/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.IRCode;
import com.phidget22.IRCodeEvent;
import com.phidget22.IRCodeInfo;
import com.phidget22.IRCodeListener;
import com.phidget22.IRLearnEvent;
import com.phidget22.IRLearnListener;
import com.phidget22.IRLearnedCode;
import com.phidget22.IRRawDataEvent;
import com.phidget22.IRRawDataListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IRBase
extends Phidget {
    private List<IRCodeListener> codeListeners = new ArrayList<IRCodeListener>();
    private long nativeCodeHandler = 0L;
    private List<IRLearnListener> learnListeners = new ArrayList<IRLearnListener>();
    private long nativeLearnHandler = 0L;
    private List<IRRawDataListener> rawDataListeners = new ArrayList<IRRawDataListener>();
    private long nativeRawDataHandler = 0L;
    public static final int RAW_DATA_LONG_SPACE = -1;
    public static final int MAX_CODE_BIT_COUNT = 128;
    public static final int MAX_CODE_STRING_LENGTH = 33;

    IRBase(long l) {
        super(l);
    }

    public IRBase() throws PhidgetException {
        super(IRBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableCodeEvents(bl && this.codeListeners.size() > 0);
        this.enableLearnEvents(bl && this.learnListeners.size() > 0);
        this.enableRawDataEvents(bl && this.rawDataListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCodeListener(IRCodeListener iRCodeListener) {
        List<IRCodeListener> list = this.codeListeners;
        synchronized (list) {
            this.codeListeners.add(iRCodeListener);
            this.enableCodeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCodeListener(IRCodeListener iRCodeListener) {
        List<IRCodeListener> list = this.codeListeners;
        synchronized (list) {
            this.codeListeners.remove(iRCodeListener);
            this.enableCodeEvents(this.codeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCode(IRCodeEvent iRCodeEvent) {
        List<IRCodeListener> list = this.codeListeners;
        synchronized (list) {
            Iterator<IRCodeListener> iterator = this.codeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCode(iRCodeEvent);
            }
        }
    }

    private native void enableCodeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLearnListener(IRLearnListener iRLearnListener) {
        List<IRLearnListener> list = this.learnListeners;
        synchronized (list) {
            this.learnListeners.add(iRLearnListener);
            this.enableLearnEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLearnListener(IRLearnListener iRLearnListener) {
        List<IRLearnListener> list = this.learnListeners;
        synchronized (list) {
            this.learnListeners.remove(iRLearnListener);
            this.enableLearnEvents(this.learnListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLearn(IRLearnEvent iRLearnEvent) {
        List<IRLearnListener> list = this.learnListeners;
        synchronized (list) {
            Iterator<IRLearnListener> iterator = this.learnListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onLearn(iRLearnEvent);
            }
        }
    }

    private native void enableLearnEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRawDataListener(IRRawDataListener iRRawDataListener) {
        List<IRRawDataListener> list = this.rawDataListeners;
        synchronized (list) {
            this.rawDataListeners.add(iRRawDataListener);
            this.enableRawDataEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRawDataListener(IRRawDataListener iRRawDataListener) {
        List<IRRawDataListener> list = this.rawDataListeners;
        synchronized (list) {
            this.rawDataListeners.remove(iRRawDataListener);
            this.enableRawDataEvents(this.rawDataListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRawData(IRRawDataEvent iRRawDataEvent) {
        List<IRRawDataListener> list = this.rawDataListeners;
        synchronized (list) {
            Iterator<IRRawDataListener> iterator = this.rawDataListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onRawData(iRRawDataEvent);
            }
        }
    }

    private native void enableRawDataEvents(boolean var1);

    public native IRCode getLastCode() throws PhidgetException;

    public native IRLearnedCode getLastLearnedCode() throws PhidgetException;

    public native void transmit(String var1, IRCodeInfo var2) throws PhidgetException;

    public native void transmitRaw(int[] var1, int var2, double var3, int var5) throws PhidgetException;

    public native void transmitRepeat() throws PhidgetException;
}

