/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.AsyncListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import com.phidget22.RCServoPositionChangeEvent;
import com.phidget22.RCServoPositionChangeListener;
import com.phidget22.RCServoTargetPositionReachedEvent;
import com.phidget22.RCServoTargetPositionReachedListener;
import com.phidget22.RCServoVelocityChangeEvent;
import com.phidget22.RCServoVelocityChangeListener;
import com.phidget22.RCServoVoltage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RCServoBase
extends Phidget {
    private List<RCServoPositionChangeListener> positionChangeListeners = new ArrayList<RCServoPositionChangeListener>();
    private long nativePositionChangeHandler = 0L;
    private List<RCServoTargetPositionReachedListener> targetPositionReachedListeners = new ArrayList<RCServoTargetPositionReachedListener>();
    private long nativeTargetPositionReachedHandler = 0L;
    private List<RCServoVelocityChangeListener> velocityChangeListeners = new ArrayList<RCServoVelocityChangeListener>();
    private long nativeVelocityChangeHandler = 0L;

    RCServoBase(long l) {
        super(l);
    }

    public RCServoBase() throws PhidgetException {
        super(RCServoBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enablePositionChangeEvents(bl && this.positionChangeListeners.size() > 0);
        this.enableTargetPositionReachedEvents(bl && this.targetPositionReachedListeners.size() > 0);
        this.enableVelocityChangeEvents(bl && this.velocityChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionChangeListener(RCServoPositionChangeListener rCServoPositionChangeListener) {
        List<RCServoPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.add(rCServoPositionChangeListener);
            this.enablePositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionChangeListener(RCServoPositionChangeListener rCServoPositionChangeListener) {
        List<RCServoPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.remove(rCServoPositionChangeListener);
            this.enablePositionChangeEvents(this.positionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionChange(RCServoPositionChangeEvent rCServoPositionChangeEvent) {
        List<RCServoPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            Iterator<RCServoPositionChangeListener> iterator = this.positionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionChange(rCServoPositionChangeEvent);
            }
        }
    }

    private native void enablePositionChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTargetPositionReachedListener(RCServoTargetPositionReachedListener rCServoTargetPositionReachedListener) {
        List<RCServoTargetPositionReachedListener> list = this.targetPositionReachedListeners;
        synchronized (list) {
            this.targetPositionReachedListeners.add(rCServoTargetPositionReachedListener);
            this.enableTargetPositionReachedEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTargetPositionReachedListener(RCServoTargetPositionReachedListener rCServoTargetPositionReachedListener) {
        List<RCServoTargetPositionReachedListener> list = this.targetPositionReachedListeners;
        synchronized (list) {
            this.targetPositionReachedListeners.remove(rCServoTargetPositionReachedListener);
            this.enableTargetPositionReachedEvents(this.targetPositionReachedListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTargetPositionReached(RCServoTargetPositionReachedEvent rCServoTargetPositionReachedEvent) {
        List<RCServoTargetPositionReachedListener> list = this.targetPositionReachedListeners;
        synchronized (list) {
            Iterator<RCServoTargetPositionReachedListener> iterator = this.targetPositionReachedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onTargetPositionReached(rCServoTargetPositionReachedEvent);
            }
        }
    }

    private native void enableTargetPositionReachedEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVelocityChangeListener(RCServoVelocityChangeListener rCServoVelocityChangeListener) {
        List<RCServoVelocityChangeListener> list = this.velocityChangeListeners;
        synchronized (list) {
            this.velocityChangeListeners.add(rCServoVelocityChangeListener);
            this.enableVelocityChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVelocityChangeListener(RCServoVelocityChangeListener rCServoVelocityChangeListener) {
        List<RCServoVelocityChangeListener> list = this.velocityChangeListeners;
        synchronized (list) {
            this.velocityChangeListeners.remove(rCServoVelocityChangeListener);
            this.enableVelocityChangeEvents(this.velocityChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVelocityChange(RCServoVelocityChangeEvent rCServoVelocityChangeEvent) {
        List<RCServoVelocityChangeListener> list = this.velocityChangeListeners;
        synchronized (list) {
            Iterator<RCServoVelocityChangeListener> iterator = this.velocityChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onVelocityChange(rCServoVelocityChangeEvent);
            }
        }
    }

    private native void enableVelocityChangeEvents(boolean var1);

    public native double getAcceleration() throws PhidgetException;

    public native void setAcceleration(double var1) throws PhidgetException;

    public native double getMinAcceleration() throws PhidgetException;

    public native double getMaxAcceleration() throws PhidgetException;

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native boolean getEngaged() throws PhidgetException;

    public native void setEngaged(boolean var1) throws PhidgetException;

    public native boolean getIsMoving() throws PhidgetException;

    public native double getPosition() throws PhidgetException;

    public native double getMinPosition() throws PhidgetException;

    public native void setMinPosition(double var1) throws PhidgetException;

    public native void setMaxPosition(double var1) throws PhidgetException;

    public native double getMaxPosition() throws PhidgetException;

    public native void setMinPulseWidth(double var1) throws PhidgetException;

    public native double getMinPulseWidth() throws PhidgetException;

    public native void setMaxPulseWidth(double var1) throws PhidgetException;

    public native double getMaxPulseWidth() throws PhidgetException;

    public native double getMinPulseWidthLimit() throws PhidgetException;

    public native double getMaxPulseWidthLimit() throws PhidgetException;

    public native boolean getSpeedRampingState() throws PhidgetException;

    public native void setSpeedRampingState(boolean var1) throws PhidgetException;

    public native double getTargetPosition() throws PhidgetException;

    public native void setTargetPosition(double var1) throws PhidgetException;

    public native void setTargetPosition(double var1, AsyncListener var3);

    public native double getTorque() throws PhidgetException;

    public native void setTorque(double var1) throws PhidgetException;

    public native double getMinTorque() throws PhidgetException;

    public native double getMaxTorque() throws PhidgetException;

    public native double getVelocity() throws PhidgetException;

    public native double getVelocityLimit() throws PhidgetException;

    public native void setVelocityLimit(double var1) throws PhidgetException;

    public native double getMinVelocityLimit() throws PhidgetException;

    public native double getMaxVelocityLimit() throws PhidgetException;

    public native RCServoVoltage getVoltage() throws PhidgetException;

    public native void setVoltage(RCServoVoltage var1) throws PhidgetException;
}

