/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.DCMotorBackEMFChangeEvent;
import com.phidget22.DCMotorBackEMFChangeListener;
import com.phidget22.DCMotorBrakingStrengthChangeEvent;
import com.phidget22.DCMotorBrakingStrengthChangeListener;
import com.phidget22.DCMotorVelocityUpdateEvent;
import com.phidget22.DCMotorVelocityUpdateListener;
import com.phidget22.FanMode;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DCMotorBase
extends Phidget {
    private List<DCMotorBackEMFChangeListener> backEMFChangeListeners = new ArrayList<DCMotorBackEMFChangeListener>();
    private long nativeBackEMFChangeHandler = 0L;
    private List<DCMotorBrakingStrengthChangeListener> brakingStrengthChangeListeners = new ArrayList<DCMotorBrakingStrengthChangeListener>();
    private long nativeBrakingStrengthChangeHandler = 0L;
    private List<DCMotorVelocityUpdateListener> velocityUpdateListeners = new ArrayList<DCMotorVelocityUpdateListener>();
    private long nativeVelocityUpdateHandler = 0L;

    DCMotorBase(long l) {
        super(l);
    }

    public DCMotorBase() throws PhidgetException {
        super(DCMotorBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableBackEMFChangeEvents(bl && this.backEMFChangeListeners.size() > 0);
        this.enableBrakingStrengthChangeEvents(bl && this.brakingStrengthChangeListeners.size() > 0);
        this.enableVelocityUpdateEvents(bl && this.velocityUpdateListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBackEMFChangeListener(DCMotorBackEMFChangeListener dCMotorBackEMFChangeListener) {
        List<DCMotorBackEMFChangeListener> list = this.backEMFChangeListeners;
        synchronized (list) {
            this.backEMFChangeListeners.add(dCMotorBackEMFChangeListener);
            this.enableBackEMFChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBackEMFChangeListener(DCMotorBackEMFChangeListener dCMotorBackEMFChangeListener) {
        List<DCMotorBackEMFChangeListener> list = this.backEMFChangeListeners;
        synchronized (list) {
            this.backEMFChangeListeners.remove(dCMotorBackEMFChangeListener);
            this.enableBackEMFChangeEvents(this.backEMFChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBackEMFChange(DCMotorBackEMFChangeEvent dCMotorBackEMFChangeEvent) {
        List<DCMotorBackEMFChangeListener> list = this.backEMFChangeListeners;
        synchronized (list) {
            Iterator<DCMotorBackEMFChangeListener> iterator = this.backEMFChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onBackEMFChange(dCMotorBackEMFChangeEvent);
            }
        }
    }

    private native void enableBackEMFChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBrakingStrengthChangeListener(DCMotorBrakingStrengthChangeListener dCMotorBrakingStrengthChangeListener) {
        List<DCMotorBrakingStrengthChangeListener> list = this.brakingStrengthChangeListeners;
        synchronized (list) {
            this.brakingStrengthChangeListeners.add(dCMotorBrakingStrengthChangeListener);
            this.enableBrakingStrengthChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBrakingStrengthChangeListener(DCMotorBrakingStrengthChangeListener dCMotorBrakingStrengthChangeListener) {
        List<DCMotorBrakingStrengthChangeListener> list = this.brakingStrengthChangeListeners;
        synchronized (list) {
            this.brakingStrengthChangeListeners.remove(dCMotorBrakingStrengthChangeListener);
            this.enableBrakingStrengthChangeEvents(this.brakingStrengthChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBrakingStrengthChange(DCMotorBrakingStrengthChangeEvent dCMotorBrakingStrengthChangeEvent) {
        List<DCMotorBrakingStrengthChangeListener> list = this.brakingStrengthChangeListeners;
        synchronized (list) {
            Iterator<DCMotorBrakingStrengthChangeListener> iterator = this.brakingStrengthChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onBrakingStrengthChange(dCMotorBrakingStrengthChangeEvent);
            }
        }
    }

    private native void enableBrakingStrengthChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVelocityUpdateListener(DCMotorVelocityUpdateListener dCMotorVelocityUpdateListener) {
        List<DCMotorVelocityUpdateListener> list = this.velocityUpdateListeners;
        synchronized (list) {
            this.velocityUpdateListeners.add(dCMotorVelocityUpdateListener);
            this.enableVelocityUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVelocityUpdateListener(DCMotorVelocityUpdateListener dCMotorVelocityUpdateListener) {
        List<DCMotorVelocityUpdateListener> list = this.velocityUpdateListeners;
        synchronized (list) {
            this.velocityUpdateListeners.remove(dCMotorVelocityUpdateListener);
            this.enableVelocityUpdateEvents(this.velocityUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVelocityUpdate(DCMotorVelocityUpdateEvent dCMotorVelocityUpdateEvent) {
        List<DCMotorVelocityUpdateListener> list = this.velocityUpdateListeners;
        synchronized (list) {
            Iterator<DCMotorVelocityUpdateListener> iterator = this.velocityUpdateListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onVelocityUpdate(dCMotorVelocityUpdateEvent);
            }
        }
    }

    private native void enableVelocityUpdateEvents(boolean var1);

    public native double getAcceleration() throws PhidgetException;

    public native void setAcceleration(double var1) throws PhidgetException;

    public native double getMinAcceleration() throws PhidgetException;

    public native double getMaxAcceleration() throws PhidgetException;

    public native double getBackEMF() throws PhidgetException;

    public native boolean getBackEMFSensingState() throws PhidgetException;

    public native void setBackEMFSensingState(boolean var1) throws PhidgetException;

    public native double getBrakingStrength() throws PhidgetException;

    public native double getMinBrakingStrength() throws PhidgetException;

    public native double getMaxBrakingStrength() throws PhidgetException;

    public native double getCurrentLimit() throws PhidgetException;

    public native void setCurrentLimit(double var1) throws PhidgetException;

    public native double getMinCurrentLimit() throws PhidgetException;

    public native double getMaxCurrentLimit() throws PhidgetException;

    public native double getCurrentRegulatorGain() throws PhidgetException;

    public native void setCurrentRegulatorGain(double var1) throws PhidgetException;

    public native double getMinCurrentRegulatorGain() throws PhidgetException;

    public native double getMaxCurrentRegulatorGain() throws PhidgetException;

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native FanMode getFanMode() throws PhidgetException;

    public native void setFanMode(FanMode var1) throws PhidgetException;

    public native double getTargetBrakingStrength() throws PhidgetException;

    public native void setTargetBrakingStrength(double var1) throws PhidgetException;

    public native double getTargetVelocity() throws PhidgetException;

    public native void setTargetVelocity(double var1) throws PhidgetException;

    public native double getVelocity() throws PhidgetException;

    public native double getMinVelocity() throws PhidgetException;

    public native double getMaxVelocity() throws PhidgetException;
}

