/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

public enum HandshakeMode {
    NONE(1){

        @Override
        public String getMessage() {
            return "RTS is never set, and CTS is ignored.";
        }
    }
    ,
    REQUEST_TO_SEND(2){

        @Override
        public String getMessage() {
            return "RTS Pin requests to transmit data. CTS input confirms we can send data.";
        }
    }
    ,
    READY_TO_RECEIVE(3){

        @Override
        public String getMessage() {
            return "RTS signals this device can receive data. CTS confirms we can send data.";
        }
    };

    private final int code;

    public static HandshakeMode getEnum(int n) {
        switch (n) {
            case 1: {
                return NONE;
            }
            case 2: {
                return REQUEST_TO_SEND;
            }
            case 3: {
                return READY_TO_RECEIVE;
            }
        }
        return null;
    }

    private HandshakeMode(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public abstract String getMessage();
}

