/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.EncoderIOMode;
import com.phidget22.EncoderPositionChangeEvent;
import com.phidget22.EncoderPositionChangeListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EncoderBase
extends Phidget {
    private List<EncoderPositionChangeListener> positionChangeListeners = new ArrayList<EncoderPositionChangeListener>();
    private long nativePositionChangeHandler = 0L;

    EncoderBase(long l) {
        super(l);
    }

    public EncoderBase() throws PhidgetException {
        super(EncoderBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enablePositionChangeEvents(bl && this.positionChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionChangeListener(EncoderPositionChangeListener encoderPositionChangeListener) {
        List<EncoderPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.add(encoderPositionChangeListener);
            this.enablePositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionChangeListener(EncoderPositionChangeListener encoderPositionChangeListener) {
        List<EncoderPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.remove(encoderPositionChangeListener);
            this.enablePositionChangeEvents(this.positionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionChange(EncoderPositionChangeEvent encoderPositionChangeEvent) {
        List<EncoderPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            Iterator<EncoderPositionChangeListener> iterator = this.positionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionChange(encoderPositionChangeEvent);
            }
        }
    }

    private native void enablePositionChangeEvents(boolean var1);

    public native void setEnabled(boolean var1) throws PhidgetException;

    public native boolean getEnabled() throws PhidgetException;

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native long getIndexPosition() throws PhidgetException;

    public native EncoderIOMode getIOMode() throws PhidgetException;

    public native void setIOMode(EncoderIOMode var1) throws PhidgetException;

    public native long getPosition() throws PhidgetException;

    public native void setPosition(long var1) throws PhidgetException;

    public native int getPositionChangeTrigger() throws PhidgetException;

    public native void setPositionChangeTrigger(int var1) throws PhidgetException;

    public native int getMinPositionChangeTrigger() throws PhidgetException;

    public native int getMaxPositionChangeTrigger() throws PhidgetException;
}

