/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.AsyncListener;
import com.phidget22.EncoderIOMode;
import com.phidget22.FanMode;
import com.phidget22.MotorPositionControllerDutyCycleUpdateEvent;
import com.phidget22.MotorPositionControllerDutyCycleUpdateListener;
import com.phidget22.MotorPositionControllerExpectedPositionChangeEvent;
import com.phidget22.MotorPositionControllerExpectedPositionChangeListener;
import com.phidget22.MotorPositionControllerPositionChangeEvent;
import com.phidget22.MotorPositionControllerPositionChangeListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import com.phidget22.PositionType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MotorPositionControllerBase
extends Phidget {
    private List<MotorPositionControllerDutyCycleUpdateListener> dutyCycleUpdateListeners = new ArrayList<MotorPositionControllerDutyCycleUpdateListener>();
    private long nativeDutyCycleUpdateHandler = 0L;
    private List<MotorPositionControllerExpectedPositionChangeListener> expectedPositionChangeListeners = new ArrayList<MotorPositionControllerExpectedPositionChangeListener>();
    private long nativeExpectedPositionChangeHandler = 0L;
    private List<MotorPositionControllerPositionChangeListener> positionChangeListeners = new ArrayList<MotorPositionControllerPositionChangeListener>();
    private long nativePositionChangeHandler = 0L;

    MotorPositionControllerBase(long l) {
        super(l);
    }

    public MotorPositionControllerBase() throws PhidgetException {
        super(MotorPositionControllerBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableDutyCycleUpdateEvents(bl && this.dutyCycleUpdateListeners.size() > 0);
        this.enableExpectedPositionChangeEvents(bl && this.expectedPositionChangeListeners.size() > 0);
        this.enablePositionChangeEvents(bl && this.positionChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDutyCycleUpdateListener(MotorPositionControllerDutyCycleUpdateListener motorPositionControllerDutyCycleUpdateListener) {
        List<MotorPositionControllerDutyCycleUpdateListener> list = this.dutyCycleUpdateListeners;
        synchronized (list) {
            this.dutyCycleUpdateListeners.add(motorPositionControllerDutyCycleUpdateListener);
            this.enableDutyCycleUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDutyCycleUpdateListener(MotorPositionControllerDutyCycleUpdateListener motorPositionControllerDutyCycleUpdateListener) {
        List<MotorPositionControllerDutyCycleUpdateListener> list = this.dutyCycleUpdateListeners;
        synchronized (list) {
            this.dutyCycleUpdateListeners.remove(motorPositionControllerDutyCycleUpdateListener);
            this.enableDutyCycleUpdateEvents(this.dutyCycleUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDutyCycleUpdate(MotorPositionControllerDutyCycleUpdateEvent motorPositionControllerDutyCycleUpdateEvent) {
        List<MotorPositionControllerDutyCycleUpdateListener> list = this.dutyCycleUpdateListeners;
        synchronized (list) {
            Iterator<MotorPositionControllerDutyCycleUpdateListener> iterator = this.dutyCycleUpdateListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDutyCycleUpdate(motorPositionControllerDutyCycleUpdateEvent);
            }
        }
    }

    private native void enableDutyCycleUpdateEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addExpectedPositionChangeListener(MotorPositionControllerExpectedPositionChangeListener motorPositionControllerExpectedPositionChangeListener) {
        List<MotorPositionControllerExpectedPositionChangeListener> list = this.expectedPositionChangeListeners;
        synchronized (list) {
            this.expectedPositionChangeListeners.add(motorPositionControllerExpectedPositionChangeListener);
            this.enableExpectedPositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeExpectedPositionChangeListener(MotorPositionControllerExpectedPositionChangeListener motorPositionControllerExpectedPositionChangeListener) {
        List<MotorPositionControllerExpectedPositionChangeListener> list = this.expectedPositionChangeListeners;
        synchronized (list) {
            this.expectedPositionChangeListeners.remove(motorPositionControllerExpectedPositionChangeListener);
            this.enableExpectedPositionChangeEvents(this.expectedPositionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireExpectedPositionChange(MotorPositionControllerExpectedPositionChangeEvent motorPositionControllerExpectedPositionChangeEvent) {
        List<MotorPositionControllerExpectedPositionChangeListener> list = this.expectedPositionChangeListeners;
        synchronized (list) {
            Iterator<MotorPositionControllerExpectedPositionChangeListener> iterator = this.expectedPositionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onExpectedPositionChange(motorPositionControllerExpectedPositionChangeEvent);
            }
        }
    }

    private native void enableExpectedPositionChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionChangeListener(MotorPositionControllerPositionChangeListener motorPositionControllerPositionChangeListener) {
        List<MotorPositionControllerPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.add(motorPositionControllerPositionChangeListener);
            this.enablePositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionChangeListener(MotorPositionControllerPositionChangeListener motorPositionControllerPositionChangeListener) {
        List<MotorPositionControllerPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.remove(motorPositionControllerPositionChangeListener);
            this.enablePositionChangeEvents(this.positionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionChange(MotorPositionControllerPositionChangeEvent motorPositionControllerPositionChangeEvent) {
        List<MotorPositionControllerPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            Iterator<MotorPositionControllerPositionChangeListener> iterator = this.positionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionChange(motorPositionControllerPositionChangeEvent);
            }
        }
    }

    private native void enablePositionChangeEvents(boolean var1);

    public native double getAcceleration() throws PhidgetException;

    public native void setAcceleration(double var1) throws PhidgetException;

    public native double getMinAcceleration() throws PhidgetException;

    public native double getMaxAcceleration() throws PhidgetException;

    public native double getActiveCurrentLimit() throws PhidgetException;

    public native double getCurrentLimit() throws PhidgetException;

    public native void setCurrentLimit(double var1) throws PhidgetException;

    public native double getMinCurrentLimit() throws PhidgetException;

    public native double getMaxCurrentLimit() throws PhidgetException;

    public native double getCurrentRegulatorGain() throws PhidgetException;

    public native void setCurrentRegulatorGain(double var1) throws PhidgetException;

    public native double getMinCurrentRegulatorGain() throws PhidgetException;

    public native double getMaxCurrentRegulatorGain() throws PhidgetException;

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native double getDataRate() throws PhidgetException;

    public native void setDataRate(double var1) throws PhidgetException;

    public native double getMinDataRate() throws PhidgetException;

    public native double getMaxDataRate() throws PhidgetException;

    public native double getDeadBand() throws PhidgetException;

    public native void setDeadBand(double var1) throws PhidgetException;

    public native double getDutyCycle() throws PhidgetException;

    public native boolean getEngaged() throws PhidgetException;

    public native void setEngaged(boolean var1) throws PhidgetException;

    public native double getExpectedPosition() throws PhidgetException;

    public native boolean getEnableExpectedPosition() throws PhidgetException;

    public native void setEnableExpectedPosition(boolean var1) throws PhidgetException;

    public native void enableFailsafe(int var1) throws PhidgetException;

    public native boolean getFailsafeBrakingEnabled() throws PhidgetException;

    public native void setFailsafeBrakingEnabled(boolean var1) throws PhidgetException;

    public native double getFailsafeCurrentLimit() throws PhidgetException;

    public native void setFailsafeCurrentLimit(double var1) throws PhidgetException;

    public native int getMinFailsafeTime() throws PhidgetException;

    public native int getMaxFailsafeTime() throws PhidgetException;

    public native FanMode getFanMode() throws PhidgetException;

    public native void setFanMode(FanMode var1) throws PhidgetException;

    public native double getInductance() throws PhidgetException;

    public native void setInductance(double var1) throws PhidgetException;

    public native double getMinInductance() throws PhidgetException;

    public native double getMaxInductance() throws PhidgetException;

    public native EncoderIOMode getIOMode() throws PhidgetException;

    public native void setIOMode(EncoderIOMode var1) throws PhidgetException;

    public native double getKd() throws PhidgetException;

    public native void setKd(double var1) throws PhidgetException;

    public native double getKi() throws PhidgetException;

    public native void setKi(double var1) throws PhidgetException;

    public native double getKp() throws PhidgetException;

    public native void setKp(double var1) throws PhidgetException;

    public native boolean getNormalizePID() throws PhidgetException;

    public native void setNormalizePID(boolean var1) throws PhidgetException;

    public native double getPosition() throws PhidgetException;

    public native double getMinPosition() throws PhidgetException;

    public native double getMaxPosition() throws PhidgetException;

    public native void addPositionOffset(double var1) throws PhidgetException;

    public native PositionType getPositionType() throws PhidgetException;

    public native void setPositionType(PositionType var1) throws PhidgetException;

    public native double getRescaleFactor() throws PhidgetException;

    public native void setRescaleFactor(double var1) throws PhidgetException;

    public native void resetFailsafe() throws PhidgetException;

    public native double getStallVelocity() throws PhidgetException;

    public native void setStallVelocity(double var1) throws PhidgetException;

    public native double getMinStallVelocity() throws PhidgetException;

    public native double getMaxStallVelocity() throws PhidgetException;

    public native double getSurgeCurrentLimit() throws PhidgetException;

    public native void setSurgeCurrentLimit(double var1) throws PhidgetException;

    public native double getMinSurgeCurrentLimit() throws PhidgetException;

    public native double getMaxSurgeCurrentLimit() throws PhidgetException;

    public native double getTargetPosition() throws PhidgetException;

    public native void setTargetPosition(double var1, AsyncListener var3);

    public native void setTargetPosition(double var1) throws PhidgetException;

    public native double getVelocityLimit() throws PhidgetException;

    public native void setVelocityLimit(double var1) throws PhidgetException;

    public native double getMinVelocityLimit() throws PhidgetException;

    public native double getMaxVelocityLimit() throws PhidgetException;
}

