/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

public enum LEDArrayProtocol {
    RGB(1){

        @Override
        public String getMessage() {
            return "Byte order RGB (WS2811)";
        }
    }
    ,
    GRB(2){

        @Override
        public String getMessage() {
            return "Byte order GRB (WS2812B, SK6812)";
        }
    }
    ,
    RGBW(3){

        @Override
        public String getMessage() {
            return "Byte order RGBW";
        }
    }
    ,
    GRBW(4){

        @Override
        public String getMessage() {
            return "Byte order GRBW (SK6812RGBW)";
        }
    };

    private final int code;

    public static LEDArrayProtocol getEnum(int n) {
        switch (n) {
            case 1: {
                return RGB;
            }
            case 2: {
                return GRB;
            }
            case 3: {
                return RGBW;
            }
            case 4: {
                return GRBW;
            }
        }
        return null;
    }

    private LEDArrayProtocol(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public abstract String getMessage();
}

