#
# Be sure to run `pod lib lint Phidget22Swift.podspec' to ensure this is a
# valid spec before submitting.
#
# Any lines starting with a # are optional, but their use is encouraged
# To learn more about a Podspec see http://guides.cocoapods.org/syntax/podspec.html
#

Pod::Spec.new do |s|
  s.name             = 'Phidget22Swift'
  s.version          = '1.24.0'
  s.summary          = 'Phidget22 Swift Library'
  s.description      = 'Phidget22 Swift library'
  s.homepage         = 'https://www.phidgets.com'
  s.license          = { :type => 'MIT', :file => 'LICENSE' }
  s.author           = { 'phidgets' => 'patrick@phidgets.com' }
  s.source           = { :http => 'https://www.phidgets.com/downloads/phidget22/libraries/any/Phidget22Swift.zip' }
  
  s.swift_versions	 = [ '3.2', '4.0', '4.2', '5.0' ]
  s.ios.deployment_target = '12.0'
  s.macos.deployment_target = '10.11'
  
  s.source_files = 'src/**/*', 'libphidget22/phidget22.h', 'libphidget22/phidget22private.h'
  
  s.ios.vendored_libraries = 'libphidget22/libphidget22.a'
  s.ios.library = 'phidget22'
  
  s.macos.vendored_frameworks = 'libphidget22/Phidget22.framework'
  s.macos.framework = 'Phidget22'
  
  s.preserve_paths = 'libphidget22/phidget22.h', 'libphidget22/phidget22private.h', 'libphidget22/module.modulemap'
  s.private_header_files = 'libphidget22/phidget22.h', 'libphidget22/phidget22private.h'
  s.xcconfig = { 'HEADER_SEARCH_PATHS' => '${PODS_ROOT}/#{s.name}/libphidget22/**', 'SWIFT_INCLUDE_PATHS' => '${PODS_TARGET_SRCROOT}/libphidget22/** ${PODS_ROOT}/#{s.name}/libphidget22/**' }

  # NOTE: This is requires because something is broken adding arm64 for iphonesimulator sdk - Apple will probably fix at some point
  s.pod_target_xcconfig = { 'EXCLUDED_ARCHS[sdk=iphonesimulator*]' => 'arm64' }
  s.user_target_xcconfig = { 'EXCLUDED_ARCHS[sdk=iphonesimulator*]' => 'arm64' }
end
