//
//  ViewController.swift
//  Phidget22Swift
//
//  Created by phidgets on 01/24/2018.
//  Copyright (c) 2018 phidgets. All rights reserved.
//

import UIKit
import Phidget22Swift

class ViewController: UIViewController {

	@IBOutlet weak var txt: UITextView!
	
	override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
		
		txt.text = try! Phidget22Swift.Phidget.getLibraryVersion()
		
		
		let ch = Accelerometer()
		do {
			try Log.enable(level: .info, destination: nil)
			try Net.enableServerDiscovery(serverType: .deviceRemote)
			try ch.open(timeout: Phidget.defaultTimeout)

			let acceleration = try ch.getAcceleration()
			print("Acceleration: \(acceleration)")

			try ch.close()
		} catch let err as PhidgetError {
			print (err)
		} catch let err {
			print (err)
		}


    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

}

