/*!
 * Phidget22 JavaScript Library v3.24.1 (https://phidgets.com)
 *  phidget22 release 1.24.20260127
 * Copyright 2017-2026 Phidgets Inc.
 * Licensed under ISC
 */
var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

var es_aggregateError = {};

var es_aggregateError_constructor = {};

var globalThis_1;
var hasRequiredGlobalThis;
function requireGlobalThis () {
	if (hasRequiredGlobalThis) return globalThis_1;
	hasRequiredGlobalThis = 1;
	var check = function (it) {
	  return it && it.Math === Math && it;
	};
	globalThis_1 =
	  check(typeof globalThis == 'object' && globalThis) ||
	  check(typeof window == 'object' && window) ||
	  check(typeof self == 'object' && self) ||
	  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
	  check(typeof globalThis_1 == 'object' && globalThis_1) ||
	  (function () { return this; })() || Function('return this')();
	return globalThis_1;
}

var fails;
var hasRequiredFails;
function requireFails () {
	if (hasRequiredFails) return fails;
	hasRequiredFails = 1;
	fails = function (exec) {
	  try {
	    return !!exec();
	  } catch (error) {
	    return true;
	  }
	};
	return fails;
}

var functionBindNative;
var hasRequiredFunctionBindNative;
function requireFunctionBindNative () {
	if (hasRequiredFunctionBindNative) return functionBindNative;
	hasRequiredFunctionBindNative = 1;
	var fails =  requireFails();
	functionBindNative = !fails(function () {
	  var test = (function () {  }).bind();
	  return typeof test != 'function' || test.hasOwnProperty('prototype');
	});
	return functionBindNative;
}

var functionApply;
var hasRequiredFunctionApply;
function requireFunctionApply () {
	if (hasRequiredFunctionApply) return functionApply;
	hasRequiredFunctionApply = 1;
	var NATIVE_BIND =  requireFunctionBindNative();
	var FunctionPrototype = Function.prototype;
	var apply = FunctionPrototype.apply;
	var call = FunctionPrototype.call;
	functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
	  return call.apply(apply, arguments);
	});
	return functionApply;
}

var functionUncurryThis;
var hasRequiredFunctionUncurryThis;
function requireFunctionUncurryThis () {
	if (hasRequiredFunctionUncurryThis) return functionUncurryThis;
	hasRequiredFunctionUncurryThis = 1;
	var NATIVE_BIND =  requireFunctionBindNative();
	var FunctionPrototype = Function.prototype;
	var call = FunctionPrototype.call;
	var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);
	functionUncurryThis = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
	  return function () {
	    return call.apply(fn, arguments);
	  };
	};
	return functionUncurryThis;
}

var classofRaw;
var hasRequiredClassofRaw;
function requireClassofRaw () {
	if (hasRequiredClassofRaw) return classofRaw;
	hasRequiredClassofRaw = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var toString = uncurryThis({}.toString);
	var stringSlice = uncurryThis(''.slice);
	classofRaw = function (it) {
	  return stringSlice(toString(it), 8, -1);
	};
	return classofRaw;
}

var functionUncurryThisClause;
var hasRequiredFunctionUncurryThisClause;
function requireFunctionUncurryThisClause () {
	if (hasRequiredFunctionUncurryThisClause) return functionUncurryThisClause;
	hasRequiredFunctionUncurryThisClause = 1;
	var classofRaw =  requireClassofRaw();
	var uncurryThis =  requireFunctionUncurryThis();
	functionUncurryThisClause = function (fn) {
	  if (classofRaw(fn) === 'Function') return uncurryThis(fn);
	};
	return functionUncurryThisClause;
}

var isCallable;
var hasRequiredIsCallable;
function requireIsCallable () {
	if (hasRequiredIsCallable) return isCallable;
	hasRequiredIsCallable = 1;
	var documentAll = typeof document == 'object' && document.all;
	isCallable = typeof documentAll == 'undefined' && documentAll !== undefined ? function (argument) {
	  return typeof argument == 'function' || argument === documentAll;
	} : function (argument) {
	  return typeof argument == 'function';
	};
	return isCallable;
}

var objectGetOwnPropertyDescriptor = {};

var descriptors;
var hasRequiredDescriptors;
function requireDescriptors () {
	if (hasRequiredDescriptors) return descriptors;
	hasRequiredDescriptors = 1;
	var fails =  requireFails();
	descriptors = !fails(function () {
	  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] !== 7;
	});
	return descriptors;
}

var functionCall;
var hasRequiredFunctionCall;
function requireFunctionCall () {
	if (hasRequiredFunctionCall) return functionCall;
	hasRequiredFunctionCall = 1;
	var NATIVE_BIND =  requireFunctionBindNative();
	var call = Function.prototype.call;
	functionCall = NATIVE_BIND ? call.bind(call) : function () {
	  return call.apply(call, arguments);
	};
	return functionCall;
}

var objectPropertyIsEnumerable = {};

var hasRequiredObjectPropertyIsEnumerable;
function requireObjectPropertyIsEnumerable () {
	if (hasRequiredObjectPropertyIsEnumerable) return objectPropertyIsEnumerable;
	hasRequiredObjectPropertyIsEnumerable = 1;
	var $propertyIsEnumerable = {}.propertyIsEnumerable;
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
	var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);
	objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
	  var descriptor = getOwnPropertyDescriptor(this, V);
	  return !!descriptor && descriptor.enumerable;
	} : $propertyIsEnumerable;
	return objectPropertyIsEnumerable;
}

var createPropertyDescriptor;
var hasRequiredCreatePropertyDescriptor;
function requireCreatePropertyDescriptor () {
	if (hasRequiredCreatePropertyDescriptor) return createPropertyDescriptor;
	hasRequiredCreatePropertyDescriptor = 1;
	createPropertyDescriptor = function (bitmap, value) {
	  return {
	    enumerable: !(bitmap & 1),
	    configurable: !(bitmap & 2),
	    writable: !(bitmap & 4),
	    value: value
	  };
	};
	return createPropertyDescriptor;
}

var indexedObject;
var hasRequiredIndexedObject;
function requireIndexedObject () {
	if (hasRequiredIndexedObject) return indexedObject;
	hasRequiredIndexedObject = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var fails =  requireFails();
	var classof =  requireClassofRaw();
	var $Object = Object;
	var split = uncurryThis(''.split);
	indexedObject = fails(function () {
	  return !$Object('z').propertyIsEnumerable(0);
	}) ? function (it) {
	  return classof(it) === 'String' ? split(it, '') : $Object(it);
	} : $Object;
	return indexedObject;
}

var isNullOrUndefined;
var hasRequiredIsNullOrUndefined;
function requireIsNullOrUndefined () {
	if (hasRequiredIsNullOrUndefined) return isNullOrUndefined;
	hasRequiredIsNullOrUndefined = 1;
	isNullOrUndefined = function (it) {
	  return it === null || it === undefined;
	};
	return isNullOrUndefined;
}

var requireObjectCoercible;
var hasRequiredRequireObjectCoercible;
function requireRequireObjectCoercible () {
	if (hasRequiredRequireObjectCoercible) return requireObjectCoercible;
	hasRequiredRequireObjectCoercible = 1;
	var isNullOrUndefined =  requireIsNullOrUndefined();
	var $TypeError = TypeError;
	requireObjectCoercible = function (it) {
	  if (isNullOrUndefined(it)) throw new $TypeError("Can't call method on " + it);
	  return it;
	};
	return requireObjectCoercible;
}

var toIndexedObject;
var hasRequiredToIndexedObject;
function requireToIndexedObject () {
	if (hasRequiredToIndexedObject) return toIndexedObject;
	hasRequiredToIndexedObject = 1;
	var IndexedObject =  requireIndexedObject();
	var requireObjectCoercible =  requireRequireObjectCoercible();
	toIndexedObject = function (it) {
	  return IndexedObject(requireObjectCoercible(it));
	};
	return toIndexedObject;
}

var isObject;
var hasRequiredIsObject;
function requireIsObject () {
	if (hasRequiredIsObject) return isObject;
	hasRequiredIsObject = 1;
	var isCallable =  requireIsCallable();
	isObject = function (it) {
	  return typeof it == 'object' ? it !== null : isCallable(it);
	};
	return isObject;
}

var path;
var hasRequiredPath;
function requirePath () {
	if (hasRequiredPath) return path;
	hasRequiredPath = 1;
	path = {};
	return path;
}

var getBuiltIn;
var hasRequiredGetBuiltIn;
function requireGetBuiltIn () {
	if (hasRequiredGetBuiltIn) return getBuiltIn;
	hasRequiredGetBuiltIn = 1;
	var path =  requirePath();
	var globalThis =  requireGlobalThis();
	var isCallable =  requireIsCallable();
	var aFunction = function (variable) {
	  return isCallable(variable) ? variable : undefined;
	};
	getBuiltIn = function (namespace, method) {
	  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(globalThis[namespace])
	    : path[namespace] && path[namespace][method] || globalThis[namespace] && globalThis[namespace][method];
	};
	return getBuiltIn;
}

var objectIsPrototypeOf;
var hasRequiredObjectIsPrototypeOf;
function requireObjectIsPrototypeOf () {
	if (hasRequiredObjectIsPrototypeOf) return objectIsPrototypeOf;
	hasRequiredObjectIsPrototypeOf = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	objectIsPrototypeOf = uncurryThis({}.isPrototypeOf);
	return objectIsPrototypeOf;
}

var environmentUserAgent;
var hasRequiredEnvironmentUserAgent;
function requireEnvironmentUserAgent () {
	if (hasRequiredEnvironmentUserAgent) return environmentUserAgent;
	hasRequiredEnvironmentUserAgent = 1;
	var globalThis =  requireGlobalThis();
	var navigator = globalThis.navigator;
	var userAgent = navigator && navigator.userAgent;
	environmentUserAgent = userAgent ? String(userAgent) : '';
	return environmentUserAgent;
}

var environmentV8Version;
var hasRequiredEnvironmentV8Version;
function requireEnvironmentV8Version () {
	if (hasRequiredEnvironmentV8Version) return environmentV8Version;
	hasRequiredEnvironmentV8Version = 1;
	var globalThis =  requireGlobalThis();
	var userAgent =  requireEnvironmentUserAgent();
	var process = globalThis.process;
	var Deno = globalThis.Deno;
	var versions = process && process.versions || Deno && Deno.version;
	var v8 = versions && versions.v8;
	var match, version;
	if (v8) {
	  match = v8.split('.');
	  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
	}
	if (!version && userAgent) {
	  match = userAgent.match(/Edge\/(\d+)/);
	  if (!match || match[1] >= 74) {
	    match = userAgent.match(/Chrome\/(\d+)/);
	    if (match) version = +match[1];
	  }
	}
	environmentV8Version = version;
	return environmentV8Version;
}

var symbolConstructorDetection;
var hasRequiredSymbolConstructorDetection;
function requireSymbolConstructorDetection () {
	if (hasRequiredSymbolConstructorDetection) return symbolConstructorDetection;
	hasRequiredSymbolConstructorDetection = 1;
	var V8_VERSION =  requireEnvironmentV8Version();
	var fails =  requireFails();
	var globalThis =  requireGlobalThis();
	var $String = globalThis.String;
	symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails(function () {
	  var symbol = Symbol('symbol detection');
	  return !$String(symbol) || !(Object(symbol) instanceof Symbol) ||
	    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
	});
	return symbolConstructorDetection;
}

var useSymbolAsUid;
var hasRequiredUseSymbolAsUid;
function requireUseSymbolAsUid () {
	if (hasRequiredUseSymbolAsUid) return useSymbolAsUid;
	hasRequiredUseSymbolAsUid = 1;
	var NATIVE_SYMBOL =  requireSymbolConstructorDetection();
	useSymbolAsUid = NATIVE_SYMBOL &&
	  !Symbol.sham &&
	  typeof Symbol.iterator == 'symbol';
	return useSymbolAsUid;
}

var isSymbol;
var hasRequiredIsSymbol;
function requireIsSymbol () {
	if (hasRequiredIsSymbol) return isSymbol;
	hasRequiredIsSymbol = 1;
	var getBuiltIn =  requireGetBuiltIn();
	var isCallable =  requireIsCallable();
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var USE_SYMBOL_AS_UID =  requireUseSymbolAsUid();
	var $Object = Object;
	isSymbol = USE_SYMBOL_AS_UID ? function (it) {
	  return typeof it == 'symbol';
	} : function (it) {
	  var $Symbol = getBuiltIn('Symbol');
	  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
	};
	return isSymbol;
}

var tryToString;
var hasRequiredTryToString;
function requireTryToString () {
	if (hasRequiredTryToString) return tryToString;
	hasRequiredTryToString = 1;
	var $String = String;
	tryToString = function (argument) {
	  try {
	    return $String(argument);
	  } catch (error) {
	    return 'Object';
	  }
	};
	return tryToString;
}

var aCallable;
var hasRequiredACallable;
function requireACallable () {
	if (hasRequiredACallable) return aCallable;
	hasRequiredACallable = 1;
	var isCallable =  requireIsCallable();
	var tryToString =  requireTryToString();
	var $TypeError = TypeError;
	aCallable = function (argument) {
	  if (isCallable(argument)) return argument;
	  throw new $TypeError(tryToString(argument) + ' is not a function');
	};
	return aCallable;
}

var getMethod;
var hasRequiredGetMethod;
function requireGetMethod () {
	if (hasRequiredGetMethod) return getMethod;
	hasRequiredGetMethod = 1;
	var aCallable =  requireACallable();
	var isNullOrUndefined =  requireIsNullOrUndefined();
	getMethod = function (V, P) {
	  var func = V[P];
	  return isNullOrUndefined(func) ? undefined : aCallable(func);
	};
	return getMethod;
}

var ordinaryToPrimitive;
var hasRequiredOrdinaryToPrimitive;
function requireOrdinaryToPrimitive () {
	if (hasRequiredOrdinaryToPrimitive) return ordinaryToPrimitive;
	hasRequiredOrdinaryToPrimitive = 1;
	var call =  requireFunctionCall();
	var isCallable =  requireIsCallable();
	var isObject =  requireIsObject();
	var $TypeError = TypeError;
	ordinaryToPrimitive = function (input, pref) {
	  var fn, val;
	  if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
	  if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input))) return val;
	  if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
	  throw new $TypeError("Can't convert object to primitive value");
	};
	return ordinaryToPrimitive;
}

var sharedStore = {exports: {}};

var isPure;
var hasRequiredIsPure;
function requireIsPure () {
	if (hasRequiredIsPure) return isPure;
	hasRequiredIsPure = 1;
	isPure = true;
	return isPure;
}

var defineGlobalProperty;
var hasRequiredDefineGlobalProperty;
function requireDefineGlobalProperty () {
	if (hasRequiredDefineGlobalProperty) return defineGlobalProperty;
	hasRequiredDefineGlobalProperty = 1;
	var globalThis =  requireGlobalThis();
	var defineProperty = Object.defineProperty;
	defineGlobalProperty = function (key, value) {
	  try {
	    defineProperty(globalThis, key, { value: value, configurable: true, writable: true });
	  } catch (error) {
	    globalThis[key] = value;
	  } return value;
	};
	return defineGlobalProperty;
}

var hasRequiredSharedStore;
function requireSharedStore () {
	if (hasRequiredSharedStore) return sharedStore.exports;
	hasRequiredSharedStore = 1;
	var IS_PURE =  requireIsPure();
	var globalThis =  requireGlobalThis();
	var defineGlobalProperty =  requireDefineGlobalProperty();
	var SHARED = '__core-js_shared__';
	var store = sharedStore.exports = globalThis[SHARED] || defineGlobalProperty(SHARED, {});
	(store.versions || (store.versions = [])).push({
	  version: '3.43.0',
	  mode: IS_PURE ? 'pure' : 'global',
	  copyright: '© 2014-2025 Denis Pushkarev (zloirock.ru)',
	  license: 'https://github.com/zloirock/core-js/blob/v3.43.0/LICENSE',
	  source: 'https://github.com/zloirock/core-js'
	});
	return sharedStore.exports;
}

var shared;
var hasRequiredShared;
function requireShared () {
	if (hasRequiredShared) return shared;
	hasRequiredShared = 1;
	var store =  requireSharedStore();
	shared = function (key, value) {
	  return store[key] || (store[key] = value || {});
	};
	return shared;
}

var toObject;
var hasRequiredToObject;
function requireToObject () {
	if (hasRequiredToObject) return toObject;
	hasRequiredToObject = 1;
	var requireObjectCoercible =  requireRequireObjectCoercible();
	var $Object = Object;
	toObject = function (argument) {
	  return $Object(requireObjectCoercible(argument));
	};
	return toObject;
}

var hasOwnProperty_1;
var hasRequiredHasOwnProperty;
function requireHasOwnProperty () {
	if (hasRequiredHasOwnProperty) return hasOwnProperty_1;
	hasRequiredHasOwnProperty = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var toObject =  requireToObject();
	var hasOwnProperty = uncurryThis({}.hasOwnProperty);
	hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
	  return hasOwnProperty(toObject(it), key);
	};
	return hasOwnProperty_1;
}

var uid;
var hasRequiredUid;
function requireUid () {
	if (hasRequiredUid) return uid;
	hasRequiredUid = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var id = 0;
	var postfix = Math.random();
	var toString = uncurryThis(1.1.toString);
	uid = function (key) {
	  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
	};
	return uid;
}

var wellKnownSymbol;
var hasRequiredWellKnownSymbol;
function requireWellKnownSymbol () {
	if (hasRequiredWellKnownSymbol) return wellKnownSymbol;
	hasRequiredWellKnownSymbol = 1;
	var globalThis =  requireGlobalThis();
	var shared =  requireShared();
	var hasOwn =  requireHasOwnProperty();
	var uid =  requireUid();
	var NATIVE_SYMBOL =  requireSymbolConstructorDetection();
	var USE_SYMBOL_AS_UID =  requireUseSymbolAsUid();
	var Symbol = globalThis.Symbol;
	var WellKnownSymbolsStore = shared('wks');
	var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol['for'] || Symbol : Symbol && Symbol.withoutSetter || uid;
	wellKnownSymbol = function (name) {
	  if (!hasOwn(WellKnownSymbolsStore, name)) {
	    WellKnownSymbolsStore[name] = NATIVE_SYMBOL && hasOwn(Symbol, name)
	      ? Symbol[name]
	      : createWellKnownSymbol('Symbol.' + name);
	  } return WellKnownSymbolsStore[name];
	};
	return wellKnownSymbol;
}

var toPrimitive;
var hasRequiredToPrimitive;
function requireToPrimitive () {
	if (hasRequiredToPrimitive) return toPrimitive;
	hasRequiredToPrimitive = 1;
	var call =  requireFunctionCall();
	var isObject =  requireIsObject();
	var isSymbol =  requireIsSymbol();
	var getMethod =  requireGetMethod();
	var ordinaryToPrimitive =  requireOrdinaryToPrimitive();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var $TypeError = TypeError;
	var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');
	toPrimitive = function (input, pref) {
	  if (!isObject(input) || isSymbol(input)) return input;
	  var exoticToPrim = getMethod(input, TO_PRIMITIVE);
	  var result;
	  if (exoticToPrim) {
	    if (pref === undefined) pref = 'default';
	    result = call(exoticToPrim, input, pref);
	    if (!isObject(result) || isSymbol(result)) return result;
	    throw new $TypeError("Can't convert object to primitive value");
	  }
	  if (pref === undefined) pref = 'number';
	  return ordinaryToPrimitive(input, pref);
	};
	return toPrimitive;
}

var toPropertyKey;
var hasRequiredToPropertyKey;
function requireToPropertyKey () {
	if (hasRequiredToPropertyKey) return toPropertyKey;
	hasRequiredToPropertyKey = 1;
	var toPrimitive =  requireToPrimitive();
	var isSymbol =  requireIsSymbol();
	toPropertyKey = function (argument) {
	  var key = toPrimitive(argument, 'string');
	  return isSymbol(key) ? key : key + '';
	};
	return toPropertyKey;
}

var documentCreateElement;
var hasRequiredDocumentCreateElement;
function requireDocumentCreateElement () {
	if (hasRequiredDocumentCreateElement) return documentCreateElement;
	hasRequiredDocumentCreateElement = 1;
	var globalThis =  requireGlobalThis();
	var isObject =  requireIsObject();
	var document = globalThis.document;
	var EXISTS = isObject(document) && isObject(document.createElement);
	documentCreateElement = function (it) {
	  return EXISTS ? document.createElement(it) : {};
	};
	return documentCreateElement;
}

var ie8DomDefine;
var hasRequiredIe8DomDefine;
function requireIe8DomDefine () {
	if (hasRequiredIe8DomDefine) return ie8DomDefine;
	hasRequiredIe8DomDefine = 1;
	var DESCRIPTORS =  requireDescriptors();
	var fails =  requireFails();
	var createElement =  requireDocumentCreateElement();
	ie8DomDefine = !DESCRIPTORS && !fails(function () {
	  return Object.defineProperty(createElement('div'), 'a', {
	    get: function () { return 7; }
	  }).a !== 7;
	});
	return ie8DomDefine;
}

var hasRequiredObjectGetOwnPropertyDescriptor;
function requireObjectGetOwnPropertyDescriptor () {
	if (hasRequiredObjectGetOwnPropertyDescriptor) return objectGetOwnPropertyDescriptor;
	hasRequiredObjectGetOwnPropertyDescriptor = 1;
	var DESCRIPTORS =  requireDescriptors();
	var call =  requireFunctionCall();
	var propertyIsEnumerableModule =  requireObjectPropertyIsEnumerable();
	var createPropertyDescriptor =  requireCreatePropertyDescriptor();
	var toIndexedObject =  requireToIndexedObject();
	var toPropertyKey =  requireToPropertyKey();
	var hasOwn =  requireHasOwnProperty();
	var IE8_DOM_DEFINE =  requireIe8DomDefine();
	var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
	objectGetOwnPropertyDescriptor.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
	  O = toIndexedObject(O);
	  P = toPropertyKey(P);
	  if (IE8_DOM_DEFINE) try {
	    return $getOwnPropertyDescriptor(O, P);
	  } catch (error) {  }
	  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
	};
	return objectGetOwnPropertyDescriptor;
}

var isForced_1;
var hasRequiredIsForced;
function requireIsForced () {
	if (hasRequiredIsForced) return isForced_1;
	hasRequiredIsForced = 1;
	var fails =  requireFails();
	var isCallable =  requireIsCallable();
	var replacement = /#|\.prototype\./;
	var isForced = function (feature, detection) {
	  var value = data[normalize(feature)];
	  return value === POLYFILL ? true
	    : value === NATIVE ? false
	    : isCallable(detection) ? fails(detection)
	    : !!detection;
	};
	var normalize = isForced.normalize = function (string) {
	  return String(string).replace(replacement, '.').toLowerCase();
	};
	var data = isForced.data = {};
	var NATIVE = isForced.NATIVE = 'N';
	var POLYFILL = isForced.POLYFILL = 'P';
	isForced_1 = isForced;
	return isForced_1;
}

var functionBindContext;
var hasRequiredFunctionBindContext;
function requireFunctionBindContext () {
	if (hasRequiredFunctionBindContext) return functionBindContext;
	hasRequiredFunctionBindContext = 1;
	var uncurryThis =  requireFunctionUncurryThisClause();
	var aCallable =  requireACallable();
	var NATIVE_BIND =  requireFunctionBindNative();
	var bind = uncurryThis(uncurryThis.bind);
	functionBindContext = function (fn, that) {
	  aCallable(fn);
	  return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function () {
	    return fn.apply(that, arguments);
	  };
	};
	return functionBindContext;
}

var objectDefineProperty = {};

var v8PrototypeDefineBug;
var hasRequiredV8PrototypeDefineBug;
function requireV8PrototypeDefineBug () {
	if (hasRequiredV8PrototypeDefineBug) return v8PrototypeDefineBug;
	hasRequiredV8PrototypeDefineBug = 1;
	var DESCRIPTORS =  requireDescriptors();
	var fails =  requireFails();
	v8PrototypeDefineBug = DESCRIPTORS && fails(function () {
	  return Object.defineProperty(function () {  }, 'prototype', {
	    value: 42,
	    writable: false
	  }).prototype !== 42;
	});
	return v8PrototypeDefineBug;
}

var anObject;
var hasRequiredAnObject;
function requireAnObject () {
	if (hasRequiredAnObject) return anObject;
	hasRequiredAnObject = 1;
	var isObject =  requireIsObject();
	var $String = String;
	var $TypeError = TypeError;
	anObject = function (argument) {
	  if (isObject(argument)) return argument;
	  throw new $TypeError($String(argument) + ' is not an object');
	};
	return anObject;
}

var hasRequiredObjectDefineProperty;
function requireObjectDefineProperty () {
	if (hasRequiredObjectDefineProperty) return objectDefineProperty;
	hasRequiredObjectDefineProperty = 1;
	var DESCRIPTORS =  requireDescriptors();
	var IE8_DOM_DEFINE =  requireIe8DomDefine();
	var V8_PROTOTYPE_DEFINE_BUG =  requireV8PrototypeDefineBug();
	var anObject =  requireAnObject();
	var toPropertyKey =  requireToPropertyKey();
	var $TypeError = TypeError;
	var $defineProperty = Object.defineProperty;
	var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
	var ENUMERABLE = 'enumerable';
	var CONFIGURABLE = 'configurable';
	var WRITABLE = 'writable';
	objectDefineProperty.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
	  anObject(O);
	  P = toPropertyKey(P);
	  anObject(Attributes);
	  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
	    var current = $getOwnPropertyDescriptor(O, P);
	    if (current && current[WRITABLE]) {
	      O[P] = Attributes.value;
	      Attributes = {
	        configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
	        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
	        writable: false
	      };
	    }
	  } return $defineProperty(O, P, Attributes);
	} : $defineProperty : function defineProperty(O, P, Attributes) {
	  anObject(O);
	  P = toPropertyKey(P);
	  anObject(Attributes);
	  if (IE8_DOM_DEFINE) try {
	    return $defineProperty(O, P, Attributes);
	  } catch (error) {  }
	  if ('get' in Attributes || 'set' in Attributes) throw new $TypeError('Accessors not supported');
	  if ('value' in Attributes) O[P] = Attributes.value;
	  return O;
	};
	return objectDefineProperty;
}

var createNonEnumerableProperty;
var hasRequiredCreateNonEnumerableProperty;
function requireCreateNonEnumerableProperty () {
	if (hasRequiredCreateNonEnumerableProperty) return createNonEnumerableProperty;
	hasRequiredCreateNonEnumerableProperty = 1;
	var DESCRIPTORS =  requireDescriptors();
	var definePropertyModule =  requireObjectDefineProperty();
	var createPropertyDescriptor =  requireCreatePropertyDescriptor();
	createNonEnumerableProperty = DESCRIPTORS ? function (object, key, value) {
	  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
	} : function (object, key, value) {
	  object[key] = value;
	  return object;
	};
	return createNonEnumerableProperty;
}

var _export;
var hasRequired_export;
function require_export () {
	if (hasRequired_export) return _export;
	hasRequired_export = 1;
	var globalThis =  requireGlobalThis();
	var apply =  requireFunctionApply();
	var uncurryThis =  requireFunctionUncurryThisClause();
	var isCallable =  requireIsCallable();
	var getOwnPropertyDescriptor =  requireObjectGetOwnPropertyDescriptor().f;
	var isForced =  requireIsForced();
	var path =  requirePath();
	var bind =  requireFunctionBindContext();
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	var hasOwn =  requireHasOwnProperty();
	 requireSharedStore();
	var wrapConstructor = function (NativeConstructor) {
	  var Wrapper = function (a, b, c) {
	    if (this instanceof Wrapper) {
	      switch (arguments.length) {
	        case 0: return new NativeConstructor();
	        case 1: return new NativeConstructor(a);
	        case 2: return new NativeConstructor(a, b);
	      } return new NativeConstructor(a, b, c);
	    } return apply(NativeConstructor, this, arguments);
	  };
	  Wrapper.prototype = NativeConstructor.prototype;
	  return Wrapper;
	};
	_export = function (options, source) {
	  var TARGET = options.target;
	  var GLOBAL = options.global;
	  var STATIC = options.stat;
	  var PROTO = options.proto;
	  var nativeSource = GLOBAL ? globalThis : STATIC ? globalThis[TARGET] : globalThis[TARGET] && globalThis[TARGET].prototype;
	  var target = GLOBAL ? path : path[TARGET] || createNonEnumerableProperty(path, TARGET, {})[TARGET];
	  var targetPrototype = target.prototype;
	  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
	  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;
	  for (key in source) {
	    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
	    USE_NATIVE = !FORCED && nativeSource && hasOwn(nativeSource, key);
	    targetProperty = target[key];
	    if (USE_NATIVE) if (options.dontCallGetSet) {
	      descriptor = getOwnPropertyDescriptor(nativeSource, key);
	      nativeProperty = descriptor && descriptor.value;
	    } else nativeProperty = nativeSource[key];
	    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];
	    if (!FORCED && !PROTO && typeof targetProperty == typeof sourceProperty) continue;
	    if (options.bind && USE_NATIVE) resultProperty = bind(sourceProperty, globalThis);
	    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
	    else if (PROTO && isCallable(sourceProperty)) resultProperty = uncurryThis(sourceProperty);
	    else resultProperty = sourceProperty;
	    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
	      createNonEnumerableProperty(resultProperty, 'sham', true);
	    }
	    createNonEnumerableProperty(target, key, resultProperty);
	    if (PROTO) {
	      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
	      if (!hasOwn(path, VIRTUAL_PROTOTYPE)) {
	        createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
	      }
	      createNonEnumerableProperty(path[VIRTUAL_PROTOTYPE], key, sourceProperty);
	      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
	        createNonEnumerableProperty(targetPrototype, key, sourceProperty);
	      }
	    }
	  }
	};
	return _export;
}

var sharedKey;
var hasRequiredSharedKey;
function requireSharedKey () {
	if (hasRequiredSharedKey) return sharedKey;
	hasRequiredSharedKey = 1;
	var shared =  requireShared();
	var uid =  requireUid();
	var keys = shared('keys');
	sharedKey = function (key) {
	  return keys[key] || (keys[key] = uid(key));
	};
	return sharedKey;
}

var correctPrototypeGetter;
var hasRequiredCorrectPrototypeGetter;
function requireCorrectPrototypeGetter () {
	if (hasRequiredCorrectPrototypeGetter) return correctPrototypeGetter;
	hasRequiredCorrectPrototypeGetter = 1;
	var fails =  requireFails();
	correctPrototypeGetter = !fails(function () {
	  function F() {  }
	  F.prototype.constructor = null;
	  return Object.getPrototypeOf(new F()) !== F.prototype;
	});
	return correctPrototypeGetter;
}

var objectGetPrototypeOf;
var hasRequiredObjectGetPrototypeOf;
function requireObjectGetPrototypeOf () {
	if (hasRequiredObjectGetPrototypeOf) return objectGetPrototypeOf;
	hasRequiredObjectGetPrototypeOf = 1;
	var hasOwn =  requireHasOwnProperty();
	var isCallable =  requireIsCallable();
	var toObject =  requireToObject();
	var sharedKey =  requireSharedKey();
	var CORRECT_PROTOTYPE_GETTER =  requireCorrectPrototypeGetter();
	var IE_PROTO = sharedKey('IE_PROTO');
	var $Object = Object;
	var ObjectPrototype = $Object.prototype;
	objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
	  var object = toObject(O);
	  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
	  var constructor = object.constructor;
	  if (isCallable(constructor) && object instanceof constructor) {
	    return constructor.prototype;
	  } return object instanceof $Object ? ObjectPrototype : null;
	};
	return objectGetPrototypeOf;
}

var functionUncurryThisAccessor;
var hasRequiredFunctionUncurryThisAccessor;
function requireFunctionUncurryThisAccessor () {
	if (hasRequiredFunctionUncurryThisAccessor) return functionUncurryThisAccessor;
	hasRequiredFunctionUncurryThisAccessor = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var aCallable =  requireACallable();
	functionUncurryThisAccessor = function (object, key, method) {
	  try {
	    return uncurryThis(aCallable(Object.getOwnPropertyDescriptor(object, key)[method]));
	  } catch (error) {  }
	};
	return functionUncurryThisAccessor;
}

var isPossiblePrototype;
var hasRequiredIsPossiblePrototype;
function requireIsPossiblePrototype () {
	if (hasRequiredIsPossiblePrototype) return isPossiblePrototype;
	hasRequiredIsPossiblePrototype = 1;
	var isObject =  requireIsObject();
	isPossiblePrototype = function (argument) {
	  return isObject(argument) || argument === null;
	};
	return isPossiblePrototype;
}

var aPossiblePrototype;
var hasRequiredAPossiblePrototype;
function requireAPossiblePrototype () {
	if (hasRequiredAPossiblePrototype) return aPossiblePrototype;
	hasRequiredAPossiblePrototype = 1;
	var isPossiblePrototype =  requireIsPossiblePrototype();
	var $String = String;
	var $TypeError = TypeError;
	aPossiblePrototype = function (argument) {
	  if (isPossiblePrototype(argument)) return argument;
	  throw new $TypeError("Can't set " + $String(argument) + ' as a prototype');
	};
	return aPossiblePrototype;
}

var objectSetPrototypeOf;
var hasRequiredObjectSetPrototypeOf;
function requireObjectSetPrototypeOf () {
	if (hasRequiredObjectSetPrototypeOf) return objectSetPrototypeOf;
	hasRequiredObjectSetPrototypeOf = 1;
	var uncurryThisAccessor =  requireFunctionUncurryThisAccessor();
	var isObject =  requireIsObject();
	var requireObjectCoercible =  requireRequireObjectCoercible();
	var aPossiblePrototype =  requireAPossiblePrototype();
	objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
	  var CORRECT_SETTER = false;
	  var test = {};
	  var setter;
	  try {
	    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
	    setter(test, []);
	    CORRECT_SETTER = test instanceof Array;
	  } catch (error) {  }
	  return function setPrototypeOf(O, proto) {
	    requireObjectCoercible(O);
	    aPossiblePrototype(proto);
	    if (!isObject(O)) return O;
	    if (CORRECT_SETTER) setter(O, proto);
	    else O.__proto__ = proto;
	    return O;
	  };
	}() : undefined);
	return objectSetPrototypeOf;
}

var objectGetOwnPropertyNames = {};

var mathTrunc;
var hasRequiredMathTrunc;
function requireMathTrunc () {
	if (hasRequiredMathTrunc) return mathTrunc;
	hasRequiredMathTrunc = 1;
	var ceil = Math.ceil;
	var floor = Math.floor;
	mathTrunc = Math.trunc || function trunc(x) {
	  var n = +x;
	  return (n > 0 ? floor : ceil)(n);
	};
	return mathTrunc;
}

var toIntegerOrInfinity;
var hasRequiredToIntegerOrInfinity;
function requireToIntegerOrInfinity () {
	if (hasRequiredToIntegerOrInfinity) return toIntegerOrInfinity;
	hasRequiredToIntegerOrInfinity = 1;
	var trunc =  requireMathTrunc();
	toIntegerOrInfinity = function (argument) {
	  var number = +argument;
	  return number !== number || number === 0 ? 0 : trunc(number);
	};
	return toIntegerOrInfinity;
}

var toAbsoluteIndex;
var hasRequiredToAbsoluteIndex;
function requireToAbsoluteIndex () {
	if (hasRequiredToAbsoluteIndex) return toAbsoluteIndex;
	hasRequiredToAbsoluteIndex = 1;
	var toIntegerOrInfinity =  requireToIntegerOrInfinity();
	var max = Math.max;
	var min = Math.min;
	toAbsoluteIndex = function (index, length) {
	  var integer = toIntegerOrInfinity(index);
	  return integer < 0 ? max(integer + length, 0) : min(integer, length);
	};
	return toAbsoluteIndex;
}

var toLength;
var hasRequiredToLength;
function requireToLength () {
	if (hasRequiredToLength) return toLength;
	hasRequiredToLength = 1;
	var toIntegerOrInfinity =  requireToIntegerOrInfinity();
	var min = Math.min;
	toLength = function (argument) {
	  var len = toIntegerOrInfinity(argument);
	  return len > 0 ? min(len, 0x1FFFFFFFFFFFFF) : 0;
	};
	return toLength;
}

var lengthOfArrayLike;
var hasRequiredLengthOfArrayLike;
function requireLengthOfArrayLike () {
	if (hasRequiredLengthOfArrayLike) return lengthOfArrayLike;
	hasRequiredLengthOfArrayLike = 1;
	var toLength =  requireToLength();
	lengthOfArrayLike = function (obj) {
	  return toLength(obj.length);
	};
	return lengthOfArrayLike;
}

var arrayIncludes;
var hasRequiredArrayIncludes;
function requireArrayIncludes () {
	if (hasRequiredArrayIncludes) return arrayIncludes;
	hasRequiredArrayIncludes = 1;
	var toIndexedObject =  requireToIndexedObject();
	var toAbsoluteIndex =  requireToAbsoluteIndex();
	var lengthOfArrayLike =  requireLengthOfArrayLike();
	var createMethod = function (IS_INCLUDES) {
	  return function ($this, el, fromIndex) {
	    var O = toIndexedObject($this);
	    var length = lengthOfArrayLike(O);
	    if (length === 0) return !IS_INCLUDES && -1;
	    var index = toAbsoluteIndex(fromIndex, length);
	    var value;
	    if (IS_INCLUDES && el !== el) while (length > index) {
	      value = O[index++];
	      if (value !== value) return true;
	    } else for (;length > index; index++) {
	      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
	    } return !IS_INCLUDES && -1;
	  };
	};
	arrayIncludes = {
	  includes: createMethod(true),
	  indexOf: createMethod(false)
	};
	return arrayIncludes;
}

var hiddenKeys;
var hasRequiredHiddenKeys;
function requireHiddenKeys () {
	if (hasRequiredHiddenKeys) return hiddenKeys;
	hasRequiredHiddenKeys = 1;
	hiddenKeys = {};
	return hiddenKeys;
}

var objectKeysInternal;
var hasRequiredObjectKeysInternal;
function requireObjectKeysInternal () {
	if (hasRequiredObjectKeysInternal) return objectKeysInternal;
	hasRequiredObjectKeysInternal = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var hasOwn =  requireHasOwnProperty();
	var toIndexedObject =  requireToIndexedObject();
	var indexOf =  requireArrayIncludes().indexOf;
	var hiddenKeys =  requireHiddenKeys();
	var push = uncurryThis([].push);
	objectKeysInternal = function (object, names) {
	  var O = toIndexedObject(object);
	  var i = 0;
	  var result = [];
	  var key;
	  for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
	  while (names.length > i) if (hasOwn(O, key = names[i++])) {
	    ~indexOf(result, key) || push(result, key);
	  }
	  return result;
	};
	return objectKeysInternal;
}

var enumBugKeys;
var hasRequiredEnumBugKeys;
function requireEnumBugKeys () {
	if (hasRequiredEnumBugKeys) return enumBugKeys;
	hasRequiredEnumBugKeys = 1;
	enumBugKeys = [
	  'constructor',
	  'hasOwnProperty',
	  'isPrototypeOf',
	  'propertyIsEnumerable',
	  'toLocaleString',
	  'toString',
	  'valueOf'
	];
	return enumBugKeys;
}

var hasRequiredObjectGetOwnPropertyNames;
function requireObjectGetOwnPropertyNames () {
	if (hasRequiredObjectGetOwnPropertyNames) return objectGetOwnPropertyNames;
	hasRequiredObjectGetOwnPropertyNames = 1;
	var internalObjectKeys =  requireObjectKeysInternal();
	var enumBugKeys =  requireEnumBugKeys();
	var hiddenKeys = enumBugKeys.concat('length', 'prototype');
	objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
	  return internalObjectKeys(O, hiddenKeys);
	};
	return objectGetOwnPropertyNames;
}

var objectGetOwnPropertySymbols = {};

var hasRequiredObjectGetOwnPropertySymbols;
function requireObjectGetOwnPropertySymbols () {
	if (hasRequiredObjectGetOwnPropertySymbols) return objectGetOwnPropertySymbols;
	hasRequiredObjectGetOwnPropertySymbols = 1;
	objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;
	return objectGetOwnPropertySymbols;
}

var ownKeys;
var hasRequiredOwnKeys;
function requireOwnKeys () {
	if (hasRequiredOwnKeys) return ownKeys;
	hasRequiredOwnKeys = 1;
	var getBuiltIn =  requireGetBuiltIn();
	var uncurryThis =  requireFunctionUncurryThis();
	var getOwnPropertyNamesModule =  requireObjectGetOwnPropertyNames();
	var getOwnPropertySymbolsModule =  requireObjectGetOwnPropertySymbols();
	var anObject =  requireAnObject();
	var concat = uncurryThis([].concat);
	ownKeys = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
	  var keys = getOwnPropertyNamesModule.f(anObject(it));
	  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
	  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
	};
	return ownKeys;
}

var copyConstructorProperties;
var hasRequiredCopyConstructorProperties;
function requireCopyConstructorProperties () {
	if (hasRequiredCopyConstructorProperties) return copyConstructorProperties;
	hasRequiredCopyConstructorProperties = 1;
	var hasOwn =  requireHasOwnProperty();
	var ownKeys =  requireOwnKeys();
	var getOwnPropertyDescriptorModule =  requireObjectGetOwnPropertyDescriptor();
	var definePropertyModule =  requireObjectDefineProperty();
	copyConstructorProperties = function (target, source, exceptions) {
	  var keys = ownKeys(source);
	  var defineProperty = definePropertyModule.f;
	  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
	  for (var i = 0; i < keys.length; i++) {
	    var key = keys[i];
	    if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
	      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
	    }
	  }
	};
	return copyConstructorProperties;
}

var objectDefineProperties = {};

var objectKeys;
var hasRequiredObjectKeys;
function requireObjectKeys () {
	if (hasRequiredObjectKeys) return objectKeys;
	hasRequiredObjectKeys = 1;
	var internalObjectKeys =  requireObjectKeysInternal();
	var enumBugKeys =  requireEnumBugKeys();
	objectKeys = Object.keys || function keys(O) {
	  return internalObjectKeys(O, enumBugKeys);
	};
	return objectKeys;
}

var hasRequiredObjectDefineProperties;
function requireObjectDefineProperties () {
	if (hasRequiredObjectDefineProperties) return objectDefineProperties;
	hasRequiredObjectDefineProperties = 1;
	var DESCRIPTORS =  requireDescriptors();
	var V8_PROTOTYPE_DEFINE_BUG =  requireV8PrototypeDefineBug();
	var definePropertyModule =  requireObjectDefineProperty();
	var anObject =  requireAnObject();
	var toIndexedObject =  requireToIndexedObject();
	var objectKeys =  requireObjectKeys();
	objectDefineProperties.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
	  anObject(O);
	  var props = toIndexedObject(Properties);
	  var keys = objectKeys(Properties);
	  var length = keys.length;
	  var index = 0;
	  var key;
	  while (length > index) definePropertyModule.f(O, key = keys[index++], props[key]);
	  return O;
	};
	return objectDefineProperties;
}

var html;
var hasRequiredHtml;
function requireHtml () {
	if (hasRequiredHtml) return html;
	hasRequiredHtml = 1;
	var getBuiltIn =  requireGetBuiltIn();
	html = getBuiltIn('document', 'documentElement');
	return html;
}

var objectCreate;
var hasRequiredObjectCreate;
function requireObjectCreate () {
	if (hasRequiredObjectCreate) return objectCreate;
	hasRequiredObjectCreate = 1;
	var anObject =  requireAnObject();
	var definePropertiesModule =  requireObjectDefineProperties();
	var enumBugKeys =  requireEnumBugKeys();
	var hiddenKeys =  requireHiddenKeys();
	var html =  requireHtml();
	var documentCreateElement =  requireDocumentCreateElement();
	var sharedKey =  requireSharedKey();
	var GT = '>';
	var LT = '<';
	var PROTOTYPE = 'prototype';
	var SCRIPT = 'script';
	var IE_PROTO = sharedKey('IE_PROTO');
	var EmptyConstructor = function () {  };
	var scriptTag = function (content) {
	  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
	};
	var NullProtoObjectViaActiveX = function (activeXDocument) {
	  activeXDocument.write(scriptTag(''));
	  activeXDocument.close();
	  var temp = activeXDocument.parentWindow.Object;
	  activeXDocument = null;
	  return temp;
	};
	var NullProtoObjectViaIFrame = function () {
	  var iframe = documentCreateElement('iframe');
	  var JS = 'java' + SCRIPT + ':';
	  var iframeDocument;
	  iframe.style.display = 'none';
	  html.appendChild(iframe);
	  iframe.src = String(JS);
	  iframeDocument = iframe.contentWindow.document;
	  iframeDocument.open();
	  iframeDocument.write(scriptTag('document.F=Object'));
	  iframeDocument.close();
	  return iframeDocument.F;
	};
	var activeXDocument;
	var NullProtoObject = function () {
	  try {
	    activeXDocument = new ActiveXObject('htmlfile');
	  } catch (error) {  }
	  NullProtoObject = typeof document != 'undefined'
	    ? document.domain && activeXDocument
	      ? NullProtoObjectViaActiveX(activeXDocument)
	      : NullProtoObjectViaIFrame()
	    : NullProtoObjectViaActiveX(activeXDocument);
	  var length = enumBugKeys.length;
	  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
	  return NullProtoObject();
	};
	hiddenKeys[IE_PROTO] = true;
	objectCreate = Object.create || function create(O, Properties) {
	  var result;
	  if (O !== null) {
	    EmptyConstructor[PROTOTYPE] = anObject(O);
	    result = new EmptyConstructor();
	    EmptyConstructor[PROTOTYPE] = null;
	    result[IE_PROTO] = O;
	  } else result = NullProtoObject();
	  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
	};
	return objectCreate;
}

var installErrorCause;
var hasRequiredInstallErrorCause;
function requireInstallErrorCause () {
	if (hasRequiredInstallErrorCause) return installErrorCause;
	hasRequiredInstallErrorCause = 1;
	var isObject =  requireIsObject();
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	installErrorCause = function (O, options) {
	  if (isObject(options) && 'cause' in options) {
	    createNonEnumerableProperty(O, 'cause', options.cause);
	  }
	};
	return installErrorCause;
}

var errorStackClear;
var hasRequiredErrorStackClear;
function requireErrorStackClear () {
	if (hasRequiredErrorStackClear) return errorStackClear;
	hasRequiredErrorStackClear = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var $Error = Error;
	var replace = uncurryThis(''.replace);
	var TEST = (function (arg) { return String(new $Error(arg).stack); })('zxcasd');
	var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
	var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);
	errorStackClear = function (stack, dropEntries) {
	  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error.prepareStackTrace) {
	    while (dropEntries--) stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
	  } return stack;
	};
	return errorStackClear;
}

var errorStackInstallable;
var hasRequiredErrorStackInstallable;
function requireErrorStackInstallable () {
	if (hasRequiredErrorStackInstallable) return errorStackInstallable;
	hasRequiredErrorStackInstallable = 1;
	var fails =  requireFails();
	var createPropertyDescriptor =  requireCreatePropertyDescriptor();
	errorStackInstallable = !fails(function () {
	  var error = new Error('a');
	  if (!('stack' in error)) return true;
	  Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
	  return error.stack !== 7;
	});
	return errorStackInstallable;
}

var errorStackInstall;
var hasRequiredErrorStackInstall;
function requireErrorStackInstall () {
	if (hasRequiredErrorStackInstall) return errorStackInstall;
	hasRequiredErrorStackInstall = 1;
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	var clearErrorStack =  requireErrorStackClear();
	var ERROR_STACK_INSTALLABLE =  requireErrorStackInstallable();
	var captureStackTrace = Error.captureStackTrace;
	errorStackInstall = function (error, C, stack, dropEntries) {
	  if (ERROR_STACK_INSTALLABLE) {
	    if (captureStackTrace) captureStackTrace(error, C);
	    else createNonEnumerableProperty(error, 'stack', clearErrorStack(stack, dropEntries));
	  }
	};
	return errorStackInstall;
}

var iterators;
var hasRequiredIterators;
function requireIterators () {
	if (hasRequiredIterators) return iterators;
	hasRequiredIterators = 1;
	iterators = {};
	return iterators;
}

var isArrayIteratorMethod;
var hasRequiredIsArrayIteratorMethod;
function requireIsArrayIteratorMethod () {
	if (hasRequiredIsArrayIteratorMethod) return isArrayIteratorMethod;
	hasRequiredIsArrayIteratorMethod = 1;
	var wellKnownSymbol =  requireWellKnownSymbol();
	var Iterators =  requireIterators();
	var ITERATOR = wellKnownSymbol('iterator');
	var ArrayPrototype = Array.prototype;
	isArrayIteratorMethod = function (it) {
	  return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
	};
	return isArrayIteratorMethod;
}

var toStringTagSupport;
var hasRequiredToStringTagSupport;
function requireToStringTagSupport () {
	if (hasRequiredToStringTagSupport) return toStringTagSupport;
	hasRequiredToStringTagSupport = 1;
	var wellKnownSymbol =  requireWellKnownSymbol();
	var TO_STRING_TAG = wellKnownSymbol('toStringTag');
	var test = {};
	test[TO_STRING_TAG] = 'z';
	toStringTagSupport = String(test) === '[object z]';
	return toStringTagSupport;
}

var classof;
var hasRequiredClassof;
function requireClassof () {
	if (hasRequiredClassof) return classof;
	hasRequiredClassof = 1;
	var TO_STRING_TAG_SUPPORT =  requireToStringTagSupport();
	var isCallable =  requireIsCallable();
	var classofRaw =  requireClassofRaw();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var TO_STRING_TAG = wellKnownSymbol('toStringTag');
	var $Object = Object;
	var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) === 'Arguments';
	var tryGet = function (it, key) {
	  try {
	    return it[key];
	  } catch (error) {  }
	};
	classof = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
	  var O, tag, result;
	  return it === undefined ? 'Undefined' : it === null ? 'Null'
	    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
	    : CORRECT_ARGUMENTS ? classofRaw(O)
	    : (result = classofRaw(O)) === 'Object' && isCallable(O.callee) ? 'Arguments' : result;
	};
	return classof;
}

var getIteratorMethod;
var hasRequiredGetIteratorMethod;
function requireGetIteratorMethod () {
	if (hasRequiredGetIteratorMethod) return getIteratorMethod;
	hasRequiredGetIteratorMethod = 1;
	var classof =  requireClassof();
	var getMethod =  requireGetMethod();
	var isNullOrUndefined =  requireIsNullOrUndefined();
	var Iterators =  requireIterators();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var ITERATOR = wellKnownSymbol('iterator');
	getIteratorMethod = function (it) {
	  if (!isNullOrUndefined(it)) return getMethod(it, ITERATOR)
	    || getMethod(it, '@@iterator')
	    || Iterators[classof(it)];
	};
	return getIteratorMethod;
}

var getIterator;
var hasRequiredGetIterator;
function requireGetIterator () {
	if (hasRequiredGetIterator) return getIterator;
	hasRequiredGetIterator = 1;
	var call =  requireFunctionCall();
	var aCallable =  requireACallable();
	var anObject =  requireAnObject();
	var tryToString =  requireTryToString();
	var getIteratorMethod =  requireGetIteratorMethod();
	var $TypeError = TypeError;
	getIterator = function (argument, usingIterator) {
	  var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
	  if (aCallable(iteratorMethod)) return anObject(call(iteratorMethod, argument));
	  throw new $TypeError(tryToString(argument) + ' is not iterable');
	};
	return getIterator;
}

var iteratorClose;
var hasRequiredIteratorClose;
function requireIteratorClose () {
	if (hasRequiredIteratorClose) return iteratorClose;
	hasRequiredIteratorClose = 1;
	var call =  requireFunctionCall();
	var anObject =  requireAnObject();
	var getMethod =  requireGetMethod();
	iteratorClose = function (iterator, kind, value) {
	  var innerResult, innerError;
	  anObject(iterator);
	  try {
	    innerResult = getMethod(iterator, 'return');
	    if (!innerResult) {
	      if (kind === 'throw') throw value;
	      return value;
	    }
	    innerResult = call(innerResult, iterator);
	  } catch (error) {
	    innerError = true;
	    innerResult = error;
	  }
	  if (kind === 'throw') throw value;
	  if (innerError) throw innerResult;
	  anObject(innerResult);
	  return value;
	};
	return iteratorClose;
}

var iterate;
var hasRequiredIterate;
function requireIterate () {
	if (hasRequiredIterate) return iterate;
	hasRequiredIterate = 1;
	var bind =  requireFunctionBindContext();
	var call =  requireFunctionCall();
	var anObject =  requireAnObject();
	var tryToString =  requireTryToString();
	var isArrayIteratorMethod =  requireIsArrayIteratorMethod();
	var lengthOfArrayLike =  requireLengthOfArrayLike();
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var getIterator =  requireGetIterator();
	var getIteratorMethod =  requireGetIteratorMethod();
	var iteratorClose =  requireIteratorClose();
	var $TypeError = TypeError;
	var Result = function (stopped, result) {
	  this.stopped = stopped;
	  this.result = result;
	};
	var ResultPrototype = Result.prototype;
	iterate = function (iterable, unboundFunction, options) {
	  var that = options && options.that;
	  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
	  var IS_RECORD = !!(options && options.IS_RECORD);
	  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
	  var INTERRUPTED = !!(options && options.INTERRUPTED);
	  var fn = bind(unboundFunction, that);
	  var iterator, iterFn, index, length, result, next, step;
	  var stop = function (condition) {
	    if (iterator) iteratorClose(iterator, 'normal');
	    return new Result(true, condition);
	  };
	  var callFn = function (value) {
	    if (AS_ENTRIES) {
	      anObject(value);
	      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
	    } return INTERRUPTED ? fn(value, stop) : fn(value);
	  };
	  if (IS_RECORD) {
	    iterator = iterable.iterator;
	  } else if (IS_ITERATOR) {
	    iterator = iterable;
	  } else {
	    iterFn = getIteratorMethod(iterable);
	    if (!iterFn) throw new $TypeError(tryToString(iterable) + ' is not iterable');
	    if (isArrayIteratorMethod(iterFn)) {
	      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
	        result = callFn(iterable[index]);
	        if (result && isPrototypeOf(ResultPrototype, result)) return result;
	      } return new Result(false);
	    }
	    iterator = getIterator(iterable, iterFn);
	  }
	  next = IS_RECORD ? iterable.next : iterator.next;
	  while (!(step = call(next, iterator)).done) {
	    try {
	      result = callFn(step.value);
	    } catch (error) {
	      iteratorClose(iterator, 'throw', error);
	    }
	    if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
	  } return new Result(false);
	};
	return iterate;
}

var toString;
var hasRequiredToString;
function requireToString () {
	if (hasRequiredToString) return toString;
	hasRequiredToString = 1;
	var classof =  requireClassof();
	var $String = String;
	toString = function (argument) {
	  if (classof(argument) === 'Symbol') throw new TypeError('Cannot convert a Symbol value to a string');
	  return $String(argument);
	};
	return toString;
}

var normalizeStringArgument;
var hasRequiredNormalizeStringArgument;
function requireNormalizeStringArgument () {
	if (hasRequiredNormalizeStringArgument) return normalizeStringArgument;
	hasRequiredNormalizeStringArgument = 1;
	var toString =  requireToString();
	normalizeStringArgument = function (argument, $default) {
	  return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
	};
	return normalizeStringArgument;
}

var hasRequiredEs_aggregateError_constructor;
function requireEs_aggregateError_constructor () {
	if (hasRequiredEs_aggregateError_constructor) return es_aggregateError_constructor;
	hasRequiredEs_aggregateError_constructor = 1;
	var $ =  require_export();
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var getPrototypeOf =  requireObjectGetPrototypeOf();
	var setPrototypeOf =  requireObjectSetPrototypeOf();
	var copyConstructorProperties =  requireCopyConstructorProperties();
	var create =  requireObjectCreate();
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	var createPropertyDescriptor =  requireCreatePropertyDescriptor();
	var installErrorCause =  requireInstallErrorCause();
	var installErrorStack =  requireErrorStackInstall();
	var iterate =  requireIterate();
	var normalizeStringArgument =  requireNormalizeStringArgument();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var TO_STRING_TAG = wellKnownSymbol('toStringTag');
	var $Error = Error;
	var push = [].push;
	var $AggregateError = function AggregateError(errors, message ) {
	  var isInstance = isPrototypeOf(AggregateErrorPrototype, this);
	  var that;
	  if (setPrototypeOf) {
	    that = setPrototypeOf(new $Error(), isInstance ? getPrototypeOf(this) : AggregateErrorPrototype);
	  } else {
	    that = isInstance ? this : create(AggregateErrorPrototype);
	    createNonEnumerableProperty(that, TO_STRING_TAG, 'Error');
	  }
	  if (message !== undefined) createNonEnumerableProperty(that, 'message', normalizeStringArgument(message));
	  installErrorStack(that, $AggregateError, that.stack, 1);
	  if (arguments.length > 2) installErrorCause(that, arguments[2]);
	  var errorsArray = [];
	  iterate(errors, push, { that: errorsArray });
	  createNonEnumerableProperty(that, 'errors', errorsArray);
	  return that;
	};
	if (setPrototypeOf) setPrototypeOf($AggregateError, $Error);
	else copyConstructorProperties($AggregateError, $Error, { name: true });
	var AggregateErrorPrototype = $AggregateError.prototype = create($Error.prototype, {
	  constructor: createPropertyDescriptor(1, $AggregateError),
	  message: createPropertyDescriptor(1, ''),
	  name: createPropertyDescriptor(1, 'AggregateError')
	});
	$({ global: true, constructor: true, arity: 2 }, {
	  AggregateError: $AggregateError
	});
	return es_aggregateError_constructor;
}

var hasRequiredEs_aggregateError;
function requireEs_aggregateError () {
	if (hasRequiredEs_aggregateError) return es_aggregateError;
	hasRequiredEs_aggregateError = 1;
	requireEs_aggregateError_constructor();
	return es_aggregateError;
}

var addToUnscopables;
var hasRequiredAddToUnscopables;
function requireAddToUnscopables () {
	if (hasRequiredAddToUnscopables) return addToUnscopables;
	hasRequiredAddToUnscopables = 1;
	addToUnscopables = function () {  };
	return addToUnscopables;
}

var weakMapBasicDetection;
var hasRequiredWeakMapBasicDetection;
function requireWeakMapBasicDetection () {
	if (hasRequiredWeakMapBasicDetection) return weakMapBasicDetection;
	hasRequiredWeakMapBasicDetection = 1;
	var globalThis =  requireGlobalThis();
	var isCallable =  requireIsCallable();
	var WeakMap = globalThis.WeakMap;
	weakMapBasicDetection = isCallable(WeakMap) && /native code/.test(String(WeakMap));
	return weakMapBasicDetection;
}

var internalState;
var hasRequiredInternalState;
function requireInternalState () {
	if (hasRequiredInternalState) return internalState;
	hasRequiredInternalState = 1;
	var NATIVE_WEAK_MAP =  requireWeakMapBasicDetection();
	var globalThis =  requireGlobalThis();
	var isObject =  requireIsObject();
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	var hasOwn =  requireHasOwnProperty();
	var shared =  requireSharedStore();
	var sharedKey =  requireSharedKey();
	var hiddenKeys =  requireHiddenKeys();
	var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
	var TypeError = globalThis.TypeError;
	var WeakMap = globalThis.WeakMap;
	var set, get, has;
	var enforce = function (it) {
	  return has(it) ? get(it) : set(it, {});
	};
	var getterFor = function (TYPE) {
	  return function (it) {
	    var state;
	    if (!isObject(it) || (state = get(it)).type !== TYPE) {
	      throw new TypeError('Incompatible receiver, ' + TYPE + ' required');
	    } return state;
	  };
	};
	if (NATIVE_WEAK_MAP || shared.state) {
	  var store = shared.state || (shared.state = new WeakMap());
	  store.get = store.get;
	  store.has = store.has;
	  store.set = store.set;
	  set = function (it, metadata) {
	    if (store.has(it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    store.set(it, metadata);
	    return metadata;
	  };
	  get = function (it) {
	    return store.get(it) || {};
	  };
	  has = function (it) {
	    return store.has(it);
	  };
	} else {
	  var STATE = sharedKey('state');
	  hiddenKeys[STATE] = true;
	  set = function (it, metadata) {
	    if (hasOwn(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
	    metadata.facade = it;
	    createNonEnumerableProperty(it, STATE, metadata);
	    return metadata;
	  };
	  get = function (it) {
	    return hasOwn(it, STATE) ? it[STATE] : {};
	  };
	  has = function (it) {
	    return hasOwn(it, STATE);
	  };
	}
	internalState = {
	  set: set,
	  get: get,
	  has: has,
	  enforce: enforce,
	  getterFor: getterFor
	};
	return internalState;
}

var functionName;
var hasRequiredFunctionName;
function requireFunctionName () {
	if (hasRequiredFunctionName) return functionName;
	hasRequiredFunctionName = 1;
	var DESCRIPTORS =  requireDescriptors();
	var hasOwn =  requireHasOwnProperty();
	var FunctionPrototype = Function.prototype;
	var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;
	var EXISTS = hasOwn(FunctionPrototype, 'name');
	var PROPER = EXISTS && (function something() {  }).name === 'something';
	var CONFIGURABLE = EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));
	functionName = {
	  EXISTS: EXISTS,
	  PROPER: PROPER,
	  CONFIGURABLE: CONFIGURABLE
	};
	return functionName;
}

var defineBuiltIn;
var hasRequiredDefineBuiltIn;
function requireDefineBuiltIn () {
	if (hasRequiredDefineBuiltIn) return defineBuiltIn;
	hasRequiredDefineBuiltIn = 1;
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	defineBuiltIn = function (target, key, value, options) {
	  if (options && options.enumerable) target[key] = value;
	  else createNonEnumerableProperty(target, key, value);
	  return target;
	};
	return defineBuiltIn;
}

var iteratorsCore;
var hasRequiredIteratorsCore;
function requireIteratorsCore () {
	if (hasRequiredIteratorsCore) return iteratorsCore;
	hasRequiredIteratorsCore = 1;
	var fails =  requireFails();
	var isCallable =  requireIsCallable();
	var isObject =  requireIsObject();
	var create =  requireObjectCreate();
	var getPrototypeOf =  requireObjectGetPrototypeOf();
	var defineBuiltIn =  requireDefineBuiltIn();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var IS_PURE =  requireIsPure();
	var ITERATOR = wellKnownSymbol('iterator');
	var BUGGY_SAFARI_ITERATORS = false;
	var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
	if ([].keys) {
	  arrayIterator = [].keys();
	  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
	  else {
	    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
	    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
	  }
	}
	var NEW_ITERATOR_PROTOTYPE = !isObject(IteratorPrototype) || fails(function () {
	  var test = {};
	  return IteratorPrototype[ITERATOR].call(test) !== test;
	});
	if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
	else if (IS_PURE) IteratorPrototype = create(IteratorPrototype);
	if (!isCallable(IteratorPrototype[ITERATOR])) {
	  defineBuiltIn(IteratorPrototype, ITERATOR, function () {
	    return this;
	  });
	}
	iteratorsCore = {
	  IteratorPrototype: IteratorPrototype,
	  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
	};
	return iteratorsCore;
}

var objectToString;
var hasRequiredObjectToString;
function requireObjectToString () {
	if (hasRequiredObjectToString) return objectToString;
	hasRequiredObjectToString = 1;
	var TO_STRING_TAG_SUPPORT =  requireToStringTagSupport();
	var classof =  requireClassof();
	objectToString = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
	  return '[object ' + classof(this) + ']';
	};
	return objectToString;
}

var setToStringTag;
var hasRequiredSetToStringTag;
function requireSetToStringTag () {
	if (hasRequiredSetToStringTag) return setToStringTag;
	hasRequiredSetToStringTag = 1;
	var TO_STRING_TAG_SUPPORT =  requireToStringTagSupport();
	var defineProperty =  requireObjectDefineProperty().f;
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	var hasOwn =  requireHasOwnProperty();
	var toString =  requireObjectToString();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var TO_STRING_TAG = wellKnownSymbol('toStringTag');
	setToStringTag = function (it, TAG, STATIC, SET_METHOD) {
	  var target = STATIC ? it : it && it.prototype;
	  if (target) {
	    if (!hasOwn(target, TO_STRING_TAG)) {
	      defineProperty(target, TO_STRING_TAG, { configurable: true, value: TAG });
	    }
	    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
	      createNonEnumerableProperty(target, 'toString', toString);
	    }
	  }
	};
	return setToStringTag;
}

var iteratorCreateConstructor;
var hasRequiredIteratorCreateConstructor;
function requireIteratorCreateConstructor () {
	if (hasRequiredIteratorCreateConstructor) return iteratorCreateConstructor;
	hasRequiredIteratorCreateConstructor = 1;
	var IteratorPrototype =  requireIteratorsCore().IteratorPrototype;
	var create =  requireObjectCreate();
	var createPropertyDescriptor =  requireCreatePropertyDescriptor();
	var setToStringTag =  requireSetToStringTag();
	var Iterators =  requireIterators();
	var returnThis = function () { return this; };
	iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
	  var TO_STRING_TAG = NAME + ' Iterator';
	  IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
	  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
	  Iterators[TO_STRING_TAG] = returnThis;
	  return IteratorConstructor;
	};
	return iteratorCreateConstructor;
}

var iteratorDefine;
var hasRequiredIteratorDefine;
function requireIteratorDefine () {
	if (hasRequiredIteratorDefine) return iteratorDefine;
	hasRequiredIteratorDefine = 1;
	var $ =  require_export();
	var call =  requireFunctionCall();
	var IS_PURE =  requireIsPure();
	var FunctionName =  requireFunctionName();
	var isCallable =  requireIsCallable();
	var createIteratorConstructor =  requireIteratorCreateConstructor();
	var getPrototypeOf =  requireObjectGetPrototypeOf();
	var setPrototypeOf =  requireObjectSetPrototypeOf();
	var setToStringTag =  requireSetToStringTag();
	var createNonEnumerableProperty =  requireCreateNonEnumerableProperty();
	var defineBuiltIn =  requireDefineBuiltIn();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var Iterators =  requireIterators();
	var IteratorsCore =  requireIteratorsCore();
	var PROPER_FUNCTION_NAME = FunctionName.PROPER;
	var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
	var IteratorPrototype = IteratorsCore.IteratorPrototype;
	var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
	var ITERATOR = wellKnownSymbol('iterator');
	var KEYS = 'keys';
	var VALUES = 'values';
	var ENTRIES = 'entries';
	var returnThis = function () { return this; };
	iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
	  createIteratorConstructor(IteratorConstructor, NAME, next);
	  var getIterationMethod = function (KIND) {
	    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
	    if (!BUGGY_SAFARI_ITERATORS && KIND && KIND in IterablePrototype) return IterablePrototype[KIND];
	    switch (KIND) {
	      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
	      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
	      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
	    }
	    return function () { return new IteratorConstructor(this); };
	  };
	  var TO_STRING_TAG = NAME + ' Iterator';
	  var INCORRECT_VALUES_NAME = false;
	  var IterablePrototype = Iterable.prototype;
	  var nativeIterator = IterablePrototype[ITERATOR]
	    || IterablePrototype['@@iterator']
	    || DEFAULT && IterablePrototype[DEFAULT];
	  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
	  var anyNativeIterator = NAME === 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
	  var CurrentIteratorPrototype, methods, KEY;
	  if (anyNativeIterator) {
	    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
	    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
	      if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
	        if (setPrototypeOf) {
	          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
	        } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
	          defineBuiltIn(CurrentIteratorPrototype, ITERATOR, returnThis);
	        }
	      }
	      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
	      if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
	    }
	  }
	  if (PROPER_FUNCTION_NAME && DEFAULT === VALUES && nativeIterator && nativeIterator.name !== VALUES) {
	    if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
	      createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
	    } else {
	      INCORRECT_VALUES_NAME = true;
	      defaultIterator = function values() { return call(nativeIterator, this); };
	    }
	  }
	  if (DEFAULT) {
	    methods = {
	      values: getIterationMethod(VALUES),
	      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
	      entries: getIterationMethod(ENTRIES)
	    };
	    if (FORCED) for (KEY in methods) {
	      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
	        defineBuiltIn(IterablePrototype, KEY, methods[KEY]);
	      }
	    } else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
	  }
	  if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
	    defineBuiltIn(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
	  }
	  Iterators[NAME] = defaultIterator;
	  return methods;
	};
	return iteratorDefine;
}

var createIterResultObject;
var hasRequiredCreateIterResultObject;
function requireCreateIterResultObject () {
	if (hasRequiredCreateIterResultObject) return createIterResultObject;
	hasRequiredCreateIterResultObject = 1;
	createIterResultObject = function (value, done) {
	  return { value: value, done: done };
	};
	return createIterResultObject;
}

var es_array_iterator;
var hasRequiredEs_array_iterator;
function requireEs_array_iterator () {
	if (hasRequiredEs_array_iterator) return es_array_iterator;
	hasRequiredEs_array_iterator = 1;
	var toIndexedObject =  requireToIndexedObject();
	var addToUnscopables =  requireAddToUnscopables();
	var Iterators =  requireIterators();
	var InternalStateModule =  requireInternalState();
	var defineProperty =  requireObjectDefineProperty().f;
	var defineIterator =  requireIteratorDefine();
	var createIterResultObject =  requireCreateIterResultObject();
	var IS_PURE =  requireIsPure();
	var DESCRIPTORS =  requireDescriptors();
	var ARRAY_ITERATOR = 'Array Iterator';
	var setInternalState = InternalStateModule.set;
	var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);
	es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
	  setInternalState(this, {
	    type: ARRAY_ITERATOR,
	    target: toIndexedObject(iterated),
	    index: 0,
	    kind: kind
	  });
	}, function () {
	  var state = getInternalState(this);
	  var target = state.target;
	  var index = state.index++;
	  if (!target || index >= target.length) {
	    state.target = null;
	    return createIterResultObject(undefined, true);
	  }
	  switch (state.kind) {
	    case 'keys': return createIterResultObject(index, false);
	    case 'values': return createIterResultObject(target[index], false);
	  } return createIterResultObject([index, target[index]], false);
	}, 'values');
	var values = Iterators.Arguments = Iterators.Array;
	addToUnscopables('keys');
	addToUnscopables('values');
	addToUnscopables('entries');
	if (!IS_PURE && DESCRIPTORS && values.name !== 'values') try {
	  defineProperty(values, 'name', { value: 'values' });
	} catch (error) {  }
	return es_array_iterator;
}

var es_promise = {};

var es_promise_constructor = {};

var environment;
var hasRequiredEnvironment;
function requireEnvironment () {
	if (hasRequiredEnvironment) return environment;
	hasRequiredEnvironment = 1;
	var globalThis =  requireGlobalThis();
	var userAgent =  requireEnvironmentUserAgent();
	var classof =  requireClassofRaw();
	var userAgentStartsWith = function (string) {
	  return userAgent.slice(0, string.length) === string;
	};
	environment = (function () {
	  if (userAgentStartsWith('Bun/')) return 'BUN';
	  if (userAgentStartsWith('Cloudflare-Workers')) return 'CLOUDFLARE';
	  if (userAgentStartsWith('Deno/')) return 'DENO';
	  if (userAgentStartsWith('Node.js/')) return 'NODE';
	  if (globalThis.Bun && typeof Bun.version == 'string') return 'BUN';
	  if (globalThis.Deno && typeof Deno.version == 'object') return 'DENO';
	  if (classof(globalThis.process) === 'process') return 'NODE';
	  if (globalThis.window && globalThis.document) return 'BROWSER';
	  return 'REST';
	})();
	return environment;
}

var environmentIsNode;
var hasRequiredEnvironmentIsNode;
function requireEnvironmentIsNode () {
	if (hasRequiredEnvironmentIsNode) return environmentIsNode;
	hasRequiredEnvironmentIsNode = 1;
	var ENVIRONMENT =  requireEnvironment();
	environmentIsNode = ENVIRONMENT === 'NODE';
	return environmentIsNode;
}

var defineBuiltInAccessor;
var hasRequiredDefineBuiltInAccessor;
function requireDefineBuiltInAccessor () {
	if (hasRequiredDefineBuiltInAccessor) return defineBuiltInAccessor;
	hasRequiredDefineBuiltInAccessor = 1;
	var defineProperty =  requireObjectDefineProperty();
	defineBuiltInAccessor = function (target, name, descriptor) {
	  return defineProperty.f(target, name, descriptor);
	};
	return defineBuiltInAccessor;
}

var setSpecies;
var hasRequiredSetSpecies;
function requireSetSpecies () {
	if (hasRequiredSetSpecies) return setSpecies;
	hasRequiredSetSpecies = 1;
	var getBuiltIn =  requireGetBuiltIn();
	var defineBuiltInAccessor =  requireDefineBuiltInAccessor();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var DESCRIPTORS =  requireDescriptors();
	var SPECIES = wellKnownSymbol('species');
	setSpecies = function (CONSTRUCTOR_NAME) {
	  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
	  if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
	    defineBuiltInAccessor(Constructor, SPECIES, {
	      configurable: true,
	      get: function () { return this; }
	    });
	  }
	};
	return setSpecies;
}

var anInstance;
var hasRequiredAnInstance;
function requireAnInstance () {
	if (hasRequiredAnInstance) return anInstance;
	hasRequiredAnInstance = 1;
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var $TypeError = TypeError;
	anInstance = function (it, Prototype) {
	  if (isPrototypeOf(Prototype, it)) return it;
	  throw new $TypeError('Incorrect invocation');
	};
	return anInstance;
}

var inspectSource;
var hasRequiredInspectSource;
function requireInspectSource () {
	if (hasRequiredInspectSource) return inspectSource;
	hasRequiredInspectSource = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var isCallable =  requireIsCallable();
	var store =  requireSharedStore();
	var functionToString = uncurryThis(Function.toString);
	if (!isCallable(store.inspectSource)) {
	  store.inspectSource = function (it) {
	    return functionToString(it);
	  };
	}
	inspectSource = store.inspectSource;
	return inspectSource;
}

var isConstructor;
var hasRequiredIsConstructor;
function requireIsConstructor () {
	if (hasRequiredIsConstructor) return isConstructor;
	hasRequiredIsConstructor = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var fails =  requireFails();
	var isCallable =  requireIsCallable();
	var classof =  requireClassof();
	var getBuiltIn =  requireGetBuiltIn();
	var inspectSource =  requireInspectSource();
	var noop = function () {  };
	var construct = getBuiltIn('Reflect', 'construct');
	var constructorRegExp = /^\s*(?:class|function)\b/;
	var exec = uncurryThis(constructorRegExp.exec);
	var INCORRECT_TO_STRING = !constructorRegExp.test(noop);
	var isConstructorModern = function isConstructor(argument) {
	  if (!isCallable(argument)) return false;
	  try {
	    construct(noop, [], argument);
	    return true;
	  } catch (error) {
	    return false;
	  }
	};
	var isConstructorLegacy = function isConstructor(argument) {
	  if (!isCallable(argument)) return false;
	  switch (classof(argument)) {
	    case 'AsyncFunction':
	    case 'GeneratorFunction':
	    case 'AsyncGeneratorFunction': return false;
	  }
	  try {
	    return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
	  } catch (error) {
	    return true;
	  }
	};
	isConstructorLegacy.sham = true;
	isConstructor = !construct || fails(function () {
	  var called;
	  return isConstructorModern(isConstructorModern.call)
	    || !isConstructorModern(Object)
	    || !isConstructorModern(function () { called = true; })
	    || called;
	}) ? isConstructorLegacy : isConstructorModern;
	return isConstructor;
}

var aConstructor;
var hasRequiredAConstructor;
function requireAConstructor () {
	if (hasRequiredAConstructor) return aConstructor;
	hasRequiredAConstructor = 1;
	var isConstructor =  requireIsConstructor();
	var tryToString =  requireTryToString();
	var $TypeError = TypeError;
	aConstructor = function (argument) {
	  if (isConstructor(argument)) return argument;
	  throw new $TypeError(tryToString(argument) + ' is not a constructor');
	};
	return aConstructor;
}

var speciesConstructor;
var hasRequiredSpeciesConstructor;
function requireSpeciesConstructor () {
	if (hasRequiredSpeciesConstructor) return speciesConstructor;
	hasRequiredSpeciesConstructor = 1;
	var anObject =  requireAnObject();
	var aConstructor =  requireAConstructor();
	var isNullOrUndefined =  requireIsNullOrUndefined();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var SPECIES = wellKnownSymbol('species');
	speciesConstructor = function (O, defaultConstructor) {
	  var C = anObject(O).constructor;
	  var S;
	  return C === undefined || isNullOrUndefined(S = anObject(C)[SPECIES]) ? defaultConstructor : aConstructor(S);
	};
	return speciesConstructor;
}

var arraySlice;
var hasRequiredArraySlice;
function requireArraySlice () {
	if (hasRequiredArraySlice) return arraySlice;
	hasRequiredArraySlice = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	arraySlice = uncurryThis([].slice);
	return arraySlice;
}

var validateArgumentsLength;
var hasRequiredValidateArgumentsLength;
function requireValidateArgumentsLength () {
	if (hasRequiredValidateArgumentsLength) return validateArgumentsLength;
	hasRequiredValidateArgumentsLength = 1;
	var $TypeError = TypeError;
	validateArgumentsLength = function (passed, required) {
	  if (passed < required) throw new $TypeError('Not enough arguments');
	  return passed;
	};
	return validateArgumentsLength;
}

var environmentIsIos;
var hasRequiredEnvironmentIsIos;
function requireEnvironmentIsIos () {
	if (hasRequiredEnvironmentIsIos) return environmentIsIos;
	hasRequiredEnvironmentIsIos = 1;
	var userAgent =  requireEnvironmentUserAgent();
	environmentIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent);
	return environmentIsIos;
}

var task;
var hasRequiredTask;
function requireTask () {
	if (hasRequiredTask) return task;
	hasRequiredTask = 1;
	var globalThis =  requireGlobalThis();
	var apply =  requireFunctionApply();
	var bind =  requireFunctionBindContext();
	var isCallable =  requireIsCallable();
	var hasOwn =  requireHasOwnProperty();
	var fails =  requireFails();
	var html =  requireHtml();
	var arraySlice =  requireArraySlice();
	var createElement =  requireDocumentCreateElement();
	var validateArgumentsLength =  requireValidateArgumentsLength();
	var IS_IOS =  requireEnvironmentIsIos();
	var IS_NODE =  requireEnvironmentIsNode();
	var set = globalThis.setImmediate;
	var clear = globalThis.clearImmediate;
	var process = globalThis.process;
	var Dispatch = globalThis.Dispatch;
	var Function = globalThis.Function;
	var MessageChannel = globalThis.MessageChannel;
	var String = globalThis.String;
	var counter = 0;
	var queue = {};
	var ONREADYSTATECHANGE = 'onreadystatechange';
	var $location, defer, channel, port;
	fails(function () {
	  $location = globalThis.location;
	});
	var run = function (id) {
	  if (hasOwn(queue, id)) {
	    var fn = queue[id];
	    delete queue[id];
	    fn();
	  }
	};
	var runner = function (id) {
	  return function () {
	    run(id);
	  };
	};
	var eventListener = function (event) {
	  run(event.data);
	};
	var globalPostMessageDefer = function (id) {
	  globalThis.postMessage(String(id), $location.protocol + '//' + $location.host);
	};
	if (!set || !clear) {
	  set = function setImmediate(handler) {
	    validateArgumentsLength(arguments.length, 1);
	    var fn = isCallable(handler) ? handler : Function(handler);
	    var args = arraySlice(arguments, 1);
	    queue[++counter] = function () {
	      apply(fn, undefined, args);
	    };
	    defer(counter);
	    return counter;
	  };
	  clear = function clearImmediate(id) {
	    delete queue[id];
	  };
	  if (IS_NODE) {
	    defer = function (id) {
	      process.nextTick(runner(id));
	    };
	  } else if (Dispatch && Dispatch.now) {
	    defer = function (id) {
	      Dispatch.now(runner(id));
	    };
	  } else if (MessageChannel && !IS_IOS) {
	    channel = new MessageChannel();
	    port = channel.port2;
	    channel.port1.onmessage = eventListener;
	    defer = bind(port.postMessage, port);
	  } else if (
	    globalThis.addEventListener &&
	    isCallable(globalThis.postMessage) &&
	    !globalThis.importScripts &&
	    $location && $location.protocol !== 'file:' &&
	    !fails(globalPostMessageDefer)
	  ) {
	    defer = globalPostMessageDefer;
	    globalThis.addEventListener('message', eventListener, false);
	  } else if (ONREADYSTATECHANGE in createElement('script')) {
	    defer = function (id) {
	      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
	        html.removeChild(this);
	        run(id);
	      };
	    };
	  } else {
	    defer = function (id) {
	      setTimeout(runner(id), 0);
	    };
	  }
	}
	task = {
	  set: set,
	  clear: clear
	};
	return task;
}

var safeGetBuiltIn;
var hasRequiredSafeGetBuiltIn;
function requireSafeGetBuiltIn () {
	if (hasRequiredSafeGetBuiltIn) return safeGetBuiltIn;
	hasRequiredSafeGetBuiltIn = 1;
	var globalThis =  requireGlobalThis();
	var DESCRIPTORS =  requireDescriptors();
	var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
	safeGetBuiltIn = function (name) {
	  if (!DESCRIPTORS) return globalThis[name];
	  var descriptor = getOwnPropertyDescriptor(globalThis, name);
	  return descriptor && descriptor.value;
	};
	return safeGetBuiltIn;
}

var queue;
var hasRequiredQueue;
function requireQueue () {
	if (hasRequiredQueue) return queue;
	hasRequiredQueue = 1;
	var Queue = function () {
	  this.head = null;
	  this.tail = null;
	};
	Queue.prototype = {
	  add: function (item) {
	    var entry = { item: item, next: null };
	    var tail = this.tail;
	    if (tail) tail.next = entry;
	    else this.head = entry;
	    this.tail = entry;
	  },
	  get: function () {
	    var entry = this.head;
	    if (entry) {
	      var next = this.head = entry.next;
	      if (next === null) this.tail = null;
	      return entry.item;
	    }
	  }
	};
	queue = Queue;
	return queue;
}

var environmentIsIosPebble;
var hasRequiredEnvironmentIsIosPebble;
function requireEnvironmentIsIosPebble () {
	if (hasRequiredEnvironmentIsIosPebble) return environmentIsIosPebble;
	hasRequiredEnvironmentIsIosPebble = 1;
	var userAgent =  requireEnvironmentUserAgent();
	environmentIsIosPebble = /ipad|iphone|ipod/i.test(userAgent) && typeof Pebble != 'undefined';
	return environmentIsIosPebble;
}

var environmentIsWebosWebkit;
var hasRequiredEnvironmentIsWebosWebkit;
function requireEnvironmentIsWebosWebkit () {
	if (hasRequiredEnvironmentIsWebosWebkit) return environmentIsWebosWebkit;
	hasRequiredEnvironmentIsWebosWebkit = 1;
	var userAgent =  requireEnvironmentUserAgent();
	environmentIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent);
	return environmentIsWebosWebkit;
}

var microtask_1;
var hasRequiredMicrotask;
function requireMicrotask () {
	if (hasRequiredMicrotask) return microtask_1;
	hasRequiredMicrotask = 1;
	var globalThis =  requireGlobalThis();
	var safeGetBuiltIn =  requireSafeGetBuiltIn();
	var bind =  requireFunctionBindContext();
	var macrotask =  requireTask().set;
	var Queue =  requireQueue();
	var IS_IOS =  requireEnvironmentIsIos();
	var IS_IOS_PEBBLE =  requireEnvironmentIsIosPebble();
	var IS_WEBOS_WEBKIT =  requireEnvironmentIsWebosWebkit();
	var IS_NODE =  requireEnvironmentIsNode();
	var MutationObserver = globalThis.MutationObserver || globalThis.WebKitMutationObserver;
	var document = globalThis.document;
	var process = globalThis.process;
	var Promise = globalThis.Promise;
	var microtask = safeGetBuiltIn('queueMicrotask');
	var notify, toggle, node, promise, then;
	if (!microtask) {
	  var queue = new Queue();
	  var flush = function () {
	    var parent, fn;
	    if (IS_NODE && (parent = process.domain)) parent.exit();
	    while (fn = queue.get()) try {
	      fn();
	    } catch (error) {
	      if (queue.head) notify();
	      throw error;
	    }
	    if (parent) parent.enter();
	  };
	  if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
	    toggle = true;
	    node = document.createTextNode('');
	    new MutationObserver(flush).observe(node, { characterData: true });
	    notify = function () {
	      node.data = toggle = !toggle;
	    };
	  } else if (!IS_IOS_PEBBLE && Promise && Promise.resolve) {
	    promise = Promise.resolve(undefined);
	    promise.constructor = Promise;
	    then = bind(promise.then, promise);
	    notify = function () {
	      then(flush);
	    };
	  } else if (IS_NODE) {
	    notify = function () {
	      process.nextTick(flush);
	    };
	  } else {
	    macrotask = bind(macrotask, globalThis);
	    notify = function () {
	      macrotask(flush);
	    };
	  }
	  microtask = function (fn) {
	    if (!queue.head) notify();
	    queue.add(fn);
	  };
	}
	microtask_1 = microtask;
	return microtask_1;
}

var hostReportErrors;
var hasRequiredHostReportErrors;
function requireHostReportErrors () {
	if (hasRequiredHostReportErrors) return hostReportErrors;
	hasRequiredHostReportErrors = 1;
	hostReportErrors = function (a, b) {
	  try {
	    arguments.length === 1 ? console.error(a) : console.error(a, b);
	  } catch (error) {  }
	};
	return hostReportErrors;
}

var perform;
var hasRequiredPerform;
function requirePerform () {
	if (hasRequiredPerform) return perform;
	hasRequiredPerform = 1;
	perform = function (exec) {
	  try {
	    return { error: false, value: exec() };
	  } catch (error) {
	    return { error: true, value: error };
	  }
	};
	return perform;
}

var promiseNativeConstructor;
var hasRequiredPromiseNativeConstructor;
function requirePromiseNativeConstructor () {
	if (hasRequiredPromiseNativeConstructor) return promiseNativeConstructor;
	hasRequiredPromiseNativeConstructor = 1;
	var globalThis =  requireGlobalThis();
	promiseNativeConstructor = globalThis.Promise;
	return promiseNativeConstructor;
}

var promiseConstructorDetection;
var hasRequiredPromiseConstructorDetection;
function requirePromiseConstructorDetection () {
	if (hasRequiredPromiseConstructorDetection) return promiseConstructorDetection;
	hasRequiredPromiseConstructorDetection = 1;
	var globalThis =  requireGlobalThis();
	var NativePromiseConstructor =  requirePromiseNativeConstructor();
	var isCallable =  requireIsCallable();
	var isForced =  requireIsForced();
	var inspectSource =  requireInspectSource();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var ENVIRONMENT =  requireEnvironment();
	var IS_PURE =  requireIsPure();
	var V8_VERSION =  requireEnvironmentV8Version();
	var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
	var SPECIES = wellKnownSymbol('species');
	var SUBCLASSING = false;
	var NATIVE_PROMISE_REJECTION_EVENT = isCallable(globalThis.PromiseRejectionEvent);
	var FORCED_PROMISE_CONSTRUCTOR = isForced('Promise', function () {
	  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor);
	  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor);
	  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
	  if (IS_PURE && !(NativePromisePrototype['catch'] && NativePromisePrototype['finally'])) return true;
	  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
	    var promise = new NativePromiseConstructor(function (resolve) { resolve(1); });
	    var FakePromise = function (exec) {
	      exec(function () {  }, function () {  });
	    };
	    var constructor = promise.constructor = {};
	    constructor[SPECIES] = FakePromise;
	    SUBCLASSING = promise.then(function () {  }) instanceof FakePromise;
	    if (!SUBCLASSING) return true;
	  } return !GLOBAL_CORE_JS_PROMISE && (ENVIRONMENT === 'BROWSER' || ENVIRONMENT === 'DENO') && !NATIVE_PROMISE_REJECTION_EVENT;
	});
	promiseConstructorDetection = {
	  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR,
	  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT,
	  SUBCLASSING: SUBCLASSING
	};
	return promiseConstructorDetection;
}

var newPromiseCapability = {};

var hasRequiredNewPromiseCapability;
function requireNewPromiseCapability () {
	if (hasRequiredNewPromiseCapability) return newPromiseCapability;
	hasRequiredNewPromiseCapability = 1;
	var aCallable =  requireACallable();
	var $TypeError = TypeError;
	var PromiseCapability = function (C) {
	  var resolve, reject;
	  this.promise = new C(function ($$resolve, $$reject) {
	    if (resolve !== undefined || reject !== undefined) throw new $TypeError('Bad Promise constructor');
	    resolve = $$resolve;
	    reject = $$reject;
	  });
	  this.resolve = aCallable(resolve);
	  this.reject = aCallable(reject);
	};
	newPromiseCapability.f = function (C) {
	  return new PromiseCapability(C);
	};
	return newPromiseCapability;
}

var hasRequiredEs_promise_constructor;
function requireEs_promise_constructor () {
	if (hasRequiredEs_promise_constructor) return es_promise_constructor;
	hasRequiredEs_promise_constructor = 1;
	var $ =  require_export();
	var IS_PURE =  requireIsPure();
	var IS_NODE =  requireEnvironmentIsNode();
	var globalThis =  requireGlobalThis();
	var path =  requirePath();
	var call =  requireFunctionCall();
	var defineBuiltIn =  requireDefineBuiltIn();
	var setPrototypeOf =  requireObjectSetPrototypeOf();
	var setToStringTag =  requireSetToStringTag();
	var setSpecies =  requireSetSpecies();
	var aCallable =  requireACallable();
	var isCallable =  requireIsCallable();
	var isObject =  requireIsObject();
	var anInstance =  requireAnInstance();
	var speciesConstructor =  requireSpeciesConstructor();
	var task =  requireTask().set;
	var microtask =  requireMicrotask();
	var hostReportErrors =  requireHostReportErrors();
	var perform =  requirePerform();
	var Queue =  requireQueue();
	var InternalStateModule =  requireInternalState();
	var NativePromiseConstructor =  requirePromiseNativeConstructor();
	var PromiseConstructorDetection =  requirePromiseConstructorDetection();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var PROMISE = 'Promise';
	var FORCED_PROMISE_CONSTRUCTOR = PromiseConstructorDetection.CONSTRUCTOR;
	var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
	var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
	var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
	var setInternalState = InternalStateModule.set;
	var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
	var PromiseConstructor = NativePromiseConstructor;
	var PromisePrototype = NativePromisePrototype;
	var TypeError = globalThis.TypeError;
	var document = globalThis.document;
	var process = globalThis.process;
	var newPromiseCapability = newPromiseCapabilityModule.f;
	var newGenericPromiseCapability = newPromiseCapability;
	var DISPATCH_EVENT = !!(document && document.createEvent && globalThis.dispatchEvent);
	var UNHANDLED_REJECTION = 'unhandledrejection';
	var REJECTION_HANDLED = 'rejectionhandled';
	var PENDING = 0;
	var FULFILLED = 1;
	var REJECTED = 2;
	var HANDLED = 1;
	var UNHANDLED = 2;
	var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
	var isThenable = function (it) {
	  var then;
	  return isObject(it) && isCallable(then = it.then) ? then : false;
	};
	var callReaction = function (reaction, state) {
	  var value = state.value;
	  var ok = state.state === FULFILLED;
	  var handler = ok ? reaction.ok : reaction.fail;
	  var resolve = reaction.resolve;
	  var reject = reaction.reject;
	  var domain = reaction.domain;
	  var result, then, exited;
	  try {
	    if (handler) {
	      if (!ok) {
	        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
	        state.rejection = HANDLED;
	      }
	      if (handler === true) result = value;
	      else {
	        if (domain) domain.enter();
	        result = handler(value);
	        if (domain) {
	          domain.exit();
	          exited = true;
	        }
	      }
	      if (result === reaction.promise) {
	        reject(new TypeError('Promise-chain cycle'));
	      } else if (then = isThenable(result)) {
	        call(then, result, resolve, reject);
	      } else resolve(result);
	    } else reject(value);
	  } catch (error) {
	    if (domain && !exited) domain.exit();
	    reject(error);
	  }
	};
	var notify = function (state, isReject) {
	  if (state.notified) return;
	  state.notified = true;
	  microtask(function () {
	    var reactions = state.reactions;
	    var reaction;
	    while (reaction = reactions.get()) {
	      callReaction(reaction, state);
	    }
	    state.notified = false;
	    if (isReject && !state.rejection) onUnhandled(state);
	  });
	};
	var dispatchEvent = function (name, promise, reason) {
	  var event, handler;
	  if (DISPATCH_EVENT) {
	    event = document.createEvent('Event');
	    event.promise = promise;
	    event.reason = reason;
	    event.initEvent(name, false, true);
	    globalThis.dispatchEvent(event);
	  } else event = { promise: promise, reason: reason };
	  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = globalThis['on' + name])) handler(event);
	  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
	};
	var onUnhandled = function (state) {
	  call(task, globalThis, function () {
	    var promise = state.facade;
	    var value = state.value;
	    var IS_UNHANDLED = isUnhandled(state);
	    var result;
	    if (IS_UNHANDLED) {
	      result = perform(function () {
	        if (IS_NODE) {
	          process.emit('unhandledRejection', value, promise);
	        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
	      });
	      state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
	      if (result.error) throw result.value;
	    }
	  });
	};
	var isUnhandled = function (state) {
	  return state.rejection !== HANDLED && !state.parent;
	};
	var onHandleUnhandled = function (state) {
	  call(task, globalThis, function () {
	    var promise = state.facade;
	    if (IS_NODE) {
	      process.emit('rejectionHandled', promise);
	    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
	  });
	};
	var bind = function (fn, state, unwrap) {
	  return function (value) {
	    fn(state, value, unwrap);
	  };
	};
	var internalReject = function (state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  state.value = value;
	  state.state = REJECTED;
	  notify(state, true);
	};
	var internalResolve = function (state, value, unwrap) {
	  if (state.done) return;
	  state.done = true;
	  if (unwrap) state = unwrap;
	  try {
	    if (state.facade === value) throw new TypeError("Promise can't be resolved itself");
	    var then = isThenable(value);
	    if (then) {
	      microtask(function () {
	        var wrapper = { done: false };
	        try {
	          call(then, value,
	            bind(internalResolve, wrapper, state),
	            bind(internalReject, wrapper, state)
	          );
	        } catch (error) {
	          internalReject(wrapper, error, state);
	        }
	      });
	    } else {
	      state.value = value;
	      state.state = FULFILLED;
	      notify(state, false);
	    }
	  } catch (error) {
	    internalReject({ done: false }, error, state);
	  }
	};
	if (FORCED_PROMISE_CONSTRUCTOR) {
	  PromiseConstructor = function Promise(executor) {
	    anInstance(this, PromisePrototype);
	    aCallable(executor);
	    call(Internal, this);
	    var state = getInternalPromiseState(this);
	    try {
	      executor(bind(internalResolve, state), bind(internalReject, state));
	    } catch (error) {
	      internalReject(state, error);
	    }
	  };
	  PromisePrototype = PromiseConstructor.prototype;
	  Internal = function Promise(executor) {
	    setInternalState(this, {
	      type: PROMISE,
	      done: false,
	      notified: false,
	      parent: false,
	      reactions: new Queue(),
	      rejection: false,
	      state: PENDING,
	      value: null
	    });
	  };
	  Internal.prototype = defineBuiltIn(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
	    var state = getInternalPromiseState(this);
	    var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
	    state.parent = true;
	    reaction.ok = isCallable(onFulfilled) ? onFulfilled : true;
	    reaction.fail = isCallable(onRejected) && onRejected;
	    reaction.domain = IS_NODE ? process.domain : undefined;
	    if (state.state === PENDING) state.reactions.add(reaction);
	    else microtask(function () {
	      callReaction(reaction, state);
	    });
	    return reaction.promise;
	  });
	  OwnPromiseCapability = function () {
	    var promise = new Internal();
	    var state = getInternalPromiseState(promise);
	    this.promise = promise;
	    this.resolve = bind(internalResolve, state);
	    this.reject = bind(internalReject, state);
	  };
	  newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
	    return C === PromiseConstructor || C === PromiseWrapper
	      ? new OwnPromiseCapability(C)
	      : newGenericPromiseCapability(C);
	  };
	  if (!IS_PURE && isCallable(NativePromiseConstructor) && NativePromisePrototype !== Object.prototype) {
	    nativeThen = NativePromisePrototype.then;
	    if (!NATIVE_PROMISE_SUBCLASSING) {
	      defineBuiltIn(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
	        var that = this;
	        return new PromiseConstructor(function (resolve, reject) {
	          call(nativeThen, that, resolve, reject);
	        }).then(onFulfilled, onRejected);
	      }, { unsafe: true });
	    }
	    try {
	      delete NativePromisePrototype.constructor;
	    } catch (error) {  }
	    if (setPrototypeOf) {
	      setPrototypeOf(NativePromisePrototype, PromisePrototype);
	    }
	  }
	}
	$({ global: true, constructor: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR }, {
	  Promise: PromiseConstructor
	});
	PromiseWrapper = path.Promise;
	setToStringTag(PromiseConstructor, PROMISE, false, true);
	setSpecies(PROMISE);
	return es_promise_constructor;
}

var es_promise_all = {};

var checkCorrectnessOfIteration;
var hasRequiredCheckCorrectnessOfIteration;
function requireCheckCorrectnessOfIteration () {
	if (hasRequiredCheckCorrectnessOfIteration) return checkCorrectnessOfIteration;
	hasRequiredCheckCorrectnessOfIteration = 1;
	var wellKnownSymbol =  requireWellKnownSymbol();
	var ITERATOR = wellKnownSymbol('iterator');
	var SAFE_CLOSING = false;
	try {
	  var called = 0;
	  var iteratorWithReturn = {
	    next: function () {
	      return { done: !!called++ };
	    },
	    'return': function () {
	      SAFE_CLOSING = true;
	    }
	  };
	  iteratorWithReturn[ITERATOR] = function () {
	    return this;
	  };
	  Array.from(iteratorWithReturn, function () { throw 2; });
	} catch (error) {  }
	checkCorrectnessOfIteration = function (exec, SKIP_CLOSING) {
	  try {
	    if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
	  } catch (error) { return false; }
	  var ITERATION_SUPPORT = false;
	  try {
	    var object = {};
	    object[ITERATOR] = function () {
	      return {
	        next: function () {
	          return { done: ITERATION_SUPPORT = true };
	        }
	      };
	    };
	    exec(object);
	  } catch (error) {  }
	  return ITERATION_SUPPORT;
	};
	return checkCorrectnessOfIteration;
}

var promiseStaticsIncorrectIteration;
var hasRequiredPromiseStaticsIncorrectIteration;
function requirePromiseStaticsIncorrectIteration () {
	if (hasRequiredPromiseStaticsIncorrectIteration) return promiseStaticsIncorrectIteration;
	hasRequiredPromiseStaticsIncorrectIteration = 1;
	var NativePromiseConstructor =  requirePromiseNativeConstructor();
	var checkCorrectnessOfIteration =  requireCheckCorrectnessOfIteration();
	var FORCED_PROMISE_CONSTRUCTOR =  requirePromiseConstructorDetection().CONSTRUCTOR;
	promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR || !checkCorrectnessOfIteration(function (iterable) {
	  NativePromiseConstructor.all(iterable).then(undefined, function () {  });
	});
	return promiseStaticsIncorrectIteration;
}

var hasRequiredEs_promise_all;
function requireEs_promise_all () {
	if (hasRequiredEs_promise_all) return es_promise_all;
	hasRequiredEs_promise_all = 1;
	var $ =  require_export();
	var call =  requireFunctionCall();
	var aCallable =  requireACallable();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var perform =  requirePerform();
	var iterate =  requireIterate();
	var PROMISE_STATICS_INCORRECT_ITERATION =  requirePromiseStaticsIncorrectIteration();
	$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
	  all: function all(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var $promiseResolve = aCallable(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call($promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = value;
	          --remaining || resolve(values);
	        }, reject);
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});
	return es_promise_all;
}

var es_promise_catch = {};

var hasRequiredEs_promise_catch;
function requireEs_promise_catch () {
	if (hasRequiredEs_promise_catch) return es_promise_catch;
	hasRequiredEs_promise_catch = 1;
	var $ =  require_export();
	var IS_PURE =  requireIsPure();
	var FORCED_PROMISE_CONSTRUCTOR =  requirePromiseConstructorDetection().CONSTRUCTOR;
	var NativePromiseConstructor =  requirePromiseNativeConstructor();
	var getBuiltIn =  requireGetBuiltIn();
	var isCallable =  requireIsCallable();
	var defineBuiltIn =  requireDefineBuiltIn();
	var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
	$({ target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR, real: true }, {
	  'catch': function (onRejected) {
	    return this.then(undefined, onRejected);
	  }
	});
	if (!IS_PURE && isCallable(NativePromiseConstructor)) {
	  var method = getBuiltIn('Promise').prototype['catch'];
	  if (NativePromisePrototype['catch'] !== method) {
	    defineBuiltIn(NativePromisePrototype, 'catch', method, { unsafe: true });
	  }
	}
	return es_promise_catch;
}

var es_promise_race = {};

var hasRequiredEs_promise_race;
function requireEs_promise_race () {
	if (hasRequiredEs_promise_race) return es_promise_race;
	hasRequiredEs_promise_race = 1;
	var $ =  require_export();
	var call =  requireFunctionCall();
	var aCallable =  requireACallable();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var perform =  requirePerform();
	var iterate =  requireIterate();
	var PROMISE_STATICS_INCORRECT_ITERATION =  requirePromiseStaticsIncorrectIteration();
	$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
	  race: function race(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule.f(C);
	    var reject = capability.reject;
	    var result = perform(function () {
	      var $promiseResolve = aCallable(C.resolve);
	      iterate(iterable, function (promise) {
	        call($promiseResolve, C, promise).then(capability.resolve, reject);
	      });
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});
	return es_promise_race;
}

var es_promise_reject = {};

var hasRequiredEs_promise_reject;
function requireEs_promise_reject () {
	if (hasRequiredEs_promise_reject) return es_promise_reject;
	hasRequiredEs_promise_reject = 1;
	var $ =  require_export();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var FORCED_PROMISE_CONSTRUCTOR =  requirePromiseConstructorDetection().CONSTRUCTOR;
	$({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR }, {
	  reject: function reject(r) {
	    var capability = newPromiseCapabilityModule.f(this);
	    var capabilityReject = capability.reject;
	    capabilityReject(r);
	    return capability.promise;
	  }
	});
	return es_promise_reject;
}

var es_promise_resolve = {};

var promiseResolve;
var hasRequiredPromiseResolve;
function requirePromiseResolve () {
	if (hasRequiredPromiseResolve) return promiseResolve;
	hasRequiredPromiseResolve = 1;
	var anObject =  requireAnObject();
	var isObject =  requireIsObject();
	var newPromiseCapability =  requireNewPromiseCapability();
	promiseResolve = function (C, x) {
	  anObject(C);
	  if (isObject(x) && x.constructor === C) return x;
	  var promiseCapability = newPromiseCapability.f(C);
	  var resolve = promiseCapability.resolve;
	  resolve(x);
	  return promiseCapability.promise;
	};
	return promiseResolve;
}

var hasRequiredEs_promise_resolve;
function requireEs_promise_resolve () {
	if (hasRequiredEs_promise_resolve) return es_promise_resolve;
	hasRequiredEs_promise_resolve = 1;
	var $ =  require_export();
	var getBuiltIn =  requireGetBuiltIn();
	var IS_PURE =  requireIsPure();
	var NativePromiseConstructor =  requirePromiseNativeConstructor();
	var FORCED_PROMISE_CONSTRUCTOR =  requirePromiseConstructorDetection().CONSTRUCTOR;
	var promiseResolve =  requirePromiseResolve();
	var PromiseConstructorWrapper = getBuiltIn('Promise');
	var CHECK_WRAPPER = IS_PURE && !FORCED_PROMISE_CONSTRUCTOR;
	$({ target: 'Promise', stat: true, forced: IS_PURE || FORCED_PROMISE_CONSTRUCTOR }, {
	  resolve: function resolve(x) {
	    return promiseResolve(CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor : this, x);
	  }
	});
	return es_promise_resolve;
}

var hasRequiredEs_promise;
function requireEs_promise () {
	if (hasRequiredEs_promise) return es_promise;
	hasRequiredEs_promise = 1;
	requireEs_promise_constructor();
	requireEs_promise_all();
	requireEs_promise_catch();
	requireEs_promise_race();
	requireEs_promise_reject();
	requireEs_promise_resolve();
	return es_promise;
}

var es_promise_allSettled = {};

var hasRequiredEs_promise_allSettled;
function requireEs_promise_allSettled () {
	if (hasRequiredEs_promise_allSettled) return es_promise_allSettled;
	hasRequiredEs_promise_allSettled = 1;
	var $ =  require_export();
	var call =  requireFunctionCall();
	var aCallable =  requireACallable();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var perform =  requirePerform();
	var iterate =  requireIterate();
	var PROMISE_STATICS_INCORRECT_ITERATION =  requirePromiseStaticsIncorrectIteration();
	$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
	  allSettled: function allSettled(iterable) {
	    var C = this;
	    var capability = newPromiseCapabilityModule.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var promiseResolve = aCallable(C.resolve);
	      var values = [];
	      var counter = 0;
	      var remaining = 1;
	      iterate(iterable, function (promise) {
	        var index = counter++;
	        var alreadyCalled = false;
	        remaining++;
	        call(promiseResolve, C, promise).then(function (value) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = { status: 'fulfilled', value: value };
	          --remaining || resolve(values);
	        }, function (error) {
	          if (alreadyCalled) return;
	          alreadyCalled = true;
	          values[index] = { status: 'rejected', reason: error };
	          --remaining || resolve(values);
	        });
	      });
	      --remaining || resolve(values);
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});
	return es_promise_allSettled;
}

var es_promise_any = {};

var hasRequiredEs_promise_any;
function requireEs_promise_any () {
	if (hasRequiredEs_promise_any) return es_promise_any;
	hasRequiredEs_promise_any = 1;
	var $ =  require_export();
	var call =  requireFunctionCall();
	var aCallable =  requireACallable();
	var getBuiltIn =  requireGetBuiltIn();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var perform =  requirePerform();
	var iterate =  requireIterate();
	var PROMISE_STATICS_INCORRECT_ITERATION =  requirePromiseStaticsIncorrectIteration();
	var PROMISE_ANY_ERROR = 'No one promise resolved';
	$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
	  any: function any(iterable) {
	    var C = this;
	    var AggregateError = getBuiltIn('AggregateError');
	    var capability = newPromiseCapabilityModule.f(C);
	    var resolve = capability.resolve;
	    var reject = capability.reject;
	    var result = perform(function () {
	      var promiseResolve = aCallable(C.resolve);
	      var errors = [];
	      var counter = 0;
	      var remaining = 1;
	      var alreadyResolved = false;
	      iterate(iterable, function (promise) {
	        var index = counter++;
	        var alreadyRejected = false;
	        remaining++;
	        call(promiseResolve, C, promise).then(function (value) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyResolved = true;
	          resolve(value);
	        }, function (error) {
	          if (alreadyRejected || alreadyResolved) return;
	          alreadyRejected = true;
	          errors[index] = error;
	          --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	        });
	      });
	      --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
	    });
	    if (result.error) reject(result.value);
	    return capability.promise;
	  }
	});
	return es_promise_any;
}

var es_promise_try = {};

var hasRequiredEs_promise_try;
function requireEs_promise_try () {
	if (hasRequiredEs_promise_try) return es_promise_try;
	hasRequiredEs_promise_try = 1;
	var $ =  require_export();
	var globalThis =  requireGlobalThis();
	var apply =  requireFunctionApply();
	var slice =  requireArraySlice();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	var aCallable =  requireACallable();
	var perform =  requirePerform();
	var Promise = globalThis.Promise;
	var ACCEPT_ARGUMENTS = false;
	var FORCED = !Promise || !Promise['try'] || perform(function () {
	  Promise['try'](function (argument) {
	    ACCEPT_ARGUMENTS = argument === 8;
	  }, 8);
	}).error || !ACCEPT_ARGUMENTS;
	$({ target: 'Promise', stat: true, forced: FORCED }, {
	  'try': function (callbackfn ) {
	    var args = arguments.length > 1 ? slice(arguments, 1) : [];
	    var promiseCapability = newPromiseCapabilityModule.f(this);
	    var result = perform(function () {
	      return apply(aCallable(callbackfn), undefined, args);
	    });
	    (result.error ? promiseCapability.reject : promiseCapability.resolve)(result.value);
	    return promiseCapability.promise;
	  }
	});
	return es_promise_try;
}

var es_promise_withResolvers = {};

var hasRequiredEs_promise_withResolvers;
function requireEs_promise_withResolvers () {
	if (hasRequiredEs_promise_withResolvers) return es_promise_withResolvers;
	hasRequiredEs_promise_withResolvers = 1;
	var $ =  require_export();
	var newPromiseCapabilityModule =  requireNewPromiseCapability();
	$({ target: 'Promise', stat: true }, {
	  withResolvers: function withResolvers() {
	    var promiseCapability = newPromiseCapabilityModule.f(this);
	    return {
	      promise: promiseCapability.promise,
	      resolve: promiseCapability.resolve,
	      reject: promiseCapability.reject
	    };
	  }
	});
	return es_promise_withResolvers;
}

var es_promise_finally = {};

var hasRequiredEs_promise_finally;
function requireEs_promise_finally () {
	if (hasRequiredEs_promise_finally) return es_promise_finally;
	hasRequiredEs_promise_finally = 1;
	var $ =  require_export();
	var IS_PURE =  requireIsPure();
	var NativePromiseConstructor =  requirePromiseNativeConstructor();
	var fails =  requireFails();
	var getBuiltIn =  requireGetBuiltIn();
	var isCallable =  requireIsCallable();
	var speciesConstructor =  requireSpeciesConstructor();
	var promiseResolve =  requirePromiseResolve();
	var defineBuiltIn =  requireDefineBuiltIn();
	var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
	var NON_GENERIC = !!NativePromiseConstructor && fails(function () {
	  NativePromisePrototype['finally'].call({ then: function () {  } }, function () {  });
	});
	$({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
	  'finally': function (onFinally) {
	    var C = speciesConstructor(this, getBuiltIn('Promise'));
	    var isFunction = isCallable(onFinally);
	    return this.then(
	      isFunction ? function (x) {
	        return promiseResolve(C, onFinally()).then(function () { return x; });
	      } : onFinally,
	      isFunction ? function (e) {
	        return promiseResolve(C, onFinally()).then(function () { throw e; });
	      } : onFinally
	    );
	  }
	});
	if (!IS_PURE && isCallable(NativePromiseConstructor)) {
	  var method = getBuiltIn('Promise').prototype['finally'];
	  if (NativePromisePrototype['finally'] !== method) {
	    defineBuiltIn(NativePromisePrototype, 'finally', method, { unsafe: true });
	  }
	}
	return es_promise_finally;
}

var es_string_iterator = {};

var stringMultibyte;
var hasRequiredStringMultibyte;
function requireStringMultibyte () {
	if (hasRequiredStringMultibyte) return stringMultibyte;
	hasRequiredStringMultibyte = 1;
	var uncurryThis =  requireFunctionUncurryThis();
	var toIntegerOrInfinity =  requireToIntegerOrInfinity();
	var toString =  requireToString();
	var requireObjectCoercible =  requireRequireObjectCoercible();
	var charAt = uncurryThis(''.charAt);
	var charCodeAt = uncurryThis(''.charCodeAt);
	var stringSlice = uncurryThis(''.slice);
	var createMethod = function (CONVERT_TO_STRING) {
	  return function ($this, pos) {
	    var S = toString(requireObjectCoercible($this));
	    var position = toIntegerOrInfinity(pos);
	    var size = S.length;
	    var first, second;
	    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
	    first = charCodeAt(S, position);
	    return first < 0xD800 || first > 0xDBFF || position + 1 === size
	      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
	        ? CONVERT_TO_STRING
	          ? charAt(S, position)
	          : first
	        : CONVERT_TO_STRING
	          ? stringSlice(S, position, position + 2)
	          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
	  };
	};
	stringMultibyte = {
	  codeAt: createMethod(false),
	  charAt: createMethod(true)
	};
	return stringMultibyte;
}

var hasRequiredEs_string_iterator;
function requireEs_string_iterator () {
	if (hasRequiredEs_string_iterator) return es_string_iterator;
	hasRequiredEs_string_iterator = 1;
	var charAt =  requireStringMultibyte().charAt;
	var toString =  requireToString();
	var InternalStateModule =  requireInternalState();
	var defineIterator =  requireIteratorDefine();
	var createIterResultObject =  requireCreateIterResultObject();
	var STRING_ITERATOR = 'String Iterator';
	var setInternalState = InternalStateModule.set;
	var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);
	defineIterator(String, 'String', function (iterated) {
	  setInternalState(this, {
	    type: STRING_ITERATOR,
	    string: toString(iterated),
	    index: 0
	  });
	}, function next() {
	  var state = getInternalState(this);
	  var string = state.string;
	  var index = state.index;
	  var point;
	  if (index >= string.length) return createIterResultObject(undefined, true);
	  point = charAt(string, index);
	  state.index += point.length;
	  return createIterResultObject(point, false);
	});
	return es_string_iterator;
}

var promise$2;
var hasRequiredPromise$2;
function requirePromise$2 () {
	if (hasRequiredPromise$2) return promise$2;
	hasRequiredPromise$2 = 1;
	requireEs_aggregateError();
	requireEs_array_iterator();
	requireEs_promise();
	requireEs_promise_allSettled();
	requireEs_promise_any();
	requireEs_promise_try();
	requireEs_promise_withResolvers();
	requireEs_promise_finally();
	requireEs_string_iterator();
	var path =  requirePath();
	promise$2 = path.Promise;
	return promise$2;
}

var web_domCollections_iterator = {};

var domIterables;
var hasRequiredDomIterables;
function requireDomIterables () {
	if (hasRequiredDomIterables) return domIterables;
	hasRequiredDomIterables = 1;
	domIterables = {
	  CSSRuleList: 0,
	  CSSStyleDeclaration: 0,
	  CSSValueList: 0,
	  ClientRectList: 0,
	  DOMRectList: 0,
	  DOMStringList: 0,
	  DOMTokenList: 1,
	  DataTransferItemList: 0,
	  FileList: 0,
	  HTMLAllCollection: 0,
	  HTMLCollection: 0,
	  HTMLFormElement: 0,
	  HTMLSelectElement: 0,
	  MediaList: 0,
	  MimeTypeArray: 0,
	  NamedNodeMap: 0,
	  NodeList: 1,
	  PaintRequestList: 0,
	  Plugin: 0,
	  PluginArray: 0,
	  SVGLengthList: 0,
	  SVGNumberList: 0,
	  SVGPathSegList: 0,
	  SVGPointList: 0,
	  SVGStringList: 0,
	  SVGTransformList: 0,
	  SourceBufferList: 0,
	  StyleSheetList: 0,
	  TextTrackCueList: 0,
	  TextTrackList: 0,
	  TouchList: 0
	};
	return domIterables;
}

var hasRequiredWeb_domCollections_iterator;
function requireWeb_domCollections_iterator () {
	if (hasRequiredWeb_domCollections_iterator) return web_domCollections_iterator;
	hasRequiredWeb_domCollections_iterator = 1;
	requireEs_array_iterator();
	var DOMIterables =  requireDomIterables();
	var globalThis =  requireGlobalThis();
	var setToStringTag =  requireSetToStringTag();
	var Iterators =  requireIterators();
	for (var COLLECTION_NAME in DOMIterables) {
	  setToStringTag(globalThis[COLLECTION_NAME], COLLECTION_NAME);
	  Iterators[COLLECTION_NAME] = Iterators.Array;
	}
	return web_domCollections_iterator;
}

var promise$1;
var hasRequiredPromise$1;
function requirePromise$1 () {
	if (hasRequiredPromise$1) return promise$1;
	hasRequiredPromise$1 = 1;
	var parent =  requirePromise$2();
	requireWeb_domCollections_iterator();
	promise$1 = parent;
	return promise$1;
}

var promise;
var hasRequiredPromise;
function requirePromise () {
	if (hasRequiredPromise) return promise;
	hasRequiredPromise = 1;
	promise =  requirePromise$1();
	return promise;
}

var promiseExports = requirePromise();
var _Promise = /*@__PURE__*/getDefaultExportFromCjs(promiseExports);

/**
 * Generates SHA-256 hash of string.
 *
 * @param   {string} msg - String to be hashed
 * @returns {string} Hash of msg as hex character string
 */
function sha256hash(msg) {
  /**
   * Rotates right (circular right shift) value x by n positions [3.2.4].
   * @private
   */
  function ROTR(n, x) {
    return x >>> n | x << 32 - n;
  }
  /**
   * Logical functions [4.1.2].
   * @private
   */
  function S0(x) {
    return ROTR(2, x) ^ ROTR(13, x) ^ ROTR(22, x);
  }
  function S1(x) {
    return ROTR(6, x) ^ ROTR(11, x) ^ ROTR(25, x);
  }
  function s0(x) {
    return ROTR(7, x) ^ ROTR(18, x) ^ x >>> 3;
  }
  function s1(x) {
    return ROTR(17, x) ^ ROTR(19, x) ^ x >>> 10;
  }
  function Ch(x, y, z) {
    return x & y ^ ~x & z;
  }
  function Maj(x, y, z) {
    return x & y ^ x & z ^ y & z;
  }
  /**
   * Hexadecimal representation of a number.
   * @private
   */
  function toHexStr(n) {
    let s = "",
      v;
    for (let i = 7; i >= 0; i--) {
      v = n >>> i * 4 & 0xf;
      s += v.toString(16);
    }
    return s;
  }
  msg = unescape(encodeURIComponent(msg));
  const K = [0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5, 0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174, 0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da, 0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967, 0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85, 0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070, 0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3, 0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2];
  const H = [0x6a09e667, 0xbb67ae85, 0x3c6ef372, 0xa54ff53a, 0x510e527f, 0x9b05688c, 0x1f83d9ab, 0x5be0cd19];
  msg += String.fromCharCode(0x80);
  const l = msg.length / 4 + 2;
  const N = Math.ceil(l / 16);
  const M = new Array(N);
  for (let i = 0; i < N; i++) {
    M[i] = new Array(16);
    for (let j = 0; j < 16; j++) {
      M[i][j] = msg.charCodeAt(i * 64 + j * 4) << 24 | msg.charCodeAt(i * 64 + j * 4 + 1) << 16 | msg.charCodeAt(i * 64 + j * 4 + 2) << 8 | msg.charCodeAt(i * 64 + j * 4 + 3);
    }
  }
  M[N - 1][14] = (msg.length - 1) * 8 / Math.pow(2, 32);
  M[N - 1][14] = Math.floor(M[N - 1][14]);
  M[N - 1][15] = (msg.length - 1) * 8 & 0xffffffff;
  const W = new Array(64);
  let a, b, c, d, e, f, g, h;
  for (let i = 0; i < N; i++) {
    for (let t = 0; t < 16; t++) W[t] = M[i][t];
    for (let t = 16; t < 64; t++) W[t] = s1(W[t - 2]) + W[t - 7] + s0(W[t - 15]) + W[t - 16] & 0xffffffff;
    a = H[0];
    b = H[1];
    c = H[2];
    d = H[3];
    e = H[4];
    f = H[5];
    g = H[6];
    h = H[7];
    for (let t = 0; t < 64; t++) {
      const T1 = h + S1(e) + Ch(e, f, g) + K[t] + W[t];
      const T2 = S0(a) + Maj(a, b, c);
      h = g;
      g = f;
      f = e;
      e = d + T1 & 0xffffffff;
      d = c;
      c = b;
      b = a;
      a = T1 + T2 & 0xffffffff;
    }
    H[0] = H[0] + a & 0xffffffff;
    H[1] = H[1] + b & 0xffffffff;
    H[2] = H[2] + c & 0xffffffff;
    H[3] = H[3] + d & 0xffffffff;
    H[4] = H[4] + e & 0xffffffff;
    H[5] = H[5] + f & 0xffffffff;
    H[6] = H[6] + g & 0xffffffff;
    H[7] = H[7] + h & 0xffffffff;
  }
  return toHexStr(H[0]) + toHexStr(H[1]) + toHexStr(H[2]) + toHexStr(H[3]) + toHexStr(H[4]) + toHexStr(H[5]) + toHexStr(H[6]) + toHexStr(H[7]);
}

var es_array_includes = {};

var hasRequiredEs_array_includes;
function requireEs_array_includes () {
	if (hasRequiredEs_array_includes) return es_array_includes;
	hasRequiredEs_array_includes = 1;
	var $ =  require_export();
	var $includes =  requireArrayIncludes().includes;
	var fails =  requireFails();
	var addToUnscopables =  requireAddToUnscopables();
	var BROKEN_ON_SPARSE = fails(function () {
	  return !Array(1).includes();
	});
	$({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
	  includes: function includes(el ) {
	    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
	  }
	});
	addToUnscopables('includes');
	return es_array_includes;
}

var getBuiltInPrototypeMethod;
var hasRequiredGetBuiltInPrototypeMethod;
function requireGetBuiltInPrototypeMethod () {
	if (hasRequiredGetBuiltInPrototypeMethod) return getBuiltInPrototypeMethod;
	hasRequiredGetBuiltInPrototypeMethod = 1;
	var globalThis =  requireGlobalThis();
	var path =  requirePath();
	getBuiltInPrototypeMethod = function (CONSTRUCTOR, METHOD) {
	  var Namespace = path[CONSTRUCTOR + 'Prototype'];
	  var pureMethod = Namespace && Namespace[METHOD];
	  if (pureMethod) return pureMethod;
	  var NativeConstructor = globalThis[CONSTRUCTOR];
	  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
	  return NativePrototype && NativePrototype[METHOD];
	};
	return getBuiltInPrototypeMethod;
}

var includes$4;
var hasRequiredIncludes$4;
function requireIncludes$4 () {
	if (hasRequiredIncludes$4) return includes$4;
	hasRequiredIncludes$4 = 1;
	requireEs_array_includes();
	var getBuiltInPrototypeMethod =  requireGetBuiltInPrototypeMethod();
	includes$4 = getBuiltInPrototypeMethod('Array', 'includes');
	return includes$4;
}

var es_string_includes = {};

var isRegexp;
var hasRequiredIsRegexp;
function requireIsRegexp () {
	if (hasRequiredIsRegexp) return isRegexp;
	hasRequiredIsRegexp = 1;
	var isObject =  requireIsObject();
	var classof =  requireClassofRaw();
	var wellKnownSymbol =  requireWellKnownSymbol();
	var MATCH = wellKnownSymbol('match');
	isRegexp = function (it) {
	  var isRegExp;
	  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classof(it) === 'RegExp');
	};
	return isRegexp;
}

var notARegexp;
var hasRequiredNotARegexp;
function requireNotARegexp () {
	if (hasRequiredNotARegexp) return notARegexp;
	hasRequiredNotARegexp = 1;
	var isRegExp =  requireIsRegexp();
	var $TypeError = TypeError;
	notARegexp = function (it) {
	  if (isRegExp(it)) {
	    throw new $TypeError("The method doesn't accept regular expressions");
	  } return it;
	};
	return notARegexp;
}

var correctIsRegexpLogic;
var hasRequiredCorrectIsRegexpLogic;
function requireCorrectIsRegexpLogic () {
	if (hasRequiredCorrectIsRegexpLogic) return correctIsRegexpLogic;
	hasRequiredCorrectIsRegexpLogic = 1;
	var wellKnownSymbol =  requireWellKnownSymbol();
	var MATCH = wellKnownSymbol('match');
	correctIsRegexpLogic = function (METHOD_NAME) {
	  var regexp = /./;
	  try {
	    '/./'[METHOD_NAME](regexp);
	  } catch (error1) {
	    try {
	      regexp[MATCH] = false;
	      return '/./'[METHOD_NAME](regexp);
	    } catch (error2) {  }
	  } return false;
	};
	return correctIsRegexpLogic;
}

var hasRequiredEs_string_includes;
function requireEs_string_includes () {
	if (hasRequiredEs_string_includes) return es_string_includes;
	hasRequiredEs_string_includes = 1;
	var $ =  require_export();
	var uncurryThis =  requireFunctionUncurryThis();
	var notARegExp =  requireNotARegexp();
	var requireObjectCoercible =  requireRequireObjectCoercible();
	var toString =  requireToString();
	var correctIsRegExpLogic =  requireCorrectIsRegexpLogic();
	var stringIndexOf = uncurryThis(''.indexOf);
	$({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
	  includes: function includes(searchString ) {
	    return !!~stringIndexOf(
	      toString(requireObjectCoercible(this)),
	      toString(notARegExp(searchString)),
	      arguments.length > 1 ? arguments[1] : undefined
	    );
	  }
	});
	return es_string_includes;
}

var includes$3;
var hasRequiredIncludes$3;
function requireIncludes$3 () {
	if (hasRequiredIncludes$3) return includes$3;
	hasRequiredIncludes$3 = 1;
	requireEs_string_includes();
	var getBuiltInPrototypeMethod =  requireGetBuiltInPrototypeMethod();
	includes$3 = getBuiltInPrototypeMethod('String', 'includes');
	return includes$3;
}

var includes$2;
var hasRequiredIncludes$2;
function requireIncludes$2 () {
	if (hasRequiredIncludes$2) return includes$2;
	hasRequiredIncludes$2 = 1;
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var arrayMethod =  requireIncludes$4();
	var stringMethod =  requireIncludes$3();
	var ArrayPrototype = Array.prototype;
	var StringPrototype = String.prototype;
	includes$2 = function (it) {
	  var own = it.includes;
	  if (it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.includes)) return arrayMethod;
	  if (typeof it == 'string' || it === StringPrototype || (isPrototypeOf(StringPrototype, it) && own === StringPrototype.includes)) {
	    return stringMethod;
	  } return own;
	};
	return includes$2;
}

var includes$1;
var hasRequiredIncludes$1;
function requireIncludes$1 () {
	if (hasRequiredIncludes$1) return includes$1;
	hasRequiredIncludes$1 = 1;
	var parent =  requireIncludes$2();
	includes$1 = parent;
	return includes$1;
}

var includes;
var hasRequiredIncludes;
function requireIncludes () {
	if (hasRequiredIncludes) return includes;
	hasRequiredIncludes = 1;
	includes =  requireIncludes$1();
	return includes;
}

var includesExports = requireIncludes();
var _includesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(includesExports);

var values$3;
var hasRequiredValues$3;
function requireValues$3 () {
	if (hasRequiredValues$3) return values$3;
	hasRequiredValues$3 = 1;
	requireEs_array_iterator();
	var getBuiltInPrototypeMethod =  requireGetBuiltInPrototypeMethod();
	values$3 = getBuiltInPrototypeMethod('Array', 'values');
	return values$3;
}

var values$2;
var hasRequiredValues$2;
function requireValues$2 () {
	if (hasRequiredValues$2) return values$2;
	hasRequiredValues$2 = 1;
	var parent =  requireValues$3();
	values$2 = parent;
	return values$2;
}

var values$1;
var hasRequiredValues$1;
function requireValues$1 () {
	if (hasRequiredValues$1) return values$1;
	hasRequiredValues$1 = 1;
	requireWeb_domCollections_iterator();
	var classof =  requireClassof();
	var hasOwn =  requireHasOwnProperty();
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var method =  requireValues$2();
	var ArrayPrototype = Array.prototype;
	var DOMIterables = {
	  DOMTokenList: true,
	  NodeList: true
	};
	values$1 = function (it) {
	  var own = it.values;
	  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.values)
	    || hasOwn(DOMIterables, classof(it)) ? method : own;
	};
	return values$1;
}

var values;
var hasRequiredValues;
function requireValues () {
	if (hasRequiredValues) return values;
	hasRequiredValues = 1;
	values =  requireValues$1();
	return values;
}

var valuesExports = requireValues();
var _valuesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(valuesExports);

/**
 * Encoder interface mode
 * @public
 */
var EncoderIOMode;
(function (EncoderIOMode) {
  /**
   * No additional pull-up or pull-down resistors will be applied to the input lines.
   * @public
   */
  EncoderIOMode[EncoderIOMode["PUSH_PULL"] = 1] = "PUSH_PULL";
  /**
   * 2.2kΩ pull-down resistors will be applied to the input lines.
   * @public
   */
  EncoderIOMode[EncoderIOMode["LINE_DRIVER_2K2"] = 2] = "LINE_DRIVER_2K2";
  /**
   * 10kΩ pull-down resistors will be applied to the input lines.
   * @public
   */
  EncoderIOMode[EncoderIOMode["LINE_DRIVER_10K"] = 3] = "LINE_DRIVER_10K";
  /**
   * 2.2kΩ pull-up resistors will be applied to the input lines.
   * @public
   */
  EncoderIOMode[EncoderIOMode["OPEN_COLLECTOR_2K2"] = 4] = "OPEN_COLLECTOR_2K2";
  /**
   * 10kΩ pull-up resistors will be applied to the input lines.
   * @public
   */
  EncoderIOMode[EncoderIOMode["OPEN_COLLECTOR_10K"] = 5] = "OPEN_COLLECTOR_10K";
})(EncoderIOMode || (EncoderIOMode = {}));
/**
 * Error codes returned from all API calls via Exceptions.
 * @public
 */
var ErrorCode;
(function (ErrorCode) {
  /**
   * Call succeeded.
   * @public
   */
  ErrorCode[ErrorCode["SUCCESS"] = 0] = "SUCCESS";
  /**
   * Not Permitted
   * @public
   */
  ErrorCode[ErrorCode["NOT_PERMITTED"] = 1] = "NOT_PERMITTED";
  /**
   * The specified entity does not exist. This is usually a result of Net or Log API calls.
   * @public
   */
  ErrorCode[ErrorCode["NO_SUCH_ENTITY"] = 2] = "NO_SUCH_ENTITY";
  /**
   * Call has timed out. This can happen for a number of common reasons: Check that the Phidget you are trying to open is plugged in, and that the addressing parameters have been specified correctly. Check that the Phidget is not already open in another program, such as the Phidget Control Panel, or another program you are developing. If your Phidget has a plug or terminal block for external power, ensure it is plugged in and powered. If you are using remote Phidgets, ensure that your computer can access the remote Phidgets using the Phidget Control Panel. If you are using remote Phidgets, ensure you have enabled Server Discovery or added the server corresponding to the Phidget you are trying to open. If you are using Network Server Discovery, try extending the timeout to allow more time for the server to be discovered.
   * @public
   */
  ErrorCode[ErrorCode["TIMEOUT"] = 3] = "TIMEOUT";
  /**
   * Keep Alive Failure
   * @public
   */
  ErrorCode[ErrorCode["KEEP_ALIVE"] = 58] = "KEEP_ALIVE";
  /**
   * The operation was interrupted; either from an error, or because the device was closed.
   * @public
   */
  ErrorCode[ErrorCode["INTERRUPTED"] = 4] = "INTERRUPTED";
  /**
   * IO Issue
   * @public
   */
  ErrorCode[ErrorCode["IO"] = 5] = "IO";
  /**
   * Memory Issue
   * @public
   */
  ErrorCode[ErrorCode["NO_MEMORY"] = 6] = "NO_MEMORY";
  /**
   * Access to the resource (file) is denied. This can happen when enabling logging.
   * @public
   */
  ErrorCode[ErrorCode["ACCESS"] = 7] = "ACCESS";
  /**
   * Address Issue
   * @public
   */
  ErrorCode[ErrorCode["FAULT"] = 8] = "FAULT";
  /**
   * Specified resource is in use. This error code is not normally used.
   * @public
   */
  ErrorCode[ErrorCode["BUSY"] = 9] = "BUSY";
  /**
   * Object Exists
   * @public
   */
  ErrorCode[ErrorCode["EXISTS"] = 10] = "EXISTS";
  /**
   * Object is not a directory
   * @public
   */
  ErrorCode[ErrorCode["IS_NOT_DIRECTORY"] = 11] = "IS_NOT_DIRECTORY";
  /**
   * Object is a directory
   * @public
   */
  ErrorCode[ErrorCode["IS_DIRECTORY"] = 12] = "IS_DIRECTORY";
  /**
   * Invalid or malformed command. This can be caused by sending a command to a device which is not supported in it's current configuration.
   * @public
   */
  ErrorCode[ErrorCode["INVALID"] = 13] = "INVALID";
  /**
   * Too many open files in system
   * @public
   */
  ErrorCode[ErrorCode["TOO_MANY_FILES_SYSTEM"] = 14] = "TOO_MANY_FILES_SYSTEM";
  /**
   * Too many open files
   * @public
   */
  ErrorCode[ErrorCode["TOO_MANY_FILES"] = 15] = "TOO_MANY_FILES";
  /**
   * The provided buffer argument size is too small.
   * @public
   */
  ErrorCode[ErrorCode["NO_SPACE"] = 16] = "NO_SPACE";
  /**
   * File too Big
   * @public
   */
  ErrorCode[ErrorCode["FILE_TOO_BIG"] = 17] = "FILE_TOO_BIG";
  /**
   * Read Only Filesystem
   * @public
   */
  ErrorCode[ErrorCode["READ_ONLY_FILESYSTEM"] = 18] = "READ_ONLY_FILESYSTEM";
  /**
   * Read Only Object
   * @public
   */
  ErrorCode[ErrorCode["READ_ONLY"] = 19] = "READ_ONLY";
  /**
   * This API call is not supported. For Class APIs this means that this API is not supported by this device. This can also mean the API is not supported on this OS, or OS configuration.
   * @public
   */
  ErrorCode[ErrorCode["UNSUPPORTED"] = 20] = "UNSUPPORTED";
  /**
   * One or more of the parameters passed to the function is not accepted by the channel in its current configuration.
   * @public
   */
  ErrorCode[ErrorCode["INVALID_ARGUMENT"] = 21] = "INVALID_ARGUMENT";
  /**
   * Try again
   * @public
   */
  ErrorCode[ErrorCode["TRY_AGAIN"] = 22] = "TRY_AGAIN";
  /**
   * Not Empty
   * @public
   */
  ErrorCode[ErrorCode["NOT_EMPTY"] = 26] = "NOT_EMPTY";
  /**
   * Something unexpected has occured. Enable library logging and have a look at the log, or contact Phidgets support.
   * @public
   */
  ErrorCode[ErrorCode["UNEXPECTED"] = 28] = "UNEXPECTED";
  /**
   * Duplicated request. Can happen with some Net API calls, such as trying to add the same server twice.
   * @public
   */
  ErrorCode[ErrorCode["DUPLICATE"] = 27] = "DUPLICATE";
  /**
   * Bad Credential
   * @public
   */
  ErrorCode[ErrorCode["BAD_PASSWORD"] = 37] = "BAD_PASSWORD";
  /**
   * Network Unavailable
   * @public
   */
  ErrorCode[ErrorCode["NETWORK_UNAVAILABLE"] = 45] = "NETWORK_UNAVAILABLE";
  /**
   * Connection Refused
   * @public
   */
  ErrorCode[ErrorCode["CONNECTION_REFUSED"] = 35] = "CONNECTION_REFUSED";
  /**
   * Connection Reset
   * @public
   */
  ErrorCode[ErrorCode["CONNECTION_RESET"] = 46] = "CONNECTION_RESET";
  /**
   * No route to host
   * @public
   */
  ErrorCode[ErrorCode["HOST_UNREACHABLE"] = 48] = "HOST_UNREACHABLE";
  /**
   * No Such Device
   * @public
   */
  ErrorCode[ErrorCode["NO_SUCH_DEVICE"] = 40] = "NO_SUCH_DEVICE";
  /**
   * A Phidget channel object of the wrong channel class was passed into this API call.
   * @public
   */
  ErrorCode[ErrorCode["WRONG_DEVICE"] = 50] = "WRONG_DEVICE";
  /**
   * Broken Pipe
   * @public
   */
  ErrorCode[ErrorCode["BROKEN_PIPE"] = 41] = "BROKEN_PIPE";
  /**
   * Name Resolution Failure
   * @public
   */
  ErrorCode[ErrorCode["NAME_RESOLUTION_FAILURE"] = 44] = "NAME_RESOLUTION_FAILURE";
  /**
   * The value is unknown. This can happen right after attach, when the value has not yet been received from the Phidget. This can also happen if a device has not yet been configured / enabled. Some properties can only be read back after being set.
   * @public
   */
  ErrorCode[ErrorCode["UNKNOWN_VALUE"] = 51] = "UNKNOWN_VALUE";
  /**
   * This can happen for a number of common reasons. Be sure you are opening the channel before trying to use it. If you are opening the channel, the program may not be waiting for the channel to be attached. If possible use openWaitForAttachment. Otherwise, be sure to check the Attached property of the channel before trying to use it.
   * @public
   */
  ErrorCode[ErrorCode["NOT_ATTACHED"] = 52] = "NOT_ATTACHED";
  /**
   * Invalid or Unexpected Packet
   * @public
   */
  ErrorCode[ErrorCode["INVALID_PACKET"] = 53] = "INVALID_PACKET";
  /**
   * Argument List Too Long
   * @public
   */
  ErrorCode[ErrorCode["TOO_BIG"] = 54] = "TOO_BIG";
  /**
   * Bad Version
   * @public
   */
  ErrorCode[ErrorCode["BAD_VERSION"] = 55] = "BAD_VERSION";
  /**
   * Channel was closed. This can happen if a channel is closed while openWaitForAttachment is waiting.
   * @public
   */
  ErrorCode[ErrorCode["CLOSED"] = 56] = "CLOSED";
  /**
   * Device is not configured enough for this API call. Have a look at the must-set properties for this device and make sure to configure them first.
   * @public
   */
  ErrorCode[ErrorCode["NOT_CONFIGURED"] = 57] = "NOT_CONFIGURED";
  /**
   * End of File
   * @public
   */
  ErrorCode[ErrorCode["END_OF_FILE"] = 31] = "END_OF_FILE";
  /**
   * Failsafe Triggered on this channel. Close and Re-open the channel to resume operation.
   * @public
   */
  ErrorCode[ErrorCode["FAILSAFE"] = 59] = "FAILSAFE";
  /**
   * The value has been measured to be higher than the valid range of the sensor.
   * @public
   */
  ErrorCode[ErrorCode["UNKNOWN_VALUE_HIGH"] = 60] = "UNKNOWN_VALUE_HIGH";
  /**
   * The value has been measured to be lower than the valid range of the sensor.
   * @public
   */
  ErrorCode[ErrorCode["UNKNOWN_VALUE_LOW"] = 61] = "UNKNOWN_VALUE_LOW";
  /**
   * The power supply of your device is outside the acceptable range to allow operation.
   * @public
   */
  ErrorCode[ErrorCode["BAD_POWER"] = 62] = "BAD_POWER";
  /**
   * Something has caused your device to decide it needs to be powered off and on to resume operation.
   * @public
   */
  ErrorCode[ErrorCode["POWER_CYCLE"] = 63] = "POWER_CYCLE";
  /**
   * The hall sensor on your Brushless DC Motor Controller is Improperly Connected
   * @public
   */
  ErrorCode[ErrorCode["HALLSENSOR"] = 64] = "HALLSENSOR";
  /**
   * Current sensor offset outside acceptable bounds. Move the sensor aways from magnetic fields and try again.
   * @public
   */
  ErrorCode[ErrorCode["BADCURRENT"] = 65] = "BADCURRENT";
  /**
   * One or more required connections on the device has been deemed faulty. Check your connections and try again.
   * @public
   */
  ErrorCode[ErrorCode["BADCONNECTION"] = 66] = "BADCONNECTION";
  /**
   * An external device has responded with a NACK response. Evaluate whether this is expected and try again.
   * @public
   */
  ErrorCode[ErrorCode["NACK"] = 67] = "NACK";
})(ErrorCode || (ErrorCode = {}));
/**
 * The error code from an Error event
 * @public
 */
var ErrorEventCode;
(function (ErrorEventCode) {
  /**
   * Client and Server protocol versions don't match. Ensure that both sides are using the same release of phidget22.
   * @public
   */
  ErrorEventCode[ErrorEventCode["BAD_VERSION"] = 1] = "BAD_VERSION";
  /**
   * Check that the Phidget is not already open in another program, such as the Phidget Control Panel, or another program you are developing.
   * @public
   */
  ErrorEventCode[ErrorEventCode["BUSY"] = 2] = "BUSY";
  /**
   * This could be a network communication issue, an authentication issue (if server password is enabled), or a Device access / hardware issue.
   * @public
   */
  ErrorEventCode[ErrorEventCode["NETWORK"] = 3] = "NETWORK";
  /**
   * An error occured dispatching a command or event.
   * @public
   */
  ErrorEventCode[ErrorEventCode["DISPATCH"] = 4] = "DISPATCH";
  /**
   * A general failure occured - see description for details.
   * @public
   */
  ErrorEventCode[ErrorEventCode["FAILURE"] = 5] = "FAILURE";
  /**
   * An error state has cleared.
   * @public
   */
  ErrorEventCode[ErrorEventCode["SUCCESS"] = 4096] = "SUCCESS";
  /**
   * A sampling overrun happened in firmware.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OVERRUN"] = 4098] = "OVERRUN";
  /**
   * One or more packets were lost.
   * @public
   */
  ErrorEventCode[ErrorEventCode["PACKET_LOST"] = 4099] = "PACKET_LOST";
  /**
   * Variable has wrapped around.
   * @public
   */
  ErrorEventCode[ErrorEventCode["WRAP_AROUND"] = 4100] = "WRAP_AROUND";
  /**
   * Over-temperature condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OVER_TEMPERATURE"] = 4101] = "OVER_TEMPERATURE";
  /**
   * Over-current condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OVER_CURRENT"] = 4102] = "OVER_CURRENT";
  /**
   * Out of range condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OUT_OF_RANGE"] = 4103] = "OUT_OF_RANGE";
  /**
   * Power supply problem detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["BAD_POWER"] = 4104] = "BAD_POWER";
  /**
   * Saturation condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["SATURATION"] = 4105] = "SATURATION";
  /**
   * Over-voltage condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OVER_VOLTAGE"] = 4107] = "OVER_VOLTAGE";
  /**
   * Failsafe condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["FAILSAFE_CONDITION"] = 4108] = "FAILSAFE_CONDITION";
  /**
   * Voltage error detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["VOLTAGE_ERROR"] = 4109] = "VOLTAGE_ERROR";
  /**
   * Energy dump condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["ENERGY_DUMP_CONDITION"] = 4110] = "ENERGY_DUMP_CONDITION";
  /**
   * Motor stall detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["MOTOR_STALL_CONDITION"] = 4111] = "MOTOR_STALL_CONDITION";
  /**
   * Invalid state detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["INVALID_STATE_CONDITION"] = 4112] = "INVALID_STATE_CONDITION";
  /**
   * Bad connection detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["BAD_CONNECTION_CONDITION"] = 4113] = "BAD_CONNECTION_CONDITION";
  /**
   * Measurement is above the valid range.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OUT_OF_RANGE_HIGH_CONDITION"] = 4114] = "OUT_OF_RANGE_HIGH_CONDITION";
  /**
   * Measurement is below the valid range.
   * @public
   */
  ErrorEventCode[ErrorEventCode["OUT_OF_RANGE_LOW_CONDITION"] = 4115] = "OUT_OF_RANGE_LOW_CONDITION";
  /**
   * Fault condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["FAULT"] = 4116] = "FAULT";
  /**
   * External stop condition detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["ESTOP"] = 4117] = "ESTOP";
  /**
   * Current sensor problem detected.
   * @public
   */
  ErrorEventCode[ErrorEventCode["BAD_CURRENT"] = 4118] = "BAD_CURRENT";
})(ErrorEventCode || (ErrorEventCode = {}));
/**
 * Phidget device ID
 * @public
 */
var DeviceID;
(function (DeviceID) {
  /**
   * Unknown device
   * @internal
   */
  DeviceID[DeviceID["NONE"] = 0] = "NONE";
  /**
   * Unknown Device
   * @public
   */
  DeviceID[DeviceID["UNKNOWN"] = 125] = "UNKNOWN";
  /**
   * Hub Port - Digital Input mode
   * @public
   */
  DeviceID[DeviceID["DIGITAL_INPUT_PORT"] = 95] = "DIGITAL_INPUT_PORT";
  /**
   * Hub Port - Digital Output mode
   * @public
   */
  DeviceID[DeviceID["DIGITAL_OUTPUT_PORT"] = 96] = "DIGITAL_OUTPUT_PORT";
  /**
   * Hub Port - Voltage Input mode
   * @public
   */
  DeviceID[DeviceID["VOLTAGE_INPUT_PORT"] = 97] = "VOLTAGE_INPUT_PORT";
  /**
   * Hub Port - Voltage Ratio Input mode
   * @public
   */
  DeviceID[DeviceID["VOLTAGE_RATIO_INPUT_PORT"] = 98] = "VOLTAGE_RATIO_INPUT_PORT";
  /**
   * Dictionary
   * @public
   */
  DeviceID[DeviceID["PN_DICTIONARY"] = 111] = "PN_DICTIONARY";
  /**
   * PhidgetServo 1-Motor (1000)
   * @public
   */
  DeviceID[DeviceID["PN_1000"] = 2] = "PN_1000";
  /**
   * PhidgetServo 4-Motor (1001)
   * @public
   */
  DeviceID[DeviceID["PN_1001"] = 3] = "PN_1001";
  /**
   * PhidgetAnalog 4-Output (1002)
   * @public
   */
  DeviceID[DeviceID["PN_1002"] = 4] = "PN_1002";
  /**
   * PhidgetAccelerometer 2-Axis (1008)
   * @public
   */
  DeviceID[DeviceID["PN_1008"] = 5] = "PN_1008";
  /**
   * PhidgetInterfaceKit 8/8/8 (1010, 1013, 1018, 1019)
   * @public
   */
  DeviceID[DeviceID["PN_1010_1013_1018_1019"] = 6] = "PN_1010_1013_1018_1019";
  /**
   * PhidgetInterfaceKit 2/2/2 (1011)
   * @public
   */
  DeviceID[DeviceID["PN_1011"] = 7] = "PN_1011";
  /**
   * PhidgetInterfaceKit 0/16/16 (1012)
   * @public
   */
  DeviceID[DeviceID["PN_1012"] = 8] = "PN_1012";
  /**
   * PhidgetInterfaceKit 0/0/4 (1014)
   * @public
   */
  DeviceID[DeviceID["PN_1014"] = 9] = "PN_1014";
  /**
   * PhidgetLinearTouch (1015)
   * @public
   */
  DeviceID[DeviceID["PN_1015"] = 10] = "PN_1015";
  /**
   * PhidgetCircularTouch (1016)
   * @public
   */
  DeviceID[DeviceID["PN_1016"] = 11] = "PN_1016";
  /**
   * PhidgetInterfaceKit 0/0/8 (1017)
   * @public
   */
  DeviceID[DeviceID["PN_1017"] = 12] = "PN_1017";
  /**
   * PhidgetRFID (1023)
   * @public
   */
  DeviceID[DeviceID["PN_1023"] = 13] = "PN_1023";
  /**
   * PhidgetRFID Read-Write (1024)
   * @public
   */
  DeviceID[DeviceID["PN_1024"] = 14] = "PN_1024";
  /**
   * PhidgetLED-64 (1030)
   * @public
   */
  DeviceID[DeviceID["PN_1030"] = 15] = "PN_1030";
  /**
   * PhidgetLED-64 Advanced (1031)
   * @public
   */
  DeviceID[DeviceID["PN_1031"] = 16] = "PN_1031";
  /**
   * PhidgetLED-64 Advanced (1032)
   * @public
   */
  DeviceID[DeviceID["PN_1032"] = 17] = "PN_1032";
  /**
   * PhidgetGPS (1040)
   * @public
   */
  DeviceID[DeviceID["PN_1040"] = 18] = "PN_1040";
  /**
   * PhidgetSpatial 0/0/3 Basic (1041)
   * @public
   */
  DeviceID[DeviceID["PN_1041"] = 19] = "PN_1041";
  /**
   * PhidgetSpatial 3/3/3 Basic (1042)
   * @public
   */
  DeviceID[DeviceID["PN_1042"] = 20] = "PN_1042";
  /**
   * PhidgetSpatial Precision 0/0/3 High Resolution (1043)
   * @public
   */
  DeviceID[DeviceID["PN_1043"] = 21] = "PN_1043";
  /**
   * PhidgetSpatial Precision 3/3/3 High Resolution (1044)
   * @public
   */
  DeviceID[DeviceID["PN_1044"] = 22] = "PN_1044";
  /**
   * PhidgetTemperatureSensor IR (1045)
   * @public
   */
  DeviceID[DeviceID["PN_1045"] = 23] = "PN_1045";
  /**
   * PhidgetBridge 4-Input (1046)
   * @public
   */
  DeviceID[DeviceID["PN_1046"] = 24] = "PN_1046";
  /**
   * PhidgetEncoder HighSpeed 4-Input (1047)
   * @public
   */
  DeviceID[DeviceID["PN_1047"] = 25] = "PN_1047";
  /**
   * PhidgetTemperatureSensor 4-Input (1048)
   * @public
   */
  DeviceID[DeviceID["PN_1048"] = 26] = "PN_1048";
  /**
   * PhidgetSpatial 0/0/3 (1049)
   * @public
   */
  DeviceID[DeviceID["PN_1049"] = 27] = "PN_1049";
  /**
   * PhidgetTemperatureSensor 1-Input (1051)
   * @public
   */
  DeviceID[DeviceID["PN_1051"] = 28] = "PN_1051";
  /**
   * PhidgetEncoder (1052)
   * @public
   */
  DeviceID[DeviceID["PN_1052"] = 29] = "PN_1052";
  /**
   * PhidgetAccelerometer 2-Axis (1053)
   * @public
   */
  DeviceID[DeviceID["PN_1053"] = 30] = "PN_1053";
  /**
   * PhidgetFrequencyCounter (1054)
   * @public
   */
  DeviceID[DeviceID["PN_1054"] = 31] = "PN_1054";
  /**
   * PhidgetIR (1055)
   * @public
   */
  DeviceID[DeviceID["PN_1055"] = 32] = "PN_1055";
  /**
   * PhidgetSpatial 3/3/3 (1056)
   * @public
   */
  DeviceID[DeviceID["PN_1056"] = 33] = "PN_1056";
  /**
   * PhidgetEncoder HighSpeed (1057)
   * @public
   */
  DeviceID[DeviceID["PN_1057"] = 34] = "PN_1057";
  /**
   * PhidgetPHSensor (1058)
   * @public
   */
  DeviceID[DeviceID["PN_1058"] = 35] = "PN_1058";
  /**
   * PhidgetAccelerometer 3-Axis (1059)
   * @public
   */
  DeviceID[DeviceID["PN_1059"] = 36] = "PN_1059";
  /**
   * PhidgetMotorControl LV (1060)
   * @public
   */
  DeviceID[DeviceID["PN_1060"] = 37] = "PN_1060";
  /**
   * PhidgetAdvancedServo 8-Motor (1061)
   * @public
   */
  DeviceID[DeviceID["PN_1061"] = 38] = "PN_1061";
  /**
   * PhidgetStepper Unipolar 4-Motor (1062)
   * @public
   */
  DeviceID[DeviceID["PN_1062"] = 39] = "PN_1062";
  /**
   * PhidgetStepper Bipolar 1-Motor (1063)
   * @public
   */
  DeviceID[DeviceID["PN_1063"] = 40] = "PN_1063";
  /**
   * PhidgetMotorControl HC (1064)
   * @public
   */
  DeviceID[DeviceID["PN_1064"] = 41] = "PN_1064";
  /**
   * PhidgetMotorControl 1-Motor (1065)
   * @public
   */
  DeviceID[DeviceID["PN_1065"] = 42] = "PN_1065";
  /**
   * PhidgetAdvancedServo 1-Motor (1066)
   * @public
   */
  DeviceID[DeviceID["PN_1066"] = 43] = "PN_1066";
  /**
   * PhidgetStepper Bipolar HC (1067)
   * @public
   */
  DeviceID[DeviceID["PN_1067"] = 44] = "PN_1067";
  /**
   * PhidgetTextLCD 20x2 with PhidgetInterfaceKit 8/8/8 (1202, 1203)
   * @public
   */
  DeviceID[DeviceID["PN_1202_1203"] = 45] = "PN_1202_1203";
  /**
   * PhidgetTextLCD Adapter (1204)
   * @public
   */
  DeviceID[DeviceID["PN_1204"] = 46] = "PN_1204";
  /**
   * PhidgetTextLCD 20x2 (1215, 1216, 1217, 1218)
   * @public
   */
  DeviceID[DeviceID["PN_1215__1218"] = 47] = "PN_1215__1218";
  /**
   * PhidgetTextLCD 20x2 with PhidgetInterfaceKit 0/8/8 (1219, 1220, 1221, 1222)
   * @public
   */
  DeviceID[DeviceID["PN_1219__1222"] = 48] = "PN_1219__1222";
  /**
   * I2C Adapter Phidget
   * @public
   */
  DeviceID[DeviceID["PN_ADP0001"] = 134] = "PN_ADP0001";
  /**
   * SPI Adapter Phidget
   * @public
   */
  DeviceID[DeviceID["PN_ADP0002"] = 160] = "PN_ADP0002";
  /**
   * pH Adapter Phidget (ADP1000)
   * @public
   */
  DeviceID[DeviceID["PN_ADP1000"] = 49] = "PN_ADP1000";
  /**
   * 8x Voltage Input Phidget (DAQ1000)
   * @public
   */
  DeviceID[DeviceID["PN_DAQ1000"] = 51] = "PN_DAQ1000";
  /**
   * 4x Digital Input Phidget (DAQ1200)
   * @public
   */
  DeviceID[DeviceID["PN_DAQ1200"] = 52] = "PN_DAQ1200";
  /**
   * 4x Isolated Digital Input Phidget (DAQ1300)
   * @public
   */
  DeviceID[DeviceID["PN_DAQ1300"] = 53] = "PN_DAQ1300";
  /**
   * 16x Isolated Digital Input Phidget (DAQ1301)
   * @public
   */
  DeviceID[DeviceID["PN_DAQ1301"] = 54] = "PN_DAQ1301";
  /**
   * Versatile Input Phidget (DAQ1400)
   * @public
   */
  DeviceID[DeviceID["PN_DAQ1400"] = 55] = "PN_DAQ1400";
  /**
   * Wheatstone Bridge Phidget (DAQ1500)
   * @public
   */
  DeviceID[DeviceID["PN_DAQ1500"] = 56] = "PN_DAQ1500";
  /**
   * DC Motor Phidget (DCC1000)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1000"] = 57] = "PN_DCC1000";
  /**
   * 2A DC Motor Phidget (DCC1001)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1001"] = 110] = "PN_DCC1001";
  /**
   * 4A DC Motor Phidget (DCC1002)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1002"] = 117] = "PN_DCC1002";
  /**
   * 2x DC Motor Phidget (DCC1003)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1003"] = 120] = "PN_DCC1003";
  /**
   * 30V 50A DC Motor Phidget (DCC1020)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1020"] = 128] = "PN_DCC1020";
  /**
   * 60V 50A DC Motor Phidget (DCC1030)
   * @internal
   */
  DeviceID[DeviceID["PN_DCC1030"] = 152] = "PN_DCC1030";
  /**
   * Brushless DC Motor Phidget (DCC1100)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1100"] = 108] = "PN_DCC1100";
  /**
   * 30V 50A Brushless DC Motor Phidget (DCC1120)
   * @public
   */
  DeviceID[DeviceID["PN_DCC1120"] = 150] = "PN_DCC1120";
  /**
   * 60V 50A Brushless DC Motor Phidget (DCC1130)
   * @internal
   */
  DeviceID[DeviceID["PN_DCC1130"] = 154] = "PN_DCC1130";
  /**
   * Distance Phidget (DST1000)
   * @public
   */
  DeviceID[DeviceID["PN_DST1000"] = 58] = "PN_DST1000";
  /**
   * Distance Phidget 650mm (DST1001)
   * @public
   */
  DeviceID[DeviceID["PN_DST1001"] = 121] = "PN_DST1001";
  /**
   * Distance Phidget 1300mm (DST1002)
   * @public
   */
  DeviceID[DeviceID["PN_DST1002"] = 126] = "PN_DST1002";
  /**
   * Sonar Phidget (DST1200)
   * @public
   */
  DeviceID[DeviceID["PN_DST1200"] = 59] = "PN_DST1200";
  /**
   * Quadrature Encoder Phidget (ENC1000)
   * @public
   */
  DeviceID[DeviceID["PN_ENC1000"] = 60] = "PN_ENC1000";
  /**
   * Quadrature Encoder Phidget (ENC1001)
   * @public
   */
  DeviceID[DeviceID["PN_ENC1001"] = 155] = "PN_ENC1001";
  /**
   * SPI Phidget in firmware upgrade mode
   * @internal
   */
  DeviceID[DeviceID["FIRMWARE_UPGRADE_SPI"] = 104] = "FIRMWARE_UPGRADE_SPI";
  /**
   * VINT Phidget in firmware upgrade mode, STM32F0 Proc.
   * @internal
   */
  DeviceID[DeviceID["FIRMWARE_UPGRADE_STM32F0"] = 102] = "FIRMWARE_UPGRADE_STM32F0";
  /**
   * VINT Phidget in firmware upgrade mode, STM32F3 Proc.
   * @internal
   */
  DeviceID[DeviceID["FIRMWARE_UPGRADE_STM32F3"] = 145] = "FIRMWARE_UPGRADE_STM32F3";
  /**
   * VINT Phidget in firmware upgrade mode, STM32G0 Proc.
   * @internal
   */
  DeviceID[DeviceID["FIRMWARE_UPGRADE_STM32G0"] = 143] = "FIRMWARE_UPGRADE_STM32G0";
  /**
   * VINT Phidget in firmware upgrade mode, STM8S Proc.
   * @internal
   */
  DeviceID[DeviceID["FIRMWARE_UPGRADE_STM8S"] = 103] = "FIRMWARE_UPGRADE_STM8S";
  /**
   * USB Phidget in firmware upgrade mode
   * @internal
   */
  DeviceID[DeviceID["FIRMWARE_UPGRADE_USB"] = 101] = "FIRMWARE_UPGRADE_USB";
  /**
   * Touch Keypad Phidget (HIN1000)
   * @public
   */
  DeviceID[DeviceID["PN_HIN1000"] = 61] = "PN_HIN1000";
  /**
   * Touch Wheel Phidget (HIN1001)
   * @public
   */
  DeviceID[DeviceID["PN_HIN1001"] = 62] = "PN_HIN1001";
  /**
   * Thumbstick Phidget (HIN1100)
   * @public
   */
  DeviceID[DeviceID["PN_HIN1100"] = 63] = "PN_HIN1100";
  /**
   * Phidget Dial (HIN1101)
   * @public
   */
  DeviceID[DeviceID["PN_HIN1101"] = 109] = "PN_HIN1101";
  /**
   * 6-Port USB VINT Hub Phidget (HUB0000)
   * @public
   */
  DeviceID[DeviceID["PN_HUB0000"] = 64] = "PN_HUB0000";
  /**
   * 6-Port USB VINT Hub Phidget (HUB0001)
   * @public
   */
  DeviceID[DeviceID["PN_HUB0001"] = 142] = "PN_HUB0001";
  /**
   * 6-Port USB VINT Hub Phidget (HUB0002)
   * @public
   */
  DeviceID[DeviceID["PN_HUB0002"] = 147] = "PN_HUB0002";
  /**
   * 6-Port PhidgetSBC VINT Hub Phidget (HUB0004)
   * @public
   */
  DeviceID[DeviceID["PN_HUB0004"] = 67] = "PN_HUB0004";
  /**
   * 1-Port USB VINT Hub Phidget (HUB0007)
   * @public
   */
  DeviceID[DeviceID["PN_HUB0007"] = 148] = "PN_HUB0007";
  /**
   * 6-Port Network VINT Hub Phidget (HUB5000)
   * @public
   */
  DeviceID[DeviceID["PN_HUB5000"] = 123] = "PN_HUB5000";
  /**
   * Humidity Phidget (HUM1000)
   * @public
   */
  DeviceID[DeviceID["PN_HUM1000"] = 69] = "PN_HUM1000";
  /**
   * Humidity Phidget (HUM1001)
   * @public
   */
  DeviceID[DeviceID["PN_HUM1001"] = 127] = "PN_HUM1001";
  /**
   * Soil Moisture Phidget (HUM1100)
   * @public
   */
  DeviceID[DeviceID["PN_HUM1100"] = 136] = "PN_HUM1100";
  /**
   * PhidgetInterfaceKit 4/8/8
   * @internal
   */
  DeviceID[DeviceID["PN_INTERFACE_KIT488"] = 1] = "PN_INTERFACE_KIT488";
  /**
   * Graphic LCD Phidget (LCD1100)
   * @public
   */
  DeviceID[DeviceID["PN_LCD1100"] = 70] = "PN_LCD1100";
  /**
   * Addressable LED Phidget
   * @public
   */
  DeviceID[DeviceID["PN_LED0100"] = 161] = "PN_LED0100";
  /**
   * 32x Isolated LED Phidget (LED1000)
   * @public
   */
  DeviceID[DeviceID["PN_LED1000"] = 71] = "PN_LED1000";
  /**
   * Light Phidget (LUX1000)
   * @public
   */
  DeviceID[DeviceID["PN_LUX1000"] = 72] = "PN_LUX1000";
  /**
   * PhidgetAccelerometer (MOT0100)
   * @public
   */
  DeviceID[DeviceID["PN_MOT0100"] = 146] = "PN_MOT0100";
  /**
   * PhidgetSpatial Precision 3/3/3 (MOT0109)
   * @public
   */
  DeviceID[DeviceID["PN_MOT0109"] = 140] = "PN_MOT0109";
  /**
   * PhidgetSpatial Precision 3/3/3 (MOT0110)
   * @public
   */
  DeviceID[DeviceID["PN_MOT0110"] = 141] = "PN_MOT0110";
  /**
   * Accelerometer Phidget (MOT1100)
   * @public
   */
  DeviceID[DeviceID["PN_MOT1100"] = 73] = "PN_MOT1100";
  /**
   * Spatial Phidget (MOT1101)
   * @public
   */
  DeviceID[DeviceID["PN_MOT1101"] = 74] = "PN_MOT1101";
  /**
   * Spatial Phidget (MOT1102)
   * @public
   */
  DeviceID[DeviceID["PN_MOT1102"] = 137] = "PN_MOT1102";
  /**
   * 12-bit Voltage Output Phidget (OUT1000)
   * @public
   */
  DeviceID[DeviceID["PN_OUT1000"] = 75] = "PN_OUT1000";
  /**
   * Isolated 12-bit Voltage Output Phidget (OUT1001)
   * @public
   */
  DeviceID[DeviceID["PN_OUT1001"] = 76] = "PN_OUT1001";
  /**
   * Isolated 16-bit Voltage Output Phidget (OUT1002)
   * @public
   */
  DeviceID[DeviceID["PN_OUT1002"] = 77] = "PN_OUT1002";
  /**
   * 4x Digital Output Phidget (OUT1100)
   * @public
   */
  DeviceID[DeviceID["PN_OUT1100"] = 78] = "PN_OUT1100";
  /**
   * Barometer Phidget (PRE1000)
   * @public
   */
  DeviceID[DeviceID["PN_PRE1000"] = 79] = "PN_PRE1000";
  /**
   * PhidgetAdvancedServo 8-Motor (RCC0004)
   * @public
   */
  DeviceID[DeviceID["PN_RCC0004"] = 124] = "PN_RCC0004";
  /**
   * 16x RC Servo Phidget (RCC1000)
   * @public
   */
  DeviceID[DeviceID["PN_RCC1000"] = 80] = "PN_RCC1000";
  /**
   * 4x Relay Phidget (REL1000)
   * @public
   */
  DeviceID[DeviceID["PN_REL1000"] = 81] = "PN_REL1000";
  /**
   * 4x Isolated Solid State Relay Phidget (REL1100)
   * @public
   */
  DeviceID[DeviceID["PN_REL1100"] = 82] = "PN_REL1100";
  /**
   * 16x Isolated Solid State Relay Phidget (REL1101)
   * @public
   */
  DeviceID[DeviceID["PN_REL1101"] = 83] = "PN_REL1101";
  /**
   * Programmable Power Guard Phidget (SAF1000)
   * @public
   */
  DeviceID[DeviceID["PN_SAF1000"] = 84] = "PN_SAF1000";
  /**
   * Sound Phidget (SND1000)
   * @public
   */
  DeviceID[DeviceID["PN_SND1000"] = 85] = "PN_SND1000";
  /**
   * Stepper Phidget (STC1000)
   * @public
   */
  DeviceID[DeviceID["PN_STC1000"] = 86] = "PN_STC1000";
  /**
   * 2.5A Stepper Phidget (STC1001)
   * @public
   */
  DeviceID[DeviceID["PN_STC1001"] = 115] = "PN_STC1001";
  /**
   * 8A Stepper Phidget (STC1002)
   * @public
   */
  DeviceID[DeviceID["PN_STC1002"] = 118] = "PN_STC1002";
  /**
   * 4A Stepper Phidget (STC1003)
   * @public
   */
  DeviceID[DeviceID["PN_STC1003"] = 119] = "PN_STC1003";
  /**
   * 4A Stepper Phidget (STC1005)
   * @public
   */
  DeviceID[DeviceID["PN_STC1005"] = 149] = "PN_STC1005";
  /**
   * Temperature Phidget (TMP1000)
   * @public
   */
  DeviceID[DeviceID["PN_TMP1000"] = 87] = "PN_TMP1000";
  /**
   * Isolated Thermocouple Phidget (TMP1100)
   * @public
   */
  DeviceID[DeviceID["PN_TMP1100"] = 88] = "PN_TMP1100";
  /**
   * 4x Thermocouple Phidget (TMP1101)
   * @public
   */
  DeviceID[DeviceID["PN_TMP1101"] = 89] = "PN_TMP1101";
  /**
   * RTD Phidget (TMP1200)
   * @public
   */
  DeviceID[DeviceID["PN_TMP1200"] = 90] = "PN_TMP1200";
  /**
   * 20-bit (+-40V) Voltage Input Phidget (VCP1000)
   * @public
   */
  DeviceID[DeviceID["PN_VCP1000"] = 92] = "PN_VCP1000";
  /**
   * 10-bit (+-40V) Voltage Input Phidget (VCP1001)
   * @public
   */
  DeviceID[DeviceID["PN_VCP1001"] = 93] = "PN_VCP1001";
  /**
   * 10-bit (+-1V) Voltage Input Phidget (VCP1002)
   * @public
   */
  DeviceID[DeviceID["PN_VCP1002"] = 94] = "PN_VCP1002";
  /**
   * 30A Current Sensor Phidget (VCP1100)
   * @public
   */
  DeviceID[DeviceID["PN_VCP1100"] = 105] = "PN_VCP1100";
})(DeviceID || (DeviceID = {}));
/**
 * Phidget logging level
 * @public
 */
var LogLevel;
(function (LogLevel) {
  /**
   * Critical
   * @public
   */
  LogLevel[LogLevel["CRITICAL"] = 1] = "CRITICAL";
  /**
   * Error
   * @public
   */
  LogLevel[LogLevel["ERROR"] = 2] = "ERROR";
  /**
   * Warning
   * @public
   */
  LogLevel[LogLevel["WARNING"] = 3] = "WARNING";
  /**
   * Info
   * @public
   */
  LogLevel[LogLevel["INFO"] = 4] = "INFO";
  /**
   * Debug
   * @public
   */
  LogLevel[LogLevel["DEBUG"] = 5] = "DEBUG";
  /**
   * Verbose
   * @public
   */
  LogLevel[LogLevel["VERBOSE"] = 6] = "VERBOSE";
})(LogLevel || (LogLevel = {}));
/**
 * Phidget device class
 * @public
 */
var DeviceClass;
(function (DeviceClass) {
  /**
   * Any device
   * @internal
   */
  DeviceClass[DeviceClass["NONE"] = 0] = "NONE";
  /**
   * PhidgetAccelerometer device
   * @public
   */
  DeviceClass[DeviceClass["ACCELEROMETER"] = 1] = "ACCELEROMETER";
  /**
   * PhidgetAdvancedServo device
   * @public
   */
  DeviceClass[DeviceClass["ADVANCED_SERVO"] = 2] = "ADVANCED_SERVO";
  /**
   * PhidgetAnalog device
   * @public
   */
  DeviceClass[DeviceClass["ANALOG"] = 3] = "ANALOG";
  /**
   * PhidgetBridge device
   * @public
   */
  DeviceClass[DeviceClass["BRIDGE"] = 4] = "BRIDGE";
  /**
   * PhidgetCurrentOutput device
   * @internal
   */
  DeviceClass[DeviceClass["CURRENT_OUTPUT"] = 26] = "CURRENT_OUTPUT";
  /**
   * PhidgetDataAdapter device
   * @public
   */
  DeviceClass[DeviceClass["DATA_ADAPTER"] = 25] = "DATA_ADAPTER";
  /**
   * Dictionary device
   * @public
   */
  DeviceClass[DeviceClass["DICTIONARY"] = 24] = "DICTIONARY";
  /**
   * PhidgetEncoder device
   * @public
   */
  DeviceClass[DeviceClass["ENCODER"] = 5] = "ENCODER";
  /**
   * Phidget device in Firmware Upgrade mode
   * @internal
   */
  DeviceClass[DeviceClass["FIRMWARE_UPGRADE"] = 23] = "FIRMWARE_UPGRADE";
  /**
   * PhidgetFrequencyCounter device
   * @public
   */
  DeviceClass[DeviceClass["FREQUENCY_COUNTER"] = 6] = "FREQUENCY_COUNTER";
  /**
   * Generic device
   * @internal
   */
  DeviceClass[DeviceClass["GENERIC"] = 22] = "GENERIC";
  /**
   * PhidgetGPS device
   * @public
   */
  DeviceClass[DeviceClass["GPS"] = 7] = "GPS";
  /**
   * Phidget VINT Hub device
   * @public
   */
  DeviceClass[DeviceClass["HUB"] = 8] = "HUB";
  /**
   * PhidgetInterfaceKit device
   * @public
   */
  DeviceClass[DeviceClass["INTERFACE_KIT"] = 9] = "INTERFACE_KIT";
  /**
   * PhidgetIR device
   * @public
   */
  DeviceClass[DeviceClass["IR"] = 10] = "IR";
  /**
   * PhidgetLED device
   * @public
   */
  DeviceClass[DeviceClass["LED"] = 11] = "LED";
  /**
   * PhidgetLEDArray device
   * @public
   */
  DeviceClass[DeviceClass["LEDARRAY"] = 12] = "LEDARRAY";
  /**
   * PhidgetMotorControl device
   * @public
   */
  DeviceClass[DeviceClass["MOTOR_CONTROL"] = 13] = "MOTOR_CONTROL";
  /**
   * PhidgetPHSensor device
   * @public
   */
  DeviceClass[DeviceClass["PH_SENSOR"] = 14] = "PH_SENSOR";
  /**
   * PhidgetRFID device
   * @public
   */
  DeviceClass[DeviceClass["RFID"] = 15] = "RFID";
  /**
   * PhidgetServo device
   * @public
   */
  DeviceClass[DeviceClass["SERVO"] = 16] = "SERVO";
  /**
   * PhidgetSpatial device
   * @public
   */
  DeviceClass[DeviceClass["SPATIAL"] = 17] = "SPATIAL";
  /**
   * PhidgetStepper device
   * @public
   */
  DeviceClass[DeviceClass["STEPPER"] = 18] = "STEPPER";
  /**
   * PhidgetTemperatureSensor device
   * @public
   */
  DeviceClass[DeviceClass["TEMPERATURE_SENSOR"] = 19] = "TEMPERATURE_SENSOR";
  /**
   * PhidgetTextLCD device
   * @public
   */
  DeviceClass[DeviceClass["TEXT_LCD"] = 20] = "TEXT_LCD";
  /**
   * Phidget VINT device
   * @public
   */
  DeviceClass[DeviceClass["VINT"] = 21] = "VINT";
})(DeviceClass || (DeviceClass = {}));
/**
 * Phidget channel class
 * @public
 */
var ChannelClass;
(function (ChannelClass) {
  /**
   * Any channel
   * @internal
   */
  ChannelClass[ChannelClass["NONE"] = 0] = "NONE";
  /**
   * Accelerometer channel
   * @public
   */
  ChannelClass[ChannelClass["ACCELEROMETER"] = 1] = "ACCELEROMETER";
  /**
   * Brushless DC motor channel
   * @public
   */
  ChannelClass[ChannelClass["BLDC_MOTOR"] = 35] = "BLDC_MOTOR";
  /**
   * Capacitive Touch channel
   * @public
   */
  ChannelClass[ChannelClass["CAPACITIVE_TOUCH"] = 14] = "CAPACITIVE_TOUCH";
  /**
   * Current input channel
   * @public
   */
  ChannelClass[ChannelClass["CURRENT_INPUT"] = 2] = "CURRENT_INPUT";
  /**
   * Current output channel
   * @internal
   */
  ChannelClass[ChannelClass["CURRENT_OUTPUT"] = 38] = "CURRENT_OUTPUT";
  /**
   * Data adapter channel
   * @public
   */
  ChannelClass[ChannelClass["DATA_ADAPTER"] = 3] = "DATA_ADAPTER";
  /**
   * DC motor channel
   * @public
   */
  ChannelClass[ChannelClass["DC_MOTOR"] = 4] = "DC_MOTOR";
  /**
   * Dictionary
   * @public
   */
  ChannelClass[ChannelClass["DICTIONARY"] = 36] = "DICTIONARY";
  /**
   * Digital input channel
   * @public
   */
  ChannelClass[ChannelClass["DIGITAL_INPUT"] = 5] = "DIGITAL_INPUT";
  /**
   * Digital output channel
   * @public
   */
  ChannelClass[ChannelClass["DIGITAL_OUTPUT"] = 6] = "DIGITAL_OUTPUT";
  /**
   * Distance sensor channel
   * @public
   */
  ChannelClass[ChannelClass["DISTANCE_SENSOR"] = 7] = "DISTANCE_SENSOR";
  /**
   * Encoder channel
   * @public
   */
  ChannelClass[ChannelClass["ENCODER"] = 8] = "ENCODER";
  /**
   * Firmware upgrade channel
   * @internal
   */
  ChannelClass[ChannelClass["FIRMWARE_UPGRADE"] = 32] = "FIRMWARE_UPGRADE";
  /**
   * Frequency counter channel
   * @public
   */
  ChannelClass[ChannelClass["FREQUENCY_COUNTER"] = 9] = "FREQUENCY_COUNTER";
  /**
   * Generic channel
   * @internal
   */
  ChannelClass[ChannelClass["GENERIC"] = 33] = "GENERIC";
  /**
   * GPS channel
   * @public
   */
  ChannelClass[ChannelClass["GPS"] = 10] = "GPS";
  /**
   * Gyroscope channel
   * @public
   */
  ChannelClass[ChannelClass["GYROSCOPE"] = 12] = "GYROSCOPE";
  /**
   * VINT Hub channel
   * @public
   */
  ChannelClass[ChannelClass["HUB"] = 13] = "HUB";
  /**
   * Humidity sensor channel
   * @public
   */
  ChannelClass[ChannelClass["HUMIDITY_SENSOR"] = 15] = "HUMIDITY_SENSOR";
  /**
   * IR channel
   * @public
   */
  ChannelClass[ChannelClass["IR"] = 16] = "IR";
  /**
   * LCD channel
   * @public
   */
  ChannelClass[ChannelClass["LCD"] = 11] = "LCD";
  /**
   * LED array channel
   * @public
   */
  ChannelClass[ChannelClass["LEDARRAY"] = 19] = "LEDARRAY";
  /**
   * Light sensor channel
   * @public
   */
  ChannelClass[ChannelClass["LIGHT_SENSOR"] = 17] = "LIGHT_SENSOR";
  /**
   * Magnetometer channel
   * @public
   */
  ChannelClass[ChannelClass["MAGNETOMETER"] = 18] = "MAGNETOMETER";
  /**
   * Motor position control channel.
   * @public
   */
  ChannelClass[ChannelClass["MOTOR_POSITION_CONTROLLER"] = 34] = "MOTOR_POSITION_CONTROLLER";
  /**
   * Motor velocity control channel.
   * @public
   */
  ChannelClass[ChannelClass["MOTOR_VELOCITY_CONTROLLER"] = 39] = "MOTOR_VELOCITY_CONTROLLER";
  /**
   * pH sensor channel
   * @public
   */
  ChannelClass[ChannelClass["PH_SENSOR"] = 37] = "PH_SENSOR";
  /**
   * Power guard channel
   * @public
   */
  ChannelClass[ChannelClass["POWER_GUARD"] = 20] = "POWER_GUARD";
  /**
   * Pressure sensor channel
   * @public
   */
  ChannelClass[ChannelClass["PRESSURE_SENSOR"] = 21] = "PRESSURE_SENSOR";
  /**
   * RC Servo channel
   * @public
   */
  ChannelClass[ChannelClass["RC_SERVO"] = 22] = "RC_SERVO";
  /**
   * Resistance input channel
   * @public
   */
  ChannelClass[ChannelClass["RESISTANCE_INPUT"] = 23] = "RESISTANCE_INPUT";
  /**
   * RFID channel
   * @public
   */
  ChannelClass[ChannelClass["RFID"] = 24] = "RFID";
  /**
   * Sound sensor channel
   * @public
   */
  ChannelClass[ChannelClass["SOUND_SENSOR"] = 25] = "SOUND_SENSOR";
  /**
   * Spatial channel
   * @public
   */
  ChannelClass[ChannelClass["SPATIAL"] = 26] = "SPATIAL";
  /**
   * Stepper channel
   * @public
   */
  ChannelClass[ChannelClass["STEPPER"] = 27] = "STEPPER";
  /**
   * Temperature sensor channel
   * @public
   */
  ChannelClass[ChannelClass["TEMPERATURE_SENSOR"] = 28] = "TEMPERATURE_SENSOR";
  /**
   * Voltage input channel
   * @public
   */
  ChannelClass[ChannelClass["VOLTAGE_INPUT"] = 29] = "VOLTAGE_INPUT";
  /**
   * Voltage output channel
   * @public
   */
  ChannelClass[ChannelClass["VOLTAGE_OUTPUT"] = 30] = "VOLTAGE_OUTPUT";
  /**
   * Voltage ratio input channel
   * @public
   */
  ChannelClass[ChannelClass["VOLTAGE_RATIO_INPUT"] = 31] = "VOLTAGE_RATIO_INPUT";
})(ChannelClass || (ChannelClass = {}));
/**
 * Phidget channel sub class
 * @public
 */
var ChannelSubclass;
(function (ChannelSubclass) {
  /**
   * No subclass
   * @public
   */
  ChannelSubclass[ChannelSubclass["NONE"] = 1] = "NONE";
  /**
   * Digital output duty cycle
   * @public
   */
  ChannelSubclass[ChannelSubclass["DIGITAL_OUTPUT_DUTY_CYCLE"] = 16] = "DIGITAL_OUTPUT_DUTY_CYCLE";
  /**
   * Digital output frequency
   * @public
   */
  ChannelSubclass[ChannelSubclass["DIGITAL_OUTPUT_FREQUENCY"] = 18] = "DIGITAL_OUTPUT_FREQUENCY";
  /**
   * Digital output LED driver
   * @public
   */
  ChannelSubclass[ChannelSubclass["DIGITAL_OUTPUT_LEDDRIVER"] = 17] = "DIGITAL_OUTPUT_LEDDRIVER";
  /**
   * Encoder IO mode settable
   * @public
   */
  ChannelSubclass[ChannelSubclass["ENCODER_MODE_SETTABLE"] = 96] = "ENCODER_MODE_SETTABLE";
  /**
   * Graphic LCD
   * @public
   */
  ChannelSubclass[ChannelSubclass["LCD_GRAPHIC"] = 80] = "LCD_GRAPHIC";
  /**
   * Text LCD
   * @public
   */
  ChannelSubclass[ChannelSubclass["LCD_TEXT"] = 81] = "LCD_TEXT";
  /**
   * RFID NFC
   * @public
   */
  ChannelSubclass[ChannelSubclass["RFID_NFC"] = 128] = "RFID_NFC";
  /**
   * Spatial AHRS/IMU
   * @public
   */
  ChannelSubclass[ChannelSubclass["SPATIAL_AHRS"] = 112] = "SPATIAL_AHRS";
  /**
   * Temperature sensor RTD
   * @public
   */
  ChannelSubclass[ChannelSubclass["TEMPERATURE_SENSOR_RTD"] = 32] = "TEMPERATURE_SENSOR_RTD";
  /**
   * Temperature sensor thermocouple
   * @public
   */
  ChannelSubclass[ChannelSubclass["TEMPERATURE_SENSOR_THERMOCOUPLE"] = 33] = "TEMPERATURE_SENSOR_THERMOCOUPLE";
  /**
   * Voltage sensor port
   * @public
   */
  ChannelSubclass[ChannelSubclass["VOLTAGE_INPUT_SENSOR_PORT"] = 48] = "VOLTAGE_INPUT_SENSOR_PORT";
  /**
   * Voltage ratio bridge input
   * @public
   */
  ChannelSubclass[ChannelSubclass["VOLTAGE_RATIO_INPUT_BRIDGE"] = 65] = "VOLTAGE_RATIO_INPUT_BRIDGE";
  /**
   * Voltage ratio sensor port
   * @public
   */
  ChannelSubclass[ChannelSubclass["VOLTAGE_RATIO_INPUT_SENSOR_PORT"] = 64] = "VOLTAGE_RATIO_INPUT_SENSOR_PORT";
})(ChannelSubclass || (ChannelSubclass = {}));
/**
 * The voltage level being provided to the sensor
 * @public
 */
var PowerSupply;
(function (PowerSupply) {
  /**
   * Switch the sensor power supply off
   * @public
   */
  PowerSupply[PowerSupply["OFF"] = 1] = "OFF";
  /**
   * The sensor is provided with 12 volts
   * @public
   */
  PowerSupply[PowerSupply["VOLTS_12"] = 2] = "VOLTS_12";
  /**
   * The sensor is provided with 24 volts
   * @public
   */
  PowerSupply[PowerSupply["VOLTS_24"] = 3] = "VOLTS_24";
})(PowerSupply || (PowerSupply = {}));
/**
 * The DataAdapter Voltage
 * @public
 */
var DataAdapterVoltage;
(function (DataAdapterVoltage) {
  /**
   * Voltage supplied by external device
   * @public
   */
  DataAdapterVoltage[DataAdapterVoltage["EXTERNAL"] = 1] = "EXTERNAL";
  /**
   * 2.5V
   * @public
   */
  DataAdapterVoltage[DataAdapterVoltage["VOLTS_2_5"] = 3] = "VOLTS_2_5";
  /**
   * 3.3V
   * @public
   */
  DataAdapterVoltage[DataAdapterVoltage["VOLTS_3_3"] = 4] = "VOLTS_3_3";
  /**
   * 5.0V
   * @public
   */
  DataAdapterVoltage[DataAdapterVoltage["VOLTS_5"] = 5] = "VOLTS_5";
})(DataAdapterVoltage || (DataAdapterVoltage = {}));
/**
 * RTD wiring configuration
 * @public
 */
var RTDWireSetup;
(function (RTDWireSetup) {
  /**
   * Configures the device to make resistance calculations based on a 2-wire RTD setup.
   * @public
   */
  RTDWireSetup[RTDWireSetup["WIRES_2"] = 1] = "WIRES_2";
  /**
   * Configures the device to make resistance calculations based on a 3-wire RTD setup.
   * @public
   */
  RTDWireSetup[RTDWireSetup["WIRES_3"] = 2] = "WIRES_3";
  /**
   * Configures the device to make resistance calculations based on a 4-wire RTD setup.
   * @public
   */
  RTDWireSetup[RTDWireSetup["WIRES_4"] = 3] = "WIRES_4";
})(RTDWireSetup || (RTDWireSetup = {}));
/**
 * The selected polarity mode for the digital input
 * @public
 */
var InputMode;
(function (InputMode) {
  /**
   * For interfacing NPN digital sensors
   * @public
   */
  InputMode[InputMode["NPN"] = 1] = "NPN";
  /**
   * For interfacing PNP digital sensors
   * @public
   */
  InputMode[InputMode["PNP"] = 2] = "PNP";
  /**
   * Floating input
   * @public
   */
  InputMode[InputMode["FLOATING"] = 3] = "FLOATING";
  /**
   * Enables a pullup for interfaces that only pull low
   * @public
   */
  InputMode[InputMode["PULLUP"] = 4] = "PULLUP";
})(InputMode || (InputMode = {}));
/**
 * The operating condition of the fan. Choose between on, off, or automatic (based on temperature).
 * @public
 */
var FanMode;
(function (FanMode) {
  /**
   * Turns the fan off.
   * @public
   */
  FanMode[FanMode["OFF"] = 1] = "OFF";
  /**
   * Turns the fan on.
   * @public
   */
  FanMode[FanMode["ON"] = 2] = "ON";
  /**
   * The fan will be automatically controlled based on temperature.
   * @public
   */
  FanMode[FanMode["AUTO"] = 3] = "AUTO";
})(FanMode || (FanMode = {}));
/**
 * The drive type selection for the motor
 * @public
 */
var DriveMode;
(function (DriveMode) {
  /**
   * Configures the motor for coasting deceleration
   * @public
   */
  DriveMode[DriveMode["COAST"] = 1] = "COAST";
  /**
   * Configures the motor for forced deceleration
   * @public
   */
  DriveMode[DriveMode["FORCED"] = 2] = "FORCED";
})(DriveMode || (DriveMode = {}));
/**
 * The position type selection
 * @public
 */
var PositionType;
(function (PositionType) {
  /**
   * Configures the controller to use the encoder as a position source
   * @public
   */
  PositionType[PositionType["ENCODER"] = 1] = "ENCODER";
  /**
   * Configures the controller to use the hall-effect sensor as a position source
   * @public
   */
  PositionType[PositionType["HALL_SENSOR"] = 2] = "HALL_SENSOR";
})(PositionType || (PositionType = {}));
/**
 * Controls how data from primary and backup spatial sensing chips are used.
 * @public
 */
var SpatialPrecision;
(function (SpatialPrecision) {
  /**
   * High precision sensor is used when possible, fallback to low precision sensor.
   * @public
   */
  SpatialPrecision[SpatialPrecision["HYBRID"] = 0] = "HYBRID";
  /**
   * High precision sensor is always used.
   * @public
   */
  SpatialPrecision[SpatialPrecision["HIGH"] = 1] = "HIGH";
  /**
   * Low precision sensor is always used.
   * @public
   */
  SpatialPrecision[SpatialPrecision["LOW"] = 2] = "LOW";
})(SpatialPrecision || (SpatialPrecision = {}));
/**
 * Analog sensor units. These correspond to the types of quantities that can be measured by Phidget analog sensors.
 * @public
 */
var Unit;
(function (Unit) {
  /**
   * Unitless
   * @public
   */
  Unit[Unit["NONE"] = 0] = "NONE";
  /**
   * Boolean
   * @public
   */
  Unit[Unit["BOOLEAN"] = 1] = "BOOLEAN";
  /**
   * Percent
   * @public
   */
  Unit[Unit["PERCENT"] = 2] = "PERCENT";
  /**
   * Decibel
   * @public
   */
  Unit[Unit["DECIBEL"] = 3] = "DECIBEL";
  /**
   * Millimeter
   * @public
   */
  Unit[Unit["MILLIMETER"] = 4] = "MILLIMETER";
  /**
   * Centimeter
   * @public
   */
  Unit[Unit["CENTIMETER"] = 5] = "CENTIMETER";
  /**
   * Meter
   * @public
   */
  Unit[Unit["METER"] = 6] = "METER";
  /**
   * Gram
   * @public
   */
  Unit[Unit["GRAM"] = 7] = "GRAM";
  /**
   * Kilogram
   * @public
   */
  Unit[Unit["KILOGRAM"] = 8] = "KILOGRAM";
  /**
   * Milliampere
   * @public
   */
  Unit[Unit["MILLIAMPERE"] = 9] = "MILLIAMPERE";
  /**
   * Ampere
   * @public
   */
  Unit[Unit["AMPERE"] = 10] = "AMPERE";
  /**
   * Kilopascal
   * @public
   */
  Unit[Unit["KILOPASCAL"] = 11] = "KILOPASCAL";
  /**
   * Volt
   * @public
   */
  Unit[Unit["VOLT"] = 12] = "VOLT";
  /**
   * Degree Celcius
   * @public
   */
  Unit[Unit["DEGREE_CELCIUS"] = 13] = "DEGREE_CELCIUS";
  /**
   * Lux
   * @public
   */
  Unit[Unit["LUX"] = 14] = "LUX";
  /**
   * Gauss
   * @public
   */
  Unit[Unit["GAUSS"] = 15] = "GAUSS";
  /**
   * pH
   * @public
   */
  Unit[Unit["PH"] = 16] = "PH";
  /**
   * Watt
   * @public
   */
  Unit[Unit["WATT"] = 17] = "WATT";
})(Unit || (Unit = {}));
/**
 * Bridge gain amplification setting. Higher gain results in better resolution, but narrower voltage range.
 * @public
 */
var BridgeGain;
(function (BridgeGain) {
  /**
   * 1x Amplificaion
   * @public
   */
  BridgeGain[BridgeGain["GAIN_1X"] = 1] = "GAIN_1X";
  /**
   * 2x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_2X"] = 2] = "GAIN_2X";
  /**
   * 4x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_4X"] = 3] = "GAIN_4X";
  /**
   * 8x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_8X"] = 4] = "GAIN_8X";
  /**
   * 16x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_16X"] = 5] = "GAIN_16X";
  /**
   * 32x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_32X"] = 6] = "GAIN_32X";
  /**
   * 64x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_64X"] = 7] = "GAIN_64X";
  /**
   * 128x Amplification
   * @public
   */
  BridgeGain[BridgeGain["GAIN_128X"] = 8] = "GAIN_128X";
})(BridgeGain || (BridgeGain = {}));
/**
 * The type of sensor attached to the voltage ratio input
 * @public
 */
var VoltageRatioSensorType;
(function (VoltageRatioSensorType) {
  /**
   * Default. Configures the channel to be a generic ratiometric sensor. Unit is volts/volt.
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["VOLTAGE_RATIO"] = 0] = "VOLTAGE_RATIO";
  /**
   * 1101 - IR Distance Adapter, with Sharp Distance Sensor 2D120X (4-30cm)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1101_SHARP2D120X"] = 11011] = "PN_1101_SHARP2D120X";
  /**
   * 1101 - IR Distance Adapter, with Sharp Distance Sensor 2Y0A21 (10-80cm)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1101_SHARP2Y0A21"] = 11012] = "PN_1101_SHARP2Y0A21";
  /**
   * 1101 - IR Distance Adapter, with Sharp Distance Sensor 2Y0A02 (20-150cm)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1101_SHARP2Y0A02"] = 11013] = "PN_1101_SHARP2Y0A02";
  /**
   * 1102 - IR Reflective Sensor 5mm
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1102"] = 11020] = "PN_1102";
  /**
   * 1103 - IR Reflective Sensor 10cm
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1103"] = 11030] = "PN_1103";
  /**
   * 1104 - Vibration Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1104"] = 11040] = "PN_1104";
  /**
   * 1105 - Light Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1105"] = 11050] = "PN_1105";
  /**
   * 1106 - Force Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1106"] = 11060] = "PN_1106";
  /**
   * 1107 - Humidity Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1107"] = 11070] = "PN_1107";
  /**
   * 1108 - Magnetic Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1108"] = 11080] = "PN_1108";
  /**
   * 1109 - Rotation Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1109"] = 11090] = "PN_1109";
  /**
   * 1110 - Touch Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1110"] = 11100] = "PN_1110";
  /**
   * 1111 - Motion Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1111"] = 11110] = "PN_1111";
  /**
   * 1112 - Slider 60
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1112"] = 11120] = "PN_1112";
  /**
   * 1113 - Mini Joy Stick Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1113"] = 11130] = "PN_1113";
  /**
   * 1115 - Pressure Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1115"] = 11150] = "PN_1115";
  /**
   * 1116 - Multi-turn Rotation Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1116"] = 11160] = "PN_1116";
  /**
   * 1118 - 50Amp Current Sensor AC
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1118_AC"] = 11181] = "PN_1118_AC";
  /**
   * 1118 - 50Amp Current Sensor DC
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1118_DC"] = 11182] = "PN_1118_DC";
  /**
   * 1119 - 20Amp Current Sensor AC
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1119_AC"] = 11191] = "PN_1119_AC";
  /**
   * 1119 - 20Amp Current Sensor DC
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1119_DC"] = 11192] = "PN_1119_DC";
  /**
   * 1120 - FlexiForce Adapter
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1120"] = 11200] = "PN_1120";
  /**
   * 1121 - Voltage Divider
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1121"] = 11210] = "PN_1121";
  /**
   * 1122 - 30 Amp Current Sensor AC
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1122_AC"] = 11221] = "PN_1122_AC";
  /**
   * 1122 - 30 Amp Current Sensor DC
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1122_DC"] = 11222] = "PN_1122_DC";
  /**
   * 1124 - Precision Temperature Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1124"] = 11240] = "PN_1124";
  /**
   * 1125 - Humidity Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1125_HUMIDITY"] = 11251] = "PN_1125_HUMIDITY";
  /**
   * 1125 - Temperature Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1125_TEMPERATURE"] = 11252] = "PN_1125_TEMPERATURE";
  /**
   * 1126 - Differential Air Pressure Sensor +- 25kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1126"] = 11260] = "PN_1126";
  /**
   * 1128 - MaxBotix EZ-1 Sonar Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1128"] = 11280] = "PN_1128";
  /**
   * 1129 - Touch Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1129"] = 11290] = "PN_1129";
  /**
   * 1131 - Thin Force Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1131"] = 11310] = "PN_1131";
  /**
   * 1134 - Switchable Voltage Divider
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1134"] = 11340] = "PN_1134";
  /**
   * 1136 - Differential Air Pressure Sensor +-2 kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1136"] = 11360] = "PN_1136";
  /**
   * 1137 - Differential Air Pressure Sensor +-7 kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1137"] = 11370] = "PN_1137";
  /**
   * 1138 - Differential Air Pressure Sensor 50 kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1138"] = 11380] = "PN_1138";
  /**
   * 1139 - Differential Air Pressure Sensor 100 kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1139"] = 11390] = "PN_1139";
  /**
   * 1140 - Absolute Air Pressure Sensor 20-400 kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1140"] = 11400] = "PN_1140";
  /**
   * 1141 - Absolute Air Pressure Sensor 15-115 kPa
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1141"] = 11410] = "PN_1141";
  /**
   * 1146 - IR Reflective Sensor 1-4mm
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_1146"] = 11460] = "PN_1146";
  /**
   * 3120 - Compression Load Cell (0-4.5 kg)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3120"] = 31200] = "PN_3120";
  /**
   * 3121 - Compression Load Cell (0-11.3 kg)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3121"] = 31210] = "PN_3121";
  /**
   * 3122 - Compression Load Cell (0-22.7 kg)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3122"] = 31220] = "PN_3122";
  /**
   * 3123 - Compression Load Cell (0-45.3 kg)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3123"] = 31230] = "PN_3123";
  /**
   * 3130 - Relative Humidity Sensor
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3130"] = 31300] = "PN_3130";
  /**
   * 3520 - Sharp Distance Sensor (4-30cm)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3520"] = 35200] = "PN_3520";
  /**
   * 3521 - Sharp Distance Sensor (10-80cm)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3521"] = 35210] = "PN_3521";
  /**
   * 3522 - Sharp Distance Sensor (20-150cm)
   * @public
   */
  VoltageRatioSensorType[VoltageRatioSensorType["PN_3522"] = 35220] = "PN_3522";
})(VoltageRatioSensorType || (VoltageRatioSensorType = {}));
/**
 * The forward voltage setting of the LED
 * @public
 */
var LEDForwardVoltage;
(function (LEDForwardVoltage) {
  /**
   * 1.7 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_1_7"] = 1] = "VOLTS_1_7";
  /**
   * 2.75 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_2_75"] = 2] = "VOLTS_2_75";
  /**
   * 3.2 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_3_2"] = 3] = "VOLTS_3_2";
  /**
   * 3.9 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_3_9"] = 4] = "VOLTS_3_9";
  /**
   * 4.0 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_4_0"] = 5] = "VOLTS_4_0";
  /**
   * 4.8 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_4_8"] = 6] = "VOLTS_4_8";
  /**
   * 5.0 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_5_0"] = 7] = "VOLTS_5_0";
  /**
   * 5.6 V
   * @public
   */
  LEDForwardVoltage[LEDForwardVoltage["VOLTS_5_6"] = 8] = "VOLTS_5_6";
})(LEDForwardVoltage || (LEDForwardVoltage = {}));
/**
 * Voltage supplied to all attached servos
 * @public
 */
var RCServoVoltage;
(function (RCServoVoltage) {
  /**
   * Run all servos on 5V DC
   * @public
   */
  RCServoVoltage[RCServoVoltage["VOLTS_5_0"] = 1] = "VOLTS_5_0";
  /**
   * Run all servos on 6V DC
   * @public
   */
  RCServoVoltage[RCServoVoltage["VOLTS_6_0"] = 2] = "VOLTS_6_0";
  /**
   * Run all servos on 7.4V DC
   * @public
   */
  RCServoVoltage[RCServoVoltage["VOLTS_7_4"] = 3] = "VOLTS_7_4";
})(RCServoVoltage || (RCServoVoltage = {}));
/**
 * The selected output voltage range
 * @public
 */
var VoltageOutputRange;
(function (VoltageOutputRange) {
  /**
   * ±10V DC
   * @public
   */
  VoltageOutputRange[VoltageOutputRange["VOLTS_10"] = 1] = "VOLTS_10";
  /**
   * 0-5V DC
   * @public
   */
  VoltageOutputRange[VoltageOutputRange["VOLTS_5"] = 2] = "VOLTS_5";
})(VoltageOutputRange || (VoltageOutputRange = {}));
/**
 * Measurement range of the voltage input. Larger ranges have less resolution.
 * @public
 */
var VoltageRange;
(function (VoltageRange) {
  /**
   * Range ±10mV DC
   * @public
   */
  VoltageRange[VoltageRange["MILLIVOLTS_10"] = 1] = "MILLIVOLTS_10";
  /**
   * Range ±40mV DC
   * @public
   */
  VoltageRange[VoltageRange["MILLIVOLTS_40"] = 2] = "MILLIVOLTS_40";
  /**
   * Range ±200mV DC
   * @public
   */
  VoltageRange[VoltageRange["MILLIVOLTS_200"] = 3] = "MILLIVOLTS_200";
  /**
   * Range ±312.5mV DC
   * @public
   */
  VoltageRange[VoltageRange["MILLIVOLTS_312_5"] = 4] = "MILLIVOLTS_312_5";
  /**
   * Range ±400mV DC
   * @public
   */
  VoltageRange[VoltageRange["MILLIVOLTS_400"] = 5] = "MILLIVOLTS_400";
  /**
   * Range ±1000mV DC
   * @public
   */
  VoltageRange[VoltageRange["MILLIVOLTS_1000"] = 6] = "MILLIVOLTS_1000";
  /**
   * Range ±2V DC
   * @public
   */
  VoltageRange[VoltageRange["VOLTS_2"] = 7] = "VOLTS_2";
  /**
   * Range ±5V DC
   * @public
   */
  VoltageRange[VoltageRange["VOLTS_5"] = 8] = "VOLTS_5";
  /**
   * Range ±15V DC
   * @public
   */
  VoltageRange[VoltageRange["VOLTS_15"] = 9] = "VOLTS_15";
  /**
   * Range ±40V DC
   * @public
   */
  VoltageRange[VoltageRange["VOLTS_40"] = 10] = "VOLTS_40";
  /**
   * Auto-range mode changes based on the present voltage measurements.
   * @public
   */
  VoltageRange[VoltageRange["AUTO"] = 11] = "AUTO";
})(VoltageRange || (VoltageRange = {}));
/**
 * Type of sensor attached to the voltage input
 * @public
 */
var VoltageSensorType;
(function (VoltageSensorType) {
  /**
   * Default. Configures the channel to be a generic voltage sensor. Unit is volts.
   * @public
   */
  VoltageSensorType[VoltageSensorType["VOLTAGE"] = 0] = "VOLTAGE";
  /**
   * 1114 - Temperature Sensor
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1114"] = 11140] = "PN_1114";
  /**
   * 1117 - Voltage Sensor
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1117"] = 11170] = "PN_1117";
  /**
   * 1123 - Precision Voltage Sensor
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1123"] = 11230] = "PN_1123";
  /**
   * 1127 - Precision Light Sensor
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1127"] = 11270] = "PN_1127";
  /**
   * 1130 - pH Adapter
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1130_PH"] = 11301] = "PN_1130_PH";
  /**
   * 1130 - ORP Adapter
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1130_ORP"] = 11302] = "PN_1130_ORP";
  /**
   * 1132 - 4-20mA Adapter
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1132"] = 11320] = "PN_1132";
  /**
   * 1133 - Sound Sensor
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1133"] = 11330] = "PN_1133";
  /**
   * 1135 - Precision Voltage Sensor
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1135"] = 11350] = "PN_1135";
  /**
   * 1142 - Light Sensor 1000 lux
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1142"] = 11420] = "PN_1142";
  /**
   * 1143 - Light Sensor 70000 lux
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_1143"] = 11430] = "PN_1143";
  /**
   * 3500 - AC Current Sensor 10Amp
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3500"] = 35000] = "PN_3500";
  /**
   * 3501 - AC Current Sensor 25Amp
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3501"] = 35010] = "PN_3501";
  /**
   * 3502 - AC Current Sensor 50Amp
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3502"] = 35020] = "PN_3502";
  /**
   * 3503 - AC Current Sensor 100Amp
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3503"] = 35030] = "PN_3503";
  /**
   * 3507 - AC Voltage Sensor 0-250V (50Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3507"] = 35070] = "PN_3507";
  /**
   * 3508 - AC Voltage Sensor 0-250V (60Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3508"] = 35080] = "PN_3508";
  /**
   * 3509 - DC Voltage Sensor 0-200V
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3509"] = 35090] = "PN_3509";
  /**
   * 3510 - DC Voltage Sensor 0-75V
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3510"] = 35100] = "PN_3510";
  /**
   * 3511 - DC Current Sensor 0-10mA
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3511"] = 35110] = "PN_3511";
  /**
   * 3512 - DC Current Sensor 0-100mA
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3512"] = 35120] = "PN_3512";
  /**
   * 3513 - DC Current Sensor 0-1A
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3513"] = 35130] = "PN_3513";
  /**
   * 3514 - AC Active Power Sensor 0-250V*0-30A (50Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3514"] = 35140] = "PN_3514";
  /**
   * 3515 - AC Active Power Sensor 0-250V*0-30A (60Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3515"] = 35150] = "PN_3515";
  /**
   * 3516 - AC Active Power Sensor 0-250V*0-5A (50Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3516"] = 35160] = "PN_3516";
  /**
   * 3517 - AC Active Power Sensor 0-250V*0-5A (60Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3517"] = 35170] = "PN_3517";
  /**
   * 3518 - AC Active Power Sensor 0-110V*0-5A (60Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3518"] = 35180] = "PN_3518";
  /**
   * 3519 - AC Active Power Sensor 0-110V*0-15A (60Hz)
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3519"] = 35190] = "PN_3519";
  /**
   * 3584 - 0-50A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3584"] = 35840] = "PN_3584";
  /**
   * 3585 - 0-100A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3585"] = 35850] = "PN_3585";
  /**
   * 3586 - 0-250A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3586"] = 35860] = "PN_3586";
  /**
   * 3587 - +-50A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3587"] = 35870] = "PN_3587";
  /**
   * 3588 - +-100A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3588"] = 35880] = "PN_3588";
  /**
   * 3589 - +-250A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_3589"] = 35890] = "PN_3589";
  /**
   * MOT2002 - Motion Sensor Low Sensitivity
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_MOT2002_LOW"] = 20020] = "PN_MOT2002_LOW";
  /**
   * MOT2002 - Motion Sensor Medium Sensitivity
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_MOT2002_MED"] = 20021] = "PN_MOT2002_MED";
  /**
   * MOT2002 - Motion Sensor High Sensitivity
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_MOT2002_HIGH"] = 20022] = "PN_MOT2002_HIGH";
  /**
   * VCP4114 - +-25A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_VCP4114"] = 41140] = "PN_VCP4114";
  /**
   * VCP4115 - +-75A DC Current Transducer
   * @public
   */
  VoltageSensorType[VoltageSensorType["PN_VCP4115"] = 41150] = "PN_VCP4115";
})(VoltageSensorType || (VoltageSensorType = {}));
/**
 * The protocol used to encode the tag data
 * @public
 */
var RFIDProtocol;
(function (RFIDProtocol) {
  /**
   * EM4100 Series
   * @public
   */
  RFIDProtocol[RFIDProtocol["EM4100"] = 1] = "EM4100";
  /**
   * ISO11785 FDX B
   * @public
   */
  RFIDProtocol[RFIDProtocol["ISO11785_FDX_B"] = 2] = "ISO11785_FDX_B";
  /**
   * PhidgetTAG
   * @public
   */
  RFIDProtocol[RFIDProtocol["PHIDGET_TAG"] = 3] = "PHIDGET_TAG";
  /**
   * HID Generic
   * @public
   */
  RFIDProtocol[RFIDProtocol["HID_GENERIC"] = 4] = "HID_GENERIC";
  /**
   * HID H10301
   * @public
   */
  RFIDProtocol[RFIDProtocol["HID_H10301"] = 5] = "HID_H10301";
})(RFIDProtocol || (RFIDProtocol = {}));
/**
 * The chipset of the writable tag
 * @public
 */
var RFIDChipset;
(function (RFIDChipset) {
  /**
   * T5577
   * @public
   */
  RFIDChipset[RFIDChipset["T5577"] = 1] = "T5577";
  /**
   * EM4305
   * @public
   */
  RFIDChipset[RFIDChipset["EM4305"] = 2] = "EM4305";
})(RFIDChipset || (RFIDChipset = {}));
/**
 * The tag type of the NFC tag
 * @public
 */
var RFIDTagType;
(function (RFIDTagType) {
  /**
   * MIFARE Classic 1K
   * @public
   */
  RFIDTagType[RFIDTagType["MIFARE_CLASSIC1K"] = 1] = "MIFARE_CLASSIC1K";
  /**
   * MIFARE Classic 4K
   * @public
   */
  RFIDTagType[RFIDTagType["MIFARE_CLASSIC4K"] = 2] = "MIFARE_CLASSIC4K";
  /**
   * Generic Type 2
   * @public
   */
  RFIDTagType[RFIDTagType["GENERIC_TYPE2"] = 3] = "GENERIC_TYPE2";
  /**
   * MIFARE Ultralight
   * @public
   */
  RFIDTagType[RFIDTagType["MIFARE_ULTRALIGHT"] = 4] = "MIFARE_ULTRALIGHT";
  /**
   * MIFARE Ultralight EV1
   * @public
   */
  RFIDTagType[RFIDTagType["MIFARE_ULTRALIGHT_EV1"] = 5] = "MIFARE_ULTRALIGHT_EV1";
  /**
   * MIFARE Ultralight C
   * @public
   */
  RFIDTagType[RFIDTagType["MIFARE_ULTRALIGHT_C"] = 6] = "MIFARE_ULTRALIGHT_C";
  /**
   * NTAG 213
   * @public
   */
  RFIDTagType[RFIDTagType["NTAG213"] = 7] = "NTAG213";
  /**
   * NTAG 215
   * @public
   */
  RFIDTagType[RFIDTagType["NTAG215"] = 8] = "NTAG215";
  /**
   * NTAG 216
   * @public
   */
  RFIDTagType[RFIDTagType["NTAG216"] = 9] = "NTAG216";
  /**
   * Unsupported
   * @public
   */
  RFIDTagType[RFIDTagType["UNSUPPORTED"] = 255] = "UNSUPPORTED";
})(RFIDTagType || (RFIDTagType = {}));
/**
 * The protocol used to encode the tag data
 * @public
 */
var RFIDTNF;
(function (RFIDTNF) {
  /**
   * Record is Empty
   * @public
   */
  RFIDTNF[RFIDTNF["EMPTY"] = 0] = "EMPTY";
  /**
   * Record is well known type
   * @public
   */
  RFIDTNF[RFIDTNF["WELL_KNOWN"] = 1] = "WELL_KNOWN";
  /**
   * Record contains a media type
   * @public
   */
  RFIDTNF[RFIDTNF["MIME_MEDIA"] = 2] = "MIME_MEDIA";
  /**
   * Record is ABSOLUTE_URI
   * @public
   */
  RFIDTNF[RFIDTNF["ABSOLUTE_URI"] = 3] = "ABSOLUTE_URI";
  /**
   * Record is EXTERNAL
   * @public
   */
  RFIDTNF[RFIDTNF["EXTERNAL"] = 4] = "EXTERNAL";
  /**
   * Record is unknown, treat payload as binary
   * @public
   */
  RFIDTNF[RFIDTNF["UNKNOWN"] = 5] = "UNKNOWN";
  /**
   * Used in chunked records, same type as previous chunk.
   * @public
   */
  RFIDTNF[RFIDTNF["UNCHANGED"] = 6] = "UNCHANGED";
})(RFIDTNF || (RFIDTNF = {}));
/**
 * Controls the AHRS algorithm.
 * @public
 */
var SpatialAlgorithm;
(function (SpatialAlgorithm) {
  /**
   * No AHRS algorithm is used.
   * @public
   */
  SpatialAlgorithm[SpatialAlgorithm["NONE"] = 0] = "NONE";
  /**
   * AHRS algorithm, incorporating magnetometer data for yaw correction.
   * @public
   */
  SpatialAlgorithm[SpatialAlgorithm["AHRS"] = 1] = "AHRS";
  /**
   * IMU algorithm, using gyro and accelerometer, but not magnetometer.
   * @public
   */
  SpatialAlgorithm[SpatialAlgorithm["IMU"] = 2] = "IMU";
})(SpatialAlgorithm || (SpatialAlgorithm = {}));
/**
 * RTD sensor type
 * @public
 */
var RTDType;
(function (RTDType) {
  /**
   * Configures the RTD type as a PT100 with a 3850ppm curve.
   * @public
   */
  RTDType[RTDType["PT100_3850"] = 1] = "PT100_3850";
  /**
   * Configures the RTD type as a PT1000 with a 3850ppm curve.
   * @public
   */
  RTDType[RTDType["PT1000_3850"] = 2] = "PT1000_3850";
  /**
   * Configures the RTD type as a PT100 with a 3920ppm curve.
   * @public
   */
  RTDType[RTDType["PT100_3920"] = 3] = "PT100_3920";
  /**
   * Configures the RTD type as a PT1000 with a 3920ppm curve.
   * @public
   */
  RTDType[RTDType["PT1000_3920"] = 4] = "PT1000_3920";
})(RTDType || (RTDType = {}));
/**
 * The type of thermocouple being used
 * @public
 */
var ThermocoupleType;
(function (ThermocoupleType) {
  /**
   * Configures the thermocouple input as a J-Type thermocouple.
   * @public
   */
  ThermocoupleType[ThermocoupleType["J"] = 1] = "J";
  /**
   * Configures the thermocouple input as a K-Type thermocouple.
   * @public
   */
  ThermocoupleType[ThermocoupleType["K"] = 2] = "K";
  /**
   * Configures the thermocouple input as a E-Type thermocouple.
   * @public
   */
  ThermocoupleType[ThermocoupleType["E"] = 3] = "E";
  /**
   * Configures the thermocouple input as a T-Type thermocouple.
   * @public
   */
  ThermocoupleType[ThermocoupleType["T"] = 4] = "T";
})(ThermocoupleType || (ThermocoupleType = {}));
/**
 * Type of filter used on the frequency input
 * @public
 */
var FrequencyFilterType;
(function (FrequencyFilterType) {
  /**
   * Frequency is calculated from the number of times the signal transitions from a negative voltage to a positive voltage and back again.
   * @public
   */
  FrequencyFilterType[FrequencyFilterType["ZERO_CROSSING"] = 1] = "ZERO_CROSSING";
  /**
   * Frequency is calculated from the number of times the signal transitions from a logic false to a logic true and back again.
   * @public
   */
  FrequencyFilterType[FrequencyFilterType["LOGIC_LEVEL"] = 2] = "LOGIC_LEVEL";
})(FrequencyFilterType || (FrequencyFilterType = {}));
/**
 * Describes the encoding technique used for the code
 * @public
 */
var IRCodeEncoding;
(function (IRCodeEncoding) {
  /**
   * Unknown - the default value
   * @public
   */
  IRCodeEncoding[IRCodeEncoding["UNKNOWN"] = 1] = "UNKNOWN";
  /**
   * Space encoding, or Pulse Distance Modulation
   * @public
   */
  IRCodeEncoding[IRCodeEncoding["SPACE"] = 2] = "SPACE";
  /**
   * Pulse encoding, or Pulse Width Modulation
   * @public
   */
  IRCodeEncoding[IRCodeEncoding["PULSE"] = 3] = "PULSE";
  /**
   * Bi-Phase, or Manchester encoding
   * @public
   */
  IRCodeEncoding[IRCodeEncoding["BI_PHASE"] = 4] = "BI_PHASE";
  /**
   * RC5 - a type of Bi-Phase encoding
   * @public
   */
  IRCodeEncoding[IRCodeEncoding["RC5"] = 5] = "RC5";
  /**
   * RC6 - a type of Bi-Phase encoding
   * @public
   */
  IRCodeEncoding[IRCodeEncoding["RC6"] = 6] = "RC6";
})(IRCodeEncoding || (IRCodeEncoding = {}));
/**
 * The length type of the bitstream and gaps
 * @public
 */
var IRCodeLength;
(function (IRCodeLength) {
  /**
   * Unknown - the default value
   * @public
   */
  IRCodeLength[IRCodeLength["UNKNOWN"] = 1] = "UNKNOWN";
  /**
   * Constant - the bitstream and gap length is constant
   * @public
   */
  IRCodeLength[IRCodeLength["CONSTANT"] = 2] = "CONSTANT";
  /**
   * Variable - the bitstream has a variable length with a constant gap
   * @public
   */
  IRCodeLength[IRCodeLength["VARIABLE"] = 3] = "VARIABLE";
})(IRCodeLength || (IRCodeLength = {}));
/**
 * Method of motor control
 * @public
 */
var StepperControlMode;
(function (StepperControlMode) {
  /**
   * Control the motor by setting a target position.
   * @public
   */
  StepperControlMode[StepperControlMode["STEP"] = 0] = "STEP";
  /**
   * Control the motor by selecting a target velocity (sign indicates direction). The motor will rotate continuously in the chosen direction.
   * @public
   */
  StepperControlMode[StepperControlMode["RUN"] = 1] = "RUN";
})(StepperControlMode || (StepperControlMode = {}));
/**
 * The type of font being used
 * @public
 */
var LCDFont;
(function (LCDFont) {
  /**
   * User-defined font #1
   * @public
   */
  LCDFont[LCDFont["USER1"] = 1] = "USER1";
  /**
   * User-defined font #2
   * @public
   */
  LCDFont[LCDFont["USER2"] = 2] = "USER2";
  /**
   * 6px by 10px font
   * @public
   */
  LCDFont[LCDFont["DIMENSIONS_6X10"] = 3] = "DIMENSIONS_6X10";
  /**
   * 5px by 8px font
   * @public
   */
  LCDFont[LCDFont["DIMENSIONS_5X8"] = 4] = "DIMENSIONS_5X8";
  /**
   * 6px by 12px font
   * @public
   */
  LCDFont[LCDFont["DIMENSIONS_6X12"] = 5] = "DIMENSIONS_6X12";
})(LCDFont || (LCDFont = {}));
/**
 * Size of the attached LCD screen
 * @public
 */
var LCDScreenSize;
(function (LCDScreenSize) {
  /**
   * Screen size unknown
   * @public
   */
  LCDScreenSize[LCDScreenSize["NO_SCREEN"] = 1] = "NO_SCREEN";
  /**
   * One row, eight column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_1X8"] = 2] = "DIMENSIONS_1X8";
  /**
   * Two row, eight column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_2X8"] = 3] = "DIMENSIONS_2X8";
  /**
   * One row, 16 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_1X16"] = 4] = "DIMENSIONS_1X16";
  /**
   * Two row, 16 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_2X16"] = 5] = "DIMENSIONS_2X16";
  /**
   * Four row, 16 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_4X16"] = 6] = "DIMENSIONS_4X16";
  /**
   * Two row, 20 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_2X20"] = 7] = "DIMENSIONS_2X20";
  /**
   * Four row, 20 column text screen.
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_4X20"] = 8] = "DIMENSIONS_4X20";
  /**
   * Two row, 24 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_2X24"] = 9] = "DIMENSIONS_2X24";
  /**
   * One row, 40 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_1X40"] = 10] = "DIMENSIONS_1X40";
  /**
   * Two row, 40 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_2X40"] = 11] = "DIMENSIONS_2X40";
  /**
   * Four row, 40 column text screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_4X40"] = 12] = "DIMENSIONS_4X40";
  /**
   * 64px by 128px graphic screen
   * @public
   */
  LCDScreenSize[LCDScreenSize["DIMENSIONS_64X128"] = 13] = "DIMENSIONS_64X128";
})(LCDScreenSize || (LCDScreenSize = {}));
/**
 * The on/off state of the pixel to be set
 * @public
 */
var LCDPixelState;
(function (LCDPixelState) {
  /**
   * Pixel off state
   * @public
   */
  LCDPixelState[LCDPixelState["OFF"] = 0] = "OFF";
  /**
   * Pixel on state
   * @public
   */
  LCDPixelState[LCDPixelState["ON"] = 1] = "ON";
  /**
   * Invert the pixel state
   * @public
   */
  LCDPixelState[LCDPixelState["INVERT"] = 2] = "INVERT";
})(LCDPixelState || (LCDPixelState = {}));
/**
 * The SPI Mode
 * @public
 */
var DataAdapterSPIMode;
(function (DataAdapterSPIMode) {
  /**
   * CPOL = 0 CPHA = 0
   * @public
   */
  DataAdapterSPIMode[DataAdapterSPIMode["MODE_0"] = 1] = "MODE_0";
  /**
   * CPOL = 0 CPHA = 1
   * @public
   */
  DataAdapterSPIMode[DataAdapterSPIMode["MODE_1"] = 2] = "MODE_1";
  /**
   * CPOL = 1 CPHA = 0
   * @public
   */
  DataAdapterSPIMode[DataAdapterSPIMode["MODE_2"] = 3] = "MODE_2";
  /**
   * CPOL = 1 CPHA = 1
   * @public
   */
  DataAdapterSPIMode[DataAdapterSPIMode["MODE_3"] = 4] = "MODE_3";
})(DataAdapterSPIMode || (DataAdapterSPIMode = {}));
/**
 * The communication frequency
 * @public
 */
var DataAdapterFrequency;
(function (DataAdapterFrequency) {
  /**
   * 10kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_10K_HZ"] = 1] = "FREQUENCY_10K_HZ";
  /**
   * 100kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_100K_HZ"] = 2] = "FREQUENCY_100K_HZ";
  /**
   * 400kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_400K_HZ"] = 3] = "FREQUENCY_400K_HZ";
  /**
   * 187.5kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_188K_HZ"] = 4] = "FREQUENCY_188K_HZ";
  /**
   * 375kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_375K_HZ"] = 5] = "FREQUENCY_375K_HZ";
  /**
   * 750kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_750K_HZ"] = 6] = "FREQUENCY_750K_HZ";
  /**
   * 1500kHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_1500K_HZ"] = 7] = "FREQUENCY_1500K_HZ";
  /**
   * 3MHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_3MHZ"] = 8] = "FREQUENCY_3MHZ";
  /**
   * 6MHz communication frequency
   * @public
   */
  DataAdapterFrequency[DataAdapterFrequency["FREQUENCY_6MHZ"] = 9] = "FREQUENCY_6MHZ";
})(DataAdapterFrequency || (DataAdapterFrequency = {}));
/**
 * The Type of Error on the Packet
 * @public
 */
var PacketErrorCode;
(function (PacketErrorCode) {
  /**
   * No error
   * @public
   */
  PacketErrorCode[PacketErrorCode["OK"] = 0] = "OK";
  /**
   * Unknown Error
   * @public
   */
  PacketErrorCode[PacketErrorCode["UNKNOWN"] = 1] = "UNKNOWN";
  /**
   * The response packet timed out
   * @public
   */
  PacketErrorCode[PacketErrorCode["TIMEOUT"] = 2] = "TIMEOUT";
  /**
   * Something about the sent or received data didn't match the expected format.
   * @public
   */
  PacketErrorCode[PacketErrorCode["FORMAT"] = 3] = "FORMAT";
  /**
   * The input lines are invalid. This likely means a cable has been unplugged.
   * @public
   */
  PacketErrorCode[PacketErrorCode["INVALID"] = 4] = "INVALID";
  /**
   * Data is being received faster than it can be processed. Some has been lost.
   * @public
   */
  PacketErrorCode[PacketErrorCode["OVERRUN"] = 5] = "OVERRUN";
  /**
   * Something behind the scenes got out of sequence.
   * @public
   */
  PacketErrorCode[PacketErrorCode["CORRUPT"] = 6] = "CORRUPT";
  /**
   * One or more packets have received a NACK response
   * @public
   */
  PacketErrorCode[PacketErrorCode["NACK"] = 7] = "NACK";
})(PacketErrorCode || (PacketErrorCode = {}));
/**
 * The SPI Chip Select
 * @public
 */
var DataAdapterSPIChipSelect;
(function (DataAdapterSPIChipSelect) {
  /**
   * CS normally HIGH, Automatically goes LOW during transmission
   * @public
   */
  DataAdapterSPIChipSelect[DataAdapterSPIChipSelect["ACTIVE_LOW"] = 1] = "ACTIVE_LOW";
  /**
   * CS normally LOW, Automatically goes HIGH during transmission
   * @public
   */
  DataAdapterSPIChipSelect[DataAdapterSPIChipSelect["ACTIVE_HIGH"] = 2] = "ACTIVE_HIGH";
  /**
   * CS is held LOW as long as this is set
   * @public
   */
  DataAdapterSPIChipSelect[DataAdapterSPIChipSelect["LOW"] = 3] = "LOW";
  /**
   * CS is held HIGH as long as this is set
   * @public
   */
  DataAdapterSPIChipSelect[DataAdapterSPIChipSelect["HIGH"] = 4] = "HIGH";
})(DataAdapterSPIChipSelect || (DataAdapterSPIChipSelect = {}));
/**
 * The endianness of data being transmitted
 * @public
 */
var DataAdapterEndianness;
(function (DataAdapterEndianness) {
  /**
   * MSB First
   * @public
   */
  DataAdapterEndianness[DataAdapterEndianness["MSB_FIRST"] = 1] = "MSB_FIRST";
  /**
   * LSB First
   * @public
   */
  DataAdapterEndianness[DataAdapterEndianness["LSB_FIRST"] = 2] = "LSB_FIRST";
})(DataAdapterEndianness || (DataAdapterEndianness = {}));
/**
 * The order that color information is to be sent to the LEDs
 * @public
 */
var LEDArrayColorOrder;
(function (LEDArrayColorOrder) {
  /**
   * Byte order RGB (WS2811)
   * @public
   */
  LEDArrayColorOrder[LEDArrayColorOrder["RGB"] = 1] = "RGB";
  /**
   * Byte order GRB (WS2812B, SK6812)
   * @public
   */
  LEDArrayColorOrder[LEDArrayColorOrder["GRB"] = 2] = "GRB";
  /**
   * Byte order RGBW
   * @public
   */
  LEDArrayColorOrder[LEDArrayColorOrder["RGBW"] = 3] = "RGBW";
  /**
   * Byte order GRBW (SK6812RGBW)
   * @public
   */
  LEDArrayColorOrder[LEDArrayColorOrder["GRBW"] = 4] = "GRBW";
})(LEDArrayColorOrder || (LEDArrayColorOrder = {}));
/**
 * The animation type
 * @public
 */
var LEDArrayAnimationType;
(function (LEDArrayAnimationType) {
  /**
   * Move the pattern in a positively incrementing direction
   * @public
   */
  LEDArrayAnimationType[LEDArrayAnimationType["FORWARD_SCROLL"] = 1] = "FORWARD_SCROLL";
  /**
   * Move the pattern in a decrementing direction
   * @public
   */
  LEDArrayAnimationType[LEDArrayAnimationType["REVERSE_SCROLL"] = 2] = "REVERSE_SCROLL";
  /**
   * Fades LEDs between colors in the supplied pattern, chosen at random.
   * @public
   */
  LEDArrayAnimationType[LEDArrayAnimationType["RANDOMIZE"] = 3] = "RANDOMIZE";
  /**
   * Flip the pattern and move it in a positively incrementing direction, starting from the animation end point
   * @public
   */
  LEDArrayAnimationType[LEDArrayAnimationType["FORWARD_SCROLL_MIRROR"] = 4] = "FORWARD_SCROLL_MIRROR";
  /**
   * Flip the pattern and move it in a decrementing direction, starting from the animation end point
   * @public
   */
  LEDArrayAnimationType[LEDArrayAnimationType["REVERSE_SCROLL_MIRROR"] = 5] = "REVERSE_SCROLL_MIRROR";
})(LEDArrayAnimationType || (LEDArrayAnimationType = {}));
/**
 * The measurement range of the sound sensor
 * @public
 */
var SPLRange;
(function (SPLRange) {
  /**
   * Range 102dB
   * @public
   */
  SPLRange[SPLRange["DB_102"] = 1] = "DB_102";
  /**
   * Range 82dB
   * @public
   */
  SPLRange[SPLRange["DB_82"] = 2] = "DB_82";
})(SPLRange || (SPLRange = {}));
/**
 * The mode of the VINT port
 * @public
 */
var HubPortMode;
(function (HubPortMode) {
  /**
   * Communicate with a smart VINT device
   * @public
   */
  HubPortMode[HubPortMode["VINT"] = 0] = "VINT";
  /**
   * 5V Logic-level digital input
   * @public
   */
  HubPortMode[HubPortMode["DIGITAL_INPUT"] = 1] = "DIGITAL_INPUT";
  /**
   * 3.3V digital output
   * @public
   */
  HubPortMode[HubPortMode["DIGITAL_OUTPUT"] = 2] = "DIGITAL_OUTPUT";
  /**
   * 0-5V voltage input for non-ratiometric sensors
   * @public
   */
  HubPortMode[HubPortMode["VOLTAGE_INPUT"] = 3] = "VOLTAGE_INPUT";
  /**
   * 0-5V voltage input for ratiometric sensors
   * @public
   */
  HubPortMode[HubPortMode["VOLTAGE_RATIO_INPUT"] = 4] = "VOLTAGE_RATIO_INPUT";
})(HubPortMode || (HubPortMode = {}));

/** @internal */
const PhidgetErrorDescription = {
  0: 'Success',
  1: 'Not Permitted',
  2: 'No Such Entity',
  3: 'Timed Out',
  58: 'Keep Alive Failure',
  4: 'Op Interrupted',
  5: 'IO Issue',
  6: 'Memory Issue',
  7: 'Access (Permission) Issue',
  8: 'Address Issue',
  9: 'Resource Busy',
  10: 'Object Exists',
  11: 'Object is not a directory',
  12: 'Object is a directory',
  13: 'Invalid',
  14: 'Too many open files in system',
  15: 'Too many open files',
  16: 'Not enough space',
  17: 'File too Big',
  18: 'Read Only Filesystem',
  19: 'Read Only Object',
  20: 'Operation Not Supported',
  21: 'Invalid Argument',
  22: 'Try again',
  26: 'Not Empty',
  28: 'Unexpected Error',
  27: 'Duplicate',
  37: 'Bad Credential',
  45: 'Network Unavailable',
  35: 'Connection Refused',
  46: 'Connection Reset',
  48: 'No route to host',
  40: 'No Such Device',
  50: 'Wrong Device',
  41: 'Broken Pipe',
  44: 'Name Resolution Failure',
  51: 'Unknown or Invalid Value',
  52: 'Device not Attached',
  53: 'Invalid or Unexpected Packet',
  54: 'Argument List Too Long',
  55: 'Bad Version',
  56: 'Closed',
  57: 'Not Configured',
  31: 'End of File',
  59: 'Failsafe Triggered',
  60: 'Invalid Value - Too High',
  61: 'Invalid Value - Too Low',
  62: 'Bad Power Supply',
  63: 'Power Cycle Required',
  64: 'Hall Sensor Error',
  65: 'Bad Current Readings',
  66: 'Bad Connection',
  67: 'NACK'
};

/** @public */
class PhidgetError extends Error {
  constructor(code, message, innerException) {
    let msg = message || PhidgetErrorDescription[code];
    if (innerException != undefined) {
      let innerMsg;
      if (innerException instanceof Error) {
        innerMsg = innerException.message;
      } else if (typeof innerException === 'string') {
        innerMsg = innerException;
      } else {
        innerMsg = JSON.stringify(innerException);
      }
      if (innerMsg.length > 0) msg += ' - ' + innerMsg;
    }
    super(msg);
    if (innerException instanceof Error) this.innerException = innerException;
    if (Error.captureStackTrace) Error.captureStackTrace(this, PhidgetError);
    this.name = "PhidgetError";
    this.errorCode = code;
  }
  get stacks() {
    let _stacks = this.stack;
    if (this.innerException && this.innerException.stack) _stacks += '\n<- ' + this.innerException.stack;
    return _stacks;
  }
}

let loglevel = LogLevel.WARNING;
let logsEnabled = true;
/**
 * The Logging API controls logs sent to the console. By default, warnings and errors are printed.
 * Verbosity of logs can be changed, or logging can be disabled entirely.
 * @public
 */
class Log {
  static setLevel(level) {
    loglevel = level;
  }
  static getLevel() {
    return loglevel;
  }
  /**
   * Enables logging within the Phidget library. Logs are sent to the console.
   * @param level - The logging level
   */
  static enable(level) {
    if (level !== undefined) loglevel = level;
    logsEnabled = true;
  }
  static disable() {
    logsEnabled = false;
  }
  /**
   * Writes a message to the Phidget library log.
   * @param level - The logging level
   * @param message - The message
   */
  static log(level, message) {
    switch (level) {
      case LogLevel.CRITICAL:
        logcrit(message);
        break;
      case LogLevel.ERROR:
        logerr(message);
        break;
      case LogLevel.WARNING:
        logwarn(message);
        break;
      case LogLevel.INFO:
        loginfo(message);
        break;
      case LogLevel.DEBUG:
        logdebug(message);
        break;
      case LogLevel.VERBOSE:
        logverbose(message);
        break;
    }
  }
}
let prevTime = null;
function colouredText(txt, colour) {
  return txt;
}
function log(logger, lvl, msg, obj) {
  if (!logsEnabled) return;
  let msDiffTxt = '';
  {
    const curr = Number(new Date());
    const ms = curr - (prevTime || curr);
    prevTime = curr;
    msDiffTxt = colouredText(' +' + ms + 'ms');
  }
  const m = ('') + ('') + msg + msDiffTxt;
  if (obj) logger(m + ' -', obj);else logger(m);
}
function logcrit(msg, obj) {
  if (loglevel >= LogLevel.CRITICAL) log(console.error, ' <' + colouredText('CRIT') + '>', msg, obj);
}
function logerr(msg, obj) {
  if (loglevel >= LogLevel.ERROR) log(console.error, '<' + colouredText('ERROR') + '>', msg, obj);
}
function logwarn(msg, obj) {
  if (loglevel >= LogLevel.WARNING) log(console.warn, ' <' + colouredText('Warn') + '>', msg, obj);
}
function loginfo(msg, obj) {
  if (loglevel >= LogLevel.INFO) log(console.log, ' <' + 'Info' + '>', msg, obj);
}
function logdebug(msg, obj) {
  if (loglevel >= LogLevel.DEBUG) log(console.debug, '<' + colouredText('Debug') + '>', msg, obj);
}
function logverbose(msg, obj) {
  if (loglevel >= LogLevel.VERBOSE) log(console.debug, ' <' + colouredText('Verb') + '>', msg, obj);
}
function logbuffer(message, buffer) {
  if (loglevel < LogLevel.VERBOSE) return;
  let bytestring = " ";
  let view;
  if (ArrayBuffer.isView(buffer)) {
    view = new DataView(buffer.buffer);
  } else {
    view = new DataView(buffer);
  }
  for (let i = 0; i < view.byteLength; i++) {
    let by = view.getUint8(i).toString(16);
    if (by.length === 1) by = "0" + by;
    bytestring += "0x" + by + ", ";
  }
  bytestring = bytestring.slice(0, bytestring.length - 2);
  logverbose(message + " - " + bytestring);
}
function logEventException(err) {
  logwarn("Unhandled exception in event handler", err);
}

/** @internal */
class PhidgetLock {
  constructor() {
    this._locked = false;
    this.releaseEvents = [];
  }
  onRelease(listener) {
    this.releaseEvents.push(listener);
  }
  removeReleaseListener(listener) {
    const idx = this.releaseEvents.indexOf(listener);
    if (idx > -1) this.releaseEvents.splice(idx, 1);
  }
  emitRelease() {
    const listeners = this.releaseEvents.slice();
    const length = listeners.length;
    for (let i = 0; i < length; i++) listeners[i]();
    logverbose('LOCK Released!');
  }
  acquire() {
    logverbose('LOCK Aquiring..');
    return new _Promise(resolve => {
      if (!this._locked) {
        this._locked = true;
        return resolve();
      }
      const tryAcquire = () => {
        if (!this._locked) {
          this._locked = true;
          this.removeReleaseListener(tryAcquire);
          logverbose('LOCK Aquired!');
          return resolve();
        }
      };
      this.onRelease(tryAcquire);
    });
  }
  release() {
    this._locked = false;
    setTimeout(() => this.emitRelease());
  }
  get locked() {
    return this._locked;
  }
}

const C_LIBRARY_VERSION = "1.24";
/**
 * The base Phidget22 library version for this release - corresponds to the C library version
 * @public
 */
const LibraryVersion = "Phidget22 - Version " + C_LIBRARY_VERSION + " - Built January 27, 2026";
/**
 * The JavaScript library version
 * @public
 */
const JSLibraryVersion = "3.24.1 - January 27, 2026";
const Managers = [];
const Connections = [];
const UserPhidgets = [];
let Epoch;
function tm() {
  if (Epoch == undefined) Epoch = Date.now();
  return Date.now() - Epoch;
}
async function scanChannels(userphid) {
  for (const conn of Connections) {
    if (userphid._isLocal && conn._isRemote) continue;
    if (userphid._isRemote && conn._isLocal) continue;
    if (await conn._match(userphid)) return true;
  }
  return false;
}
async function scanUserPhidgets(ch) {
  for (const userphid of UserPhidgets) {
    if (await ch.tryMatchOpen(userphid)) return;
  }
}
let scanningActive = false;
let scanStopped;
let scanLock;
let scanTimeout;
async function startScanningUserPhidgets() {
  if (!scanLock) scanLock = new PhidgetLock();
  await scanLock.acquire();
  if (scanningActive) {
    scanLock.release();
    return;
  }
  const scan = () => {
    scanTimeout = undefined;
    const again = () => {
      if (scanningActive) {
        scanTimeout = setTimeout(scan, 1000);
      } else {
        if (scanStopped) {
          scanStopped();
          scanStopped = undefined;
        }
      }
    };
    _Promise.all(UserPhidgets.filter(userphid => !userphid._attaching && !userphid._isopen).map(userphid => {
      return scanChannels(userphid);
    })).then(() => {
      again();
    }).catch(err => {
      logerr("Error during User Phidgets scan", err);
      again();
    });
  };
  scanningActive = true;
  loginfo("Starting User Phidget scanning");
  scan();
  scanLock.release();
}
async function stopScanningUserPhidgets() {
  if (!scanLock) scanLock = new PhidgetLock();
  await scanLock.acquire();
  if (!scanningActive) {
    scanLock.release();
    return;
  }
  scanningActive = false;
  if (scanTimeout != undefined) {
    clearTimeout(scanTimeout);
  } else {
    const scanStopPromise = new _Promise(resolve => {
      scanStopped = resolve;
    });
    await scanStopPromise;
  }
  loginfo("User Phidget scanning Stopped");
  scanLock.release();
}
function managerDeviceAttach(dev) {
  for (const m of Managers) m._deviceAttach(dev);
}
function managerDeviceDetach(dev) {
  for (const m of Managers) m._deviceDetach(dev);
}
function managerChannelAttach(ch) {
  for (const m of Managers) m._channelAttach(ch);
}
function managerChannelDetach(ch) {
  for (const m of Managers) m._channelDetach(ch);
}

let _onConnectionRemoved = null;
let _onConnectionAdded = null;
function onConnectionRemoved(conn) {
  if (_onConnectionRemoved) _onConnectionRemoved(conn);
}
function onConnectionAdded(conn) {
  if (_onConnectionAdded) _onConnectionAdded(conn);
}
let ConnectionID = 0;
/** @public */
class PhidgetConnection {
  static setOnConnectionRemoved(func) {
    _onConnectionRemoved = func;
  }
  static setOnConnectionAdded(func) {
    _onConnectionAdded = func;
  }
  /** @internal */
  constructor(opts) {
    this.onError = null;
    if (opts != undefined && typeof opts !== 'object') throw new Error('Options argument must be an object');
    this._id = ConnectionID++;
    this.connected = false;
    this._channels = new Map();
    this._devices = new Map();
    this.name = '';
    if (opts != undefined) {
      if (opts.name != undefined && typeof opts.name === 'string') this.name = opts.name;
      if (opts.onError != undefined && typeof opts.onError === 'function') this.onError = opts.onError;
    }
    if (this.onError === undefined) {
      this.onError = function (code, msg) {
        logerr("Connection error: " + msg + ':0x' + code.toString(16));
      };
    }
    Connections.push(this);
    onConnectionAdded(this);
  }
  delete() {
    if (this.connected) throw new PhidgetError(ErrorCode.BUSY, 'close connection before deleting');
    onConnectionRemoved(this);
    if (_includesInstanceProperty(Connections).call(Connections, this)) Connections.splice(Connections.indexOf(this), 1);
  }
  getKey() {
    return this._id;
  }
  get key() {
    return this._id;
  }
  /** @internal */
  get _isLocal() {
    return this._type === 0;
  }
  /** @internal */
  get _isRemote() {
    return this._type === 1;
  }
  /** @internal */
  _getChannel(id) {
    const ch = this._channels.get(id);
    if (ch == undefined) throw new PhidgetError(ErrorCode.UNEXPECTED, 'invalid channel id:' + id);
    return ch;
  }
  /** @internal */
  _getDevice(id) {
    const dev = this._devices.get(id);
    if (dev == undefined) return null;
    return dev;
  }
  /** @internal */
  _detachAllDevices() {
    while (this._devices.size > 0) {
      var _context;
      const last = Array.from(_valuesInstanceProperty(_context = this._devices).call(_context))[this._devices.size - 1];
      try {
        this._deviceDetach(last);
      } catch (err) {
        logerr("Error while detaching all devices", err);
      }
    }
  }
  /** @internal */
  _deviceAttach(dev) {
    if (this._devices.has(dev.id)) throw new PhidgetError(ErrorCode.DUPLICATE, 'duplicate device:' + dev);
    (dev.isHubPort ? logverbose : loginfo)("Device Attach: " + dev);
    this._devices.set(dev.id, dev);
    managerDeviceAttach(dev);
  }
  /** @internal */
  _deviceDetach(dev) {
    if (!this._devices.has(dev.id)) throw new PhidgetError(ErrorCode.NO_SUCH_ENTITY, 'no such device:' + dev);
    for (const ch of this._channels.entries()) {
      if (ch[1].parent === dev) {
        logverbose("Channel Detach: " + ch[1]);
        managerChannelDetach(ch[1]);
        ch[1].detach();
        this._channels.delete(ch[0]);
      }
    }
    (dev.isHubPort ? logverbose : loginfo)("Device Detach: " + dev);
    managerDeviceDetach(dev);
    this._devices.delete(dev.id);
  }
  /** @internal */
  _channelAttach(ch) {
    if (this._channels.has(ch.id)) throw new PhidgetError(ErrorCode.DUPLICATE, 'duplicate channel:' + ch);
    logverbose("Channel Attach: " + ch);
    this._channels.set(ch.id, ch);
    managerChannelAttach(ch);
    scanUserPhidgets(ch).catch(err => {
      logerr("Error scanning user phidgets", err);
    });
  }
  /** @internal */
  async _match(userphid) {
    for (const ch of _valuesInstanceProperty(_context2 = this._channels).call(_context2)) {
      var _context2;
      if (await ch.tryMatchOpen(userphid)) return true;
    }
    return false;
  }
}

/** @internal */
class Request {
  constructor(dataOrLength, flgs, reqseq, repseq, type, stype) {
    if (typeof dataOrLength === 'number') {
      if (flgs === undefined || reqseq === undefined || repseq === undefined || type === undefined || stype === undefined) throw new Error("Invalid Input");
      this.len = dataOrLength;
      this.flgs = flgs;
      this.reqseq = reqseq;
      this.repseq = repseq;
      this.type = type;
      this.stype = stype;
      this.hdrlen = 16;
    } else {
      this.hdrlen = this.parse(dataOrLength);
    }
  }
  toString() {
    return '{flags:0x' + this.flgs.toString(16) + ' len:' + this.len + ' reqseq:' + this.reqseq + ' repseq:' + this.repseq + ' type:' + this.type + ' subtype:' + this.stype + '}';
  }
  parse(buf) {
    const magic = buf[3] << 24 | buf[2] << 16 | buf[1] << 8 | buf[0];
    this.len = buf[7] << 24 | buf[6] << 16 | buf[5] << 8 | buf[4];
    this.flgs = buf[9] << 8 | buf[8];
    this.reqseq = buf[11] << 8 | buf[10];
    this.repseq = buf[13] << 8 | buf[12];
    this.type = buf[14];
    this.stype = buf[15];
    if (magic != 1346914608) throw new Error("Bad Request Magic");
    return 16;
  }
  get buffer() {
    const array = new Uint8Array(16);
    array[3] = 1346914608 >> 24 & 0xff;
    array[2] = 1346914608 >> 16 & 0xff;
    array[1] = 1346914608 >> 8 & 0xff;
    array[0] = 1346914608 & 0xff;
    array[7] = this.len >> 24 & 0xff;
    array[6] = this.len >> 16 & 0xff;
    array[5] = this.len >> 8 & 0xff;
    array[4] = this.len & 0xff;
    array[9] = this.flgs >> 8 & 0xff;
    array[8] = this.flgs & 0xff;
    array[11] = this.reqseq >> 8 & 0xff;
    array[10] = this.reqseq & 0xff;
    array[13] = this.repseq >> 8 & 0xff;
    array[12] = this.repseq & 0xff;
    array[14] = this.type;
    array[15] = this.stype;
    return array;
  }
}

var regexpFlagsDetection;
var hasRequiredRegexpFlagsDetection;
function requireRegexpFlagsDetection () {
	if (hasRequiredRegexpFlagsDetection) return regexpFlagsDetection;
	hasRequiredRegexpFlagsDetection = 1;
	var globalThis =  requireGlobalThis();
	var fails =  requireFails();
	var RegExp = globalThis.RegExp;
	var FLAGS_GETTER_IS_CORRECT = !fails(function () {
	  var INDICES_SUPPORT = true;
	  try {
	    RegExp('.', 'd');
	  } catch (error) {
	    INDICES_SUPPORT = false;
	  }
	  var O = {};
	  var calls = '';
	  var expected = INDICES_SUPPORT ? 'dgimsy' : 'gimsy';
	  var addGetter = function (key, chr) {
	    Object.defineProperty(O, key, { get: function () {
	      calls += chr;
	      return true;
	    } });
	  };
	  var pairs = {
	    dotAll: 's',
	    global: 'g',
	    ignoreCase: 'i',
	    multiline: 'm',
	    sticky: 'y'
	  };
	  if (INDICES_SUPPORT) pairs.hasIndices = 'd';
	  for (var key in pairs) addGetter(key, pairs[key]);
	  var result = Object.getOwnPropertyDescriptor(RegExp.prototype, 'flags').get.call(O);
	  return result !== expected || calls !== expected;
	});
	regexpFlagsDetection = { correct: FLAGS_GETTER_IS_CORRECT };
	return regexpFlagsDetection;
}

var regexpFlags;
var hasRequiredRegexpFlags;
function requireRegexpFlags () {
	if (hasRequiredRegexpFlags) return regexpFlags;
	hasRequiredRegexpFlags = 1;
	var anObject =  requireAnObject();
	regexpFlags = function () {
	  var that = anObject(this);
	  var result = '';
	  if (that.hasIndices) result += 'd';
	  if (that.global) result += 'g';
	  if (that.ignoreCase) result += 'i';
	  if (that.multiline) result += 'm';
	  if (that.dotAll) result += 's';
	  if (that.unicode) result += 'u';
	  if (that.unicodeSets) result += 'v';
	  if (that.sticky) result += 'y';
	  return result;
	};
	return regexpFlags;
}

var regexpGetFlags;
var hasRequiredRegexpGetFlags;
function requireRegexpGetFlags () {
	if (hasRequiredRegexpGetFlags) return regexpGetFlags;
	hasRequiredRegexpGetFlags = 1;
	var call =  requireFunctionCall();
	var hasOwn =  requireHasOwnProperty();
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var regExpFlagsDetection =  requireRegexpFlagsDetection();
	var regExpFlagsGetterImplementation =  requireRegexpFlags();
	var RegExpPrototype = RegExp.prototype;
	regexpGetFlags = regExpFlagsDetection.correct ? function (it) {
	  return it.flags;
	} : function (it) {
	  return (!regExpFlagsDetection.correct && isPrototypeOf(RegExpPrototype, it) && !hasOwn(it, 'flags'))
	    ? call(regExpFlagsGetterImplementation, it)
	    : it.flags;
	};
	return regexpGetFlags;
}

var flags$2;
var hasRequiredFlags$3;
function requireFlags$3 () {
	if (hasRequiredFlags$3) return flags$2;
	hasRequiredFlags$3 = 1;
	var getRegExpFlags =  requireRegexpGetFlags();
	flags$2 = getRegExpFlags;
	return flags$2;
}

var flags_1;
var hasRequiredFlags$2;
function requireFlags$2 () {
	if (hasRequiredFlags$2) return flags_1;
	hasRequiredFlags$2 = 1;
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var flags =  requireFlags$3();
	var RegExpPrototype = RegExp.prototype;
	flags_1 = function (it) {
	  return (it === RegExpPrototype || isPrototypeOf(RegExpPrototype, it)) ? flags(it) : it.flags;
	};
	return flags_1;
}

var flags$1;
var hasRequiredFlags$1;
function requireFlags$1 () {
	if (hasRequiredFlags$1) return flags$1;
	hasRequiredFlags$1 = 1;
	var parent =  requireFlags$2();
	flags$1 = parent;
	return flags$1;
}

var flags;
var hasRequiredFlags;
function requireFlags () {
	if (hasRequiredFlags) return flags;
	hasRequiredFlags = 1;
	flags =  requireFlags$1();
	return flags;
}

var flagsExports = requireFlags();
var _flagsInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(flagsExports);

/** @internal */
const BPE_ISEVENT_FLAG = 0x01;
/** @internal */
class BridgePacket {
  constructor(conn, data) {
    if (conn != undefined && data != undefined) {
      this.version = data.v;
      this.source = data.s;
      this.flags = data.f;
      this.vpkt = data.p;
      this.ch = conn._getChannel(data.O);
      this.entryCount = data.c;
      this.entries = data.e;
      this.local = false;
    } else {
      this.version = 0;
      this.source = 2;
      this.flags = 0;
      this.entryCount = 0;
      this.entries = {};
      this.local = true;
    }
  }
  isEvent() {
    if (_flagsInstanceProperty(this) & BPE_ISEVENT_FLAG) return true;
    return false;
  }
  entryType(type) {
    switch (type) {
      case 'c':
      case 'h':
      case 'uh':
      case 'd':
      case 'u':
      case 'l':
      case 'ul':
        return 1;
      case 'f':
      case 'g':
        return 2;
      case 's':
        return 3;
      case 'R':
      case 'I':
      case 'G':
      case 'U':
      case 'H':
        return 4;
      case 'J':
        return 5;
      default:
        return -1;
    }
  }
  validate(e) {
    switch (this.entryType(e.type)) {
      case 1:
        if (typeof e.value !== 'number') {
          const num = Number(e.value);
          if (Number.isNaN(num)) throw new TypeError('Expected number but got ' + typeof e.value);
          e.value = num;
        }
        e.value = Math.round(e.value);
        return;
      case 2:
        if (typeof e.value !== 'number') {
          const num = Number(e.value);
          if (Number.isNaN(num)) throw new TypeError('Expected number but got ' + typeof e.value);
          e.value = num;
        }
        return;
      case 3:
        if (typeof e.value == 'string') return;
        throw new TypeError('Expected string but got ' + typeof e.value);
      case 5:
        if (typeof e.value === 'object') return;
        throw new TypeError('Expected object but got ' + typeof e.value);
      case 4:
        if (Array.isArray(e.value)) return;
        throw new TypeError('Expected an Array but got ' + typeof e.value);
      default:
        throw new Error('Invalid entry type: ' + e.type);
    }
  }
  set(val) {
    this.validate(val);
    if (val.name in this.entries) throw new Error('value [' + val.name + '] already set');
    const e = {
      t: val.type,
      v: val.value
    };
    this.entries[val.name] = e;
    this.entryCount++;
  }
  remove(name) {
    const entry = {
      t: name};
    if (!(entry.t in this.entries)) return;
    const filteredEntries = {};
    for (const e in this.entries) {
      if (e !== entry.t) {
        filteredEntries[e] = this.entries[e];
      }
    }
    this.entries = filteredEntries;
    this.entryCount--;
  }
  add(val) {
    val.name = this.entryCount.toString();
    this.set(val);
  }
  getJsonOut(ch) {
    if (this.vpkt == undefined) throw new Error('vpkt not set!');
    const bp = {
      v: this.version,
      s: this.source,
      f: _flagsInstanceProperty(this),
      p: this.vpkt,
      I: ch.parent.id,
      X: ch.uniqueIndex,
      c: this.entryCount,
      e: this.entries
    };
    return bp;
  }
  async send(ch, vpkt) {
    let callBridgeInput = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    if (!ch || !ch.isopen) throw new PhidgetError(ErrorCode.NOT_ATTACHED);
    this.vpkt = vpkt;
    const response = await ch.send(this);
    if (callBridgeInput) ch.bridgeInput(this);
    return response;
  }
  deliver() {
    if (!this.ch) throw new PhidgetError(ErrorCode.UNEXPECTED, 'Bridge packet missing channel');
    if (this.ch.isopen === false) return;
    this.ch.bridgeInput(this);
  }
  sendToChannel(ch, vpkt) {
    this.vpkt = vpkt;
    ch.clearErrorEvent();
    ch.bridgeInput(this);
  }
  getNumber(name) {
    if (!(name in this.entries)) throw new Error("BP entry '".concat(name, "' does not exist."));
    const type = this.entryType(this.entries[name].t);
    if (type != 2 && type != 1) throw new Error("BP entry '".concat(name, "' is not a number."));
    if (typeof this.entries[name].v !== 'number') throw new Error("BP entry '".concat(name, "' has an unexpected value!"));
    return this.entries[name].v;
  }
  getArray(name) {
    if (!(name in this.entries)) throw new Error("BP entry '".concat(name, "' does not exist."));
    const type = this.entryType(this.entries[name].t);
    if (type != 4) throw new Error("BP entry '".concat(name, "' is not an array."));
    if (!Array.isArray(this.entries[name].v)) throw new Error("BP entry '".concat(name, "' has an unexpected value!"));
    return this.entries[name].v;
  }
  getObject(name) {
    if (!(name in this.entries)) throw new Error("BP entry '".concat(name, "' does not exist."));
    const type = this.entryType(this.entries[name].t);
    if (type != 5) throw new Error("BP entry '".concat(name, "' is not an object."));
    if (typeof this.entries[name].v !== 'object') throw new Error("BP entry '".concat(name, "' has an unexpected value!"));
    return this.entries[name].v;
  }
  getString(name) {
    if (!(name in this.entries)) throw new Error("BP entry '".concat(name, "' does not exist."));
    const type = this.entryType(this.entries[name].t);
    if (type != 3) throw new Error("BP entry '".concat(name, "' is not a string."));
    if (this.entries[name].v === null) throw new Error("BP entry '".concat(name, "' is null."));
    if (typeof this.entries[name].v !== 'string') throw new Error("BP entry '".concat(name, "' has an unexpected value!"));
    return this.entries[name].v;
  }
  getBoolean(name) {
    if (!(name in this.entries)) throw new Error("BP entry '".concat(name, "' does not exist."));
    const type = this.entryType(this.entries[name].t);
    if (type != 1) throw new Error("BP entry '".concat(name, "' is not a boolean."));
    if (typeof this.entries[name].v !== 'number') throw new Error("BP entry '".concat(name, "' has an unexpected value!"));
    if (this.entries[name].v === 0) return false;
    if (this.entries[name].v === 1) return true;
    if (this.entries[name].v === 2) return 2;
    throw new Error("BP entry '".concat(name, "' has an unexpected value!"));
  }
}

/** @internal */
const ChannelClassName = {
  0: 'PhidgetNone',
  1: 'PhidgetAccelerometer',
  35: 'PhidgetBLDCMotor',
  14: 'PhidgetCapacitiveTouch',
  2: 'PhidgetCurrentInput',
  38: 'PhidgetCurrentOutput',
  3: 'PhidgetDataAdapter',
  4: 'PhidgetDCMotor',
  36: 'PhidgetDictionary',
  5: 'PhidgetDigitalInput',
  6: 'PhidgetDigitalOutput',
  7: 'PhidgetDistanceSensor',
  8: 'PhidgetEncoder',
  32: 'PhidgetFirmwareUpgrade',
  9: 'PhidgetFrequencyCounter',
  33: 'PhidgetGeneric',
  10: 'PhidgetGPS',
  12: 'PhidgetGyroscope',
  13: 'PhidgetHub',
  15: 'PhidgetHumiditySensor',
  16: 'PhidgetIR',
  11: 'PhidgetLCD',
  19: 'PhidgetLEDArray',
  17: 'PhidgetLightSensor',
  18: 'PhidgetMagnetometer',
  34: 'PhidgetMotorPositionController',
  39: 'PhidgetMotorVelocityController',
  37: 'PhidgetPHSensor',
  20: 'PhidgetPowerGuard',
  21: 'PhidgetPressureSensor',
  22: 'PhidgetRCServo',
  23: 'PhidgetResistanceInput',
  24: 'PhidgetRFID',
  25: 'PhidgetSoundSensor',
  26: 'PhidgetSpatial',
  27: 'PhidgetStepper',
  28: 'PhidgetTemperatureSensor',
  29: 'PhidgetVoltageInput',
  30: 'PhidgetVoltageOutput',
  31: 'PhidgetVoltageRatioInput'
};

/** @internal */
const DeviceClassName = {
  0: 'PhidgetNone',
  1: 'PhidgetAccelerometer',
  2: 'PhidgetAdvancedServo',
  3: 'PhidgetAnalog',
  4: 'PhidgetBridge',
  26: 'PhidgetCurrentOutput',
  25: 'PhidgetDataAdapter',
  24: 'PhidgetDictionary',
  5: 'PhidgetEncoder',
  23: 'PhidgetFirmwareUpgrade',
  6: 'PhidgetFrequencyCounter',
  22: 'PhidgetGeneric',
  7: 'PhidgetGPS',
  8: 'PhidgetHub',
  9: 'PhidgetInterfaceKit',
  10: 'PhidgetIR',
  11: 'PhidgetLED',
  12: 'PhidgetLEDArray',
  13: 'PhidgetMotorControl',
  14: 'PhidgetPHSensor',
  15: 'PhidgetRFID',
  16: 'PhidgetServo',
  17: 'PhidgetSpatial',
  18: 'PhidgetStepper',
  19: 'PhidgetTemperatureSensor',
  20: 'PhidgetTextLCD',
  21: 'PhidgetVINT'
};

/**
 * The core Phidget class deals with functionality common to all Phidgets, such as opening and closing them, or setting Attach, Detach, Error event handlers.
 *
 * This class is also used to specify the associations between the Phidget software objects and their corresponding physical devices, and makes it possible to determine which Phidget is which in cases where it might otherwise be ambiguous.
 *
 * This class contains various functions such as **Release**, **Retain**, and **getParent** designed to be used with the **Phidget Manager**. These specialized functions may be safely ignored if your application does not require a **Manager**. You can check the **Manager API** for more information.
 * @public
 */
class PhidgetBase {
  static get ANY_SERIAL_NUMBER() {
    return -1;
  }
  static get ANY_HUB_PORT() {
    return -1;
  }
  static get ANY_CHANNEL() {
    return -1;
  }
  static get ANY_LABEL() {
    return null;
  }
  static get INFINITE_TIMEOUT() {
    return 0;
  }
  static get DEFAULT_TIMEOUT() {
    return 2500;
  }
  static get AUTO_HUBPORTSPEED() {
    return 0;
  }
  /**
   * Gets the attached status of channel. A Phidget is attached after it has been opened and the Phidget library finds and connects to the corresponding hardware device.
   *
   * *   Most API calls are only valid on attached Phidgets.
   * @throws `PhidgetError`
   */
  get attached() {
    return this.getAttached();
  }
  /**
   * get: Gets the channel index of the channel on the device.
   *
   * set: Specifies the channel index to be opened. The default channel is 0. Set to `ANY_CHANNEL` to open any channel on the specified device.
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get channel() {
    return this.getChannel();
  }
  set channel(channel) {
    this.setChannel(channel);
  }
  /**
   * Returns true if this represents a channel, false if this represents a device. Mostly for use alongside `getParent()` to distinguish channel handles from device handles.
   * @throws `PhidgetError`
   */
  get isChannel() {
    return this.getIsChannel();
  }
  /**
   * Gets the channel class of the channel.
   * @throws `PhidgetError`
   */
  get channelClass() {
    return this.getChannelClass();
  }
  /**
   * Gets the name of the channel class the channel belongs to.
   * @throws `PhidgetError`
   */
  get channelClassName() {
    return this.getChannelClassName();
  }
  /**
   * Gets the channel's name. This name serves as a description of the specific nature of the channel.
   * @throws `PhidgetError`
   */
  get channelName() {
    return this.getChannelName();
  }
  /**
   * Controls whether the state of this channel persists across attach and close. By default, channels are reset on attach and close. Note that any defaults listed in the API must be set by the user when Persistence is enabled.
   * @throws `PhidgetError`
   */
  get channelPersistence() {
    return this.getChannelPersistence();
  }
  /**
   * Gets the subclass for this channel. Allows for identifying channels with specific characteristics without needing to know the exact device and channel index.
   * @throws `PhidgetError`
   */
  get channelSubclass() {
    return this.getChannelSubclass();
  }
  /**
   * Gets the connection associated with this Phidget.
   * @throws `PhidgetError`
   */
  get connection() {
    return this.getConnection();
  }
  /**
   * Gets the device class for the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   */
  get deviceClass() {
    return this.getDeviceClass();
  }
  /**
   * Gets the name of the device class for the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   */
  get deviceClassName() {
    return this.getDeviceClassName();
  }
  /**
   * Gets the string which will match the filename of the firmware upgrade file
   * @throws `PhidgetError`
   * @internal
   */
  get deviceFirmwareUpgradeString() {
    return this.getDeviceFirmwareUpgradeString();
  }
  /**
   * Gets the Device ID for the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   */
  get deviceID() {
    return this.getDeviceID();
  }
  /**
   * get: Gets the label of the Phidget which this channel is a part of. A device label is a custom string used to more easily identify a Phidget. Labels are written to a Phidget using `writeDeviceLabel()`, or by right-clicking the device and setting a label in the Phidget Control Panel for Windows.
   *
   * set: Specifies the label of the Phidget to be opened. Leave un-set to open any label. A device label is a custom string used to more easily identify a Phidget. Labels are written to a Phidget using `writeDeviceLabel()`, or by right-clicking the device and setting a label in the Phidget Control Panel for Windows.
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get deviceLabel() {
    return this.getDeviceLabel();
  }
  set deviceLabel(deviceLabel) {
    this.setDeviceLabel(deviceLabel);
  }
  /**
   * Gets the name of the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   */
  get deviceName() {
    return this.getDeviceName();
  }
  /**
   * get: Gets the serial number of the Phidget which this channel is a part of.
   * If the channel is part of a VINT device, this will be the serial number of the VINT Hub the device is attached to.
   *
   * set: Specifies the serial number of the Phidget to be opened. Leave un-set, or set to `ANY_SERIAL_NUMBER` to open any serial number.
   * If the channel is part of a VINT device, this will be the serial number of the VINT Hub the device is attached to.
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get deviceSerialNumber() {
    return this.getDeviceSerialNumber();
  }
  set deviceSerialNumber(deviceSerialNumber) {
    this.setDeviceSerialNumber(deviceSerialNumber);
  }
  /**
   * Gets the SKU (part number) of the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   */
  get deviceSKU() {
    return this.getDeviceSKU();
  }
  /**
   * Gets the firmware version of the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   */
  get deviceVersion() {
    return this.getDeviceVersion();
  }
  /**
   * Gets the vint id for the Phidget which this channel is a part of.
   * @throws `PhidgetError`
   * @internal
   */
  get deviceVINTID() {
    return this.getDeviceVINTID();
  }
  /**
   * Gets the hub that this channel is attached to.
   * @throws `PhidgetError`
   */
  get hub() {
    return this.getHub();
  }
  /**
   * get: Gets the hub port index of the VINT Hub port that the channel is attached to.
   *
   * set: Specifies the hub port index of the VINT Hub port to open this channel on. Leave un-set, or set to `ANY_HUB_PORT` to open the channel on any VINT Hub port
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get hubPort() {
    return this.getHubPort();
  }
  set hubPort(hubPort) {
    this.setHubPort(hubPort);
  }
  /**
   * Gets the number of VINT ports present on the VINT Hub that the channel is attached to.
   * @throws `PhidgetError`
   */
  get hubPortCount() {
    return this.getHubPortCount();
  }
  /**
   * get: Gets whether this channel is a VINT Hub port channel, or part of a VINT device attached to a hub port.
   *
   * set: Specifies whether this channel should be opened on a VINT Hub port directly, or on a VINT device attached to a hub port.
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get isHubPortDevice() {
    return this.getIsHubPortDevice();
  }
  set isHubPortDevice(isHubPortDevice) {
    this.setIsHubPortDevice(isHubPortDevice);
  }
  /**
   * Configures the communication speed for this VINT device. Both the `hubPortSupportsSetSpeed` and `VINTDeviceSupportsSetSpeed` must be true in order to set the hub port speed.Available speeds are: 100000, 160000, 250000, 400000, 500000, 800000 and 1000000. Setting any other speed will select the nearest lower supported speed. The upper speed is bound by the lesser of `maxHubPortSpeed` and `maxVINTDeviceSpeed`. Set the speed to `AUTO_HUBPORTSPEED` to enable Auto Set Speed on Hubs that support it (enabled by default).
   * @throws `PhidgetError`
   */
  get hubPortSpeed() {
    return this.getHubPortSpeed();
  }
  /**
   * The max communication speed of a high-speed capable VINT Port.
   * @throws `PhidgetError`
   */
  get maxHubPortSpeed() {
    return this.getMaxHubPortSpeed();
  }
  /**
   * Indicates that the communication speed of this VINT port can be set automatically.
   * @throws `PhidgetError`
   */
  get hubPortSupportsAutoSetSpeed() {
    return this.getHubPortSupportsAutoSetSpeed();
  }
  /**
   * Indicates that the communication speed of this VINT port can be set.
   * @throws `PhidgetError`
   */
  get hubPortSupportsSetSpeed() {
    return this.getHubPortSupportsSetSpeed();
  }
  /**
   * Gets a key which identifies this device or channel uniquely. This can be useful for correlating attach/detach events from the **Manager**.
   * @throws `PhidgetError`
   */
  get key() {
    return this.getKey();
  }
  /**
   * get: Returns true when this channel is attached directly on the local machine, or false otherwise.
   *
   * set: Set to True if the channel is to be opened locally, and not over a network. If both this and `isRemote` are set to False (the default), the channel will be opened either locally or remotely, on whichever matching channel is found first.
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get isLocal() {
    return this.getIsLocal();
  }
  set isLocal(isLocal) {
    this.setIsLocal(isLocal);
  }
  /**
   * Returns true if `open()` has been called on this channel.
   * @throws `PhidgetError`
   */
  get isOpen() {
    return this.getIsOpen();
  }
  /**
   * Gets the handle of the parent device of the given Phidget handle.
   *
   * For example, this would refer to the device the channel is a part of, or the Hub that a device is plugged into.
   *
   * This is useful when used alongside a **Phidget Manager** to create device trees like the one in the Phidget Control Panel.
   *
   * *   This can be used to travel up the device tree and get device information at each step.
   * *   The root device will return a null handle
   * *   Parent handles always refer to devices. See `getIsChannel()`
   * @throws `PhidgetError`
   */
  get parent() {
    return this.getParent();
  }
  /**
   * get: Returns true when this channel is attached via a Phidget network server, or false otherwise.
   *
   * set:
   *
   * Set to True if the channel is to be opened remotely, rather than locally. If both this and `isLocal` are set to False (the default), the channel will be opened either locally or remotely, on whichever matching channel is found first.
   *
   * If setting this property, it must be set before the channel is opened. The behaviour of setting this property while the channel is open is undefined.
   * @throws `PhidgetError`
   */
  get isRemote() {
    return this.getIsRemote();
  }
  set isRemote(isRemote) {
    this.setIsRemote(isRemote);
  }
  /**
   * The max communication speed of a high-speed capable VINT Device.
   * @throws `PhidgetError`
   */
  get maxVINTDeviceSpeed() {
    return this.getMaxVINTDeviceSpeed();
  }
  /**
   * Indicates that the communication speed of this VINT device can be set automatically.
   * @throws `PhidgetError`
   */
  get VINTDeviceSupportsAutoSetSpeed() {
    return this.getVINTDeviceSupportsAutoSetSpeed();
  }
  /**
   * Indicates that the communication speed of this VINT device can be set.
   * @throws `PhidgetError`
   */
  get VINTDeviceSupportsSetSpeed() {
    return this.getVINTDeviceSupportsSetSpeed();
  }
}

/** @internal */
function AllowChannelPersistence(cls) {
  switch (cls) {
    case ChannelClass.ACCELEROMETER:
      return false;
    case ChannelClass.BLDC_MOTOR:
      return false;
    case ChannelClass.CAPACITIVE_TOUCH:
      return false;
    case ChannelClass.CURRENT_INPUT:
      return false;
    case ChannelClass.DATA_ADAPTER:
      return true;
    case ChannelClass.DC_MOTOR:
      return false;
    case ChannelClass.DICTIONARY:
      return false;
    case ChannelClass.DIGITAL_INPUT:
      return false;
    case ChannelClass.DIGITAL_OUTPUT:
      return true;
    case ChannelClass.DISTANCE_SENSOR:
      return false;
    case ChannelClass.ENCODER:
      return false;
    case ChannelClass.FIRMWARE_UPGRADE:
      return false;
    case ChannelClass.FREQUENCY_COUNTER:
      return false;
    case ChannelClass.GENERIC:
      return false;
    case ChannelClass.GPS:
      return false;
    case ChannelClass.GYROSCOPE:
      return false;
    case ChannelClass.HUB:
      return false;
    case ChannelClass.HUMIDITY_SENSOR:
      return false;
    case ChannelClass.IR:
      return false;
    case ChannelClass.LCD:
      return true;
    case ChannelClass.LEDARRAY:
      return true;
    case ChannelClass.LIGHT_SENSOR:
      return false;
    case ChannelClass.MAGNETOMETER:
      return false;
    case ChannelClass.MOTOR_POSITION_CONTROLLER:
      return false;
    case ChannelClass.MOTOR_VELOCITY_CONTROLLER:
      return false;
    case ChannelClass.PH_SENSOR:
      return false;
    case ChannelClass.POWER_GUARD:
      return true;
    case ChannelClass.PRESSURE_SENSOR:
      return false;
    case ChannelClass.RC_SERVO:
      return true;
    case ChannelClass.RESISTANCE_INPUT:
      return false;
    case ChannelClass.RFID:
      return false;
    case ChannelClass.SOUND_SENSOR:
      return false;
    case ChannelClass.SPATIAL:
      return false;
    case ChannelClass.STEPPER:
      return true;
    case ChannelClass.TEMPERATURE_SENSOR:
      return false;
    case ChannelClass.VOLTAGE_INPUT:
      return false;
    case ChannelClass.VOLTAGE_OUTPUT:
      return true;
    case ChannelClass.VOLTAGE_RATIO_INPUT:
      return false;
    default:
      throw new Error("Invalid Channel Class");
  }
}

/** @public */
class Phidget extends PhidgetBase {
  /**
   * Gets the version of the Phidget library being used by the program in human readable form.
   * @returns The Phidget library version.
   * @throws `PhidgetError`
   */
  static get libraryVersion() {
    return this.getLibraryVersion();
  }
  /**
   * Gets the version of the Phidget library being used by the program in human readable form.
   * @returns The Phidget library version.
   * @throws `PhidgetError`
   */
  static getLibraryVersion() {
    return LibraryVersion;
  }
  /** @internal */
  constructor(chOrDev) {
    super();
    this.onAttach = null;
    this.onDetach = null;
    this.onError = null;
    this.onPropertyChange = null;
    if (chOrDev !== undefined) {
      this._fromManager = true;
      this._isattached = true;
    } else {
      this._fromManager = false;
      this._isattached = false;
    }
  }
}
/** @public */
class PhidgetChannel extends Phidget {
  /** @internal */
  constructor(ch) {
    super(ch);
    this._attaching = false;
    this._useropen = false;
    this._isopen = false;
    this._detaching = false;
    this._isHubPort = false;
    this._channel = Phidget.ANY_CHANNEL;
    this._deviceLabel = Phidget.ANY_LABEL;
    this._serialNumber = Phidget.ANY_SERIAL_NUMBER;
    this._hubPort = Phidget.ANY_HUB_PORT;
    this._isLocal = false;
    this._isRemote = false;
    this._persistence = false;
    this._ch = ch;
  }
  /** @internal */
  _cancelOpenTimeout() {
    if (this._openTimeoutTimer != undefined) {
      clearTimeout(this._openTimeoutTimer);
      delete this._openTimeoutTimer;
    }
    delete this._openTimeout;
    delete this._openTime;
  }
  /** @internal */
  async _wasOpened(ch) {
    this._ch = ch;
    this._isopen = true;
    this._isattached = true;
    this._cancelOpenTimeout();
    if (this.onAttach) {
      try {
        await this.onAttach(this);
      } catch (err) {
        logEventException(err);
      }
    }
    if (this._resolveOpen) this._resolveOpen();
  }
  /** @internal */
  async _close() {
    let fromDetach = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    this._cancelOpenTimeout();
    if (fromDetach) {
      this._useropen = true;
    } else {
      if (_includesInstanceProperty(UserPhidgets).call(UserPhidgets, this)) UserPhidgets.splice(UserPhidgets.indexOf(this), 1);
      if (UserPhidgets.length === 0) await stopScanningUserPhidgets();
    }
    if (this._isopen) {
      try {
        if (this._ch) await this._ch.close();
      } catch (err) {
        logwarn("Error while closing channel", err);
      }
      this._detaching = true;
      this._isattached = false;
      if (this.onDetach) {
        try {
          this.onDetach(this);
        } catch (err) {
          logEventException(err);
        }
      }
      this._detaching = false;
      this._isopen = false;
      delete this._ch;
    } else {
      if (this._rejectOpen != undefined) this._rejectOpen(new PhidgetError(ErrorCode.CLOSED, "Closed while waiting for open"));
    }
  }
  /** @internal */
  _FIREPropertyChange(prop, bp) {
    if (this.onPropertyChange && this._isAttachedDone && (bp === undefined || bp.local !== true)) {
      try {
        this.onPropertyChange(prop);
      } catch (err) {
        logEventException(err);
      }
    }
  }
  /** @internal */
  _FIREError(code, description) {
    if (this.onError) {
      try {
        this.onError(code, description);
      } catch (err) {
        logEventException(err);
      }
    }
  }
  /** @internal */
  _handleSetStatus(bp) {
    for (const e in bp.entries) {
      if (e === '_class_version_') continue;
      if (e === 'dataIntervalDbl') continue;
      if (!(e in this.data)) {
        loginfo("Unknown property: " + e + " in setstatus packet. Probably server is newer than client.");
        continue;
      }
      this.data[e] = bp.entries[e].v;
    }
    if (bp.entries.dataIntervalDbl !== undefined) this.data.dataInterval = bp.entries.dataIntervalDbl.v;
    if (this.data.minDataInterval != undefined && bp.entries.maxDataRate === undefined) this.data.maxDataRate = 1000.0 / this.data.minDataInterval;
    if (this.data.maxDataInterval != undefined && bp.entries.minDataRate === undefined) this.data.minDataRate = 1000.0 / this.data.maxDataInterval;
  }
  /** @internal */
  _assertAttached() {
    if (!this._ch || !this._isattached && !this._detaching) throw new PhidgetError(ErrorCode.NOT_ATTACHED);
  }
  /** @internal */
  _assertOpen() {
    if (!this._ch || !this._isopen || !this._isattached && !this._detaching) throw new PhidgetError(ErrorCode.NOT_ATTACHED);
  }
  /** @internal */
  get _isAttachedDone() {
    if (this._isattached && !this._attaching) return true;
    return false;
  }
  /** @internal */
  get _isAttachedOrDetaching() {
    if (this._isattached || this._detaching) return true;
    return false;
  }
  toString() {
    if (this._ch) return this._ch.toString();
    return this.constructor.name;
  }
  getConnection() {
    if (this._ch) return this._ch.conn;
    return null;
  }
  getKey() {
    this._assertAttached();
    return 'ch' + this._ch.id + "_" + this._ch.conn._id;
  }
  async open() {
    let timeout = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
    if (this._useropen) return;
    this._useropen = true;
    this._openTime = tm();
    if (!isNaN(timeout) && timeout > 0) this._openTimeout = timeout;else delete this._openTimeout;
    UserPhidgets.push(this);
    if (this._fromManager === true) {
      this.setChannel(this.getChannel());
      this.setHubPort(this.getHubPort());
      this.setDeviceSerialNumber(this.getDeviceSerialNumber());
      this.setIsHubPortDevice(this.getIsHubPortDevice());
      this.setIsLocal(this.getIsLocal());
      this.setIsRemote(this.getIsRemote());
      this._fromManager = false;
      this._isattached = false;
      delete this._ch;
    }
    const openPromise = new _Promise((resolve, reject) => {
      this._resolveOpen = resolve;
      this._rejectOpen = reject;
    });
    try {
      await scanChannels(this);
    } catch (err) {
      logerr("Problem during open scan", err);
    }
    await startScanningUserPhidgets();
    if (this._openTimeout) {
      this._openTimeoutTimer = setTimeout(() => {
        delete this._openTimeoutTimer;
        const reject = this._rejectOpen;
        delete this._rejectOpen;
        this.close().then(() => {
          if (reject) reject(new PhidgetError(ErrorCode.TIMEOUT, "Open timed out"));
        }).catch(err => {
          logwarn("Error calling close after open timeout", err);
          if (reject) reject(new PhidgetError(ErrorCode.TIMEOUT, "Open timed out"));
        });
      }, this._openTimeout);
    }
    return openPromise;
  }
  async close() {
    if (this._useropen) {
      logdebug("closing phidget");
      this._useropen = false;
      await this._close();
    }
  }
  getAttached() {
    return this._isattached;
  }
  getIsOpen() {
    return this._useropen;
  }
  getChannel() {
    if (!this._isattached && !this._detaching) return this._channel;
    return this._ch.index;
  }
  setChannel(ch) {
    this._channel = ch;
  }
  getChannelClass() {
    return this._class;
  }
  getChannelClassName() {
    return ChannelClassName[this._class];
  }
  getChannelName() {
    this._assertAttached();
    return this._ch.name;
  }
  getChannelSubclass() {
    this._assertAttached();
    return this._ch.subclass;
  }
  getDeviceClass() {
    this._assertAttached();
    return this._ch.parent.class;
  }
  getDeviceClassName() {
    this._assertAttached();
    return DeviceClassName[this._ch.parent.class];
  }
  getDeviceID() {
    this._assertAttached();
    return this._ch.parent.deviceID;
  }
  getDeviceLabel() {
    if (!this._isattached && !this._detaching) return this._deviceLabel ? this._deviceLabel : '';
    return this._ch.parent.label;
  }
  setDeviceLabel(label) {
    this._deviceLabel = label;
  }
  getDeviceName() {
    this._assertAttached();
    return this._ch.parent.name;
  }
  getDeviceSerialNumber() {
    if (!this._isattached && !this._detaching) return this._serialNumber;
    return this._ch.parent.serialNumber;
  }
  setDeviceSerialNumber(sn) {
    if (!isNaN(sn)) this._serialNumber = sn;
  }
  getDeviceSKU() {
    this._assertAttached();
    return this._ch.parent.sku;
  }
  getDeviceVersion() {
    this._assertAttached();
    return this._ch.parent.version;
  }
  getHub() {
    this._assertAttached();
    let hub = this._ch.parent;
    while (hub != undefined && hub.class !== DeviceClass.HUB) hub = hub.parent;
    if (hub == undefined) throw new PhidgetError(ErrorCode.WRONG_DEVICE, "Hub not found");
    return new PhidgetDevice(hub);
  }
  getHubPort() {
    if (!this._isattached && !this._detaching) return this._hubPort;
    return this._ch.parent.hubPort;
  }
  setHubPort(hubPort) {
    if (!isNaN(hubPort)) this._hubPort = hubPort;
  }
  getHubPortSpeed() {
    this._assertAttached();
    if (this._ch.parent.class !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    if (this._ch.parent.vintDeviceProps.commSpeed == undefined || this._ch.parent.vintDeviceProps.commSpeed == 4294967295) throw new PhidgetError(ErrorCode.UNKNOWN_VALUE);
    return this._ch.parent.vintDeviceProps.commSpeed;
  }
  async setHubPortSpeed(hubPortSpeed) {
    this._assertAttached();
    if (this._ch.parent.class !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    const bp = new BridgePacket();
    bp.set({
      name: '0',
      type: 'u',
      value: hubPortSpeed
    });
    await bp.send(this._ch, 173);
  }
  getIsChannel() {
    return true;
  }
  getIsHubPortDevice() {
    if (!this._isattached && !this._detaching) return this._isHubPort;
    return this._ch.parent.isHubPort;
  }
  setIsHubPortDevice(isHubPort) {
    this._isHubPort = isHubPort;
  }
  getIsLocal() {
    if (!this._isattached && !this._detaching) return this._isLocal;
    return this._ch.parent.conn._isLocal;
  }
  setIsLocal(isLocal) {
    this._isLocal = isLocal;
  }
  getIsRemote() {
    if (!this._isattached && !this._detaching) return this._isRemote;
    return this._ch.parent.conn._isRemote;
  }
  setIsRemote(isRemote) {
    this._isRemote = isRemote;
  }
  getParent() {
    this._assertAttached();
    return new PhidgetDevice(this._ch.parent);
  }
  getDeviceFirmwareUpgradeString() {
    this._assertAttached();
    return this._ch.parent.fwstr;
  }
  async writeDeviceLabel(deviceLabel) {
    this._assertOpen();
    const bp = new BridgePacket();
    bp.set({
      name: "0",
      type: "s",
      value: deviceLabel
    });
    await bp.send(this._ch, 140);
  }
  getDeviceChannelCount(cls) {
    this._assertAttached();
    let count = 0;
    for (const ch of this._ch.parent.devDef.ch) {
      if (cls != undefined && ch.c == undefined) throw new PhidgetError(ErrorCode.UNSUPPORTED);
      if (cls == undefined || ch.c === cls) count++;
    }
    return count;
  }
  getDeviceVINTID() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this._ch.parent.vintID;
  }
  getHubPortCount() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT && this.deviceClass !== DeviceClass.HUB) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this.hub._device.hubPortProps.length;
  }
  getHubPortSupportsSetSpeed() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this.hub._device.hubPortProps[this.hubPort].portSuppSetSpeed;
  }
  getHubPortSupportsAutoSetSpeed() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this.hub._device.hubPortProps[this.hubPort].portSuppAutoSetSpeed;
  }
  getMaxHubPortSpeed() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    if (this.hub._device.hubPortProps[this.hubPort].portMaxSpeed === 4294967295) throw new PhidgetError(ErrorCode.UNKNOWN_VALUE);
    return this.hub._device.hubPortProps[this.hubPort].portMaxSpeed;
  }
  getVINTDeviceSupportsSetSpeed() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this._ch.parent.vintDeviceProps.suppSetSpeed;
  }
  getVINTDeviceSupportsAutoSetSpeed() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this._ch.parent.vintDeviceProps.suppAutoSetSpeed;
  }
  getMaxVINTDeviceSpeed() {
    this._assertAttached();
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    if (this._ch.parent.vintDeviceProps.maxSpeed === 4294967295) throw new PhidgetError(ErrorCode.UNKNOWN_VALUE);
    return this._ch.parent.vintDeviceProps.maxSpeed;
  }
  async reboot() {
    this._assertOpen();
    const bp = new BridgePacket();
    await bp.send(this._ch, 139, false);
  }
  async rebootFirmwareUpgrade(upgradeTimeout) {
    this._assertOpen();
    const bp = new BridgePacket();
    bp.set({
      name: "0",
      type: "u",
      value: upgradeTimeout
    });
    await bp.send(this._ch, 138, false);
  }
  getChannelPersistence() {
    if (this._isattached || this._detaching) return this._ch.persistence;
    return this._persistence;
  }
  async setChannelPersistence(channelPersistence) {
    if (!AllowChannelPersistence(this.channelClass)) throw new PhidgetError(ErrorCode.UNSUPPORTED, "Channel persistence is not supported for this channel class");
    this._persistence = channelPersistence;
    if (this._isopen && this._isattached) {
      const bp = new BridgePacket();
      bp.set({
        name: "0",
        type: "d",
        value: channelPersistence ? 1 : 0
      });
      await bp.send(this._ch, 211);
    }
  }
}
/** @public */
class PhidgetDevice extends Phidget {
  /** @internal */
  constructor(dev) {
    super(dev);
    this._device = dev;
    this.name = "PhidgetDevice";
  }
  toString() {
    return this._device.toString();
  }
  getConnection() {
    return this._device.conn;
  }
  getKey() {
    return 'dev' + this._device.id + "_" + this._device.conn._id;
  }
  getAttached() {
    return true;
  }
  getIsOpen() {
    return false;
  }
  getDeviceClass() {
    return this._device.class;
  }
  getDeviceClassName() {
    return DeviceClassName[this._device.class];
  }
  getDeviceID() {
    return this._device.deviceID;
  }
  getDeviceLabel() {
    return this._device.label;
  }
  getDeviceName() {
    return this._device.name;
  }
  getDeviceSerialNumber() {
    return this._device.serialNumber;
  }
  getDeviceSKU() {
    return this._device.sku;
  }
  getDeviceVersion() {
    return this._device.version;
  }
  getHub() {
    let hub = this._device;
    while (hub != undefined && hub.class !== DeviceClass.HUB) hub = hub.parent;
    if (hub == undefined) throw new PhidgetError(ErrorCode.WRONG_DEVICE, "Hub not found");
    return new PhidgetDevice(hub);
  }
  getHubPort() {
    return this._device.hubPort;
  }
  getHubPortSpeed() {
    if (this._device.class !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    if (this._device.vintDeviceProps.commSpeed == undefined || this._device.vintDeviceProps.commSpeed == 4294967295) throw new PhidgetError(ErrorCode.UNKNOWN_VALUE);
    return this._device.vintDeviceProps.commSpeed;
  }
  getIsChannel() {
    return false;
  }
  getIsHubPortDevice() {
    return this._device.isHubPort;
  }
  getIsLocal() {
    return this._device.conn._isLocal;
  }
  getIsRemote() {
    return this._device.conn._isRemote;
  }
  getParent() {
    const parent = this._device.parent;
    if (!parent) return null;
    return new PhidgetDevice(parent);
  }
  getDeviceFirmwareUpgradeString() {
    return this._device.fwstr;
  }
  getDeviceChannelCount(cls) {
    let count = 0;
    for (const ch of this._device.devDef.ch) {
      if (cls != undefined && ch.c == undefined) throw new PhidgetError(ErrorCode.UNSUPPORTED);
      if (cls == undefined || ch.c === cls) count++;
    }
    return count;
  }
  getDeviceVINTID() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this._device.vintID;
  }
  getHubPortCount() {
    if (this.deviceClass !== DeviceClass.VINT && this.deviceClass !== DeviceClass.HUB) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this.hub._device.hubPortProps.length;
  }
  getHubPortSupportsSetSpeed() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this.hub._device.hubPortProps[this.hubPort].portSuppSetSpeed;
  }
  getHubPortSupportsAutoSetSpeed() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this.hub._device.hubPortProps[this.hubPort].portSuppAutoSetSpeed;
  }
  getMaxHubPortSpeed() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    if (this.hub._device.hubPortProps[this.hubPort].portMaxSpeed === 4294967295) throw new PhidgetError(ErrorCode.UNKNOWN_VALUE);
    return this.hub._device.hubPortProps[this.hubPort].portMaxSpeed;
  }
  getVINTDeviceSupportsSetSpeed() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this._device.vintDeviceProps.suppSetSpeed;
  }
  getVINTDeviceSupportsAutoSetSpeed() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    return this._device.vintDeviceProps.suppAutoSetSpeed;
  }
  getMaxVINTDeviceSpeed() {
    if (this.deviceClass !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
    if (this._device.vintDeviceProps.maxSpeed === 4294967295) throw new PhidgetError(ErrorCode.UNKNOWN_VALUE);
    return this._device.vintDeviceProps.maxSpeed;
  }
  getChannel() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setChannel(_channel) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  getChannelClass() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  getChannelClassName() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  getChannelName() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  getChannelSubclass() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  close() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setDeviceLabel(_deviceLabel) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setDeviceSerialNumber(_deviceSerialNumber) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setHubPort(_hubPort) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setHubPortSpeed(_hubPortSpeed) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setIsHubPortDevice(_isHubPortDevice) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setIsLocal(_isLocal) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setIsRemote(_isRemote) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  open(_timeout) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  writeDeviceLabel(_deviceLabel) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  reboot() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  rebootFirmwareUpgrade(_upgradeTimeout) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  getChannelPersistence() {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
  setChannelPersistence(_channelPersistence) {
    throw new PhidgetError(ErrorCode.UNEXPECTED);
  }
}

/** @internal */
class Channel {
  get subclass() {
    var _a;
    return (_a = this.chDef.s) !== null && _a !== void 0 ? _a : ChannelSubclass.NONE;
  }
  get isHubPort() {
    return this.parent.isHubPort;
  }
  constructor(conn, dev, data) {
    this.lastErrorEventCode = null;
    this.lastErrorEventDesc = '';
    this.lastErrorEventTime = 0;
    this.conn = conn;
    this.parent = dev;
    this.id = data.id;
    this.chDef = data.chDef;
    this.uniqueIndex = data.uniqueIndex;
    this.index = data.index;
    this.isopen = false;
    this.persistence = false;
  }
  match(userphid) {
    if (userphid._attaching || userphid._isattached) return false;
    if (userphid._class !== this.class) return false;
    if (userphid._serialNumber !== Phidget.ANY_SERIAL_NUMBER) {
      if (userphid._serialNumber != this.parent.serialNumber) return false;
    }
    if (userphid._channel !== Phidget.ANY_CHANNEL) {
      if (userphid._channel != this.index) return false;
    }
    if (userphid._hubPort !== Phidget.ANY_HUB_PORT) {
      if (userphid._hubPort != this.parent.hubPort) return false;
    }
    if (userphid._isHubPort !== this.isHubPort) return false;
    if (userphid._deviceLabel !== Phidget.ANY_LABEL) {
      if (userphid._deviceLabel !== this.parent.label) return false;
    }
    if (userphid._isLocal && this.conn._isRemote) return false;
    if (userphid._isRemote && this.conn._isLocal) return false;
    logdebug("matched:" + userphid + " -> " + this);
    return true;
  }
  async tryMatchOpen(userphid) {
    if (this.match(userphid)) {
      try {
        await this.open(userphid);
        return true;
      } catch (err) {
        if (userphid.onError) {
          try {
            if (err instanceof PhidgetError) {
              let code;
              switch (err.errorCode) {
                case ErrorCode.BUSY:
                  code = ErrorEventCode.BUSY;
                  break;
                case ErrorCode.BAD_VERSION:
                  code = ErrorEventCode.BAD_VERSION;
                  break;
                case ErrorCode.FAILSAFE:
                  code = ErrorEventCode.FAILSAFE_CONDITION;
                  break;
                case ErrorCode.UNKNOWN_VALUE:
                  code = ErrorEventCode.OUT_OF_RANGE;
                  break;
                case ErrorCode.UNKNOWN_VALUE_HIGH:
                  code = ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION;
                  break;
                case ErrorCode.UNKNOWN_VALUE_LOW:
                  code = ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION;
                  break;
                case ErrorCode.BAD_POWER:
                case ErrorCode.POWER_CYCLE:
                  code = ErrorEventCode.BAD_POWER;
                  break;
                case ErrorCode.HALLSENSOR:
                case ErrorCode.BADCONNECTION:
                  code = ErrorEventCode.BAD_CONNECTION_CONDITION;
                  break;
                case ErrorCode.BADCURRENT:
                  code = ErrorEventCode.BAD_CURRENT;
                  break;
                default:
                  code = ErrorEventCode.FAILURE;
                  break;
              }
              userphid.onError(code, err.message);
            } else if (err instanceof Error) {
              userphid.onError(ErrorEventCode.FAILURE, err.message);
            } else {
              userphid.onError(ErrorEventCode.FAILURE, "Error during open");
            }
          } catch (err) {
            logEventException(err);
          }
        } else {
          logerr("Error opening channel", err);
        }
      }
    }
    return false;
  }
  detach() {
    if (this.isopen) {
      if (this.userphid) {
        this.detaching = true;
        this.userphid._close(true).then(() => {
          this.isopen = false;
          delete this.userphid;
          delete this.detaching;
        }).catch(err => {
          this.isopen = false;
          delete this.userphid;
          delete this.detaching;
          logwarn("Error closing during detach", err);
        });
      }
    }
  }
  toString() {
    if (this.parent.class === DeviceClass.VINT) {
      if (this.isHubPort) return this.name + ' Ch:' + this.index + ' -> ' + this.parent.sku + ' Port:' + this.parent.hubPort + ' Serial#:' + this.parent.serialNumber;
      return this.name + ' Ch:' + this.index + ' -> ' + this.parent.sku + ' -> ' + this.parent.parent.sku + ' Port:' + this.parent.hubPort + ' Serial#:' + this.parent.serialNumber;
    }
    return this.name + ' Ch:' + this.index + ' -> ' + this.parent.sku + ' Serial#:' + this.parent.serialNumber;
  }
  supportedBridgePacket(bp) {
    var _context;
    if (this.chDef.p == undefined || _includesInstanceProperty(_context = this.chDef.p).call(_context, bp)) return true;
    return false;
  }
  bridgeInput(bp) {
    if (!this.userphid) return;
    switch (bp.vpkt) {
      case 0:
        this.userphid._handleSetStatus(bp);
        break;
      case 17:
        if (this.userphid._errorHandler) this.userphid._errorHandler(bp.getNumber(0));
        if (this.userphid.onError) {
          try {
            this.userphid.onError(bp.getNumber(0), bp.getString(1));
          } catch (err) {
            logEventException(err);
          }
        }
        break;
      case 172:
        this.parent.label = bp.getString(0);
        this.userphid._FIREPropertyChange('DeviceLabel', bp);
        break;
      case 176:
        this.parent.vintDeviceProps.commSpeed = bp.getNumber(0);
        this.userphid._FIREPropertyChange('HubPortSpeed', bp);
        break;
      case 139:
      case 138:
        break;
      case 173:
        if (this.conn._isRemote) this.parent.vintDeviceProps.commSpeed = bp.getNumber(0);
        break;
      case 140:
        if (this.conn._isRemote) this.parent.label = bp.getString(0);
        break;
      case 211:
        this.persistence = !!bp.getNumber(0);
        this.userphid._FIREPropertyChange('ChannelPersistence', bp);
        break;
      default:
        {
          if (!this.supportedBridgePacket(bp.vpkt)) throw new PhidgetError(ErrorCode.UNSUPPORTED);
          this.userphid._bridgeInput(bp);
          if (this.userphid._onInitialState && this.userphid._hasInitialState()) this.userphid._onInitialState();
          break;
        }
    }
  }
  sendErrorEvent(bp) {
    const code = bp.getNumber(0);
    const desc = bp.getString(1);
    const now = Date.now();
    if (this.lastErrorEventCode === code && this.lastErrorEventDesc === desc) {
      if (now - this.lastErrorEventTime < 1000) return;
    }
    this.lastErrorEventCode = code;
    this.lastErrorEventDesc = desc;
    this.lastErrorEventTime = now;
    bp.vpkt = 17;
    this.bridgeInput(bp);
  }
  clearErrorEvent() {
    this.lastErrorEventCode = null;
  }
}

/** @internal */
class NetworkChannel extends Channel {
  constructor(conn, dev, data) {
    super(conn, dev, data);
    this.cpversion = data.cpversion;
    this.name = data.name;
    this.class = data.class;
  }
  async open(userphid) {
    try {
      this.persistence = userphid._persistence;
      const devInfo = {
        phid: this.parent.id,
        channel: this.id,
        class: this.class,
        index: this.uniqueIndex,
        version: this.cpversion,
        chreset: this.persistence ? 0 : 1
      };
      userphid._attaching = true;
      const status = await this.conn._sendRequest(0, 0, 0, 30, 60, devInfo);
      userphid._attaching = false;
      this.isopen = true;
      this.userphid = userphid;
      const bp = new BridgePacket(this.conn, status);
      bp.deliver();
      await userphid._wasOpened(this);
    } catch (err) {
      userphid._attaching = false;
      userphid._isattached = false;
      throw err;
    }
  }
  async close() {
    if (this.detaching) return;
    const closePkt = {
      phid: this.parent.id,
      index: this.uniqueIndex,
      chreset: this.persistence ? 0 : 1
    };
    await this.conn._sendRequest(0, 0, 0, 30, 65, closePkt);
  }
  async send(bp) {
    const pkt = bp.getJsonOut(this);
    const response = await this.conn._sendRequest(0, 0, 0, 30, 70, pkt);
    return response;
  }
}

/** @internal */
const PhidgetDevices = {
  VINT: [{
    uid: 22,
    d: 9,
    c: 21,
    t: "PhidgetInterfaceKit 0/0/4",
    s: "1014",
    i: 64,
    v: [800, 900],
    ch: [{
      uid: 36,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [82, 55, 147, 146]
    }]
  }, {
    uid: 27,
    d: 12,
    c: 21,
    t: "PhidgetInterfaceKit 0/0/8",
    s: "1017",
    i: 135,
    v: [200, 300],
    ch: [{
      uid: 41,
      t: "Signal Relay",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55, 147, 146]
    }]
  }, {
    uid: 36,
    d: 14,
    c: 21,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 57,
    v: [300, 310],
    ch: [{
      uid: 68,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 69,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 70,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 71,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 38,
    d: 14,
    c: 21,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 57,
    v: [310, 320],
    ch: [{
      uid: 76,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 77,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 78,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 79,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 40,
    d: 14,
    c: 21,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 57,
    v: [320, 400],
    ch: [{
      uid: 84,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 85,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 86,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 87,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 98,
    d: 95,
    c: 21,
    t: "Hub Port - Digital Input Mode",
    s: "DIGITALINPUT_PORT",
    i: 1,
    v: [100, 200],
    ch: [{
      uid: 213,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 99,
    d: 96,
    c: 21,
    t: "Hub Port - Digital Output Mode",
    s: "DIGITALOUTPUT_PORT",
    i: 2,
    v: [100, 110],
    ch: [{
      uid: 214,
      t: "Digital Output",
      c: 6,
      s: 16,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 100,
    d: 96,
    c: 21,
    t: "Hub Port - Digital Output Mode",
    s: "DIGITALOUTPUT_PORT",
    i: 2,
    v: [110, 200],
    ch: [{
      uid: 215,
      t: "Digital Output",
      c: 6,
      s: 16,
      i: 0,
      p: [55, 82, 147, 146]
    }]
  }, {
    uid: 101,
    d: 97,
    c: 21,
    t: "Hub Port - Voltage Input Mode",
    s: "VOLTAGEINPUT_PORT",
    i: 3,
    v: [100, 110],
    ch: [{
      uid: 216,
      t: "Voltage Input",
      c: 29,
      s: 48,
      i: 0,
      p: [54, 79, 46, 122, 101, 115]
    }]
  }, {
    uid: 102,
    d: 97,
    c: 21,
    t: "Hub Port - Voltage Input Mode",
    s: "VOLTAGEINPUT_PORT",
    i: 3,
    v: [110, 200],
    ch: [{
      uid: 217,
      t: "Voltage Input",
      c: 29,
      s: 48,
      i: 0,
      p: [54, 79, 46, 122, 101, 115]
    }]
  }, {
    uid: 103,
    d: 97,
    c: 21,
    t: "Hub Port - Voltage Input Mode",
    s: "VOLTAGEINPUT_PORT",
    i: 3,
    v: [200, 300],
    ch: [{
      uid: 218,
      t: "Voltage Input",
      c: 29,
      s: 48,
      i: 0,
      p: [54, 79, 46, 122, 101, 115]
    }]
  }, {
    uid: 104,
    d: 98,
    c: 21,
    t: "Hub Port - Voltage Ratio Mode",
    s: "VOLTAGERATIOINPUT_PORT",
    i: 4,
    v: [100, 200],
    ch: [{
      uid: 219,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      i: 0,
      p: [54, 79, 46, 122, 102, 115]
    }]
  }, {
    uid: 105,
    d: 98,
    c: 21,
    t: "Hub Port - Voltage Ratio Mode",
    s: "VOLTAGERATIOINPUT_PORT",
    i: 4,
    v: [200, 300],
    ch: [{
      uid: 220,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      i: 0,
      p: [54, 79, 46, 122, 102, 115]
    }]
  }, {
    uid: 106,
    d: 49,
    c: 21,
    t: "pH Adapter Phidget",
    s: "ADP1000",
    i: 29,
    v: [100, 200],
    ch: [{
      uid: 221,
      t: "PH Sensor Input",
      c: 37,
      i: 0,
      p: [54, 46, 134, 133]
    }, {
      uid: 222,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 79, 46, 87, 122, 101, 115]
    }]
  }, {
    uid: 108,
    d: 134,
    c: 21,
    t: "I2C Adapter Phidget",
    s: "ADP0001",
    i: 134,
    v: [200, 300],
    ch: [{
      uid: 226,
      t: "Data Adapter",
      c: 3,
      i: 0,
      p: [202, 157, 168, 208]
    }, {
      uid: 227,
      t: "Digital Input",
      c: 5,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 64, 168, 90]
    }, {
      uid: 228,
      t: "Digital Output",
      c: 6,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 55, 82, 168]
    }]
  }, {
    uid: 110,
    d: 160,
    c: 21,
    t: "SPI Adapter Phidget",
    s: "ADP0002",
    i: 160,
    v: [100, 200],
    ch: [{
      uid: 232,
      t: "Data Adapter",
      c: 3,
      i: 0,
      p: [202, 157, 160, 163, 199, 165, 168, 118, 169]
    }, {
      uid: 233,
      t: "Digital Input",
      c: 5,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 168, 90]
    }, {
      uid: 234,
      t: "Digital Output",
      c: 6,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 55, 82, 168]
    }]
  }, {
    uid: 112,
    d: 161,
    c: 21,
    t: "Addressable LED Phidget",
    s: "LED0100",
    i: 161,
    v: [100, 200],
    ch: [{
      uid: 237,
      t: "LED Array",
      c: 19,
      i: 0,
      p: [56, 205, 206, 162, 118, 4, 203, 207, 204]
    }, {
      uid: 238,
      t: "Current Input",
      c: 2,
      i: 0,
      p: [181, 8]
    }]
  }, {
    uid: 113,
    d: 51,
    c: 21,
    t: "8x Voltage Input Phidget",
    s: "DAQ1000",
    i: 50,
    v: [100, 110],
    ch: [{
      uid: 239,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [54, 79, 46, 122, 102, 115]
    }, {
      uid: 240,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [54, 79, 46, 122, 101, 115]
    }]
  }, {
    uid: 114,
    d: 51,
    c: 21,
    t: "8x Voltage Input Phidget",
    s: "DAQ1000",
    i: 50,
    v: [110, 200],
    ch: [{
      uid: 241,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [54, 79, 46, 122, 102, 115]
    }, {
      uid: 242,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [54, 79, 46, 122, 101, 115]
    }]
  }, {
    uid: 116,
    d: 75,
    c: 21,
    t: "12-bit Voltage Output Phidget",
    s: "OUT1000",
    i: 41,
    v: [100, 110],
    ch: [{
      uid: 245,
      t: "Voltage Output",
      c: 30,
      i: 0,
      p: [56, 86]
    }]
  }, {
    uid: 117,
    d: 75,
    c: 21,
    t: "12-bit Voltage Output Phidget",
    s: "OUT1000",
    i: 41,
    v: [110, 200],
    ch: [{
      uid: 246,
      t: "Voltage Output",
      c: 30,
      i: 0,
      p: [56, 86, 147, 146]
    }]
  }, {
    uid: 118,
    d: 76,
    c: 21,
    t: "Isolated 12-bit Voltage Output Phidget",
    s: "OUT1001",
    i: 42,
    v: [100, 110],
    ch: [{
      uid: 247,
      t: "Voltage Output",
      c: 30,
      i: 0,
      p: [86, 87]
    }]
  }, {
    uid: 119,
    d: 76,
    c: 21,
    t: "Isolated 12-bit Voltage Output Phidget",
    s: "OUT1001",
    i: 42,
    v: [110, 200],
    ch: [{
      uid: 248,
      t: "Voltage Output",
      c: 30,
      i: 0,
      p: [86, 87, 147, 146]
    }]
  }, {
    uid: 120,
    d: 77,
    c: 21,
    t: "Isolated 16-bit Voltage Output Phidget",
    s: "OUT1002",
    i: 43,
    v: [100, 110],
    ch: [{
      uid: 249,
      t: "Voltage Output",
      c: 30,
      i: 0,
      p: [86, 87]
    }]
  }, {
    uid: 121,
    d: 77,
    c: 21,
    t: "Isolated 16-bit Voltage Output Phidget",
    s: "OUT1002",
    i: 43,
    v: [110, 200],
    ch: [{
      uid: 250,
      t: "Voltage Output",
      c: 30,
      i: 0,
      p: [86, 87, 147, 146]
    }]
  }, {
    uid: 124,
    d: 52,
    c: 21,
    t: "4x Digital Input Phidget",
    s: "DAQ1200",
    i: 28,
    v: [100, 200],
    ch: [{
      uid: 253,
      t: "Digital Input",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 125,
    d: 78,
    c: 21,
    t: "4x Digital Output Phidget",
    s: "OUT1100",
    i: 25,
    v: [100, 110],
    ch: [{
      uid: 254,
      t: "Digital Output",
      c: 6,
      s: 16,
      n: 4,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 126,
    d: 78,
    c: 21,
    t: "4x Digital Output Phidget",
    s: "OUT1100",
    i: 25,
    v: [110, 120],
    ch: [{
      uid: 255,
      t: "Digital Output",
      c: 6,
      s: 16,
      n: 4,
      i: 0,
      p: [55, 82, 147, 146]
    }]
  }, {
    uid: 127,
    d: 78,
    c: 21,
    t: "4x Digital Output Phidget",
    s: "OUT1100",
    i: 25,
    v: [120, 200],
    ch: [{
      uid: 256,
      t: "Digital Output",
      c: 6,
      s: 18,
      n: 4,
      i: 0,
      p: [55, 82, 156, 147, 146]
    }]
  }, {
    uid: 128,
    d: 53,
    c: 21,
    t: "4x Isolated Digital Input Phidget",
    s: "DAQ1300",
    i: 32,
    v: [100, 200],
    ch: [{
      uid: 257,
      t: "Digital Input Isolated",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 129,
    d: 54,
    c: 21,
    t: "16x Isolated Digital Input Phidget",
    s: "DAQ1301",
    i: 54,
    v: [100, 200],
    ch: [{
      uid: 258,
      t: "Digital Input Isolated",
      c: 5,
      n: 16,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 130,
    d: 55,
    c: 21,
    t: "Versatile Input Phidget",
    s: "DAQ1400",
    i: 34,
    v: [100, 120],
    ch: [{
      uid: 259,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [181, 54, 74, 79, 46, 122, 101, 115]
    }, {
      uid: 260,
      t: "Current Input",
      c: 2,
      i: 0,
      p: [181, 54, 46, 74, 8]
    }, {
      uid: 261,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [181, 182, 64, 74, 90]
    }, {
      uid: 262,
      t: "Frequency Input",
      c: 9,
      i: 0,
      p: [181, 182, 21, 54, 64, 74, 20, 7]
    }]
  }, {
    uid: 131,
    d: 55,
    c: 21,
    t: "Versatile Input Phidget",
    s: "DAQ1400",
    i: 34,
    v: [120, 130],
    ch: [{
      uid: 263,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [181, 54, 74, 79, 46, 122, 101, 115]
    }, {
      uid: 264,
      t: "Current Input",
      c: 2,
      i: 0,
      p: [181, 54, 46, 74, 8]
    }, {
      uid: 265,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [181, 182, 64, 74, 90]
    }, {
      uid: 266,
      t: "Frequency Input",
      c: 9,
      i: 0,
      p: [181, 182, 21, 54, 64, 74, 20, 7]
    }]
  }, {
    uid: 132,
    d: 55,
    c: 21,
    t: "Versatile Input Phidget",
    s: "DAQ1400",
    i: 34,
    v: [130, 200],
    ch: [{
      uid: 267,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [181, 54, 74, 79, 46, 122, 101, 115]
    }, {
      uid: 268,
      t: "Current Input",
      c: 2,
      i: 0,
      p: [181, 54, 46, 74, 8]
    }, {
      uid: 269,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [181, 182, 64, 74, 90]
    }, {
      uid: 270,
      t: "Frequency Input",
      c: 9,
      i: 0,
      p: [181, 182, 21, 54, 64, 74, 20, 7]
    }]
  }, {
    uid: 133,
    d: 56,
    c: 21,
    t: "Wheatstone Bridge Phidget",
    s: "DAQ1500",
    i: 24,
    v: [100, 200],
    ch: [{
      uid: 271,
      t: "Bridge Input",
      c: 31,
      s: 65,
      n: 2,
      i: 0,
      p: [45, 54, 46, 56, 102]
    }]
  }, {
    uid: 134,
    d: 105,
    c: 21,
    t: "30A Current Sensor Phidget",
    s: "VCP1100",
    i: 64,
    v: [100, 200],
    ch: [{
      uid: 272,
      t: "Current Input",
      c: 2,
      i: 0,
      p: [54, 46, 8]
    }]
  }, {
    uid: 135,
    d: 57,
    c: 21,
    t: "DC Motor Phidget",
    s: "DCC1000",
    i: 47,
    v: [100, 200],
    ch: [{
      uid: 273,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      p: [54, 40, 44, 51, 119, 55, 58, 121, 16]
    }, {
      uid: 274,
      t: "Encoder Input",
      c: 8,
      s: 96,
      i: 0,
      p: [54, 46, 65, 29]
    }, {
      uid: 275,
      t: "Voltage Ratio",
      c: 31,
      s: 64,
      i: 0,
      p: [54, 46, 79, 122, 102, 115]
    }, {
      uid: 276,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 277,
      t: "Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 136,
    d: 57,
    c: 21,
    t: "DC Motor Phidget",
    s: "DCC1000",
    i: 47,
    v: [200, 210],
    ch: [{
      uid: 278,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [54, 40, 44, 51, 119, 55, 58, 121, 16]
    }, {
      uid: 279,
      t: "Encoder Input",
      c: 8,
      s: 96,
      i: 0,
      p: [54, 46, 65, 29]
    }, {
      uid: 280,
      t: "Voltage Ratio",
      c: 31,
      s: 64,
      i: 0,
      p: [54, 46, 79, 122, 102, 115]
    }, {
      uid: 281,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 282,
      t: "Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }, {
      uid: 283,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [40, 54, 51, 119, 57, 55, 83, 58, 120, 65, 135, 136, 142, 147, 146, 29, 16]
    }]
  }, {
    uid: 137,
    d: 57,
    c: 21,
    t: "DC Motor Phidget",
    s: "DCC1000",
    i: 47,
    v: [210, 300],
    ch: [{
      uid: 284,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [54, 40, 44, 51, 119, 55, 58, 147, 146, 121, 16]
    }, {
      uid: 285,
      t: "Encoder Input",
      c: 8,
      s: 96,
      i: 0,
      p: [54, 46, 65, 29]
    }, {
      uid: 286,
      t: "Voltage Ratio",
      c: 31,
      s: 64,
      i: 0,
      p: [54, 46, 79, 122, 102, 115]
    }, {
      uid: 287,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 288,
      t: "Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }, {
      uid: 289,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [40, 54, 51, 119, 57, 55, 83, 58, 120, 65, 135, 136, 142, 147, 146, 29, 16]
    }]
  }, {
    uid: 138,
    d: 128,
    c: 21,
    t: "30V 50A DC Motor Phidget",
    s: "DCC1020",
    i: 66,
    v: [100, 200],
    ch: [{
      uid: 290,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [10, 54, 46, 29]
    }, {
      uid: 291,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [185, 10, 195, 197, 196, 54, 40, 44, 51, 194, 55, 184, 186, 192, 193, 147, 146, 121, 16]
    }, {
      uid: 292,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 293,
      t: "Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }, {
      uid: 294,
      t: "Supply Voltage Sensor",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }, {
      uid: 295,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [185, 10, 195, 197, 196, 40, 54, 51, 194, 57, 55, 83, 120, 135, 142, 136, 184, 189, 192, 193, 147, 146, 29, 188, 16]
    }, {
      uid: 296,
      t: "Velocity Controller",
      c: 39,
      i: 0,
      e: 0,
      p: [185, 10, 195, 197, 196, 40, 54, 51, 194, 57, 55, 135, 142, 136, 184, 191, 120, 192, 193, 147, 146, 100, 16, 190]
    }]
  }, {
    uid: 140,
    d: 110,
    c: 21,
    t: "2A DC Motor Phidget",
    s: "DCC1001",
    i: 68,
    v: [100, 120],
    ch: [{
      uid: 304,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [54, 40, 44, 51, 55, 121, 16]
    }, {
      uid: 305,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [54, 46, 29]
    }, {
      uid: 306,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [40, 54, 51, 57, 55, 83, 120, 135, 136, 142, 29, 16]
    }]
  }, {
    uid: 141,
    d: 110,
    c: 21,
    t: "2A DC Motor Phidget",
    s: "DCC1001",
    i: 68,
    v: [120, 200],
    ch: [{
      uid: 307,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [54, 40, 44, 51, 55, 147, 146, 121, 16]
    }, {
      uid: 308,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [54, 46, 29]
    }, {
      uid: 309,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [40, 54, 51, 57, 55, 83, 120, 135, 136, 142, 147, 146, 29, 16]
    }]
  }, {
    uid: 142,
    d: 117,
    c: 21,
    t: "4A DC Motor Phidget",
    s: "DCC1002",
    i: 70,
    v: [100, 110],
    ch: [{
      uid: 310,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [54, 40, 44, 51, 55, 121, 16]
    }, {
      uid: 311,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [54, 46, 29]
    }, {
      uid: 312,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [40, 54, 51, 57, 55, 83, 120, 135, 136, 142, 29, 16]
    }]
  }, {
    uid: 143,
    d: 117,
    c: 21,
    t: "4A DC Motor Phidget",
    s: "DCC1002",
    i: 70,
    v: [110, 200],
    ch: [{
      uid: 313,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      e: 0,
      p: [54, 40, 44, 51, 55, 147, 146, 121, 16]
    }, {
      uid: 314,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [54, 46, 29]
    }, {
      uid: 315,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [40, 54, 51, 57, 55, 83, 120, 135, 136, 142, 147, 146, 29, 16]
    }]
  }, {
    uid: 144,
    d: 120,
    c: 21,
    t: "2x DC Motor Phidget",
    s: "DCC1003",
    i: 73,
    v: [100, 110],
    ch: [{
      uid: 316,
      t: "DC Motor Controller",
      c: 4,
      n: 2,
      i: 0,
      p: [54, 40, 44, 51, 55, 121, 16]
    }]
  }, {
    uid: 145,
    d: 120,
    c: 21,
    t: "2x DC Motor Phidget",
    s: "DCC1003",
    i: 73,
    v: [110, 200],
    ch: [{
      uid: 317,
      t: "DC Motor Controller",
      c: 4,
      n: 2,
      i: 0,
      p: [54, 40, 44, 51, 55, 147, 146, 121, 16]
    }]
  }, {
    uid: 146,
    d: 108,
    c: 21,
    t: "Brushless DC Motor Phidget",
    s: "DCC1100",
    i: 65,
    v: [100, 120],
    ch: [{
      uid: 318,
      t: "Brushless DC Motor Controller",
      c: 35,
      i: 0,
      e: 0,
      p: [54, 40, 44, 55, 141, 121, 29, 16]
    }, {
      uid: 319,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 320,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [54, 40, 55, 57, 83, 120, 135, 136, 142, 141, 147, 146, 29, 16]
    }]
  }, {
    uid: 147,
    d: 108,
    c: 21,
    t: "Brushless DC Motor Phidget",
    s: "DCC1100",
    i: 65,
    v: [120, 200],
    ch: [{
      uid: 321,
      t: "Brushless DC Motor Controller",
      c: 35,
      i: 0,
      e: 0,
      p: [54, 40, 44, 55, 141, 147, 146, 121, 29, 16]
    }, {
      uid: 322,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 323,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [54, 40, 55, 57, 83, 120, 135, 136, 142, 141, 147, 146, 29, 16]
    }]
  }, {
    uid: 149,
    d: 150,
    c: 21,
    t: "30V 50A Brushless DC Motor Phidget",
    s: "DCC1120",
    i: 148,
    v: [100, 200],
    ch: [{
      uid: 327,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [10, 54, 46, 29]
    }, {
      uid: 328,
      t: "Brushless DC Motor Controller",
      c: 35,
      i: 0,
      e: 0,
      p: [185, 10, 195, 197, 196, 54, 40, 44, 51, 194, 55, 184, 186, 192, 193, 147, 146, 121, 29, 16]
    }, {
      uid: 329,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }, {
      uid: 330,
      t: "Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }, {
      uid: 331,
      t: "Supply Voltage Sensor",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }, {
      uid: 332,
      t: "Position Controller",
      c: 34,
      i: 0,
      e: 0,
      p: [185, 10, 195, 197, 196, 40, 54, 51, 194, 57, 55, 83, 120, 135, 142, 136, 184, 187, 189, 192, 193, 147, 146, 29, 188, 16]
    }, {
      uid: 333,
      t: "Velocity Controller",
      c: 39,
      i: 0,
      e: 0,
      p: [185, 10, 195, 197, 196, 40, 54, 51, 194, 57, 55, 135, 142, 136, 184, 187, 191, 120, 192, 193, 147, 146, 100, 16, 190]
    }]
  }, {
    uid: 151,
    d: 58,
    c: 21,
    t: "Distance Phidget",
    s: "DST1000",
    i: 45,
    v: [100, 200],
    ch: [{
      uid: 341,
      t: "Distance Sensor 200mm",
      c: 7,
      i: 0,
      p: [54, 46, 12]
    }]
  }, {
    uid: 152,
    d: 121,
    c: 21,
    t: "Distance Phidget 650mm",
    s: "DST1001",
    i: 121,
    v: [100, 200],
    ch: [{
      uid: 342,
      t: "Distance Sensor 650mm",
      c: 7,
      i: 0,
      p: [54, 46, 12]
    }]
  }, {
    uid: 153,
    d: 126,
    c: 21,
    t: "Distance Phidget 1300mm",
    s: "DST1002",
    i: 126,
    v: [100, 200],
    ch: [{
      uid: 343,
      t: "Distance Sensor 1300mm",
      c: 7,
      i: 0,
      p: [54, 46, 12]
    }]
  }, {
    uid: 154,
    d: 59,
    c: 21,
    t: "Sonar Phidget",
    s: "DST1200",
    i: 46,
    v: [100, 200],
    ch: [{
      uid: 344,
      t: "Sonar Distance Sensor",
      c: 7,
      i: 0,
      p: [54, 46, 75, 12, 88]
    }]
  }, {
    uid: 155,
    d: 60,
    c: 21,
    t: "Quadrature Encoder Phidget",
    s: "ENC1000",
    i: 18,
    v: [100, 200],
    ch: [{
      uid: 345,
      t: "Encoder Input",
      c: 8,
      s: 96,
      i: 0,
      p: [54, 46, 56, 65, 29]
    }]
  }, {
    uid: 156,
    d: 155,
    c: 21,
    t: "Quadrature Encoder Phidget",
    s: "ENC1001",
    i: 75,
    v: [100, 200],
    ch: [{
      uid: 346,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [10, 54, 46, 56, 29]
    }]
  }, {
    uid: 157,
    d: 109,
    c: 21,
    t: "Phidget Dial",
    s: "HIN1101",
    i: 67,
    v: [100, 200],
    ch: [{
      uid: 347,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [54, 46, 56, 29]
    }, {
      uid: 348,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 158,
    d: 61,
    c: 21,
    t: "Touch Keypad Phidget",
    s: "HIN1000",
    i: 36,
    v: [100, 200],
    ch: [{
      uid: 349,
      t: "Capacitive Touch Sensor",
      c: 14,
      n: 7,
      i: 0,
      p: [46, 54, 66, 96, 137]
    }]
  }, {
    uid: 159,
    d: 62,
    c: 21,
    t: "Touch Wheel Phidget",
    s: "HIN1001",
    i: 56,
    v: [100, 200],
    ch: [{
      uid: 350,
      t: "Capacitive Touch Sensor",
      c: 14,
      n: 4,
      i: 0,
      p: [46, 54, 66, 96, 137]
    }, {
      uid: 351,
      t: "Capacitive Scroll Wheel",
      c: 14,
      i: 4,
      p: [46, 54, 66, 96, 137]
    }]
  }, {
    uid: 160,
    d: 63,
    c: 21,
    t: "Thumbstick Phidget",
    s: "HIN1100",
    i: 37,
    v: [100, 200],
    ch: [{
      uid: 352,
      t: "Thumbstick Axis",
      c: 31,
      n: 2,
      i: 0,
      p: [54, 46, 102]
    }, {
      uid: 353,
      t: "Thumbstick Button",
      c: 5,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 161,
    d: 69,
    c: 21,
    t: "Humidity Phidget",
    s: "HUM1000",
    i: 20,
    v: [100, 200],
    ch: [{
      uid: 354,
      t: "Humidity Sensor",
      c: 15,
      i: 0,
      p: [54, 46, 22]
    }, {
      uid: 355,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }]
  }, {
    uid: 162,
    d: 127,
    c: 21,
    t: "Humidity Phidget",
    s: "HUM1001",
    i: 127,
    v: [100, 200],
    ch: [{
      uid: 356,
      t: "Humidity Sensor",
      c: 15,
      i: 0,
      p: [54, 46, 22]
    }, {
      uid: 357,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }]
  }, {
    uid: 163,
    d: 70,
    c: 21,
    t: "Graphic LCD Phidget",
    s: "LCD1100",
    i: 40,
    v: [100, 200],
    ch: [{
      uid: 358,
      t: "Graphic LCD",
      c: 11,
      s: 80,
      i: 0,
      p: [43, 48, 62, 80, 47, 4, 6, 13, 14, 15, 19, 61, 38, 104, 105]
    }]
  }, {
    uid: 164,
    d: 70,
    c: 21,
    t: "Graphic LCD Phidget",
    s: "LCD1100",
    i: 23,
    v: [200, 300],
    ch: [{
      uid: 359,
      t: "Graphic LCD",
      c: 11,
      s: 80,
      i: 0,
      p: [43, 48, 62, 80, 47, 4, 6, 13, 14, 15, 19, 61, 38, 104, 105]
    }]
  }, {
    uid: 165,
    d: 71,
    c: 21,
    t: "32x Isolated LED Phidget",
    s: "LED1000",
    i: 39,
    v: [100, 200],
    ch: [{
      uid: 360,
      t: "LED Driver",
      c: 6,
      s: 17,
      n: 32,
      i: 0,
      p: [210, 55, 67, 68, 82]
    }]
  }, {
    uid: 166,
    d: 72,
    c: 21,
    t: "Light Phidget",
    s: "LUX1000",
    i: 33,
    v: [100, 200],
    ch: [{
      uid: 361,
      t: "Light Sensor",
      c: 17,
      i: 0,
      p: [54, 46, 23]
    }]
  }, {
    uid: 167,
    d: 136,
    c: 21,
    t: "Soil Moisture Phidget",
    s: "HUM1100",
    i: 136,
    v: [100, 200],
    ch: [{
      uid: 362,
      t: "Moisture Sensor",
      c: 31,
      i: 0,
      p: [54, 46, 102]
    }]
  }, {
    uid: 168,
    d: 73,
    c: 21,
    t: "Accelerometer Phidget",
    s: "MOT1100",
    i: 51,
    v: [200, 300],
    ch: [{
      uid: 363,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }]
  }, {
    uid: 170,
    d: 146,
    c: 21,
    t: "PhidgetAccelerometer",
    s: "MOT0100",
    i: 146,
    v: [100, 200],
    ch: [{
      uid: 365,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }]
  }, {
    uid: 171,
    d: 74,
    c: 21,
    t: "Spatial Phidget",
    s: "MOT1101",
    i: 52,
    v: [100, 200],
    ch: [{
      uid: 366,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }, {
      uid: 367,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [54, 106, 2]
    }, {
      uid: 368,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [54, 46, 50, 37, 35, 18]
    }, {
      uid: 369,
      t: "Spatial",
      c: 26,
      i: 0,
      p: [54, 106, 50, 37, 35, 89]
    }]
  }, {
    uid: 172,
    d: 137,
    c: 21,
    t: "Spatial Phidget",
    s: "MOT1102",
    i: 137,
    v: [200, 300],
    ch: [{
      uid: 370,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }, {
      uid: 371,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [54, 106, 2]
    }, {
      uid: 372,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [54, 46, 50, 37, 35, 18]
    }, {
      uid: 373,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [54, 149, 151, 106, 50, 37, 35, 174, 150, 89, 148]
    }]
  }, {
    uid: 173,
    d: 137,
    c: 21,
    t: "Spatial Phidget",
    s: "MOT1102",
    i: 140,
    v: [300, 400],
    ch: [{
      uid: 374,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }, {
      uid: 375,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [54, 106, 2]
    }, {
      uid: 376,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [54, 46, 50, 37, 35, 18]
    }, {
      uid: 377,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [54, 149, 151, 106, 50, 37, 35, 174, 150, 89, 148]
    }]
  }, {
    uid: 176,
    d: 141,
    c: 21,
    t: "PhidgetSpatial Precision 3/3/3",
    s: "MOT0110",
    i: 141,
    v: [100, 200],
    ch: [{
      uid: 388,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 179, 54, 46, 170, 1]
    }, {
      uid: 389,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 179, 54, 170, 106, 2]
    }, {
      uid: 390,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 179, 54, 46, 170, 50, 37, 35, 18]
    }, {
      uid: 391,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [10, 179, 54, 149, 170, 106, 50, 37, 35, 174, 150, 89, 148]
    }, {
      uid: 392,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [10, 54, 46, 95]
    }]
  }, {
    uid: 177,
    d: 79,
    c: 21,
    t: "Barometer Phidget",
    s: "PRE1000",
    i: 17,
    v: [100, 200],
    ch: [{
      uid: 393,
      t: "Barometer",
      c: 21,
      i: 0,
      p: [54, 46, 31]
    }]
  }, {
    uid: 178,
    d: 80,
    c: 21,
    t: "16x RC Servo Phidget",
    s: "RCC1000",
    i: 49,
    v: [100, 110],
    ch: [{
      uid: 394,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 16,
      i: 0,
      p: [209, 69, 70, 83, 57, 86, 85, 40, 81, 94]
    }]
  }, {
    uid: 179,
    d: 80,
    c: 21,
    t: "16x RC Servo Phidget",
    s: "RCC1000",
    i: 49,
    v: [110, 200],
    ch: [{
      uid: 395,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 16,
      i: 0,
      p: [209, 69, 70, 83, 57, 86, 85, 40, 81, 147, 146, 94]
    }]
  }, {
    uid: 180,
    d: 80,
    c: 21,
    t: "16x RC Servo Phidget",
    s: "RCC1000",
    i: 58,
    v: [200, 300],
    ch: [{
      uid: 396,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 16,
      i: 0,
      p: [209, 69, 70, 83, 57, 86, 85, 40, 81, 147, 146, 94]
    }]
  }, {
    uid: 181,
    d: 81,
    c: 21,
    t: "4x Relay Phidget",
    s: "REL1000",
    i: 44,
    v: [100, 110],
    ch: [{
      uid: 397,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 182,
    d: 81,
    c: 21,
    t: "4x Relay Phidget",
    s: "REL1000",
    i: 44,
    v: [110, 200],
    ch: [{
      uid: 398,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [55, 82, 147, 146]
    }]
  }, {
    uid: 183,
    d: 82,
    c: 21,
    t: "4x Isolated Solid State Relay Phidget",
    s: "REL1100",
    i: 26,
    v: [100, 110],
    ch: [{
      uid: 399,
      t: "Digital Output Isolated",
      c: 6,
      s: 16,
      n: 4,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 184,
    d: 82,
    c: 21,
    t: "4x Isolated Solid State Relay Phidget",
    s: "REL1100",
    i: 26,
    v: [110, 120],
    ch: [{
      uid: 400,
      t: "Digital Output Isolated",
      c: 6,
      s: 16,
      n: 4,
      i: 0,
      p: [55, 82, 147, 146]
    }]
  }, {
    uid: 185,
    d: 82,
    c: 21,
    t: "4x Isolated Solid State Relay Phidget",
    s: "REL1100",
    i: 26,
    v: [120, 200],
    ch: [{
      uid: 401,
      t: "Digital Output Isolated",
      c: 6,
      s: 18,
      n: 4,
      i: 0,
      p: [55, 82, 156, 147, 146]
    }]
  }, {
    uid: 186,
    d: 83,
    c: 21,
    t: "16x Isolated Solid State Relay Phidget",
    s: "REL1101",
    i: 27,
    v: [100, 110],
    ch: [{
      uid: 402,
      t: "Digital Output Isolated",
      c: 6,
      s: 16,
      n: 16,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 187,
    d: 83,
    c: 21,
    t: "16x Isolated Solid State Relay Phidget",
    s: "REL1101",
    i: 27,
    v: [110, 200],
    ch: [{
      uid: 403,
      t: "Digital Output Isolated",
      c: 6,
      s: 16,
      n: 16,
      i: 0,
      p: [55, 82, 147, 146]
    }]
  }, {
    uid: 188,
    d: 83,
    c: 21,
    t: "16x Isolated Solid State Relay Phidget",
    s: "REL1101",
    i: 130,
    v: [100, 300],
    ch: [{
      uid: 404,
      t: "Digital Output Isolated Frequency Control",
      c: 6,
      s: 18,
      n: 8,
      i: 0,
      p: [55, 82, 156, 147, 146]
    }, {
      uid: 405,
      t: "Digital Output Isolated",
      c: 6,
      s: 16,
      n: 8,
      i: 8,
      p: [55, 82, 147, 146]
    }]
  }, {
    uid: 190,
    d: 84,
    c: 21,
    t: "Programmable Power Guard Phidget",
    s: "SAF1000",
    i: 38,
    v: [100, 110],
    ch: [{
      uid: 407,
      t: "Power Supply Protector",
      c: 20,
      i: 0,
      p: [56, 71, 58]
    }, {
      uid: 408,
      t: "Voltage Sensor",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }, {
      uid: 409,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }]
  }, {
    uid: 191,
    d: 84,
    c: 21,
    t: "Programmable Power Guard Phidget",
    s: "SAF1000",
    i: 38,
    v: [110, 200],
    ch: [{
      uid: 410,
      t: "Power Supply Protector",
      c: 20,
      i: 0,
      p: [56, 71, 58, 147, 146]
    }, {
      uid: 411,
      t: "Voltage Sensor",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }, {
      uid: 412,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }]
  }, {
    uid: 192,
    d: 85,
    c: 21,
    t: "Sound Phidget",
    s: "SND1000",
    i: 35,
    v: [100, 200],
    ch: [{
      uid: 413,
      t: "Sound Sensor",
      c: 25,
      i: 0,
      p: [54, 116, 46, 11]
    }]
  }, {
    uid: 193,
    d: 86,
    c: 21,
    t: "Stepper Phidget",
    s: "STC1000",
    i: 48,
    v: [100, 110],
    ch: [{
      uid: 414,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 29, 100, 91]
    }]
  }, {
    uid: 194,
    d: 86,
    c: 21,
    t: "Stepper Phidget",
    s: "STC1000",
    i: 48,
    v: [110, 200],
    ch: [{
      uid: 415,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }]
  }, {
    uid: 195,
    d: 115,
    c: 21,
    t: "2.5A Stepper Phidget",
    s: "STC1001",
    i: 69,
    v: [100, 110],
    ch: [{
      uid: 416,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 29, 100, 91]
    }]
  }, {
    uid: 196,
    d: 115,
    c: 21,
    t: "2.5A Stepper Phidget",
    s: "STC1001",
    i: 69,
    v: [110, 200],
    ch: [{
      uid: 417,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }]
  }, {
    uid: 197,
    d: 118,
    c: 21,
    t: "8A Stepper Phidget",
    s: "STC1002",
    i: 71,
    v: [100, 110],
    ch: [{
      uid: 418,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 29, 100, 91]
    }]
  }, {
    uid: 198,
    d: 118,
    c: 21,
    t: "8A Stepper Phidget",
    s: "STC1002",
    i: 71,
    v: [110, 200],
    ch: [{
      uid: 419,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }]
  }, {
    uid: 199,
    d: 119,
    c: 21,
    t: "4A Stepper Phidget",
    s: "STC1003",
    i: 72,
    v: [100, 110],
    ch: [{
      uid: 420,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 29, 100, 91]
    }]
  }, {
    uid: 200,
    d: 119,
    c: 21,
    t: "4A Stepper Phidget",
    s: "STC1003",
    i: 72,
    v: [110, 200],
    ch: [{
      uid: 421,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }]
  }, {
    uid: 201,
    d: 119,
    c: 21,
    t: "4A Stepper Phidget",
    s: "STC1003",
    i: 142,
    v: [200, 300],
    ch: [{
      uid: 422,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }, {
      uid: 423,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }]
  }, {
    uid: 202,
    d: 149,
    c: 21,
    t: "4A Stepper Phidget",
    s: "STC1005",
    i: 147,
    v: [100, 110],
    ch: [{
      uid: 424,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }, {
      uid: 425,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }]
  }, {
    uid: 203,
    d: 149,
    c: 21,
    t: "4A Stepper Phidget",
    s: "STC1005",
    i: 147,
    v: [110, 200],
    ch: [{
      uid: 426,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [54, 83, 85, 40, 51, 57, 49, 63, 147, 146, 29, 100, 91]
    }, {
      uid: 427,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }]
  }, {
    uid: 204,
    d: 87,
    c: 21,
    t: "Temperature Phidget",
    s: "TMP1000",
    i: 19,
    v: [100, 200],
    ch: [{
      uid: 428,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 0,
      p: [54, 46, 95]
    }]
  }, {
    uid: 205,
    d: 88,
    c: 21,
    t: "Isolated Thermocouple Phidget",
    s: "TMP1100",
    i: 55,
    v: [100, 200],
    ch: [{
      uid: 429,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      i: 0,
      p: [54, 46, 84, 95]
    }, {
      uid: 430,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 1,
      p: [54, 46, 95]
    }, {
      uid: 431,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 101]
    }]
  }, {
    uid: 206,
    d: 89,
    c: 21,
    t: "4x Thermocouple Phidget",
    s: "TMP1101",
    i: 21,
    v: [100, 200],
    ch: [{
      uid: 432,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      n: 4,
      i: 0,
      p: [54, 46, 84, 95]
    }, {
      uid: 433,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 4,
      p: [54, 46, 95]
    }, {
      uid: 434,
      t: "Voltage Input",
      c: 29,
      n: 4,
      i: 0,
      p: [54, 46, 101]
    }]
  }, {
    uid: 207,
    d: 89,
    c: 21,
    t: "4x Thermocouple Phidget",
    s: "TMP1101",
    i: 143,
    v: [200, 300],
    ch: [{
      uid: 435,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      n: 4,
      i: 0,
      p: [54, 46, 84, 95]
    }, {
      uid: 436,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 4,
      p: [54, 46, 95]
    }, {
      uid: 437,
      t: "Voltage Input",
      c: 29,
      n: 4,
      i: 0,
      p: [54, 46, 101]
    }]
  }, {
    uid: 208,
    d: 90,
    c: 21,
    t: "RTD Phidget",
    s: "TMP1200",
    i: 16,
    v: [100, 200],
    ch: [{
      uid: 438,
      t: "RTD input",
      c: 28,
      s: 32,
      i: 0,
      p: [180, 54, 46, 76, 77, 95]
    }, {
      uid: 439,
      t: "Resistance Input",
      c: 23,
      i: 0,
      p: [180, 54, 46, 77, 36]
    }]
  }, {
    uid: 209,
    d: 90,
    c: 21,
    t: "RTD Phidget",
    s: "TMP1200",
    i: 78,
    v: [300, 400],
    ch: [{
      uid: 440,
      t: "RTD input",
      c: 28,
      s: 32,
      i: 0,
      p: [180, 54, 46, 76, 77, 95]
    }, {
      uid: 441,
      t: "Resistance Input",
      c: 23,
      i: 0,
      p: [180, 54, 46, 77, 36]
    }]
  }, {
    uid: 211,
    d: 92,
    c: 21,
    t: "20-bit (+-40V) Voltage Input Phidget",
    s: "VCP1000",
    i: 53,
    v: [100, 200],
    ch: [{
      uid: 444,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 87, 101]
    }]
  }, {
    uid: 212,
    d: 93,
    c: 21,
    t: "10-bit (+-40V) Voltage Input Phidget",
    s: "VCP1001",
    i: 31,
    v: [100, 110],
    ch: [{
      uid: 445,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 87, 101]
    }]
  }, {
    uid: 213,
    d: 93,
    c: 21,
    t: "10-bit (+-40V) Voltage Input Phidget",
    s: "VCP1001",
    i: 31,
    v: [110, 200],
    ch: [{
      uid: 446,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 87, 101]
    }]
  }, {
    uid: 214,
    d: 94,
    c: 21,
    t: "10-bit (+-1V) Voltage Input Phidget",
    s: "VCP1002",
    i: 30,
    v: [100, 110],
    ch: [{
      uid: 447,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 87, 101]
    }]
  }, {
    uid: 215,
    d: 94,
    c: 21,
    t: "10-bit (+-1V) Voltage Input Phidget",
    s: "VCP1002",
    i: 30,
    v: [110, 200],
    ch: [{
      uid: 448,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [54, 46, 87, 101]
    }]
  }, {
    uid: 232,
    d: 102,
    c: 21,
    t: "VINT Firmware Upgrade (STM32F0)",
    s: "FIRMWARE_UPGRADE_STM32F0",
    i: 4093,
    v: [100, 110],
    ch: [{
      uid: 465,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [114, 112, 113]
    }]
  }, {
    uid: 233,
    d: 143,
    c: 21,
    t: "VINT Firmware Upgrade (STM32G0)",
    s: "FIRMWARE_UPGRADE_STM32G0",
    i: 4093,
    v: [110, 114],
    ch: [{
      uid: 466,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [114, 112, 113]
    }]
  }, {
    uid: 234,
    d: 143,
    c: 21,
    t: "VINT Firmware Upgrade (STM32G0)",
    s: "FIRMWARE_UPGRADE_STM32G0",
    i: 4093,
    v: [114, 120],
    ch: [{
      uid: 467,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [114, 112, 113]
    }]
  }, {
    uid: 235,
    d: 145,
    c: 21,
    t: "VINT Firmware Upgrade (STM32F3)",
    s: "FIRMWARE_UPGRADE_STM32F3",
    i: 4093,
    v: [120, 200],
    ch: [{
      uid: 468,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [114, 112, 113]
    }]
  }, {
    uid: 236,
    d: 102,
    c: 21,
    t: "VINT Firmware Upgrade (STM32F0)",
    s: "FIRMWARE_UPGRADE_STM32F0",
    i: 4093,
    v: [400, 500],
    ch: [{
      uid: 469,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [114, 112, 113]
    }]
  }, {
    uid: 237,
    d: 103,
    c: 21,
    t: "VINT Firmware Upgrade (STM8S)",
    s: "FIRMWARE_UPGRADE_STM8S",
    i: 4094,
    v: [100, 200],
    ch: [{
      uid: 470,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [114, 112, 113]
    }]
  }, {
    uid: 245,
    d: 125,
    c: 21,
    t: "Unsupported VINT Phidget",
    s: " ",
    i: 4080,
    v: [0, 9999],
    ch: [{
      uid: 485,
      t: "Unsupported VINT Channel",
      c: 33,
      i: 0,
      p: [39, 152, 153, 154, 155, 28]
    }]
  }],
  USB: [{
    uid: 1,
    d: 1,
    c: 9,
    t: "PhidgetInterfaceKit 4/8/8",
    s: "ifkit488",
    i: 33281,
    v: [0, 101],
    cn: {
      numVoltageRatioInputs: 4,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 1,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 4,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 2,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 3,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 2,
    d: 2,
    c: 16,
    t: "PhidgetServo 1-Motor",
    s: "1000",
    i: 33025,
    v: [200, 201],
    cn: {
      numRCServos: 1
    },
    ch: [{
      uid: 4,
      t: "RC Servo Motor Controller",
      c: 22,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 3,
    d: 2,
    c: 16,
    t: "PhidgetServo 1-Motor",
    s: "1000",
    i: 57,
    v: [200, 201],
    cn: {
      numRCServos: 1
    },
    ch: [{
      uid: 5,
      t: "RC Servo Motor Controller",
      c: 22,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 4,
    d: 2,
    c: 16,
    t: "PhidgetServo 1-Motor",
    s: "1000",
    i: 57,
    v: [300, 313],
    cn: {
      numRCServos: 1
    },
    ch: [{
      uid: 6,
      t: "RC Servo Motor Controller",
      c: 22,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 5,
    d: 2,
    c: 16,
    t: "PhidgetServo 1-Motor",
    s: "1000",
    i: 57,
    v: [313, 400],
    cn: {
      numRCServos: 1
    },
    ch: [{
      uid: 7,
      t: "RC Servo Motor Controller",
      c: 22,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 6,
    d: 3,
    c: 16,
    t: "PhidgetServo 4-Motor",
    s: "1001",
    i: 33028,
    v: [200, 201],
    cn: {
      numRCServos: 4
    },
    ch: [{
      uid: 8,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 4,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 7,
    d: 3,
    c: 16,
    t: "PhidgetServo 4-Motor",
    s: "1001",
    i: 56,
    v: [200, 201],
    cn: {
      numRCServos: 4
    },
    ch: [{
      uid: 9,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 4,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 8,
    d: 3,
    c: 16,
    t: "PhidgetServo 4-Motor",
    s: "1001",
    i: 56,
    v: [300, 313],
    cn: {
      numRCServos: 4
    },
    ch: [{
      uid: 10,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 4,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 9,
    d: 3,
    c: 16,
    t: "PhidgetServo 4-Motor",
    s: "1001",
    i: 56,
    v: [313, 400],
    cn: {
      numRCServos: 4
    },
    ch: [{
      uid: 11,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 4,
      i: 0,
      p: [70, 69, 83, 57, 29]
    }]
  }, {
    uid: 10,
    d: 4,
    c: 3,
    t: "PhidgetAnalog 4-Output",
    s: "1002",
    i: 55,
    v: [100, 200],
    cn: {
      numVoltageOutputs: 4
    },
    ch: [{
      uid: 12,
      t: "Voltage Output",
      c: 30,
      n: 4,
      i: 0,
      p: [56, 86]
    }]
  }, {
    uid: 11,
    d: 5,
    c: 1,
    t: "PhidgetAccelerometer 2-Axis",
    s: "1008",
    i: 113,
    v: [0, 200],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 13,
      t: "2-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [46, 54, 1]
    }]
  }, {
    uid: 12,
    d: 7,
    c: 9,
    t: "PhidgetInterfaceKit 2/2/2",
    s: "1011",
    i: 54,
    v: [0, 200],
    cn: {
      numVoltageInputs: 2,
      numVoltageRatioInputs: 2,
      numDigitalInputs: 2,
      numDigitalOutputs: 2
    },
    ch: [{
      uid: 14,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 2,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 15,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 2,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 16,
      t: "Digital Input",
      c: 5,
      n: 2,
      i: 0,
      p: [90]
    }, {
      uid: 17,
      t: "Digital Output",
      c: 6,
      n: 2,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 13,
    d: 8,
    c: 9,
    t: "PhidgetInterfaceKit 0/16/16",
    s: "1012",
    i: 68,
    v: [0, 601],
    cn: {
      numDigitalInputs: 16,
      numDigitalOutputs: 16
    },
    ch: [{
      uid: 18,
      t: "Digital Input",
      c: 5,
      n: 16,
      i: 0,
      p: [90]
    }, {
      uid: 19,
      t: "Digital Output",
      c: 6,
      n: 16,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 14,
    d: 8,
    c: 9,
    t: "PhidgetInterfaceKit 0/16/16",
    s: "1012",
    i: 68,
    v: [601, 602],
    cn: {
      numDigitalInputs: 16,
      numDigitalOutputs: 16
    },
    ch: [{
      uid: 20,
      t: "Digital Input",
      c: 5,
      n: 16,
      i: 0,
      p: [90]
    }, {
      uid: 21,
      t: "Digital Output",
      c: 6,
      n: 16,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 15,
    d: 8,
    c: 9,
    t: "PhidgetInterfaceKit 0/16/16",
    s: "1012",
    i: 68,
    v: [602, 700],
    cn: {
      numDigitalInputs: 16,
      numDigitalOutputs: 16
    },
    ch: [{
      uid: 22,
      t: "Digital Input",
      c: 5,
      n: 16,
      i: 0,
      p: [90]
    }, {
      uid: 23,
      t: "Digital Output",
      c: 6,
      n: 16,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 16,
    d: 6,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1013",
    i: 69,
    v: [0, 821],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 24,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 25,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 26,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 27,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 17,
    d: 6,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1013/1018/1019",
    i: 69,
    v: [821, 900],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 28,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 29,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 30,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 31,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 18,
    d: 9,
    c: 9,
    t: "PhidgetInterfaceKit 0/0/4",
    s: "1014",
    i: 64,
    v: [0, 704],
    cn: {
      numDigitalOutputs: 4
    },
    ch: [{
      uid: 32,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 19,
    d: 9,
    c: 9,
    t: "PhidgetInterfaceKit 0/0/4",
    s: "1014",
    i: 64,
    v: [704, 710],
    cn: {
      numDigitalOutputs: 4
    },
    ch: [{
      uid: 33,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 20,
    d: 9,
    c: 9,
    t: "PhidgetInterfaceKit 0/0/4",
    s: "1014",
    i: 64,
    v: [710, 800],
    cn: {
      numDigitalOutputs: 4
    },
    ch: [{
      uid: 34,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 21,
    d: 9,
    c: 9,
    t: "PhidgetInterfaceKit 0/0/4",
    s: "1014",
    i: 64,
    v: [800, 900],
    cn: {
      numDigitalOutputs: 4
    },
    ch: [{
      uid: 35,
      t: "Power Relay",
      c: 6,
      n: 4,
      i: 0,
      p: [82, 55, 147, 146]
    }]
  }, {
    uid: 23,
    d: 10,
    c: 9,
    t: "PhidgetLinearTouch",
    s: "1015",
    i: 118,
    v: [0, 9999],
    cn: {
      numCapacitiveTouches: 1
    },
    ch: [{
      uid: 37,
      t: "Capacitive Slider Sensor",
      c: 14,
      i: 0,
      p: [46, 54, 96, 137]
    }]
  }, {
    uid: 24,
    d: 11,
    c: 9,
    t: "PhidgetCircularTouch",
    s: "1016",
    i: 119,
    v: [0, 9999],
    cn: {
      numCapacitiveTouches: 1
    },
    ch: [{
      uid: 38,
      t: "Capacitive Scroll Sensor",
      c: 14,
      i: 0,
      p: [46, 54, 96, 137]
    }]
  }, {
    uid: 25,
    d: 12,
    c: 9,
    t: "PhidgetInterfaceKit 0/0/8",
    s: "1017",
    i: 129,
    v: [0, 9999],
    cn: {
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 39,
      t: "Signal Relay",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 26,
    d: 12,
    c: 9,
    t: "PhidgetInterfaceKit 0/0/8",
    s: "1017",
    i: 135,
    v: [200, 300],
    cn: {
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 40,
      t: "Signal Relay",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55, 147, 146]
    }]
  }, {
    uid: 28,
    d: 6,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1010/1018/1019",
    i: 69,
    v: [900, 1000],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 42,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 43,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 44,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 45,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 29,
    d: 6,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1010/1018/1019",
    i: 69,
    v: [1000, 1100],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 46,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 47,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 48,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 49,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 30,
    d: 13,
    c: 15,
    t: "PhidgetRFID",
    s: "1023",
    i: 48,
    v: [0, 104],
    cn: {
      numRFIDs: 1
    },
    ch: [{
      uid: 50,
      t: "RFID Reader",
      c: 24,
      i: 0,
      p: [92, 93]
    }]
  }, {
    uid: 31,
    d: 13,
    c: 15,
    t: "PhidgetRFID",
    s: "1023",
    i: 48,
    v: [104, 200],
    cn: {
      numRFIDs: 1
    },
    ch: [{
      uid: 51,
      t: "RFID Reader",
      c: 24,
      i: 0,
      p: [92, 93]
    }]
  }, {
    uid: 32,
    d: 13,
    c: 15,
    t: "PhidgetRFID",
    s: "1023",
    i: 49,
    v: [200, 201],
    cn: {
      numRFIDs: 1,
      numDigitalOutputs: 3
    },
    ch: [{
      uid: 52,
      t: "RFID Reader",
      c: 24,
      i: 0,
      p: [41, 92, 93]
    }, {
      uid: 53,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 54,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 55,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 33,
    d: 13,
    c: 15,
    t: "PhidgetRFID",
    s: "1023",
    i: 49,
    v: [201, 300],
    cn: {
      numRFIDs: 1,
      numDigitalOutputs: 3
    },
    ch: [{
      uid: 56,
      t: "RFID Reader",
      c: 24,
      i: 0,
      p: [41, 92, 93]
    }, {
      uid: 57,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 58,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 59,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 34,
    d: 14,
    c: 15,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 52,
    v: [100, 200],
    cn: {
      numRFIDs: 1,
      numDigitalOutputs: 3
    },
    ch: [{
      uid: 60,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 61,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 62,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 63,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 35,
    d: 14,
    c: 15,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 52,
    v: [300, 310],
    cn: {
      numRFIDs: 1,
      numDigitalOutputs: 3
    },
    ch: [{
      uid: 64,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 65,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 66,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 67,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 37,
    d: 14,
    c: 15,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 52,
    v: [310, 320],
    cn: {
      numRFIDs: 1,
      numDigitalOutputs: 3
    },
    ch: [{
      uid: 72,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 73,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 74,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 75,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 39,
    d: 14,
    c: 15,
    t: "PhidgetRFID Read-Write",
    s: "1024",
    i: 52,
    v: [320, 400],
    cn: {
      numRFIDs: 1,
      numDigitalOutputs: 3
    },
    ch: [{
      uid: 80,
      t: "RFID Reader/Writer",
      c: 24,
      i: 0,
      p: [41, 103, 201, 92, 93]
    }, {
      uid: 81,
      t: "Digital Output",
      c: 6,
      i: 0,
      p: [82, 55]
    }, {
      uid: 82,
      t: "LED Driver",
      c: 6,
      i: 1,
      p: [82, 55]
    }, {
      uid: 83,
      t: "Onboard LED",
      c: 6,
      i: 2,
      p: [82, 55]
    }]
  }, {
    uid: 43,
    d: 15,
    c: 11,
    t: "PhidgetLED-64",
    s: "1030",
    i: 74,
    v: [100, 300],
    cn: {
      numDigitalOutputs: 64
    },
    ch: [{
      uid: 96,
      t: "LED Driver",
      c: 6,
      s: 17,
      n: 64,
      i: 0,
      p: [55, 82]
    }]
  }, {
    uid: 44,
    d: 16,
    c: 11,
    t: "PhidgetLED-64 Advanced",
    s: "1031",
    i: 76,
    v: [100, 200],
    cn: {
      numDigitalOutputs: 64
    },
    ch: [{
      uid: 97,
      t: "LED Driver",
      c: 6,
      s: 17,
      n: 64,
      i: 0,
      p: [210, 55, 67, 68, 82]
    }]
  }, {
    uid: 45,
    d: 17,
    c: 11,
    t: "PhidgetLED-64 Advanced",
    s: "1032",
    i: 76,
    v: [200, 300],
    cn: {
      numDigitalOutputs: 64
    },
    ch: [{
      uid: 98,
      t: "LED Driver",
      c: 6,
      s: 17,
      n: 64,
      i: 0,
      p: [210, 55, 67, 68, 82]
    }]
  }, {
    uid: 46,
    d: 18,
    c: 7,
    t: "PhidgetGPS",
    s: "1040",
    i: 121,
    v: [0, 9999],
    cn: {
      numGPSes: 1
    },
    ch: [{
      uid: 99,
      t: "GPS",
      c: 10,
      i: 0,
      p: [9, 109, 108, 29, 110, 30]
    }]
  }, {
    uid: 47,
    d: 19,
    c: 17,
    t: "PhidgetSpatial 0/0/3 Basic",
    s: "1041",
    i: 127,
    v: [200, 300],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 100,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }]
  }, {
    uid: 48,
    d: 20,
    c: 17,
    t: "PhidgetSpatial 3/3/3 Basic",
    s: "1042",
    i: 51,
    v: [300, 400],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1
    },
    ch: [{
      uid: 101,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 54, 46, 1]
    }, {
      uid: 102,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 54, 106, 2]
    }, {
      uid: 103,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 54, 46, 50, 37, 35, 18]
    }, {
      uid: 104,
      t: "Spatial",
      c: 26,
      i: 0,
      p: [10, 54, 106, 50, 37, 35, 89]
    }]
  }, {
    uid: 49,
    d: 21,
    c: 17,
    t: "PhidgetSpatial Precision 0/0/3 High Resolution",
    s: "1043",
    i: 127,
    v: [300, 400],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 105,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 145, 1]
    }]
  }, {
    uid: 50,
    d: 22,
    c: 17,
    t: "PhidgetSpatial Precision 3/3/3 High Resolution",
    s: "1044",
    i: 51,
    v: [400, 500],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1
    },
    ch: [{
      uid: 106,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 54, 46, 145, 1]
    }, {
      uid: 107,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 54, 145, 106, 2]
    }, {
      uid: 108,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 54, 46, 50, 37, 35, 18]
    }, {
      uid: 109,
      t: "Spatial",
      c: 26,
      i: 0,
      p: [10, 54, 145, 106, 50, 37, 35, 89]
    }]
  }, {
    uid: 51,
    d: 22,
    c: 17,
    t: "PhidgetSpatial Precision 3/3/3 High Resolution",
    s: "1044",
    i: 51,
    v: [500, 510],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1
    },
    ch: [{
      uid: 110,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 54, 46, 145, 1]
    }, {
      uid: 111,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 54, 145, 106, 2]
    }, {
      uid: 112,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 54, 46, 50, 37, 35, 18]
    }, {
      uid: 113,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [10, 54, 145, 149, 151, 106, 50, 37, 35, 150, 89, 148]
    }]
  }, {
    uid: 52,
    d: 22,
    c: 17,
    t: "PhidgetSpatial Precision 3/3/3 High Resolution",
    s: "1044",
    i: 51,
    v: [510, 600],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1
    },
    ch: [{
      uid: 114,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 54, 46, 145, 1]
    }, {
      uid: 115,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 54, 145, 106, 2]
    }, {
      uid: 116,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 54, 46, 50, 37, 35, 18]
    }, {
      uid: 117,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [10, 54, 145, 149, 151, 106, 50, 37, 35, 174, 150, 89, 148]
    }]
  }, {
    uid: 53,
    d: 23,
    c: 19,
    t: "PhidgetTemperatureSensor IR",
    s: "1045",
    i: 60,
    v: [100, 200],
    cn: {
      numTemperatureSensors: 2
    },
    ch: [{
      uid: 118,
      t: "Temperature Sensor (IR)",
      c: 28,
      i: 0,
      p: [46, 54, 95]
    }, {
      uid: 119,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 1,
      p: [46, 54, 95]
    }]
  }, {
    uid: 54,
    d: 24,
    c: 4,
    t: "PhidgetBridge 4-Input",
    s: "1046",
    i: 59,
    v: [100, 102],
    cn: {
      numVoltageRatioInputs: 4
    },
    ch: [{
      uid: 120,
      t: "Bridge Input",
      c: 31,
      s: 65,
      n: 4,
      i: 0,
      p: [10, 56, 45, 54, 46, 102]
    }]
  }, {
    uid: 55,
    d: 24,
    c: 4,
    t: "PhidgetBridge 4-Input",
    s: "1046",
    i: 59,
    v: [102, 200],
    cn: {
      numVoltageRatioInputs: 4
    },
    ch: [{
      uid: 121,
      t: "Bridge Input",
      c: 31,
      s: 65,
      n: 4,
      i: 0,
      p: [10, 56, 45, 54, 46, 102]
    }]
  }, {
    uid: 56,
    d: 24,
    c: 4,
    t: "PhidgetBridge 4-Input",
    s: "1046",
    i: 59,
    v: [200, 300],
    cn: {
      numVoltageRatioInputs: 4
    },
    ch: [{
      uid: 122,
      t: "Bridge Input",
      c: 31,
      s: 65,
      n: 4,
      i: 0,
      p: [10, 56, 45, 54, 46, 102]
    }]
  }, {
    uid: 57,
    d: 25,
    c: 5,
    t: "PhidgetEncoder HighSpeed 4-Input",
    s: "1047",
    i: 79,
    v: [100, 200],
    cn: {
      numEncoders: 4,
      numDigitalInputs: 4
    },
    ch: [{
      uid: 123,
      t: "Encoder Input",
      c: 8,
      n: 4,
      i: 0,
      p: [46, 56, 54, 29]
    }, {
      uid: 124,
      t: "Digital Input",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 58,
    d: 25,
    c: 5,
    t: "PhidgetEncoder HighSpeed 4-Input",
    s: "1047",
    i: 79,
    v: [200, 300],
    cn: {
      numEncoders: 4,
      numDigitalInputs: 4
    },
    ch: [{
      uid: 125,
      t: "Encoder Input",
      c: 8,
      n: 4,
      i: 0,
      p: [46, 56, 54, 29]
    }, {
      uid: 126,
      t: "Digital Input",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 59,
    d: 25,
    c: 5,
    t: "PhidgetEncoder HighSpeed 4-Input",
    s: "1047",
    i: 79,
    v: [300, 400],
    cn: {
      numEncoders: 4,
      numDigitalInputs: 4
    },
    ch: [{
      uid: 127,
      t: "Encoder Input",
      c: 8,
      n: 4,
      i: 0,
      p: [46, 56, 54, 29]
    }, {
      uid: 128,
      t: "Digital Input",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 60,
    d: 26,
    c: 19,
    t: "PhidgetTemperatureSensor 4-Input",
    s: "1048",
    i: 50,
    v: [100, 200],
    cn: {
      numTemperatureSensors: 5,
      numVoltageInputs: 4
    },
    ch: [{
      uid: 129,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      n: 4,
      i: 0,
      p: [46, 84, 54, 95]
    }, {
      uid: 130,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 4,
      p: [46, 54, 95]
    }, {
      uid: 131,
      t: "Voltage Input",
      c: 29,
      n: 4,
      i: 0,
      p: [46, 54, 101]
    }]
  }, {
    uid: 61,
    d: 26,
    c: 19,
    t: "PhidgetTemperatureSensor 4-Input",
    s: "1048",
    i: 50,
    v: [200, 300],
    cn: {
      numTemperatureSensors: 5,
      numVoltageInputs: 4
    },
    ch: [{
      uid: 132,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      n: 4,
      i: 0,
      p: [46, 84, 54, 95]
    }, {
      uid: 133,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 4,
      p: [46, 54, 95]
    }, {
      uid: 134,
      t: "Voltage Input",
      c: 29,
      n: 4,
      i: 0,
      p: [46, 54, 101]
    }]
  }, {
    uid: 62,
    d: 27,
    c: 17,
    t: "PhidgetSpatial 0/0/3",
    s: "1049",
    i: 127,
    v: [0, 200],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 135,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }]
  }, {
    uid: 63,
    d: 28,
    c: 19,
    t: "PhidgetTemperatureSensor 1-Input",
    s: "1051",
    i: 112,
    v: [0, 200],
    cn: {
      numTemperatureSensors: 2
    },
    ch: [{
      uid: 136,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      i: 0,
      p: [46, 54, 95]
    }, {
      uid: 137,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 1,
      p: [46, 54, 95]
    }]
  }, {
    uid: 64,
    d: 28,
    c: 19,
    t: "PhidgetTemperatureSensor 1-Input",
    s: "1051",
    i: 112,
    v: [200, 300],
    cn: {
      numTemperatureSensors: 2,
      numVoltageInputs: 1
    },
    ch: [{
      uid: 138,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      i: 0,
      p: [46, 84, 54, 95]
    }, {
      uid: 139,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 1,
      p: [46, 54, 95]
    }, {
      uid: 140,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [46, 54, 101]
    }]
  }, {
    uid: 65,
    d: 28,
    c: 19,
    t: "PhidgetTemperatureSensor 1-Input",
    s: "1051",
    i: 112,
    v: [300, 400],
    cn: {
      numTemperatureSensors: 2,
      numVoltageInputs: 1
    },
    ch: [{
      uid: 141,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      i: 0,
      p: [46, 84, 54, 95]
    }, {
      uid: 142,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 1,
      p: [46, 54, 95]
    }, {
      uid: 143,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [46, 54, 101]
    }]
  }, {
    uid: 66,
    d: 28,
    c: 19,
    t: "PhidgetTemperatureSensor 1-Input",
    s: "1051",
    i: 112,
    v: [400, 500],
    cn: {
      numTemperatureSensors: 2,
      numVoltageInputs: 1
    },
    ch: [{
      uid: 144,
      t: "Thermocouple Input",
      c: 28,
      s: 33,
      i: 0,
      p: [46, 84, 54, 95]
    }, {
      uid: 145,
      t: "Temperature Sensor (IC)",
      c: 28,
      i: 1,
      p: [46, 54, 95]
    }, {
      uid: 146,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [46, 54, 101]
    }]
  }, {
    uid: 67,
    d: 29,
    c: 5,
    t: "PhidgetEncoder",
    s: "1052",
    i: 75,
    v: [0, 101],
    cn: {
      numEncoders: 1,
      numDigitalInputs: 1
    },
    ch: [{
      uid: 147,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [46, 54, 29]
    }, {
      uid: 148,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 68,
    d: 29,
    c: 5,
    t: "PhidgetEncoder",
    s: "1052",
    i: 75,
    v: [101, 110],
    cn: {
      numEncoders: 1,
      numDigitalInputs: 1
    },
    ch: [{
      uid: 149,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [46, 54, 29]
    }, {
      uid: 150,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 69,
    d: 29,
    c: 5,
    t: "PhidgetEncoder",
    s: "1052",
    i: 75,
    v: [110, 300],
    cn: {
      numEncoders: 1,
      numDigitalInputs: 1
    },
    ch: [{
      uid: 151,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [46, 54, 29]
    }, {
      uid: 152,
      t: "Digital Input",
      c: 5,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 70,
    d: 30,
    c: 1,
    t: "PhidgetAccelerometer 2-Axis",
    s: "1053",
    i: 113,
    v: [300, 400],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 153,
      t: "2-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [46, 54, 1]
    }]
  }, {
    uid: 71,
    d: 31,
    c: 6,
    t: "PhidgetFrequencyCounter",
    s: "1054",
    i: 53,
    v: [0, 200],
    cn: {
      numFrequencyCounters: 2
    },
    ch: [{
      uid: 154,
      t: "Frequency Input",
      c: 9,
      n: 2,
      i: 0,
      p: [21, 56, 59, 54, 20, 7]
    }]
  }, {
    uid: 72,
    d: 32,
    c: 10,
    t: "PhidgetIR",
    s: "1055",
    i: 77,
    v: [100, 200],
    cn: {
      numIRs: 1
    },
    ch: [{
      uid: 155,
      t: "IR Receiver Transmitter",
      c: 16,
      i: 0,
      p: [33, 97, 99, 98, 5, 25, 32]
    }]
  }, {
    uid: 73,
    d: 33,
    c: 17,
    t: "PhidgetSpatial 3/3/3",
    s: "1056",
    i: 51,
    v: [0, 200],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1
    },
    ch: [{
      uid: 156,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 54, 46, 1]
    }, {
      uid: 157,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 54, 106, 2]
    }, {
      uid: 158,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 54, 46, 50, 37, 35, 18]
    }, {
      uid: 159,
      t: "Spatial",
      c: 26,
      i: 0,
      p: [10, 54, 106, 50, 37, 35, 89]
    }]
  }, {
    uid: 74,
    d: 33,
    c: 17,
    t: "PhidgetSpatial 3/3/3",
    s: "1056",
    i: 51,
    v: [200, 300],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1
    },
    ch: [{
      uid: 160,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 54, 46, 1]
    }, {
      uid: 161,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 54, 106, 2]
    }, {
      uid: 162,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 54, 46, 50, 37, 35, 18]
    }, {
      uid: 163,
      t: "Spatial",
      c: 26,
      i: 0,
      p: [10, 54, 106, 50, 37, 35, 89]
    }]
  }, {
    uid: 75,
    d: 34,
    c: 5,
    t: "PhidgetEncoder HighSpeed",
    s: "1057",
    i: 128,
    v: [300, 400],
    cn: {
      numEncoders: 1
    },
    ch: [{
      uid: 164,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [46, 54, 29]
    }]
  }, {
    uid: 76,
    d: 34,
    c: 5,
    t: "PhidgetEncoder HighSpeed",
    s: "1057",
    i: 128,
    v: [400, 500],
    cn: {
      numEncoders: 1
    },
    ch: [{
      uid: 165,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [46, 56, 54, 65, 29]
    }]
  }, {
    uid: 77,
    d: 35,
    c: 14,
    t: "PhidgetPHSensor",
    s: "1058",
    i: 116,
    v: [100, 200],
    cn: {
      numVoltageInputs: 1,
      numPHSensors: 1
    },
    ch: [{
      uid: 166,
      t: "Voltage Input",
      c: 29,
      i: 0,
      p: [46, 54, 101]
    }, {
      uid: 167,
      t: "PH Input",
      c: 37,
      i: 0,
      p: [54, 46, 134, 133]
    }]
  }, {
    uid: 78,
    d: 36,
    c: 1,
    t: "PhidgetAccelerometer 3-Axis",
    s: "1059",
    i: 126,
    v: [400, 500],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 168,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [46, 54, 1]
    }]
  }, {
    uid: 79,
    d: 37,
    c: 13,
    t: "PhidgetMotorControl LV",
    s: "1060",
    i: 88,
    v: [100, 200],
    cn: {
      numDCMotors: 2,
      numDigitalInputs: 4
    },
    ch: [{
      uid: 169,
      t: "DC Motor Controller",
      c: 4,
      n: 2,
      i: 0,
      p: [54, 55, 40, 16]
    }, {
      uid: 170,
      t: "Digital Input",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }]
  }, {
    uid: 80,
    d: 38,
    c: 2,
    t: "PhidgetAdvancedServo 8-Motor",
    s: "1061",
    i: 58,
    v: [100, 200],
    cn: {
      numRCServos: 8,
      numCurrentInputs: 8
    },
    ch: [{
      uid: 171,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 8,
      i: 0,
      p: [70, 69, 85, 40, 83, 57, 81, 54, 29, 100, 94]
    }, {
      uid: 172,
      t: "RC Servo Motor Current Sensor",
      c: 2,
      n: 8,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 81,
    d: 38,
    c: 2,
    t: "PhidgetAdvancedServo 8-Motor",
    s: "1061",
    i: 58,
    v: [200, 300],
    cn: {
      numRCServos: 8,
      numCurrentInputs: 8
    },
    ch: [{
      uid: 173,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 8,
      i: 0,
      p: [70, 69, 85, 40, 83, 57, 81, 54, 29, 100, 94]
    }, {
      uid: 174,
      t: "RC Servo Motor Current Sensor",
      c: 2,
      n: 8,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 82,
    d: 38,
    c: 2,
    t: "PhidgetAdvancedServo 8-Motor",
    s: "1061",
    i: 58,
    v: [300, 400],
    cn: {
      numRCServos: 8,
      numCurrentInputs: 8
    },
    ch: [{
      uid: 175,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 8,
      i: 0,
      p: [70, 69, 85, 40, 83, 57, 81, 54, 29, 100, 94]
    }, {
      uid: 176,
      t: "RC Servo Motor Current Sensor",
      c: 2,
      n: 8,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 83,
    d: 124,
    c: 2,
    t: "PhidgetAdvancedServo 8-Motor",
    s: "RCC0004",
    i: 58,
    v: [400, 500],
    cn: {
      numRCServos: 8
    },
    ch: [{
      uid: 177,
      t: "RC Servo Motor Controller",
      c: 22,
      n: 8,
      i: 0,
      p: [70, 69, 85, 40, 83, 57, 81, 86, 54, 29, 100, 94]
    }]
  }, {
    uid: 84,
    d: 39,
    c: 18,
    t: "PhidgetStepper Unipolar 4-Motor",
    s: "1062",
    i: 122,
    v: [100, 200],
    cn: {
      numSteppers: 4
    },
    ch: [{
      uid: 178,
      t: "Unipolar Stepper Controller",
      c: 27,
      n: 4,
      i: 0,
      p: [83, 85, 40, 57, 49, 54, 29, 100, 91]
    }]
  }, {
    uid: 85,
    d: 40,
    c: 18,
    t: "PhidgetStepper Bipolar 1-Motor",
    s: "1063",
    i: 123,
    v: [100, 200],
    cn: {
      numSteppers: 1,
      numDigitalInputs: 4,
      numCurrentInputs: 1
    },
    ch: [{
      uid: 179,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [83, 85, 40, 51, 57, 49, 54, 29, 100, 91]
    }, {
      uid: 180,
      t: "Digital Input",
      c: 5,
      n: 4,
      i: 0,
      p: [90]
    }, {
      uid: 181,
      t: "Bipolar Stepper Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 86,
    d: 41,
    c: 13,
    t: "PhidgetMotorControl HC",
    s: "1064",
    i: 89,
    v: [100, 200],
    cn: {
      numDCMotors: 2,
      numCurrentInputs: 2
    },
    ch: [{
      uid: 182,
      t: "DC Motor Controller",
      c: 4,
      n: 2,
      i: 0,
      p: [54, 55, 40, 16]
    }, {
      uid: 183,
      t: "DC Motor Current Sensor",
      c: 2,
      n: 2,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 87,
    d: 42,
    c: 13,
    t: "PhidgetMotorControl 1-Motor",
    s: "1065",
    i: 62,
    v: [100, 200],
    cn: {
      numDCMotors: 1,
      numDigitalInputs: 2,
      numEncoders: 1,
      numVoltageInputs: 3,
      numVoltageRatioInputs: 2,
      numCurrentInputs: 1
    },
    ch: [{
      uid: 184,
      t: "DC Motor Controller",
      c: 4,
      i: 0,
      p: [54, 55, 40, 44, 42, 16, 3]
    }, {
      uid: 185,
      t: "Digital Input",
      c: 5,
      n: 2,
      i: 0,
      p: [90]
    }, {
      uid: 186,
      t: "Encoder Input",
      c: 8,
      i: 0,
      p: [46, 54, 29]
    }, {
      uid: 187,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 2,
      i: 0,
      p: [79, 46, 54, 122, 101, 115]
    }, {
      uid: 188,
      t: "Supply Voltage Sensor",
      c: 29,
      i: 2,
      p: [46, 54, 101]
    }, {
      uid: 189,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 2,
      i: 0,
      p: [79, 46, 54, 122, 102, 115]
    }, {
      uid: 190,
      t: "DC Motor Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 88,
    d: 43,
    c: 2,
    t: "PhidgetAdvancedServo 1-Motor",
    s: "1066",
    i: 130,
    v: [100, 200],
    cn: {
      numRCServos: 1,
      numCurrentInputs: 1
    },
    ch: [{
      uid: 191,
      t: "RC Servo Motor Controller",
      c: 22,
      i: 0,
      p: [70, 69, 85, 40, 83, 57, 81, 54, 29, 100, 94]
    }, {
      uid: 192,
      t: "RC Servo Motor Current Sensor",
      c: 2,
      i: 0,
      p: [46, 54, 8]
    }]
  }, {
    uid: 89,
    d: 44,
    c: 18,
    t: "PhidgetStepper Bipolar HC",
    s: "1067",
    i: 123,
    v: [200, 300],
    cn: {
      numSteppers: 1
    },
    ch: [{
      uid: 193,
      t: "Bipolar Stepper Controller",
      c: 27,
      i: 0,
      p: [83, 85, 40, 51, 57, 49, 54, 29, 100, 91]
    }]
  }, {
    uid: 90,
    d: 45,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1202/1203",
    i: 125,
    v: [0, 120],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 194,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 195,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 196,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 197,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 91,
    d: 45,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1202/1203",
    i: 125,
    v: [120, 200],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 198,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 199,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 200,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 201,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 92,
    d: 45,
    c: 20,
    t: "PhidgetTextLCD 20X2",
    s: "1202/1203",
    i: 125,
    v: [0, 200],
    cn: {
      numLCDs: 1
    },
    n: 1,
    ch: [{
      uid: 202,
      t: "Text LCD",
      c: 11,
      s: 81,
      i: 0,
      p: [43, 48, 52, 53, 47, 4, 19, 105]
    }]
  }, {
    uid: 93,
    d: 45,
    c: 9,
    t: "PhidgetInterfaceKit 8/8/8",
    s: "1202/1203",
    i: 125,
    v: [200, 300],
    cn: {
      numVoltageInputs: 8,
      numVoltageRatioInputs: 8,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 203,
      t: "Voltage Input",
      c: 29,
      s: 48,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 101, 115]
    }, {
      uid: 204,
      t: "Voltage Ratio Input",
      c: 31,
      s: 64,
      n: 8,
      i: 0,
      p: [10, 27, 54, 79, 46, 122, 102, 115]
    }, {
      uid: 205,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 206,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 94,
    d: 45,
    c: 20,
    t: "PhidgetTextLCD 20X2",
    s: "1202/1203",
    i: 125,
    v: [200, 9999],
    cn: {
      numLCDs: 1
    },
    n: 1,
    ch: [{
      uid: 207,
      t: "Text LCD",
      c: 11,
      s: 81,
      i: 0,
      p: [43, 48, 52, 53, 47, 4, 19, 105]
    }]
  }, {
    uid: 95,
    d: 46,
    c: 20,
    t: "PhidgetTextLCD Adapter",
    s: "1204",
    i: 61,
    v: [0, 9999],
    cn: {
      numLCDs: 2
    },
    ch: [{
      uid: 208,
      t: "Text LCD",
      c: 11,
      s: 81,
      n: 2,
      i: 0,
      p: [43, 48, 52, 53, 78, 47, 4, 19, 24, 105]
    }]
  }, {
    uid: 96,
    d: 47,
    c: 20,
    t: "PhidgetTextLCD 20X2",
    s: "1215/1216/1217/1218",
    i: 82,
    v: [0, 9999],
    cn: {
      numLCDs: 1
    },
    ch: [{
      uid: 209,
      t: "Text LCD",
      c: 11,
      s: 81,
      i: 0,
      p: [43, 48, 52, 53, 47, 4, 19, 105]
    }]
  }, {
    uid: 97,
    d: 48,
    c: 20,
    t: "PhidgetTextLCD 20X2 with InterfaceKit 0/8/8",
    s: "1219/1220/1221/1222",
    i: 83,
    v: [0, 9999],
    cn: {
      numLCDs: 1,
      numDigitalInputs: 8,
      numDigitalOutputs: 8
    },
    ch: [{
      uid: 210,
      t: "Text LCD",
      c: 11,
      s: 81,
      i: 0,
      p: [43, 48, 52, 53, 47, 4, 19, 105]
    }, {
      uid: 211,
      t: "Digital Input",
      c: 5,
      n: 8,
      i: 0,
      p: [90]
    }, {
      uid: 212,
      t: "Digital Output",
      c: 6,
      n: 8,
      i: 0,
      p: [82, 55]
    }]
  }, {
    uid: 107,
    d: 134,
    c: 25,
    t: "I2C Adapter Phidget",
    s: "ADP0001",
    i: 134,
    v: [200, 300],
    cn: {
      numDataAdapters: 1,
      numDigitalInputs: 2,
      numDigitalOutputs: 2
    },
    ch: [{
      uid: 223,
      t: "Data Adapter",
      c: 3,
      i: 0,
      p: [202, 157, 168, 208]
    }, {
      uid: 224,
      t: "Digital Input",
      c: 5,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 64, 168, 90]
    }, {
      uid: 225,
      t: "Digital Output",
      c: 6,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 55, 82, 168]
    }]
  }, {
    uid: 109,
    d: 160,
    c: 25,
    t: "SPI Adapter Phidget",
    s: "ADP0002",
    i: 160,
    v: [100, 200],
    cn: {
      numDataAdapters: 1,
      numDigitalInputs: 2,
      numDigitalOutputs: 2
    },
    ch: [{
      uid: 229,
      t: "Data Adapter",
      c: 3,
      i: 0,
      p: [202, 157, 160, 163, 199, 165, 168, 118, 169]
    }, {
      uid: 230,
      t: "Digital Input",
      c: 5,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 168, 90]
    }, {
      uid: 231,
      t: "Digital Output",
      c: 6,
      n: 2,
      i: 0,
      e: 0,
      p: [202, 55, 82, 168]
    }]
  }, {
    uid: 111,
    d: 161,
    c: 12,
    t: "Addressable LED Phidget",
    s: "LED0100",
    i: 161,
    v: [100, 200],
    cn: {
      numLEDArrays: 1,
      numCurrentInputs: 1
    },
    ch: [{
      uid: 235,
      t: "LED Array",
      c: 19,
      i: 0,
      p: [56, 205, 206, 162, 118, 4, 203, 207, 204]
    }, {
      uid: 236,
      t: "Current Input",
      c: 2,
      i: 0,
      p: [181, 8]
    }]
  }, {
    uid: 169,
    d: 146,
    c: 1,
    t: "PhidgetAccelerometer",
    s: "MOT0100",
    i: 146,
    v: [100, 200],
    cn: {
      numAccelerometers: 1
    },
    ch: [{
      uid: 364,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [54, 46, 1]
    }]
  }, {
    uid: 174,
    d: 140,
    c: 17,
    t: "PhidgetSpatial Precision 3/3/3",
    s: "MOT0109",
    i: 140,
    v: [100, 200],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1,
      numTemperatureSensors: 1
    },
    ch: [{
      uid: 378,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 179, 54, 46, 145, 170, 1]
    }, {
      uid: 379,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 179, 54, 145, 170, 106, 2]
    }, {
      uid: 380,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 179, 54, 46, 170, 50, 37, 35, 18]
    }, {
      uid: 381,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [10, 179, 54, 145, 149, 151, 170, 106, 50, 37, 35, 174, 150, 89, 148]
    }, {
      uid: 382,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [10, 54, 46, 95]
    }]
  }, {
    uid: 175,
    d: 141,
    c: 17,
    t: "PhidgetSpatial Precision 3/3/3",
    s: "MOT0110",
    i: 141,
    v: [100, 200],
    cn: {
      numAccelerometers: 1,
      numGyroscopes: 1,
      numMagnetometers: 1,
      numSpatials: 1,
      numTemperatureSensors: 1
    },
    ch: [{
      uid: 383,
      t: "3-Axis Accelerometer",
      c: 1,
      i: 0,
      p: [10, 179, 54, 46, 170, 1]
    }, {
      uid: 384,
      t: "3-Axis Gyroscope",
      c: 12,
      i: 0,
      p: [10, 179, 54, 170, 106, 2]
    }, {
      uid: 385,
      t: "3-Axis Magnetometer",
      c: 18,
      i: 0,
      p: [10, 179, 54, 46, 170, 50, 37, 35, 18]
    }, {
      uid: 386,
      t: "Spatial",
      c: 26,
      s: 112,
      i: 0,
      p: [10, 179, 54, 149, 170, 106, 50, 37, 35, 174, 150, 89, 148]
    }, {
      uid: 387,
      t: "Temperature Sensor",
      c: 28,
      i: 0,
      p: [10, 54, 46, 95]
    }]
  }, {
    uid: 216,
    d: 64,
    c: 8,
    t: "6-Port USB VINT Hub Phidget",
    s: "HUB0000",
    i: 63,
    v: [100, 200],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 449,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 217,
    d: 64,
    c: 8,
    t: "6-Port USB VINT Hub Phidget",
    s: "HUB0000",
    i: 63,
    v: [300, 400],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 450,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 218,
    d: 64,
    c: 8,
    t: "6-Port USB VINT Hub Phidget",
    s: "HUB0000",
    i: 63,
    v: [400, 500],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 451,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 178]
    }]
  }, {
    uid: 219,
    d: 142,
    c: 8,
    t: "6-Port USB VINT Hub Phidget",
    s: "HUB0001",
    i: 67,
    v: [100, 115],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 452,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 220,
    d: 142,
    c: 8,
    t: "6-Port USB VINT Hub Phidget",
    s: "HUB0001",
    i: 67,
    v: [115, 200],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 453,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 183, 107]
    }]
  }, {
    uid: 221,
    d: 147,
    c: 8,
    t: "6-Port USB VINT Hub Phidget",
    s: "HUB0002",
    i: 70,
    v: [100, 200],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 454,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 183, 178]
    }]
  }, {
    uid: 222,
    d: 148,
    c: 8,
    t: "1-Port USB VINT Hub Phidget",
    s: "HUB0007",
    i: 71,
    v: [100, 200],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 455,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 183, 178]
    }]
  }, {
    uid: 225,
    d: 123,
    c: 8,
    t: "6-Port Network VINT Hub Phidget",
    s: "HUB5000",
    i: 66,
    v: [100, 200],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 458,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 226,
    d: 123,
    c: 8,
    t: "6-Port Network VINT Hub Phidget",
    s: "HUB5000",
    i: 66,
    v: [200, 300],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 459,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 227,
    d: 101,
    c: 23,
    t: "USB Firmware Upgrade (NXP M3)",
    s: "FIRMWARE_UPGRADE_M3",
    i: 152,
    v: [0, 9999],
    cn: {
      numFirmwareUpgrades: 1
    },
    ch: [{
      uid: 460,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [112, 113]
    }]
  }, {
    uid: 228,
    d: 101,
    c: 23,
    t: "USB Firmware Upgrade (STM32F)",
    s: "FIRMWARE_UPGRADE_STM32_USB",
    i: 156,
    v: [100, 200],
    cn: {
      numFirmwareUpgrades: 1
    },
    ch: [{
      uid: 461,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [112, 113]
    }]
  }, {
    uid: 229,
    d: 101,
    c: 23,
    t: "USB Firmware Upgrade (STM32G)",
    s: "FIRMWARE_UPGRADE_STM32G_USB",
    i: 156,
    v: [200, 300],
    cn: {
      numFirmwareUpgrades: 1
    },
    ch: [{
      uid: 462,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [112, 113]
    }]
  }, {
    uid: 230,
    d: 101,
    c: 23,
    t: "USB Firmware Upgrade (STM32L)",
    s: "FIRMWARE_UPGRADE_STM32L_USB",
    i: 156,
    v: [300, 400],
    cn: {
      numFirmwareUpgrades: 1
    },
    ch: [{
      uid: 463,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [112, 113]
    }]
  }, {
    uid: 231,
    d: 101,
    c: 23,
    t: "USB Firmware Upgrade (STM32F)",
    s: "FIRMWARE_UPGRADE_STM32Fv2_USB",
    i: 156,
    v: [400, 500],
    cn: {
      numFirmwareUpgrades: 1
    },
    ch: [{
      uid: 464,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [112, 113]
    }]
  }, {
    uid: 244,
    d: 125,
    c: 22,
    t: "Unsupported USB Phidget",
    s: " ",
    i: 175,
    v: [0, 9999],
    cn: {
      numGenerics: 1
    },
    ch: [{
      uid: 484,
      t: "Unsupported USB Channel",
      c: 33,
      i: 0,
      p: [39, 152, 153, 154, 155, 28]
    }]
  }],
  SPI: [{
    uid: 223,
    d: 67,
    c: 8,
    t: "6-Port PhidgetSBC VINT Hub Phidget",
    s: "HUB0004",
    i: 1,
    v: [100, 200],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 456,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 224,
    d: 67,
    c: 8,
    t: "6-Port PhidgetSBC VINT Hub Phidget",
    s: "HUB0004",
    i: 1,
    v: [200, 300],
    cn: {
      numHubs: 1
    },
    ch: [{
      uid: 457,
      t: "VINT Hub",
      c: 13,
      i: 0,
      p: [60, 72, 73, 107]
    }]
  }, {
    uid: 238,
    d: 104,
    c: 23,
    t: "SPI Firmware Upgrade (M3)",
    s: "FIRMWARE_UPGRADE_M3",
    i: 2,
    v: [0, 9999],
    cn: {
      numFirmwareUpgrades: 1
    },
    ch: [{
      uid: 471,
      t: "Firmware Upgrade",
      c: 32,
      i: 0,
      p: [112, 113]
    }]
  }, {
    uid: 246,
    d: 125,
    c: 22,
    t: "Unsupported SPI Phidget",
    s: " ",
    i: 65535,
    v: [0, 9999],
    cn: {
      numGenerics: 1
    },
    ch: [{
      uid: 486,
      t: "Unsupported SPI Channel",
      c: 33,
      i: 0,
      p: [39, 152, 153, 154, 155, 28]
    }]
  }],
  VIRTUAL: [{
    uid: 243,
    d: 111,
    c: 24,
    t: "Dictionary",
    s: "Dictionary",
    i: 0,
    v: [100, 200],
    cn: {
      numDictionaries: 1
    },
    ch: [{
      uid: 483,
      t: "Dictionary",
      c: 36,
      i: 0,
      p: [123, 125, 130, 127, 131, 129, 132, 124, 126, 128]
    }]
  }]
};

function findPhidgetUniqueDevice(data) {
  var _a;
  const typeDevs = PhidgetDevices[data.type];
  for (const d of typeDevs) {
    if (d.v[0] > data.version || d.v[1] <= data.version) continue;
    if (data.type === 'VINT') {
      if (d.i !== data.vintID) continue;
    } else {
      if (d.i !== data.productID) continue;
      if (data.type === 'USB' && ((_a = d.n) !== null && _a !== void 0 ? _a : 0) !== data.interfaceNum) continue;
    }
    return d;
  }
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Couldn't find device in device list!!");
}
/** @internal */
class Device {
  get parentId() {
    var _a, _b;
    return (_b = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.id) !== null && _b !== void 0 ? _b : '0';
  }
  get vintID() {
    return this.devDef.i;
  }
  get sku() {
    return this.devDef.s;
  }
  get class() {
    return this.devDef.c;
  }
  get hubPort() {
    var _a, _b;
    return (_b = (_a = this.vintDeviceProps) === null || _a === void 0 ? void 0 : _a.hubPort) !== null && _b !== void 0 ? _b : 0;
  }
  get isHubPort() {
    var _a, _b;
    return (_b = (_a = this.vintDeviceProps) === null || _a === void 0 ? void 0 : _a.isHubPort) !== null && _b !== void 0 ? _b : false;
  }
  get index() {
    var _a, _b;
    return (_b = (_a = this.vintDeviceProps) === null || _a === void 0 ? void 0 : _a.uniqueIndex) !== null && _b !== void 0 ? _b : 0;
  }
  constructor(conn, data) {
    this.conn = conn;
    this.devDef = data.devDef;
    this.version = data.version;
    this.label = data.label;
    this.serialNumber = data.serialNumber;
    this.fwstr = data.fwstr;
    this.id = data.id;
    this.parent = data.parent;
    if (data.type === 'VINT') this.vintDeviceProps = data.vintDeviceProps;
    if (data.type === 'HUB') this.hubPortProps = data.hubPortProps;
  }
  toString() {
    if (this.class === DeviceClass.VINT) {
      return this.sku + ' (' + this.name + ') v' + this.version + ' -> ' + this.parent.sku + ' Port:' + this.hubPort + ' Serial#:' + this.serialNumber + (this.conn._isRemote ? " NET" : " USB");
    }
    return this.sku + ' (' + this.name + ') v' + this.version + ' Serial#:' + this.serialNumber + (this.conn._isRemote ? " NET" : " USB");
  }
}

/** @internal */
class NetworkDevice extends Device {
  constructor(conn, data) {
    super(conn, data);
    this.deviceID = data.deviceID;
    this.name = data.name;
  }
  findPhidgetUniqueChannel(uniqueIndex) {
    var _a, _b;
    let index = 0;
    for (const c of this.devDef.ch) {
      if (uniqueIndex < index + ((_a = c.n) !== null && _a !== void 0 ? _a : 1)) return c;
      index += (_b = c.n) !== null && _b !== void 0 ? _b : 1;
    }
    throw new PhidgetError(ErrorCode.UNEXPECTED, "Couldn't find channel in channel list!!");
  }
}

const NET_MAJOR = 2;
const NET_MINOR = 4;
const NET_IDENT = "phidgetclient";
/** @public */
class NetworkConnectionBase extends PhidgetConnection {
  constructor(optsOrUriOrPort, optsOrHostname, opts) {
    let options = {};
    let uri = '';
    let hostname = '';
    let port = 0;
    if (optsOrUriOrPort != undefined && typeof optsOrUriOrPort === 'object') {
      options = optsOrUriOrPort;
    } else if (optsOrUriOrPort != undefined && typeof optsOrUriOrPort === 'string') {
      uri = optsOrUriOrPort;
      if (optsOrHostname != undefined && typeof optsOrHostname === 'object') options = optsOrHostname;
    } else if (optsOrUriOrPort != undefined && typeof optsOrUriOrPort === 'number') {
      port = optsOrUriOrPort;
      if (optsOrHostname != undefined && typeof optsOrHostname === 'string') {
        hostname = optsOrHostname;
        if (opts != undefined && typeof opts === 'object') options = opts;
      }
    }
    if (!options.name) options.name = uri;
    super(options);
    this._type = 1;
    this._generation = 0;
    this._timeout = 8000;
    this._reqseq = 10;
    this._requests = new Map();
    this._opened = false;
    this._uri = uri;
    if (options.hostname && hostname === '') {
      if (typeof options.hostname === 'string') hostname = options.hostname;
    }
    if (hostname === '') hostname = 'localhost';
    this._hostname = hostname;
    if (options.port && port === 0) {
      if (typeof options.port === 'number') port = options.port;
      if (typeof options.port === 'string') port = Number(options.port);
    }
    this._port = port;
    if (options.onConnect && typeof options.onConnect === 'function') this.onConnect = options.onConnect;else this.onConnect = null;
    if (options.onDisconnect && typeof options.onDisconnect === 'function') this.onDisconnect = options.onDisconnect;else this.onDisconnect = null;
    if (options.onAuthenticationNeeded && typeof options.onAuthenticationNeeded === 'function') this.onAuthenticationNeeded = options.onAuthenticationNeeded;else this.onAuthenticationNeeded = null;
    if (options.passwd) this._passwd = options.passwd;else this._passwd = '';
    this._handleAbandonedRequestsInterval = setInterval(this._handleAbandonedRequests.bind(this), 2000);
  }
  delete() {
    if (this._handleAbandonedRequestsInterval != undefined) {
      clearInterval(this._handleAbandonedRequestsInterval);
      delete this._handleAbandonedRequestsInterval;
    }
    super.delete();
  }
  setKeepAlive(timeout) {
    if (typeof timeout !== 'number' || isNaN(timeout)) throw 'invalid keep alive:' + timeout;
    this._timeout = timeout;
  }
  close() {
    logdebug("Network Connection close() called");
    this._opened = false;
    if (this._connectionMaintainer != undefined) clearTimeout(this._connectionMaintainer);
    delete this._connectionMaintainer;
    this._detachAllDevices();
    this._closesocket();
  }
  /** @internal */
  _onmessage(msg, req) {
    let json;
    if (msg !== undefined) {
      const tmp1 = msg.replace(/("[OI]"|"phid"|"chid"|"parent"):([0-9]+)/g, "$1:\"$2\"");
      const tmp2 = tmp1.replace(/([:[,])[-+]?nan(\([\w]*\))?/ig, "$1\"**NAN**\"");
      if (tmp1 !== tmp2) {
        json = JSON.parse(tmp2, (key, value) => {
          if (key == 'v') {
            if (value === "**NAN**") return NaN;
            if (Array.isArray(value)) return value.map(val => {
              if (val === "**NAN**") return NaN;
              return val;
            });
          }
          return value;
        });
      } else {
        json = JSON.parse(tmp2);
      }
    }
    try {
      if (this.connected) this._ondatamessage(json, req);else this._onauthmessage(json);
    } catch (err) {
      if (this.onError && err instanceof PhidgetError) {
        try {
          this.onError(err.errorCode, err.message);
        } catch (err) {
          logEventException(err);
        }
        loginfo("Error handling message from server", err);
      } else {
        logerr("Error handling message from server", err);
      }
    }
  }
  /** @internal */
  _handleAbandonedRequests() {
    for (const r of this._requests.entries()) {
      if (r[1].generation != this._generation) {
        r[1].onError(ErrorCode.CONNECTION_RESET, "Connection Reset");
        this._requests.delete(r[0]);
        continue;
      }
      if (tm() - r[1].time > 5000) {
        r[1].onTimeout();
        this._requests.delete(r[0]);
      }
    }
  }
  /** @internal */
  _getNextRequestSequence() {
    if (this._reqseq >= 65535) this._reqseq = 10;
    this._reqseq++;
    return this._reqseq;
  }
  /** @internal */
  _sendRequest(flags, reqseq, repseq, type, stype, data) {
    if (reqseq === 0) reqseq = this._getNextRequestSequence();
    return new _Promise((resolve, reject) => {
      this._requests.set(reqseq, {
        generation: this._generation,
        time: tm(),
        onReply: function (res) {
          if ('E' in res) {
            if (res.E !== ErrorCode.SUCCESS) {
              if (res.R != undefined) reject(new PhidgetError(res.E, res.R));
              reject(new PhidgetError(res.E));
            } else {
              if (res.R != undefined) resolve(res.R);
              resolve();
            }
          } else {
            resolve(res);
          }
        },
        onTimeout: function () {
          reject(new PhidgetError(ErrorCode.TIMEOUT));
        },
        onError: function (code, msg) {
          reject(new PhidgetError(code, msg));
        }
      });
      const json = JSON.stringify(data);
      const data2 = json.replace(/("[OI]"|"phid"|"channel"):"([0-9]+)"/g, "$1:$2");
      const req = new Request(data2.length, flags, reqseq, repseq, type, stype);
      this._send(req, data2);
    });
  }
  /** @internal */
  _sendReply(repseq, type, stype, reply) {
    const NRF_REPLY = 0x0002;
    const reqseq = this._getNextRequestSequence();
    let data = '';
    if (reply != undefined) data = JSON.stringify(reply);
    const req = new Request(data.length, NRF_REPLY, reqseq, repseq, type, stype);
    this._send(req, data);
  }
  /** @internal */
  _maintainConnection() {
    logdebug("Maintaining network connection..");
    const nextMaintainer = () => {
      if (!this._connectionMaintainer && this._opened) {
        logdebug(".. Check again in 4 seconds.");
        this._connectionMaintainer = setTimeout(this._maintainConnection.bind(this), 4000);
      }
    };
    if (this._connectionMaintainer) delete this._connectionMaintainer;
    if (this.connected) {
      logdebug(".. already connected ..");
      nextMaintainer();
    } else {
      logdebug(".. trying to connect ..");
      this.connect().then(() => {
        logdebug(".. connected!");
        nextMaintainer();
      }).catch(err => {
        if (this.onError && err instanceof PhidgetError) {
          try {
            this.onError(err.errorCode, err.message);
          } catch (err) {
            logEventException(err);
          }
        }
        logerr("Error connecting", err);
        logdebug(".. failed to connect! ..");
        nextMaintainer();
      });
    }
  }
  /** @internal */
  _doclose() {
    this._detachAllDevices();
    this._closesocket();
  }
  /** @internal */
  _onauthmessage(data) {
    if (this._onauthdata == undefined) throw new Error('packet recieved while not connected and authdata is not defined');
    this._onauthdata(data);
  }
  /** @internal */
  _ondatamessage(data, req) {
    const request = this._requests.get(req.repseq);
    if (request) {
      this._requests.delete(req.repseq);
      request.onReply(data);
    }
    if (req.flgs & 2) {
      if (request === undefined) throw new PhidgetError(ErrorCode.UNEXPECTED, 'No handler registered for reply: ' + req);
      return;
    }
    switch (req.type) {
      case 20:
        this._handleCommand(req);
        break;
      case 30:
        this._handleDevice(req, data);
        break;
      default:
        throw new PhidgetError(ErrorCode.INVALID, 'Unknown request type:' + req.type);
    }
  }
  /** @internal */
  _handleCommand(req) {
    switch (req.stype) {
      case 41:
        logdebug("Got a keepalive message");
        if (this._keepAliveTimeout != undefined) {
          logdebug("Cleaning previous keepalive timeout");
          clearTimeout(this._keepAliveTimeout);
        }
        this._keepAliveTimeout = setTimeout(() => {
          logdebug("Keepalive timeout passed");
          delete this._keepAliveTimeout;
          if (this.connected) {
            if (this.onError) {
              try {
                this.onError(ErrorCode.KEEP_ALIVE, "KeepAlive timeout. Closing connection to server.");
              } catch (err) {
                logEventException(err);
              }
            }
            logerr("KeepAlive timeout. Closing connection to server.");
            this._doclose();
          }
        }, this._timeout);
        this._sendReply(req.reqseq, 20, 41);
        return;
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED, 'Unknown command subrequest:' + req.stype);
    }
  }
  /** @internal */
  _handleDevice(req, data) {
    switch (req.stype) {
      case 50:
        this._handleDeviceAttach(data);
        return;
      case 55:
        this._handleDeviceDetach(data);
        return;
      case 70:
        this._handleBridgePacket(req, data);
        return;
      case 80:
        this._handleChannel(data);
        return;
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED, 'Unknown device subrequest:' + req.stype);
    }
  }
  /** @internal */
  _handleDeviceAttach(data) {
    var _a, _b, _c, _d, _e;
    const devDef = findPhidgetUniqueDevice(data);
    let devData;
    const baseData = {
      version: data.version,
      label: data.label,
      serialNumber: data.serialNumber,
      devDef: devDef,
      fwstr: (_a = data.fwstr) !== null && _a !== void 0 ? _a : devDef.s,
      id: data.phid,
      parent: (_b = this._getDevice(data.parent)) !== null && _b !== void 0 ? _b : undefined,
      deviceID: data.deviceID,
      name: data.name
    };
    if (data.type === 'VINT') {
      devData = Object.assign(Object.assign({}, baseData), {
        type: 'VINT',
        vintDeviceProps: {
          vintProto: (_c = data.vintProto) !== null && _c !== void 0 ? _c : 1,
          suppSetSpeed: data.suppSetSpeed ? !!data.suppSetSpeed : false,
          suppAutoSetSpeed: data.suppSetSpeed ? !!data.suppSetSpeed : false,
          maxSpeed: (_d = data.maxSpeed) !== null && _d !== void 0 ? _d : 4294967295,
          commSpeed: (_e = data.commSpeed) !== null && _e !== void 0 ? _e : 4294967295,
          hubPort: data.hubPort,
          isHubPort: !!data.isHubPort,
          uniqueIndex: data.index
        }
      });
    } else if (devDef.c === DeviceClass.HUB) {
      let hubPortCnt;
      if (data.hubPortsInfo) hubPortCnt = data.hubPortsInfo.portProto.length;else hubPortCnt = data.deviceID === DeviceID.PN_HUB0007 ? 1 : 6;
      const hubPortProps = [];
      for (let i = 0; i < hubPortCnt; i++) {
        if (data.hubPortsInfo) {
          hubPortProps.push({
            portProto: data.hubPortsInfo.portProto[i],
            portSuppSetSpeed: !!data.hubPortsInfo.portSuppSetSpeed[i],
            portSuppAutoSetSpeed: !!data.hubPortsInfo.portSuppSetSpeed[i],
            portMaxSpeed: data.hubPortsInfo.portMaxSpeed[i]
          });
        } else {
          hubPortProps.push({
            portProto: 1,
            portSuppSetSpeed: false,
            portSuppAutoSetSpeed: false,
            portMaxSpeed: 100000
          });
        }
      }
      devData = Object.assign(Object.assign({}, baseData), {
        type: 'HUB',
        hubPortProps: hubPortProps
      });
    } else {
      devData = Object.assign(Object.assign({}, baseData), {
        type: 'OTHER'
      });
    }
    const dev = new NetworkDevice(this, devData);
    this._deviceAttach(dev);
  }
  /** @internal */
  _handleDeviceDetach(data) {
    const dev = this._getDevice(data.phid);
    if (dev) this._deviceDetach(dev);
  }
  /** @internal */
  _handleChannel(data) {
    const dev = this._devices.get(data.parent);
    if (!dev) throw new PhidgetError(ErrorCode.UNEXPECTED, 'missing channel parent');
    const chDef = dev.findPhidgetUniqueChannel(data.uniqueIndex);
    const chData = {
      id: data.chid,
      chDef: chDef,
      uniqueIndex: data.uniqueIndex,
      index: data.index,
      cpversion: data.version,
      name: data.name,
      class: data.class
    };
    const ch = new NetworkChannel(this, dev, chData);
    this._channelAttach(ch);
  }
  /** @internal */
  _handleBridgePacket(req, data) {
    const bp = new BridgePacket(this, data);
    let reply;
    try {
      bp.deliver();
    } catch (err) {
      if (err instanceof PhidgetError) {
        reply = {
          E: err.errorCode,
          R: err.message
        };
      } else {
        reply = {
          E: ErrorCode.UNEXPECTED,
          R: '' + err
        };
      }
    }
    if (!bp.isEvent()) this._sendReply(req.reqseq, req.type, req.stype, reply);
  }
  /** @internal */
  _handshake() {
    return new _Promise((resolve, reject) => {
      const pkt = {
        type: this._protocol,
        pmajor: NET_MAJOR,
        pminor: NET_MINOR
      };
      const json = JSON.stringify(pkt);
      const req = new Request(json.length, 0, 0, 0, 10, 10);
      this._send(req, json);
      this._onauthdata = HandShakeS0;
      function HandShakeS0(data) {
        if (data.result !== ErrorCode.SUCCESS) {
          reject(new PhidgetError(data.result, 'server rejected handshake'));
          return;
        }
        this._nonceC = this._createSalt(16);
        const pkt = {
          ident: NET_IDENT,
          nonceC: this._nonceC
        };
        const json = JSON.stringify(pkt);
        const req = new Request(json.length, 0, 0, 0, 10, 30);
        try {
          this._send(req, json);
        } catch (err) {
          reject(err);
          return;
        }
        this._onauthdata = AuthS0;
      }
      function AuthS0(data) {
        if (data.result !== ErrorCode.SUCCESS) {
          reject(new PhidgetError(data.result, 'authentication failed'));
          return;
        }
        if (this._nonceC != data.nonceC) {
          reject(new PhidgetError(ErrorCode.UNEXPECTED, 'Authentication Failure: nonce do not match (' + this._nonceC + ') vs (' + data.nonceC + ')'));
          return;
        }
        const challenge = NET_IDENT + this._passwd + this._nonceC + data.nonceS + data.salt;
        const proof = this._hash(challenge);
        const pkt = {
          nonceC: this._nonceC,
          nonceS: data.nonceS,
          proof: proof
        };
        const json = JSON.stringify(pkt);
        const req = new Request(json.length, 0, 0, 0, 10, 32);
        try {
          this._send(req, json);
        } catch (err) {
          reject(err);
          return;
        }
        this._onauthdata = AuthReply;
      }
      function AuthReply(data) {
        delete this._onauthdata;
        if (data.E != ErrorCode.SUCCESS) {
          if (this.onAuthenticationNeeded) {
            let pass;
            try {
              pass = this.onAuthenticationNeeded();
            } catch (err) {
              logEventException(err);
            }
            if (pass != undefined && typeof pass === 'string') {
              this._passwd = pass;
              setTimeout(() => {
                this.connect().then(() => resolve()).catch(err => reject(err));
              }, 10);
              return;
            }
          } else {
            logwarn("A password is required for this server. Handle the onAuthenticationNeeded event to return a password.");
          }
          reject(new PhidgetError(data.E, 'authentication failed: server rejected proof'));
          return;
        }
        this.connected = true;
        if (this.onConnect) {
          try {
            this.onConnect();
          } catch (err) {
            logEventException(err);
          }
        }
        if (this._connectionMaintainer != undefined) clearTimeout(this._connectionMaintainer);
        delete this._connectionMaintainer;
        this._maintainConnection();
        resolve();
      }
    });
  }
}
function DecodeUTF8(bytes) {
  let s = '';
  let i = 0;
  while (i < bytes.length) {
    let c = bytes[i++];
    if (c > 127) {
      if (c > 191 && c < 224) {
        if (i >= bytes.length) throw 'UTF-8 decode: incomplete 2-byte sequence';
        c = (c & 31) << 6 | bytes[i] & 63;
      } else if (c > 223 && c < 240) {
        if (i + 1 >= bytes.length) throw 'UTF-8 decode: incomplete 3-byte sequence';
        c = (c & 15) << 12 | (bytes[i] & 63) << 6 | bytes[++i] & 63;
      } else if (c > 239 && c < 248) {
        if (i + 2 >= bytes.length) throw 'UTF-8 decode: incomplete 4-byte sequence';
        c = (c & 7) << 18 | (bytes[i] & 63) << 12 | (bytes[++i] & 63) << 6 | bytes[++i] & 63;
      } else throw 'UTF-8 decode: unknown multibyte start 0x' + c.toString(16) + ' at index ' + (i - 1);
      ++i;
    }
    if (c <= 0xffff) s += String.fromCharCode(c);else if (c <= 0x10ffff) {
      c -= 0x10000;
      s += String.fromCharCode(c >> 10 | 0xd800);
      s += String.fromCharCode(c & 0x3FF | 0xdc00);
    } else throw 'UTF-8 decode: code point 0x' + c.toString(16) + ' exceeds UTF-16 reach';
  }
  return s;
}
function EncodeUTF8(s) {
  let i = 0;
  const bytes = new Uint8Array(s.length * 4);
  for (let ci = 0; ci != s.length; ci++) {
    let c = s.charCodeAt(ci);
    if (c < 128) {
      bytes[i++] = c;
      continue;
    }
    if (c < 2048) {
      bytes[i++] = c >> 6 | 192;
    } else {
      if (c > 0xd7ff && c < 0xdc00) {
        if (++ci == s.length) throw 'UTF-8 encode: incomplete surrogate pair';
        const c2 = s.charCodeAt(ci);
        if (c2 < 0xdc00 || c2 > 0xdfff) throw 'UTF-8 encode: second char code 0x' + c2.toString(16) + ' at index ' + ci + ' in surrogate pair out of range';
        c = 0x10000 + ((c & 0x03ff) << 10) + (c2 & 0x03ff);
        bytes[i++] = c >> 18 | 240;
        bytes[i++] = c >> 12 & 63 | 128;
      } else {
        bytes[i++] = c >> 12 | 224;
      }
      bytes[i++] = c >> 6 & 63 | 128;
    }
    bytes[i++] = c & 63 | 128;
  }
  return bytes.subarray(0, i);
}

/**
 * @public
 */
class NetworkConnection extends NetworkConnectionBase {
  constructor(optsOrUriOrPort, optsOrHostname, opts) {
    super(optsOrUriOrPort, optsOrHostname, opts);
    if (this._port === 0) this._port = 8989;
    if (this._uri === '') this._uri = 'ws://' + this._hostname + ':' + this._port + '/phidgets';
    this._protocol = "www";
  }
  /**
   * Connects to the server. Once the initial connection has succeeded,
   * it will be maintained until close is called.
   *
   * It retryOnFail is true, the initial connect will retry on failure until a connection is established,
   * and connect() will not resolve until the connection is established.
   * Thisis allows connect to be called before the network server is running.
   *
   * If retryOnFail is false (the default), connect() will throw an exception
   * if the connection can not be established.
   *
   * @param retryOnFail - Keep trying to connect if the initial attempt fails. Defaults to false.
   */
  connect() {
    let retryOnFail = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    return new _Promise((resolve, reject) => {
      this._opened = true;
      if (this.connected === true) {
        resolve();
        return;
      }
      if (retryOnFail) {
        this._resolveConnect = resolve;
        this._maintainConnection();
        return;
      }
      if (this._ws) {
        try {
          this._ws.close();
        } catch (e) {}
        delete this._ws;
      }
      let hasCompleted = false;
      try {
        this._ws = new WebSocket(this._uri);
        this._ws.binaryType = 'arraybuffer';
        this._ws.onopen = () => {
          this._handshake().then(() => {
            if (this._resolveConnect) {
              this._resolveConnect();
              delete this._resolveConnect;
            }
            if (this._connectTimeout !== undefined) {
              clearTimeout(this._connectTimeout);
              delete this._connectTimeout;
            }
            hasCompleted = true;
            resolve();
          }).catch(err => {
            if (this._connectTimeout !== undefined) {
              clearTimeout(this._connectTimeout);
              delete this._connectTimeout;
            }
            if (!hasCompleted) {
              hasCompleted = true;
              reject(err);
            }
          });
        };
        this._ws.onclose = () => {
          this._doclose();
          if (!hasCompleted) {
            hasCompleted = true;
            reject(new PhidgetError(ErrorCode.CONNECTION_RESET, "Socket closed"));
          }
        };
        this._ws.onmessage = event => {
          try {
            const array = new Uint8Array(event.data);
            const req = new Request(array);
            let msg;
            if (req.len > 0) {
              const tmp1 = new Uint8Array(event.data, req.hdrlen, req.len);
              msg = DecodeUTF8(tmp1);
            }
            this._onmessage(msg, req);
          } catch (e) {
            const msg = "Error handling data from server - resetting connection";
            const perr = new PhidgetError(ErrorCode.UNEXPECTED, msg, e);
            this._doclose();
            if (hasCompleted) {
              if (this.onError) {
                try {
                  this.onError(perr.errorCode, perr.message);
                } catch (err) {
                  logEventException(err);
                }
                loginfo(perr.message);
              } else {
                logerr(msg, e);
              }
            } else {
              hasCompleted = true;
              reject(perr);
            }
          }
        };
        this._ws.onerror = () => {
          const msg = "websocket error - check that server is available";
          this._doclose();
          if (!hasCompleted) {
            hasCompleted = true;
            reject(new PhidgetError(ErrorCode.CONNECTION_REFUSED, msg));
            return;
          }
          if (this.onError) {
            try {
              this.onError(ErrorCode.CONNECTION_REFUSED, msg);
            } catch (err) {
              logEventException(err);
            }
            loginfo(msg);
          } else {
            logerr(msg);
          }
        };
        this._connectTimeout = setTimeout(() => {
          delete this._connectTimeout;
          this._doclose();
          if (!hasCompleted) {
            hasCompleted = true;
            reject(new PhidgetError(ErrorCode.TIMEOUT, "Connection Timed Out"));
          }
        }, this._timeout);
      } catch (err) {
        if (this._connectTimeout !== undefined) {
          clearTimeout(this._connectTimeout);
          delete this._connectTimeout;
        }
        if (!hasCompleted) {
          hasCompleted = true;
          reject(new PhidgetError(ErrorCode.UNEXPECTED, 'Error in connect', err));
        }
      }
    });
  }
  /** @internal */
  _closesocket() {
    if (this.connected === true) {
      if (this.onDisconnect) {
        try {
          this.onDisconnect();
        } catch (err) {
          logEventException(err);
        }
      }
    }
    this.connected = false;
    if (this._connectTimeout !== undefined) {
      clearTimeout(this._connectTimeout);
      delete this._connectTimeout;
    }
    if (this._ws != undefined) {
      try {
        this._ws.onopen = null;
        this._ws.onclose = null;
        this._ws.onmessage = null;
        this._ws.onerror = null;
        this._ws.close();
      } catch (_a) {}
      delete this._ws;
    }
    this._generation++;
  }
  /** @internal */
  _send(req, data) {
    try {
      if (!this._ws || this._ws.readyState != WebSocket.OPEN) throw new PhidgetError(ErrorCode.UNEXPECTED, 'invalid websocket state');
      if (data.length > 0) {
        const dataArr = EncodeUTF8(data);
        req.len = dataArr.length;
        this._ws.send(req.buffer);
        this._ws.send(dataArr);
      } else {
        this._ws.send(req.buffer);
      }
    } catch (e) {
      let msg;
      if (typeof e === 'string') msg = e;else if (e instanceof Error) msg = e.message;else msg = 'Error in connect';
      throw new PhidgetError(ErrorCode.UNEXPECTED, msg);
    }
  }
  /** @internal */
  _hash(challenge) {
    const digest = sha256hash(challenge);
    let bin = '';
    for (let i = 0; i < digest.length; i += 2) {
      const b = parseInt(digest.substring(i, i + 2), 16);
      bin += String.fromCharCode(b);
    }
    return btoa(bin);
  }
  /** @internal */
  _createSalt(len) {
    const buf = new Uint8Array(len);
    crypto.getRandomValues(buf);
    return btoa(String.fromCharCode(...buf)).substring(len);
  }
}

const PHIDGET_MAXCHANNELS = 64;
const MAX_OUT_PACKET_SIZE = 128;
/** @internal */
class LocalDevice extends Device {
  constructor(conn, data) {
    super(conn, data);
    this.deviceID = this.devDef.d;
    this.name = this.devDef.t;
    this.channels = {};
  }
  getChannel(index) {
    if (this.channels[index] != undefined && this.channels[index].isopen) return this.channels[index];
    return null;
  }
}

function GetBigInt64(view, offset) {
  if ("getBigInt64" in DataView.prototype) {
    return Number(view.getBigInt64(offset));
  } else {
    const isNegative = (view.getUint8(offset) & 0x80) > 0;
    let uint64 = 0;
    let carrying = true;
    for (let i = 0; i < 2; i++) {
      let uint32 = view.getUint32(offset + (4 - i * 4));
      if (isNegative) {
        if (carrying) {
          if (uint32 !== 0x00000000) {
            uint32 = ~(uint32 - 1) & 0xFFFFFFFF;
            carrying = false;
          }
        } else {
          uint32 = ~uint32 & 0xFFFFFFFF;
        }
      }
      uint64 += uint32 * 2 ** (8 * i);
    }
    return isNegative ? -uint64 : uint64;
  }
}
function SetBigInt64(view, offset, value) {
  const temp = value >> 2;
  view.setInt32(offset, temp >> 30);
  view.setUint32(offset + 4, value & 0xFFFFFFFF);
}
function StringToWordByteArray(buff) {
  const wordarray = new Uint16Array(buff.length);
  let i = 0;
  for (i = 0; i < buff.length; i++) {
    wordarray[i] = buff.charCodeAt(i);
  }
  return wordarray;
}
function WordByteArrayToString(bytearray) {
  return String.fromCharCode(...bytearray);
}
function RoundDouble(num, decimals) {
  return Math.round(num * Math.pow(10, decimals)) / Math.pow(10, decimals);
}
function UpperPowerOfTwo(v) {
  v--;
  v |= v >> 1;
  v |= v >> 2;
  v |= v >> 4;
  v |= v >> 8;
  v |= v >> 16;
  v++;
  return v;
}
const PhidgetSleep = delay => new _Promise(resolve => setTimeout(resolve, delay));

const MAX_PACKET_IDS = 128;
const PACKETTRACKER_INUSE = 0x01;
const PACKETTRACKER_SIGNALLED = 0x02;
const PACKETTRACKER_SENT = 0x04;
const PACKETTRACKER_ABANDONNED = 0x08;
class PacketTrackers {
  constructor() {
    this.packetTracker = new Map();
    this.counter = [];
  }
  setPacketsReturnCode(child, res) {
    for (const pt of _valuesInstanceProperty(_context = this.packetTracker).call(_context)) {
      var _context;
      if (!(pt.state & PACKETTRACKER_INUSE)) return;
      if (!(pt.state & PACKETTRACKER_SENT)) return;
      if (pt.childIndex !== child) return;
      if (pt.state & PACKETTRACKER_ABANDONNED) {
        pt.state = 0;
      } else {
        pt.returnCode = res;
        pt.state |= PACKETTRACKER_SIGNALLED;
        if (pt.signal) pt.signal();
      }
    }
  }
  async getPacketTrackerWait(device, min, max, childIndex, timeout) {
    const tm = Date.now() + timeout;
    for (;;) {
      const tracker = this.getPacketTracker(device, min, max, childIndex);
      if (tracker !== null) return tracker;
      if (Date.now() > tm) throw new PhidgetError(ErrorCode.TIMEOUT);
      await PhidgetSleep(2);
      logverbose("getPacketTrackerWait tm after sleep: " + Date.now());
    }
  }
  getPacketTracker(device, min, max, childIndex) {
    let i, j;
    if (device === null) throw new PhidgetError(ErrorCode.NOT_ATTACHED);
    if (device.packetTrackers === null) throw new PhidgetError(ErrorCode.UNEXPECTED);
    if (min < 0) throw new PhidgetError(ErrorCode.UNEXPECTED);
    if (max >= MAX_PACKET_IDS) throw new PhidgetError(ErrorCode.UNEXPECTED);
    if (device.packetTrackers.counter[childIndex] == undefined) device.packetTrackers.counter[childIndex] = 0;
    for (j = min; j <= max; j++) {
      i = j + device.packetTrackers.counter[childIndex];
      if (i > max) i -= max - min;
      if (i < min || i > max) throw new PhidgetError(ErrorCode.INVALID, "Calculated an invalid packetTracker");
      let pt = device.packetTrackers.packetTracker.get(i);
      if (pt == undefined) {
        pt = new PacketTracker();
        device.packetTrackers.packetTracker.set(i, pt);
      }
      if (pt.state & PACKETTRACKER_INUSE) continue;
      pt.state |= PACKETTRACKER_INUSE;
      pt.returnCode = ErrorCode.UNKNOWN_VALUE;
      pt.len = 0;
      pt.childIndex = childIndex;
      device.packetTrackers.counter[childIndex]++;
      if (device.packetTrackers.counter[childIndex] > max - min) device.packetTrackers.counter[childIndex] = 0;
      return {
        pt: pt,
        id: i
      };
    }
    return null;
  }
  async waitForPendingPackets(child) {
    let stillSomeLeft;
    const timetm = Date.now() + 10;
    do {
      stillSomeLeft = 0;
      for (const pt of _valuesInstanceProperty(_context2 = this.packetTracker).call(_context2)) {
        var _context2;
        if (pt.childIndex !== child) return;
        if (!(pt.state & PACKETTRACKER_INUSE)) return;
        if (!(pt.state & PACKETTRACKER_SIGNALLED)) return;
        stillSomeLeft++;
      }
      if (stillSomeLeft) {
        if (Date.now() > timetm) {
          break;
        }
        await PhidgetSleep(10);
      }
    } while (stillSomeLeft);
  }
}
class PacketTracker {
  constructor() {
    this.state = 0;
    this.returnCode = ErrorCode.SUCCESS;
    this.childIndex = 0;
    this.len = 0;
  }
  setPacketLength(len) {
    this.len = len;
  }
  setPacketDevice(udd) {
    this.devDef = udd;
  }
  setPacketReturnCode(res) {
    if ((this.state & PACKETTRACKER_INUSE) === 0 || this.state & PACKETTRACKER_SIGNALLED) throw new PhidgetError(ErrorCode.INVALID);
    this.returnCode = res;
    this.state |= PACKETTRACKER_SIGNALLED;
    if (this.signal) this.signal();
  }
  get signalled() {
    return this.state & PACKETTRACKER_SIGNALLED ? true : false;
  }
  set sent(val) {
    if (val) this.state |= PACKETTRACKER_SENT;else this.state &= ~PACKETTRACKER_SENT;
  }
  async waitForPendingPacket(timeout) {
    if (!(this.state & PACKETTRACKER_INUSE)) throw new PhidgetError(ErrorCode.UNEXPECTED, "PacketTracker not INUSE");
    if (this.state & PACKETTRACKER_SIGNALLED) return this.returnCode;
    if (timeout === 0) throw new PhidgetError(ErrorCode.TIMEOUT);
    logverbose("waiting for PendingPacket: " + timeout + "ms...");
    await new _Promise((resolve, reject) => {
      const timer = setTimeout(() => {
        logwarn("PacketTracker " + this.childIndex + " waitForPendingPacket timeout (" + timeout + "ms).");
        delete this.signal;
        reject(new PhidgetError(ErrorCode.TIMEOUT));
      }, timeout);
      this.signal = () => {
        clearTimeout(timer);
        delete this.signal;
        resolve();
      };
    });
    logverbose("no longer waiting for PendingPacket");
    return this.returnCode;
  }
  releasePacketTracker(force) {
    if (force) {
      this.state = 0;
    } else {
      if ((this.state & (PACKETTRACKER_INUSE | PACKETTRACKER_SIGNALLED | PACKETTRACKER_SENT)) !== (PACKETTRACKER_INUSE | PACKETTRACKER_SENT)) {
        this.state = 0;
      } else {
        logverbose("Refusing to release sent but non-signalled packet tracker, Port " + this.childIndex);
        this.state |= PACKETTRACKER_ABANDONNED;
      }
    }
  }
}

var es_array_reverse = {};

var isArray;
var hasRequiredIsArray;
function requireIsArray () {
	if (hasRequiredIsArray) return isArray;
	hasRequiredIsArray = 1;
	var classof =  requireClassofRaw();
	isArray = Array.isArray || function isArray(argument) {
	  return classof(argument) === 'Array';
	};
	return isArray;
}

var hasRequiredEs_array_reverse;
function requireEs_array_reverse () {
	if (hasRequiredEs_array_reverse) return es_array_reverse;
	hasRequiredEs_array_reverse = 1;
	var $ =  require_export();
	var uncurryThis =  requireFunctionUncurryThis();
	var isArray =  requireIsArray();
	var nativeReverse = uncurryThis([].reverse);
	var test = [1, 2];
	$({ target: 'Array', proto: true, forced: String(test) === String(test.reverse()) }, {
	  reverse: function reverse() {
	    if (isArray(this)) this.length = this.length;
	    return nativeReverse(this);
	  }
	});
	return es_array_reverse;
}

var reverse$3;
var hasRequiredReverse$3;
function requireReverse$3 () {
	if (hasRequiredReverse$3) return reverse$3;
	hasRequiredReverse$3 = 1;
	requireEs_array_reverse();
	var getBuiltInPrototypeMethod =  requireGetBuiltInPrototypeMethod();
	reverse$3 = getBuiltInPrototypeMethod('Array', 'reverse');
	return reverse$3;
}

var reverse$2;
var hasRequiredReverse$2;
function requireReverse$2 () {
	if (hasRequiredReverse$2) return reverse$2;
	hasRequiredReverse$2 = 1;
	var isPrototypeOf =  requireObjectIsPrototypeOf();
	var method =  requireReverse$3();
	var ArrayPrototype = Array.prototype;
	reverse$2 = function (it) {
	  var own = it.reverse;
	  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.reverse) ? method : own;
	};
	return reverse$2;
}

var reverse$1;
var hasRequiredReverse$1;
function requireReverse$1 () {
	if (hasRequiredReverse$1) return reverse$1;
	hasRequiredReverse$1 = 1;
	var parent =  requireReverse$2();
	reverse$1 = parent;
	return reverse$1;
}

var reverse;
var hasRequiredReverse;
function requireReverse () {
	if (hasRequiredReverse) return reverse;
	hasRequiredReverse = 1;
	reverse =  requireReverse$1();
	return reverse;
}

var reverseExports = requireReverse();
var _reverseInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reverseExports);

/** @internal */
function supportedEncoderIOMode(ch, val) {
  if (val < EncoderIOMode.PUSH_PULL || val > EncoderIOMode.OPEN_COLLECTOR_10K) return false;
  switch (val) {
    case EncoderIOMode.PUSH_PULL:
    case EncoderIOMode.LINE_DRIVER_2K2:
    case EncoderIOMode.LINE_DRIVER_10K:
    case EncoderIOMode.OPEN_COLLECTOR_2K2:
    case EncoderIOMode.OPEN_COLLECTOR_10K:
      switch (ch.chDef.uid) {
        case 274:
        case 279:
        case 285:
        case 283:
        case 289:
        case 345:
        case 165:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedPowerSupply(ch, val) {
  if (val < PowerSupply.OFF || val > PowerSupply.VOLTS_24) return false;
  switch (val) {
    case PowerSupply.OFF:
    case PowerSupply.VOLTS_12:
    case PowerSupply.VOLTS_24:
      switch (ch.chDef.uid) {
        case 261:
        case 260:
        case 262:
        case 259:
        case 265:
        case 264:
        case 266:
        case 263:
        case 269:
        case 268:
        case 270:
        case 267:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedDataAdapterVoltage(ch, val) {
  if (val < DataAdapterVoltage.EXTERNAL || val > DataAdapterVoltage.VOLTS_5) return false;
  switch (val) {
    case DataAdapterVoltage.EXTERNAL:
    case DataAdapterVoltage.VOLTS_2_5:
    case DataAdapterVoltage.VOLTS_3_3:
    case DataAdapterVoltage.VOLTS_5:
      switch (ch.chDef.uid) {
        case 223:
        case 226:
        case 224:
        case 227:
        case 225:
        case 228:
        case 229:
        case 232:
        case 230:
        case 233:
        case 231:
        case 234:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedRTDWireSetup(ch, val) {
  if (val < RTDWireSetup.WIRES_2 || val > RTDWireSetup.WIRES_4) return false;
  switch (val) {
    case RTDWireSetup.WIRES_2:
    case RTDWireSetup.WIRES_3:
    case RTDWireSetup.WIRES_4:
      switch (ch.chDef.uid) {
        case 439:
        case 438:
        case 441:
        case 440:
        case 442:
        case 443:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedInputMode(ch, val) {
  if (val < InputMode.NPN || val > InputMode.PULLUP) return false;
  switch (val) {
    case InputMode.NPN:
    case InputMode.PNP:
      switch (ch.chDef.uid) {
        case 261:
        case 262:
        case 265:
        case 266:
        case 269:
        case 270:
          return true;
        default:
          return false;
      }
    case InputMode.FLOATING:
    case InputMode.PULLUP:
      switch (ch.chDef.uid) {
        case 224:
        case 227:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedFanMode(ch, val) {
  if (val < FanMode.OFF || val > FanMode.AUTO) return false;
  switch (val) {
    case FanMode.OFF:
    case FanMode.ON:
    case FanMode.AUTO:
      switch (ch.chDef.uid) {
        case 407:
        case 410:
        case 273:
        case 278:
        case 284:
        case 283:
        case 289:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedDriveMode(ch, val) {
  if (val < DriveMode.COAST || val > DriveMode.FORCED) return false;
  switch (val) {
    case DriveMode.COAST:
    case DriveMode.FORCED:
      switch (ch.chDef.uid) {
        case 291:
        case 298:
        case 328:
        case 335:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedSpatialPrecision(_ch, val) {
  if (val < SpatialPrecision.HYBRID || val > SpatialPrecision.LOW) return false;
  return true;
}
/** @internal */
function supportedBridgeGain(ch, val) {
  if (val < BridgeGain.GAIN_1X || val > BridgeGain.GAIN_128X) return false;
  switch (val) {
    case BridgeGain.GAIN_1X:
    case BridgeGain.GAIN_64X:
    case BridgeGain.GAIN_128X:
      switch (ch.chDef.uid) {
        case 120:
        case 121:
        case 271:
        case 122:
          return true;
        default:
          return false;
      }
    case BridgeGain.GAIN_2X:
      switch (ch.chDef.uid) {
        case 271:
          return true;
        default:
          return false;
      }
    case BridgeGain.GAIN_4X:
      switch (ch.chDef.uid) {
        default:
          return false;
      }
    case BridgeGain.GAIN_8X:
    case BridgeGain.GAIN_16X:
    case BridgeGain.GAIN_32X:
      switch (ch.chDef.uid) {
        case 120:
        case 121:
        case 122:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedVoltageRatioSensorType(ch, val) {
  if (val < VoltageRatioSensorType.VOLTAGE_RATIO || val > VoltageRatioSensorType.PN_3522) return false;
  switch (val) {
    case VoltageRatioSensorType.PN_1101_SHARP2D120X:
    case VoltageRatioSensorType.PN_1101_SHARP2Y0A21:
    case VoltageRatioSensorType.PN_1101_SHARP2Y0A02:
    case VoltageRatioSensorType.PN_1102:
    case VoltageRatioSensorType.PN_1103:
    case VoltageRatioSensorType.PN_1104:
    case VoltageRatioSensorType.PN_1105:
    case VoltageRatioSensorType.PN_1106:
    case VoltageRatioSensorType.PN_1107:
    case VoltageRatioSensorType.PN_1108:
    case VoltageRatioSensorType.PN_1109:
    case VoltageRatioSensorType.PN_1110:
    case VoltageRatioSensorType.PN_1111:
    case VoltageRatioSensorType.PN_1112:
    case VoltageRatioSensorType.PN_1113:
    case VoltageRatioSensorType.PN_1115:
    case VoltageRatioSensorType.PN_1116:
    case VoltageRatioSensorType.PN_1118_AC:
    case VoltageRatioSensorType.PN_1118_DC:
    case VoltageRatioSensorType.PN_1119_AC:
    case VoltageRatioSensorType.PN_1119_DC:
    case VoltageRatioSensorType.PN_1120:
    case VoltageRatioSensorType.PN_1121:
    case VoltageRatioSensorType.PN_1122_AC:
    case VoltageRatioSensorType.PN_1122_DC:
    case VoltageRatioSensorType.PN_1124:
    case VoltageRatioSensorType.PN_1125_HUMIDITY:
    case VoltageRatioSensorType.PN_1125_TEMPERATURE:
    case VoltageRatioSensorType.PN_1126:
    case VoltageRatioSensorType.PN_1128:
    case VoltageRatioSensorType.PN_1129:
    case VoltageRatioSensorType.PN_1131:
    case VoltageRatioSensorType.PN_1134:
    case VoltageRatioSensorType.PN_1136:
    case VoltageRatioSensorType.PN_1137:
    case VoltageRatioSensorType.PN_1138:
    case VoltageRatioSensorType.PN_1139:
    case VoltageRatioSensorType.PN_1140:
    case VoltageRatioSensorType.PN_1141:
    case VoltageRatioSensorType.PN_1146:
    case VoltageRatioSensorType.PN_3120:
    case VoltageRatioSensorType.PN_3121:
    case VoltageRatioSensorType.PN_3122:
    case VoltageRatioSensorType.PN_3123:
    case VoltageRatioSensorType.PN_3130:
    case VoltageRatioSensorType.PN_3520:
    case VoltageRatioSensorType.PN_3521:
    case VoltageRatioSensorType.PN_3522:
      switch (ch.chDef.uid) {
        case 1:
        case 15:
        case 25:
        case 29:
        case 43:
        case 47:
        case 189:
        case 195:
        case 199:
        case 204:
        case 219:
        case 220:
        case 239:
        case 241:
        case 243:
        case 275:
        case 280:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedLEDForwardVoltage(ch, val) {
  if (val < LEDForwardVoltage.VOLTS_1_7 || val > LEDForwardVoltage.VOLTS_5_6) return false;
  switch (val) {
    case LEDForwardVoltage.VOLTS_1_7:
    case LEDForwardVoltage.VOLTS_2_75:
    case LEDForwardVoltage.VOLTS_3_9:
    case LEDForwardVoltage.VOLTS_5_0:
      switch (ch.chDef.uid) {
        case 97:
        case 98:
          return true;
        default:
          return false;
      }
    case LEDForwardVoltage.VOLTS_3_2:
      switch (ch.chDef.uid) {
        case 360:
        case 96:
          return true;
        default:
          return false;
      }
    case LEDForwardVoltage.VOLTS_4_0:
    case LEDForwardVoltage.VOLTS_4_8:
    case LEDForwardVoltage.VOLTS_5_6:
      switch (ch.chDef.uid) {
        case 360:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedRCServoVoltage(ch, val) {
  if (val < RCServoVoltage.VOLTS_5_0 || val > RCServoVoltage.VOLTS_7_4) return false;
  switch (val) {
    case RCServoVoltage.VOLTS_6_0:
    case RCServoVoltage.VOLTS_7_4:
      switch (ch.chDef.uid) {
        case 394:
        case 395:
        case 396:
        case 177:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedVoltageOutputRange(ch, val) {
  if (val < VoltageOutputRange.VOLTS_10 || val > VoltageOutputRange.VOLTS_5) return false;
  switch (val) {
    case VoltageOutputRange.VOLTS_10:
      switch (ch.chDef.uid) {
        case 12:
        case 247:
        case 248:
        case 249:
        case 250:
          return true;
        default:
          return false;
      }
    case VoltageOutputRange.VOLTS_5:
      switch (ch.chDef.uid) {
        case 247:
        case 248:
        case 249:
        case 250:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedVoltageRange(ch, val) {
  if (val < VoltageRange.MILLIVOLTS_10 || val > VoltageRange.AUTO) return false;
  switch (val) {
    case VoltageRange.MILLIVOLTS_10:
    case VoltageRange.MILLIVOLTS_40:
    case VoltageRange.MILLIVOLTS_200:
    case VoltageRange.MILLIVOLTS_1000:
      switch (ch.chDef.uid) {
        case 447:
        case 448:
          return true;
        default:
          return false;
      }
    case VoltageRange.MILLIVOLTS_312_5:
      switch (ch.chDef.uid) {
        case 444:
          return true;
        default:
          return false;
      }
    case VoltageRange.MILLIVOLTS_400:
    case VoltageRange.VOLTS_2:
      switch (ch.chDef.uid) {
        case 222:
          return true;
        default:
          return false;
      }
    case VoltageRange.VOLTS_5:
    case VoltageRange.VOLTS_15:
      switch (ch.chDef.uid) {
        case 445:
        case 446:
          return true;
        default:
          return false;
      }
    case VoltageRange.VOLTS_40:
      switch (ch.chDef.uid) {
        case 444:
        case 445:
        case 446:
          return true;
        default:
          return false;
      }
    case VoltageRange.AUTO:
      switch (ch.chDef.uid) {
        case 445:
        case 446:
        case 447:
        case 448:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedVoltageSensorType(ch, val) {
  if (val < VoltageSensorType.VOLTAGE || val > VoltageSensorType.PN_VCP4115) return false;
  switch (val) {
    case VoltageSensorType.PN_1114:
    case VoltageSensorType.PN_1117:
    case VoltageSensorType.PN_1123:
    case VoltageSensorType.PN_1127:
    case VoltageSensorType.PN_1130_PH:
    case VoltageSensorType.PN_1130_ORP:
    case VoltageSensorType.PN_1132:
    case VoltageSensorType.PN_1133:
    case VoltageSensorType.PN_1135:
    case VoltageSensorType.PN_1142:
    case VoltageSensorType.PN_1143:
    case VoltageSensorType.PN_3500:
    case VoltageSensorType.PN_3501:
    case VoltageSensorType.PN_3502:
    case VoltageSensorType.PN_3503:
    case VoltageSensorType.PN_3585:
    case VoltageSensorType.PN_3586:
    case VoltageSensorType.PN_3587:
    case VoltageSensorType.PN_3588:
    case VoltageSensorType.PN_3589:
    case VoltageSensorType.PN_MOT2002_LOW:
    case VoltageSensorType.PN_MOT2002_MED:
    case VoltageSensorType.PN_MOT2002_HIGH:
    case VoltageSensorType.PN_VCP4114:
    case VoltageSensorType.PN_VCP4115:
      switch (ch.chDef.uid) {
        case 14:
        case 24:
        case 28:
        case 42:
        case 46:
        case 187:
        case 194:
        case 198:
        case 203:
        case 216:
        case 217:
        case 218:
        case 240:
        case 242:
        case 244:
          return true;
        default:
          return false;
      }
    case VoltageSensorType.PN_3507:
    case VoltageSensorType.PN_3508:
    case VoltageSensorType.PN_3509:
    case VoltageSensorType.PN_3510:
    case VoltageSensorType.PN_3511:
    case VoltageSensorType.PN_3512:
    case VoltageSensorType.PN_3513:
    case VoltageSensorType.PN_3514:
    case VoltageSensorType.PN_3515:
    case VoltageSensorType.PN_3516:
    case VoltageSensorType.PN_3517:
    case VoltageSensorType.PN_3518:
    case VoltageSensorType.PN_3519:
    case VoltageSensorType.PN_3584:
      switch (ch.chDef.uid) {
        case 14:
        case 24:
        case 28:
        case 42:
        case 46:
        case 187:
        case 194:
        case 198:
        case 203:
        case 216:
        case 217:
        case 218:
        case 240:
        case 242:
        case 244:
        case 259:
        case 263:
        case 267:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedRFIDProtocol(ch, val) {
  if (val < RFIDProtocol.EM4100 || val > RFIDProtocol.HID_H10301) return false;
  switch (val) {
    case RFIDProtocol.EM4100:
      switch (ch.chDef.uid) {
        case 50:
        case 51:
        case 52:
        case 56:
        case 60:
        case 64:
        case 68:
        case 72:
        case 76:
        case 80:
        case 84:
          return true;
        default:
          return false;
      }
    case RFIDProtocol.ISO11785_FDX_B:
    case RFIDProtocol.PHIDGET_TAG:
      switch (ch.chDef.uid) {
        case 60:
        case 64:
        case 68:
        case 72:
        case 76:
        case 80:
        case 84:
          return true;
        default:
          return false;
      }
    case RFIDProtocol.HID_GENERIC:
    case RFIDProtocol.HID_H10301:
      switch (ch.chDef.uid) {
        case 72:
        case 76:
        case 80:
        case 84:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedRFIDChipset(ch, val) {
  if (val < RFIDChipset.T5577 || val > RFIDChipset.EM4305) return false;
  switch (val) {
    case RFIDChipset.EM4305:
      switch (ch.chDef.uid) {
        case 80:
        case 84:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedSpatialAlgorithm(_ch, val) {
  if (val < SpatialAlgorithm.NONE || val > SpatialAlgorithm.IMU) return false;
  return true;
}
/** @internal */
function supportedRTDType(ch, val) {
  if (val < RTDType.PT100_3850 || val > RTDType.PT1000_3920) return false;
  switch (val) {
    case RTDType.PT100_3850:
    case RTDType.PT1000_3850:
    case RTDType.PT100_3920:
    case RTDType.PT1000_3920:
      switch (ch.chDef.uid) {
        case 438:
        case 440:
        case 442:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedThermocoupleType(ch, val) {
  if (val < ThermocoupleType.J || val > ThermocoupleType.T) return false;
  switch (val) {
    case ThermocoupleType.J:
    case ThermocoupleType.E:
    case ThermocoupleType.T:
      switch (ch.chDef.uid) {
        case 129:
        case 132:
        case 138:
        case 141:
        case 144:
        case 429:
        case 432:
        case 435:
          return true;
        default:
          return false;
      }
    case ThermocoupleType.K:
      switch (ch.chDef.uid) {
        case 129:
        case 132:
        case 136:
        case 138:
        case 141:
        case 144:
        case 429:
        case 432:
        case 435:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedFrequencyFilterType(ch, val) {
  if (val < FrequencyFilterType.ZERO_CROSSING || val > FrequencyFilterType.LOGIC_LEVEL) return false;
  switch (val) {
    case FrequencyFilterType.ZERO_CROSSING:
      switch (ch.chDef.uid) {
        case 154:
          return true;
        default:
          return false;
      }
    case FrequencyFilterType.LOGIC_LEVEL:
      switch (ch.chDef.uid) {
        case 154:
        case 262:
        case 266:
        case 270:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedStepperControlMode(_ch, val) {
  if (val < StepperControlMode.STEP || val > StepperControlMode.RUN) return false;
  return true;
}
/** @internal */
function supportedLCDFont(ch, val) {
  if (val < LCDFont.USER1 || val > LCDFont.DIMENSIONS_6X12) return false;
  switch (val) {
    case LCDFont.USER1:
    case LCDFont.USER2:
    case LCDFont.DIMENSIONS_6X10:
    case LCDFont.DIMENSIONS_6X12:
      switch (ch.chDef.uid) {
        case 358:
        case 359:
          return true;
        default:
          return false;
      }
    case LCDFont.DIMENSIONS_5X8:
      switch (ch.chDef.uid) {
        case 202:
        case 207:
        case 208:
        case 209:
        case 210:
        case 358:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedLCDScreenSize(ch, val) {
  if (val < LCDScreenSize.NO_SCREEN || val > LCDScreenSize.DIMENSIONS_64X128) return false;
  switch (val) {
    case LCDScreenSize.NO_SCREEN:
    case LCDScreenSize.DIMENSIONS_1X8:
    case LCDScreenSize.DIMENSIONS_2X8:
    case LCDScreenSize.DIMENSIONS_1X16:
    case LCDScreenSize.DIMENSIONS_2X16:
    case LCDScreenSize.DIMENSIONS_4X16:
    case LCDScreenSize.DIMENSIONS_4X20:
    case LCDScreenSize.DIMENSIONS_2X24:
    case LCDScreenSize.DIMENSIONS_1X40:
    case LCDScreenSize.DIMENSIONS_2X40:
    case LCDScreenSize.DIMENSIONS_4X40:
      switch (ch.chDef.uid) {
        case 208:
          return true;
        default:
          return false;
      }
    case LCDScreenSize.DIMENSIONS_2X20:
      switch (ch.chDef.uid) {
        case 202:
        case 207:
        case 208:
        case 209:
        case 210:
          return true;
        default:
          return false;
      }
    case LCDScreenSize.DIMENSIONS_64X128:
      switch (ch.chDef.uid) {
        case 358:
        case 359:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedLCDPixelState(ch, val) {
  if (val < LCDPixelState.OFF || val > LCDPixelState.INVERT) return false;
  switch (val) {
    case LCDPixelState.OFF:
    case LCDPixelState.ON:
    case LCDPixelState.INVERT:
      switch (ch.chDef.uid) {
        case 358:
        case 359:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedDataAdapterSPIMode(ch, val) {
  if (val < DataAdapterSPIMode.MODE_0 || val > DataAdapterSPIMode.MODE_3) return false;
  switch (val) {
    case DataAdapterSPIMode.MODE_0:
    case DataAdapterSPIMode.MODE_1:
    case DataAdapterSPIMode.MODE_2:
    case DataAdapterSPIMode.MODE_3:
      switch (ch.chDef.uid) {
        case 229:
        case 232:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedDataAdapterFrequency(ch, val) {
  if (val < DataAdapterFrequency.FREQUENCY_10K_HZ || val > DataAdapterFrequency.FREQUENCY_6MHZ) return false;
  switch (val) {
    case DataAdapterFrequency.FREQUENCY_10K_HZ:
    case DataAdapterFrequency.FREQUENCY_100K_HZ:
    case DataAdapterFrequency.FREQUENCY_400K_HZ:
      switch (ch.chDef.uid) {
        case 223:
        case 226:
          return true;
        default:
          return false;
      }
    case DataAdapterFrequency.FREQUENCY_188K_HZ:
    case DataAdapterFrequency.FREQUENCY_375K_HZ:
    case DataAdapterFrequency.FREQUENCY_750K_HZ:
    case DataAdapterFrequency.FREQUENCY_1500K_HZ:
    case DataAdapterFrequency.FREQUENCY_3MHZ:
    case DataAdapterFrequency.FREQUENCY_6MHZ:
      switch (ch.chDef.uid) {
        case 229:
        case 232:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedDataAdapterSPIChipSelect(ch, val) {
  if (val < DataAdapterSPIChipSelect.ACTIVE_LOW || val > DataAdapterSPIChipSelect.HIGH) return false;
  switch (val) {
    case DataAdapterSPIChipSelect.ACTIVE_LOW:
    case DataAdapterSPIChipSelect.ACTIVE_HIGH:
    case DataAdapterSPIChipSelect.LOW:
    case DataAdapterSPIChipSelect.HIGH:
      switch (ch.chDef.uid) {
        case 229:
        case 232:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedDataAdapterEndianness(ch, val) {
  if (val < DataAdapterEndianness.MSB_FIRST || val > DataAdapterEndianness.LSB_FIRST) return false;
  switch (val) {
    case DataAdapterEndianness.MSB_FIRST:
    case DataAdapterEndianness.LSB_FIRST:
      switch (ch.chDef.uid) {
        case 229:
        case 232:
          return true;
        default:
          return false;
      }
    default:
      return true;
  }
}
/** @internal */
function supportedLEDArrayColorOrder(_ch, val) {
  if (val < LEDArrayColorOrder.RGB || val > LEDArrayColorOrder.GRBW) return false;
  return true;
}
/** @internal */
function supportedSPLRange(_ch, val) {
  if (val < SPLRange.DB_102 || val > SPLRange.DB_82) return false;
  return true;
}
/** @internal */
function supportedHubPortMode(_ch, val) {
  if (val < HubPortMode.VINT || val > HubPortMode.VOLTAGE_RATIO_INPUT) return false;
  return true;
}

const NO_ACTIVE_PACKET$1 = 0xFFFF;
const NEW_RX_READY = 0xFFFF;
const DATAADAPTER_MAX_PACKET_LENGTH = 4096;
const VINT_MAX_OUT_PACKETSIZE$1 = 48;
const USB_IN_PACKET_OVERHEAD = 5;
const USB_OUT_PACKET_OVERHEAD$1 = 5;
const USB_OUT_PACKET_LENGTH$1 = 64;
const NEW_PACKET_FLAG$1 = 0x8000;
const WAIT_RESP_FLAG = 0x4000;
const ANONYMOUS_PACKET_ID = 0x0000;
function handleDataAdapterDataInput(ch, buf) {
  let receivedPacketCount;
  let usedPacketLength = 0;
  let packetInfo;
  let packetId;
  let error = 0;
  let errorCode = PacketErrorCode.OK;
  let packetOverhead = USB_IN_PACKET_OVERHEAD;
  let endPacket = 0;
  let newResponsePacket = 0;
  const userphid = ch.userphid;
  switch (buf.getUint8(0)) {
    case 71:
      userphid._supportData = Object.assign(Object.assign({}, userphid._supportData), {
        usbInPacketCount: buf.getUint16(1),
        storedPacketLength: 0,
        rxPacketError: 0,
        droppedPacketID: NO_ACTIVE_PACKET$1,
        rxPacketID: NEW_RX_READY
      });
      break;
    case 65:
      error = 1;
      errorCode = buf.getUint8(5);
      packetOverhead++;
    case 66:
      endPacket = 1;
    case 64:
      receivedPacketCount = buf.getUint16(1);
      packetInfo = buf.getUint16(3);
      packetId = packetInfo & 0x3FFF;
      newResponsePacket = (packetInfo & NEW_PACKET_FLAG$1) !== 0 ? 1 : 0;
      if (userphid._supportData.usbInPacketCount !== receivedPacketCount || newResponsePacket && userphid._supportData.storedPacketLength !== 0) {
        if (newResponsePacket === 0) {
          error = 1;
          errorCode = PacketErrorCode.CORRUPT;
        }
        userphid._supportData.storedPacketLength = 0;
      }
      if (userphid._supportData.rxPacketID === NEW_RX_READY) {
        userphid._supportData.rxPacketID = packetId;
        userphid._supportData.rxPacketError = 0;
      }
      userphid._supportData.rxPacketError |= error;
      if (packetId !== userphid._supportData.rxPacketID && newResponsePacket === 0) {
        error = 1;
        errorCode = PacketErrorCode.CORRUPT;
        userphid._supportData.storedPacketLength = 0;
      }
      userphid._supportData.usbInPacketCount = receivedPacketCount + 1;
      userphid._supportData.lastDataLength = buf.byteLength - packetOverhead;
      new Uint8Array(userphid._supportData.lastData.buffer, userphid._supportData.lastData.byteOffset, userphid._supportData.lastData.byteLength).set(new Uint8Array(buf.buffer, buf.byteOffset + packetOverhead, userphid._supportData.lastDataLength));
      if (userphid._supportData.storedPacketLength + userphid._supportData.lastDataLength <= DATAADAPTER_MAX_PACKET_LENGTH) {
        new Uint8Array(userphid._supportData.storedPacket.buffer, userphid._supportData.storedPacket.byteOffset, userphid._supportData.storedPacket.byteLength).set(new Uint8Array(userphid._supportData.lastData.buffer, 0, userphid._supportData.lastDataLength), userphid._supportData.storedPacketLength);
        userphid._supportData.storedPacketLength += userphid._supportData.lastDataLength;
        if (endPacket === 0) return;
      } else {
        usedPacketLength = DATAADAPTER_MAX_PACKET_LENGTH - userphid._supportData.storedPacketLength;
        new Uint8Array(userphid._supportData.storedPacket.buffer, userphid._supportData.storedPacket.byteOffset, userphid._supportData.storedPacket.byteLength).set(new Uint8Array(userphid._supportData.lastData.buffer, 0, usedPacketLength), userphid._supportData.storedPacketLength);
        userphid._supportData.storedPacketLength = DATAADAPTER_MAX_PACKET_LENGTH;
      }
      userphid._supportData.responseLength = userphid._supportData.storedPacketLength;
      new Uint8Array(userphid._supportData.responsePacket.buffer, userphid._supportData.responsePacket.byteOffset, userphid._supportData.responsePacket.byteLength).set(new Uint8Array(userphid._supportData.storedPacket.buffer, 0, userphid._supportData.storedPacketLength));
      userphid._supportData = Object.assign(Object.assign({}, userphid._supportData), {
        storedPacketLength: 0,
        responseError: errorCode,
        responsePacketID: userphid._supportData.rxPacketID,
        rxPacketID: NEW_RX_READY
      });
      break;
    case 68:
      userphid._supportData.droppedPacketID = buf.getUint16(1);
      userphid._supportData.droppedPacketReason = buf.getUint8(3);
      break;
    case 70:
      userphid._supportData.ackID = buf.getUint16(1) & 0x3FFF;
      userphid._supportData.nakFlag = 0;
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected channel");
  }
}
async function handleDataAdapterSendI2CData(ch, bp, _waitResponse, sendDataPacket) {
  let transmitCount = 0;
  const buffer = new DataView(new ArrayBuffer(1024));
  const dataSize = bp.entries[0].v.length;
  const userphid = ch.userphid;
  if (userphid._supportData.i2cFormatCount === 0) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "I2C Format must be set before data can be exchanged");
  const totalCount = dataSize + userphid._supportData.i2cFormatCount + 2;
  if (totalCount > 512) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Packet is too large.");
  for (let i = 0; i < userphid._supportData.i2cFormatCount; i++) {
    if (!(userphid._supportData.i2cFormatList.getUint8(i) & 0x80)) transmitCount += userphid._supportData.i2cFormatList.getUint8(i) & 0x7F;
  }
  if (transmitCount !== dataSize) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Transmit array length does not match the length specified in I2CFormat");
  buffer.setUint8(0, userphid._supportData.address);
  buffer.setUint8(1, userphid._supportData.i2cFormatCount);
  new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength).set(new Uint8Array(userphid._supportData.i2cFormatList.buffer, userphid._supportData.i2cFormatList.byteOffset, userphid._supportData.i2cFormatCount), 2);
  new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength).set(bp.getArray(0), userphid._supportData.i2cFormatCount + 2);
  await handleDataAdapterSendDataBuffer(ch, totalCount, bp, buffer, _waitResponse, sendDataPacket);
}
async function handleDataAdapterSendData(ch, bp, waitResponse, sendDataPacket) {
  const buf = new DataView(new Uint8Array(bp.getArray(0)).buffer);
  await handleDataAdapterSendDataBuffer(ch, buf.byteLength, bp, buf, waitResponse, sendDataPacket);
}
async function handleDataAdapterSendDataBuffer(ch, len, bp, buf, waitResponse, sendDataPacket) {
  const userphid = ch.userphid;
  let maxDuration;
  let duration;
  let expectedDurationUS;
  let start;
  let packetId;
  let packetLen;
  let packetCount = 0;
  let packetInfo;
  const usbbuf = new DataView(new ArrayBuffer(USB_OUT_PACKET_LENGTH$1));
  if (userphid._supportData.enabled === 0 && ch.parent.class !== DeviceClass.VINT) throw new PhidgetError(ErrorCode.NOT_CONFIGURED, "Data cannot be exchanged from within the attach handler.");
  if (userphid._supportData.txTimeout === 0) {
    switch (ch.chDef.uid) {
      case 223:
      case 226:
        maxDuration = DATAADAPTER_MAX_PACKET_LENGTH / userphid._supportData.baudRate * 2000000 * 10 + 1000000;
        break;
      default:
        maxDuration = len / userphid._supportData.baudRate * 2000000 * 10 + 1000000;
        break;
    }
  } else {
    maxDuration = (userphid._supportData.txTimeout + 50) * 1000;
  }
  switch (ch.chDef.uid) {
    case 223:
    case 226:
      if (userphid._supportData.address === 2147483647) throw new PhidgetError(ErrorCode.NOT_CONFIGURED, "I2C requires a Device Address to be set before sending data.");
      break;
  }
  if (userphid._supportData.baudRate === 0) throw new PhidgetError(ErrorCode.NOT_CONFIGURED, "Baud Rate Not Configured");
  let maxOutPacketSize;
  switch (ch.chDef.uid) {
    case 223:
    case 229:
      maxOutPacketSize = USB_OUT_PACKET_LENGTH$1;
      break;
    case 226:
    case 232:
      maxOutPacketSize = VINT_MAX_OUT_PACKETSIZE$1;
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected Channel UID");
  }
  userphid._stopwatch.reset();
  userphid._stopwatch.start();
  start = userphid._stopwatch.getTimeMicroseconds();
  userphid._supportData.packetID++;
  userphid._supportData.packetID &= 0x3FFF;
  if (userphid._supportData.packetID === ANONYMOUS_PACKET_ID) userphid._supportData.packetID = 0x0001;
  packetId = userphid._supportData.packetID;
  if (len > 0) {
    if (len <= maxOutPacketSize - USB_OUT_PACKET_OVERHEAD$1) {
      packetLen = len + USB_IN_PACKET_OVERHEAD;
      packetInfo = NEW_PACKET_FLAG$1 | packetId;
      if (waitResponse === 1) packetInfo |= WAIT_RESP_FLAG;
      usbbuf.setUint16(0, packetInfo);
      usbbuf.setUint32(2, len << 8);
      new Uint8Array(usbbuf.buffer, usbbuf.byteOffset, usbbuf.byteLength).set(new Uint8Array(buf.buffer, 0, len), USB_OUT_PACKET_OVERHEAD$1);
      try {
        await sendDataPacket(usbbuf, packetLen, ch);
      } catch (e) {
        handleDataAdapterReturnCode(userphid, e);
      }
    } else {
      let i = 0;
      for (i = 0; i + (maxOutPacketSize - USB_OUT_PACKET_OVERHEAD$1) < len; i += maxOutPacketSize - USB_OUT_PACKET_OVERHEAD$1) {
        packetLen = maxOutPacketSize;
        if (i === 0) {
          packetInfo = NEW_PACKET_FLAG$1 | packetId;
          if (waitResponse === 1) packetInfo |= WAIT_RESP_FLAG;
          usbbuf.setUint16(0, packetInfo);
          usbbuf.setUint32(2, len << 8);
        } else {
          usbbuf.setUint16(0, packetId);
          usbbuf.setUint32(2, packetCount << 8);
        }
        if (userphid._supportData.droppedPacketID === packetId) {
          userphid._supportData.droppedPacketID = NO_ACTIVE_PACKET$1;
          handleDataAdapterReturnCode(userphid, new PhidgetError(ErrorCode.INTERRUPTED));
        }
        new Uint8Array(usbbuf.buffer, usbbuf.byteOffset, usbbuf.byteLength).set(new Uint8Array(buf.buffer, i, packetLen - USB_OUT_PACKET_OVERHEAD$1), USB_OUT_PACKET_OVERHEAD$1);
        try {
          await sendDataPacket(usbbuf, packetLen, ch);
        } catch (e) {
          handleDataAdapterReturnCode(userphid, e);
        }
        packetCount++;
      }
      if (i !== len) {
        packetLen = len - i + USB_OUT_PACKET_OVERHEAD$1;
        buf.setUint16(0, packetId);
        buf.setUint32(2, packetCount << 8);
        if (userphid._supportData.droppedPacketID === packetId) {
          userphid._supportData.droppedPacketID = NO_ACTIVE_PACKET$1;
          handleDataAdapterReturnCode(userphid, new PhidgetError(ErrorCode.INTERRUPTED));
        }
        new Uint8Array(usbbuf.buffer, usbbuf.byteOffset, usbbuf.byteLength).set(new Uint8Array(buf.buffer, i, packetLen - USB_OUT_PACKET_OVERHEAD$1), USB_OUT_PACKET_OVERHEAD$1);
        try {
          await sendDataPacket(usbbuf, packetLen, ch);
        } catch (e) {
          handleDataAdapterReturnCode(userphid, e);
        }
      }
    }
  }
  while (true) {
    if (userphid._supportData.responsePacketID === packetId) {
      if (waitResponse !== 0) {
        const replyArray = new Uint8Array(userphid._supportData.responsePacket.buffer, 0, userphid._supportData.responseLength);
        bp.set({
          name: bp.entryCount.toString(),
          type: "R",
          value: [...replyArray]
        });
        userphid._supportData.responseLength = 0;
      }
      switch (userphid._supportData.responseError) {
        case PacketErrorCode.OK:
          return;
        case PacketErrorCode.TIMEOUT:
          userphid._supportData.responseError = PacketErrorCode.OK;
          throw new PhidgetError(ErrorCode.TIMEOUT, "Packet timed out");
        case PacketErrorCode.NACK:
          userphid._supportData.responseError = PacketErrorCode.OK;
          throw new PhidgetError(ErrorCode.NACK, "Packet was NACKed by the external device.");
        case PacketErrorCode.UNKNOWN:
        case PacketErrorCode.FORMAT:
        case PacketErrorCode.INVALID:
        case PacketErrorCode.OVERRUN:
        case PacketErrorCode.CORRUPT:
        default:
          userphid._supportData.responseError = PacketErrorCode.OK;
          throw new PhidgetError(ErrorCode.INTERRUPTED, "Something happened to corrupt the response data.");
      }
    }
    if (userphid._supportData.droppedPacketID === packetId) {
      handleDataAdapterReturnCode(userphid, new PhidgetError(ErrorCode.INTERRUPTED));
    }
    if (!ch.isopen) throw new PhidgetError(ErrorCode.CLOSED);
    duration = userphid._stopwatch.getTimeMicroseconds() - start;
    if (duration >= maxDuration) throw new PhidgetError(ErrorCode.TIMEOUT);
    expectedDurationUS = len * 8 * 1000000 / userphid._supportData.baudRate;
    if (expectedDurationUS > duration) {
      if (waitResponse === 1 || expectedDurationUS - duration > 20000) await PhidgetSleep((expectedDurationUS - duration) / 1000);else await PhidgetSleep(1);
    }
    await PhidgetSleep(1);
  }
}
function handleDataAdapterReturnCode(userphid, ret) {
  userphid._supportData.droppedPacketID = NO_ACTIVE_PACKET$1;
  if (ret.errorCode === ErrorCode.NOT_CONFIGURED) throw new PhidgetError(ErrorCode.NOT_CONFIGURED, "Data cannot be exchanged from within the attach handler");
  switch (userphid._supportData.droppedPacketReason) {
    case 5:
      throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "The packet is too large to be accepted by the device");
    case 1:
      throw new PhidgetError(ErrorCode.TIMEOUT, "The packet timed out while waiting to be transmitted. Check that your system can keep up with the data being sent.");
    default:
      throw ret;
  }
}

const VINT_MAX_OUT_PACKETSIZE = 48;
const USB_OUT_PACKET_LENGTH = 64;
const USB_OUT_PACKET_OVERHEAD = 5;
const NEW_PACKET_FLAG = 0x8000;
const IS_ANIMATION_FLAG = 0x4000;
const RGBW_FLAG = 0x2000;
const MAX_PACKET_ID = 0x00FF;
const NO_ACTIVE_PACKET = 0xFFFF;
const VINTPacketDescription = {
  0xE0: "Success",
  0xE1: "Not Ready",
  0xE2: "Invalid Argument",
  0xE3: "Invalid Packet Type",
  0xE4: "Invalid Sequence",
  0xE5: "Invalid Command",
  0xE6: "Malformed",
  0xE7: "No Space",
  0xE8: "Unexpected",
  0xE9: "Not Attached",
  0xEA: "Packet Too Big",
  0xEB: "Device Specific Error 0",
  0xF0: "Device Specific Error 1",
  0xF1: "Device Specific Error 2",
  0xF2: "Device Specific Error 3",
  0xF3: "Device Specific Error 4",
  0xF4: "Device Specific Error 5"
};
function VINTPacketCode_to_PhidgetReturnCode(code, udd) {
  switch (code) {
    case 240:
      switch (udd.uid) {
        case 138:
        case 149:
          return ErrorCode.BAD_POWER;
        default:
          return ErrorCode.UNEXPECTED;
      }
    case 241:
      switch (udd.uid) {
        case 138:
        case 149:
          return ErrorCode.POWER_CYCLE;
        default:
          return ErrorCode.UNEXPECTED;
      }
    case 242:
      switch (udd.uid) {
        case 138:
          return ErrorCode.BADCURRENT;
        case 149:
          return ErrorCode.HALLSENSOR;
        default:
          return ErrorCode.UNEXPECTED;
      }
    case 243:
      switch (udd.uid) {
        case 138:
          return ErrorCode.BADCONNECTION;
        case 149:
          return ErrorCode.BADCURRENT;
        default:
          return ErrorCode.UNEXPECTED;
      }
    case 244:
      switch (udd.uid) {
        case 149:
          return ErrorCode.BADCONNECTION;
        default:
          return ErrorCode.UNEXPECTED;
      }
    case 224:
      return ErrorCode.SUCCESS;
    case 231:
      return ErrorCode.NO_SPACE;
    case 225:
      return ErrorCode.BUSY;
    case 234:
      return ErrorCode.FILE_TOO_BIG;
    case 233:
      return ErrorCode.NOT_ATTACHED;
    case 228:
      return ErrorCode.NOT_CONFIGURED;
    case 226:
      return ErrorCode.INVALID_ARGUMENT;
    case 229:
    case 230:
      return ErrorCode.INVALID;
    case 227:
      return ErrorCode.INVALID_PACKET;
    case 235:
      return ErrorCode.FAILSAFE;
    case 232:
    default:
      return ErrorCode.UNEXPECTED;
  }
}
async function send1014_3_VINT(ch, bp) {
  let dutyCycle;
  const buf = new DataView(new ArrayBuffer(2));
  switch (ch.chDef.uid) {
    case 36:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          dutyCycle = bp.getNumber(0);
          if (dutyCycle !== 0 && dutyCycle !== 1) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          buf.setUint8(0, dutyCycle ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recv1014_3_VINT(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 36:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function send1017_2_VINT(ch, bp) {
  let dutyCycle;
  const buf = new DataView(new ArrayBuffer(2));
  switch (ch.chDef.uid) {
    case 41:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          dutyCycle = bp.getNumber(0);
          if (dutyCycle !== 0 && dutyCycle !== 1) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          buf.setUint8(0, dutyCycle ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recv1017_2_VINT(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 41:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function send1024_1_VINT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(64));
  let tagString;
  let protocol,
    chipset = RFIDChipset.T5577;
  let dutyCycle;
  let len;
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 68:
    case 76:
    case 84:
      switch (bp.vpkt) {
        case 41:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(99, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 201:
          chipset = bp.getNumber(3);
          switch (ch.chDef.uid) {
            case 68:
            case 76:
              if (chipset < RFIDChipset.T5577 || chipset > RFIDChipset.T5577) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
              break;
            case 84:
            default:
              if (chipset < RFIDChipset.T5577 || chipset > RFIDChipset.EM4305) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
              break;
          }
        case 103:
          protocol = bp.getNumber(1);
          switch (ch.chDef.uid) {
            case 68:
              if (protocol < RFIDProtocol.EM4100 || protocol > RFIDProtocol.PHIDGET_TAG) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
              break;
            case 76:
            case 84:
              if (protocol < RFIDProtocol.EM4100 || protocol > RFIDProtocol.HID_H10301) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
              break;
          }
          buf.setUint8(0, bp.getNumber(1));
          buf.setUint8(1, bp.getNumber(2));
          tagString = bp.getString(0);
          if ((protocol === RFIDProtocol.EM4100 || protocol === RFIDProtocol.HID_GENERIC) && tagString.charAt(1) === 'x') {
            tagString = tagString.slice(2);
          }
          if (tagString.length > MAX_OUT_PACKET_SIZE - 3) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          for (let i = 0; i < tagString.length; i++) {
            buf.setUint8(2 + i, tagString.charCodeAt(i));
          }
          buf.setUint8(2 + tagString.length, 0x00);
          if (protocol === RFIDProtocol.EM4100 || protocol === RFIDProtocol.HID_GENERIC) {
            for (let i = 0; i < tagString.length; i++) {
              const toLower = String.fromCharCode(buf.getUint8(2 + i)).toLowerCase();
              buf.setUint8(2 + i, toLower.charCodeAt(0));
            }
          }
          len = tagString.length + 2;
          userphid._setLatestTagString("");
          switch (ch.chDef.uid) {
            case 68:
            case 76:
              await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, len));
              break;
            case 84:
              if (bp.vpkt === 201) {
                buf.setInt32(len, chipset);
                len += 4;
                await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, len));
              } else {
                await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, len));
              }
              break;
          }
          try {
            tagString = userphid._setExpectedTag(protocol, tagString);
            switch (ch.chDef.uid) {
              case 68:
              case 76:
                await userphid._waitForTag(tagString, 700);
                break;
              case 84:
                await userphid._waitForTag(tagString, 1000);
                break;
              default:
                break;
            }
          } catch (_a) {
            throw new PhidgetError(ErrorCode.TIMEOUT, "Timed out waiting for tag to appear after writing. Try again.");
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 69:
    case 70:
    case 71:
    case 77:
    case 78:
    case 79:
    case 85:
    case 86:
    case 87:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          dutyCycle = bp.getNumber(0);
          if (dutyCycle !== 0 && dutyCycle !== 1) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Duty cycle myust be 0 or 1.");
          }
          buf.setUint8(0, dutyCycle);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 34:
        case 111:
          buf.setUint8(0, 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 143:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recv1024_1_VINT(ch, buf) {
  let tagString;
  const pkt = buf.getUint8(0);
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 68:
    case 76:
    case 84:
      switch (pkt) {
        case 96:
          {
            tagString = "";
            for (let i = 2, byteChar = buf.getUint8(i); i < buf.byteLength && String.fromCharCode(byteChar) !== '\0'; i++, byteChar = buf.getUint8(i)) {
              tagString += String.fromCharCode(byteChar);
            }
            userphid._setLatestTagString(tagString);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 's',
              value: tagString
            });
            bp.set({
              name: '1',
              type: 'd',
              value: buf.getUint8(1)
            });
            bp.sendToChannel(ch, 92);
            break;
          }
        case 97:
          {
            tagString = "";
            for (let i = 2, byteChar = buf.getUint8(i); i < buf.byteLength && String.fromCharCode(byteChar) !== '\0'; i++, byteChar = buf.getUint8(i)) {
              tagString += String.fromCharCode(byteChar);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 's',
              value: tagString
            });
            bp.set({
              name: '1',
              type: 'd',
              value: buf.getUint8(1)
            });
            bp.sendToChannel(ch, 93);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 69:
    case 77:
    case 85:
      switch (pkt) {
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
    case 70:
    case 78:
    case 86:
      switch (pkt) {
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function send1024_1_310_VINT(ch, bp) {
  await send1024_1_VINT(ch, bp);
}
function recv1024_1_310_VINT(ch, buf) {
  recv1024_1_VINT(ch, buf);
}
async function send1024_1_320_VINT(ch, bp) {
  await send1024_1_VINT(ch, bp);
}
function recv1024_1_320_VINT(ch, buf) {
  recv1024_1_VINT(ch, buf);
}
async function sendDIGITALINPUT_PORT() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected command received.");
}
function recvDIGITALINPUT_PORT(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 213:
      {
        const bp = new BridgePacket();
        switch (pkt) {
          case 8:
            bp.set({
              name: "0",
              type: "d",
              value: 1
            });
            break;
          case 9:
            bp.set({
              name: "0",
              type: "d",
              value: 0
            });
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        bp.sendToChannel(ch, 90);
        break;
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDIGITALOUTPUT_PORT(ch, bp) {
  const buf = new Uint16Array(1);
  switch (ch.chDef.uid) {
    case 214:
      switch (bp.vpkt) {
        case 82:
          buf.set(bp.getBoolean(0) ? [1 << 15] : [0], 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, buf.byteLength));
          break;
        case 55:
          buf.set([bp.getNumber(0) * (1 << 15)], 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, buf.byteLength));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 215:
      switch (bp.vpkt) {
        case 82:
          buf.set(bp.getBoolean(0) ? [1 << 7] : [0], 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, buf.byteLength));
          break;
        case 55:
          {
            buf.set([bp.getNumber(0) * (1 << 15)], 0);
            const buf8 = new Uint8Array(buf.buffer, 0, buf.byteLength);
            await ch.sendVINTDataPacket(10, _reverseInstanceProperty(buf8).call(buf8));
            break;
          }
        case 146:
          buf.set([bp.getNumber(0)], 0);
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, buf.byteLength));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDIGITALOUTPUT_PORT(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 214:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
    case 215:
      {
        switch (pkt) {
          case 13:
            {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.FAILSAFE_CONDITION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Failsafe procedure initiated."
              });
              ch.sendErrorEvent(bp);
              break;
            }
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDIGITALOUTPUT_PORT_FAILSAFE(ch, bp) {
  await sendDIGITALOUTPUT_PORT(ch, bp);
}
function recvDIGITALOUTPUT_PORT_FAILSAFE(ch, buf) {
  recvDIGITALOUTPUT_PORT(ch, buf);
}
async function sendVOLTAGEINPUT_PORT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 216:
    case 217:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) / 5 * (1 << 15));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 79:
          if (!supportedVoltageSensorType(ch, bp.getNumber(0))) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVOLTAGEINPUT_PORT(ch, buf) {
  const pkt = buf.getUint8(0);
  let voltage;
  switch (ch.chDef.uid) {
    case 216:
    case 217:
      {
        switch (pkt) {
          case 17:
            {
              voltage = buf.getUint16(1) * 5.0 / (1 << 15);
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(voltage, 5)
              });
              bp.sendToChannel(ch, 101);
              break;
            }
          case 18:
            {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              break;
            }
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVOLTAGEINPUT_PORT_5V25(ch, bp) {
  await sendVOLTAGEINPUT_PORT(ch, bp);
}
function recvVOLTAGEINPUT_PORT_5V25(ch, buf) {
  recvVOLTAGEINPUT_PORT(ch, buf);
}
async function sendVOLTAGEINPUT_PORT_V2(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 218:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 79:
          if (!supportedVoltageSensorType(ch, bp.getNumber(0))) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVOLTAGEINPUT_PORT_V2(ch, buf) {
  const pkt = buf.getUint8(0);
  let voltage;
  switch (ch.chDef.uid) {
    case 218:
      {
        switch (pkt) {
          case 17:
            {
              if (buf.byteLength == 6) {
                switch (buf.getUint8(5)) {
                  case 1:
                    {
                      const bp = new BridgePacket();
                      bp.set({
                        name: "0",
                        type: "d",
                        value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                      });
                      bp.set({
                        name: "1",
                        type: "s",
                        value: "Voltage is too high to be accurately measured"
                      });
                      ch.sendErrorEvent(bp);
                      break;
                    }
                  default:
                    throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
                }
              }
              voltage = buf.getFloat32(1, true);
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(voltage, 6)
              });
              bp.sendToChannel(ch, 101);
              break;
            }
          case 18:
            switch (buf.getUint8(1)) {
              case 1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Voltage is too high to be accurately measured"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
            }
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVOLTAGERATIOINPUT_PORT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 219:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 32768);
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 79:
          if (!supportedVoltageRatioSensorType(ch, bp.getNumber(0))) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVOLTAGERATIOINPUT_PORT(ch, buf) {
  let voltageRatio;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 219:
      {
        switch (pkt) {
          case 27:
            {
              voltageRatio = buf.getUint16(1) / (1 << 15);
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(voltageRatio, 5)
              });
              bp.sendToChannel(ch, 102);
              break;
            }
          case 28:
            {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              break;
            }
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVOLTAGERATIOINPUT_PORT_V2(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 220:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 79:
          if (!supportedVoltageRatioSensorType(ch, bp.getNumber(0))) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVOLTAGERATIOINPUT_PORT_V2(ch, buf) {
  const pkt = buf.getUint8(0);
  let voltageRatio;
  switch (ch.chDef.uid) {
    case 220:
      {
        switch (pkt) {
          case 27:
            {
              if (buf.byteLength == 6) {
                switch (buf.getUint8(5)) {
                  case 1:
                    {
                      const bp = new BridgePacket();
                      bp.set({
                        name: "0",
                        type: "d",
                        value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                      });
                      bp.set({
                        name: "1",
                        type: "s",
                        value: "Voltage Ratio is too high to be accurately measured"
                      });
                      ch.sendErrorEvent(bp);
                      break;
                    }
                  default:
                    throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
                }
              }
              voltageRatio = buf.getFloat32(1, true);
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(voltageRatio, 6)
              });
              bp.sendToChannel(ch, 102);
              break;
            }
          case 28:
            switch (buf.getUint8(1)) {
              case 1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Voltage Ratio is too high to be accurately measured"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
            }
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendADP1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 221:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(187, new Uint8Array(buf.buffer));
          break;
        case 134:
          buf.setUint16(0, bp.getNumber(0) * (1 << 3));
          await ch.sendVINTDataPacket(188, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 222:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer));
          break;
        case 87:
          {
            const range = bp.getNumber(0);
            switch (range) {
              case VoltageRange.MILLIVOLTS_400:
              case VoltageRange.VOLTS_2:
                buf.setUint8(0, range);
                await ch.sendVINTDataPacket(22, new Uint8Array(buf.buffer, 0, 1));
                break;
              default:
                throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid or unsupported voltage range for this device.");
            }
            break;
          }
        case 79:
          {
            const sensorType = bp.getNumber(0);
            if (!supportedVoltageSensorType(ch, sensorType)) {
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid or unsupported voltage sensor type");
            }
            break;
          }
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvADP1000(ch, buf) {
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 221:
      switch (pkt) {
        case 185:
          {
            voltage = buf.getInt32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(voltage, 5)
            });
            bp.sendToChannel(ch, 133);
            break;
          }
        case 186:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 222:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getInt32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(voltage, 5)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendADP0001_VINT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  const parentDevice = ch.parent;
  let numChannels = Object.keys(parentDevice.channels).length;
  const userphid = ch.userphid;
  const newBp = new BridgePacket();
  let commFrequency;
  switch (ch.chDef.uid) {
    case 226:
      switch (bp.vpkt) {
        case 168:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(93, new Uint8Array(buf.buffer, 0, 1));
          newBp.set({
            name: "0",
            type: "d",
            value: userphid.data.dataAdapterVoltage
          });
          for (let i = 0; i < numChannels; i++) {
            const channelSib = parentDevice.getChannel(i);
            if (channelSib === null || channelSib.uniqueIndex === ch.uniqueIndex) continue;
            newBp.sendToChannel(channelSib, 168);
          }
          break;
        case 208:
          userphid._supportData.address = bp.getNumber(1);
          userphid._parseI2CFormat(ch, bp.getString(2));
          await handleDataAdapterSendI2CData(ch, bp, 1, userphid._sendDataPacket);
          break;
        case 157:
          switch (bp.getNumber(0)) {
            case DataAdapterFrequency.FREQUENCY_10K_HZ:
              commFrequency = 10000;
              break;
            case DataAdapterFrequency.FREQUENCY_100K_HZ:
              commFrequency = 100000;
              break;
            case DataAdapterFrequency.FREQUENCY_400K_HZ:
              commFrequency = 400000;
              break;
            default:
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          buf.setInt32(0, commFrequency);
          await ch.sendVINTDataPacket(81, new Uint8Array(buf.buffer, 0, 4));
          userphid._supportData.baudRate = commFrequency;
          return;
        case 34:
          userphid._supportData.enabled = 0;
          await ch.sendVINTDataPacket(250);
          return;
        case 111:
          userphid._supportData.enabled = 0;
          await ch.sendVINTDataPacket(250);
          return;
        case 143:
          userphid._supportData.enabled = 1;
          await ch.sendVINTDataPacket(251);
          return;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 227:
      switch (bp.vpkt) {
        case 168:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(93, new Uint8Array(buf.buffer, 0, 1));
          newBp.set({
            name: "0",
            type: "d",
            value: userphid.data.dataAdapterVoltage
          });
          for (let i = 0; i < numChannels; i++) {
            const channelSib = parentDevice.getChannel(i);
            if (channelSib === null || channelSib.uniqueIndex === ch.uniqueIndex) continue;
            newBp.sendToChannel(channelSib, 168);
          }
          break;
        case 64:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 228:
      switch (bp.vpkt) {
        case 168:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(93, new Uint8Array(buf.buffer, 0, 1));
          newBp.set({
            name: "0",
            type: "d",
            value: userphid.data.dataAdapterVoltage
          });
          for (let i = 0; i < numChannels; i++) {
            const channelSib = parentDevice.getChannel(i);
            if (channelSib === null || channelSib.uniqueIndex === ch.uniqueIndex) continue;
            newBp.sendToChannel(channelSib, 168);
          }
          break;
        case 55:
          const dutyCycle = bp.getNumber(0);
          if (dutyCycle !== 0 && dutyCycle !== 1) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          buf.setUint8(0, dutyCycle !== 0 ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 82:
          buf.setUint8(0, bp.getNumber(0) !== 0 ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvADP0001_VINT(ch, buf) {
  const pkt = buf.getUint8(0);
  const bp = new BridgePacket();
  switch (ch.chDef.uid) {
    case 226:
      switch (pkt) {
        case 69:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Overcurrent Condition Detected."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          handleDataAdapterDataInput(ch, buf);
          break;
      }
      break;
    case 227:
      switch (pkt) {
        case 8:
          let state = buf.getUint8(1) ? 1 : 0;
          bp.set({
            name: "0",
            type: "d",
            value: state
          });
          bp.sendToChannel(ch, 90);
          break;
        case 7:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.INVALID_STATE_CONDITION
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Channel Invalidated.  This means some other aspect of the device is making use of the channel."
          });
          ch.sendErrorEvent(bp);
          break;
        case 69:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Overcurrent Condition Detected."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 228:
      switch (pkt) {
        case 16:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.INVALID_STATE_CONDITION
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Channel Invalidated.  This means some other aspect of the device is making use of the channel."
          });
          ch.sendErrorEvent(bp);
          break;
        case 69:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Overcurrent Condition Detected."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendADP0002_VINT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  const parentDevice = ch.parent;
  let numChannels = Object.keys(parentDevice.channels).length;
  const userphid = ch.userphid;
  const newBp = new BridgePacket();
  let commFrequency;
  switch (ch.chDef.uid) {
    case 232:
      switch (bp.vpkt) {
        case 168:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(93, new Uint8Array(buf.buffer, 0, 1));
          newBp.set({
            name: "0",
            type: "d",
            value: userphid.data.dataAdapterVoltage
          });
          for (let i = 0; i < numChannels; i++) {
            const channelSib = parentDevice.getChannel(i);
            if (channelSib === null || channelSib.uniqueIndex === ch.uniqueIndex) continue;
            newBp.sendToChannel(channelSib, 168);
          }
          break;
        case 118:
          await handleDataAdapterSendData(ch, bp, 0, userphid._sendDataPacket);
          break;
        case 169:
          return await handleDataAdapterSendData(ch, bp, 1, userphid._sendDataPacket);
        case 157:
          switch (bp.getNumber(0)) {
            case DataAdapterFrequency.FREQUENCY_188K_HZ:
              commFrequency = 187500;
              break;
            case DataAdapterFrequency.FREQUENCY_375K_HZ:
              commFrequency = 375000;
              break;
            case DataAdapterFrequency.FREQUENCY_750K_HZ:
              commFrequency = 750000;
              break;
            case DataAdapterFrequency.FREQUENCY_1500K_HZ:
              commFrequency = 1500000;
              break;
            case DataAdapterFrequency.FREQUENCY_3MHZ:
              commFrequency = 3000000;
              break;
            case DataAdapterFrequency.FREQUENCY_6MHZ:
              commFrequency = 6000000;
              break;
            default:
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          buf.setInt32(0, commFrequency);
          await ch.sendVINTDataPacket(81, new Uint8Array(buf.buffer, 0, 4));
          userphid._supportData.baudRate = commFrequency;
          return;
        case 160:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(86, new Uint8Array(buf.buffer, 0, 1));
          return;
        case 163:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 1));
          return;
        case 199:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(95, new Uint8Array(buf.buffer, 0, 1));
          return;
        case 200:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(96, new Uint8Array(buf.buffer, 0, 1));
          return;
        case 165:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(91, new Uint8Array(buf.buffer, 0, 1));
          return;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 233:
      switch (bp.vpkt) {
        case 168:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(93, new Uint8Array(buf.buffer, 0, 1));
          newBp.set({
            name: "0",
            type: "d",
            value: userphid.data.dataAdapterVoltage
          });
          for (let i = 0; i < numChannels; i++) {
            const channelSib = parentDevice.getChannel(i);
            if (channelSib === null || channelSib.uniqueIndex === ch.uniqueIndex) continue;
            newBp.sendToChannel(channelSib, 168);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 234:
      switch (bp.vpkt) {
        case 168:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(93, new Uint8Array(buf.buffer, 0, 1));
          newBp.set({
            name: "0",
            type: "d",
            value: userphid.data.dataAdapterVoltage
          });
          for (let i = 0; i < numChannels; i++) {
            const channelSib = parentDevice.getChannel(i);
            if (channelSib === null || channelSib.uniqueIndex === ch.uniqueIndex) continue;
            newBp.sendToChannel(channelSib, 168);
          }
          break;
        case 55:
          const dutyCycle = bp.getNumber(0);
          if (dutyCycle !== 0 && dutyCycle !== 1) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          buf.setUint8(0, dutyCycle !== 0 ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 82:
          buf.setUint8(0, bp.getNumber(0) !== 0 ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvADP0002_VINT(ch, buf) {
  const pkt = buf.getUint8(0);
  const bp = new BridgePacket();
  switch (ch.chDef.uid) {
    case 232:
      switch (pkt) {
        case 69:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Overcurrent Condition Detected."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          handleDataAdapterDataInput(ch, buf);
          break;
      }
      break;
    case 233:
      switch (pkt) {
        case 8:
          let state = buf.getUint8(1) ? 1 : 0;
          bp.set({
            name: "0",
            type: "d",
            value: state
          });
          bp.sendToChannel(ch, 90);
          break;
        case 7:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.INVALID_STATE_CONDITION
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Channel Invalidated.  This means some other aspect of the device is making use of the channel."
          });
          ch.sendErrorEvent(bp);
          break;
        case 69:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Overcurrent Condition Detected."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 234:
      switch (pkt) {
        case 16:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.INVALID_STATE_CONDITION
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Channel Invalidated.  This means some other aspect of the device is making use of the channel."
          });
          ch.sendErrorEvent(bp);
          break;
        case 69:
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "Overcurrent Condition Detected."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function handleLED0100sendAnimation(ch, bp, sendDataPacket) {
  const buffer = new DataView(new ArrayBuffer(1024 + 8));
  const ledDataBuffer = bp.getArray(5);
  const totalCount = ledDataBuffer.length + 8;
  buffer.setUint8(0, bp.getNumber(0));
  buffer.setUint16(1, bp.getNumber(1));
  buffer.setUint16(3, bp.getNumber(2));
  buffer.setUint16(5, bp.getNumber(3));
  buffer.setUint8(7, bp.getNumber(4));
  new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength).set(ledDataBuffer, 8);
  switch (ch === null || ch === void 0 ? void 0 : ch.chDef.uid) {
    case 235:
    case 237:
      await handleLED0100SendDataBuffer(ch, totalCount, buffer, bp, sendDataPacket);
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected channel");
  }
}
async function handleLED0100sendData(ch, bp, sendDataPacket) {
  const buffer = new DataView(new ArrayBuffer(16384 + 4));
  const dataSize = bp.entries[3].v.length;
  const ledData = bp.getArray(3);
  const startAddress = bp.getNumber(0);
  const endAddress = bp.getNumber(1);
  const segmentLength = endAddress - startAddress + 1;
  const segmentCount = segmentLength * 4;
  const totalCount = segmentCount + 4;
  buffer.setUint16(0, bp.getNumber(0));
  buffer.setUint16(2, bp.getNumber(2));
  for (let i = 0; i < segmentCount; i += dataSize) {
    const bufSize = segmentCount - i >= dataSize ? dataSize : segmentCount - i;
    new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength).set(ledData.slice(0, bufSize), i + 4);
  }
  switch (ch === null || ch === void 0 ? void 0 : ch.chDef.uid) {
    case 235:
    case 237:
      await handleLED0100SendDataBuffer(ch, totalCount, buffer, bp, sendDataPacket);
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected channel");
  }
}
function handleLED0100ReturnCode(userphid, ret) {
  userphid._supportData.droppedPacketID = NO_ACTIVE_PACKET;
  let retransmit = false;
  switch (userphid._supportData.droppedPacketReason) {
    case 5:
      throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "The packet is too large to be accepted by the device");
    case 6:
      throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Animations cannot be configured to overlap.");
    case 4:
      throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Fade times cannot be used when animations are active");
    case 7:
    default:
      logdebug("Failed to send, trying again:", ret);
      retransmit = true;
  }
  return retransmit;
}
async function handleLED0100SendDataBuffer(ch, len, buffer, bp, sendDataPacket) {
  let packetLen;
  let packetCount = 0;
  let packetID;
  let packetInfo;
  let i = 0;
  const outBuffer = new DataView(new ArrayBuffer(8192));
  let requestRGBW = 0;
  let lenCapture = len;
  const userphid = ch.userphid;
  let maxOutPacketSize;
  switch (ch.chDef.uid) {
    case 235:
      maxOutPacketSize = USB_OUT_PACKET_LENGTH;
      break;
    case 237:
      maxOutPacketSize = VINT_MAX_OUT_PACKETSIZE;
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected Channel UID");
  }
  switch (ch.chDef.uid) {
    case 235:
    case 237:
      if (bp.vpkt === 118) {
        outBuffer.setUint32(0, buffer.getUint32(0));
        i = 4;
      } else if (bp.vpkt === 203) {
        outBuffer.setBigUint64(0, buffer.getBigUint64(0));
        i = 8;
      }
      switch (userphid._supportData.ledColorOrder) {
        case LEDArrayColorOrder.GRB:
        case LEDArrayColorOrder.RGB:
          requestRGBW = 0;
          break;
        case LEDArrayColorOrder.GRBW:
        case LEDArrayColorOrder.RGBW:
          requestRGBW = 1;
          break;
      }
      for (let j = i; i < lenCapture; i += 4) {
        switch (userphid._supportData.ledColorOrder) {
          case LEDArrayColorOrder.GRB:
            outBuffer.setUint8(j + 1, buffer.getUint8(i + 0));
            outBuffer.setUint8(j + 0, buffer.getUint8(i + 1));
            outBuffer.setUint8(j + 2, buffer.getUint8(i + 2));
            j += 3;
            len--;
            break;
          case LEDArrayColorOrder.RGB:
            outBuffer.setUint8(j + 0, buffer.getUint8(i + 0));
            outBuffer.setUint8(j + 1, buffer.getUint8(i + 1));
            outBuffer.setUint8(j + 2, buffer.getUint8(i + 2));
            j += 3;
            len--;
            break;
          case LEDArrayColorOrder.GRBW:
            outBuffer.setUint8(j + 1, buffer.getUint8(i + 0));
            outBuffer.setUint8(j + 0, buffer.getUint8(i + 1));
            outBuffer.setUint8(j + 2, buffer.getUint8(i + 2));
            outBuffer.setUint8(j + 3, buffer.getUint8(i + 3));
            break;
          case LEDArrayColorOrder.RGBW:
            outBuffer.setUint8(j + 0, buffer.getUint8(i + 0));
            outBuffer.setUint8(j + 1, buffer.getUint8(i + 1));
            outBuffer.setUint8(j + 2, buffer.getUint8(i + 2));
            outBuffer.setUint8(j + 3, buffer.getUint8(i + 3));
            break;
        }
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected Channel UID");
  }
  const usbbuf = new DataView(new ArrayBuffer(USB_OUT_PACKET_LENGTH));
  let duration;
  let start;
  let maxDuration = 5000000;
  userphid._stopwatch.reset();
  userphid._stopwatch.start();
  start = userphid._stopwatch.getTimeMicroseconds();
  retransmit: while (true) {
    packetCount = 0;
    userphid._supportData.packetID++;
    userphid._supportData.packetID &= MAX_PACKET_ID;
    if (userphid._supportData.packetID === 0) userphid._supportData.packetID = 0x0001;
    packetID = userphid._supportData.packetID;
    if (len > 0) {
      if (len <= maxOutPacketSize - USB_OUT_PACKET_OVERHEAD) {
        packetLen = len + USB_OUT_PACKET_OVERHEAD;
        packetInfo = NEW_PACKET_FLAG | packetID;
        if (bp.vpkt === 203) packetInfo |= IS_ANIMATION_FLAG;
        if (requestRGBW) packetInfo |= RGBW_FLAG;
        usbbuf.setUint16(0, packetInfo);
        usbbuf.setUint32(2, len << 8);
        new Uint8Array(usbbuf.buffer, usbbuf.byteOffset, usbbuf.byteLength).set(new Uint8Array(outBuffer.buffer, 0, len), USB_OUT_PACKET_OVERHEAD);
        try {
          await sendDataPacket(usbbuf, packetLen, ch);
        } catch (e) {
          if (handleLED0100ReturnCode(userphid, e)) continue retransmit;
        }
      } else {
        for (i = 0; i + (maxOutPacketSize - USB_OUT_PACKET_OVERHEAD) < len; i += maxOutPacketSize - USB_OUT_PACKET_OVERHEAD) {
          packetLen = maxOutPacketSize;
          if (i === 0) {
            packetInfo = NEW_PACKET_FLAG | packetID;
            if (bp.vpkt === 203) packetInfo |= IS_ANIMATION_FLAG;
            if (requestRGBW) packetInfo |= RGBW_FLAG;
            usbbuf.setUint16(0, packetInfo);
            usbbuf.setUint32(2, len << 8);
          } else {
            usbbuf.setUint16(0, packetID);
            usbbuf.setUint32(2, packetCount << 8);
          }
          if (userphid._supportData.droppedPacketID === packetID) {
            userphid._supportData.droppedPacketID = NO_ACTIVE_PACKET;
            if (handleLED0100ReturnCode(userphid, new PhidgetError(ErrorCode.INTERRUPTED))) continue retransmit;
          }
          new Uint8Array(usbbuf.buffer, usbbuf.byteOffset, usbbuf.byteLength).set(new Uint8Array(outBuffer.buffer, i, packetLen - USB_OUT_PACKET_OVERHEAD), USB_OUT_PACKET_OVERHEAD);
          try {
            await sendDataPacket(usbbuf, packetLen, ch);
          } catch (e) {
            if (handleLED0100ReturnCode(userphid, e)) continue retransmit;
          }
          packetCount++;
        }
        if (i !== len) {
          packetLen = len - i + USB_OUT_PACKET_OVERHEAD;
          usbbuf.setUint16(0, packetID);
          usbbuf.setUint32(2, packetCount << 8);
          if (userphid._supportData.droppedPacketID === packetID) {
            userphid._supportData.droppedPacketID = NO_ACTIVE_PACKET;
            if (handleLED0100ReturnCode(userphid, new PhidgetError(ErrorCode.INTERRUPTED))) continue retransmit;
          }
          new Uint8Array(usbbuf.buffer, usbbuf.byteOffset, usbbuf.byteLength).set(new Uint8Array(outBuffer.buffer, i, packetLen - USB_OUT_PACKET_OVERHEAD), USB_OUT_PACKET_OVERHEAD);
          try {
            await sendDataPacket(usbbuf, packetLen, ch);
          } catch (e) {
            if (handleLED0100ReturnCode(userphid, e)) continue retransmit;
          }
        }
      }
    }
    start = userphid._stopwatch.getTimeMicroseconds();
    while (true) {
      if (userphid._supportData.ackID === packetID) return;
      if (userphid._supportData.droppedPacketID === packetID) {
        if (handleLED0100ReturnCode(userphid, new PhidgetError(ErrorCode.TRY_AGAIN))) continue retransmit;
      }
      if (!userphid.attached) throw new PhidgetError(ErrorCode.CLOSED);
      duration = userphid._stopwatch.getTimeMicroseconds() - start;
      if (duration >= maxDuration) throw new PhidgetError(ErrorCode.TIMEOUT);
      await PhidgetSleep(5);
    }
  }
}
async function sendLED0100_VINT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(MAX_OUT_PACKET_SIZE));
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 237:
      try {
        await userphid._transactionLock.acquire();
        switch (bp.vpkt) {
          case 118:
            await handleLED0100sendData(ch, bp, userphid._sendDataPacket);
            break;
          case 203:
            await handleLED0100sendAnimation(ch, bp, userphid._sendDataPacket);
            userphid._supportData.protocolLocked = 1;
            break;
          case 207:
            buf.setUint8(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 204:
            await ch.sendVINTDataPacket(82);
            break;
          case 56:
            buf.setUint8(0, bp.getBoolean(0) ? 1 : 0);
            await ch.sendVINTDataPacket(85, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 162:
            if (userphid._supportData.protocolLocked === 1 && userphid._supportData.ledColorOrder !== bp.getNumber(0)) throw new PhidgetError(ErrorCode.NOT_CONFIGURED, "LEDArray Protocol cannot be changed after an animation has been set. Call clear() first.");
            userphid._supportData.ledColorOrder = bp.getNumber(0);
            break;
          case 205:
            buf.setFloat32(0, bp.getNumber(0), true);
            await ch.sendVINTDataPacket(86, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 206:
            buf.setFloat32(0, bp.getNumber(0), true);
            await ch.sendVINTDataPacket(87, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 4:
            userphid._supportData.protocolLocked = 0;
            await ch.sendVINTDataPacket(84);
            break;
          case 34:
            userphid._supportData.protocolLocked = 0;
            await ch.sendVINTDataPacket(250);
            break;
          case 111:
            userphid._supportData.protocolLocked = 0;
            await ch.sendVINTDataPacket(250);
            break;
          case 143:
            await ch.sendVINTDataPacket(251);
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      } catch (e) {
        const err = e;
        throw new PhidgetError(err.errorCode, err.message);
      } finally {
        userphid._transactionLock.release();
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function handleLED0100DataInput(ch, buf) {
  let bp;
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 235:
    case 237:
      switch (buf.getUint8(0)) {
        case 66:
          break;
        case 68:
          userphid._supportData.droppedPacketID = buf.getUint16(1);
          userphid._supportData.droppedPacketReason = buf.getUint8(3);
          break;
        case 70:
          userphid._supportData.ackID = buf.getUint16(1) & MAX_PACKET_ID;
          break;
        case 71:
          bp = new BridgePacket();
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "USB Overcurrent, disabling USB power to the LEDs. Consider running at a lower brightness or using an external power supply. Cycle powerEnabled to resume power."
          });
          if ((ch === null || ch === void 0 ? void 0 : ch.chDef.uid) === 237) {
            bp.set({
              name: "1",
              type: "s",
              value: "This device requires an external supply when connected through VINT. Connect an external supply and cycle powerEnabled to try again."
            });
          }
          ch.sendErrorEvent(bp);
          break;
        case 72:
          bp = new BridgePacket();
          bp.set({
            name: "0",
            type: "d",
            value: ErrorEventCode.OVER_CURRENT
          });
          bp.set({
            name: "1",
            type: "s",
            value: "External supply overcurrent, disabling power to the LEDs. Consider running at a lower brightness or powering LEDs offboard. Cycle powerEnabled to resume power."
          });
          ch.sendErrorEvent(bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected channel");
  }
}
function recvLED0100_VINT(ch, buf) {
  switch (ch.chDef.uid) {
    case 237:
      handleLED0100DataInput(ch, buf);
      break;
    case 238:
      switch (buf.getUint8(0)) {
        case 84:
          const current = buf.getFloat32(1, true);
          const bp = new BridgePacket();
          bp.set({
            name: '0',
            type: 'g',
            value: RoundDouble(current, 4)
          });
          bp.sendToChannel(ch, 8);
          break;
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDAQ1000(ch, bp) {
  var _a, _b;
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 239:
    case 241:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 79:
          if (!supportedVoltageRatioSensorType(ch, bp.getNumber(0))) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 240:
    case 242:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_b = ch.parent.parent) === null || _b === void 0 ? void 0 : _b._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 79:
          if (!supportedVoltageSensorType(ch, bp.getNumber(0))) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDAQ1000(ch, buf) {
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 239:
    case 241:
      switch (pkt) {
        case 27:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 4)
            });
            bp.sendToChannel(ch, 102);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 240:
    case 242:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 4)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDAQ1000_5V25(ch, bp) {
  await sendDAQ1000(ch, bp);
}
function recvDAQ1000_5V25(ch, buf) {
  recvDAQ1000(ch, buf);
}
async function sendOUT1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 245:
      switch (bp.vpkt) {
        case 86:
          buf.setInt32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(5, new Uint8Array(buf.buffer));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(4, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 246:
      switch (bp.vpkt) {
        case 86:
          buf.setInt32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(5, new Uint8Array(buf.buffer));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(4, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvOUT1000(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 245:
      switch (pkt) {
        case 6:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.VOLTAGE_ERROR
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Voltage Error Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 246:
      switch (pkt) {
        case 6:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.VOLTAGE_ERROR
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Voltage Error Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 14:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Failsafe procedure initiated."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendOUT1000_Failsafe(ch, bp) {
  await sendOUT1000(ch, bp);
}
function recvOUT1000_Failsafe(ch, buf) {
  recvOUT1000(ch, buf);
}
async function sendOUT1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 247:
      switch (bp.vpkt) {
        case 86:
          buf.setInt32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(5, new Uint8Array(buf.buffer));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(7, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 248:
      switch (bp.vpkt) {
        case 86:
          buf.setInt32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(5, new Uint8Array(buf.buffer));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(7, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvOUT1001(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 247:
      switch (pkt) {
        case 6:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.VOLTAGE_ERROR
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Voltage Error Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 248:
      switch (pkt) {
        case 6:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.VOLTAGE_ERROR
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Voltage Error Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 14:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Failsafe procedure initiated."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendOUT1001_Failsafe(ch, bp) {
  await sendOUT1001(ch, bp);
}
function recvOUT1001_Failsafe(ch, buf) {
  recvOUT1001(ch, buf);
}
async function sendOUT1002(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 249:
      switch (bp.vpkt) {
        case 86:
          buf.setInt32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(5, new Uint8Array(buf.buffer));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(7, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 250:
      switch (bp.vpkt) {
        case 86:
          buf.setInt32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(5, new Uint8Array(buf.buffer));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(7, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvOUT1002(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 249:
      switch (pkt) {
        case 6:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.VOLTAGE_ERROR
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Voltage Error Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 250:
      switch (pkt) {
        case 6:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.VOLTAGE_ERROR
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Voltage Error Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 14:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Failsafe procedure initiated."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendOUT1002_Failsafe(ch, bp) {
  await sendOUT1002(ch, bp);
}
function recvOUT1002_Failsafe(ch, buf) {
  recvOUT1002(ch, buf);
}
async function sendDAQ1200() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected command received");
}
function recvDAQ1200(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 253:
      switch (pkt) {
        case 8:
          {
            const state = buf.getUint8(1) & 0x1;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: state
            });
            bp.sendToChannel(ch, 90);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendOUT1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 254:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 255:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 256:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 156:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(15, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvOUT1100(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 254:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
    case 255:
    case 256:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Failsafe procedure initiated."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendOUT1100_Failsafe(ch, bp) {
  await sendOUT1100(ch, bp);
}
function recvOUT1100_Failsafe(ch, buf) {
  recvOUT1100(ch, buf);
}
async function sendOUT1100_Failsafe_Frequency(ch, bp) {
  await sendOUT1100(ch, bp);
}
function recvOUT1100_Failsafe_Frequency(ch, buf) {
  recvOUT1100(ch, buf);
}
async function sendDAQ1300() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected command received.");
}
function recvDAQ1300(ch, buf) {
  let state;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 257:
      switch (pkt) {
        case 8:
          {
            state = buf.getUint8(1) & 0x1;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: state
            });
            bp.sendToChannel(ch, 90);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDAQ1301() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected command received.");
}
function recvDAQ1301(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 258:
      switch (pkt) {
        case 8:
          {
            const state = buf.getUint8(1) & 0x1;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: state
            });
            bp.sendToChannel(ch, 90);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDAQ1400(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 262:
    case 266:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 74:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(193, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 64:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(194, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 261:
    case 265:
      switch (bp.vpkt) {
        case 74:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(193, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 64:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(194, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 260:
    case 264:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(83, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 74:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(193, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 259:
    case 263:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 74:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(193, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 79:
          if (!supportedVoltageSensorType(ch, bp.getNumber(0))) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDAQ1400(ch, buf) {
  let ticksAtLastCount;
  let counts;
  let ticks;
  let current;
  let voltage;
  let state;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 262:
    case 266:
      switch (pkt) {
        case 132:
          {
            ticks = buf.getUint32(1) / 1000;
            counts = buf.getUint32(5);
            ticksAtLastCount = buf.getUint32(9) / 1000;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: ticks
            });
            bp.set({
              name: '1',
              type: 'u',
              value: counts
            });
            bp.set({
              name: '2',
              type: 'g',
              value: ticksAtLastCount
            });
            bp.sendToChannel(ch, 21);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 261:
    case 265:
      switch (pkt) {
        case 8:
          {
            state = buf.getUint8(1) & 0x01;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: state
            });
            bp.sendToChannel(ch, 90);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 260:
    case 264:
      switch (pkt) {
        case 84:
          {
            current = buf.getInt32(1) / (1 << 24);
            if (current < 0.0005) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'd',
                value: ErrorEventCode.OUT_OF_RANGE
              });
              bp.set({
                name: '1',
                type: 's',
                value: 'Sensor value is ouside the valid range for this sensor.'
              });
              ch.sendErrorEvent(bp);
              break;
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(current, 5)
            });
            bp.sendToChannel(ch, 8);
            break;
          }
        case 85:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 259:
    case 263:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getInt32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 8)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDAQ1400_120(ch, bp) {
  await sendDAQ1400(ch, bp);
}
function recvDAQ1400_120(ch, buf) {
  recvDAQ1400(ch, buf);
}
async function sendDAQ1400_130(ch, bp) {
  await sendDAQ1400(ch, bp);
}
function recvDAQ1400_130(ch, buf) {
  recvDAQ1400(ch, buf);
}
async function sendDAQ1500(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 271:
      switch (bp.vpkt) {
        case 56:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(30, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * 0x80000000);
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer));
          break;
        case 45:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(29, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDAQ1500(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 271:
      switch (pkt) {
        case 27:
          {
            const voltageratio = buf.getInt32(1) / (0x80000000 - 1.0);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: voltageratio
            });
            bp.sendToChannel(ch, 102);
            break;
          }
        case 151:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVCP1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 272:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * 0x00010000);
          await ch.sendVINTDataPacket(83, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVCP1100(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 272:
      switch (pkt) {
        case 84:
          {
            const current = buf.getInt32(1) / 65536;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: current
            });
            bp.sendToChannel(ch, 8);
            break;
          }
        case 85:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 277:
    case 282:
    case 288:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * (4095 / 3.3) * 0.045);
          await ch.sendVINTDataPacket(83, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 276:
    case 281:
    case 287:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 256);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 275:
    case 280:
    case 286:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 79:
          if (!supportedVoltageRatioSensorType(ch, bp.getNumber(0))) {
            throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          }
          break;
        case 122:
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 274:
    case 279:
    case 285:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 65:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 273:
    case 278:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setInt32(0, bp.getNumber(0) * 0.045 * 4095 / 3.3 + 2048);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 58:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(94, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 119:
          buf.setUint32(0, (bp.getNumber(0) - 1) * 1804.070707 + 897);
          await ch.sendVINTDataPacket(102, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 284:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setInt32(0, bp.getNumber(0) * 0.045 * 4095 / 3.3 + 2048);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 58:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(94, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 119:
          buf.setUint32(0, (bp.getNumber(0) - 1) * 1804.070707 + 897);
          await ch.sendVINTDataPacket(102, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 283:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setInt32(0, bp.getNumber(0) * 0.045 * 4095 / 3.3 + 2048);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 119:
          buf.setUint32(0, (bp.getNumber(0) - 1) * 1804.070707 + 897);
          await ch.sendVINTDataPacket(102, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 58:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(94, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 65:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(56, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 289:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setInt32(0, bp.getNumber(0) * 0.045 * 4095 / 3.3 + 2048);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 119:
          buf.setUint32(0, (bp.getNumber(0) - 1) * 1804.070707 + 897);
          await ch.sendVINTDataPacket(102, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 58:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(94, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 65:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(56, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDCC1000(ch, buf) {
  let dutyCycle, brakingDutyCycle, sign;
  let temperature, current, voltageRatio;
  let position;
  let indexPosition;
  let timeChange;
  let indexTriggered;
  let positionChange;
  let userphid;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 277:
    case 282:
    case 288:
      switch (pkt) {
        case 84:
          {
            current = (buf.getUint16(1) - 2048) * 0.017908017;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(current, 4)
            });
            bp.sendToChannel(ch, 8);
            break;
          }
        case 85:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 276:
    case 281:
    case 287:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(temperature, 2)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 275:
    case 280:
    case 286:
      switch (pkt) {
        case 27:
          {
            voltageRatio = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltageRatio, 5)
            });
            bp.sendToChannel(ch, 102);
            break;
          }
        case 28:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 274:
    case 279:
    case 285:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getUint32(5) * 1000 / 48;
            indexTriggered = buf.getUint8(9);
            if (indexTriggered) {
              indexPosition = buf.getUint32(10);
            } else {
              indexPosition = 0;
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: positionChange
            });
            bp.set({
              name: '1',
              type: 'g',
              value: timeChange / 1000000.0
            });
            bp.set({
              name: '2',
              type: 'c',
              value: indexTriggered
            });
            bp.set({
              name: '3',
              type: 'd',
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 273:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getUint16(3) / 65535;
            sign = buf.getUint8(6) ? -1 : 1;
            dutyCycle = buf.getUint16(1) / 65535 * sign;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 278:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5) / 940;
            dutyCycle = buf.getInt32(1) / 940;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 284:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5) / 940;
            dutyCycle = buf.getInt32(1) / 940;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 283:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 289:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1000_POSITIONCONTROL(ch, bp) {
  await sendDCC1000(ch, bp);
}
function recvDCC1000_POSITIONCONTROL(ch, buf) {
  recvDCC1000(ch, buf);
}
async function sendDCC1000_POSITIONCONTROL_FAILSAFE(ch, bp) {
  await sendDCC1000(ch, bp);
}
function recvDCC1000_POSITIONCONTROL_FAILSAFE(ch, buf) {
  recvDCC1000(ch, buf);
}
async function sendDCC1020(ch, bp) {
  var _a, _b, _c, _d, _e, _f, _g;
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 291:
    case 298:
      switch (bp.vpkt) {
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 194:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 184:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(103, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 186:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(104, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 193:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(112, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 192:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(105, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 290:
    case 297:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_b = ch.parent.parent) === null || _b === void 0 ? void 0 : _b._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 292:
    case 299:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_c = ch.parent.parent) === null || _c === void 0 ? void 0 : _c._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 256.0);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 293:
    case 300:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_d = ch.parent.parent) === null || _d === void 0 ? void 0 : _d._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          {
            const currentModifier = 0.0132;
            const changetrigger = Math.ceil(4095 / 3.3 * currentModifier * bp.getNumber(0));
            buf.setUint16(0, changetrigger);
            await ch.sendVINTDataPacket(83, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 294:
    case 301:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_e = ch.parent.parent) === null || _e === void 0 ? void 0 : _e._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 295:
    case 302:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          SetBigInt64(buf, 0, bp.getNumber(0));
          await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
          break;
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 194:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          {
            const dataInterval = (_f = ch.parent.parent) === null || _f === void 0 ? void 0 : _f._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 184:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(103, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 189:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(60, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 193:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(112, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 192:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(105, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 296:
    case 303:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 194:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          {
            const dataInterval = (_g = ch.parent.parent) === null || _g === void 0 ? void 0 : _g._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 184:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(103, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 191:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(60, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 193:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(112, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 192:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(105, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function handleDCC10X0_Error(ch, code, subCode) {
  const bp = new BridgePacket();
  switch (code) {
    case 1:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.FAILSAFE_CONDITION
      });
      bp.set({
        name: "1",
        type: "s",
        value: "Failsafe procedure initiated."
      });
      break;
    case 2:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.ESTOP
      });
      bp.set({
        name: "1",
        type: "s",
        value: "External stop procedure initiated."
      });
      break;
    case 3:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.BAD_CONNECTION_CONDITION
      });
      switch (subCode) {
        case 1:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Suspected short circuit. Fix connection and re-open controller to try again."
          });
          break;
        case 2:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Probable open circuit or purely resistive load. Fix connection and re-open controller to try again."
          });
          break;
        case 3:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Inductance measured too high for the controller. Fix connection and re-open controller to try again."
          });
          break;
        case 4:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Inductance measured too low for the controller. Close the Motor Controller and re-open to try again."
          });
          break;
        case 5:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Verify motor is not moving and re-open controller to try again."
          });
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error sub-code.");
      }
      break;
    case 4:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.ENERGY_DUMP_CONDITION
      });
      bp.set({
        name: "1",
        type: "s",
        value: "Motor Controller forced to save itself from excess regenerative power.  We recommend adding an appropriate Powerguard Phidget to your application."
      });
      break;
    case 5:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.OVER_TEMPERATURE
      });
      bp.set({
        name: "1",
        type: "s",
        value: "Motor Controller is experiencing an overtemperature condition.  Consider adding better airflow to your system."
      });
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error code.");
  }
  ch.sendErrorEvent(bp);
}
function recvDCC1020(ch, buf) {
  let temperature, voltage, current, dutyCycle, brakingDutyCycle;
  let currentLimit, surgeCurrentLimit, activeCurrentLimit;
  let inductance;
  let position, expectedPosition;
  let velocity, expectedVelocity;
  let interval;
  let positionChange, timeChange, indexTriggered, indexPosition;
  let sendInd, sendExpected;
  let dataOffset;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 291:
    case 298:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = RoundDouble(buf.getFloat32(5, true), 3);
            dutyCycle = RoundDouble(buf.getFloat32(1, true), 3);
            activeCurrentLimit = RoundDouble(buf.getFloat32(9, true), 1);
            sendInd = buf.byteLength > 13;
            if (sendInd) {
              inductance = RoundDouble(buf.getFloat32(13, true), 9);
            } else {
              inductance = 1e+300;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: activeCurrentLimit
            });
            bp.sendToChannel(ch, 197);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: brakingDutyCycle
            });
            bp.sendToChannel(ch, 121);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: dutyCycle
            });
            bp.sendToChannel(ch, 16);
            if (sendInd) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: inductance
              });
              bp.sendToChannel(ch, 185);
            }
          }
          break;
        case 93:
          handleDCC10X0_Error(ch, buf.getUint8(1), buf.byteLength > 2 ? buf.getUint8(2) : undefined);
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        case 114:
          currentLimit = buf.getFloat32(1, true);
          surgeCurrentLimit = buf.getFloat32(5, true);
          if (currentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: currentLimit
            });
            bp.sendToChannel(ch, 196);
          }
          if (surgeCurrentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: surgeCurrentLimit
            });
            bp.sendToChannel(ch, 195);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 290:
    case 297:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getInt32(5) * 1000 / 64;
            indexTriggered = buf.getUint8(9);
            indexPosition = indexTriggered === 1 ? buf.getInt32(10) : 0;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: positionChange
            });
            bp.set({
              name: "1",
              type: "g",
              value: timeChange / 1000000
            });
            bp.set({
              name: "2",
              type: "c",
              value: indexTriggered
            });
            bp.set({
              name: "3",
              type: "d",
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 294:
    case 301:
      switch (pkt) {
        case 17:
          voltage = RoundDouble(buf.getFloat32(1, true), 2);
          if (buf.byteLength > 5) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Source voltage is above the measurement range range"
            });
            ch.sendErrorEvent(bp);
          }
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: voltage
            });
            bp.sendToChannel(ch, 101);
          }
          break;
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Source voltage is above the measurement range range"
            });
            ch.sendErrorEvent(bp);
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 292:
    case 299:
      switch (pkt) {
        case 59:
          temperature = RoundDouble(buf.getInt32(1) / (1 << 16), 2);
          if (buf.byteLength > 5) {
            switch (buf.getUint8(5)) {
              case 1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature reading is above the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              case -1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature reading is below the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
            }
          }
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: temperature
            });
            bp.sendToChannel(ch, 95);
          }
          break;
        case 60:
          switch (buf.getUint8(1)) {
            case 1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Temperature reading is above the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            case -1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Temperature reading is below the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            default:
              throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 293:
    case 300:
      switch (pkt) {
        case 84:
          current = RoundDouble(buf.getFloat32(1, true), 4);
          if (buf.byteLength > 5) {
            switch (buf.getUint8(5)) {
              case 1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Current reading is above the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              case -1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Current reading is below the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
            }
          }
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: current
            });
            bp.sendToChannel(ch, 8);
          }
          break;
        case 85:
          switch (buf.getUint8(1)) {
            case 1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Current reading is above the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            case -1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Current reading is below the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            default:
              throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 295:
    case 302:
      switch (pkt) {
        case 53:
          {
            dataOffset = 0;
            dutyCycle = RoundDouble(buf.getFloat32(1, true), 3);
            position = GetBigInt64(buf, 5);
            activeCurrentLimit = RoundDouble(buf.getFloat32(13, true), 1);
            sendExpected = buf.byteLength === 25 || buf.byteLength === 29;
            if (sendExpected) {
              expectedPosition = GetBigInt64(buf, 17 + dataOffset);
              dataOffset += 8;
            } else {
              expectedPosition = 9223372036854776000;
            }
            sendInd = buf.byteLength === 21 || buf.byteLength === 29;
            if (sendInd) {
              inductance = RoundDouble(buf.getFloat32(17 + dataOffset, true), 9);
              dataOffset += 4;
            } else {
              inductance = 1e+300;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: activeCurrentLimit
            });
            bp.sendToChannel(ch, 197);
            if (sendExpected) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "l",
                value: expectedPosition
              });
              bp.sendToChannel(ch, 188);
            }
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: dutyCycle
            });
            bp.sendToChannel(ch, 16);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "l",
              value: position
            });
            bp.sendToChannel(ch, 29);
            if (sendInd) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: inductance
              });
              bp.sendToChannel(ch, 185);
            }
          }
          break;
        case 93:
          handleDCC10X0_Error(ch, buf.getUint8(1), buf.byteLength > 2 ? buf.getUint8(2) : undefined);
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        case 114:
          currentLimit = buf.getFloat32(1, true);
          surgeCurrentLimit = buf.getFloat32(5, true);
          if (currentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: currentLimit
            });
            bp.sendToChannel(ch, 196);
          }
          if (surgeCurrentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: surgeCurrentLimit
            });
            bp.sendToChannel(ch, 195);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 296:
    case 303:
      switch (pkt) {
        case 53:
          {
            dataOffset = 0;
            dutyCycle = RoundDouble(buf.getFloat32(1, true), 3);
            velocity = RoundDouble(buf.getFloat32(5, true), 3);
            activeCurrentLimit = RoundDouble(buf.getFloat32(9, true), 1);
            if (buf.byteLength > 13) {
              sendExpected = (buf.getUint8(13) & 1) !== 0;
              sendInd = (buf.getUint8(13) & 2) !== 0;
              dataOffset++;
            } else {
              sendInd = false;
              sendExpected = false;
            }
            if (sendExpected) {
              expectedVelocity = buf.getFloat32(13 + dataOffset, true);
              dataOffset += 4;
            } else {
              expectedVelocity = 1e+300;
            }
            if (sendInd) {
              inductance = RoundDouble(buf.getFloat32(13 + dataOffset, true), 9);
              dataOffset += 4;
            } else {
              inductance = 1e+300;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: activeCurrentLimit
            });
            bp.sendToChannel(ch, 197);
            if (sendExpected) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: expectedVelocity
              });
              bp.sendToChannel(ch, 190);
            }
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: dutyCycle
            });
            bp.sendToChannel(ch, 16);
            if (sendInd) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: inductance
              });
              bp.sendToChannel(ch, 185);
            }
          }
          break;
        case 93:
          handleDCC10X0_Error(ch, buf.getUint8(1), buf.byteLength > 2 ? buf.getUint8(2) : undefined);
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        case 114:
          currentLimit = buf.getFloat32(1, true);
          surgeCurrentLimit = buf.getFloat32(5, true);
          if (currentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: currentLimit
            });
            bp.sendToChannel(ch, 196);
          }
          if (surgeCurrentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: surgeCurrentLimit
            });
            bp.sendToChannel(ch, 195);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 305:
    case 308:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 65:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 304:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 307:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 306:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 309:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDCC1001(ch, buf) {
  let dutyCycle, brakingDutyCycle;
  let indexPosition;
  let timeChange;
  let position;
  let indexTriggered;
  let positionChange;
  let userphid;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 305:
    case 308:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getUint32(5) * 1000 / 48;
            indexTriggered = buf.getUint8(9);
            if (indexTriggered) {
              indexPosition = buf.getUint32(10);
            } else {
              indexPosition = 0;
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: positionChange
            });
            bp.set({
              name: '1',
              type: 'g',
              value: timeChange / 1000000.0
            });
            bp.set({
              name: '2',
              type: 'c',
              value: indexTriggered
            });
            bp.set({
              name: '3',
              type: 'd',
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 304:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5) / 940;
            dutyCycle = buf.getInt32(1) / 940;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 307:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5) / 940;
            dutyCycle = buf.getInt32(1) / 940;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 306:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 309:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1001_Failsafe(ch, bp) {
  await sendDCC1001(ch, bp);
}
function recvDCC1001_Failsafe(ch, buf) {
  recvDCC1001(ch, buf);
}
async function sendDCC1002(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 311:
    case 314:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 65:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 310:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 313:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 312:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 315:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDCC1002(ch, buf) {
  let dutyCycle, brakingDutyCycle;
  let indexPosition;
  let timeChange;
  let position;
  let indexTriggered;
  let positionChange;
  let userphid;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 311:
    case 314:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getUint32(5) * 1000 / 48;
            indexTriggered = buf.getUint8(9);
            if (indexTriggered) {
              indexPosition = buf.getUint32(10);
            } else {
              indexPosition = 0;
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: positionChange
            });
            bp.set({
              name: '1',
              type: 'g',
              value: timeChange / 1000000.0
            });
            bp.set({
              name: '2',
              type: 'c',
              value: indexTriggered
            });
            bp.set({
              name: '3',
              type: 'd',
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 310:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5) / 940;
            dutyCycle = buf.getInt32(1) / 940;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 313:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5) / 940;
            dutyCycle = buf.getInt32(1) / 940;
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 312:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 315:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1002_Failsafe(ch, bp) {
  await sendDCC1002(ch, bp);
}
function recvDCC1002_Failsafe(ch, buf) {
  recvDCC1002(ch, buf);
}
async function sendDCC1003(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 316:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer));
          break;
        case 44:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 317:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer));
          break;
        case 44:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDCC1003(ch, buf) {
  let dutyCycle, brakingDutyCycle;
  const pkt = buf.getUint8(0);
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 316:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5);
            brakingDutyCycle = brakingDutyCycle / 959.0;
            dutyCycle = buf.getInt32(1);
            dutyCycle = dutyCycle / 959.0;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 317:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = buf.getInt32(5);
            brakingDutyCycle = brakingDutyCycle / 959.0;
            dutyCycle = buf.getInt32(1);
            dutyCycle = dutyCycle / 959.0;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Failsafe procedure initiated."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1003_Failsafe(ch, bp) {
  await sendDCC1003(ch, bp);
}
function recvDCC1003_Failsafe(ch, buf) {
  recvDCC1003(ch, buf);
}
async function sendDCC1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 320:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(54, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(55, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(36, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 141:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 323:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
            break;
          }
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(54, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(55, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(36, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 141:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 319:
    case 322:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 256);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 318:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(35, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(34, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(36, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setInt32(0, bp.getNumber(0) * 0.045 * 4095 / 3.3 + 2048);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 141:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(37, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 321:
      switch (bp.vpkt) {
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 8192);
          await ch.sendVINTDataPacket(35, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setInt32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(34, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setUint32(0, bp.getNumber(0) * 2097151);
          await ch.sendVINTDataPacket(36, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setInt32(0, bp.getNumber(0) * 0.045 * 4095 / 3.3 + 2048);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 141:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(37, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDCC1100(ch, buf) {
  let temperature, dutyCycle, brakingDutyCycle;
  let position;
  let userphid;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 319:
    case 322:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(temperature, 2)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 318:
      switch (pkt) {
        case 32:
          {
            dutyCycle = buf.getInt32(1) / 940;
            brakingDutyCycle = buf.getInt32(5) / 940;
            position = GetBigInt64(buf, 9);
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 38:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.MOTOR_STALL_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Dangerous motor stall detected. Velocity has been reduced in order to prevent damage.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 321:
      switch (pkt) {
        case 32:
          {
            dutyCycle = buf.getInt32(1) / 940;
            brakingDutyCycle = buf.getInt32(5) / 940;
            position = GetBigInt64(buf, 9);
            userphid = ch.userphid;
            if (userphid.data.brakingStrength !== brakingDutyCycle) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'g',
                value: RoundDouble(brakingDutyCycle, 3)
              });
              bp.sendToChannel(ch, 121);
            }
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 38:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.MOTOR_STALL_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Dangerous motor stall detected. Velocity has been reduced in order to prevent damage.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 320:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 38:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.MOTOR_STALL_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Dangerous motor stall detected. Velocity has been reduced in order to prevent damage.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 323:
      switch (pkt) {
        case 53:
          {
            dutyCycle = buf.getInt32(1) / 940;
            position = GetBigInt64(buf, 5);
            userphid = ch.userphid;
            if (userphid.data.position !== position) {
              const bp = new BridgePacket();
              bp.set({
                name: '0',
                type: 'l',
                value: position
              });
              bp.sendToChannel(ch, 29);
            }
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(dutyCycle, 3)
            });
            bp.sendToChannel(ch, 16);
            break;
          }
        case 38:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.MOTOR_STALL_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Dangerous motor stall detected. Velocity has been reduced in order to prevent damage.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDCC1100_Failsafe(ch, bp) {
  await sendDCC1100(ch, bp);
}
function recvDCC1100_Failsafe(ch, buf) {
  recvDCC1100(ch, buf);
}
async function sendDCC1120(ch, bp) {
  var _a, _b, _c, _d, _e, _f, _g;
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 328:
    case 335:
      switch (bp.vpkt) {
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 44:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(101, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 194:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 184:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(103, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 186:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(104, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 193:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(112, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 192:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(105, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 327:
    case 334:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_b = ch.parent.parent) === null || _b === void 0 ? void 0 : _b._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 329:
    case 336:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_c = ch.parent.parent) === null || _c === void 0 ? void 0 : _c._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 256.0);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 330:
    case 337:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_d = ch.parent.parent) === null || _d === void 0 ? void 0 : _d._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          {
            const currentModifier = 0.0132;
            const changetrigger = Math.ceil(4095 / 3.3 * currentModifier * bp.getNumber(0));
            buf.setUint16(0, changetrigger);
            await ch.sendVINTDataPacket(83, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 331:
    case 338:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_e = ch.parent.parent) === null || _e === void 0 ? void 0 : _e._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 332:
    case 339:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          SetBigInt64(buf, 0, bp.getNumber(0));
          await ch.sendVINTDataPacket(52, new Uint8Array(buf.buffer));
          break;
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 194:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          {
            const dataInterval = (_f = ch.parent.parent) === null || _f === void 0 ? void 0 : _f._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 184:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(103, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 187:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(39, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 189:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(60, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 193:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(112, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 192:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(105, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 333:
    case 340:
      switch (bp.vpkt) {
        case 120:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 135:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 136:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(49, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 142:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 55:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(100, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(98, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 194:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 54:
          {
            const dataInterval = (_g = ch.parent.parent) === null || _g === void 0 ? void 0 : _g._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          }
        case 57:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(57, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 184:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(103, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 187:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(39, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 191:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(60, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 193:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(112, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 192:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(105, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function handleDCC11X0_Error(ch, code, subCode) {
  const bp = new BridgePacket();
  switch (code) {
    case 1:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.FAILSAFE_CONDITION
      });
      bp.set({
        name: "1",
        type: "s",
        value: "Failsafe procedure initiated. You must close and re-open your controller"
      });
      break;
    case 2:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.ESTOP
      });
      bp.set({
        name: "1",
        type: "s",
        value: "External stop procedure initiated. You must close and re-open your controller"
      });
      break;
    case 3:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.BAD_CONNECTION_CONDITION
      });
      switch (subCode) {
        case 1:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Suspected short circuit. Fix connection and re-open controller to try again."
          });
          break;
        case 2:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Probable open circuit or purely resistive load. Fix connection and re-open controller to try again."
          });
          break;
        case 3:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Inductance measured too high for the controller. Fix connection and re-open controller to try again."
          });
          break;
        case 4:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Inductance measured too low for the controller. Close the Motor Controller and re-open to try again."
          });
          break;
        case 5:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Verify motor is not moving and re-open controller to try again."
          });
          break;
        case 6:
          bp.set({
            name: "1",
            type: "s",
            value: "Motor initialization failed. Coil mismatch. Possible open circuit or bad motor. Fix connection and re-open controller to try again."
          });
          break;
        case 7:
          bp.set({
            name: "1",
            type: "s",
            value: "Hall effect sensor error. The sensor is likely damaged or unplugged. Fix connection and re-open controller to try again."
          });
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error sub-code.");
      }
      break;
    case 4:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.ENERGY_DUMP_CONDITION
      });
      bp.set({
        name: "1",
        type: "s",
        value: "Motor Controller forced to save itself from excess regenerative power.  We recommend adding an appropriate Powerguard Phidget to your application."
      });
      break;
    case 5:
      bp.set({
        name: "0",
        type: "d",
        value: ErrorEventCode.OVER_TEMPERATURE
      });
      bp.set({
        name: "1",
        type: "s",
        value: "Motor Controller is experiencing an overtemperature condition.  Consider adding better airflow to your system."
      });
      break;
    default:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error code.");
  }
  ch.sendErrorEvent(bp);
}
function recvDCC1120(ch, buf) {
  let temperature, voltage, current, dutyCycle, brakingDutyCycle;
  let currentLimit, surgeCurrentLimit, activeCurrentLimit;
  let inductance;
  let position, expectedPosition;
  let velocity, expectedVelocity;
  let interval;
  let positionChange, timeChange, indexTriggered, indexPosition;
  let sendInd, sendExpected;
  let dataOffset;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 328:
    case 335:
      switch (pkt) {
        case 96:
          {
            brakingDutyCycle = RoundDouble(buf.getFloat32(5, true), 3);
            dutyCycle = RoundDouble(buf.getFloat32(1, true), 3);
            position = GetBigInt64(buf, 9);
            activeCurrentLimit = RoundDouble(buf.getFloat32(17, true), 1);
            sendInd = buf.byteLength > 21;
            if (sendInd) {
              inductance = RoundDouble(buf.getFloat32(21, true), 9);
            } else {
              inductance = 1e+300;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: activeCurrentLimit
            });
            bp.sendToChannel(ch, 197);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: brakingDutyCycle
            });
            bp.sendToChannel(ch, 121);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "l",
              value: position
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: dutyCycle
            });
            bp.sendToChannel(ch, 16);
            if (sendInd) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: inductance
              });
              bp.sendToChannel(ch, 185);
            }
          }
          break;
        case 93:
          handleDCC11X0_Error(ch, buf.getUint8(1), buf.byteLength > 2 ? buf.getUint8(2) : undefined);
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        case 114:
          currentLimit = buf.getFloat32(1, true);
          surgeCurrentLimit = buf.getFloat32(5, true);
          if (currentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: currentLimit
            });
            bp.sendToChannel(ch, 196);
          }
          if (surgeCurrentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: surgeCurrentLimit
            });
            bp.sendToChannel(ch, 195);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 327:
    case 334:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getInt32(5) * 1000 / 64;
            indexTriggered = buf.getUint8(9);
            indexPosition = indexTriggered === 1 ? buf.getInt32(10) : 0;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: positionChange
            });
            bp.set({
              name: "1",
              type: "g",
              value: timeChange / 1000000
            });
            bp.set({
              name: "2",
              type: "c",
              value: indexTriggered
            });
            bp.set({
              name: "3",
              type: "d",
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 331:
    case 338:
      switch (pkt) {
        case 17:
          voltage = RoundDouble(buf.getFloat32(1, true), 2);
          if (buf.byteLength > 5) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Source voltage is above the measurement range range"
            });
            ch.sendErrorEvent(bp);
          }
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: voltage
            });
            bp.sendToChannel(ch, 101);
          }
          break;
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Source voltage is above the measurement range range"
            });
            ch.sendErrorEvent(bp);
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 329:
    case 336:
      switch (pkt) {
        case 59:
          temperature = RoundDouble(buf.getInt32(1) / (1 << 16), 2);
          if (buf.byteLength > 5) {
            switch (buf.getUint8(5)) {
              case 1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature reading is above the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              case -1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature reading is below the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
            }
          }
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: temperature
            });
            bp.sendToChannel(ch, 95);
          }
          break;
        case 60:
          switch (buf.getUint8(1)) {
            case 1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Temperature reading is above the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            case -1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Temperature reading is below the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            default:
              throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 330:
    case 337:
      switch (pkt) {
        case 84:
          current = RoundDouble(buf.getFloat32(1, true), 4);
          if (buf.byteLength > 5) {
            switch (buf.getUint8(5)) {
              case 1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Current reading is above the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              case -1:
                {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Current reading is below the valid range"
                  });
                  ch.sendErrorEvent(bp);
                  break;
                }
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
            }
          }
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: current
            });
            bp.sendToChannel(ch, 8);
          }
          break;
        case 85:
          switch (buf.getUint8(1)) {
            case 1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Current reading is above the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            case -1:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Current reading is below the valid range"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            case 0:
              {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Hall sensor unplugged, current reading unknown"
                });
                ch.sendErrorEvent(bp);
                break;
              }
            default:
              throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected error event code");
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 332:
    case 339:
      switch (pkt) {
        case 53:
          {
            dataOffset = 0;
            dutyCycle = RoundDouble(buf.getFloat32(1, true), 3);
            position = GetBigInt64(buf, 5);
            activeCurrentLimit = RoundDouble(buf.getFloat32(13, true), 1);
            sendExpected = buf.byteLength === 25 || buf.byteLength === 29;
            if (sendExpected) {
              expectedPosition = GetBigInt64(buf, 17 + dataOffset);
              dataOffset += 8;
            } else {
              expectedPosition = 9223372036854776000;
            }
            sendInd = buf.byteLength === 21 || buf.byteLength === 29;
            if (sendInd) {
              inductance = RoundDouble(buf.getFloat32(17 + dataOffset, true), 9);
              dataOffset += 4;
            } else {
              inductance = 1e+300;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: activeCurrentLimit
            });
            bp.sendToChannel(ch, 197);
            if (sendExpected) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "l",
                value: expectedPosition
              });
              bp.sendToChannel(ch, 188);
            }
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: dutyCycle
            });
            bp.sendToChannel(ch, 16);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "l",
              value: position
            });
            bp.sendToChannel(ch, 29);
            if (sendInd) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: inductance
              });
              bp.sendToChannel(ch, 185);
            }
          }
          break;
        case 93:
          handleDCC11X0_Error(ch, buf.getUint8(1), buf.byteLength > 2 ? buf.getUint8(2) : undefined);
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        case 114:
          currentLimit = buf.getFloat32(1, true);
          surgeCurrentLimit = buf.getFloat32(5, true);
          if (currentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: currentLimit
            });
            bp.sendToChannel(ch, 196);
          }
          if (surgeCurrentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: surgeCurrentLimit
            });
            bp.sendToChannel(ch, 195);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 333:
    case 340:
      switch (pkt) {
        case 53:
          {
            dataOffset = 0;
            dutyCycle = RoundDouble(buf.getFloat32(1, true), 3);
            velocity = RoundDouble(buf.getFloat32(5, true), 3);
            activeCurrentLimit = RoundDouble(buf.getFloat32(9, true), 1);
            if (buf.byteLength > 13) {
              sendExpected = (buf.getUint8(13) & 1) !== 0;
              sendInd = (buf.getUint8(13) & 2) !== 0;
              dataOffset++;
            } else {
              sendInd = false;
              sendExpected = false;
            }
            if (sendExpected) {
              expectedVelocity = buf.getFloat32(13 + dataOffset, true);
              dataOffset += 4;
            } else {
              expectedVelocity = 1e+300;
            }
            if (sendInd) {
              inductance = RoundDouble(buf.getFloat32(13 + dataOffset, true), 9);
              dataOffset += 4;
            } else {
              inductance = 1e+300;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: activeCurrentLimit
            });
            bp.sendToChannel(ch, 197);
            if (sendExpected) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: expectedVelocity
              });
              bp.sendToChannel(ch, 190);
            }
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: dutyCycle
            });
            bp.sendToChannel(ch, 16);
            if (sendInd) {
              bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: inductance
              });
              bp.sendToChannel(ch, 185);
            }
          }
          break;
        case 93:
          handleDCC11X0_Error(ch, buf.getUint8(1), buf.byteLength > 2 ? buf.getUint8(2) : undefined);
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
          }
          break;
        case 114:
          currentLimit = buf.getFloat32(1, true);
          surgeCurrentLimit = buf.getFloat32(5, true);
          if (currentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: currentLimit
            });
            bp.sendToChannel(ch, 196);
          }
          if (surgeCurrentLimit > 0) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: surgeCurrentLimit
            });
            bp.sendToChannel(ch, 195);
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDST1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 341:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(149, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDST1000(ch, buf) {
  let distance;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 341:
      switch (pkt) {
        case 150:
          {
            distance = buf.getUint16(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: distance
            });
            bp.sendToChannel(ch, 12);
            break;
          }
        case 151:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Sensor value is outside the valid range for this sensor."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDST1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 342:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(149, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDST1001(ch, buf) {
  let distance;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 342:
      switch (pkt) {
        case 150:
          {
            distance = buf.getUint16(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: distance
            });
            bp.sendToChannel(ch, 12);
            break;
          }
        case 151:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Sensor value is outside the valid range for this sensor."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDST1002(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 343:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(149, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDST1002(ch, buf) {
  let distance;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 343:
      switch (pkt) {
        case 150:
          {
            distance = buf.getUint16(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: distance
            });
            bp.sendToChannel(ch, 12);
            break;
          }
        case 151:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Sensor value is outside the valid range for this sensor."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendDST1200(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 344:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(149, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 75:
          buf.setUint8(0, bp.getNumber(0) ? 1 : 0);
          await ch.sendVINTDataPacket(153, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvDST1200(ch, buf) {
  const DISTANCE_MAX_REFLECTIONS = 8;
  const reflections_distance = new Array(DISTANCE_MAX_REFLECTIONS);
  const reflections_strength = new Array(DISTANCE_MAX_REFLECTIONS);
  let reflections_count;
  let distance;
  let i;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 344:
      switch (pkt) {
        case 152:
          {
            reflections_count = buf.getUint8(1);
            for (i = 0; i < DISTANCE_MAX_REFLECTIONS; i++) {
              if (i < reflections_count) {
                reflections_distance[i] = buf.getUint16(2 * i + 2);
              } else {
                reflections_distance[i] = 4294967295;
              }
            }
            for (i = 0; i < DISTANCE_MAX_REFLECTIONS; i++) {
              if (i < reflections_count) {
                reflections_strength[i] = buf.getUint16(2 * i + 2 * reflections_count + 2);
                if (reflections_strength[i] === 0x7FFF) {
                  reflections_strength[i] = 4294967295;
                }
              } else {
                reflections_strength[i] = 4294967295;
              }
            }
            if (reflections_count === 0) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "U",
                value: reflections_distance
              });
              bp.set({
                name: "1",
                type: "U",
                value: reflections_strength
              });
              bp.set({
                name: "2",
                type: "u",
                value: reflections_count
              });
              bp.sendToChannel(ch, 88);
              break;
            }
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "U",
              value: reflections_distance
            });
            bp.set({
              name: "1",
              type: "U",
              value: reflections_strength
            });
            bp.set({
              name: "2",
              type: "u",
              value: reflections_count
            });
            bp.sendToChannel(ch, 88);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: reflections_distance[0]
            });
            bp.sendToChannel(ch, 12);
            break;
          }
        case 150:
          {
            distance = buf.getUint32(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: distance
            });
            bp.sendToChannel(ch, 12);
            break;
          }
        case 151:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendENC1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 345:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer));
          break;
        case 65:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvENC1000(ch, buf) {
  let indexPosition;
  let indexTriggered;
  let positionChange;
  let timeChange;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 345:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getUint32(5) * 1000 / 16;
            indexTriggered = buf.getUint8(9);
            if (indexTriggered) {
              indexPosition = buf.getInt32(10);
            } else {
              indexPosition = 0;
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: positionChange
            });
            bp.set({
              name: "1",
              type: "g",
              value: timeChange / 1000000.0
            });
            bp.set({
              name: "2",
              type: "c",
              value: indexTriggered
            });
            bp.set({
              name: "3",
              type: "d",
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendENC1001(ch, bp) {
  var _a;
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 346:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer));
          break;
        case 56:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvENC1001(ch, buf) {
  let indexPosition;
  let indexTriggered;
  let positionChange;
  let timeChange;
  let interval;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 346:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getUint32(5) * 1000 / 64;
            indexTriggered = buf.getUint8(9);
            if (indexTriggered) {
              indexPosition = buf.getInt32(10);
            } else {
              indexPosition = 0;
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: positionChange
            });
            bp.set({
              name: "1",
              type: "g",
              value: timeChange / 1000000.0
            });
            bp.set({
              name: "2",
              type: "c",
              value: indexTriggered
            });
            bp.set({
              name: "3",
              type: "d",
              value: indexPosition
            });
            bp.sendToChannel(ch, 29);
          }
          break;
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHIN1101(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 347:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(48, new Uint8Array(buf.buffer));
          break;
        case 65:
          buf.setInt32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(50, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 56:
          buf.setInt8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(51, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHIN1101(ch, buf) {
  let positionChange;
  let timeChange;
  let state;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 347:
      switch (pkt) {
        case 49:
          {
            positionChange = buf.getInt32(1);
            timeChange = buf.getInt32(5) * 1000 / 16;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: positionChange
            });
            bp.set({
              name: "1",
              type: "g",
              value: timeChange / 1000000.0
            });
            bp.set({
              name: "2",
              type: "c",
              value: 0
            });
            bp.set({
              name: "3",
              type: "d",
              value: 0
            });
            bp.sendToChannel(ch, 29);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 348:
      switch (pkt) {
        case 8:
          {
            state = buf.getUint8(1) & 0x01;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: state
            });
            bp.sendToChannel(ch, 90);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHIN1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 349:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          break;
        case 66:
          buf.setUint8(0, (1 - bp.getNumber(0)) * 80 + 20);
          await ch.sendVINTDataPacket(54, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHIN1000(ch, buf) {
  let touched;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 349:
      switch (pkt) {
        case 53:
          {
            touched = buf.getUint8(1) ? 1 : 0;
            const bp = new BridgePacket();
            if (touched) {
              bp.set({
                name: "0",
                type: "g",
                value: touched
              });
              bp.sendToChannel(ch, 96);
            } else {
              bp.sendToChannel(ch, 137);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHIN1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 350:
    case 351:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(55, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 66:
          if (ch.index === 4) {
            buf.setUint8(0, (1 - bp.getNumber(0)) * 32 + 1);
          } else {
            buf.setUint8(0, (1 - bp.getNumber(0)) * 64 + 1);
          }
          await ch.sendVINTDataPacket(54, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHIN1001(ch, buf) {
  let value;
  let touched;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 350:
    case 351:
      switch (pkt) {
        case 53:
          {
            touched = buf.getUint8(1) ? 1 : 0;
            if (ch.index < 4) {
              value = touched;
            } else {
              value = buf.getUint16(2) / 65536.0;
            }
            const bp = new BridgePacket();
            if (touched) {
              bp.set({
                name: "0",
                type: "g",
                value: value
              });
              bp.sendToChannel(ch, 96);
            } else {
              bp.sendToChannel(ch, 137);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHIN1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 352:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 16384);
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHIN1100(ch, buf) {
  let axis;
  let value;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 352:
      switch (pkt) {
        case 27:
          {
            axis = RoundDouble(buf.getInt16(1) / 16384, 4);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: axis
            });
            bp.sendToChannel(ch, 102);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 353:
      switch (pkt) {
        case 8:
          {
            value = buf.getUint8(1) ? 1 : 0;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: value
            });
            bp.sendToChannel(ch, 90);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHUM1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 355:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 354:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(68, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHUM1000(ch, buf) {
  let temperature;
  let humidity;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 355:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 2)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 354:
      switch (pkt) {
        case 69:
          {
            humidity = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(humidity, 2)
            });
            bp.sendToChannel(ch, 22);
            break;
          }
        case 70:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHUM1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 356:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(68, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 357:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHUM1001(ch, buf) {
  let temperature;
  let humidity;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 356:
      switch (pkt) {
        case 69:
          {
            humidity = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(humidity, 2)
            });
            bp.sendToChannel(ch, 22);
            break;
          }
        case 70:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 357:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 2)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendLCD1100_WRITETEXT(ch, bp) {
  const buf = new DataView(new ArrayBuffer(48));
  const userphid = ch.userphid;
  const font = bp.getNumber(0);
  let xpos = bp.getNumber(1);
  const ypos = bp.getNumber(2);
  const chars = bp.getString(3);
  const fontSize = userphid.getFontSize(font);
  const frameBuffer = userphid.data.frameBuffer;
  const width = userphid.data.width;
  const height = userphid.data.height;
  let numchars = chars.length;
  if (font == frameBuffer) {
    throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid font/framebuffer combination.");
  }
  numchars = Math.min(width - xpos, fontSize.width * numchars) / fontSize.width;
  if (ypos + fontSize.height > height) {
    numchars = 0;
  }
  if (numchars === 0) {
    return;
  }
  let numsent = 0;
  while (numsent < numchars) {
    const count = Math.min(VINT_MAX_OUT_PACKETSIZE - 6, numchars - numsent);
    buf.setUint8(0, font);
    buf.setUint8(1, fontSize.width);
    buf.setUint8(2, fontSize.height);
    buf.setUint8(3, xpos);
    buf.setUint8(4, ypos);
    buf.setUint8(5, count);
    for (let i = 0; i < count; i++) buf.setUint8(i + 6, chars.charCodeAt(numsent++));
    xpos += count * fontSize.width;
    await ch.sendVINTDataPacket(37, new Uint8Array(buf.buffer, 0, count + 6));
  }
}
async function sendLCD1100_WRITEBITMAP(ch, bp) {
  let buf = new DataView(new ArrayBuffer(48));
  let count = 0;
  const bitmap = bp.getArray(4);
  const xsize = bp.getNumber(2);
  const ysize = bp.getNumber(3);
  buf.setUint8(0, bp.getNumber(0));
  buf.setUint8(1, bp.getNumber(1));
  buf.setUint8(2, xsize);
  buf.setUint8(3, ysize);
  await ch.sendVINTDataPacket(38, new Uint8Array(buf.buffer, 0, 4));
  let x = 0;
  let y = 0;
  while (x < xsize) {
    buf = new DataView(new ArrayBuffer(48));
    for (let i = 0; i < VINT_MAX_OUT_PACKETSIZE * 8 && x < xsize; i++) {
      const byteIdx = Math.floor(i / 8);
      count = byteIdx + 1;
      const bit = 1 << 7 - i % 8 & (bitmap[y * xsize + x] ? 0xFF : 0x00);
      const newbyte = buf.getUint8(byteIdx) | bit;
      buf.setUint8(byteIdx, newbyte);
      y++;
      if (y >= ysize) {
        x++;
        y = 0;
      }
    }
    await ch.sendVINTDataPacket(39, new Uint8Array(buf.buffer, 0, count));
  }
}
async function sendLCD1100_SETCHARACTERBITMAP(ch, bp) {
  const userphid = ch.userphid;
  const font = bp.getNumber(0);
  const characterStr = bp.getString(1);
  const bitmap = bp.getArray(2);
  if (font != LCDFont.USER1 && font != LCDFont.USER2) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Font must be user font 1 or 2.");
  const frameBuffer = userphid.frameBuffer;
  const maxchars = userphid.getMaxCharacters(font);
  const fontSize = userphid.getFontSize(font);
  const lcdw = userphid.width;
  if (characterStr.length != 1) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Multibyte characters are unsupported.");
  let character = characterStr.charCodeAt(0);
  character -= 1;
  if (character < 0 || character > maxchars) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Character code must be between 0x00 and 0x" + maxchars.toString(16) + " ('" + String.fromCharCode(maxchars) + "'). Number of supported characters depends on the font size.");
  if (frameBuffer != font) {
    const buf = new DataView(new ArrayBuffer(1));
    buf.setUint8(0, font);
    await ch.sendVINTDataPacket(43, new Uint8Array(buf.buffer, 0, 1));
  }
  const buf = new DataView(new ArrayBuffer(4));
  buf.setUint8(0, fontSize.width * (character % Math.floor(lcdw / fontSize.width)));
  buf.setUint8(1, fontSize.height * Math.floor(character / Math.floor(lcdw / fontSize.width)));
  buf.setUint8(2, fontSize.width);
  buf.setUint8(3, fontSize.height);
  await ch.sendVINTDataPacket(38, new Uint8Array(buf.buffer, 0, 4));
  let x = 0;
  let y = 0;
  while (x < fontSize.width) {
    const buf = new DataView(new ArrayBuffer(VINT_MAX_OUT_PACKETSIZE));
    let count;
    for (let i = 0; i < VINT_MAX_OUT_PACKETSIZE * 8 && x < fontSize.width; i++) {
      const byteIdx = Math.floor(i / 8);
      count = byteIdx + 1;
      const bit = 1 << 7 - i % 8 & (bitmap[y * fontSize.width + x] ? 0xFF : 0x00);
      const newbyte = buf.getUint8(byteIdx) | bit;
      buf.setUint8(byteIdx, newbyte);
      y++;
      if (y >= fontSize.height) {
        x++;
        y = 0;
      }
    }
    await ch.sendVINTDataPacket(39, new Uint8Array(buf.buffer, 0, count));
  }
  if (frameBuffer != font) {
    const buf = new DataView(new ArrayBuffer(1));
    buf.setUint8(0, frameBuffer);
    await ch.sendVINTDataPacket(43, new Uint8Array(buf.buffer, 0, 1));
  }
}
async function sendLCD1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(48));
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 358:
    case 359:
      await userphid._transactionLock.acquire();
      try {
        switch (bp.vpkt) {
          case 38:
            {
              const fb = bp.getNumber(0);
              if (fb < 0 || fb > 2) {
                throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Framebuffer must be 0, 1 or 2.");
              }
              buf.setUint8(0, fb);
              await ch.sendVINTDataPacket(44, new Uint8Array(buf.buffer, 0, 1));
              break;
            }
          case 62:
            buf.setUint8(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(43, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 43:
            if (bp.getNumber(0) >= 1) {
              buf.setUint8(0, 0xFF);
            } else {
              buf.setUint8(0, bp.getNumber(0) * (1 << 8));
            }
            await ch.sendVINTDataPacket(32, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 48:
            if (bp.getNumber(0) >= 1) {
              buf.setUint8(0, 0xFF);
            } else {
              buf.setUint8(0, bp.getNumber(0) * (1 << 8));
            }
            await ch.sendVINTDataPacket(33, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 14:
            buf.setUint8(0, bp.getNumber(0));
            buf.setUint8(1, bp.getNumber(1));
            buf.setUint8(2, bp.getNumber(2));
            await ch.sendVINTDataPacket(34, new Uint8Array(buf.buffer, 0, 3));
            break;
          case 13:
            buf.setUint8(0, bp.getNumber(0));
            buf.setUint8(1, bp.getNumber(1));
            buf.setUint8(2, bp.getNumber(2));
            buf.setUint8(3, bp.getNumber(3));
            await ch.sendVINTDataPacket(35, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 15:
            buf.setUint8(0, bp.getNumber(0));
            buf.setUint8(1, bp.getNumber(1));
            buf.setUint8(2, bp.getNumber(2));
            buf.setUint8(3, bp.getNumber(3));
            buf.setUint8(4, bp.getNumber(4) ? 0xFF : 0x00);
            buf.setUint8(5, bp.getNumber(5) ? 0xFF : 0x00);
            await ch.sendVINTDataPacket(36, new Uint8Array(buf.buffer, 0, 6));
            break;
          case 105:
            await sendLCD1100_WRITETEXT(ch, bp);
            break;
          case 104:
            await sendLCD1100_WRITEBITMAP(ch, bp);
            break;
          case 19:
            await ch.sendVINTDataPacket(40);
            break;
          case 4:
            await ch.sendVINTDataPacket(41);
            break;
          case 80:
            buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
            await ch.sendVINTDataPacket(42, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 47:
            await sendLCD1100_SETCHARACTERBITMAP(ch, bp);
            break;
          case 6:
            buf.setUint8(0, bp.getNumber(0));
            buf.setUint8(1, bp.getNumber(1));
            buf.setUint8(2, bp.getNumber(2));
            buf.setUint8(3, bp.getNumber(3));
            buf.setUint8(4, bp.getNumber(4));
            buf.setUint8(5, bp.getNumber(5));
            buf.setUint8(6, bp.getNumber(6));
            buf.setUint8(7, bp.getNumber(7));
            buf.setUint8(8, bp.getNumber(8) ? 0xFF : 0x00);
            await ch.sendVINTDataPacket(45, new Uint8Array(buf.buffer, 0, 9));
            break;
          case 24:
            await ch.sendVINTDataPacket(47);
            break;
          case 61:
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
        break;
      } finally {
        userphid._transactionLock.release();
      }
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendLCD1100_1(ch, bp) {
  await sendLCD1100(ch, bp);
}
function recvLCD1100() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
}
function recvLCD1100_1() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
}
async function sendLED1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 360:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 68:
          buf.setUint8(0, bp.getNumber(0));
          switch (buf.getUint8(0)) {
            case LEDForwardVoltage.VOLTS_3_2:
            case LEDForwardVoltage.VOLTS_4_0:
            case LEDForwardVoltage.VOLTS_4_8:
            case LEDForwardVoltage.VOLTS_5_6:
              await ch.sendVINTDataPacket(12, new Uint8Array(buf.buffer, 0, 1));
              break;
            default:
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid or unsupported voltage for this device.");
          }
          break;
        case 67:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(11, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvLED1000() {
  throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
}
async function sendLUX1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 361:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 14));
          await ch.sendVINTDataPacket(80, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvLUX1000(ch, buf) {
  let illuminance;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 361:
      switch (pkt) {
        case 81:
          {
            illuminance = buf.getInt32(1) / (1 << 14);
            illuminance = illuminance < 100 ? RoundDouble(illuminance, 4) : RoundDouble(illuminance, 2);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: illuminance
            });
            bp.sendToChannel(ch, 23);
            break;
          }
        case 82:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendHUM1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 362:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint16(0, bp.getNumber(0) * 0xFFFF);
          await ch.sendVINTDataPacket(26, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvHUM1100(ch, buf) {
  let value;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 362:
      switch (pkt) {
        case 27:
          {
            value = buf.getUint16(1) / 65535.0;
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(value, 3)
            });
            bp.sendToChannel(ch, 102);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendMOT1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 363:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvMOT1100(ch, buf) {
  let timestamp;
  const acc = [0, 0, 0];
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 363:
      switch (pkt) {
        case 196:
          {
            acc[0] = buf.getInt16(1) / (1 << 12);
            acc[0] = RoundDouble(acc[0], 4);
            acc[1] = buf.getInt16(3) / (1 << 12);
            acc[1] = RoundDouble(acc[1], 4);
            acc[2] = buf.getInt16(5) / (1 << 12);
            acc[2] = RoundDouble(acc[2], 4);
            timestamp = buf.getUint32(7);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: acc
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 1);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Acceleration Saturation."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendMOT1101(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 366:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 367:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 106:
          await ch.sendVINTDataPacket(51);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 368:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer));
          break;
        case 35:
          await ch.sendVINTDataPacket(77);
          break;
        case 37:
          await ch.sendVINTDataPacket(79);
          break;
        case 50:
          await sendMOT1101_SETCORRECTIONPARAMETERS(ch, bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 369:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 106:
          await ch.sendVINTDataPacket(51);
          break;
        case 35:
          await ch.sendVINTDataPacket(77);
          break;
        case 37:
          await ch.sendVINTDataPacket(79);
          break;
        case 50:
          await sendMOT1101_SETCORRECTIONPARAMETERS(ch, bp);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvMOT1101(ch, buf) {
  let fireSaturation = 0;
  let timestamp;
  const compass = [0, 0, 0];
  const accel = [0, 0, 0];
  const gyro = [0, 0, 0];
  const pkt = buf.getUint8(0);
  let i;
  switch (ch.chDef.uid) {
    case 366:
      switch (pkt) {
        case 196:
          {
            accel[0] = RoundDouble(buf.getInt16(1) / (1 << 12), 4);
            accel[1] = RoundDouble(buf.getInt16(3) / (1 << 12), 4);
            accel[2] = RoundDouble(buf.getInt16(5) / (1 << 12), 4);
            timestamp = buf.getUint32(7);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 1);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 367:
      switch (pkt) {
        case 197:
          {
            gyro[0] = RoundDouble(buf.getFloat32(1, true), 5);
            gyro[1] = RoundDouble(buf.getFloat32(5, true), 5);
            gyro[2] = RoundDouble(buf.getFloat32(9, true), 5);
            timestamp = buf.getUint32(13);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: gyro
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 2);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 368:
      switch (pkt) {
        case 196:
          {
            compass[0] = RoundDouble(buf.getInt16(1) / (1 << 12), 4);
            compass[1] = RoundDouble(buf.getInt16(3) / (1 << 12), 4);
            compass[2] = RoundDouble(buf.getInt16(5) / (1 << 12), 4);
            timestamp = buf.getUint32(7);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: compass
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 18);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 369:
      switch (pkt) {
        case 196:
          for (i = 0; i < 3; i++) {
            if (buf.getUint8(1 + i * 2) === 0x7F && buf.getUint8(2 + i * 2) === 0xFF || buf.getUint8(1 + i * 2) === 0x80 && buf.getUint8(2 + i * 2) === 0x00) {
              fireSaturation |= 0x04;
            } else {
              compass[i] = RoundDouble(buf.getInt16(1 + i * 2) / (1 << 12), 5);
            }
          }
          for (i = 0; i < 3; i++) {
            if (buf.getUint8(7 + i * 2) === 0x7F && buf.getUint8(8 + i * 2) === 0xFF || buf.getUint8(7 + i * 2) === 0x80 && buf.getUint8(8 + i * 2) === 0x00) {
              fireSaturation |= 0x01;
            } else {
              accel[i] = RoundDouble(buf.getInt16(7 + i * 2) / (1 << 12), 5);
            }
          }
          for (i = 0; i < 3; i++) {
            const tmp = buf.getFloat32(13 + i * 4, true);
            if (tmp === 1e+30 || tmp === -1e30) {
              fireSaturation |= 0x02;
            } else {
              gyro[i] = RoundDouble(tmp, 5);
            }
          }
          if (fireSaturation === 0) {
            timestamp = buf.getUint32(25);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "G",
              value: gyro
            });
            bp.set({
              name: "2",
              type: "G",
              value: compass
            });
            bp.set({
              name: "3",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 89);
          } else {
            let saturationError = true;
            if (fireSaturation & 0x01) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Acceleration Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              saturationError = false;
            }
            if (fireSaturation & 0x02) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Gyroscope Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              saturationError = false;
            }
            if (fireSaturation & 0x04) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Magnetometer Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              saturationError = false;
            }
            if (saturationError) {
              throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected saturation flag. This is likely a firmware bug.");
            }
          }
          break;
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendMOT1101_SETCORRECTIONPARAMETERS(ch, bp) {
  const firmware_userMagnetometerTransform = [0, 0, 0, 0, 0, 0];
  const firmware_userMagnetometerOffset = [0, 0, 0];
  const firmware_userMagnetometerGain = [0, 0, 0];
  const buf = new DataView(new ArrayBuffer(28));
  const firmware_userMagField = bp.getNumber(0);
  for (let i = 0; i < 3; i++) {
    firmware_userMagnetometerOffset[i] = bp.getNumber((i + 1).toString());
    firmware_userMagnetometerGain[i] = bp.getNumber((i + 4).toString());
  }
  for (let i = 0; i < 6; i++) {
    firmware_userMagnetometerTransform[i] = bp.getNumber((i + 7).toString());
  }
  buf.setFloat32(0, firmware_userMagField, true);
  for (let i = 0; i < 3; i++) {
    buf.setFloat32(4 + i * 4, firmware_userMagnetometerOffset[i], true);
    buf.setFloat32(16 + i * 4, firmware_userMagnetometerGain[i], true);
  }
  await ch.sendVINTDataPacket(78, new Uint8Array(buf.buffer));
  for (let i = 0; i < 6; i++) {
    buf.setFloat32(i * 4, firmware_userMagnetometerTransform[i], true);
  }
  await ch.sendVINTDataPacket(78, new Uint8Array(buf.buffer, 0, 24));
}
async function sendMOT1102(ch, bp) {
  const buf = new DataView(new ArrayBuffer(24));
  let userphid;
  switch (ch.chDef.uid) {
    case 370:
    case 374:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 371:
    case 375:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 106:
          await ch.sendVINTDataPacket(51);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 372:
    case 376:
      userphid = ch.userphid;
      await userphid.transactionLock.acquire();
      try {
        switch (bp.vpkt) {
          case 54:
            buf.setUint16(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          case 46:
            buf.setFloat32(0, bp.getNumber(0), true);
            await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 35:
            await ch.sendVINTDataPacket(77);
            break;
          case 37:
            await ch.sendVINTDataPacket(79);
            break;
          case 50:
            await sendMOT1102_SETCORRECTIONPARAMETERS(ch, bp);
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
      } finally {
        userphid.transactionLock.release();
      }
      break;
    case 373:
    case 377:
      userphid = ch.userphid;
      await userphid._transactionLock.acquire();
      try {
        switch (bp.vpkt) {
          case 54:
            buf.setUint16(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            break;
          case 106:
            await ch.sendVINTDataPacket(51);
            break;
          case 35:
            await ch.sendVINTDataPacket(77);
            break;
          case 37:
            await ch.sendVINTDataPacket(79);
            break;
          case 50:
            await sendMOT1102_SETCORRECTIONPARAMETERS(ch, bp);
            break;
          case 150:
            await ch.sendVINTDataPacket(80);
            break;
          case 149:
            buf.setUint8(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(81, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 151:
            buf.setFloat32(0, bp.getNumber(0), true);
            await ch.sendVINTDataPacket(82, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 174:
            buf.setFloat32(0, bp.getNumber(0), true);
            buf.setFloat32(4, bp.getNumber(1), true);
            buf.setFloat32(8, bp.getNumber(2), true);
            buf.setFloat32(12, bp.getNumber(3), true);
            buf.setFloat32(16, bp.getNumber(4), true);
            buf.setFloat32(20, bp.getNumber(5), true);
            await ch.sendVINTDataPacket(84, new Uint8Array(buf.buffer));
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
      } finally {
        userphid._transactionLock.release();
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvMOT1102(ch, buf) {
  let fireSaturation = 0;
  let timestamp;
  const compass = [0, 0, 0];
  const accel = [0, 0, 0];
  const gyro = [0, 0, 0];
  const quaternion = [0, 0, 0, 0];
  const pkt = buf.getUint8(0);
  let i;
  switch (ch.chDef.uid) {
    case 370:
    case 374:
      switch (pkt) {
        case 196:
          {
            accel[0] = RoundDouble(buf.getInt16(1) / (1 << 12), 4);
            accel[1] = RoundDouble(buf.getInt16(3) / (1 << 12), 4);
            accel[2] = RoundDouble(buf.getInt16(5) / (1 << 12), 4);
            timestamp = buf.getUint32(7);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 1);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 371:
    case 375:
      switch (pkt) {
        case 197:
          {
            gyro[0] = RoundDouble(buf.getFloat32(1, true), 5);
            gyro[1] = RoundDouble(buf.getFloat32(5, true), 5);
            gyro[2] = RoundDouble(buf.getFloat32(9, true), 5);
            timestamp = buf.getUint32(13);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: gyro
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 2);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 199:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.INVALID_STATE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "The gyroscope has received invalid data and will recover shortly."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 372:
    case 376:
      switch (pkt) {
        case 196:
          {
            compass[0] = RoundDouble(buf.getInt16(1) / (1 << 12), 4);
            compass[1] = RoundDouble(buf.getInt16(3) / (1 << 12), 4);
            compass[2] = RoundDouble(buf.getInt16(5) / (1 << 12), 4);
            timestamp = buf.getUint32(7);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: compass
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 18);
            break;
          }
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 373:
    case 377:
      switch (pkt) {
        case 196:
          for (i = 0; i < 3; i++) {
            if (buf.getUint8(1 + i * 2) === 0x7F && buf.getUint8(2 + i * 2) === 0xFF || buf.getUint8(1 + i * 2) === 0x80 && buf.getUint8(2 + i * 2) === 0x00) {
              fireSaturation |= 0x04;
            } else {
              compass[i] = RoundDouble(buf.getInt16(1 + i * 2) / (1 << 12), 5);
            }
          }
          for (i = 0; i < 3; i++) {
            if (buf.getUint8(7 + i * 2) === 0x7F && buf.getUint8(8 + i * 2) === 0xFF || buf.getUint8(7 + i * 2) === 0x80 && buf.getUint8(8 + i * 2) === 0x00) {
              fireSaturation |= 0x01;
            } else {
              accel[i] = RoundDouble(buf.getInt16(7 + i * 2) / (1 << 12), 5);
            }
          }
          for (i = 0; i < 3; i++) {
            const tmp = buf.getFloat32(13 + i * 4, true);
            if (tmp === 1e+30 || tmp === -1e30) {
              fireSaturation |= 0x02;
            } else {
              gyro[i] = RoundDouble(tmp, 5);
            }
          }
          quaternion[0] = buf.getFloat32(29, true);
          quaternion[1] = buf.getFloat32(33, true);
          quaternion[2] = buf.getFloat32(37, true);
          quaternion[3] = buf.getFloat32(41, true);
          if (fireSaturation === 0) {
            timestamp = buf.getUint32(25);
            let bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "G",
              value: gyro
            });
            bp.set({
              name: "2",
              type: "G",
              value: compass
            });
            bp.set({
              name: "3",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 89);
            bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: quaternion
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 148);
          } else {
            let saturationError = true;
            if (fireSaturation & 0x01) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Acceleration Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              saturationError = false;
            }
            if (fireSaturation & 0x02) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Gyroscope Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              saturationError = false;
            }
            if (fireSaturation & 0x04) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.SATURATION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Magnetometer Saturation Detected."
              });
              ch.sendErrorEvent(bp);
              saturationError = false;
            }
            if (saturationError) {
              throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected saturation flag. This is likely a firmware bug.");
            }
          }
          break;
        case 198:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 199:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.INVALID_STATE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "The gyroscope has received invalid data and will recover shortly."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendMOT1102_SETCORRECTIONPARAMETERS(ch, bp) {
  const firmware_userMagnetometerTransform = [0, 0, 0, 0, 0, 0];
  const firmware_userMagnetometerOffset = [0, 0, 0];
  const firmware_userMagnetometerGain = [0, 0, 0];
  const buf = new DataView(new ArrayBuffer(28));
  const firmware_userMagField = bp.getNumber(0);
  for (let i = 0; i < 3; i++) {
    firmware_userMagnetometerOffset[i] = bp.getNumber((i + 1).toString());
    firmware_userMagnetometerGain[i] = bp.getNumber((i + 4).toString());
  }
  for (let i = 0; i < 6; i++) {
    firmware_userMagnetometerTransform[i] = bp.getNumber((i + 7).toString());
  }
  buf.setFloat32(0, firmware_userMagField, true);
  for (let i = 0; i < 3; i++) {
    buf.setFloat32(4 + i * 4, firmware_userMagnetometerOffset[i], true);
    buf.setFloat32(16 + i * 4, firmware_userMagnetometerGain[i], true);
  }
  await ch.sendVINTDataPacket(78, new Uint8Array(buf.buffer));
  for (let i = 0; i < 6; i++) {
    buf.setFloat32(i * 4, firmware_userMagnetometerTransform[i], true);
  }
  await ch.sendVINTDataPacket(78, new Uint8Array(buf.buffer, 0, 24));
}
async function sendMOT1102_1(ch, bp) {
  await sendMOT1102(ch, bp);
}
function recvMOT1102_1(ch, buf) {
  recvMOT1102(ch, buf);
}
async function sendMOT0100_VINT(ch, bp) {
  var _a;
  const buf = new DataView(new ArrayBuffer(24));
  switch (ch.chDef.uid) {
    case 365:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvMOT0100_VINT(ch, buf) {
  let timestamp;
  const accel = [0, 0, 0];
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 365:
      switch (pkt) {
        case 196:
          {
            if (buf.byteLength > 17) {
              if (buf.getUint8(17) & 0x01) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "One or more accelerometer readings is out of range."
                });
                ch.sendErrorEvent(bp);
              }
            }
            accel[0] = buf.getFloat32(1, true);
            accel[1] = buf.getFloat32(5, true);
            accel[2] = buf.getFloat32(9, true);
            timestamp = buf.getUint32(13);
            for (let i = 0; i < 3; i++) {
              if (!isNaN(accel[i])) accel[i] = RoundDouble(accel[i], 6);
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 1);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendMOT0110_VINT(ch, bp) {
  var _a, _b, _c, _d, _e;
  const buf = new DataView(new ArrayBuffer(24));
  let userphid;
  switch (ch.chDef.uid) {
    case 391:
      userphid = ch.userphid;
      await userphid._transactionLock.acquire();
      try {
        switch (bp.vpkt) {
          case 54:
            {
              const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
              if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
              await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            }
            break;
          case 106:
            await ch.sendVINTDataPacket(51);
            break;
          case 35:
            await ch.sendVINTDataPacket(77);
            break;
          case 37:
            await ch.sendVINTDataPacket(79);
            break;
          case 50:
            await sendMOT0110_SETCORRECTIONPARAMETERS(ch, bp);
            break;
          case 150:
            await ch.sendVINTDataPacket(80);
            break;
          case 149:
            buf.setUint8(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(81, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 151:
            buf.setFloat32(0, bp.getNumber(0), true);
            await ch.sendVINTDataPacket(82, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 174:
            buf.setFloat32(0, bp.getNumber(0), true);
            buf.setFloat32(4, bp.getNumber(1), true);
            buf.setFloat32(8, bp.getNumber(2), true);
            buf.setFloat32(12, bp.getNumber(3), true);
            buf.setFloat32(16, bp.getNumber(4), true);
            buf.setFloat32(20, bp.getNumber(5), true);
            await ch.sendVINTDataPacket(84, new Uint8Array(buf.buffer));
            break;
          case 170:
            buf.setUint8(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(85, new Uint8Array(buf.buffer, 0, 1));
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
      } finally {
        userphid._transactionLock.release();
      }
      break;
    case 390:
      userphid = ch.userphid;
      await userphid.transactionLock.acquire();
      try {
        switch (bp.vpkt) {
          case 54:
            {
              const dataInterval = (_b = ch.parent.parent) === null || _b === void 0 ? void 0 : _b._handleDataIntervalPacket(bp, 1);
              if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
              await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
            }
            break;
          case 46:
            buf.setFloat32(0, bp.getNumber(0), true);
            await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer, 0, 4));
            break;
          case 35:
            await ch.sendVINTDataPacket(77);
            break;
          case 37:
            await ch.sendVINTDataPacket(79);
            break;
          case 50:
            await sendMOT0110_SETCORRECTIONPARAMETERS(ch, bp);
            break;
          case 170:
            buf.setUint8(0, bp.getNumber(0));
            await ch.sendVINTDataPacket(85, new Uint8Array(buf.buffer, 0, 1));
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
        }
      } finally {
        userphid.transactionLock.release();
      }
      break;
    case 389:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_c = ch.parent.parent) === null || _c === void 0 ? void 0 : _c._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 106:
          await ch.sendVINTDataPacket(51);
          break;
        case 170:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(85, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 388:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_d = ch.parent.parent) === null || _d === void 0 ? void 0 : _d._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(195, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 170:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(85, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 392:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_e = ch.parent.parent) === null || _e === void 0 ? void 0 : _e._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvMOT0110_VINT(ch, buf) {
  let timestamp;
  let temperature;
  const compass = [0, 0, 0];
  const accel = [0, 0, 0];
  const gyro = [0, 0, 0];
  const quaternion = [0, 0, 0, 0];
  let tmpFlt;
  let interval;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 391:
      switch (pkt) {
        case 196:
          {
            if (buf.byteLength > 41) {
              if (buf.getUint8(41) & 0x20) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "One or more spatial readings is out of range."
                });
                ch.sendErrorEvent(bp);
              }
            }
            for (let i = 0; i < 3; i++) {
              tmpFlt = buf.getFloat32(i * 4 + 1, true);
              if (!Number.isNaN(tmpFlt)) {
                compass[i] = RoundDouble(tmpFlt, 5);
              }
              tmpFlt = buf.getFloat32(i * 4 + 13, true);
              if (!Number.isNaN(tmpFlt)) {
                accel[i] = RoundDouble(tmpFlt, 5);
              }
              tmpFlt = buf.getFloat32(i * 4 + 25, true);
              if (!Number.isNaN(tmpFlt)) {
                gyro[i] = RoundDouble(tmpFlt, 5);
              }
            }
            timestamp = buf.getUint32(37);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "G",
              value: gyro
            });
            bp.set({
              name: "2",
              type: "G",
              value: compass
            });
            bp.set({
              name: "3",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 89);
            break;
          }
        case 197:
          {
            quaternion[0] = buf.getFloat32(1, true);
            quaternion[1] = buf.getFloat32(5, true);
            quaternion[2] = buf.getFloat32(9, true);
            quaternion[3] = buf.getFloat32(13, true);
            timestamp = buf.getUint16(17);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: quaternion
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 148);
            break;
          }
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 390:
      switch (pkt) {
        case 196:
          {
            if (buf.byteLength > 17) {
              if (buf.getUint8(17) & 0x04) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "One or more magnetometer readings is out of range."
                });
                ch.sendErrorEvent(bp);
              }
            }
            compass[0] = RoundDouble(buf.getFloat32(1, true), 4);
            compass[1] = RoundDouble(buf.getFloat32(5, true), 4);
            compass[2] = RoundDouble(buf.getFloat32(9, true), 4);
            timestamp = buf.getUint32(13);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: compass
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 18);
            break;
          }
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 389:
      switch (pkt) {
        case 197:
          {
            if (buf.byteLength > 17) {
              if (buf.getUint8(17) & 0x02) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "One or more gyroscope readings is out of range."
                });
                ch.sendErrorEvent(bp);
              }
            }
            gyro[0] = RoundDouble(buf.getFloat32(1, true), 6);
            gyro[1] = RoundDouble(buf.getFloat32(5, true), 6);
            gyro[2] = RoundDouble(buf.getFloat32(9, true), 6);
            timestamp = buf.getUint32(13);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: gyro
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 2);
            break;
          }
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 388:
      switch (pkt) {
        case 196:
          {
            if (buf.byteLength > 17) {
              if (buf.getUint8(17) & 0x01) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "One or more accelerometer readings is out of range."
                });
                ch.sendErrorEvent(bp);
              }
            }
            accel[0] = RoundDouble(buf.getFloat32(1, true), 6);
            accel[1] = RoundDouble(buf.getFloat32(5, true), 6);
            accel[2] = RoundDouble(buf.getFloat32(9, true), 6);
            timestamp = buf.getUint32(13);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "G",
              value: accel
            });
            bp.set({
              name: "1",
              type: "g",
              value: timestamp
            });
            bp.sendToChannel(ch, 1);
            break;
          }
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 392:
      switch (pkt) {
        case 59:
          {
            if (buf.byteLength > 5) {
              const bp = new BridgePacket();
              switch (buf.getUint8(5) & 0x18) {
                case 0x08:
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature is too low to be accurately measured."
                  });
                  break;
                case 0x10:
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature is too high to be accurately measured."
                  });
                  break;
                case 0x18:
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.OUT_OF_RANGE
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature is unknown."
                  });
                  break;
              }
              ch.sendErrorEvent(bp);
            }
            temperature = RoundDouble(buf.getFloat32(1, true), 3);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: temperature
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 245:
          {
            interval = buf.getUint16(1);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "u",
              value: interval
            });
            bp.sendToChannel(ch, 10);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendMOT0110_SETCORRECTIONPARAMETERS(ch, bp) {
  const firmware_userMagnetometerTransform = [0, 0, 0, 0, 0, 0];
  const firmware_userMagnetometerOffset = [0, 0, 0];
  const firmware_userMagnetometerGain = [0, 0, 0];
  const buf = new DataView(new ArrayBuffer(28));
  const firmware_userMagField = bp.getNumber(0);
  for (let i = 0; i < 3; i++) {
    firmware_userMagnetometerOffset[i] = bp.getNumber((i + 1).toString());
    firmware_userMagnetometerGain[i] = bp.getNumber((i + 4).toString());
  }
  for (let i = 0; i < 6; i++) {
    firmware_userMagnetometerTransform[i] = bp.getNumber((i + 7).toString());
  }
  buf.setFloat32(0, firmware_userMagField, true);
  for (let i = 0; i < 3; i++) {
    buf.setFloat32(4 + i * 4, firmware_userMagnetometerOffset[i], true);
    buf.setFloat32(16 + i * 4, firmware_userMagnetometerGain[i], true);
  }
  await ch.sendVINTDataPacket(78, new Uint8Array(buf.buffer));
  for (let i = 0; i < 6; i++) {
    buf.setFloat32(i * 4, firmware_userMagnetometerTransform[i], true);
  }
  await ch.sendVINTDataPacket(78, new Uint8Array(buf.buffer, 0, 24));
}
async function sendPRE1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 393:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(64, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvPRE1000(ch, buf) {
  let pressure;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 393:
      switch (pkt) {
        case 65:
          {
            pressure = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(pressure, 3)
            });
            bp.sendToChannel(ch, 31);
            break;
          }
        case 66:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendRCC1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 394:
      switch (bp.vpkt) {
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 86:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(118, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 70:
          buf.setUint32(0, bp.getNumber(0) * 1000);
          await ch.sendVINTDataPacket(114, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 69:
          buf.setUint32(0, bp.getNumber(0) * 1000);
          await ch.sendVINTDataPacket(115, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 16 / 2500);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 85:
          buf.setUint32(0, bp.getNumber(0) * 16 / 50);
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          buf.setUint32(0, bp.getNumber(0) * 1000);
          await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 81:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 395:
    case 396:
      switch (bp.vpkt) {
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(113, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 86:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(118, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 70:
          buf.setUint32(0, bp.getNumber(0) * 1000);
          await ch.sendVINTDataPacket(114, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 69:
          buf.setUint32(0, bp.getNumber(0) * 1000);
          await ch.sendVINTDataPacket(115, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * 16 / 2500);
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 85:
          buf.setUint32(0, bp.getNumber(0) * 16 / 50);
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 83:
          buf.setUint32(0, bp.getNumber(0) * 1000);
          await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 81:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvRCC1000(ch, buf) {
  let motorPosition;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 394:
      switch (pkt) {
        case 116:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.BAD_POWER
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Servo motors are drawing too much power or the power supply is not providing enough voltage or current.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 112:
          {
            motorPosition = buf.getUint16(1) / 16;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: motorPosition
            });
            bp.sendToChannel(ch, 94);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 395:
    case 396:
      switch (pkt) {
        case 116:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.BAD_POWER
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Servo motors are drawing too much power or the power supply is not providing enough voltage or current.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 112:
          {
            motorPosition = buf.getUint16(1) / 16;
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: motorPosition
            });
            bp.sendToChannel(ch, 94);
            break;
          }
        case 121:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendRCC1000_Failsafe(ch, bp) {
  await sendRCC1000(ch, bp);
}
function recvRCC1000_Failsafe(ch, buf) {
  recvRCC1000(ch, buf);
}
async function sendRCC1000_1(ch, bp) {
  await sendRCC1000(ch, bp);
}
function recvRCC1000_1(ch, buf) {
  recvRCC1000(ch, buf);
}
async function sendREL1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(2));
  switch (ch.chDef.uid) {
    case 397:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 398:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvREL1000(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 397:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
    case 398:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Failsafe procedure initiated."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendREL1000_Failsafe(ch, bp) {
  await sendREL1000(ch, bp);
}
function recvREL1000_Failsafe(ch, buf) {
  recvREL1000(ch, buf);
}
async function sendREL1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 399:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 400:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 401:
      switch (bp.vpkt) {
        case 82:
          buf.setUint16(0, bp.getNumber(0) ? 1 << 15 : 0);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 55:
          buf.setUint16(0, bp.getNumber(0) * (1 << 15));
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 156:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(15, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvREL1100(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 399:
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet received.");
    case 400:
    case 401:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendREL1100_Failsafe(ch, bp) {
  await sendREL1100(ch, bp);
}
function recvREL1100_Failsafe(ch, buf) {
  recvREL1100(ch, buf);
}
async function sendREL1100_Failsafe_Frequency(ch, bp) {
  await sendREL1100(ch, bp);
}
function recvREL1100_Failsafe_Frequency(ch, buf) {
  recvREL1100(ch, buf);
}
async function sendREL1101(ch, bp) {
  const buf = new DataView(new ArrayBuffer(2));
  switch (ch.chDef.uid) {
    case 402:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          buf.setUint8(0, bp.getNumber(0) * 255);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 403:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          buf.setUint8(0, bp.getNumber(0) * 255);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvREL1101(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 402:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendREL1101_Failsafe(ch, bp) {
  await sendREL1101(ch, bp);
}
function recvREL1101_Failsafe(ch, buf) {
  recvREL1101(ch, buf);
}
async function sendREL1101_1(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 404:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          buf.setUint8(0, bp.getNumber(0) * 255);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        case 156:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(15, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 405:
      switch (bp.vpkt) {
        case 82:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 55:
          buf.setUint8(0, bp.getNumber(0) * 255);
          await ch.sendVINTDataPacket(10, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvREL1101_1(ch, buf) {
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 405:
    case 404:
      switch (pkt) {
        case 13:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSAF1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 407:
      switch (bp.vpkt) {
        case 56:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(166, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 71:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(162, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 58:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(159, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 410:
      switch (bp.vpkt) {
        case 56:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(166, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 71:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(162, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 58:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(159, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 408:
    case 411:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 409:
    case 412:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSAF1000(ch, buf) {
  let temperature;
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 407:
      switch (pkt) {
        case 164:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.ENERGY_DUMP_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Energy Dump in Progress.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 165:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.OVER_TEMPERATURE
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Overtemperature Condition Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 163:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.OVER_VOLTAGE
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Overvoltage Condition Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 160:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SUCCESS
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'All error conditions have been resolved'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 410:
      switch (pkt) {
        case 164:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.ENERGY_DUMP_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Energy Dump in Progress.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 165:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.OVER_TEMPERATURE
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Overtemperature Condition Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 163:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.OVER_VOLTAGE
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Overvoltage Condition Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 160:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SUCCESS
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'All error conditions have been resolved'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 167:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 408:
    case 411:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getUint32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 7)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 409:
    case 412:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(temperature, 2)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSAF1000_Failsafe(ch, bp) {
  await sendSAF1000(ch, bp);
}
function recvSAF1000_Failsafe(ch, buf) {
  recvSAF1000(ch, buf);
}
async function sendSND1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 413:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          break;
        case 116:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(147, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSND1000(ch, buf) {
  const octaves = new Array(10);
  const finaloctaves = new Array(10);
  let tempDouble,
    gain,
    dB = 0.0,
    dBA = 0.0,
    dBC = 0.0,
    changeTrigger,
    lastdB;
  let saturatedFlag = false;
  const userphid = ch.userphid;
  const dBA_weight = [-6.700912224792721, -1.144507424157968, 0.9642291552357972, 1.2016993444284976, 0.0, -3.098968656056327, -8.456545621324212, -16.189851062139507, -26.22302364022129, -39.52906401331724];
  const dBC_weight = [-8.62944227232129, -3.0448821481317507, -0.8252420358959885, -0.16942156787436816, 0.0, 0.03251328929742176, 0.0019618319836562453, -0.1718184155510175, -0.8206982482269319, 3.030794594641769];
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 413:
      switch (pkt) {
        case 146:
          gain = buf.getUint8(41) == 1 ? 39.912703891951 : 59.912703891951;
          saturatedFlag = buf.getUint8(42) == 1 ? true : false;
          for (let i = 0; i < 10; i++) {
            tempDouble = Math.sqrt(buf.getFloat32(i * 4 + 1, true));
            tempDouble *= 3300.0 / 4095.0;
            tempDouble /= 6.309573444801932;
            octaves[i] = 20.0 * Math.log10(tempDouble) + 94.0 - gain;
            dB += Math.pow(10, octaves[i] / 10.0);
            dBA += Math.pow(10, (octaves[i] + dBA_weight[i]) / 10.0);
            dBC += Math.pow(10, (octaves[i] + dBC_weight[i]) / 10.0);
          }
          if (saturatedFlag) {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
          } else {
            dB = 10 * Math.log10(dB);
            dBA = 10 * Math.log10(dBA);
            dBC = 10 * Math.log10(dBC);
            for (let i = 0; i < 10; i++) {
              finaloctaves[i] = RoundDouble(octaves[9 - i], 4);
            }
            changeTrigger = userphid.data.SPLChangeTrigger;
            lastdB = userphid.data.lastdB;
            if (Math.abs(lastdB - dB) > changeTrigger) {
              userphid.data.lastdB = dB;
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "g",
                value: RoundDouble(dB, 4)
              });
              bp.set({
                name: "1",
                type: "g",
                value: RoundDouble(dBA, 4)
              });
              bp.set({
                name: "2",
                type: "g",
                value: RoundDouble(dBC, 4)
              });
              bp.set({
                name: "3",
                type: "G",
                value: finaloctaves
              });
              bp.sendToChannel(ch, 11);
            }
          }
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 414:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 415:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSTC1000(ch, buf) {
  let motorPosition;
  let velocity;
  let stopped;
  let moving;
  const pkt = buf.getUint8(0);
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 414:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 415:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1000_Failsafe(ch, bp) {
  await sendSTC1000(ch, bp);
}
function recvSTC1000_Failsafe(ch, buf) {
  recvSTC1000(ch, buf);
}
async function sendSTC1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 416:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 417:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSTC1001(ch, buf) {
  let motorPosition;
  let velocity;
  let stopped;
  let moving;
  const pkt = buf.getUint8(0);
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 416:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 417:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1001_Failsafe(ch, bp) {
  await sendSTC1001(ch, bp);
}
function recvSTC1001_Failsafe(ch, buf) {
  recvSTC1001(ch, buf);
}
async function sendSTC1002(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 418:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 419:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSTC1002(ch, buf) {
  let motorPosition;
  let velocity;
  let stopped;
  let moving;
  const pkt = buf.getUint8(0);
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 418:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 419:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1002_Failsafe(ch, bp) {
  await sendSTC1002(ch, bp);
}
function recvSTC1002_Failsafe(ch, buf) {
  recvSTC1002(ch, buf);
}
async function sendSTC1003(ch, bp) {
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 420:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 421:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSTC1003(ch, buf) {
  let motorPosition;
  let velocity;
  let stopped;
  let moving;
  const pkt = buf.getUint8(0);
  const userphid = ch.userphid;
  switch (ch.chDef.uid) {
    case 420:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 421:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            moving = userphid.data.isMoving;
            if (stopped && stopped == moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 118:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.BAD_POWER
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Overcurrent error detected. Device has been reset.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1003_Failsafe(ch, bp) {
  await sendSTC1003(ch, bp);
}
function recvSTC1003_Failsafe(ch, buf) {
  recvSTC1003(ch, buf);
}
async function sendSTC1003_1(ch, bp) {
  var _a, _b;
  const buf = new DataView(new ArrayBuffer(8));
  switch (ch.chDef.uid) {
    case 422:
    case 424:
    case 426:
      switch (bp.vpkt) {
        case 83:
          {
            const position = bp.getNumber(0);
            SetBigInt64(buf, 0, position);
            await ch.sendVINTDataPacket(88, new Uint8Array(buf.buffer));
            break;
          }
        case 85:
          buf.setUint32(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(89, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 40:
          buf.setUint32(0, bp.getNumber(0) * (1 << 7));
          await ch.sendVINTDataPacket(90, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 51:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(127, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 63:
          buf.setUint16(0, bp.getNumber(0) * (1 << 8));
          await ch.sendVINTDataPacket(122, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 57:
          buf.setUint8(0, bp.getNumber(0) ? 0xFF : 0x00);
          await ch.sendVINTDataPacket(120, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 49:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(119, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 146:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(246, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 147:
          await ch.sendVINTDataPacket(247);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 423:
    case 425:
    case 427:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_b = ch.parent.parent) === null || _b === void 0 ? void 0 : _b._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvSTC1003_1(ch, buf) {
  let motorPosition;
  let velocity;
  let voltage;
  let stopped;
  let moving;
  let userphid;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 422:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            userphid = ch.userphid;
            moving = userphid.data.isMoving;
            if (stopped && moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 118:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.BAD_POWER
            });
            if (buf.getUint8(1)) {
              bp.set({
                name: '1',
                type: 's',
                value: 'Supply Voltage above expected range.'
              });
            } else {
              bp.set({
                name: '1',
                type: 's',
                value: 'Supply Voltage below expected range.  Possible overcurrent condition.'
              });
            }
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 423:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 7)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1005_0(ch, bp) {
  await sendSTC1003_1(ch, bp);
}
function recvSTC1005_0(ch, buf) {
  let motorPosition;
  let velocity;
  let voltage;
  let stopped;
  let moving;
  let userphid;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 424:
    case 426:
      switch (pkt) {
        case 123:
          {
            motorPosition = GetBigInt64(buf, 1);
            velocity = buf.getInt32(9) / 256;
            stopped = buf.getUint8(13) ? 1 : 0;
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'l',
              value: motorPosition
            });
            bp.sendToChannel(ch, 29);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: velocity
            });
            bp.sendToChannel(ch, 100);
            userphid = ch.userphid;
            moving = userphid.data.isMoving;
            if (stopped && moving) {
              bp = new BridgePacket();
              bp.sendToChannel(ch, 91);
            }
            break;
          }
        case 93:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 118:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.BAD_POWER
            });
            if (buf.getUint8(1)) {
              bp.set({
                name: '1',
                type: 's',
                value: 'Supply Voltage above expected range.'
              });
            } else {
              bp.set({
                name: '1',
                type: 's',
                value: 'Supply Voltage below expected range.  Possible overcurrent condition.'
              });
            }
            ch.sendErrorEvent(bp);
            break;
          }
        case 119:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAULT
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Fault condition detected. Motor is disengaged and position is lost. Re-engage and re-initialize your system.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 120:
          {
            let bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAULT
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Fault condition detected. Motor is disengaged and position is lost. Re-engage and re-initialize your system.'
            });
            ch.sendErrorEvent(bp);
            bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.OVER_TEMPERATURE
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Overtemperature Condition Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 425:
    case 427:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 7)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendTMP1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 428:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 16));
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer, 0, 4));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendSTC1005_0_110(ch, bp) {
  await sendSTC1005_0(ch, bp);
}
function recvSTC1005_0_110(ch, buf) {
  recvSTC1005_0(ch, buf);
}
function recvTMP1000(ch, buf) {
  let temperature;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 428:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getInt32(1) / (1 << 16);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(temperature, 2)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendTMP1100(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 431:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 430:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 429:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        case 84:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(62, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvTMP1100(ch, buf) {
  let temperature;
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 430:
    case 429:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 3)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 431:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(voltage, 6)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendTMP1101(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 432:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        case 84:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(62, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 433:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 434:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvTMP1101(ch, buf) {
  let temperature;
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 432:
    case 433:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 3)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 434:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(voltage, 6)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendTMP1101_1(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 435:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        case 84:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(62, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 436:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 437:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvTMP1101_1(ch, buf) {
  let temperature;
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 435:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 3)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 64:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.BAD_CONNECTION_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Bad Connection"
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 436:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 3)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 437:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(voltage, 6)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 23:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.BAD_CONNECTION_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Bad Connection"
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendTMP1200(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 438:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        case 77:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(192, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 76:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(63, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 439:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(155, new Uint8Array(buf.buffer));
          break;
        case 77:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(192, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvTMP1200(ch, buf) {
  let temperature, resistance;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 438:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 3)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 439:
      switch (pkt) {
        case 154:
          {
            resistance = buf.getFloat32(1, true);
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(resistance, 3)
            });
            bp.sendToChannel(ch, 36);
            break;
          }
        case 156:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Saturation Detected."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendTMP1200_1(ch, bp) {
  var _a, _b;
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 440:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_a = ch.parent.parent) === null || _a === void 0 ? void 0 : _a._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(58, new Uint8Array(buf.buffer));
          break;
        case 77:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(192, new Uint8Array(buf.buffer, 0, 1));
          break;
        case 76:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(63, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 441:
      switch (bp.vpkt) {
        case 54:
          {
            const dataInterval = (_b = ch.parent.parent) === null || _b === void 0 ? void 0 : _b._handleDataIntervalPacket(bp, 1);
            if (dataInterval) buf.setUint16(0, dataInterval);else throw new PhidgetError(ErrorCode.UNEXPECTED);
            await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          }
          break;
        case 46:
          buf.setFloat32(0, bp.getNumber(0), true);
          await ch.sendVINTDataPacket(155, new Uint8Array(buf.buffer));
          break;
        case 77:
          buf.setUint8(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(192, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvTMP1200_1(ch, buf) {
  let temperature, resistance;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 440:
      switch (pkt) {
        case 59:
          {
            temperature = buf.getFloat32(1, true);
            if (buf.byteLength > 5) {
              if (temperature > 0) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Temperature is too high to be accurately measured."
                });
                ch.sendErrorEvent(bp);
              } else {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Temperature is too low to be accurately measured."
                });
                ch.sendErrorEvent(bp);
              }
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(temperature, 3)
            });
            bp.sendToChannel(ch, 95);
            break;
          }
        case 60:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.OUT_OF_RANGE
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Temperature is unknown."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        case 64:
          {
            if (buf.getUint8(1)) {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.BAD_CONNECTION_CONDITION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Bad Connection: Check polarity of connection."
              });
              ch.sendErrorEvent(bp);
            } else {
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.BAD_CONNECTION_CONDITION
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Bad Connection: RTD is likely disconnected."
              });
              ch.sendErrorEvent(bp);
            }
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    case 441:
      switch (pkt) {
        case 154:
          {
            resistance = buf.getFloat32(1, true);
            if (buf.byteLength > 5) {
              if (resistance > 0) {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Resistance is too high to be accurately measured."
                });
                ch.sendErrorEvent(bp);
              } else {
                const bp = new BridgePacket();
                bp.set({
                  name: "0",
                  type: "d",
                  value: ErrorEventCode.BAD_CONNECTION_CONDITION
                });
                bp.set({
                  name: "1",
                  type: "s",
                  value: "Bad Connection: check polarity of connection."
                });
                ch.sendErrorEvent(bp);
              }
            }
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "g",
              value: RoundDouble(resistance, 3)
            });
            bp.sendToChannel(ch, 36);
            break;
          }
        case 64:
          {
            const bp = new BridgePacket();
            bp.set({
              name: "0",
              type: "d",
              value: ErrorEventCode.BAD_CONNECTION_CONDITION
            });
            bp.set({
              name: "1",
              type: "s",
              value: "Bad Connection."
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVCP1000(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 444:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          switch (bp.getNumber(0)) {
            case VoltageRange.MILLIVOLTS_312_5:
            case VoltageRange.VOLTS_40:
              break;
            default:
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid or unsupported voltage range for this device.");
          }
          await ch.sendVINTDataPacket(21, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVCP1000(ch, buf) {
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 444:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getInt32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 7)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVCP1001(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 445:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          switch (bp.getNumber(0)) {
            case VoltageRange.VOLTS_5:
            case VoltageRange.VOLTS_15:
            case VoltageRange.VOLTS_40:
            case VoltageRange.AUTO:
              break;
            default:
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid or unsupported voltage range for this device.");
          }
          await ch.sendVINTDataPacket(19, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVCP1001(ch, buf) {
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 445:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getInt32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 4)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVCP1002(ch, bp) {
  const buf = new DataView(new ArrayBuffer(4));
  switch (ch.chDef.uid) {
    case 447:
      switch (bp.vpkt) {
        case 54:
          buf.setUint16(0, bp.getNumber(0));
          await ch.sendVINTDataPacket(252, new Uint8Array(buf.buffer, 0, 2));
          break;
        case 46:
          buf.setUint32(0, bp.getNumber(0) * (1 << 24));
          await ch.sendVINTDataPacket(16, new Uint8Array(buf.buffer, 0, 4));
          break;
        case 87:
          buf.setUint8(0, bp.getNumber(0));
          switch (bp.getNumber(0)) {
            case VoltageRange.MILLIVOLTS_10:
            case VoltageRange.MILLIVOLTS_40:
            case VoltageRange.MILLIVOLTS_200:
            case VoltageRange.MILLIVOLTS_1000:
            case VoltageRange.AUTO:
              break;
            default:
              throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid or unsupported voltage range for this device.");
          }
          await ch.sendVINTDataPacket(20, new Uint8Array(buf.buffer, 0, 1));
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
function recvVCP1002(ch, buf) {
  let voltage;
  const pkt = buf.getUint8(0);
  switch (ch.chDef.uid) {
    case 447:
      switch (pkt) {
        case 17:
          {
            voltage = buf.getInt32(1) / (1 << 24);
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'g',
              value: RoundDouble(voltage, 7)
            });
            bp.sendToChannel(ch, 101);
            break;
          }
        case 18:
          {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.SATURATION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Saturation Detected.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
      break;
    default:
      throw new PhidgetError(ErrorCode.INVALID, "Invalid Channel UID");
  }
}
async function sendVCP1001_110(ch, bp) {
  await sendVCP1001(ch, bp);
}
function recvVCP1001_110(ch, buf) {
  return recvVCP1001(ch, buf);
}
async function sendVCP1002_110(ch, bp) {
  await sendVCP1002(ch, bp);
}
function recvVCP1002_110(ch, buf) {
  return recvVCP1002(ch, buf);
}
async function sendFIRMWARE_UPGRADE_STM32F0(ch, bp) {
  throw new Error("Not Implemented");
}
function recvFIRMWARE_UPGRADE_STM32F0(ch, buf) {
  throw new Error("Not Implemented");
}
async function sendFIRMWARE_UPGRADE_STM32F0v2(ch, bp) {
  throw new Error("Not Implemented");
}
function recvFIRMWARE_UPGRADE_STM32F0v2(ch, buf) {
  throw new Error("Not Implemented");
}
async function sendFIRMWARE_UPGRADE_STM32G0_BLBug(ch, bp) {
  throw new Error("Not Implemented");
}
function recvFIRMWARE_UPGRADE_STM32G0_BLBug(ch, buf) {
  throw new Error("Not Implemented");
}
async function sendFIRMWARE_UPGRADE_STM32G0(ch, bp) {
  throw new Error("Not Implemented");
}
function recvFIRMWARE_UPGRADE_STM32G0(ch, buf) {
  throw new Error("Not Implemented");
}
async function sendFIRMWARE_UPGRADE_STM32F3(ch, bp) {
  throw new Error("Not Implemented");
}
function recvFIRMWARE_UPGRADE_STM32F3(ch, buf) {
  throw new Error("Not Implemented");
}
async function sendFIRMWARE_UPGRADE_STM8S(ch, bp) {
  throw new Error("Not Implemented");
}
function recvFIRMWARE_UPGRADE_STM8S(ch, buf) {
  throw new Error("Not Implemented");
}
async function sendUNKNOWNVINT(ch, bp) {
  throw new Error("Not Implemented");
}
function recvUNKNOWNVINT(ch, buf) {
  throw new Error("Not Implemented");
}

/** @internal */
const USBVID_PHIDGETS = 0x06C2;
const USBPID_PHIDGETS_MIN = 0x0030;
const USBPID_PHIDGETS_MAX = 0x00AF;
const USBD_PHIDGET_PROTO_VERSION = 0x0110;
const USB_CONFIGURATION_DESCRIPTOR = 9;
const USB_COMMON_DESCRIPTOR = 2;
async function GetPhidgetDeviceParams(usbDevice) {
  let endpointDesc = null;
  let phidgetDeviceDesc = null;
  let phidgetEndpointDesc = null;
  const params = {
    maxPacketEP0: 0,
    ep1type: 0,
    maxPacketEP1: 0,
    ep2type: 0,
    maxPacketEP2: 0,
    wMaxPacketSizeEP1: 0,
    labelIndex: 0,
    skuIndex: 0
  };
  let descEnd = null;
  const configDescData = await GetConfigDescriptor(usbDevice, 0);
  const configDesc = {
    bLength: configDescData.getUint8(0),
    bDescriptorType: configDescData.getUint8(1),
    wTotalLength: configDescData.getUint8(3) << 8 | configDescData.getUint8(2),
    bNumInterfaces: configDescData.getUint8(4),
    bConfigurationValue: configDescData.getUint8(5),
    iConfiguration: configDescData.getUint8(6),
    bmAttributes: configDescData.getUint8(7),
    MaxPower: configDescData.getUint8(8)
  };
  descEnd = 0 + configDesc.wTotalLength;
  params.ep1type = 0;
  params.maxPacketEP1 = 0;
  params.ep2type = 0;
  params.maxPacketEP2 = 0;
  let i = 0;
  while (i + 2 < descEnd && i + configDescData.getUint8(i) <= descEnd) {
    switch (configDescData.getUint8(i + 1)) {
      case 2:
        if (configDescData.getUint8(i) !== 9) throw new PhidgetError(ErrorCode.UNEXPECTED, "Error parsing config descriptor!");
        break;
      case 4:
        break;
      case 5:
        if (configDescData.getUint8(i) !== 7) throw new PhidgetError(ErrorCode.UNEXPECTED, "Error parsing config descriptor!");
        endpointDesc = {
          bLength: configDescData.getUint8(i),
          bDescriptorType: configDescData.getUint8(i + 1),
          bEndpointAddress: configDescData.getUint8(i + 2),
          bmAttributes: configDescData.getUint8(i + 3),
          wMaxPacketSize: configDescData.getUint8(i + 5) << 8 | configDescData.getUint8(i + 4),
          bInterval: configDescData.getUint8(i + 6)
        };
        if (endpointDesc.bEndpointAddress === 0x81) {
          params.wMaxPacketSizeEP1 = endpointDesc.wMaxPacketSize;
          if (endpointDesc.bmAttributes === 2) params.ep1type = 1;
          if (endpointDesc.bmAttributes === 3) params.ep1type = 2;
        }
        if (endpointDesc.bEndpointAddress === 0x02) {
          params.maxPacketEP2 = endpointDesc.wMaxPacketSize;
          params.ep2type = 1;
        }
        break;
      case 64:
        if (configDescData.getUint8(i) !== 8) throw new PhidgetError(ErrorCode.UNEXPECTED, "Error parsing config descriptor!");
        phidgetDeviceDesc = {
          bLength: configDescData.getUint8(i),
          bDescriptorType: configDescData.getUint8(i + 1),
          bcdVersion: configDescData.getUint8(i + 3) << 8 | configDescData.getUint8(i + 2),
          iLabel: configDescData.getUint8(i + 4),
          iSKU: configDescData.getUint8(i + 5),
          wMaxPacketSize: configDescData.getUint8(i + 7) << 8 | configDescData.getUint8(i + 6)
        };
        if (phidgetDeviceDesc.bcdVersion !== USBD_PHIDGET_PROTO_VERSION) {
          throw new PhidgetError(ErrorCode.UNSUPPORTED, "Unknown Phidget descriptor version: " + phidgetDeviceDesc.bcdVersion + " - Library upgrade may be required.");
        }
        params.labelIndex = phidgetDeviceDesc.iLabel;
        params.skuIndex = phidgetDeviceDesc.iSKU;
        params.maxPacketEP0 = phidgetDeviceDesc.wMaxPacketSize;
        break;
      case 66:
        if (configDescData.getUint8(i) !== 4) throw new PhidgetError(ErrorCode.UNEXPECTED, "Error parsing config descriptor!");
        phidgetEndpointDesc = {
          bLength: configDescData.getUint8(i),
          bDescriptorType: configDescData.getUint8(i + 1),
          wMaxPacketSize: configDescData.getUint8(i + 3) << 8 | configDescData.getUint8(i + 2)
        };
        if (endpointDesc == undefined) throw new PhidgetError(ErrorCode.UNEXPECTED, "Didn't get Phidget Endpoint descriptor!");
        if ((endpointDesc.bEndpointAddress & 0x7F) == 0x01) params.maxPacketEP1 = phidgetEndpointDesc.wMaxPacketSize;
        if ((endpointDesc.bEndpointAddress & 0x7F) == 0x02) params.maxPacketEP2 = phidgetEndpointDesc.wMaxPacketSize;
        break;
    }
    i += configDescData.getUint8(i);
  }
  return params;
}
async function GetPhidgetUSBData(usbDevice) {
  var _a, _b;
  let desc;
  if (usbDevice.vendorId !== USBVID_PHIDGETS) throw new PhidgetError(ErrorCode.UNSUPPORTED);
  if (usbDevice.productId < USBPID_PHIDGETS_MIN || usbDevice.productId > USBPID_PHIDGETS_MAX) throw new PhidgetError(ErrorCode.UNSUPPORTED);
  desc = await GetDescriptor(usbDevice, 1, 0, 0);
  const devDescriptor = {
    bLength: desc.getUint8(0),
    bDescriptorType: desc.getUint8(1),
    bcdUSB: desc.getUint8(3) << 8 | desc.getUint8(2),
    bDeviceClass: desc.getUint8(4),
    bDeviceSubClass: desc.getUint8(5),
    bDeviceProtocol: desc.getUint8(6),
    bMaxPacketSize0: desc.getUint8(7),
    idVendor: desc.getUint8(9) << 8 | desc.getUint8(8),
    idProduct: desc.getUint8(11) << 8 | desc.getUint8(10),
    bcdDevice: desc.getUint8(13) << 8 | desc.getUint8(12),
    iManufacturer: desc.getUint8(14),
    iProduct: desc.getUint8(15),
    iSerialNumber: desc.getUint8(16),
    bNumConfigurations: desc.getUint8(17)
  };
  desc = await GetDescriptor(usbDevice, 3, devDescriptor.iSerialNumber, 0);
  const version = (devDescriptor.bcdDevice >> 12 & 0x0F) * 1000 + (devDescriptor.bcdDevice >> 8 & 0x0F) * 100 + (devDescriptor.bcdDevice >> 4 & 0x0F) * 10 + (devDescriptor.bcdDevice & 0x0F);
  const serial = parseInt(WordByteArrayToString(new Uint16Array(desc.buffer, 2)));
  const phidDevParams = await GetPhidgetDeviceParams(usbDevice);
  desc = await GetDescriptor(usbDevice, 3, phidDevParams.skuIndex, 0);
  const skuString = WordByteArrayToString(new Uint16Array(desc.buffer, 2));
  const interfaceNum = (_b = (_a = usbDevice.configuration) === null || _a === void 0 ? void 0 : _a.interfaces[0].interfaceNumber) !== null && _b !== void 0 ? _b : 0;
  let label = '';
  if (phidDevParams.labelIndex != 0) {
    const desc = await GetDescriptor(usbDevice, 3, phidDevParams.labelIndex, 0);
    if (desc.byteLength <= 22) {
      const bLength = desc.getUint8(0);
      if (bLength > 2) {
        const bStringWordArray = new Uint16Array(desc.buffer);
        label = WordByteArrayToString(bStringWordArray.slice(1));
      }
    }
  }
  const devData = {
    version: version,
    serialNumber: serial,
    productID: usbDevice.productId,
    vendorID: usbDevice.vendorId,
    interfaceNum: interfaceNum,
    fwstr: skuString,
    label: label,
    pusbParams: phidDevParams
  };
  return devData;
}
async function GetDescriptor(usbDevice, DescriptorType, DescriptorIndex, wIndex) {
  let descReq;
  const controlTransferParams = {
    requestType: 'standard',
    recipient: 'device',
    request: 0x06,
    value: DescriptorType << 8 | DescriptorIndex,
    index: wIndex
  };
  try {
    descReq = await usbDevice.controlTransferIn(controlTransferParams, USB_COMMON_DESCRIPTOR);
  } catch (err) {
    throw new PhidgetError(ErrorCode.IO, "Failed to read descriptor", err);
  }
  if (descReq.status !== 'ok') throw new PhidgetError(ErrorCode.UNEXPECTED, "Failed to read descriptor: " + descReq.status);
  if (!descReq.data || descReq.data.byteLength != USB_COMMON_DESCRIPTOR) throw new PhidgetError(ErrorCode.UNEXPECTED, "GetDescriptor error - returned unexpected number of bytes");
  const bLength = descReq.data.getUint8(0);
  if (bLength <= USB_COMMON_DESCRIPTOR) return descReq.data;
  try {
    descReq = await usbDevice.controlTransferIn(controlTransferParams, bLength);
  } catch (err) {
    throw new PhidgetError(ErrorCode.IO, "Failed to read descriptor", err);
  }
  if (descReq.status !== 'ok') throw new PhidgetError(ErrorCode.UNEXPECTED, "Failed to read descriptor: " + descReq.status);
  if (!descReq.data || descReq.data.byteLength != bLength) throw new PhidgetError(ErrorCode.UNEXPECTED, "GetDescriptor error - returned unexpected number of bytes");
  return descReq.data;
}
async function GetConfigDescriptor(usbDevice, DescriptorIndex) {
  const controlTransferParams = {
    requestType: 'standard',
    recipient: 'device',
    request: 0x06,
    value: 2 << 8 | DescriptorIndex,
    index: 0
  };
  let configDescReq = await usbDevice.controlTransferIn(controlTransferParams, USB_CONFIGURATION_DESCRIPTOR);
  if (configDescReq.status !== 'ok') throw new PhidgetError(ErrorCode.UNEXPECTED, "Failed to read descriptor: " + configDescReq.status);
  if (!configDescReq.data) throw new PhidgetError(ErrorCode.UNEXPECTED, "GetDescriptor error - returned unexpected number of bytes");
  const wTotalLength = configDescReq.data.getUint8(3) << 8 | configDescReq.data.getUint8(2);
  if (wTotalLength < USB_CONFIGURATION_DESCRIPTOR) throw new PhidgetError(ErrorCode.UNEXPECTED, "GetDescriptor error - too short!");
  configDescReq = await usbDevice.controlTransferIn(controlTransferParams, wTotalLength);
  if (configDescReq.status !== 'ok') throw new PhidgetError(ErrorCode.UNEXPECTED, "Failed to read descriptor: " + configDescReq.status);
  if (!configDescReq.data) throw new PhidgetError(ErrorCode.UNEXPECTED, "GetDescriptor error - returned unexpected number of bytes");
  if (configDescReq.data.byteLength !== wTotalLength) throw new PhidgetError(ErrorCode.UNEXPECTED, "GetDescriptor error - returned unexpected number of bytes");
  return configDescReq.data;
}

/** @internal */
class PhidgetUSBDevice extends LocalDevice {
  constructor(conn, data, usbDev) {
    super(conn, data);
    this.usbDevice = usbDev;
    this.phidlock = new PhidgetLock();
    this.readlock = new PhidgetLock();
    this.writelock = new PhidgetLock();
    this.openCnt = 0;
    this.interfaceNum = data.interfaceNum;
    this.pusbParams = data.pusbParams;
    this.sku;
  }
  get opened() {
    return this.usbDevice.opened;
  }
  get claimed() {
    var _a, _b;
    return (_b = (_a = this.usbDevice.configuration) === null || _a === void 0 ? void 0 : _a.interfaces[0].claimed) !== null && _b !== void 0 ? _b : false;
  }
  async open() {
    let fullOpen = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    if (!this.phidlock.locked) throw new Error("Device MUST be locked before calling open");
    this.closing = false;
    if (!this.opened) {
      try {
        this.openCnt = 0;
        await this.usbDevice.open();
        if (this.usbDevice.configuration === null) await this.usbDevice.selectConfiguration(1);
      } catch (err) {
        this.closing = true;
        await this.usbDevice.close();
        this.openCnt = 0;
        throw new PhidgetError(ErrorCode.IO, "Error during USB open", err);
      }
    }
    this.openCnt++;
    if (fullOpen && !this.claimed) {
      try {
        await this.usbDevice.claimInterface(0);
      } catch (err) {
        this.closing = true;
        await this.usbDevice.close();
        this.openCnt = 0;
        throw new PhidgetError(ErrorCode.IO, "Failed to claim interface: ", err);
      }
      try {
        await this.openReset();
        await this.initAfterOpen();
      } catch (err) {
        this.closing = true;
        await this.usbDevice.close();
        this.openCnt = 0;
        logerr("Device Initialization failed", err);
        if (err instanceof PhidgetError && err.errorCode === ErrorCode.BAD_VERSION) logwarn("This Phidget requires a new library - please upgrade.");
        throw err;
      }
      loginfo("Opened USB Phidget: " + this);
      if (this.conn._usbType === 1) this.conn._setEpTimeout(this.usbDevice, 0x81, 500);
      this.pollUSBData().catch(err => {
        if (this.closing) return;
        logerr("Error polling USB Data", err);
        this.conn._usbErrorDetach(this);
      });
    }
  }
  async pollUSBData() {
    while (this.opened && !this.closing) {
      try {
        this.dataInput(await this.readPacket());
      } catch (err) {
        if (err.errorCode !== ErrorCode.TIMEOUT) throw err;
      }
    }
    throw new PhidgetError(ErrorCode.NOT_ATTACHED);
  }
  async close() {
    let force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    let fullClose = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    if (!this.phidlock.locked) throw new Error("Device MUST be locked before calling close");
    if (!this.opened) return;
    if (force) this.openCnt = 1;
    this.openCnt--;
    if (this.openCnt > 0) {
      logdebug("Leaving USB device open, as open count is: " + this.openCnt);
      return;
    }
    if (fullClose) {
      if (!this.claimed) throw new PhidgetError(ErrorCode.UNEXPECTED, "USB Interface is already released");
      try {
        this.closing = true;
        await this.closeReset();
        try {
          if (this.conn._usbType === 1) {
            await this.readlock.acquire();
            await this.writelock.acquire();
          }
          this.openCnt = 0;
          await this.usbDevice.releaseInterface(0);
          await this.usbDevice.close();
        } finally {
          if (this.conn._usbType === 1) {
            this.readlock.release();
            this.writelock.release();
          }
        }
        loginfo("Closed USB Phidget: " + this);
      } catch (err) {
        throw new PhidgetError(ErrorCode.IO, 'Failure during USB close', err);
      }
    } else {
      try {
        this.closing = true;
        this.openCnt = 0;
        await this.usbDevice.close();
      } catch (err) {
        throw new PhidgetError(ErrorCode.IO, "Failed to close USB handle", err);
      }
    }
  }
  async transferPacket(transferType, packetType, index, bufferOrReadLen) {
    switch (transferType) {
      case 0:
      case 2:
      case 4:
      case 6:
        {
          let result;
          if (transferType === 6) {
            if (bufferOrReadLen == undefined || typeof bufferOrReadLen !== 'object') throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
            if (bufferOrReadLen.byteLength > this.pusbParams.maxPacketEP2) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
            if (this.pusbParams.ep2type !== 1) throw new PhidgetError(ErrorCode.UNSUPPORTED);
            logbuffer("USB Bulk OUT Packet", bufferOrReadLen);
            try {
              if (this.conn._usbType === 1) await this.writelock.acquire();
              result = await this.usbDevice.transferOut(2, bufferOrReadLen);
            } catch (err) {
              throw new PhidgetError(ErrorCode.IO, "USB Bulk transfer failed", err);
            } finally {
              if (this.conn._usbType === 1) this.writelock.release();
            }
          } else {
            const controlTransferParams = {
              requestType: "vendor",
              recipient: 'interface',
              request: transferType,
              value: packetType << 8 | index,
              index: this.interfaceNum
            };
            if (bufferOrReadLen != undefined && typeof bufferOrReadLen === 'object') {
              if (bufferOrReadLen.byteLength > this.pusbParams.maxPacketEP0) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
              logbuffer("USB Control OUT Packet", bufferOrReadLen);
              try {
                if (this.conn._usbType === 1) await this.writelock.acquire();
                result = await this.usbDevice.controlTransferOut(controlTransferParams, bufferOrReadLen);
              } catch (err) {
                throw new PhidgetError(ErrorCode.IO, "USB Control OUT transfer failed", err);
              } finally {
                if (this.conn._usbType === 1) this.writelock.release();
              }
            } else {
              try {
                if (this.conn._usbType === 1) await this.writelock.acquire();
                result = await this.usbDevice.controlTransferOut(controlTransferParams);
              } catch (err) {
                throw new PhidgetError(ErrorCode.IO, "USB Control OUT transfer failed", err);
              } finally {
                if (this.conn._usbType === 1) this.writelock.release();
              }
            }
          }
          if (result.status !== 'ok') throw new PhidgetError(ErrorCode.IO, "controlTransferOut error. Status: " + result.status);
          if (bufferOrReadLen != undefined && typeof bufferOrReadLen === 'object' && result.bytesWritten !== bufferOrReadLen.byteLength) throw new PhidgetError(ErrorCode.UNEXPECTED, "USB send failed to write expected number of bytes.");
          break;
        }
      case 1:
      case 3:
      case 5:
        {
          if (!(typeof bufferOrReadLen === 'number')) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
          if (bufferOrReadLen > this.pusbParams.maxPacketEP0) bufferOrReadLen = this.pusbParams.maxPacketEP0;
          const controlTransferParams = {
            requestType: "vendor",
            recipient: 'interface',
            request: transferType,
            value: packetType << 8 | index,
            index: this.interfaceNum
          };
          let descReq;
          try {
            if (this.conn._usbType === 1) await this.writelock.acquire();
            descReq = await this.usbDevice.controlTransferIn(controlTransferParams, bufferOrReadLen);
          } catch (err) {
            throw new PhidgetError(ErrorCode.IO, "USB Control IN transfer failed", err);
          } finally {
            if (this.conn._usbType === 1) this.writelock.release();
          }
          if (descReq.status !== 'ok') throw new PhidgetError(ErrorCode.IO, "USB Control Transfer failure: " + descReq.status);
          if (descReq.data == undefined) throw new PhidgetError(ErrorCode.IO, "USB Control IN failed to read data");
          logbuffer("USB Control IN Packet", descReq.data);
          return descReq.data;
        }
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED);
    }
  }
  async readPacket() {
    let xfer;
    if (this.conn._usbType === 1) {
      try {
        await this.readlock.acquire();
        xfer = await this.usbDevice.transferIn(1, this.pusbParams.maxPacketEP1);
      } catch (err) {
        var _context;
        if (err instanceof Error && _includesInstanceProperty(_context = err.message).call(_context, 'LIBUSB_TRANSFER_TIMED_OUT')) throw new PhidgetError(ErrorCode.TIMEOUT, "Read timed out", err);
        throw new PhidgetError(ErrorCode.IO, "Error reading USB packet", err);
      } finally {
        this.readlock.release();
      }
    } else {
      try {
        xfer = await this.usbDevice.transferIn(1, this.pusbParams.maxPacketEP1);
      } catch (err) {
        throw new PhidgetError(ErrorCode.IO, "Error reading USB packet", err);
      }
    }
    if (xfer.status !== 'ok') throw new PhidgetError(ErrorCode.IO, "USB IN Transfer failure: " + xfer.status);
    if (xfer.data == undefined) throw new PhidgetError(ErrorCode.IO, "USB IN Transfer failed to read data");
    logbuffer("Received USB Packet", xfer.data);
    return xfer.data;
  }
  async readDescriptor(type, index) {
    let desc;
    try {
      if (this.conn._usbType === 1) await this.writelock.acquire();
      desc = await GetDescriptor(this.usbDevice, type, index, 0);
    } finally {
      if (this.conn._usbType === 1) this.writelock.release();
    }
    return desc;
  }
  getMaxOutPacketSize() {
    if (this.pusbParams.ep2type !== 0) return this.pusbParams.maxPacketEP2;
    return this.pusbParams.maxPacketEP0;
  }
  async writeLabel(label) {
    if (label.length > 10) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Label is too long. Max 10 characters.");
    if (label !== undefined || label !== null) {
      const bufftemp = new Uint8Array(StringToWordByteArray(label).buffer);
      const buffer = [0, 3, ..._valuesInstanceProperty(bufftemp).call(bufftemp)];
      buffer[0] = buffer.length;
      await this.transferPacket(4, 36, 0, new Uint8Array(buffer));
      this.label = label;
    }
  }
  async closeReset() {
    await this.transferPacket(4, 33, 0);
  }
  async openReset() {
    await this.transferPacket(4, 32, 0);
  }
  async rebootFirmwareUpgrade() {
    await this.transferPacket(4, 1, 0);
  }
  async lock() {
    await this.phidlock.acquire();
  }
  unlock() {
    this.phidlock.release();
  }
  _handleDataIntervalPacket(bp, interruptRate) {
    let __di = bp.getNumber(0);
    if (__di % interruptRate !== 0) {
      __di = (__di / interruptRate + 1) * interruptRate;
      bp.remove("0");
      bp.set({
        name: "0",
        type: "u",
        value: __di
      });
    }
    if (bp.entryCount > 1) bp.set({
      name: "1",
      type: "g",
      value: __di
    });
    return __di;
  }
}

const HUB_PORT_ID_MAX = 0x0F;
const VINTHUB_MAXPORTS = 6;
const PACKETID_MAX = 126;
const PACKETIDS_PER_PORT = PACKETID_MAX / 6;
const PACKETRETURN_notACK = 0x80;
const INPACKET_HUBMSG_FLAG = 0x80;
const IN_VINTPACKET_START = 0x08;
const UNKNOWN_VINT_ID = 0xff0;
class HubDevice extends PhidgetUSBDevice {
  constructor(conn, data, usbDev) {
    super(conn, data, usbDev);
    switch (this.devDef.uid) {
      case 217:
      case 219:
      case 220:
      case 226:
      case 218:
      case 221:
        this.numVintPorts = 6;
        break;
      case 222:
        this.numVintPorts = 1;
        break;
      default:
        throw new PhidgetError(ErrorCode.UNSUPPORTED);
    }
    this.numVintPortModes = 4;
    this.vintDevices = {};
    this.hubPortProps = [];
    this.outstandingPacketCnt = new Array(this.numVintPorts).fill(0);
    this.packetOutCounter = new Array(this.numVintPorts).fill(0);
    this.internalPacketInBufferLen = 0;
    this.packetCounter = -1;
    this.splitPacketStoragePtr = 0;
    this.splitPacketStorage = new Array(54).fill(0);
    this.scanError = 0;
    this.packetTrackers = new PacketTrackers();
  }
  async initAfterCreate() {
    for (let i = 0; i < this.numVintPorts; i++) await this.updatePortProperties(i);
  }
  makePacket(vintDevice, packetID, bufferIn) {
    const buffer = new Uint8Array(new ArrayBuffer(MAX_OUT_PACKET_SIZE));
    if (buffer.byteLength < this.getMaxOutPacketSize()) throw new PhidgetError(ErrorCode.UNEXPECTED);
    if (bufferIn == undefined) bufferIn = new Uint8Array(0);
    if (this.getMaxOutPacketSize() < bufferIn.length + 4) throw new PhidgetError(ErrorCode.UNEXPECTED);
    buffer.set([this.packetOutCounter[vintDevice.hubPort] << 4 & 0xF0 | vintDevice.hubPort & 0x0F], 0);
    buffer.set([vintDevice.vintID & 0xFF], 1);
    buffer.set([vintDevice.vintID >> 4 & 0xF0], 2);
    buffer.set([packetID], 3);
    buffer.set(bufferIn, 4);
    return buffer.slice(0, bufferIn.length + 4);
  }
  async openAndUpdatePortProperties(port) {
    try {
      await this.lock();
      let opened = false;
      try {
        await this.open(false);
        opened = true;
        await this.updatePortProperties(port);
      } finally {
        if (opened) await this.close(false, false);
      }
    } finally {
      this.unlock();
    }
  }
  async updatePortProperties(port) {
    let prop, propLen;
    const buf = await this.readDescriptor(69, port);
    const vintPortDesc = {
      bLength: buf.getUint8(0),
      bDescriptorType: buf.getUint8(1),
      bPortMode: buf.getUint8(2),
      bPowered: buf.getUint8(3),
      dwSpeedHz: buf.getUint32(4, true),
      bVINTProtocolVersion: buf.getUint8(8),
      VINTProperties: new DataView(buf.buffer, 9)
    };
    this.hubPortProps[port] = {
      portProto: vintPortDesc.bVINTProtocolVersion,
      portSpeed: vintPortDesc.dwSpeedHz,
      portMode: vintPortDesc.bPortMode,
      portPowered: !!vintPortDesc.bPowered,
      portSuppSetSpeed: false,
      portSuppAutoSetSpeed: false,
      portMaxSpeed: 100000
    };
    for (let i = 0; i < vintPortDesc.VINTProperties.byteLength; i += propLen) {
      prop = vintPortDesc.VINTProperties.getUint8(i) & 0x1F;
      propLen = ((vintPortDesc.VINTProperties.getUint8(i) & 0xE0) >> 5) + 1;
      switch (prop) {
        case 2:
          this.hubPortProps[port].portSuppSetSpeed = true;
          break;
        case 4:
          this.hubPortProps[port].portSuppAutoSetSpeed = true;
          break;
        case 3:
          this.hubPortProps[port].portMaxSpeed = vintPortDesc.VINTProperties.getUint32(i + 1, false);
          break;
        default:
          loginfo("Unknown VINT Port property: " + prop);
      }
    }
  }
  async sendHubPacket(hubPacketType, bufferIn) {
    await this.transferPacket(2, 64 | hubPacketType, 0, bufferIn);
  }
  async sendHubPortPacket(hubPort, hubPacketType, bufferIn) {
    await this.transferPacket(0, 64 | hubPacketType, hubPort, bufferIn);
  }
  processPacketReturnCodes(buffer, length) {
    let readPtr = 0;
    while (readPtr < length) {
      const packetID = buffer.getUint8(readPtr) & 0x7F;
      const port = Math.trunc((packetID - 1) / PACKETIDS_PER_PORT);
      let response = 224;
      if (buffer.getUint8(readPtr) & PACKETRETURN_notACK) {
        readPtr++;
        response = buffer.getUint8(readPtr);
      }
      readPtr++;
      const NotFound = () => {
        if (response !== 233) {
          loginfo("An unexpected PacketID was returned: " + packetID + "(" + response + " - " + VINTPacketDescription[response] + "). " + "Probably this packet is from a previous session or detached device.");
        }
        this.readInTXBufferCounts(port).catch(err => {
          logwarn("Failure to read TX Buffer counts", err);
        });
      };
      const packetTracker = this.packetTrackers.packetTracker.get(packetID);
      if (!packetTracker) {
        NotFound();
        continue;
      }
      const packetSpace = packetTracker.len;
      logverbose("Packet " + packetID + " response: " + response + " - " + VINTPacketDescription[response] + ", Port " + port);
      const res = VINTPacketCode_to_PhidgetReturnCode(response, packetTracker.devDef);
      try {
        packetTracker.setPacketReturnCode(res);
      } catch (err) {
        NotFound();
        continue;
      }
      this.releasePacketSpace(port, packetSpace);
      switch (res) {
        case ErrorCode.SUCCESS:
          break;
        case ErrorCode.NOT_CONFIGURED:
        case ErrorCode.INVALID_ARGUMENT:
        case ErrorCode.INVALID:
        case ErrorCode.INVALID_PACKET:
          break;
        case ErrorCode.FAILSAFE:
          break;
        case ErrorCode.NO_SPACE:
          logerr("Got a NOSPACE response from a VINT device, Port " + port + ". " + "This usually indicates firmware problems.");
          this.readInTXBufferCounts(port).catch(err => {
            logwarn("Failure to read TX Buffer counts", err);
          });
          break;
        case ErrorCode.NOT_ATTACHED:
          loginfo("Got a NOTATTACHED response from a VINT device, Port " + port);
          break;
        case ErrorCode.BUSY:
          logerr("Got a NAK response form a VINT device, Port " + port + ". " + "This means the device decided not to deal with this data; try again.");
          break;
        case ErrorCode.FILE_TOO_BIG:
          logerr("Got a TOOBIG response from a VINT device, Port " + port + ". " + "This means the packet was too big.");
          break;
        case ErrorCode.UNEXPECTED:
          logerr("Got an unexpected response from a VINT device: " + response + " - " + VINTPacketDescription[response] + ". " + "This usually indicates firmware problems.");
          break;
        default:
          switch (response) {
            case 240:
            case 241:
            case 242:
            case 243:
            case 244:
              break;
            default:
              logerr("Got an unexpected response from a VINT device: " + response + " - " + VINTPacketDescription[response] + ". " + "This usually indicates firmware problems.");
          }
          break;
      }
    }
  }
  processVintPacket(buffer) {
    const vintPort = buffer.getUint8(0) & 0x07;
    const vintID = ((buffer.getUint8(0) & 0xF0) << 4) + buffer.getUint8(1);
    const dataCount = buffer.getUint8(2) & 0x3F;
    let childIndex = vintPort;
    if (vintID <= HUB_PORT_ID_MAX) childIndex += vintID * this.numVintPorts;
    const vintDevice = this.vintDevices[childIndex];
    if (!vintDevice) return;
    if (vintDevice.vintID !== vintID) {
      loginfo("Seeing VINT Data on Port: " + vintPort + " for VINT Device: " + vintID + ", but device in structure is: " + vintDevice.vintID);
      return;
    }
    vintDevice.dataInput(new DataView(buffer.buffer, 2 + buffer.byteOffset, dataCount + 1));
  }
  async readInTXBufferCounts(port) {
    this.outstandingPacketCnt[port] = 18446744073709552000;
    await this.sendHubPacket(2);
  }
  async initAfterOpen() {
    let i;
    this.internalPacketInBufferLen = 18446744073709552000;
    for (i = 0; i < this.numVintPorts; i++) this.outstandingPacketCnt[i] = 18446744073709552000;
    this.packetCounter = -1;
    this.splitPacketStoragePtr = 0;
    const len = VINTHUB_MAXPORTS + 1;
    const buffer = await this.transferPacket(3, 64 | 2, 0, len);
    if (buffer.byteLength !== this.numVintPorts + 1) throw new PhidgetError(ErrorCode.UNEXPECTED, "Bad buffer length from transferpacket from HubDevice");
    this.internalPacketInBufferLen = buffer.getUint8(0);
    for (i = 0; i < this.numVintPorts; i++) {
      this.outstandingPacketCnt[i] = this.internalPacketInBufferLen - 1 - buffer.getUint8(i + 1);
    }
  }
  dataInput(buffer) {
    let dataCount;
    const packetCounter = buffer.getUint8(0) >> 4 & 0x07;
    const packetReturnLen = buffer.getUint8(0) & 0x0F;
    const dataEndIndex = buffer.byteLength - packetReturnLen;
    let nextPacketStart = buffer.getUint8(1) & 0x3F;
    let readPtr = 2;
    let killOutstandingPackets = false;
    this.processPacketReturnCodes(new DataView(buffer.buffer, dataEndIndex), buffer.byteLength - dataEndIndex);
    if (buffer.getUint8(1) & INPACKET_HUBMSG_FLAG) {
      switch (buffer.getUint8(readPtr)) {
        case 0:
          readPtr++;
          logdebug("VINTHUB_HUBINPACKET_TXBUFFERSTATUS packet filling outstandingPacketCnt");
          for (let i = 0; i < this.numVintPorts; i++) {
            this.outstandingPacketCnt[i] = this.internalPacketInBufferLen - 1 - buffer.getUint8(readPtr++);
          }
          break;
        case 1:
          readPtr++;
          for (let i = 0; i < this.numVintPorts; i++) {
            if (buffer.getUint8(readPtr) & 0x01 << i) {
              logwarn("Hub overcurrent detected on Port: " + i);
              const bp = new BridgePacket();
              bp.set({
                name: "0",
                type: "d",
                value: ErrorEventCode.OVER_CURRENT
              });
              bp.set({
                name: "1",
                type: "s",
                value: "Hub overcurrent detected on Port " + i + ". Check for short."
              });
              for (const v in this.vintDevices) {
                if (this.vintDevices[v].hubPort !== i) continue;
                for (const c in this.vintDevices[v].channels) {
                  const ch = this.vintDevices[v].channels[c];
                  if (ch.isopen) ch.sendErrorEvent(bp);
                }
              }
            }
          }
          readPtr++;
          break;
        case 2:
          readPtr++;
          for (let i = 0; i < this.numVintPorts; i++) {
            if (buffer.getUint8(readPtr) & 0x01 << i) {
              if (this.vintDevices[i]) {
                this.conn._deviceDetach(this.vintDevices[i]);
                delete this.vintDevices[i];
              }
            }
          }
          readPtr++;
          break;
        case 3:
          readPtr++;
          for (let i = 0; i < this.numVintPorts; i++) {
            if (buffer.getUint8(readPtr) & 0x01 << i) logwarn("Invalid VINT activity detected on Port: " + i + ". This can be safely ignored if something other than a VINT device is attached.");
          }
          readPtr++;
          break;
        case 4:
          readPtr++;
          for (let i = 0; i < this.numVintPorts; i++) {
            if (buffer.getUint8(readPtr) & 0x01 << i) {
              this.updatePortProperties(i).then(() => {
                loginfo("Hub Port Speed changed to: " + this.hubPortProps[i].portSpeed + " on Port: " + i + ".");
              }, err => {
                logwarn("Error updating port properties", err);
              });
            }
          }
          readPtr++;
          break;
        case 5:
          readPtr++;
          for (let i = 0; i < this.numVintPorts; i++) {
            if (buffer.getUint8(readPtr) & 0x01 << i) logwarn("Re-Enumeration on Port: " + i + ". This could indicate EMI issues, an unstable Hub Port Speed, or firmware issues.");
          }
          readPtr++;
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Got unexpected InPacketType: " + buffer.getUint8(readPtr));
      }
    }
    if (this.packetCounter === -1) {
      readPtr += nextPacketStart;
    } else {
      if (this.packetCounter !== packetCounter) {
        logwarn("One or more data packets were lost on the Hub.");
        this.splitPacketStoragePtr = 0;
        readPtr += nextPacketStart;
        killOutstandingPackets = true;
        this.sendHubPacket(2).catch(err => {
          logwarn("Error reading TX Buffer Status", err);
        });
      } else {
        if (nextPacketStart && !this.splitPacketStoragePtr) {
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Problem with split data in vint packet. This should be a firmware/library bug.");
        }
      }
    }
    this.packetCounter = packetCounter + 1 & 0x07;
    if (this.splitPacketStoragePtr) {
      while (nextPacketStart--) this.splitPacketStorage[this.splitPacketStoragePtr++] = buffer.getUint8(readPtr++);
      this.processVintPacket(new DataView(new Uint8Array(this.splitPacketStorage).buffer));
      this.splitPacketStoragePtr = 0;
    }
    while (readPtr < dataEndIndex) {
      if ((buffer.getUint8(readPtr) & IN_VINTPACKET_START) === 0x00) break;
      if (readPtr < dataEndIndex - 2) {
        if (buffer.getUint8(readPtr + 2) & 0x80) {
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Got an unexpected MSG in vint data: " + buffer.getUint8(readPtr + 2));
        }
        dataCount = buffer.getUint8(readPtr + 2) & 0x3F;
        if (readPtr + 3 + dataCount <= dataEndIndex) {
          this.processVintPacket(new DataView(buffer.buffer, readPtr));
          readPtr += dataCount + 3;
          continue;
        }
      }
      while (readPtr < dataEndIndex) this.splitPacketStorage[this.splitPacketStoragePtr++] = buffer.getUint8(readPtr++);
    }
    if (killOutstandingPackets) {
      loginfo("Killing outstanding packets on hub");
      for (let i = 0; i < this.numVintPorts; i++) {
        if (this.outstandingPacketCnt[i]) this.outstandingPacketCnt[i] = 18446744073709552000;
        this.packetTrackers.setPacketsReturnCode(i, ErrorCode.INTERRUPTED);
      }
    }
  }
  async bridgeInput(_channel, bp) {
    switch (bp.vpkt) {
      case 60:
        {
          const hubPort = bp.getNumber(0);
          const timeout = bp.getNumber(1);
          const buffer = new Uint8Array([timeout & 0xFF, timeout >> 8 & 0xFF]);
          await this.sendHubPortPacket(hubPort, 1, buffer);
          break;
        }
      case 72:
        {
          const hubPort = bp.getNumber(0);
          await this.setPortMode(hubPort, bp.getNumber(1));
          break;
        }
      case 73:
        {
          const hubPort = bp.getNumber(0);
          const buffer = new Uint8Array([bp.getNumber(1)]);
          await this.sendHubPortPacket(hubPort, 3, buffer);
          break;
        }
      case 107:
        throw new PhidgetError(ErrorCode.UNSUPPORTED);
      case 34:
      case 111:
      case 143:
        break;
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type");
    }
  }
  async setPortMode(index, newVal) {
    if (!this.opened) throw new PhidgetError(ErrorCode.NOT_ATTACHED);
    const buffer = new Uint8Array([newVal]);
    logdebug("Setting Port: " + index + " mode to " + newVal + " on " + this.name);
    await this.sendHubPortPacket(index, 0, buffer);
  }
  releasePacketSpace(hubPort, packetSize) {
    if (this.outstandingPacketCnt[hubPort] !== 18446744073709552000) {
      if (this.outstandingPacketCnt[hubPort] < packetSize) this.outstandingPacketCnt[hubPort] = 0;else this.outstandingPacketCnt[hubPort] -= packetSize;
      if (this.outstandingPacketCnt[hubPort] > this.internalPacketInBufferLen) throw new PhidgetError(ErrorCode.UNEXPECTED, "PacketSpace is out of spec");
      logverbose("Releasing " + packetSize + " bytes, " + (this.internalPacketInBufferLen - this.outstandingPacketCnt[hubPort]) + " remaining, Port " + hubPort);
    }
  }
  async claimPacketSpace(hubPort, packetSize) {
    if (!this.opened) throw new PhidgetError(ErrorCode.NOT_ATTACHED);
    const tm = Date.now() + 2000;
    for (;;) {
      const pktCnt = this.outstandingPacketCnt[hubPort];
      if (pktCnt !== 18446744073709552000 && pktCnt + packetSize < this.internalPacketInBufferLen) break;
      if (Date.now() >= tm) throw new PhidgetError(ErrorCode.TIMEOUT, "Timed out claiming packet space, Port " + hubPort);
      await PhidgetSleep(2);
    }
    this.outstandingPacketCnt[hubPort] += packetSize;
    logverbose("Claiming " + packetSize + " bytes, " + (this.internalPacketInBufferLen - this.outstandingPacketCnt[hubPort]) + " remaining, Port " + hubPort);
  }
  async scanVINTDevice(childIndex, id, version, port, realID) {
    var _a;
    let vintDeviceDesc;
    let buf;
    let prop, propLen;
    for (const dev of PhidgetDevices.VINT) {
      if (dev.i !== id) continue;
      if (version >= dev.v[1] || version < dev.v[0]) continue;
      const vint = this.vintDevices[childIndex];
      if (vint) {
        if (vint.devDef === dev && vint.version === version) return;
        this.conn._deviceDetach(vint);
        delete this.vintDevices[childIndex];
      }
      const data = {
        vintProto: 255,
        suppSetSpeed: false,
        suppAutoSetSpeed: false,
        maxSpeed: 4294967295,
        commSpeed: 4294967295,
        hubPort: port,
        isHubPort: id <= HUB_PORT_ID_MAX,
        uniqueIndex: childIndex
      };
      if (id > HUB_PORT_ID_MAX) {
        try {
          buf = await this.readDescriptor(68, port);
          vintDeviceDesc = {
            bLength: buf.getUint8(0),
            bDescriptorType: buf.getUint8(1),
            wID: buf.getUint16(2),
            wVersion: buf.getUint16(4, true),
            bVINTProtocolVersion: buf.getUint8(6),
            VINTProperties: new DataView(buf.buffer, 7)
          };
          data.vintProto = vintDeviceDesc.bVINTProtocolVersion;
          for (let i = 0; i < vintDeviceDesc.VINTProperties.byteLength; i += propLen) {
            prop = vintDeviceDesc.VINTProperties.getUint8(i) & 0x1F;
            propLen = ((vintDeviceDesc.VINTProperties.getUint8(i) & 0xE0) >> 5) + 1;
            switch (prop) {
              case 0:
              case 1:
                break;
              case 2:
                data.suppSetSpeed = true;
                break;
              case 4:
                data.suppAutoSetSpeed = true;
                break;
              case 3:
                data.maxSpeed = vintDeviceDesc.VINTProperties.getUint32(i + 1, false);
                break;
              default:
                loginfo("Unknown VINT Device Property: " + vintDeviceDesc.VINTProperties.getUint8(i));
                break;
            }
          }
          await this.updatePortProperties(port);
        } catch (err) {
          logwarn("Couldn't read VINT Device descriptor from a Hub", err);
        }
      }
      data.commSpeed = (_a = this.hubPortProps[port].portSpeed) !== null && _a !== void 0 ? _a : 4294967295;
      const vintData = {
        type: 'VINT',
        version: version,
        label: this.label,
        serialNumber: this.serialNumber,
        devDef: dev,
        fwstr: dev.s,
        id: this.devDef.uid + "_" + this.serialNumber + '_' + port + '_' + dev.uid,
        parent: this,
        vintDeviceProps: data
      };
      const vintDev = new VINTDevice(this.conn, vintData);
      this.vintDevices[vintDev.index] = vintDev;
      this.conn._attachLocalDevice(vintDev);
      if (id === UNKNOWN_VINT_ID) logwarn("A VINT Phidget (ID: " + realID + " Version: " + version + " HubPort: " + port + ") was found which is not supported by the library. A library upgrade is required to work with this Phidget.");
      return;
    }
    await this.scanVINTDevice(childIndex, UNKNOWN_VINT_ID, version, port, id);
  }
  async scanVINTDevices() {
    let i, j, childIndex;
    let deviceID;
    let version;
    let buf = await this.readDescriptor(67, 0);
    const len = buf.byteLength;
    buf = new DataView(buf.buffer.slice(2));
    if (len !== this.numVintPorts * 4 + this.numVintPortModes * 4 + 2) {
      throw new PhidgetError(ErrorCode.UNEXPECTED, "Wrong VINT Ports descriptor length from Hub: " + len + "/" + (this.numVintPorts * 4 + this.numVintPortModes * 4 + 2));
    }
    for (childIndex = 0, i = 0; i < this.numVintPorts; i++) {
      deviceID = buf.getUint16(0, true);
      version = buf.getUint8(3) * 100 + buf.getUint8(2);
      buf = new DataView(buf.buffer.slice(4));
      if (deviceID > HUB_PORT_ID_MAX) {
        await this.scanVINTDevice(childIndex, deviceID, version, i);
      } else {
        if (this.vintDevices[childIndex]) {
          this.conn._deviceDetach(this.vintDevices[childIndex]);
          delete this.vintDevices[childIndex];
        }
      }
      childIndex++;
      if (deviceID > HubPortMode.VINT && deviceID <= HUB_PORT_ID_MAX) await this.resetVINTPortModeIfNeeded(i, deviceID);
    }
    for (j = 0; j < this.numVintPortModes; j++) {
      deviceID = buf.getUint16(0, true);
      version = buf.getUint8(3) * 100 + buf.getUint8(2);
      buf = new DataView(buf.buffer.slice(4));
      for (i = 0; i < this.numVintPorts; i++) await this.scanVINTDevice(childIndex++, deviceID, version, i);
    }
  }
  async resetVINTPortModeIfNeeded(port, mode) {
    if (mode === HubPortMode.VINT) return;
    for (const userphid of UserPhidgets) {
      if (userphid._isattached) continue;
      if (userphid._hubPort !== port) continue;
      if (userphid._isHubPort) continue;
      if (userphid._serialNumber === Phidget.ANY_SERIAL_NUMBER && userphid._deviceLabel === Phidget.ANY_LABEL) continue;
      if (userphid._serialNumber !== Phidget.ANY_SERIAL_NUMBER) {
        if (userphid._serialNumber !== this.serialNumber) continue;
      }
      if (userphid._deviceLabel !== Phidget.ANY_LABEL) {
        if (userphid._deviceLabel !== this.label) continue;
      }
      let opened = false;
      try {
        await this.open();
        opened = true;
        await this.setPortMode(port, HubPortMode.VINT);
      } finally {
        if (opened) await this.close();
      }
    }
  }
}

/** @internal */
function getVINTIO(uid) {
  switch (uid) {
    case 22:
      return {
        send: send1014_3_VINT,
        recv: recv1014_3_VINT
      };
    case 27:
      return {
        send: send1017_2_VINT,
        recv: recv1017_2_VINT
      };
    case 36:
      return {
        send: send1024_1_VINT,
        recv: recv1024_1_VINT
      };
    case 38:
      return {
        send: send1024_1_310_VINT,
        recv: recv1024_1_310_VINT
      };
    case 40:
      return {
        send: send1024_1_320_VINT,
        recv: recv1024_1_320_VINT
      };
    case 98:
      return {
        send: sendDIGITALINPUT_PORT,
        recv: recvDIGITALINPUT_PORT
      };
    case 99:
      return {
        send: sendDIGITALOUTPUT_PORT,
        recv: recvDIGITALOUTPUT_PORT
      };
    case 100:
      return {
        send: sendDIGITALOUTPUT_PORT_FAILSAFE,
        recv: recvDIGITALOUTPUT_PORT_FAILSAFE
      };
    case 101:
      return {
        send: sendVOLTAGEINPUT_PORT,
        recv: recvVOLTAGEINPUT_PORT
      };
    case 102:
      return {
        send: sendVOLTAGEINPUT_PORT_5V25,
        recv: recvVOLTAGEINPUT_PORT_5V25
      };
    case 103:
      return {
        send: sendVOLTAGEINPUT_PORT_V2,
        recv: recvVOLTAGEINPUT_PORT_V2
      };
    case 104:
      return {
        send: sendVOLTAGERATIOINPUT_PORT,
        recv: recvVOLTAGERATIOINPUT_PORT
      };
    case 105:
      return {
        send: sendVOLTAGERATIOINPUT_PORT_V2,
        recv: recvVOLTAGERATIOINPUT_PORT_V2
      };
    case 106:
      return {
        send: sendADP1000,
        recv: recvADP1000
      };
    case 108:
      return {
        send: sendADP0001_VINT,
        recv: recvADP0001_VINT
      };
    case 110:
      return {
        send: sendADP0002_VINT,
        recv: recvADP0002_VINT
      };
    case 112:
      return {
        send: sendLED0100_VINT,
        recv: recvLED0100_VINT
      };
    case 113:
      return {
        send: sendDAQ1000,
        recv: recvDAQ1000
      };
    case 114:
      return {
        send: sendDAQ1000_5V25,
        recv: recvDAQ1000_5V25
      };
    case 116:
      return {
        send: sendOUT1000,
        recv: recvOUT1000
      };
    case 117:
      return {
        send: sendOUT1000_Failsafe,
        recv: recvOUT1000_Failsafe
      };
    case 118:
      return {
        send: sendOUT1001,
        recv: recvOUT1001
      };
    case 119:
      return {
        send: sendOUT1001_Failsafe,
        recv: recvOUT1001_Failsafe
      };
    case 120:
      return {
        send: sendOUT1002,
        recv: recvOUT1002
      };
    case 121:
      return {
        send: sendOUT1002_Failsafe,
        recv: recvOUT1002_Failsafe
      };
    case 124:
      return {
        send: sendDAQ1200,
        recv: recvDAQ1200
      };
    case 125:
      return {
        send: sendOUT1100,
        recv: recvOUT1100
      };
    case 126:
      return {
        send: sendOUT1100_Failsafe,
        recv: recvOUT1100_Failsafe
      };
    case 127:
      return {
        send: sendOUT1100_Failsafe_Frequency,
        recv: recvOUT1100_Failsafe_Frequency
      };
    case 128:
      return {
        send: sendDAQ1300,
        recv: recvDAQ1300
      };
    case 129:
      return {
        send: sendDAQ1301,
        recv: recvDAQ1301
      };
    case 130:
      return {
        send: sendDAQ1400,
        recv: recvDAQ1400
      };
    case 131:
      return {
        send: sendDAQ1400_120,
        recv: recvDAQ1400_120
      };
    case 132:
      return {
        send: sendDAQ1400_130,
        recv: recvDAQ1400_130
      };
    case 133:
      return {
        send: sendDAQ1500,
        recv: recvDAQ1500
      };
    case 134:
      return {
        send: sendVCP1100,
        recv: recvVCP1100
      };
    case 135:
      return {
        send: sendDCC1000,
        recv: recvDCC1000
      };
    case 136:
      return {
        send: sendDCC1000_POSITIONCONTROL,
        recv: recvDCC1000_POSITIONCONTROL
      };
    case 137:
      return {
        send: sendDCC1000_POSITIONCONTROL_FAILSAFE,
        recv: recvDCC1000_POSITIONCONTROL_FAILSAFE
      };
    case 138:
      return {
        send: sendDCC1020,
        recv: recvDCC1020
      };
    case 140:
      return {
        send: sendDCC1001,
        recv: recvDCC1001
      };
    case 141:
      return {
        send: sendDCC1001_Failsafe,
        recv: recvDCC1001_Failsafe
      };
    case 142:
      return {
        send: sendDCC1002,
        recv: recvDCC1002
      };
    case 143:
      return {
        send: sendDCC1002_Failsafe,
        recv: recvDCC1002_Failsafe
      };
    case 144:
      return {
        send: sendDCC1003,
        recv: recvDCC1003
      };
    case 145:
      return {
        send: sendDCC1003_Failsafe,
        recv: recvDCC1003_Failsafe
      };
    case 146:
      return {
        send: sendDCC1100,
        recv: recvDCC1100
      };
    case 147:
      return {
        send: sendDCC1100_Failsafe,
        recv: recvDCC1100_Failsafe
      };
    case 149:
      return {
        send: sendDCC1120,
        recv: recvDCC1120
      };
    case 151:
      return {
        send: sendDST1000,
        recv: recvDST1000
      };
    case 152:
      return {
        send: sendDST1001,
        recv: recvDST1001
      };
    case 153:
      return {
        send: sendDST1002,
        recv: recvDST1002
      };
    case 154:
      return {
        send: sendDST1200,
        recv: recvDST1200
      };
    case 155:
      return {
        send: sendENC1000,
        recv: recvENC1000
      };
    case 156:
      return {
        send: sendENC1001,
        recv: recvENC1001
      };
    case 157:
      return {
        send: sendHIN1101,
        recv: recvHIN1101
      };
    case 158:
      return {
        send: sendHIN1000,
        recv: recvHIN1000
      };
    case 159:
      return {
        send: sendHIN1001,
        recv: recvHIN1001
      };
    case 160:
      return {
        send: sendHIN1100,
        recv: recvHIN1100
      };
    case 161:
      return {
        send: sendHUM1000,
        recv: recvHUM1000
      };
    case 162:
      return {
        send: sendHUM1001,
        recv: recvHUM1001
      };
    case 163:
      return {
        send: sendLCD1100,
        recv: recvLCD1100
      };
    case 164:
      return {
        send: sendLCD1100_1,
        recv: recvLCD1100_1
      };
    case 165:
      return {
        send: sendLED1000,
        recv: recvLED1000
      };
    case 166:
      return {
        send: sendLUX1000,
        recv: recvLUX1000
      };
    case 167:
      return {
        send: sendHUM1100,
        recv: recvHUM1100
      };
    case 168:
      return {
        send: sendMOT1100,
        recv: recvMOT1100
      };
    case 170:
      return {
        send: sendMOT0100_VINT,
        recv: recvMOT0100_VINT
      };
    case 171:
      return {
        send: sendMOT1101,
        recv: recvMOT1101
      };
    case 172:
      return {
        send: sendMOT1102,
        recv: recvMOT1102
      };
    case 173:
      return {
        send: sendMOT1102_1,
        recv: recvMOT1102_1
      };
    case 176:
      return {
        send: sendMOT0110_VINT,
        recv: recvMOT0110_VINT
      };
    case 177:
      return {
        send: sendPRE1000,
        recv: recvPRE1000
      };
    case 178:
      return {
        send: sendRCC1000,
        recv: recvRCC1000
      };
    case 179:
      return {
        send: sendRCC1000_Failsafe,
        recv: recvRCC1000_Failsafe
      };
    case 180:
      return {
        send: sendRCC1000_1,
        recv: recvRCC1000_1
      };
    case 181:
      return {
        send: sendREL1000,
        recv: recvREL1000
      };
    case 182:
      return {
        send: sendREL1000_Failsafe,
        recv: recvREL1000_Failsafe
      };
    case 183:
      return {
        send: sendREL1100,
        recv: recvREL1100
      };
    case 184:
      return {
        send: sendREL1100_Failsafe,
        recv: recvREL1100_Failsafe
      };
    case 185:
      return {
        send: sendREL1100_Failsafe_Frequency,
        recv: recvREL1100_Failsafe_Frequency
      };
    case 186:
      return {
        send: sendREL1101,
        recv: recvREL1101
      };
    case 187:
      return {
        send: sendREL1101_Failsafe,
        recv: recvREL1101_Failsafe
      };
    case 188:
      return {
        send: sendREL1101_1,
        recv: recvREL1101_1
      };
    case 190:
      return {
        send: sendSAF1000,
        recv: recvSAF1000
      };
    case 191:
      return {
        send: sendSAF1000_Failsafe,
        recv: recvSAF1000_Failsafe
      };
    case 192:
      return {
        send: sendSND1000,
        recv: recvSND1000
      };
    case 193:
      return {
        send: sendSTC1000,
        recv: recvSTC1000
      };
    case 194:
      return {
        send: sendSTC1000_Failsafe,
        recv: recvSTC1000_Failsafe
      };
    case 195:
      return {
        send: sendSTC1001,
        recv: recvSTC1001
      };
    case 196:
      return {
        send: sendSTC1001_Failsafe,
        recv: recvSTC1001_Failsafe
      };
    case 197:
      return {
        send: sendSTC1002,
        recv: recvSTC1002
      };
    case 198:
      return {
        send: sendSTC1002_Failsafe,
        recv: recvSTC1002_Failsafe
      };
    case 199:
      return {
        send: sendSTC1003,
        recv: recvSTC1003
      };
    case 200:
      return {
        send: sendSTC1003_Failsafe,
        recv: recvSTC1003_Failsafe
      };
    case 201:
      return {
        send: sendSTC1003_1,
        recv: recvSTC1003_1
      };
    case 202:
      return {
        send: sendSTC1005_0,
        recv: recvSTC1005_0
      };
    case 203:
      return {
        send: sendSTC1005_0_110,
        recv: recvSTC1005_0_110
      };
    case 204:
      return {
        send: sendTMP1000,
        recv: recvTMP1000
      };
    case 205:
      return {
        send: sendTMP1100,
        recv: recvTMP1100
      };
    case 206:
      return {
        send: sendTMP1101,
        recv: recvTMP1101
      };
    case 207:
      return {
        send: sendTMP1101_1,
        recv: recvTMP1101_1
      };
    case 208:
      return {
        send: sendTMP1200,
        recv: recvTMP1200
      };
    case 209:
      return {
        send: sendTMP1200_1,
        recv: recvTMP1200_1
      };
    case 211:
      return {
        send: sendVCP1000,
        recv: recvVCP1000
      };
    case 212:
      return {
        send: sendVCP1001,
        recv: recvVCP1001
      };
    case 213:
      return {
        send: sendVCP1001_110,
        recv: recvVCP1001_110
      };
    case 214:
      return {
        send: sendVCP1002,
        recv: recvVCP1002
      };
    case 215:
      return {
        send: sendVCP1002_110,
        recv: recvVCP1002_110
      };
    case 232:
      return {
        send: sendFIRMWARE_UPGRADE_STM32F0,
        recv: recvFIRMWARE_UPGRADE_STM32F0
      };
    case 233:
      return {
        send: sendFIRMWARE_UPGRADE_STM32G0_BLBug,
        recv: recvFIRMWARE_UPGRADE_STM32G0_BLBug
      };
    case 234:
      return {
        send: sendFIRMWARE_UPGRADE_STM32G0,
        recv: recvFIRMWARE_UPGRADE_STM32G0
      };
    case 235:
      return {
        send: sendFIRMWARE_UPGRADE_STM32F3,
        recv: recvFIRMWARE_UPGRADE_STM32F3
      };
    case 236:
      return {
        send: sendFIRMWARE_UPGRADE_STM32F0v2,
        recv: recvFIRMWARE_UPGRADE_STM32F0v2
      };
    case 237:
      return {
        send: sendFIRMWARE_UPGRADE_STM8S,
        recv: recvFIRMWARE_UPGRADE_STM8S
      };
    case 245:
      return {
        send: sendUNKNOWNVINT,
        recv: recvUNKNOWNVINT
      };
    default:
      throw new PhidgetError(ErrorCode.UNSUPPORTED);
  }
}

const VINT_DATA_wCHANNEL = 0x40;
const NUM_VINT_SUPPORTED_SPEEDS = 10;
const supportedSpeeds = [10000, 25000, 50000, 100000, 160000, 250000, 400000, 500000, 800000, 1000000];
class VINTDevice extends LocalDevice {
  constructor(conn, data) {
    super(conn, data);
    const io = getVINTIO(this.devDef.uid);
    if (io == undefined) throw new Error("Invalid VINT Device UID");
    this.vintIO = io;
    this.opened = false;
    this.openCnt = 0;
  }
  async open() {
    if (!this.opened) {
      this.openCnt = 0;
      await this.parent.open();
      this.opened = true;
    }
    this.openCnt++;
  }
  async close() {
    let force = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (!this.opened) return;
    if (force) this.openCnt = 1;
    this.openCnt--;
    if (this.openCnt > 0) {
      logdebug("Leaving VINT device open, as open count is: " + this.openCnt);
      return;
    }
    this.opened = false;
    this.openCnt = 0;
    await this.parent.close();
  }
  async lock() {
    await this.parent.lock();
  }
  unlock() {
    this.parent.unlock();
  }
  async bridgeInput(channel, bp) {
    if (!channel.userphid) return;
    const hub = this.parent;
    switch (bp.vpkt) {
      case 111:
        await channel.sendVINTDataPacket(250);
        await hub.setPortMode(this.hubPort, HubPortMode.VINT);
        await hub.packetTrackers.waitForPendingPackets(this.hubPort);
        break;
      case 34:
        {
          let portMode = HubPortMode.VINT;
          if (channel.isHubPort) {
            switch (channel.class) {
              case ChannelClass.DIGITAL_INPUT:
                portMode = HubPortMode.DIGITAL_INPUT;
                break;
              case ChannelClass.DIGITAL_OUTPUT:
                portMode = HubPortMode.DIGITAL_OUTPUT;
                break;
              case ChannelClass.VOLTAGE_INPUT:
                portMode = HubPortMode.VOLTAGE_INPUT;
                break;
              case ChannelClass.VOLTAGE_RATIO_INPUT:
                portMode = HubPortMode.VOLTAGE_RATIO_INPUT;
                break;
            }
          }
          await hub.setPortMode(channel.parent.hubPort, portMode);
          if (!channel.persistence) await channel.sendVINTDataPacket(250);
          break;
        }
      case 143:
        await channel.sendVINTDataPacket(251);
        break;
      default:
        await this.vintIO.send(channel, bp);
        break;
    }
  }
  dataInput(buffer) {
    let channelIndex;
    let readPtr;
    let dataCount;
    if (buffer.getUint8(0) & VINT_DATA_wCHANNEL) {
      dataCount = (buffer.getUint8(0) & 0x3F) - 1;
      channelIndex = buffer.getUint8(1);
      readPtr = 2;
    } else {
      dataCount = buffer.getUint8(0) & 0x3F;
      channelIndex = 0;
      readPtr = 1;
    }
    const vintChannel = this.getChannel(channelIndex);
    if (!vintChannel) return;
    this.vintIO.recv(vintChannel, new DataView(buffer.buffer, readPtr + buffer.byteOffset, dataCount));
  }
  makePacket(vintChannel, deviceCommand, devicePacketType, bufferIn) {
    const buffer = new Uint8Array(new ArrayBuffer(MAX_OUT_PACKET_SIZE));
    let bufIndex = 0;
    if (bufferIn == undefined) bufferIn = new Uint8Array(0);
    switch (deviceCommand) {
      case 0:
        if (vintChannel.uniqueIndex) {
          buffer.set([VINT_DATA_wCHANNEL | bufferIn.length + 2], bufIndex++);
          buffer.set([vintChannel.uniqueIndex], bufIndex++);
          buffer.set([devicePacketType], bufIndex++);
        } else {
          buffer.set([bufferIn.length + 1], bufIndex++);
          buffer.set([devicePacketType], bufIndex++);
        }
        if (bufferIn) buffer.set(bufferIn, bufIndex);
        break;
      case 131:
      case 139:
      case 140:
        buffer.set([deviceCommand], bufIndex++);
        break;
      case 143:
        if (bufferIn.length !== 4) throw new PhidgetError(ErrorCode.UNEXPECTED);
        buffer.set([deviceCommand], bufIndex++);
        buffer.set(bufferIn, bufIndex);
        break;
      default:
        throw new PhidgetError(ErrorCode.INVALID_PACKET);
    }
    return buffer.slice(0, bufIndex + bufferIn.length);
  }
  async sendpacket(bufferIn) {
    if (bufferIn.length > MAX_OUT_PACKET_SIZE) throw new PhidgetError(ErrorCode.UNEXPECTED, "BufferIn length too big in sendpacket");
    const hubDevice = this.parent;
    const tracker = await hubDevice.packetTrackers.getPacketTrackerWait(hubDevice, this.hubPort * PACKETIDS_PER_PORT + 1, (this.hubPort + 1) * PACKETIDS_PER_PORT, this.hubPort, 500);
    logverbose("Claimed Hub packet ID " + tracker.id + ", Port " + this.hubPort);
    try {
      const buffer = hubDevice.makePacket(this, tracker.id, bufferIn);
      await hubDevice.claimPacketSpace(this.hubPort, buffer.byteLength);
      tracker.pt.setPacketLength(buffer.byteLength);
      tracker.pt.setPacketDevice(this.devDef);
      await this.sendpacketWithTracking(buffer, tracker.pt);
      tracker.pt.releasePacketTracker(false);
      hubDevice.packetOutCounter[this.hubPort]++;
      logverbose("Packet " + tracker.id + " send successfully, Port " + this.hubPort);
    } catch (err) {
      logverbose("Packet " + tracker.id + " failed, Port " + this.hubPort, err);
      tracker.pt.releasePacketTracker(true);
      throw err;
    }
  }
  async sendpacketWithTracking(buf, packetTracker) {
    if (packetTracker.signalled) {
      if (packetTracker.returnCode != ErrorCode.SUCCESS) throw new PhidgetError(packetTracker.returnCode);
      return;
    }
    await this.parent.transferPacket(6, 0, 0, buf);
    packetTracker.sent = true;
    const res = await packetTracker.waitForPendingPacket(1000);
    if (res != ErrorCode.SUCCESS) throw new PhidgetError(res);
  }
  async setHubPortSpeed(vintChannel, speed) {
    let i;
    const hubPortProps = this.parent.hubPortProps[this.hubPort];
    if (hubPortProps.portProto === 255 || this.vintDeviceProps.vintProto < 2 || this.vintDeviceProps.vintProto === 255 || this.vintDeviceProps.vintProto < 2) {
      throw new PhidgetError(ErrorCode.UNSUPPORTED, "VINT Port and Device must support VINT2 protocol.");
    }
    if (!hubPortProps.portSuppSetSpeed) {
      throw new PhidgetError(ErrorCode.UNSUPPORTED, "VINT Port does not support High Speed.");
    }
    if (speed === Phidget.AUTO_HUBPORTSPEED && !hubPortProps.portSuppAutoSetSpeed) {
      throw new PhidgetError(ErrorCode.UNSUPPORTED, "VINT Port does not support Auto Set Speed.");
    }
    if (!this.vintDeviceProps.suppSetSpeed) {
      throw new PhidgetError(ErrorCode.UNSUPPORTED, "VINT Device does not support High Speed.");
    }
    if (speed === Phidget.AUTO_HUBPORTSPEED && !this.vintDeviceProps.suppAutoSetSpeed) {
      throw new PhidgetError(ErrorCode.UNSUPPORTED, "VINT Device does not support Auto Set Speed.");
    }
    if (speed > hubPortProps.portMaxSpeed) {
      throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Speed must be <= Port max speed of: " + hubPortProps.portMaxSpeed + "Hz.");
    }
    if (speed > this.vintDeviceProps.maxSpeed) {
      throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Speed must be <= Device max speed of: " + this.vintDeviceProps.maxSpeed + "Hz.");
    }
    if (speed !== Phidget.AUTO_HUBPORTSPEED) {
      for (i = NUM_VINT_SUPPORTED_SPEEDS - 1; i >= 0; i--) {
        if (speed >= supportedSpeeds[i]) {
          break;
        }
      }
      if (speed !== supportedSpeeds[i]) {
        loginfo("Requested VINT speed of " + speed + "HZ is not supported.  Setting nearest lower speed of " + supportedSpeeds[i] + "Hz instead.");
      }
      speed = supportedSpeeds[i];
    }
    const buf = new DataView(new ArrayBuffer(4));
    buf.setUint32(0, speed);
    await vintChannel.sendVINTPacket(143, 0, new Uint8Array(buf.buffer));
    this.vintDeviceProps.commSpeed = speed;
    for (let i = 0; i < PHIDGET_MAXCHANNELS; i++) {
      const ch = this.getChannel(i);
      if (ch != undefined && ch !== vintChannel) {
        const bp = new BridgePacket();
        bp.set({
          name: '0',
          type: 'u',
          value: this.vintDeviceProps.commSpeed
        });
        bp.sendToChannel(ch, 176);
      }
    }
  }
  async reboot(vintChannel) {
    await vintChannel.sendVINTPacket(131);
  }
  async rebootFirmwareUpgrade(vintChannel, timeout) {
    const hubDevice = this.parent;
    const buffer = new Uint8Array([timeout & 0xFF, timeout >> 8 & 0xFF]);
    await hubDevice.sendHubPortPacket(this.hubPort, 1, buffer);
    await vintChannel.sendVINTPacket(131);
  }
}

/** @internal */
class LocalChannel extends Channel {
  constructor(conn, dev, data) {
    super(conn, dev, data);
    this.name = this.chDef.t;
    this.class = this.chDef.c;
  }
  async open(userphid) {
    var _a;
    const dev = this.parent;
    if (dev instanceof VINTDevice) {
      for (const ch of _valuesInstanceProperty(_context = this.conn._channels).call(_context)) {
        var _context;
        if (ch.parent == dev) continue;
        if (!ch.isopen) continue;
        if (ch.parent.parentId === dev.parentId && ch.parent.hubPort === dev.hubPort) {
          throw new PhidgetError(ErrorCode.BUSY, "Failed to open Channel " + this + " on local device: " + dev + " because Channel: " + ch + " is opened on the same Hub Port, and these channels are mutually exclusive.");
        }
      }
    }
    if (this.chDef.e != undefined) {
      for (const c in this.parent.channels) {
        const ch = this.parent.channels[c];
        if (ch === this) continue;
        if (!ch.isopen) continue;
        if (ch.index === this.index && ch.chDef.e === this.chDef.e) {
          throw new PhidgetError(ErrorCode.BUSY, "Failed to open Channel " + this + " on local device: " + dev + " because Channel: " + ch + " is opened, and these channels are mutually exclusive.");
        }
      }
    }
    this.persistence = userphid._persistence;
    userphid._attaching = true;
    let opened = false;
    try {
      await dev.lock();
      await dev.open();
      opened = true;
      this.isopen = true;
      this.userphid = userphid;
      userphid._ch = this;
      userphid._isattached = true;
      userphid._initAfterOpen();
      userphid._isopen = true;
    } catch (err) {
      try {
        if (opened) await dev.close();
      } finally {
        userphid._attaching = false;
        userphid._isattached = false;
        userphid._isopen = false;
        this.isopen = false;
      }
      throw err;
    } finally {
      dev.unlock();
    }
    try {
      const bp = new BridgePacket();
      if (this.parent.class === DeviceClass.VINT || !this.persistence) await bp.send(this, 34, false);
      if (!this.persistence) await userphid._setDefaults();
      if (userphid.onAttach) {
        try {
          await userphid.onAttach(userphid);
        } catch (err) {
          logEventException(err);
        }
      }
      await bp.send(this, 143, false);
      userphid._fireInitialEvents();
      userphid._attaching = false;
      if (userphid._hasInitialState()) {
        userphid._cancelOpenTimeout();
        (_a = userphid._resolveOpen) === null || _a === void 0 ? void 0 : _a.call(userphid);
      } else {
        userphid._onInitialState = () => {
          var _a;
          userphid._cancelOpenTimeout();
          (_a = userphid._resolveOpen) === null || _a === void 0 ? void 0 : _a.call(userphid);
          delete userphid._onInitialState;
        };
        let remaining = 500;
        if (userphid._openTimeout != undefined && userphid._openTime !== undefined) remaining = userphid._openTimeout - (tm() - userphid._openTime);
        if (remaining > 2500) remaining = 2500;
        if (remaining < 500) remaining = 500;
        setTimeout(() => {
          if (userphid._onInitialState) userphid._onInitialState();
        }, remaining);
      }
    } catch (err) {
      try {
        await dev.lock();
        await dev.close();
      } finally {
        dev.unlock();
        userphid._attaching = false;
        userphid._isattached = false;
        userphid._isopen = false;
        this.isopen = false;
      }
      throw err;
    }
  }
  async close() {
    if (this.detaching) return;
    try {
      const bp = new BridgePacket();
      if (!this.persistence) await bp.send(this, 111, false);
    } finally {
      try {
        await this.parent.lock();
        await this.parent.close();
      } finally {
        if (this.userphid && this.isopen) {
          this.userphid._isopen = false;
          this.isopen = false;
        }
        this.parent.unlock();
      }
    }
  }
  async send(bp) {
    switch (bp.vpkt) {
      case 173:
        if (!(this.parent instanceof VINTDevice)) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
        await this.parent.setHubPortSpeed(this, bp.getNumber(0));
        break;
      case 140:
        if (!(this.parent instanceof PhidgetUSBDevice)) throw new PhidgetError(ErrorCode.WRONG_DEVICE);
        await this.parent.writeLabel(bp.getString(0));
        for (let i = 0; i < PHIDGET_MAXCHANNELS; i++) {
          const ch = this.parent.getChannel(i);
          if (ch && ch !== this) {
            const bp = new BridgePacket();
            bp.set({
              name: '0',
              type: 's',
              value: this.parent.label
            });
            bp.sendToChannel(ch, 172);
          }
        }
        break;
      case 139:
        if (this.parent instanceof VINTDevice) {
          await this.parent.reboot(this);
        } else if (this.parent instanceof PhidgetUSBDevice) {
          await this.parent.rebootFirmwareUpgrade();
        } else {
          throw new PhidgetError(ErrorCode.WRONG_DEVICE);
        }
        break;
      case 138:
        if (this.parent instanceof VINTDevice) {
          await this.parent.rebootFirmwareUpgrade(this, bp.getNumber(0));
        } else if (this.parent instanceof PhidgetUSBDevice) {
          await this.parent.rebootFirmwareUpgrade();
        } else {
          throw new PhidgetError(ErrorCode.WRONG_DEVICE);
        }
        break;
      case 211:
        break;
      default:
        await this.parent.bridgeInput(this, bp);
        break;
    }
  }
  async sendVINTPacket(command) {
    let devicePacketType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    let buffer = arguments.length > 2 ? arguments[2] : undefined;
    const vintDevice = this.parent;
    if (!(vintDevice instanceof VINTDevice)) throw new PhidgetError(ErrorCode.UNEXPECTED, "Parent device does not exist in sendVINTPacket.");
    const bufferOut = vintDevice.makePacket(this, command, devicePacketType, buffer);
    await vintDevice.sendpacket(bufferOut);
  }
  async sendVINTDataPacket(devicePacketType, buffer) {
    await this.sendVINTPacket(0, devicePacketType, buffer);
  }
}

class InterfaceKitDevice extends PhidgetUSBDevice {
  constructor(conn, data, usbDev) {
    super(conn, data, usbDev);
    switch (this.devDef.uid) {
      case 21:
      case 26:
      case 29:
        break;
      default:
        throw new PhidgetError(ErrorCode.UNSUPPORTED);
    }
    this.data = {
      outputState: new Array(this.numDigitalOutputs).fill(2),
      dutyCycle: new Array(this.numDigitalOutputs).fill(1e+300),
      failsafeState: new Array(this.numDigitalOutputs).fill(0),
      inputState: new Array(this.numDigitalInputs).fill(2),
      voltage: new Array(this.numVoltageInputs).fill(1e+300),
      voltageSensorType: new Array(this.numVoltageInputs).fill(2147483647),
      voltageRatio: new Array(this.numVoltageRatioInputs).fill(1e+300),
      voltageRatioSensorType: new Array(this.numVoltageRatioInputs).fill(2147483647)
    };
  }
  get numVoltageInputs() {
    return this.devDef.cn.numVoltageInputs;
  }
  get numVoltageRatioInputs() {
    return this.devDef.cn.numVoltageRatioInputs;
  }
  get numDigitalInputs() {
    return this.devDef.cn.numDigitalInputs;
  }
  get numDigitalOutputs() {
    return this.devDef.cn.numDigitalOutputs;
  }
  async initAfterOpen() {
    switch (this.devDef.uid) {
      case 29:
        throw new PhidgetError(ErrorCode.UNSUPPORTED, "This Phidget is not yet supported via direct USB connection in JavaScript.");
    }
    for (let i = 0; i < this.numDigitalOutputs; i++) this.data.failsafeState[i] = 0;
    const buf = await this.transferPacket(3, 0, 0, 1);
    for (let i = 0; i < this.numDigitalOutputs; i++) this.data.outputState[i] = this.data.dutyCycle[i] = buf.getUint8(0) & 1 << i ? 1 : 0;
  }
  async bridgeInput(ch, bp) {
    let dutyCycle;
    const buf = new DataView(new ArrayBuffer(2));
    switch (ch.class) {
      case ChannelClass.DIGITAL_OUTPUT:
        if (this.data.failsafeState[ch.index] && bp.vpkt !== 34 && bp.vpkt !== 111) {
          throw new PhidgetError(ErrorCode.FAILSAFE);
        }
        switch (bp.vpkt) {
          case 82:
            this.data.outputState[ch.index] = this.data.dutyCycle[ch.index] = bp.getNumber(0);
            buf.setUint8(0, this.data.outputState[ch.index]);
            await this.transferPacket(0, 10, ch.index, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 55:
            dutyCycle = bp.getNumber(0);
            if (dutyCycle !== 0 && dutyCycle !== 1) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Duty cycle must be either 0 or 1");
            this.data.dutyCycle[ch.index] = dutyCycle;
            this.data.outputState[ch.index] = dutyCycle ? 1 : 0;
            buf.setUint8(0, dutyCycle ? 0xFF : 0x00);
            await this.transferPacket(0, 10, ch.index, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 34:
          case 111:
            this.data.failsafeState[ch.index] = 0;
            await this.transferPacket(0, 250, ch.index);
            break;
          case 143:
            break;
          case 146:
            buf.setUint16(0, bp.getNumber('0'));
            await this.transferPacket(0, 246, ch.index, new Uint8Array(buf.buffer, 0, 2));
            break;
          case 147:
            await this.transferPacket(0, 247, ch.index);
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type");
        }
        break;
      case ChannelClass.DIGITAL_INPUT:
      case ChannelClass.VOLTAGE_RATIO_INPUT:
      case ChannelClass.VOLTAGE_INPUT:
        throw new Error("Class not implemented");
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected channel class");
    }
  }
  dataInput(buf) {
    const ch = this.getChannel(buf.getUint8(1));
    if (ch) {
      const pkt = buf.getUint8(0);
      const bp = new BridgePacket();
      switch (pkt) {
        case 13:
          {
            const i = buf.getUint8(1);
            this.data.failsafeState[i] = 1;
            bp.set({
              name: '0',
              type: 'd',
              value: ErrorEventCode.FAILSAFE_CONDITION
            });
            bp.set({
              name: '1',
              type: 's',
              value: 'Failsafe procedure initiated.'
            });
            ch.sendErrorEvent(bp);
            break;
          }
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type");
      }
    }
  }
}

class RFIDDevice extends PhidgetUSBDevice {
  constructor(conn, data, usbDev) {
    super(conn, data, usbDev);
    switch (this.devDef.uid) {
      case 35:
      case 37:
      case 39:
        break;
      default:
        throw new PhidgetError(ErrorCode.UNSUPPORTED);
    }
    this.data = {
      antennaEnabled: [2],
      tagPresent: [0],
      outputState: new Array(this.numDigitalOutputs).fill(2),
      dutyCycle: new Array(this.numDigitalOutputs).fill(1e+300),
      lastTagMemorySize: [0],
      lastTagUserMemorySize: [0],
      lastTagNDEFMemorySize: [0]
    };
  }
  get numDigitalOutputs() {
    return this.devDef.cn.numDigitalOutputs;
  }
  async initAfterOpen() {
    const buffer = await this.transferPacket(3, 5, 0, 5);
    this.data.antennaEnabled[0] = buffer.getUint8(0) & 0x01 ? 1 : 0;
    this.data.outputState[0] = this.data.dutyCycle[0] = buffer.getUint8(0) & 0x02 ? 1 : 0;
    this.data.outputState[1] = this.data.dutyCycle[1] = buffer.getUint8(0) & 0x04 ? 1 : 0;
    this.data.outputState[2] = this.data.dutyCycle[2] = buffer.getUint8(0) & 0x08 ? 1 : 0;
  }
  async bridgeInput(ch, bp) {
    const buf = new DataView(new ArrayBuffer(MAX_OUT_PACKET_SIZE));
    let protocol,
      chipset = RFIDChipset.T5577;
    let tagString;
    let dutyCycle;
    let len;
    switch (ch.class) {
      case ChannelClass.DIGITAL_OUTPUT:
        switch (bp.vpkt) {
          case 82:
            this.data.outputState[ch.index] = this.data.dutyCycle[ch.index] = bp.getNumber(0);
            buf.setUint8(0, bp.getNumber(0));
            await this.transferPacket(0, 10, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 55:
            dutyCycle = bp.getNumber(0);
            if (dutyCycle !== 0 && dutyCycle !== 1) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Duty cycle myust be 0 or 1.");
            this.data.dutyCycle[ch.index] = dutyCycle;
            this.data.outputState[ch.index] = dutyCycle ? 1 : 0;
            buf.setUint8(0, dutyCycle);
            await this.transferPacket(0, 10, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 34:
          case 111:
            buf.setUint8(0, 0);
            await this.transferPacket(0, 10, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 143:
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type");
        }
        break;
      case ChannelClass.RFID:
        if (ch.index !== 0) {
          throw new PhidgetError(ErrorCode.UNEXPECTED);
        }
        switch (bp.vpkt) {
          case 41:
            buf.setUint8(0, bp.getNumber(0));
            this.data.antennaEnabled[0] = bp.getNumber(0);
            await this.transferPacket(0, 99, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
            break;
          case 201:
            chipset = bp.getNumber(3);
            switch (this.devDef.uid) {
              case 35:
              case 37:
                if (chipset < RFIDChipset.T5577 || chipset > RFIDChipset.T5577) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
                break;
              case 39:
              default:
                if (chipset < RFIDChipset.T5577 || chipset > RFIDChipset.EM4305) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
                break;
            }
          case 103:
            {
              protocol = bp.getNumber(1);
              switch (this.devDef.uid) {
                case 35:
                  if (protocol < RFIDProtocol.EM4100 || protocol > RFIDProtocol.PHIDGET_TAG) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
                  break;
                case 37:
                case 39:
                default:
                  if (protocol < RFIDProtocol.EM4100 || protocol > RFIDProtocol.HID_H10301) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Invalid protocol type");
                  break;
              }
              if (this.data.antennaEnabled[0] !== 1) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT, "Cannot write tag while antenna is off");
              buf.setUint8(0, bp.getNumber(1));
              buf.setUint8(1, bp.getNumber(2));
              tagString = bp.getString(0);
              if ((protocol === RFIDProtocol.EM4100 || protocol === RFIDProtocol.HID_GENERIC) && tagString.charAt(1) === 'x') tagString = tagString.slice(2);
              if (tagString.length > MAX_OUT_PACKET_SIZE - 3) throw new PhidgetError(ErrorCode.INVALID_ARGUMENT);
              for (let i = 0; i < tagString.length; i++) buf.setUint8(2 + i, tagString.charCodeAt(i));
              buf.setUint8(2 + tagString.length, 0x00);
              if (protocol === RFIDProtocol.EM4100 || protocol === RFIDProtocol.HID_GENERIC) {
                for (let i = 0; i < tagString.length; i++) {
                  const toLower = String.fromCharCode(buf.getUint8(2 + i)).toLowerCase();
                  buf.setUint8(2 + i, toLower.charCodeAt(0));
                }
              }
              len = tagString.length + 2;
              const userphid = ch.userphid;
              userphid._setLatestTagString("");
              switch (this.devDef.uid) {
                case 35:
                case 37:
                  await this.transferPacket(0, 98, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, len));
                  break;
                case 39:
                  if (bp.vpkt === 201) {
                    buf.setInt32(len, chipset);
                    len += 4;
                    await this.transferPacket(0, 101, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, len));
                  } else {
                    await this.transferPacket(0, 98, ch.uniqueIndex, new Uint8Array(buf.buffer, 0, len));
                  }
                  break;
              }
              try {
                tagString = userphid._setExpectedTag(protocol, tagString);
                switch (this.devDef.uid) {
                  case 35:
                  case 37:
                    await userphid._waitForTag(tagString, 700);
                    break;
                  case 39:
                    await userphid._waitForTag(tagString, 1000);
                    break;
                  default:
                    break;
                }
              } catch (_a) {
                throw new PhidgetError(ErrorCode.TIMEOUT, "Timed out waiting for tag to appear after writing. Try again.");
              }
              break;
            }
          case 34:
          case 111:
          case 143:
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type");
        }
        break;
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected channel class");
    }
  }
  dataInput(buffer) {
    const pkt = buffer.getUint8(0);
    const ch = this.getChannel(0);
    let tagString;
    if (ch) {
      const bp = new BridgePacket();
      switch (pkt) {
        case 96:
          {
            tagString = "";
            for (let i = 2, byteChar = buffer.getUint8(i); i < buffer.byteLength && String.fromCharCode(byteChar) !== '\0'; i++, byteChar = buffer.getUint8(i)) {
              tagString += String.fromCharCode(byteChar);
            }
            const userphid = ch.userphid;
            userphid._setLatestTagString(tagString);
            this.data.tagPresent[0] = 1;
            bp.set({
              name: '0',
              type: 's',
              value: tagString
            });
            bp.set({
              name: '1',
              type: 'd',
              value: buffer.getUint8(1)
            });
            bp.sendToChannel(ch, 92);
            break;
          }
        case 97:
          tagString = "";
          for (let i = 2, byteChar = buffer.getUint8(i); i < buffer.byteLength && String.fromCharCode(byteChar) !== '\0'; i++, byteChar = buffer.getUint8(i)) {
            tagString += String.fromCharCode(byteChar);
          }
          this.data.tagPresent[0] = 0;
          bp.set({
            name: '0',
            type: 's',
            value: tagString
          });
          bp.set({
            name: '1',
            type: 'd',
            value: buffer.getUint8(1)
          });
          bp.sendToChannel(ch, 93);
          break;
        default:
          throw new PhidgetError(ErrorCode.UNEXPECTED, "Unexpected packet type.");
      }
    }
  }
}

const ZERO_GYRO_TIME = 2000;
const MIN_DATA_RATE = 1000;
const ACCEL_CHANNEL = 0;
const GYRO_CHANNEL = 1;
const MAG_CHANNEL = 2;
const SPT_CHANNEL = 3;
const TMP_CHANNEL = 4;
const ACCEL_SEND_FLAG = 1 << ACCEL_CHANNEL;
const GYRO_SEND_FLAG = 1 << GYRO_CHANNEL;
const MAG_SEND_FLAG = 1 << MAG_CHANNEL;
const SPT_SEND_FLAG = 1 << SPT_CHANNEL;
const TMP_SEND_FLAG = 1 << TMP_CHANNEL;
class SpatialDevice extends PhidgetUSBDevice {
  constructor(conn, data, usbDev) {
    super(conn, data, usbDev);
    switch (this.devDef.uid) {
      case 174:
      case 175:
        this.numAccelAxes = 3;
        this.numGyroAxes = 3;
        this.numCompassAxes = 3;
        break;
      default:
        throw new PhidgetError(ErrorCode.UNSUPPORTED);
    }
    this.data = this.initData();
  }
  get numAccelerometers() {
    return this.devDef.cn.numAccelerometers;
  }
  get numGyroscopes() {
    return this.devDef.cn.numGyroscopes;
  }
  get numMagnetometers() {
    return this.devDef.cn.numMagnetometers;
  }
  get numSpatials() {
    return this.devDef.cn.numSpatials;
  }
  get numTemperatureSensors() {
    return this.devDef.cn.numTemperatureSensors;
  }
  updateTimestamp(time) {
    if (this.data.lastTimeCounter != undefined) {
      const timechange = time - this.data.lastTimeCounter & 0xFFFF;
      this.data.timestamp[0] += timechange;
    }
    this.data.lastTimeCounter = time;
  }
  updateLatestDataTime(i) {
    this.data.latestDataTime = this.data.timestamp[0] + (i + 1) * this.data.dataRateMax;
  }
  timestampDiff(time1, time2) {
    return time1 - time2;
  }
  initData() {
    const data = {
      timestamp: [0],
      acceleration: [new Array(this.numAccelAxes).fill(1e+300)],
      angularRate: [new Array(this.numGyroAxes).fill(1e+300)],
      magneticField: [new Array(this.numCompassAxes).fill(1e+300)],
      temperature: new Array(this.numTemperatureSensors).fill(1e+300),
      quaternion: [null],
      precision: 2147483647,
      algorithm: [2147483647],
      algorithmMagnetometerGain: [1e+300],
      dataInterval: 0,
      temperatureDataInterval: 0,
      accelerationChangeTrigger: 0,
      magneticFieldChangeTrigger: 0,
      temperatureChangeTrigger: 0,
      accelAxisLastTrigger: new Array(this.numAccelAxes).fill(1e+300),
      gyroCorrection: new Array(this.numGyroAxes).fill(0),
      magAxisLastTrigger: new Array(this.numCompassAxes).fill(1e+300),
      lastEventTime: 0,
      latestDataTime: 0,
      doZeroGyro: false,
      dataBuffer: [],
      accelerationMax: 0,
      accelerationMin: 0,
      interruptRate: 0,
      dataRateMax: 0,
      dataRateMin: 0,
      angularRateMax: 0,
      angularRateMin: 0,
      magneticFieldMax: 0,
      magneticFieldMin: 0,
      userMagField: 0,
      calDataValid: false,
      temperatureMax: 0,
      temperatureMin: 0,
      lastTemperatureEventTime: 0,
      temperatureLastTrigger: 1e+300,
      heatingEnabled: 0
    };
    return data;
  }
  async initAfterOpen() {
    this.data = this.initData();
    this.data.accelerationMax = 8;
    this.data.accelerationMin = -8;
    this.data.interruptRate = 4;
    this.data.dataRateMin = MIN_DATA_RATE;
    this.data.dataInterval = 8;
    this.data.temperatureDataInterval = 100;
    this.data.dataRateMax = 4;
    this.data.angularRateMax = 2000;
    this.data.angularRateMin = -2e3;
    this.data.magneticFieldMax = 5000;
    this.data.magneticFieldMin = -5e3;
    this.data.userMagField = 1.0;
    this.data.calDataValid = false;
    this.data.algorithmMagnetometerGain = [0.005];
    this.data.algorithm = [SpatialAlgorithm.AHRS];
    this.data.temperatureMax = 85;
    this.data.temperatureMin = -40;
    switch (this.devDef.uid) {
      case 174:
        this.data.precision = SpatialPrecision.HYBRID;
        break;
      case 175:
        this.data.precision = SpatialPrecision.HIGH;
        break;
    }
  }
  async bridgeInput(channel, bp) {
    let buffer;
    const buf = new DataView(new ArrayBuffer(24));
    let userphid;
    switch (this.devDef.uid) {
      case 174:
        switch (channel.class) {
          case ChannelClass.ACCELEROMETER:
            if (channel.index !== 0) throw new PhidgetError(ErrorCode.INVALID);
            switch (bp.vpkt) {
              case 54:
                this.setDataRate(channel, bp.getNumber(0));
                break;
              case 46:
                this.data.accelerationChangeTrigger = bp.getNumber(0);
                break;
              case 145:
                this.data.precision = bp.getNumber(0);
                await this.setPrecision(this.data.precision);
                break;
              case 170:
                this.data.heatingEnabled = bp.getNumber(0);
                buffer = new Uint8Array([bp.getNumber(0)]);
                await this.transferPacket(0, 18, channel.uniqueIndex, buffer);
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 17, channel.uniqueIndex);
                break;
              case 143:
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          case ChannelClass.GYROSCOPE:
            if (channel.index !== 0) throw new PhidgetError(ErrorCode.INVALID);
            switch (bp.vpkt) {
              case 54:
                this.setDataRate(channel, bp.getNumber(0));
                break;
              case 106:
                await this.zeroGyro();
                break;
              case 145:
                this.data.precision = bp.getNumber(0);
                await this.setPrecision(this.data.precision);
                break;
              case 170:
                this.data.heatingEnabled = bp.getNumber(0);
                buffer = new Uint8Array([bp.getNumber(0)]);
                await this.transferPacket(0, 18, channel.uniqueIndex, buffer);
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 17, channel.uniqueIndex);
                break;
              case 143:
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          case ChannelClass.MAGNETOMETER:
            if (channel.index !== 0) throw new PhidgetError(ErrorCode.INVALID);
            switch (bp.vpkt) {
              case 54:
                this.setDataRate(channel, bp.getNumber(0));
                break;
              case 46:
                this.data.magneticFieldChangeTrigger = bp.getNumber(0);
                break;
              case 37:
                await this.saveCompassCorrectionParameters();
                break;
              case 35:
                await this.resetCompassCorrectionParameters();
                break;
              case 50:
                {
                  const corrParams = {
                    magField: bp.getNumber(0),
                    offset0: bp.getNumber(1),
                    offset1: bp.getNumber(2),
                    offset2: bp.getNumber(3),
                    gain0: bp.getNumber(4),
                    gain1: bp.getNumber(5),
                    gain2: bp.getNumber(6),
                    T0: bp.getNumber(7),
                    T1: bp.getNumber(8),
                    T2: bp.getNumber(9),
                    T3: bp.getNumber(10),
                    T4: bp.getNumber(11),
                    T5: bp.getNumber(12)
                  };
                  await this.setCompassCorrectionParameters(corrParams);
                  break;
                }
              case 170:
                this.data.heatingEnabled = bp.getNumber(0);
                buffer = new Uint8Array([bp.getNumber(0)]);
                await this.transferPacket(0, 18, channel.uniqueIndex, buffer);
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 17, channel.uniqueIndex);
                break;
              case 143:
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          case ChannelClass.SPATIAL:
            if (channel.index !== 0) throw new PhidgetError(ErrorCode.INVALID);
            switch (bp.vpkt) {
              case 54:
                this.setDataRate(channel, bp.getNumber(0));
                break;
              case 106:
                await this.zeroGyro();
                break;
              case 37:
                await this.saveCompassCorrectionParameters();
                break;
              case 35:
                await this.resetCompassCorrectionParameters();
                break;
              case 50:
                {
                  const corrParams = {
                    magField: bp.getNumber(0),
                    offset0: bp.getNumber(1),
                    offset1: bp.getNumber(2),
                    offset2: bp.getNumber(3),
                    gain0: bp.getNumber(4),
                    gain1: bp.getNumber(5),
                    gain2: bp.getNumber(6),
                    T0: bp.getNumber(7),
                    T1: bp.getNumber(8),
                    T2: bp.getNumber(9),
                    T3: bp.getNumber(10),
                    T4: bp.getNumber(11),
                    T5: bp.getNumber(12)
                  };
                  await this.setCompassCorrectionParameters(corrParams);
                  break;
                }
              case 145:
                this.data.precision = bp.getNumber(0);
                await this.setPrecision(this.data.precision);
                break;
              case 150:
                await this.zeroAHRS();
                break;
              case 149:
                this.data.algorithm[0] = bp.getNumber(0);
                await this.configureAlgorithm();
                break;
              case 151:
                this.data.algorithmMagnetometerGain[0] = bp.getNumber(0);
                await this.configureAlgorithm();
                break;
              case 170:
                this.data.heatingEnabled = bp.getNumber(0);
                buffer = new Uint8Array([bp.getNumber(0)]);
                await this.transferPacket(0, 18, channel.uniqueIndex, buffer);
                break;
              case 174:
                {
                  const buf = new ArrayBuffer(24);
                  buffer = new DataView(buf);
                  buffer.setFloat32(0, bp.getNumber(0), true);
                  buffer.setFloat32(4, bp.getNumber(1), true);
                  buffer.setFloat32(8, bp.getNumber(2), true);
                  buffer.setFloat32(12, bp.getNumber(3), true);
                  buffer.setFloat32(16, bp.getNumber(4), true);
                  buffer.setFloat32(20, bp.getNumber(5), true);
                  await this.transferPacket(0, 18, channel.uniqueIndex, buffer);
                  break;
                }
              case 34:
              case 111:
                await this.transferPacket(0, 17, channel.uniqueIndex);
                break;
              case 143:
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          case ChannelClass.TEMPERATURE_SENSOR:
            if (channel.index !== 0) throw new PhidgetError(ErrorCode.INVALID);
            switch (bp.vpkt) {
              case 54:
                this.setTemperatureDataRate(bp.getNumber(0));
                break;
              case 46:
                this.data.temperatureChangeTrigger = bp.getNumber(0);
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 17, channel.uniqueIndex);
                break;
              case 143:
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED);
        }
        break;
      case 175:
        switch (channel.chDef.uid) {
          case 386:
            userphid = channel.userphid;
            await userphid._transactionLock.acquire();
            try {
              switch (bp.vpkt) {
                case 54:
                  buf.setUint16(0, this._handleDataIntervalPacket(bp, 1));
                  await this.transferPacket(0, 252, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 2));
                  break;
                case 106:
                  await this.transferPacket(0, 51, channel.uniqueIndex);
                  break;
                case 35:
                  await this.transferPacket(0, 77, channel.uniqueIndex);
                  break;
                case 37:
                  await this.transferPacket(0, 79, channel.uniqueIndex);
                  break;
                case 50:
                  {
                    const corrParams = {
                      magField: bp.getNumber(0),
                      offset0: bp.getNumber(1),
                      offset1: bp.getNumber(2),
                      offset2: bp.getNumber(3),
                      gain0: bp.getNumber(4),
                      gain1: bp.getNumber(5),
                      gain2: bp.getNumber(6),
                      T0: bp.getNumber(7),
                      T1: bp.getNumber(8),
                      T2: bp.getNumber(9),
                      T3: bp.getNumber(10),
                      T4: bp.getNumber(11),
                      T5: bp.getNumber(12)
                    };
                    await this.setCompassCorrectionParameters(corrParams);
                  }
                  break;
                case 150:
                  await this.transferPacket(0, 80, channel.uniqueIndex);
                  break;
                case 149:
                  this.data.algorithm[0] = bp.getNumber(0);
                  buf.setUint8(0, bp.getNumber(0));
                  await this.transferPacket(0, 81, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
                  break;
                case 151:
                  this.data.algorithmMagnetometerGain[0] = bp.getNumber(0);
                  buf.setFloat32(0, bp.getNumber(0), true);
                  await this.transferPacket(0, 82, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 4));
                  break;
                case 174:
                  buf.setFloat32(0, bp.getNumber(0), true);
                  buf.setFloat32(4, bp.getNumber(1), true);
                  buf.setFloat32(8, bp.getNumber(2), true);
                  buf.setFloat32(12, bp.getNumber(3), true);
                  buf.setFloat32(16, bp.getNumber(4), true);
                  buf.setFloat32(20, bp.getNumber(5), true);
                  await this.transferPacket(0, 84, channel.uniqueIndex, buf);
                  break;
                case 170:
                  this.data.heatingEnabled = bp.getNumber(0);
                  buf.setUint8(0, bp.getNumber(0));
                  await this.transferPacket(0, 85, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
                  break;
                case 34:
                case 111:
                  await this.transferPacket(0, 250, channel.uniqueIndex);
                  break;
                case 143:
                  await this.transferPacket(0, 251, channel.uniqueIndex);
                  break;
                default:
                  throw new PhidgetError(ErrorCode.UNEXPECTED);
              }
            } finally {
              userphid._transactionLock.release();
            }
            break;
          case 385:
            userphid = channel.userphid;
            await userphid.transactionLock.acquire();
            try {
              switch (bp.vpkt) {
                case 54:
                  buf.setUint16(0, this._handleDataIntervalPacket(bp, 1));
                  await this.transferPacket(0, 252, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 2));
                  break;
                case 46:
                  this.data.magneticFieldChangeTrigger = bp.getNumber(0);
                  buf.setFloat32(0, bp.getNumber(0), true);
                  await this.transferPacket(0, 195, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 4));
                  break;
                case 35:
                  await this.transferPacket(0, 77, channel.uniqueIndex);
                  break;
                case 37:
                  await this.transferPacket(0, 79, channel.uniqueIndex);
                  break;
                case 50:
                  {
                    const corrParams = {
                      magField: bp.getNumber(0),
                      offset0: bp.getNumber(1),
                      offset1: bp.getNumber(2),
                      offset2: bp.getNumber(3),
                      gain0: bp.getNumber(4),
                      gain1: bp.getNumber(5),
                      gain2: bp.getNumber(6),
                      T0: bp.getNumber(7),
                      T1: bp.getNumber(8),
                      T2: bp.getNumber(9),
                      T3: bp.getNumber(10),
                      T4: bp.getNumber(11),
                      T5: bp.getNumber(12)
                    };
                    await this.setCompassCorrectionParameters(corrParams);
                  }
                  break;
                case 170:
                  this.data.heatingEnabled = bp.getNumber(0);
                  buf.setUint8(0, bp.getNumber(0));
                  await this.transferPacket(0, 85, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
                  break;
                case 34:
                case 111:
                  await this.transferPacket(0, 250, channel.uniqueIndex);
                  break;
                case 143:
                  await this.transferPacket(0, 251, channel.uniqueIndex);
                  break;
                default:
                  throw new PhidgetError(ErrorCode.UNEXPECTED);
              }
            } finally {
              userphid.transactionLock.release();
            }
            break;
          case 384:
            switch (bp.vpkt) {
              case 54:
                buf.setUint16(0, this._handleDataIntervalPacket(bp, 1));
                await this.transferPacket(0, 252, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 2));
                break;
              case 106:
                await this.transferPacket(0, 51, channel.uniqueIndex);
                break;
              case 170:
                this.data.heatingEnabled = bp.getNumber(0);
                buf.setUint8(0, bp.getNumber(0));
                await this.transferPacket(0, 85, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 250, channel.uniqueIndex);
                break;
              case 143:
                await this.transferPacket(0, 251, channel.uniqueIndex);
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          case 383:
            switch (bp.vpkt) {
              case 54:
                buf.setUint16(0, this._handleDataIntervalPacket(bp, 1));
                await this.transferPacket(0, 252, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 2));
                break;
              case 46:
                this.data.accelerationChangeTrigger = bp.getNumber(0);
                buf.setFloat32(0, bp.getNumber(0), true);
                await this.transferPacket(0, 195, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 4));
                break;
              case 170:
                this.data.heatingEnabled = bp.getNumber(0);
                buf.setUint8(0, bp.getNumber(0));
                await this.transferPacket(0, 85, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 1));
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 250, channel.uniqueIndex);
                break;
              case 143:
                await this.transferPacket(0, 251, channel.uniqueIndex);
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          case 387:
            switch (bp.vpkt) {
              case 54:
                buf.setUint16(0, this._handleDataIntervalPacket(bp, 1));
                await this.transferPacket(0, 252, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 2));
                break;
              case 46:
                this.data.temperatureChangeTrigger = bp.getNumber(0);
                buf.setFloat32(0, bp.getNumber(0), true);
                await this.transferPacket(0, 58, channel.uniqueIndex, new Uint8Array(buf.buffer, 0, 4));
                break;
              case 34:
              case 111:
                await this.transferPacket(0, 250, channel.uniqueIndex);
                break;
              case 143:
                await this.transferPacket(0, 251, channel.uniqueIndex);
                break;
              default:
                throw new PhidgetError(ErrorCode.UNEXPECTED);
            }
            break;
          default:
            throw new PhidgetError(ErrorCode.UNEXPECTED);
        }
        break;
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED);
    }
  }
  dataInput(buffer) {
    let channel;
    let j = 0;
    let doneGyroZero = false;
    const accelAvg = [0, 0, 0];
    const angularRateAvg = [0, 0, 0];
    const magneticFieldAvg = [0, 0, 0];
    const quaternion = [0, 0, 0, 0];
    const eventData = [];
    let fireSaturation;
    let fireEvent;
    const dataRate = this.data.dataInterval;
    let temperature = 1e+300;
    const incData = {
      acceleration: [],
      angularRate: [],
      magneticField: [],
      quaternion: [],
      timestamp: 0,
      temperature: 0
    };
    switch (this.devDef.uid) {
      case 175:
        {
          let dataIndex = 1;
          const channelFlags = buffer.getUint8(0);
          const evData = {
            acceleration: [],
            angularRate: [],
            magneticField: [],
            quaternion: [],
            timestamp: 0,
            temperature: 0
          };
          evData.timestamp = buffer.getUint32(1);
          dataIndex += 4;
          if (channelFlags & ACCEL_SEND_FLAG || channelFlags & SPT_SEND_FLAG) {
            for (let j = 0; j < 3; j++) {
              evData.acceleration[j] = buffer.getFloat32(dataIndex + j * 4, true);
              if (!Number.isNaN(evData.acceleration[j])) {
                evData.acceleration[j] = RoundDouble(evData.acceleration[j], 6);
              }
            }
            dataIndex += 12;
          }
          if (channelFlags & GYRO_SEND_FLAG || channelFlags & SPT_SEND_FLAG) {
            for (let j = 0; j < 3; j++) {
              evData.angularRate[j] = buffer.getFloat32(dataIndex + j * 4, true);
              if (!Number.isNaN(evData.angularRate[j])) {
                evData.angularRate[j] = RoundDouble(evData.angularRate[j], 6);
              }
            }
            dataIndex += 12;
          }
          if (channelFlags & MAG_SEND_FLAG || channelFlags & SPT_SEND_FLAG) {
            for (let j = 0; j < 3; j++) {
              evData.magneticField[j] = buffer.getFloat32(dataIndex + j * 4, true);
              if (!Number.isNaN(evData.magneticField[j])) {
                evData.magneticField[j] = RoundDouble(evData.magneticField[j], 6);
              }
            }
            dataIndex += 12;
          }
          if (channelFlags & SPT_SEND_FLAG) {
            evData.quaternion[0] = buffer.getFloat32(dataIndex, true);
            evData.quaternion[1] = buffer.getFloat32(dataIndex + 4, true);
            evData.quaternion[2] = buffer.getFloat32(dataIndex + 8, true);
            evData.quaternion[3] = buffer.getFloat32(dataIndex + 12, true);
            dataIndex += 16;
          }
          if (channelFlags & TMP_SEND_FLAG) {
            evData.temperature = buffer.getFloat32(dataIndex, true);
            if (!Number.isNaN(evData.temperature)) {
              evData.temperature = RoundDouble(evData.temperature, 3);
            }
            dataIndex += 4;
          }
          for (let i = 0; i < 5; i++) {
            if ((channelFlags & 1 << i) === 0) {
              continue;
            }
            if ((channel = this.getChannel(i)) !== null) {
              switch (channel.chDef.uid) {
                case 386:
                  {
                    if (buffer.byteLength > dataIndex) {
                      if (buffer.getUint8(dataIndex) & 0x20) {
                        const bp = new BridgePacket();
                        bp.set({
                          name: "0",
                          type: "d",
                          value: ErrorEventCode.OUT_OF_RANGE
                        });
                        bp.set({
                          name: "1",
                          type: "s",
                          value: "One or more spatial readings is out of range."
                        });
                        channel.sendErrorEvent(bp);
                      }
                    }
                    let bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: evData.acceleration
                    });
                    bp.set({
                      name: "1",
                      type: "G",
                      value: evData.angularRate
                    });
                    bp.set({
                      name: "2",
                      type: "G",
                      value: evData.magneticField
                    });
                    bp.set({
                      name: "3",
                      type: "g",
                      value: evData.timestamp
                    });
                    bp.sendToChannel(channel, 89);
                    bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: evData.quaternion
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: evData.timestamp
                    });
                    bp.sendToChannel(channel, 148);
                  }
                  break;
                case 385:
                  {
                    if (buffer.byteLength > dataIndex) {
                      if (buffer.getUint8(dataIndex) & 0x04) {
                        const bp = new BridgePacket();
                        bp.set({
                          name: "0",
                          type: "d",
                          value: ErrorEventCode.OUT_OF_RANGE
                        });
                        bp.set({
                          name: "1",
                          type: "s",
                          value: "One or more magnetometer readings is out of range."
                        });
                        channel.sendErrorEvent(bp);
                      }
                    }
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: evData.magneticField
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: evData.timestamp
                    });
                    bp.sendToChannel(channel, 18);
                  }
                  break;
                case 384:
                  {
                    if (buffer.byteLength > dataIndex) {
                      if (buffer.getUint8(dataIndex) & 0x02) {
                        const bp = new BridgePacket();
                        bp.set({
                          name: "0",
                          type: "d",
                          value: ErrorEventCode.OUT_OF_RANGE
                        });
                        bp.set({
                          name: "1",
                          type: "s",
                          value: "One or more gyroscope readings is out of range."
                        });
                        channel.sendErrorEvent(bp);
                      }
                    }
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: evData.angularRate
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: evData.timestamp
                    });
                    bp.sendToChannel(channel, 2);
                  }
                  break;
                case 383:
                  {
                    if (buffer.byteLength > dataIndex) {
                      if (buffer.getUint8(dataIndex) & 0x01) {
                        const bp = new BridgePacket();
                        bp.set({
                          name: "0",
                          type: "d",
                          value: ErrorEventCode.OUT_OF_RANGE
                        });
                        bp.set({
                          name: "1",
                          type: "s",
                          value: "One or more accelerometer readings is out of range."
                        });
                        channel.sendErrorEvent(bp);
                      }
                    }
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: evData.acceleration
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: evData.timestamp
                    });
                    bp.sendToChannel(channel, 1);
                  }
                  break;
                case 387:
                  {
                    if (buffer.byteLength > dataIndex) {
                      const bp = new BridgePacket();
                      switch (buffer.getUint8(dataIndex) & 0x18) {
                        case 0x08:
                          bp.set({
                            name: "0",
                            type: "d",
                            value: ErrorEventCode.OUT_OF_RANGE_LOW_CONDITION
                          });
                          bp.set({
                            name: "1",
                            type: "s",
                            value: "Temperature is too low to be accurately measured."
                          });
                          break;
                        case 0x10:
                          bp.set({
                            name: "0",
                            type: "d",
                            value: ErrorEventCode.OUT_OF_RANGE_HIGH_CONDITION
                          });
                          bp.set({
                            name: "1",
                            type: "s",
                            value: "Temperature is too high to be accurately measured."
                          });
                          break;
                        case 0x18:
                          bp.set({
                            name: "0",
                            type: "d",
                            value: ErrorEventCode.OUT_OF_RANGE
                          });
                          bp.set({
                            name: "1",
                            type: "s",
                            value: "Temperature is unknown."
                          });
                          break;
                      }
                      channel.sendErrorEvent(bp);
                    }
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "g",
                      value: evData.temperature
                    });
                    bp.sendToChannel(channel, 95);
                  }
              }
            }
          }
        }
        break;
      case 174:
        {
          const time = buffer.getUint32(1, true);
          this.updateTimestamp(time & 0xFFFF);
          for (j = 0; j < 3; j++) {
            const indexOffset = j * 4;
            incData.acceleration.push(buffer.getFloat32(5 + indexOffset, true));
            incData.angularRate.push(buffer.getFloat32(17 + indexOffset, true));
            incData.magneticField.push(buffer.getFloat32(29 + indexOffset, true));
          }
          incData.quaternion.push(buffer.getFloat32(41, true));
          incData.quaternion.push(buffer.getFloat32(45, true));
          incData.quaternion.push(buffer.getFloat32(49, true));
          incData.quaternion.push(buffer.getFloat32(53, true));
          incData.temperature = buffer.getFloat32(57, true);
          this.updateLatestDataTime(0);
          incData.timestamp = this.data.latestDataTime;
          this.data.dataBuffer.push(incData);
          if (this.data.doZeroGyro) {
            if (this.timestampDiff(this.data.latestDataTime, this.data.dataBuffer[0].timestamp) >= ZERO_GYRO_TIME) {
              const gyroCorrectionTemp = [0, 0, 0];
              this.data.dataBuffer.forEach(v => {
                gyroCorrectionTemp.map((_value, index, arary) => {
                  arary[index] += v.angularRate[index];
                });
              });
              this.data.gyroCorrection.forEach((_value, index, arary) => {
                arary[index] = gyroCorrectionTemp[index] / this.data.dataBuffer.length;
              });
              doneGyroZero = true;
            }
          }
          if (this.timestampDiff(this.data.latestDataTime, this.data.lastEventTime) >= dataRate) {
            let tempTime = 0;
            let accelCounter = [0, 0, 0];
            let angularRateCounter = [0, 0, 0];
            let magneticFieldCounter = [0, 0, 0];
            let dataPerEvent = 0;
            let multipleDataPerEvent = false;
            if (dataRate < this.data.interruptRate) multipleDataPerEvent = true;
            for (let j = 0;; j++) {
              if (this.data.dataBuffer.length === 0 || j >= 16) {
                dataPerEvent = j;
                break;
              }
              tempTime = this.data.dataBuffer[0].timestamp;
              this.data.dataBuffer.forEach(v => {
                if (!multipleDataPerEvent || this.timestampDiff(v.timestamp, tempTime) < dataRate) {
                  accelAvg.map((_value, index, array) => {
                    if (v.acceleration[index] !== 1e+300) {
                      array[index] += v.acceleration[index];
                      accelCounter[index]++;
                    }
                  });
                  angularRateAvg.map((_value, index, array) => {
                    if (v.angularRate[index] !== 1e+300) {
                      const rate = v.angularRate[index] - this.data.gyroCorrection[index];
                      array[index] += rate;
                      angularRateCounter[index]++;
                    }
                  });
                  magneticFieldAvg.map((_value, index, array) => {
                    if (v.magneticField[index] !== 1e+300) {
                      array[index] += v.magneticField[index];
                      magneticFieldCounter[index]++;
                    }
                  });
                  quaternion.forEach((_value, index, array) => {
                    array[index] = v.quaternion[index];
                  });
                  temperature = v.temperature;
                }
              });
              this.data.dataBuffer = [];
              const evData = {
                acceleration: [],
                angularRate: [],
                magneticField: [],
                quaternion: [],
                timestamp: 0,
                temperature: 0
              };
              accelAvg.map((value, index, array) => {
                if (accelCounter[index] > 0) evData.acceleration.push(value / accelCounter[index]);else evData.acceleration.push(1e+300);
                array[index] = 0;
              });
              angularRateAvg.map((value, index, array) => {
                if (angularRateCounter[index] > 0) {
                  if (this.data.doZeroGyro && !doneGyroZero) evData.angularRate.push(0);else evData.angularRate.push(value / angularRateCounter[index]);
                } else evData.angularRate.push(1e+300);
                array[index] = 0;
              });
              magneticFieldAvg.map((value, index, array) => {
                if (magneticFieldCounter[index] > 0) evData.magneticField.push(value / magneticFieldCounter[index]);else evData.magneticField.push(1e+300);
                array[index] = 0;
              });
              evData.quaternion = quaternion;
              evData.timestamp = tempTime;
              evData.temperature = temperature;
              eventData.push(evData);
            }
            accelCounter = [0, 0, 0];
            angularRateCounter = [0, 0, 0];
            magneticFieldCounter = [0, 0, 0];
            for (j = 0; j < dataPerEvent; j++) {
              for (let i = 0; i < this.numAccelAxes; i++) if (eventData[j].acceleration[i] !== 1e+300) {
                accelAvg[i] += eventData[j].acceleration[i];
                accelCounter[i]++;
              }
              for (let i = 0; i < this.numGyroAxes; i++) if (eventData[j].angularRate[i] !== 1e+300) {
                angularRateAvg[i] += eventData[j].angularRate[i];
                angularRateCounter[i]++;
              }
              for (let i = 0; i < this.numCompassAxes; i++) if (eventData[j].magneticField[i] !== 1e+300) {
                magneticFieldAvg[i] += eventData[j].magneticField[i];
                magneticFieldCounter[i]++;
              }
              eventData[j].quaternion.forEach((value, index) => {
                quaternion[index] = value;
              });
              temperature = eventData[j].temperature;
            }
            for (let i = 0; i < this.numAccelAxes; i++) {
              if (accelCounter[i] > 0) this.data.acceleration[0][i] = accelAvg[i] / accelCounter[i];else this.data.acceleration[0][i] = 1e+300;
            }
            for (let i = 0; i < this.numGyroAxes; i++) {
              if (angularRateCounter[i] > 0) {
                if (this.data.doZeroGyro && !doneGyroZero) this.data.angularRate[0][i] = 0;else this.data.angularRate[0][i] = angularRateAvg[i] / angularRateCounter[i];
              } else this.data.angularRate[0][i] = 1e+300;
            }
            for (let i = 0; i < this.numCompassAxes; i++) {
              if (magneticFieldCounter[i] > 0) this.data.magneticField[0][i] = magneticFieldAvg[i] / magneticFieldCounter[i];else this.data.magneticField[0][i] = 1e+300;
            }
            this.data.quaternion[0] = {
              x: quaternion[0],
              y: quaternion[1],
              z: quaternion[2],
              w: quaternion[3]
            };
            this.data.temperature[0] = temperature;
            for (let j = 0; j < dataPerEvent; j++) {
              fireSaturation = 0;
              if (this.numSpatials > 0) {
                if ((channel = this.getChannel(3)) !== null) {
                  for (let i = 0; i < this.numAccelAxes; i++) {
                    if (eventData[j].acceleration[i] > this.data.accelerationMax || eventData[j].acceleration[i] < this.data.accelerationMin) fireSaturation |= 0x01;
                  }
                  for (let i = 0; i < this.numGyroAxes; i++) {
                    if (eventData[j].angularRate[i] > this.data.angularRateMax || eventData[j].angularRate[i] < this.data.angularRateMin) fireSaturation |= 0x02;
                  }
                  for (let i = 0; i < this.numCompassAxes; i++) {
                    if (eventData[j].magneticField[i] === 1e+300) continue;
                    if (eventData[j].magneticField[i] > this.data.magneticFieldMax || eventData[j].magneticField[i] < this.data.magneticFieldMin) fireSaturation |= 0x04;
                  }
                  if (fireSaturation === 0) {
                    let bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: eventData[j].acceleration
                    });
                    bp.set({
                      name: "1",
                      type: "G",
                      value: eventData[j].angularRate
                    });
                    bp.set({
                      name: "2",
                      type: "G",
                      value: eventData[j].magneticField
                    });
                    bp.set({
                      name: "3",
                      type: "g",
                      value: eventData[j].timestamp
                    });
                    bp.sendToChannel(channel, 89);
                    bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: eventData[j].quaternion
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: eventData[j].timestamp
                    });
                    bp.sendToChannel(channel, 148);
                  } else {
                    if (fireSaturation & 0x01) {
                      const bp = new BridgePacket();
                      bp.set({
                        name: "0",
                        type: "d",
                        value: ErrorEventCode.SATURATION
                      });
                      bp.set({
                        name: "1",
                        type: "s",
                        value: "Accelerometer Saturation Detected."
                      });
                      channel.sendErrorEvent(bp);
                    }
                    if (fireSaturation & 0x02) {
                      const bp = new BridgePacket();
                      bp.set({
                        name: "0",
                        type: "d",
                        value: ErrorEventCode.SATURATION
                      });
                      bp.set({
                        name: "1",
                        type: "s",
                        value: "Gyroscope Saturation Detected."
                      });
                      channel.sendErrorEvent(bp);
                    }
                    if (fireSaturation & 0x04) {
                      const bp = new BridgePacket();
                      bp.set({
                        name: "0",
                        type: "d",
                        value: ErrorEventCode.SATURATION
                      });
                      bp.set({
                        name: "1",
                        type: "s",
                        value: "Magnetometer Saturation Detected."
                      });
                      channel.sendErrorEvent(bp);
                    }
                  }
                }
              }
              if (this.numAccelerometers > 0) {
                const chIndex = 0;
                if ((channel = this.getChannel(chIndex)) !== null) {
                  fireSaturation = false;
                  fireEvent = false;
                  for (let i = 0; i < this.numAccelAxes; i++) {
                    if (eventData[j].acceleration[i] !== 1e+300) {
                      if (Math.abs(eventData[j].acceleration[i] - this.data.accelAxisLastTrigger[i]) >= this.data.accelerationChangeTrigger || this.data.accelAxisLastTrigger[i] === 1e+300) fireEvent = true;
                      if (eventData[j].acceleration[i] > this.data.accelerationMax || eventData[j].acceleration[i] < this.data.accelerationMin) fireSaturation = true;
                    }
                  }
                  if (fireSaturation) {
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "d",
                      value: ErrorEventCode.SATURATION
                    });
                    bp.set({
                      name: "1",
                      type: "s",
                      value: "Accelerometer Saturation Detected."
                    });
                    channel.sendErrorEvent(bp);
                  }
                  if (fireEvent) {
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: eventData[j].acceleration
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: eventData[j].timestamp
                    });
                    bp.sendToChannel(channel, 1);
                    for (let i = 0; i < this.numAccelAxes; i++) this.data.accelAxisLastTrigger[i] = eventData[j].acceleration[i];
                  }
                }
              }
              if (this.numGyroscopes > 0) {
                const chIndex = 1;
                if ((channel = this.getChannel(chIndex)) !== null) {
                  fireSaturation = false;
                  fireEvent = false;
                  for (let i = 0; i < this.numGyroAxes; i++) {
                    if (eventData[j].angularRate[i] !== 1e+300) {
                      fireEvent = true;
                      if (eventData[j].angularRate[i] > this.data.angularRateMax || eventData[j].angularRate[i] < this.data.angularRateMin) fireSaturation = true;
                    }
                  }
                  if (fireSaturation) {
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "d",
                      value: ErrorEventCode.SATURATION
                    });
                    bp.set({
                      name: "1",
                      type: "s",
                      value: "Gyroscope Saturation Detected."
                    });
                    channel.sendErrorEvent(bp);
                  }
                  if (fireEvent) {
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: eventData[j].angularRate
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: eventData[j].timestamp
                    });
                    bp.sendToChannel(channel, 2);
                  }
                }
              }
              if (this.numMagnetometers > 0) {
                const chIndex = 2;
                if ((channel = this.getChannel(chIndex)) !== null) {
                  fireSaturation = false;
                  fireEvent = false;
                  for (let i = 0; i < this.numCompassAxes; i++) {
                    if (eventData[j].magneticField[i] !== 1e+300) {
                      if (Math.abs(eventData[j].magneticField[i] - this.data.magAxisLastTrigger[i]) >= this.data.magneticFieldChangeTrigger || this.data.magAxisLastTrigger[i] === 1e+300) fireEvent = true;
                      if (eventData[j].magneticField[i] > this.data.magneticFieldMax || eventData[j].magneticField[i] < this.data.magneticFieldMin) fireSaturation = true;
                    }
                  }
                  if (fireSaturation) {
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "d",
                      value: ErrorEventCode.SATURATION
                    });
                    bp.set({
                      name: "1",
                      type: "s",
                      value: "Magnetometer Saturation Detected."
                    });
                    channel.sendErrorEvent(bp);
                  }
                  if (fireEvent) {
                    const bp = new BridgePacket();
                    bp.set({
                      name: "0",
                      type: "G",
                      value: eventData[j].magneticField
                    });
                    bp.set({
                      name: "1",
                      type: "g",
                      value: eventData[j].timestamp
                    });
                    bp.sendToChannel(channel, 18);
                    for (let i = 0; i < this.numCompassAxes; i++) this.data.magAxisLastTrigger[i] = eventData[j].magneticField[i];
                  }
                }
              }
            }
            this.data.lastEventTime = this.data.latestDataTime;
          }
          if (this.timestampDiff(this.data.latestDataTime, this.data.lastTemperatureEventTime) >= this.data.temperatureDataInterval) {
            if (this.numTemperatureSensors > 0) {
              const chIndex = 4;
              if ((channel = this.getChannel(chIndex)) !== null) {
                fireSaturation = false;
                fireEvent = false;
                if (this.data.temperature[0] !== 1e+300) {
                  if (this.data.temperature[0] > this.data.temperatureMax || this.data.temperature[0] < this.data.temperatureMin) {
                    fireSaturation = true;
                    this.data.temperature[0] = 1e+300;
                  }
                  if (Math.abs(this.data.temperature[0] - this.data.temperatureLastTrigger) >= this.data.temperatureChangeTrigger || this.data.temperatureLastTrigger === 1e+300) fireEvent = true;
                }
                if (fireSaturation) {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "d",
                    value: ErrorEventCode.SATURATION
                  });
                  bp.set({
                    name: "1",
                    type: "s",
                    value: "Temperature Saturation Detected."
                  });
                  channel.sendErrorEvent(bp);
                }
                if (fireEvent) {
                  const bp = new BridgePacket();
                  bp.set({
                    name: "0",
                    type: "g",
                    value: this.data.temperature[0]
                  });
                  bp.sendToChannel(channel, 95);
                  this.data.temperatureLastTrigger = this.data.temperature[0];
                }
              }
            }
            this.data.lastTemperatureEventTime = this.data.latestDataTime;
          }
          if (doneGyroZero) this.data.doZeroGyro = false;
        }
        break;
      default:
        throw new PhidgetError(ErrorCode.UNEXPECTED);
  