/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.ManagerAttachEvent;
import com.phidget22.ManagerAttachListener;
import com.phidget22.ManagerDetachEvent;
import com.phidget22.ManagerDetachListener;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ManagerBase {
    long handle = 0L;
    private List<ManagerAttachListener> attachListeners = new ArrayList<ManagerAttachListener>();
    private long nativeAttachHandler = 0L;
    private List<ManagerDetachListener> detachListeners = new ArrayList<ManagerDetachListener>();
    private long nativeDetachHandler = 0L;

    public ManagerBase() throws PhidgetException {
        this.handle = ManagerBase.create();
    }

    private static native long create() throws PhidgetException;

    private final void setEvents(boolean bl) {
        this.enableAttachEvents(bl && this.attachListeners.size() > 0);
        this.enableDetachEvents(bl && this.detachListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAttachListener(ManagerAttachListener managerAttachListener) {
        List<ManagerAttachListener> list = this.attachListeners;
        synchronized (list) {
            this.attachListeners.add(managerAttachListener);
            this.enableAttachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAttachListener(ManagerAttachListener managerAttachListener) {
        List<ManagerAttachListener> list = this.attachListeners;
        synchronized (list) {
            this.attachListeners.remove(managerAttachListener);
            this.enableAttachEvents(this.attachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttach(ManagerAttachEvent managerAttachEvent) {
        List<ManagerAttachListener> list = this.attachListeners;
        synchronized (list) {
            Iterator<ManagerAttachListener> iterator = this.attachListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onAttach(managerAttachEvent);
            }
        }
    }

    private native void enableAttachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDetachListener(ManagerDetachListener managerDetachListener) {
        List<ManagerDetachListener> list = this.detachListeners;
        synchronized (list) {
            this.detachListeners.add(managerDetachListener);
            this.enableDetachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDetachListener(ManagerDetachListener managerDetachListener) {
        List<ManagerDetachListener> list = this.detachListeners;
        synchronized (list) {
            this.detachListeners.remove(managerDetachListener);
            this.enableDetachEvents(this.detachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDetach(ManagerDetachEvent managerDetachEvent) {
        List<ManagerDetachListener> list = this.detachListeners;
        synchronized (list) {
            Iterator<ManagerDetachListener> iterator = this.detachListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDetach(managerDetachEvent);
            }
        }
    }

    private native void enableDetachEvents(boolean var1);

    public native void close() throws PhidgetException;

    public native void open() throws PhidgetException;

    static {
        try {
            System.loadLibrary("phidget22");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        try {
            System.loadLibrary("phidget22java");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries (libphidget22.so and libphidget22java.so).\nMake sure they are available, and add their path to LD_LIBRARY_PATH, or specify with java.library.path.");
            }
            if (string.startsWith("Windows")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries.\nInstall the Windows Phidget22 MSI, or specify with java.library.path.");
            }
            if (string.startsWith("Mac")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries.\nThe Mac Phidget22 DMG must be installed.");
            }
            throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nError loading the Phidget C libraries.");
        }
    }
}

