/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

public enum Protocol {
    RS485(1){

        @Override
        public String getMessage() {
            return "Basic half-duplex RS485. Always receiving until you send data.";
        }
    }
    ,
    RS422(2){

        @Override
        public String getMessage() {
            return "Uses full-duplex RS422 communication.";
        }
    }
    ,
    DMX512(3){

        @Override
        public String getMessage() {
            return "Allows communication with DMX512-compatible devices, such as stage lighting";
        }
    };

    private final int code;

    public static Protocol getEnum(int n) {
        switch (n) {
            case 1: {
                return RS485;
            }
            case 2: {
                return RS422;
            }
            case 3: {
                return DMX512;
            }
        }
        return null;
    }

    private Protocol(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public abstract String getMessage();
}

