/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

public class GPGGA {
    public double latitude;
    public double longitude;
    public short fixQuality;
    public short numSatellites;
    public double horizontalDilution;
    public double altitude;
    public double heightOfGeoid;

    public String toString() {
        return "[GPGGA](latitude: " + this.latitude + ", longitude: " + this.longitude + ", fixQuality: " + this.fixQuality + ", numSatellites: " + this.numSatellites + ", horizontalDilution: " + this.horizontalDilution + ", altitude: " + this.altitude + ", heightOfGeoid: " + this.heightOfGeoid + ")";
    }

    public static class Builder {
        private double latitude;
        private double longitude;
        private short fixQuality;
        private short numSatellites;
        private double horizontalDilution;
        private double altitude;
        private double heightOfGeoid;

        public Builder latitude(double d) {
            this.latitude = d;
            return this;
        }

        public Builder longitude(double d) {
            this.longitude = d;
            return this;
        }

        public Builder fixQuality(short s) {
            this.fixQuality = s;
            return this;
        }

        public Builder numSatellites(short s) {
            this.numSatellites = s;
            return this;
        }

        public Builder horizontalDilution(double d) {
            this.horizontalDilution = d;
            return this;
        }

        public Builder altitude(double d) {
            this.altitude = d;
            return this;
        }

        public Builder heightOfGeoid(double d) {
            this.heightOfGeoid = d;
            return this;
        }

        public GPGGA build() {
            GPGGA gPGGA = new GPGGA();
            gPGGA.latitude = this.latitude;
            gPGGA.longitude = this.longitude;
            gPGGA.fixQuality = this.fixQuality;
            gPGGA.numSatellites = this.numSatellites;
            gPGGA.horizontalDilution = this.horizontalDilution;
            gPGGA.altitude = this.altitude;
            gPGGA.heightOfGeoid = this.heightOfGeoid;
            return gPGGA;
        }
    }
}

