/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.DictionaryAddEvent;
import com.phidget22.DictionaryAddListener;
import com.phidget22.DictionaryRemoveEvent;
import com.phidget22.DictionaryRemoveListener;
import com.phidget22.DictionaryUpdateEvent;
import com.phidget22.DictionaryUpdateListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DictionaryBase
extends Phidget {
    private List<DictionaryAddListener> addListeners = new ArrayList<DictionaryAddListener>();
    private long nativeAddHandler = 0L;
    private List<DictionaryRemoveListener> removeListeners = new ArrayList<DictionaryRemoveListener>();
    private long nativeRemoveHandler = 0L;
    private List<DictionaryUpdateListener> updateListeners = new ArrayList<DictionaryUpdateListener>();
    private long nativeUpdateHandler = 0L;

    DictionaryBase(long l) {
        super(l);
    }

    public DictionaryBase() throws PhidgetException {
        super(DictionaryBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableAddEvents(bl && this.addListeners.size() > 0);
        this.enableRemoveEvents(bl && this.removeListeners.size() > 0);
        this.enableUpdateEvents(bl && this.updateListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAddListener(DictionaryAddListener dictionaryAddListener) {
        List<DictionaryAddListener> list = this.addListeners;
        synchronized (list) {
            this.addListeners.add(dictionaryAddListener);
            this.enableAddEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAddListener(DictionaryAddListener dictionaryAddListener) {
        List<DictionaryAddListener> list = this.addListeners;
        synchronized (list) {
            this.addListeners.remove(dictionaryAddListener);
            this.enableAddEvents(this.addListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAdd(DictionaryAddEvent dictionaryAddEvent) {
        List<DictionaryAddListener> list = this.addListeners;
        synchronized (list) {
            Iterator<DictionaryAddListener> iterator = this.addListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onAdd(dictionaryAddEvent);
            }
        }
    }

    private native void enableAddEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRemoveListener(DictionaryRemoveListener dictionaryRemoveListener) {
        List<DictionaryRemoveListener> list = this.removeListeners;
        synchronized (list) {
            this.removeListeners.add(dictionaryRemoveListener);
            this.enableRemoveEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRemoveListener(DictionaryRemoveListener dictionaryRemoveListener) {
        List<DictionaryRemoveListener> list = this.removeListeners;
        synchronized (list) {
            this.removeListeners.remove(dictionaryRemoveListener);
            this.enableRemoveEvents(this.removeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemove(DictionaryRemoveEvent dictionaryRemoveEvent) {
        List<DictionaryRemoveListener> list = this.removeListeners;
        synchronized (list) {
            Iterator<DictionaryRemoveListener> iterator = this.removeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onRemove(dictionaryRemoveEvent);
            }
        }
    }

    private native void enableRemoveEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addUpdateListener(DictionaryUpdateListener dictionaryUpdateListener) {
        List<DictionaryUpdateListener> list = this.updateListeners;
        synchronized (list) {
            this.updateListeners.add(dictionaryUpdateListener);
            this.enableUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeUpdateListener(DictionaryUpdateListener dictionaryUpdateListener) {
        List<DictionaryUpdateListener> list = this.updateListeners;
        synchronized (list) {
            this.updateListeners.remove(dictionaryUpdateListener);
            this.enableUpdateEvents(this.updateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdate(DictionaryUpdateEvent dictionaryUpdateEvent) {
        List<DictionaryUpdateListener> list = this.updateListeners;
        synchronized (list) {
            Iterator<DictionaryUpdateListener> iterator = this.updateListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onUpdate(dictionaryUpdateEvent);
            }
        }
    }

    private native void enableUpdateEvents(boolean var1);

    public native void add(String var1, String var2) throws PhidgetException;

    public native void removeAll() throws PhidgetException;

    public native String get(String var1) throws PhidgetException;

    public native void remove(String var1) throws PhidgetException;

    public native void set(String var1, String var2) throws PhidgetException;

    public native String sscan(String var1) throws PhidgetException;

    public native void update(String var1, String var2) throws PhidgetException;
}

