/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.AsyncListener;
import com.phidget22.BLDCMotorBrakingStrengthChangeEvent;
import com.phidget22.BLDCMotorBrakingStrengthChangeListener;
import com.phidget22.BLDCMotorPositionChangeEvent;
import com.phidget22.BLDCMotorPositionChangeListener;
import com.phidget22.BLDCMotorVelocityUpdateEvent;
import com.phidget22.BLDCMotorVelocityUpdateListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BLDCMotorBase
extends Phidget {
    private List<BLDCMotorBrakingStrengthChangeListener> brakingStrengthChangeListeners = new ArrayList<BLDCMotorBrakingStrengthChangeListener>();
    private long nativeBrakingStrengthChangeHandler = 0L;
    private List<BLDCMotorPositionChangeListener> positionChangeListeners = new ArrayList<BLDCMotorPositionChangeListener>();
    private long nativePositionChangeHandler = 0L;
    private List<BLDCMotorVelocityUpdateListener> velocityUpdateListeners = new ArrayList<BLDCMotorVelocityUpdateListener>();
    private long nativeVelocityUpdateHandler = 0L;

    BLDCMotorBase(long l) {
        super(l);
    }

    public BLDCMotorBase() throws PhidgetException {
        super(BLDCMotorBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableBrakingStrengthChangeEvents(bl && this.brakingStrengthChangeListeners.size() > 0);
        this.enablePositionChangeEvents(bl && this.positionChangeListeners.size() > 0);
        this.enableVelocityUpdateEvents(bl && this.velocityUpdateListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBrakingStrengthChangeListener(BLDCMotorBrakingStrengthChangeListener bLDCMotorBrakingStrengthChangeListener) {
        List<BLDCMotorBrakingStrengthChangeListener> list = this.brakingStrengthChangeListeners;
        synchronized (list) {
            this.brakingStrengthChangeListeners.add(bLDCMotorBrakingStrengthChangeListener);
            this.enableBrakingStrengthChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBrakingStrengthChangeListener(BLDCMotorBrakingStrengthChangeListener bLDCMotorBrakingStrengthChangeListener) {
        List<BLDCMotorBrakingStrengthChangeListener> list = this.brakingStrengthChangeListeners;
        synchronized (list) {
            this.brakingStrengthChangeListeners.remove(bLDCMotorBrakingStrengthChangeListener);
            this.enableBrakingStrengthChangeEvents(this.brakingStrengthChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBrakingStrengthChange(BLDCMotorBrakingStrengthChangeEvent bLDCMotorBrakingStrengthChangeEvent) {
        List<BLDCMotorBrakingStrengthChangeListener> list = this.brakingStrengthChangeListeners;
        synchronized (list) {
            Iterator<BLDCMotorBrakingStrengthChangeListener> iterator = this.brakingStrengthChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onBrakingStrengthChange(bLDCMotorBrakingStrengthChangeEvent);
            }
        }
    }

    private native void enableBrakingStrengthChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionChangeListener(BLDCMotorPositionChangeListener bLDCMotorPositionChangeListener) {
        List<BLDCMotorPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.add(bLDCMotorPositionChangeListener);
            this.enablePositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionChangeListener(BLDCMotorPositionChangeListener bLDCMotorPositionChangeListener) {
        List<BLDCMotorPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.remove(bLDCMotorPositionChangeListener);
            this.enablePositionChangeEvents(this.positionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionChange(BLDCMotorPositionChangeEvent bLDCMotorPositionChangeEvent) {
        List<BLDCMotorPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            Iterator<BLDCMotorPositionChangeListener> iterator = this.positionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionChange(bLDCMotorPositionChangeEvent);
            }
        }
    }

    private native void enablePositionChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVelocityUpdateListener(BLDCMotorVelocityUpdateListener bLDCMotorVelocityUpdateListener) {
        List<BLDCMotorVelocityUpdateListener> list = this.velocityUpdateListeners;
        synchronized (list) {
            this.velocityUpdateListeners.add(bLDCMotorVelocityUpdateListener);
            this.enableVelocityUpdateEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVelocityUpdateListener(BLDCMotorVelocityUpdateListener bLDCMotorVelocityUpdateListener) {
        List<BLDCMotorVelocityUpdateListener> list = this.velocityUpdateListeners;
        synchronized (list) {
            this.velocityUpdateListeners.remove(bLDCMotorVelocityUpdateListener);
            this.enableVelocityUpdateEvents(this.velocityUpdateListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVelocityUpdate(BLDCMotorVelocityUpdateEvent bLDCMotorVelocityUpdateEvent) {
        List<BLDCMotorVelocityUpdateListener> list = this.velocityUpdateListeners;
        synchronized (list) {
            Iterator<BLDCMotorVelocityUpdateListener> iterator = this.velocityUpdateListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onVelocityUpdate(bLDCMotorVelocityUpdateEvent);
            }
        }
    }

    private native void enableVelocityUpdateEvents(boolean var1);

    public native double getAcceleration() throws PhidgetException;

    public native void setAcceleration(double var1) throws PhidgetException;

    public native double getMinAcceleration() throws PhidgetException;

    public native double getMaxAcceleration() throws PhidgetException;

    public native double getBrakingStrength() throws PhidgetException;

    public native double getMinBrakingStrength() throws PhidgetException;

    public native double getMaxBrakingStrength() throws PhidgetException;

    public native double getCurrentLimit() throws PhidgetException;

    public native void setCurrentLimit(double var1) throws PhidgetException;

    public native double getMinCurrentLimit() throws PhidgetException;

    public native double getMaxCurrentLimit() throws PhidgetException;

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native double getDataRate() throws PhidgetException;

    public native void setDataRate(double var1) throws PhidgetException;

    public native double getMinDataRate() throws PhidgetException;

    public native double getMaxDataRate() throws PhidgetException;

    public native void enableFailsafe(int var1) throws PhidgetException;

    public native int getMinFailsafeTime() throws PhidgetException;

    public native int getMaxFailsafeTime() throws PhidgetException;

    public native double getPosition() throws PhidgetException;

    public native double getMinPosition() throws PhidgetException;

    public native double getMaxPosition() throws PhidgetException;

    public native void addPositionOffset(double var1) throws PhidgetException;

    public native double getRescaleFactor() throws PhidgetException;

    public native void setRescaleFactor(double var1) throws PhidgetException;

    public native void resetFailsafe() throws PhidgetException;

    public native double getStallVelocity() throws PhidgetException;

    public native void setStallVelocity(double var1) throws PhidgetException;

    public native double getMinStallVelocity() throws PhidgetException;

    public native double getMaxStallVelocity() throws PhidgetException;

    public native double getTargetBrakingStrength() throws PhidgetException;

    public native void setTargetBrakingStrength(double var1) throws PhidgetException;

    public native double getTargetVelocity() throws PhidgetException;

    public native void setTargetVelocity(double var1) throws PhidgetException;

    public native void setTargetVelocity(double var1, AsyncListener var3);

    public native double getVelocity() throws PhidgetException;

    public native double getMinVelocity() throws PhidgetException;

    public native double getMaxVelocity() throws PhidgetException;
}

