/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

public enum ServerType {
    DEVICE_REMOTE(3){

        @Override
        public String getMessage() {
            return "Phidget22 Server<br/>Server discovery with this server type allows discovery of servers hosting Phidget devices. Enabling server discovery with this server type allows automated connection to these servers, and the Phidgets connected to them. Enabling server discovery with this server type will also enable ServerAdded and ServerRemoved events for this server type.";
        }
    }
    ,
    WWWREMOTE(6){

        @Override
        public String getMessage() {
            return "Phidget22 Web server<br/>Server discovery with this server type detects the presence of Phidget web servers used to communicate with in-browser JavaScript. Enabling server discovery with this server type will enable ServerAdded and ServerRemoved events for this server type.";
        }
    }
    ,
    SBC(7){

        @Override
        public String getMessage() {
            return "Phidget SBC<br/>Server discovery with this server type detects the presence of Phidget SBCs on the network. Enabling server discovery with this server type will enable ServerAdded and ServerRemoved events for this server type.";
        }
    };

    private final int code;

    public static ServerType getEnum(int n) {
        switch (n) {
            case 3: {
                return DEVICE_REMOTE;
            }
            case 6: {
                return WWWREMOTE;
            }
            case 7: {
                return SBC;
            }
        }
        return null;
    }

    private ServerType(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public abstract String getMessage();
}

