/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import com.phidget22.PowerSupply;
import com.phidget22.UnitInfo;
import com.phidget22.VoltageInputSensorChangeEvent;
import com.phidget22.VoltageInputSensorChangeListener;
import com.phidget22.VoltageInputVoltageChangeEvent;
import com.phidget22.VoltageInputVoltageChangeListener;
import com.phidget22.VoltageRange;
import com.phidget22.VoltageSensorType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VoltageInputBase
extends Phidget {
    private List<VoltageInputSensorChangeListener> sensorChangeListeners = new ArrayList<VoltageInputSensorChangeListener>();
    private long nativeSensorChangeHandler = 0L;
    private List<VoltageInputVoltageChangeListener> voltageChangeListeners = new ArrayList<VoltageInputVoltageChangeListener>();
    private long nativeVoltageChangeHandler = 0L;

    VoltageInputBase(long l) throws PhidgetException {
        super(l);
    }

    public VoltageInputBase() throws PhidgetException {
        super(VoltageInputBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableSensorChangeEvents(bl && this.sensorChangeListeners.size() > 0);
        this.enableVoltageChangeEvents(bl && this.voltageChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSensorChangeListener(VoltageInputSensorChangeListener voltageInputSensorChangeListener) {
        List<VoltageInputSensorChangeListener> list = this.sensorChangeListeners;
        synchronized (list) {
            this.sensorChangeListeners.add(voltageInputSensorChangeListener);
            this.enableSensorChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSensorChangeListener(VoltageInputSensorChangeListener voltageInputSensorChangeListener) {
        List<VoltageInputSensorChangeListener> list = this.sensorChangeListeners;
        synchronized (list) {
            this.sensorChangeListeners.remove(voltageInputSensorChangeListener);
            this.enableSensorChangeEvents(this.sensorChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSensorChange(VoltageInputSensorChangeEvent voltageInputSensorChangeEvent) {
        List<VoltageInputSensorChangeListener> list = this.sensorChangeListeners;
        synchronized (list) {
            Iterator<VoltageInputSensorChangeListener> iterator = this.sensorChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onSensorChange(voltageInputSensorChangeEvent);
            }
        }
    }

    private native void enableSensorChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVoltageChangeListener(VoltageInputVoltageChangeListener voltageInputVoltageChangeListener) {
        List<VoltageInputVoltageChangeListener> list = this.voltageChangeListeners;
        synchronized (list) {
            this.voltageChangeListeners.add(voltageInputVoltageChangeListener);
            this.enableVoltageChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVoltageChangeListener(VoltageInputVoltageChangeListener voltageInputVoltageChangeListener) {
        List<VoltageInputVoltageChangeListener> list = this.voltageChangeListeners;
        synchronized (list) {
            this.voltageChangeListeners.remove(voltageInputVoltageChangeListener);
            this.enableVoltageChangeEvents(this.voltageChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVoltageChange(VoltageInputVoltageChangeEvent voltageInputVoltageChangeEvent) {
        List<VoltageInputVoltageChangeListener> list = this.voltageChangeListeners;
        synchronized (list) {
            Iterator<VoltageInputVoltageChangeListener> iterator = this.voltageChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onVoltageChange(voltageInputVoltageChangeEvent);
            }
        }
    }

    private native void enableVoltageChangeEvents(boolean var1);

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native PowerSupply getPowerSupply() throws PhidgetException;

    public native void setPowerSupply(PowerSupply var1) throws PhidgetException;

    public native VoltageSensorType getSensorType() throws PhidgetException;

    public native void setSensorType(VoltageSensorType var1) throws PhidgetException;

    public native UnitInfo getSensorUnit() throws PhidgetException;

    public native double getSensorValue() throws PhidgetException;

    public native double getSensorValueChangeTrigger() throws PhidgetException;

    public native void setSensorValueChangeTrigger(double var1) throws PhidgetException;

    public native double getVoltage() throws PhidgetException;

    public native double getMinVoltage() throws PhidgetException;

    public native double getMaxVoltage() throws PhidgetException;

    public native double getVoltageChangeTrigger() throws PhidgetException;

    public native void setVoltageChangeTrigger(double var1) throws PhidgetException;

    public native double getMinVoltageChangeTrigger() throws PhidgetException;

    public native double getMaxVoltageChangeTrigger() throws PhidgetException;

    public native VoltageRange getVoltageRange() throws PhidgetException;

    public native void setVoltageRange(VoltageRange var1) throws PhidgetException;
}

