/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.PhidgetBase;
import com.phidget22.PhidgetException;
import java.util.Comparator;

public class Phidget
extends PhidgetBase
implements Comparator<Phidget> {
    private String _phidgetidstr;

    public Phidget(long l) throws PhidgetException {
        super(l);
    }

    public String toString() {
        try {
            return this.getDescription();
        }
        catch (PhidgetException phidgetException) {
            return "[" + this.getClass().getName() + "]";
        }
    }

    public String getPhidgetIDString() {
        if (this._phidgetidstr != null) {
            return this._phidgetidstr;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getIsLocal()) {
                stringBuffer.append('L');
            } else {
                stringBuffer.append('N');
            }
            if (this.getIsChannel()) {
                stringBuffer.append('_').append('C').append(this.getChannel());
                stringBuffer.append('_').append((Object)this.getChannelClass());
            } else {
                stringBuffer.append('_').append('D').append('_').append((Object)this.getDeviceClass());
                stringBuffer.append('_').append((Object)this.getDeviceID());
                if (this.getIsHubPortDevice()) {
                    stringBuffer.append('_').append('H');
                }
            }
            stringBuffer.append('_').append(this.getHubPort());
            stringBuffer.append('_').append(this.getDeviceSerialNumber());
            this._phidgetidstr = stringBuffer.toString();
            return this._phidgetidstr;
        }
        catch (PhidgetException phidgetException) {
            return "_invalid_a_phidget_";
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Phidget)) {
            return false;
        }
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        return this.getPhidgetIDString().hashCode();
    }

    @Override
    public int compare(Phidget phidget, Phidget phidget2) {
        try {
            int n;
            if (phidget.getIsLocal()) {
                if (!phidget2.getIsLocal()) {
                    return 1;
                }
            } else if (phidget2.getIsLocal()) {
                return -1;
            }
            if ((n = phidget.getDeviceSerialNumber() - phidget2.getDeviceSerialNumber()) != 0) {
                return n;
            }
            int n2 = phidget.getHubPort() - phidget2.getHubPort();
            if (n2 != 0) {
                return n2;
            }
            if (phidget.getIsChannel()) {
                if (!phidget2.getIsChannel()) {
                    return -1;
                }
                int n3 = phidget.getChannel() - phidget2.getChannel();
                if (n3 != 0) {
                    return n3;
                }
                int n4 = phidget.getChannelClassName().compareTo(phidget2.getChannelClassName());
                if (n4 != 0) {
                    return n4;
                }
            } else {
                if (phidget2.getIsChannel()) {
                    return 1;
                }
                int n5 = phidget.getDeviceClassName().compareTo(phidget2.getDeviceClassName());
                if (n5 != 0) {
                    return n5;
                }
                int n6 = phidget.getDeviceID().ordinal() - phidget2.getDeviceID().ordinal();
                if (n6 != 0) {
                    return n6;
                }
                if (phidget.getIsHubPortDevice()) {
                    if (!phidget2.getIsHubPortDevice()) {
                        return -1;
                    }
                } else if (phidget2.getIsHubPortDevice()) {
                    return 1;
                }
            }
        }
        catch (PhidgetException phidgetException) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.deleteHandle();
            this.handle = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private native String getDescription() throws PhidgetException;

    private native void deleteHandle() throws PhidgetException;
}

