/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

public enum ErrorEventCode {
    BAD_VERSION(1){

        @Override
        public String getMessage() {
            return "Client and Server protocol versions don't match.";
        }
    }
    ,
    BUSY(2){

        @Override
        public String getMessage() {
            return "Phidget is in use.";
        }
    }
    ,
    NETWORK(3){

        @Override
        public String getMessage() {
            return "Networking communication error.";
        }
    }
    ,
    DISPATCH(4){

        @Override
        public String getMessage() {
            return "An error occured dispatching a command or event.";
        }
    }
    ,
    SUCCESS(4096){

        @Override
        public String getMessage() {
            return "An error state has cleared.";
        }
    }
    ,
    OVERRUN(4098){

        @Override
        public String getMessage() {
            return "A sampling overrun happened in firmware.";
        }
    }
    ,
    PACKET_LOST(4099){

        @Override
        public String getMessage() {
            return "One or more packets were lost.";
        }
    }
    ,
    WRAP_AROUND(4100){

        @Override
        public String getMessage() {
            return "A variable has wrapped around.";
        }
    }
    ,
    OVER_TEMPERATURE(4101){

        @Override
        public String getMessage() {
            return "Over-temperature condition detected.";
        }
    }
    ,
    OVER_CURRENT(4102){

        @Override
        public String getMessage() {
            return "Over-current condition detected.";
        }
    }
    ,
    OUT_OF_RANGE(4103){

        @Override
        public String getMessage() {
            return "Out of range condition detected.";
        }
    }
    ,
    BAD_POWER(4104){

        @Override
        public String getMessage() {
            return "Power supply problem detected.";
        }
    }
    ,
    SATURATION(4105){

        @Override
        public String getMessage() {
            return "Saturation condition detected.";
        }
    }
    ,
    OVER_VOLTAGE(4107){

        @Override
        public String getMessage() {
            return "Over-voltage condition detected.";
        }
    }
    ,
    FAILSAFE_CONDITION(4108){

        @Override
        public String getMessage() {
            return "Fail-safe condition detected.";
        }
    }
    ,
    VOLTAGE_ERROR(4109){

        @Override
        public String getMessage() {
            return "Voltage error detected.";
        }
    }
    ,
    ENERGY_DUMP_CONDITION(4110){

        @Override
        public String getMessage() {
            return "Energy dump condition detected.";
        }
    }
    ,
    MOTOR_STALL_CONDITION(4111){

        @Override
        public String getMessage() {
            return "Motor stall detected.";
        }
    };

    private final int code;

    public static ErrorEventCode getEnum(int n) {
        switch (n) {
            case 1: {
                return BAD_VERSION;
            }
            case 2: {
                return BUSY;
            }
            case 3: {
                return NETWORK;
            }
            case 4: {
                return DISPATCH;
            }
            case 4096: {
                return SUCCESS;
            }
            case 4098: {
                return OVERRUN;
            }
            case 4099: {
                return PACKET_LOST;
            }
            case 4100: {
                return WRAP_AROUND;
            }
            case 4101: {
                return OVER_TEMPERATURE;
            }
            case 4102: {
                return OVER_CURRENT;
            }
            case 4103: {
                return OUT_OF_RANGE;
            }
            case 4104: {
                return BAD_POWER;
            }
            case 4105: {
                return SATURATION;
            }
            case 4107: {
                return OVER_VOLTAGE;
            }
            case 4108: {
                return FAILSAFE_CONDITION;
            }
            case 4109: {
                return VOLTAGE_ERROR;
            }
            case 4110: {
                return ENERGY_DUMP_CONDITION;
            }
            case 4111: {
                return MOTOR_STALL_CONDITION;
            }
        }
        return null;
    }

    private ErrorEventCode(int n2) {
        this.code = n2;
    }

    public int getCode() {
        return this.code;
    }

    public abstract String getMessage();
}

