/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.AttachEvent;
import com.phidget22.AttachListener;
import com.phidget22.ChannelClass;
import com.phidget22.ChannelSubclass;
import com.phidget22.DetachEvent;
import com.phidget22.DetachListener;
import com.phidget22.DeviceClass;
import com.phidget22.DeviceID;
import com.phidget22.ErrorEvent;
import com.phidget22.ErrorListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import com.phidget22.PropertyChangeEvent;
import com.phidget22.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PhidgetBase {
    long handle;
    private List<AttachListener> attachListeners = new ArrayList<AttachListener>();
    private long nativeAttachHandler = 0L;
    private List<DetachListener> detachListeners = new ArrayList<DetachListener>();
    private long nativeDetachHandler = 0L;
    private List<ErrorListener> errorListeners = new ArrayList<ErrorListener>();
    private long nativeErrorHandler = 0L;
    private List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();
    private long nativePropertyChangeHandler = 0L;
    public static final int ANY_SERIAL_NUMBER = -1;
    public static final int ANY_HUB_PORT = -1;
    public static final int ANY_CHANNEL = -1;
    public static final String ANY_LABEL;
    public static final int INFINITE_TIMEOUT = 0;
    public static final int DEFAULT_TIMEOUT = 500;

    PhidgetBase(long l) {
        this.handle = l;
    }

    public PhidgetBase() throws PhidgetException {
    }

    private final void setEvents(boolean bl) {
        this.enableAttachEvents(bl && this.attachListeners.size() > 0);
        this.enableDetachEvents(bl && this.detachListeners.size() > 0);
        this.enableErrorEvents(bl && this.errorListeners.size() > 0);
        this.enablePropertyChangeEvents(bl && this.propertyChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAttachListener(AttachListener attachListener) {
        List<AttachListener> list = this.attachListeners;
        synchronized (list) {
            this.attachListeners.add(attachListener);
            this.enableAttachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAttachListener(AttachListener attachListener) {
        List<AttachListener> list = this.attachListeners;
        synchronized (list) {
            this.attachListeners.remove(attachListener);
            this.enableAttachEvents(this.attachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttach(AttachEvent attachEvent) {
        List<AttachListener> list = this.attachListeners;
        synchronized (list) {
            Iterator<AttachListener> iterator = this.attachListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onAttach(attachEvent);
            }
        }
    }

    private native void enableAttachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDetachListener(DetachListener detachListener) {
        List<DetachListener> list = this.detachListeners;
        synchronized (list) {
            this.detachListeners.add(detachListener);
            this.enableDetachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDetachListener(DetachListener detachListener) {
        List<DetachListener> list = this.detachListeners;
        synchronized (list) {
            this.detachListeners.remove(detachListener);
            this.enableDetachEvents(this.detachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDetach(DetachEvent detachEvent) {
        List<DetachListener> list = this.detachListeners;
        synchronized (list) {
            Iterator<DetachListener> iterator = this.detachListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDetach(detachEvent);
            }
        }
    }

    private native void enableDetachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addErrorListener(ErrorListener errorListener) {
        List<ErrorListener> list = this.errorListeners;
        synchronized (list) {
            this.errorListeners.add(errorListener);
            this.enableErrorEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeErrorListener(ErrorListener errorListener) {
        List<ErrorListener> list = this.errorListeners;
        synchronized (list) {
            this.errorListeners.remove(errorListener);
            this.enableErrorEvents(this.errorListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireError(ErrorEvent errorEvent) {
        List<ErrorListener> list = this.errorListeners;
        synchronized (list) {
            Iterator<ErrorListener> iterator = this.errorListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onError(errorEvent);
            }
        }
    }

    private native void enableErrorEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.propertyChangeListeners;
        synchronized (list) {
            this.propertyChangeListeners.add(propertyChangeListener);
            this.enablePropertyChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.propertyChangeListeners;
        synchronized (list) {
            this.propertyChangeListeners.remove(propertyChangeListener);
            this.enablePropertyChangeEvents(this.propertyChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        List<PropertyChangeListener> list = this.propertyChangeListeners;
        synchronized (list) {
            Iterator<PropertyChangeListener> iterator = this.propertyChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPropertyChange(propertyChangeEvent);
            }
        }
    }

    private native void enablePropertyChangeEvents(boolean var1);

    public static native void finalize(int var0) throws PhidgetException;

    public static native String getLibraryVersion() throws PhidgetException;

    public native boolean getAttached() throws PhidgetException;

    public native int getChannel() throws PhidgetException;

    public native void setChannel(int var1) throws PhidgetException;

    public native ChannelClass getChannelClass() throws PhidgetException;

    public native String getChannelClassName() throws PhidgetException;

    public native String getChannelName() throws PhidgetException;

    public native ChannelSubclass getChannelSubclass() throws PhidgetException;

    public native void close() throws PhidgetException;

    public native DeviceClass getDeviceClass() throws PhidgetException;

    public native String getDeviceClassName() throws PhidgetException;

    public native DeviceID getDeviceID() throws PhidgetException;

    public native String getDeviceLabel() throws PhidgetException;

    public native void setDeviceLabel(String var1) throws PhidgetException;

    public native String getDeviceName() throws PhidgetException;

    public native int getDeviceSerialNumber() throws PhidgetException;

    public native void setDeviceSerialNumber(int var1) throws PhidgetException;

    public native String getDeviceSKU() throws PhidgetException;

    public native int getDeviceVersion() throws PhidgetException;

    public native Phidget getHub() throws PhidgetException;

    public native int getHubPort() throws PhidgetException;

    public native void setHubPort(int var1) throws PhidgetException;

    public native int getHubPortCount() throws PhidgetException;

    public native boolean getIsChannel() throws PhidgetException;

    public native boolean getIsHubPortDevice() throws PhidgetException;

    public native void setIsHubPortDevice(boolean var1) throws PhidgetException;

    public native boolean getIsLocal() throws PhidgetException;

    public native void setIsLocal(boolean var1) throws PhidgetException;

    public native boolean getIsRemote() throws PhidgetException;

    public native void setIsRemote(boolean var1) throws PhidgetException;

    public native void open() throws PhidgetException;

    public native void open(int var1) throws PhidgetException;

    public native Phidget getParent() throws PhidgetException;

    public native String getServerHostname() throws PhidgetException;

    public native String getServerName() throws PhidgetException;

    public native void setServerName(String var1) throws PhidgetException;

    public native String getServerPeerName() throws PhidgetException;

    public native void writeDeviceLabel(String var1) throws PhidgetException;

    static {
        try {
            System.loadLibrary("phidget22java");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library (libphidget22java.so)." + "\nMake sure it is installed, and add it' s path to LD_LIBRARY_PATH.");
            }
            if (string.startsWith("Windows")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library." + "\nThe Windows Phidget22 MSI must be installed.");
            }
            if (string.startsWith("Mac")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library." + "\nThe Mac Phidget22 DMG must be installed.");
            }
            throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library.");
        }
        ANY_LABEL = null;
    }
}

