/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.AsyncListener;
import com.phidget22.DataAdapterPacketEvent;
import com.phidget22.DataAdapterPacketListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataAdapterBase
extends Phidget {
    private List<DataAdapterPacketListener> packetListeners = new ArrayList<DataAdapterPacketListener>();
    private long nativePacketHandler = 0L;

    DataAdapterBase(long l) throws PhidgetException {
        super(l);
    }

    public DataAdapterBase() throws PhidgetException {
        super(DataAdapterBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enablePacketEvents(bl && this.packetListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPacketListener(DataAdapterPacketListener dataAdapterPacketListener) {
        List<DataAdapterPacketListener> list = this.packetListeners;
        synchronized (list) {
            this.packetListeners.add(dataAdapterPacketListener);
            this.enablePacketEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePacketListener(DataAdapterPacketListener dataAdapterPacketListener) {
        List<DataAdapterPacketListener> list = this.packetListeners;
        synchronized (list) {
            this.packetListeners.remove(dataAdapterPacketListener);
            this.enablePacketEvents(this.packetListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePacket(DataAdapterPacketEvent dataAdapterPacketEvent) {
        List<DataAdapterPacketListener> list = this.packetListeners;
        synchronized (list) {
            Iterator<DataAdapterPacketListener> iterator = this.packetListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPacket(dataAdapterPacketEvent);
            }
        }
    }

    private native void enablePacketEvents(boolean var1);

    public native int getMaxPacketLength() throws PhidgetException;

    public native void sendPacket(byte[] var1) throws PhidgetException;

    public native void sendPacket(byte[] var1, AsyncListener var2) throws PhidgetException;
}

