/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.AsyncListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import com.phidget22.StepperControlMode;
import com.phidget22.StepperPositionChangeEvent;
import com.phidget22.StepperPositionChangeListener;
import com.phidget22.StepperStoppedEvent;
import com.phidget22.StepperStoppedListener;
import com.phidget22.StepperVelocityChangeEvent;
import com.phidget22.StepperVelocityChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StepperBase
extends Phidget {
    private List<StepperPositionChangeListener> positionChangeListeners = new ArrayList<StepperPositionChangeListener>();
    private long nativePositionChangeHandler = 0L;
    private List<StepperStoppedListener> stoppedListeners = new ArrayList<StepperStoppedListener>();
    private long nativeStoppedHandler = 0L;
    private List<StepperVelocityChangeListener> velocityChangeListeners = new ArrayList<StepperVelocityChangeListener>();
    private long nativeVelocityChangeHandler = 0L;

    public StepperBase() throws PhidgetException {
        super(StepperBase.create());
    }

    private static native long create() throws PhidgetException;

    private static native void delete() throws PhidgetException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            StepperBase.delete();
        }
        finally {
            super.finalize();
        }
    }

    private final void setDeviceEvents(boolean bl) {
        this.enablePositionChangeEvents(bl && this.positionChangeListeners.size() > 0);
        this.enableStoppedEvents(bl && this.stoppedListeners.size() > 0);
        this.enableVelocityChangeEvents(bl && this.velocityChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionChangeListener(StepperPositionChangeListener stepperPositionChangeListener) {
        List<StepperPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.add(stepperPositionChangeListener);
            this.enablePositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionChangeListener(StepperPositionChangeListener stepperPositionChangeListener) {
        List<StepperPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.remove(stepperPositionChangeListener);
            this.enablePositionChangeEvents(this.positionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionChange(StepperPositionChangeEvent stepperPositionChangeEvent) {
        List<StepperPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            Iterator<StepperPositionChangeListener> iterator = this.positionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionChange(stepperPositionChangeEvent);
            }
        }
    }

    private native void enablePositionChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStoppedListener(StepperStoppedListener stepperStoppedListener) {
        List<StepperStoppedListener> list = this.stoppedListeners;
        synchronized (list) {
            this.stoppedListeners.add(stepperStoppedListener);
            this.enableStoppedEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeStoppedListener(StepperStoppedListener stepperStoppedListener) {
        List<StepperStoppedListener> list = this.stoppedListeners;
        synchronized (list) {
            this.stoppedListeners.remove(stepperStoppedListener);
            this.enableStoppedEvents(this.stoppedListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStopped(StepperStoppedEvent stepperStoppedEvent) {
        List<StepperStoppedListener> list = this.stoppedListeners;
        synchronized (list) {
            Iterator<StepperStoppedListener> iterator = this.stoppedListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onStopped(stepperStoppedEvent);
            }
        }
    }

    private native void enableStoppedEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVelocityChangeListener(StepperVelocityChangeListener stepperVelocityChangeListener) {
        List<StepperVelocityChangeListener> list = this.velocityChangeListeners;
        synchronized (list) {
            this.velocityChangeListeners.add(stepperVelocityChangeListener);
            this.enableVelocityChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVelocityChangeListener(StepperVelocityChangeListener stepperVelocityChangeListener) {
        List<StepperVelocityChangeListener> list = this.velocityChangeListeners;
        synchronized (list) {
            this.velocityChangeListeners.remove(stepperVelocityChangeListener);
            this.enableVelocityChangeEvents(this.velocityChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVelocityChange(StepperVelocityChangeEvent stepperVelocityChangeEvent) {
        List<StepperVelocityChangeListener> list = this.velocityChangeListeners;
        synchronized (list) {
            Iterator<StepperVelocityChangeListener> iterator = this.velocityChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onVelocityChange(stepperVelocityChangeEvent);
            }
        }
    }

    private native void enableVelocityChangeEvents(boolean var1);

    public native double getAcceleration() throws PhidgetException;

    public native void setAcceleration(double var1) throws PhidgetException;

    public native double getMinAcceleration() throws PhidgetException;

    public native double getMaxAcceleration() throws PhidgetException;

    public native StepperControlMode getControlMode() throws PhidgetException;

    public native void setControlMode(StepperControlMode var1) throws PhidgetException;

    public native double getCurrentLimit() throws PhidgetException;

    public native void setCurrentLimit(double var1) throws PhidgetException;

    public native double getMinCurrentLimit() throws PhidgetException;

    public native double getMaxCurrentLimit() throws PhidgetException;

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native boolean getEngaged() throws PhidgetException;

    public native void setEngaged(boolean var1) throws PhidgetException;

    public native double getHoldingCurrentLimit() throws PhidgetException;

    public native void setHoldingCurrentLimit(double var1) throws PhidgetException;

    public native boolean getIsMoving() throws PhidgetException;

    public native double getPosition() throws PhidgetException;

    public native double getMinPosition() throws PhidgetException;

    public native double getMaxPosition() throws PhidgetException;

    public native void addPositionOffset(double var1) throws PhidgetException;

    public native double getRescaleFactor() throws PhidgetException;

    public native void setRescaleFactor(double var1) throws PhidgetException;

    public native double getTargetPosition() throws PhidgetException;

    public native void setTargetPosition(double var1, AsyncListener var3) throws PhidgetException;

    public native void setTargetPosition(double var1) throws PhidgetException;

    public native double getVelocity() throws PhidgetException;

    public native double getVelocityLimit() throws PhidgetException;

    public native void setVelocityLimit(double var1) throws PhidgetException;

    public native double getMinVelocityLimit() throws PhidgetException;

    public native double getMaxVelocityLimit() throws PhidgetException;
}

