/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.LightSensorIlluminanceChangeEvent;
import com.phidget22.LightSensorIlluminanceChangeListener;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LightSensorBase
extends Phidget {
    private List<LightSensorIlluminanceChangeListener> illuminanceChangeListeners = new ArrayList<LightSensorIlluminanceChangeListener>();
    private long nativeIlluminanceChangeHandler = 0L;

    public LightSensorBase() throws PhidgetException {
        super(LightSensorBase.create());
    }

    private static native long create() throws PhidgetException;

    private static native void delete() throws PhidgetException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            LightSensorBase.delete();
        }
        finally {
            super.finalize();
        }
    }

    private final void setDeviceEvents(boolean bl) {
        this.enableIlluminanceChangeEvents(bl && this.illuminanceChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIlluminanceChangeListener(LightSensorIlluminanceChangeListener lightSensorIlluminanceChangeListener) {
        List<LightSensorIlluminanceChangeListener> list = this.illuminanceChangeListeners;
        synchronized (list) {
            this.illuminanceChangeListeners.add(lightSensorIlluminanceChangeListener);
            this.enableIlluminanceChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeIlluminanceChangeListener(LightSensorIlluminanceChangeListener lightSensorIlluminanceChangeListener) {
        List<LightSensorIlluminanceChangeListener> list = this.illuminanceChangeListeners;
        synchronized (list) {
            this.illuminanceChangeListeners.remove(lightSensorIlluminanceChangeListener);
            this.enableIlluminanceChangeEvents(this.illuminanceChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireIlluminanceChange(LightSensorIlluminanceChangeEvent lightSensorIlluminanceChangeEvent) {
        List<LightSensorIlluminanceChangeListener> list = this.illuminanceChangeListeners;
        synchronized (list) {
            Iterator<LightSensorIlluminanceChangeListener> iterator = this.illuminanceChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onIlluminanceChange(lightSensorIlluminanceChangeEvent);
            }
        }
    }

    private native void enableIlluminanceChangeEvents(boolean var1);

    public native int getDataInterval() throws PhidgetException;

    public native void setDataInterval(int var1) throws PhidgetException;

    public native int getMinDataInterval() throws PhidgetException;

    public native int getMaxDataInterval() throws PhidgetException;

    public native double getIlluminance() throws PhidgetException;

    public native double getMinIlluminance() throws PhidgetException;

    public native double getMaxIlluminance() throws PhidgetException;

    public native double getIlluminanceChangeTrigger() throws PhidgetException;

    public native void setIlluminanceChangeTrigger(double var1) throws PhidgetException;

    public native double getMinIlluminanceChangeTrigger() throws PhidgetException;

    public native double getMaxIlluminanceChangeTrigger() throws PhidgetException;
}

