/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.GPSDate;
import com.phidget22.GPSHeadingChangeEvent;
import com.phidget22.GPSHeadingChangeListener;
import com.phidget22.GPSPositionChangeEvent;
import com.phidget22.GPSPositionChangeListener;
import com.phidget22.GPSPositionFixStateChangeEvent;
import com.phidget22.GPSPositionFixStateChangeListener;
import com.phidget22.GPSTime;
import com.phidget22.NMEAData;
import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class GPSBase
extends Phidget {
    private List<GPSHeadingChangeListener> headingChangeListeners = new ArrayList<GPSHeadingChangeListener>();
    private long nativeHeadingChangeHandler = 0L;
    private List<GPSPositionChangeListener> positionChangeListeners = new ArrayList<GPSPositionChangeListener>();
    private long nativePositionChangeHandler = 0L;
    private List<GPSPositionFixStateChangeListener> positionFixStateChangeListeners = new ArrayList<GPSPositionFixStateChangeListener>();
    private long nativePositionFixStateChangeHandler = 0L;

    public GPSBase() throws PhidgetException {
        super(GPSBase.create());
    }

    private static native long create() throws PhidgetException;

    private static native void delete() throws PhidgetException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            GPSBase.delete();
        }
        finally {
            super.finalize();
        }
    }

    private final void setDeviceEvents(boolean bl) {
        this.enableHeadingChangeEvents(bl && this.headingChangeListeners.size() > 0);
        this.enablePositionChangeEvents(bl && this.positionChangeListeners.size() > 0);
        this.enablePositionFixStateChangeEvents(bl && this.positionFixStateChangeListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addHeadingChangeListener(GPSHeadingChangeListener gPSHeadingChangeListener) {
        List<GPSHeadingChangeListener> list = this.headingChangeListeners;
        synchronized (list) {
            this.headingChangeListeners.add(gPSHeadingChangeListener);
            this.enableHeadingChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeHeadingChangeListener(GPSHeadingChangeListener gPSHeadingChangeListener) {
        List<GPSHeadingChangeListener> list = this.headingChangeListeners;
        synchronized (list) {
            this.headingChangeListeners.remove(gPSHeadingChangeListener);
            this.enableHeadingChangeEvents(this.headingChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHeadingChange(GPSHeadingChangeEvent gPSHeadingChangeEvent) {
        List<GPSHeadingChangeListener> list = this.headingChangeListeners;
        synchronized (list) {
            Iterator<GPSHeadingChangeListener> iterator = this.headingChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onHeadingChange(gPSHeadingChangeEvent);
            }
        }
    }

    private native void enableHeadingChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionChangeListener(GPSPositionChangeListener gPSPositionChangeListener) {
        List<GPSPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.add(gPSPositionChangeListener);
            this.enablePositionChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionChangeListener(GPSPositionChangeListener gPSPositionChangeListener) {
        List<GPSPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            this.positionChangeListeners.remove(gPSPositionChangeListener);
            this.enablePositionChangeEvents(this.positionChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionChange(GPSPositionChangeEvent gPSPositionChangeEvent) {
        List<GPSPositionChangeListener> list = this.positionChangeListeners;
        synchronized (list) {
            Iterator<GPSPositionChangeListener> iterator = this.positionChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionChange(gPSPositionChangeEvent);
            }
        }
    }

    private native void enablePositionChangeEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPositionFixStateChangeListener(GPSPositionFixStateChangeListener gPSPositionFixStateChangeListener) {
        List<GPSPositionFixStateChangeListener> list = this.positionFixStateChangeListeners;
        synchronized (list) {
            this.positionFixStateChangeListeners.add(gPSPositionFixStateChangeListener);
            this.enablePositionFixStateChangeEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePositionFixStateChangeListener(GPSPositionFixStateChangeListener gPSPositionFixStateChangeListener) {
        List<GPSPositionFixStateChangeListener> list = this.positionFixStateChangeListeners;
        synchronized (list) {
            this.positionFixStateChangeListeners.remove(gPSPositionFixStateChangeListener);
            this.enablePositionFixStateChangeEvents(this.positionFixStateChangeListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePositionFixStateChange(GPSPositionFixStateChangeEvent gPSPositionFixStateChangeEvent) {
        List<GPSPositionFixStateChangeListener> list = this.positionFixStateChangeListeners;
        synchronized (list) {
            Iterator<GPSPositionFixStateChangeListener> iterator = this.positionFixStateChangeListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onPositionFixStateChange(gPSPositionFixStateChangeEvent);
            }
        }
    }

    private native void enablePositionFixStateChangeEvents(boolean var1);

    public native double getAltitude() throws PhidgetException;

    public native GPSDate getDate() throws PhidgetException;

    public native Calendar getDateAndTime() throws PhidgetException;

    public native double getHeading() throws PhidgetException;

    public native double getLatitude() throws PhidgetException;

    public native double getLongitude() throws PhidgetException;

    public native NMEAData getNMEAData() throws PhidgetException;

    public native boolean getPositionFixState() throws PhidgetException;

    public native GPSTime getTime() throws PhidgetException;

    public native double getVelocity() throws PhidgetException;
}

