/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.IRCodeEncoding;
import com.phidget22.IRCodeLength;
import java.util.Arrays;

public class IRCodeInfo {
    public int bitCount;
    public IRCodeEncoding encoding;
    public IRCodeLength length;
    public int gap;
    public int trail;
    public int[] header;
    public int[] one;
    public int[] zero;
    public int[] repeat;
    public int minRepeat;
    public double dutyCycle;
    public int carrierFrequency;
    public String toggleMask;

    public String toString() {
        return "[IRCodeInfo](bitCount: " + this.bitCount + ", encoding: " + String.valueOf((Object)this.encoding) + ", length: " + String.valueOf((Object)this.length) + ", gap: " + this.gap + ", trail: " + this.trail + ", header: " + Arrays.toString(this.header) + ", one: " + Arrays.toString(this.one) + ", zero: " + Arrays.toString(this.zero) + ", repeat: " + Arrays.toString(this.repeat) + ", minRepeat: " + this.minRepeat + ", dutyCycle: " + this.dutyCycle + ", carrierFrequency: " + this.carrierFrequency + ", toggleMask: " + this.toggleMask + ")";
    }

    public static class Builder {
        private int bitCount;
        private IRCodeEncoding encoding;
        private IRCodeLength length;
        private int gap;
        private int trail;
        private int[] header;
        private int[] one;
        private int[] zero;
        private int[] repeat;
        private int minRepeat;
        private double dutyCycle;
        private int carrierFrequency;
        private String toggleMask;

        public Builder bitCount(int n) {
            this.bitCount = n;
            return this;
        }

        public Builder encoding(IRCodeEncoding iRCodeEncoding) {
            this.encoding = iRCodeEncoding;
            return this;
        }

        public Builder length(IRCodeLength iRCodeLength) {
            this.length = iRCodeLength;
            return this;
        }

        public Builder gap(int n) {
            this.gap = n;
            return this;
        }

        public Builder trail(int n) {
            this.trail = n;
            return this;
        }

        public Builder header(int[] nArray) {
            this.header = nArray;
            return this;
        }

        public Builder one(int[] nArray) {
            this.one = nArray;
            return this;
        }

        public Builder zero(int[] nArray) {
            this.zero = nArray;
            return this;
        }

        public Builder repeat(int[] nArray) {
            this.repeat = nArray;
            return this;
        }

        public Builder minRepeat(int n) {
            this.minRepeat = n;
            return this;
        }

        public Builder dutyCycle(double d) {
            this.dutyCycle = d;
            return this;
        }

        public Builder carrierFrequency(int n) {
            this.carrierFrequency = n;
            return this;
        }

        public Builder toggleMask(String string) {
            this.toggleMask = string;
            return this;
        }

        public IRCodeInfo build() {
            IRCodeInfo iRCodeInfo = new IRCodeInfo();
            iRCodeInfo.bitCount = this.bitCount;
            iRCodeInfo.encoding = this.encoding;
            iRCodeInfo.length = this.length;
            iRCodeInfo.gap = this.gap;
            iRCodeInfo.trail = this.trail;
            iRCodeInfo.header = this.header;
            iRCodeInfo.one = this.one;
            iRCodeInfo.zero = this.zero;
            iRCodeInfo.repeat = this.repeat;
            iRCodeInfo.minRepeat = this.minRepeat;
            iRCodeInfo.dutyCycle = this.dutyCycle;
            iRCodeInfo.carrierFrequency = this.carrierFrequency;
            iRCodeInfo.toggleMask = this.toggleMask;
            return iRCodeInfo;
        }
    }
}

