/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import com.phidget22.usb.Manager;
import java.nio.ByteBuffer;

public class Phidget {
    public int vID;
    public int pID;
    public int version;
    public int interfaceNum;
    public int inputReportSize;
    public int outputReportSize;
    public int serialNumber;
    public int id;
    public int interfaceClass;
    public String productString;
    public String skuString;
    public int labelIndex = 4;
    public String name;
    public byte[] label;
    public int skuIndex;
    public int maxPacketEP0;
    public int maxPacketEP1;
    public int wMaxPacketSizeEP1;
    public int maxPacketEP2;
    public int ep1type;
    public int ep2type;
    private UsbDevice device = null;
    private UsbDeviceConnection conn = null;
    private UsbInterface intf = null;
    private UsbEndpoint endpoint = null;
    private UsbEndpoint endpointOut = null;
    private UsbRequest request = null;
    private ByteBuffer requestBuffer = null;

    public void refreshLabel() {
        Phidget.refreshLabel(this, this.conn);
    }

    public static void refreshLabel(Phidget phidget, UsbDeviceConnection conn) {
        byte[] stringDesc = new byte[256];
        int bytesRecieved = conn.controlTransfer(128, 6, 0x300 | phidget.labelIndex, 1033, stringDesc, 2, 500);
        if (bytesRecieved == 2) {
            bytesRecieved = conn.controlTransfer(128, 6, 0x300 | phidget.labelIndex, 1033, stringDesc, (int)stringDesc[0], 500);
            if (bytesRecieved >= 0) {
                phidget.label = new byte[bytesRecieved];
                for (int k = 0; k < bytesRecieved; ++k) {
                    phidget.label[k] = stringDesc[k];
                }
            } else {
                phidget.label = new byte[1];
                phidget.label[0] = 0;
            }
        } else {
            phidget.label = new byte[1];
            phidget.label[0] = 0;
        }
    }

    public boolean setDeviceAndConnection(UsbDevice device, UsbDeviceConnection conn, UsbInterface intf) {
        this.device = device;
        this.conn = conn;
        this.intf = intf;
        this.endpoint = intf.getEndpoint(0);
        this.request = new UsbRequest();
        if (!this.request.initialize(conn, this.endpoint)) {
            this.request = null;
            return false;
        }
        this.requestBuffer = ByteBuffer.allocate(this.inputReportSize);
        return true;
    }

    public void cancelRead() {
        if (this.request != null) {
            this.request.cancel();
        }
    }

    public void close() {
        if (this.device != null) {
            if (this.conn != null) {
                if (this.intf != null) {
                    this.conn.releaseInterface(this.intf);
                    this.intf = null;
                }
                this.conn.close();
                this.conn = null;
            }
            this.device = null;
        }
        if (this.request != null) {
            this.request.close();
            this.request = null;
            this.requestBuffer = null;
        }
    }

    public int write(byte[] data) {
        if (this.conn != null && this.interfaceClass != 255) {
            if (data.length == this.outputReportSize) {
                return this.conn.controlTransfer(33, 9, 512, this.interfaceNum, data, data.length, 500);
            }
            return -8002;
        }
        return -8001;
    }

    public int bulkWrite(byte[] data, int timeout) {
        if (this.endpointOut == null) {
            this.endpointOut = this.intf.getEndpoint(1);
        }
        if (this.conn != null && this.endpointOut != null) {
            return this.conn.bulkTransfer(this.endpointOut, data, data.length, timeout);
        }
        return -8001;
    }

    public int controlWrite(int request, int value, byte[] data, int timeout) {
        if (this.conn != null) {
            return this.conn.controlTransfer(65, request, value, this.interfaceNum, data, data.length, timeout);
        }
        return -8001;
    }

    public byte[] controlRead(int request, int value, int length, int timeout) {
        if (this.conn != null) {
            byte[] buf = new byte[length];
            int res = this.conn.controlTransfer(193, request, value, this.interfaceNum, buf, length, timeout);
            if (res < 0) {
                return null;
            }
            byte[] data = new byte[res];
            for (int k = 0; k < res; ++k) {
                data[k] = buf[k];
            }
            return data;
        }
        return null;
    }

    public int setLabel(byte[] label) {
        if (this.conn != null) {
            if (label.length <= 22) {
                int res = this.conn.controlTransfer(0, 7, 0x300 | this.labelIndex, 1033, label, label.length, 500);
                if (res >= 0) {
                    this.refreshLabel();
                }
                return res;
            }
            return -8002;
        }
        return -8001;
    }

    public byte[] read() {
        if (this.conn != null && this.endpoint != null && this.request != null) {
            this.requestBuffer.clear();
            if (this.request.queue(this.requestBuffer, this.inputReportSize)) {
                if (this.conn.requestWait() == this.request) {
                    byte[] data = new byte[this.requestBuffer.position()];
                    this.requestBuffer.rewind();
                    this.requestBuffer.get(data);
                    return data;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public int getvID() {
        return this.vID;
    }

    public int getpID() {
        return this.pID;
    }

    public int getVersion() {
        return this.version;
    }

    public int getInterfaceNum() {
        return this.interfaceNum;
    }

    public int getInputReportSize() {
        return this.inputReportSize;
    }

    public int getOutputReportSize() {
        return this.outputReportSize;
    }

    public byte[] getLabel() {
        return this.label;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getInterfaceClass() {
        return this.interfaceClass;
    }

    public String getUniqueName() {
        return this.name;
    }

    public String getProductString() {
        return this.productString;
    }

    public String getSkuString() {
        return this.skuString;
    }

    public int getMaxPacketEP0() {
        return this.maxPacketEP0;
    }

    public int getMaxPacketEP1() {
        return this.maxPacketEP1;
    }

    public int getWMaxPacketSizeEP1() {
        return this.wMaxPacketSizeEP1;
    }

    public int getMaxPacketEP2() {
        return this.maxPacketEP2;
    }

    public int getEp1type() {
        return this.ep1type;
    }

    public int getEp2type() {
        return this.ep2type;
    }

    public String getDescriptor(int index) {
        if (this.conn == null) {
            return null;
        }
        return Manager.getStringDescriptor(this.conn, index);
    }

    public byte[] getDeviceDescriptor(int type, int index) {
        if (this.conn == null) {
            return null;
        }
        return Manager.getDeviceDescriptor(this.conn, type, index);
    }

    static {
        try {
            System.loadLibrary("phidget22java");
        }
        catch (UnsatisfiedLinkError ex) {
            String os = System.getProperty("os.name");
            if (os.startsWith("Linux")) {
                throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library (libphidget22java.so).\nMake sure it is installed, and add it' s path to LD_LIBRARY_PATH.");
            }
            if (os.startsWith("Windows")) {
                throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library.\nThe Windows Phidget22 MSI must be installed.");
            }
            if (os.startsWith("Mac")) {
                throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library.\nThe Mac Phidget22 DMG must be installed.");
            }
            throw new ExceptionInInitializerError(ex.getMessage() + "\nCould not locate the Phidget C library.");
        }
    }
}

