//
//  PhidgetInfoBoxViewController.swift
//  DigitalInput
//
//  Created by Phidgets on 2018-01-23.
//  Copyright © 2018 Phidgets. All rights reserved.
//

import UIKit
import Phidget22Swift

class PhidgetInfoBoxViewController: UIViewController {
    @IBOutlet var deviceTxt: UILabel!
    @IBOutlet var versionTxt: UILabel!
    @IBOutlet var channelTxt: UILabel!
    @IBOutlet var serialNumTxt: UILabel!
    @IBOutlet var hubPortTxt: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    func fillPhidgetInfo(phid: Phidget?) throws {
        
        if(phid == nil){
            DispatchQueue.main.async {
                self.deviceTxt.text = "Nothing"
                self.versionTxt.text = "Version:"
                self.channelTxt.text = "Channel:"
                self.serialNumTxt.text = "Serial Number:"
                self.hubPortTxt.text = "Hub Port:"
                return
            }
        }
        else{
            let channel = try phid?.getChannel()
            let deviceVersion = try phid?.getDeviceVersion()
            let deviceName = try phid?.getDeviceName()
            let deviceSerialNumber = try phid?.getDeviceSerialNumber()
            
            if(try phid?.getDeviceClass() == DeviceClass.VINT){
                let hubPort = try phid?.getHubPort()
                DispatchQueue.main.async {
                    self.hubPortTxt.isHidden = false
                    self.hubPortTxt.text = "Hub Port: \(hubPort!)"
                }
            }
            DispatchQueue.main.async {
                self.deviceTxt.text = deviceName
                self.versionTxt.text = "Version: \(deviceVersion!)"
                self.serialNumTxt.text = "Serial Number: \(deviceSerialNumber!)"
                self.channelTxt.text = "Channel: \(channel!)"
            }
            
        }
    }
}
