#===============================================================================
# This example begins by creating a DataAdapter object. Before opening the DataAdapter object, we add attach, detach, error, and data handlers. (Check your device's user guide for more information).
# We then open the the Sound object on a hub with a specified serial number, port, and channel (these are defined at the top of the main method) and wait for an attachment.
# 
# When the device has attached, the attach handler that we have previously defined will execute. In this handler, we will relay some basic information about the device to the console.
# Likewise, when the hub loses communication with the device, the detach handler will execute and inform us of the event.
# 
# If the master device sends data, our data handler will execute and allow us to see what was sent. We can send data after the attach handler by using the following:
#     object.writeData(data,length)
#===============================================================================
from ctypes import *
import sys
from array import *
from Phidgets.VINT.PhidgetVINT import PhidgetVINT, PhidgetVINTID, PhidgetVINTClass
from Phidgets.PhidgetException import PhidgetErrorCodes, PhidgetException
from Phidgets.VINT.Events.VINTEvents import DataAdapterDataEventArgs
from Phidgets.VINT.Devices.DataAdapter import DataAdapter 
HUB_SERIAL_NUMBER = -1 #You can change this value to match your VINT HUBs Serial Number. -1 is generic and works for any hub
DataAdapter_PORT = 0 #Change this value to match corresponding port being used on the HUB
DataAdapter_CHANNEL = 0 #Change this value to match corresponding channel being used on the port

try:
    dataadapter = DataAdapter()
except RuntimeError as e:
    print("Runtime Exception %s" % e.details)
    print("Exiting...")
    exit(1)
if(HUB_SERIAL_NUMBER == -1):
    print("\nThis example requires a DataAdapter device to be plugged in to a hub with any serial number.\nPlug your device on Port: %d" % DataAdapter_PORT)
else:
    print("\nThis example requires a DataAdapter device to be plugged in to a hub with \nserial number: %d\nPlug in your device on Port: %d" % (HUB_SERIAL_NUMBER, DataAdapter_PORT))    
def DataAdapterAttached(e):
    
#use this method of creating a byte array for Python 2
    data = ''.join(chr(x) for x in [0,1,2,3,4,255])
#use this method of creating a byte array for Python 3
#    data = bytes([1,2,3,4,5,255])
    try:
        attached = e.device
        print("\nAttach Event Detected (Information Below)")
        print("===========================================")
        print("Library Version: %s" % attached.getLibraryVersion())
        print("Hub Serial Number: %d" % attached.getHubSerialNumber())
        print("Hub Version: %s" % attached.getHubVersion())
        print("Hub ID: %d" % attached.getHubID())
        print("Hub Name: %s" % attached.getHubName())
        print("Hub Port: %d" % attached.getHubPort())
        print("Hub Port Count: %d" % attached.getHubPortCount())
        print("Device is a Hub Port Device: %d" % attached.isHubPortDevice())
        print("Channel: %d" % attached.getChannel())
        print("Channel Class: %s" % attached.getChannelClass())
        print("Channel Name: %s" % attached.getChannelName())
        print("Device ID: %d" % attached.getDeviceID())
        print("Device Version: %d" % attached.getDeviceVersion())
        print("Device Name: %s" % attached.getDeviceName())
        print("\n")
        attached.writeData(data,6)
    except PhidgetException as e:
        print("Phidget Exception %i: %s" % (e.code, e.details))
        print("Exiting....")
        exit(1)   

def DataAdapterDetached(e):
    detached = e.device
    try:
        print("\nDetach event on Port %d Channel %d" % (detached.getHubPort(), detached.getChannel()))
    except PhidgetException as e:
        print("Phidget Exception %i: %s" % (e.code, e.details))
        print("Exiting....")
        exit(1)   
def ErrorEvent(e):
    print("Error %i : %s" % (e.eCode, e.description))
    
def DataAdapterDataHandler(e):
    for i in range(0,e.length):
        print("Data[%d]: %d" % (i,(e.data[i]) & 0xFF))
          
try:
    dataadapter.setOnAttachHandler(DataAdapterAttached)
    dataadapter.setOnDetachHandler(DataAdapterDetached)
    dataadapter.setDataAdapterDataHandler(DataAdapterDataHandler)
    dataadapter.setOnErrorhandler(ErrorEvent)
    dataadapter.open(HUB_SERIAL_NUMBER, DataAdapter_PORT, DataAdapter_CHANNEL)
    print("Waiting for the Phidget DataAdapter Object to be attached...")
    dataadapter.waitForAttach()
except PhidgetException as e:
    print("Phidget Exception %i: %s" % (e.code, e.details))
    print("Exiting....")
    exit(1) 
    
print("Press Enter to quit...")
readin = sys.stdin.read(1)
try:
    dataadapter.close()
except PhidgetException as e:
    print("Phidget Exception %i: %s" % (e.code, e.details))
    print("Exiting....")
    exit(1) 
print("\nClosed DataAdapter device")
exit(0)
                     
