var jPhidget22 = require('phidget22');

var SERVER_PORT = 5661;

function main() {

	if (process.argv.length != 3) {
		console.log('usage: node PowerGuard.js <server address>');
		process.exit(1);
	}

	var url = 'phid://' + process.argv[2] + ':' + SERVER_PORT;

	console.log('connecting to:' + url);
	var conn = new jPhidget22.Connection(url, { name: 'Server Connection', passwd: '' });
	conn.connect()
	  .then(runExample)
	  .catch(function (err) {
	  	console.log('Error running example:' + err);
		process.exit(1);
	  });
}

function runExample() {

	console.log('connected to server');
	var ch = new jPhidget22.PowerGuard();

	ch.onAttach = function(ch) {
		console.log(ch + ' attached');
		ch.setOverVoltage(13);
		ch.setFanMode(jPhidget22.FanMode.FAN_MODE_ON);
		ch.setPowerEnabled(1);
	};

	ch.onDetach = function(ch) {
		console.log(ch + ' detached');
	};

	ch.onError = function (code, desc) {
		console.log('Error (' + code + ') ' + desc);
	};
	
	ch.open().then(function (ch) {
		console.log('channel open');
	}).catch(function (err) {
		console.log('failed to open the channel:' + err);
	});
}

if (require.main === module)
	main();
