var jPhidget22 = require('phidget22');

var SERVER_PORT = 5661;

function main() {

	if (process.argv.length != 3) {
		console.log('usage: node Magnetometer.js <server address>');
		process.exit(1);
	}

	var url = 'phid://' + process.argv[2] + ':' + SERVER_PORT;

	console.log('connecting to:' + url);
	var conn = new jPhidget22.Connection(url, { name: 'Server Connection', passwd: '' });
	conn.connect()
	  .then(runExample)
	  .catch(function (err) {
	  	console.log('Error running example:' + err);
		process.exit(1);
	  });
}

function runExample() {

	console.log('connected to server');
	var ch = new jPhidget22.Magnetometer();

	ch.onAttach = function(ch) {
		console.log(ch + ' attached');
		console.log('Min Magnetic Field: ' + ch.getMinMagneticField());
		console.log('Max Magnetic Field: ' + ch.getMaxMagneticField());
	};

	ch.onDetach = function(ch) {
		console.log(ch + ' detached');
	};

	ch.onMagneticFieldChange = function (magneticField, timestamp) {
        var gmag = this.getMagneticField();
        console.log('mag fld x:' + magneticField[0] + ' (' + gmag[0] + ')' +
		  ' y:' + magneticField[1] + '(' + gmag[1] + ') z:' + magneticField[2] + ' (' + gmag[2] + ')');
		console.log('timestamp: ' + timestamp);
		console.log('');
	};

	ch.open().then(function (ch) {
		console.log('channel open');
	}).catch(function (err) {
		console.log('failed to open the channel:' + err);
	});
}

if (require.main === module)
	main();
