var jPhidget22 = require('phidget22');

var SERVER_PORT = 5661;

function main() {

	if (process.argv.length != 3) {
		console.log('usage: node FrequencyCounter.js <server address>');
		process.exit(1);
	}

	var url = 'phid://' + process.argv[2] + ':' + SERVER_PORT;

	console.log('connecting to:' + url);
	var conn = new jPhidget22.Connection(url, { name: 'Server Connection', passwd: '' });
	conn.connect()
	  .then(runExample)
	  .catch(function (err) {
	  	console.log('Error running example:' + err);
		process.exit(1);
	  });
}

function runExample() {

	console.log('connected to server');
	var ch = new jPhidget22.FrequencyCounter();

	ch.onAttach = function(ch) {
		console.log(ch + ' attached');
		if(ch.getDeviceID() == jPhidget22.DeviceID.PHIDID_1054) {
			ch.setEnabled(1);
			ch.setFilterType(jPhidget22.FilterType.FILTER_TYPE_LOGIC_LEVEL);
		}
	};

	ch.onDetach = function(ch) {
		console.log(ch + ' detached');
	};

	ch.onCountChange = function (counts, timeChange) {
        console.log('counts:' + counts);
		console.log('timeChange:' + timeChange);
		console.log('count:' + this.getCount());
	};
	
	ch.onFrequencyChange = function (frequency) {
        console.log('frequency: ' + frequency + ' (' + this.getFrequency() + ')');
	};


	ch.open().then(function (ch) {
		console.log('channel open');
	}).catch(function (err) {
		console.log('failed to open the channel:' + err);
	});
}

if (require.main === module)
	main();
