var jPhidget22 = require('phidget22');

var SERVER_PORT = 5661;

function main() {

	if (process.argv.length != 3) {
		console.log('usage: node Encoder.js <server address>');
		process.exit(1);
	}

	var url = 'phid://' + process.argv[2] + ':' + SERVER_PORT;

	console.log('connecting to:' + url);
	var conn = new jPhidget22.Connection(url, { name: 'Server Connection', passwd: '' });
	conn.connect()
	  .then(runExample)
	  .catch(function (err) {
	  	console.log('Error running example:' + err);
		process.exit(1);
	  });
}

function runExample() {

	console.log('connected to server');
	var ch = new jPhidget22.Encoder();

	ch.onAttach = function(ch) {
		console.log(ch + ' attached');
		if(!ch.getEnabled())
			ch.setEnabled(1);
	};

	ch.onDetach = function(ch) {
		console.log(ch + ' detached');
	};

	ch.onPositionChange = function (positionChange, timeChange, indexTriggered) {
        console.log('Position Changed: ' + positionChange + ' | ' + timeChange + ' | ' + indexTriggered + ' | ' + this.getPosition());
	};

	ch.open().then(function (ch) {
		console.log('channel open');
	}).catch(function (err) {
		console.log('failed to open the channel:' + err);
	});
}

if (require.main === module)
	main();
