var jPhidget22 = require('phidget22');

var SERVER_PORT = 5661;

function main() {

	if (process.argv.length != 3) {
		console.log('usage: node Dictionary.js <server address>');
		process.exit(1);
	}

	var url = 'phid://' + process.argv[2] + ':' + SERVER_PORT;

	console.log('connecting to:' + url);
	var conn = new jPhidget22.Connection(url, { name: 'Server Connection', passwd: '' });
	conn.connect()
	  .then(runExample)
	  .catch(function (err) {
	  	console.log('Error running example:' + err);
		process.exit(1);
	  });
}

var allkeys = [];
function getKeys(dict, startKey) {

	return (new Promise(function (resolve, reject) {

		dict.scan(startKey).then(function (keys) {
			resolve(keys);
		}).catch(function (err) {
			reject(err);
		});
	})).then(function (keys) {
		if (keys.length == 0)
			return (allkeys);
		allkeys = allkeys.concat(keys);
		return (getKeys(dict, keys[keys.length - 1]));
	});
}

function scanKeys(dict) {

	getKeys(dict, '').then(function (keys) {
		console.log('----------\nkeys\n----------');
		for (var i in keys) {
			dict.get(keys[i]).then(function (val) {
				console.log(this + ' = ' + val);
			}.bind(keys[i]));
		}
	});
}

function runExample() {

	var d = new jPhidget22.Dictionary();

	/*
	 * Dictionaries are virtual phidgets: the Phidget Network Server has a test dictionary create
	 * with serial number 1001.
	 */
	d.setDeviceSerialNumber(1001);

	d.onAttach = function(ch) {
		console.log(ch + ' attached');
	};

	d.onDetach = function(ch) {
		console.log(ch + ' detached');
	};

	d.onAdd = function (key, value) {
		console.log('added:' + key + '=' + value);
	};

	d.onUpdate = function (key, value) {
		console.log('updated:' + key + '=' + value);
	};

	d.onRemove = function (key) {
		console.log('removed:' + key);
	};

	d.open().then(function (ch) {
		console.log('channel open');
		d.remove('testkey').then(function () {
			/* onRemove() may fire if the key already exists. */
			return (d.add('testkey', 'testvalue'));
		}).then(function () {
			/* onAdd() should fire */
			return (d.add('testkey', 'testvalue')); /* expected to fail */
		}).then(function () {
			console.log('XXX this should be an error since we already added "testkey"');
		}).catch(function (err) {
			console.log('dictionary error:' + err + ':0x' + err.phidgetReturnCode.toString(16));
			return (d.update('testkey', 'testvalue2'));
		}).then(function () {
			/* onUpdate() should fire */
			return (d.remove('testkey'));
		}).then(function () {
			/* onRemove() should fire */
			scanKeys(d);
		}).catch(function (err) {
			console.log('failed to update dictionary');
		});
	}).catch(function (err) {
		console.log('failed to open dictionary');
	});
}

if (require.main === module)
	main();
