/*
 * Decompiled with CFR 0.152.
 */
package com.phidget22;

import com.phidget22.Phidget;
import com.phidget22.PhidgetException;
import com.phidget22.RFIDProtocol;
import com.phidget22.RFIDTag;
import com.phidget22.RFIDTagEvent;
import com.phidget22.RFIDTagListener;
import com.phidget22.RFIDTagLostEvent;
import com.phidget22.RFIDTagLostListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RFIDBase
extends Phidget {
    private List<RFIDTagListener> tagListeners = new ArrayList<RFIDTagListener>();
    private long nativeTagHandler = 0L;
    private List<RFIDTagLostListener> tagLostListeners = new ArrayList<RFIDTagLostListener>();
    private long nativeTagLostHandler = 0L;

    RFIDBase(long l) {
        super(l);
    }

    public RFIDBase() throws PhidgetException {
        super(RFIDBase.create());
    }

    private static native long create() throws PhidgetException;

    private final void setDeviceEvents(boolean bl) {
        this.enableTagEvents(bl && this.tagListeners.size() > 0);
        this.enableTagLostEvents(bl && this.tagLostListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTagListener(RFIDTagListener rFIDTagListener) {
        List<RFIDTagListener> list = this.tagListeners;
        synchronized (list) {
            this.tagListeners.add(rFIDTagListener);
            this.enableTagEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTagListener(RFIDTagListener rFIDTagListener) {
        List<RFIDTagListener> list = this.tagListeners;
        synchronized (list) {
            this.tagListeners.remove(rFIDTagListener);
            this.enableTagEvents(this.tagListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTag(RFIDTagEvent rFIDTagEvent) {
        List<RFIDTagListener> list = this.tagListeners;
        synchronized (list) {
            Iterator<RFIDTagListener> iterator = this.tagListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onTag(rFIDTagEvent);
            }
        }
    }

    private native void enableTagEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addTagLostListener(RFIDTagLostListener rFIDTagLostListener) {
        List<RFIDTagLostListener> list = this.tagLostListeners;
        synchronized (list) {
            this.tagLostListeners.add(rFIDTagLostListener);
            this.enableTagLostEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeTagLostListener(RFIDTagLostListener rFIDTagLostListener) {
        List<RFIDTagLostListener> list = this.tagLostListeners;
        synchronized (list) {
            this.tagLostListeners.remove(rFIDTagLostListener);
            this.enableTagLostEvents(this.tagLostListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTagLost(RFIDTagLostEvent rFIDTagLostEvent) {
        List<RFIDTagLostListener> list = this.tagLostListeners;
        synchronized (list) {
            Iterator<RFIDTagLostListener> iterator = this.tagLostListeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onTagLost(rFIDTagLostEvent);
            }
        }
    }

    private native void enableTagLostEvents(boolean var1);

    public native boolean getAntennaEnabled() throws PhidgetException;

    public native void setAntennaEnabled(boolean var1) throws PhidgetException;

    public native RFIDTag getLastTag() throws PhidgetException;

    public native boolean getTagPresent() throws PhidgetException;

    public native void write(String var1, RFIDProtocol var2, boolean var3) throws PhidgetException;
}

