package com.example.PhidgetGPSExample;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.phidget22.*;

public class GPSExample extends Activity {

	GPS ch;

	Toast errToast;

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstancePositionFixState) {
        super.onCreate(savedInstancePositionFixState);
        setContentView(R.layout.main);

        //Hide device information and settings until one is attached
		LinearLayout settingsAndData = (LinearLayout) findViewById(R.id.settingsAndData);
		settingsAndData.setVisibility(LinearLayout.GONE);

        try
        {
        	ch = new GPS();

        	//Allow direct USB connection of Phidgets
			if(getPackageManager().hasSystemFeature(PackageManager.FEATURE_USB_HOST))
                com.phidget22.usb.Manager.Initialize(this);

			//Enable server discovery to list remote Phidgets
			this.getSystemService(Context.NSD_SERVICE);
			Net.enableServerDiscovery(ServerType.DEVICE_REMOTE);

			ch.addAttachListener(new AttachListener() {
				public void onAttach(final AttachEvent attachEvent) {
				    AttachEventHandler handler = new AttachEventHandler(ch);
                    synchronized(handler)
					{
						runOnUiThread(handler);
						try {
							handler.wait();
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}
				}
			});

			ch.addDetachListener(new DetachListener() {
				public void onDetach(final DetachEvent detachEvent) {
                    DetachEventHandler handler = new DetachEventHandler(ch);
                    synchronized(handler)
					{
						runOnUiThread(handler);
						try {
							handler.wait();
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
					}
				}
			});

			ch.addErrorListener(new ErrorListener() {
				public void onError(final ErrorEvent errorEvent) {
					ErrorEventHandler handler = new ErrorEventHandler(ch, errorEvent);
					runOnUiThread(handler);
				}
			});

			ch.addPositionFixStateChangeListener(new GPSPositionFixStateChangeListener() {
				public void onPositionFixStateChange(GPSPositionFixStateChangeEvent positionFixStateChangeEvent) {
                    GPSPositionFixStateChangeEventHandler handler = new GPSPositionFixStateChangeEventHandler(ch, positionFixStateChangeEvent);
                    runOnUiThread(handler);
                }
			});

			ch.addPositionChangeListener(new GPSPositionChangeListener() {
				public void onPositionChange(GPSPositionChangeEvent positionChangeEvent) {
					GPSPositionChangeEventHandler handler = new GPSPositionChangeEventHandler(ch, positionChangeEvent);
					runOnUiThread(handler);
				}
			});

			ch.addHeadingChangeListener(new GPSHeadingChangeListener() {
				public void onHeadingChange(GPSHeadingChangeEvent positionChangeEvent) {
					GPSHeadingChangeEventHandler handler = new GPSHeadingChangeEventHandler(ch, positionChangeEvent);
					runOnUiThread(handler);
				}
			});
			
			ch.open();
        } catch (PhidgetException pe) {
	        pe.printStackTrace();
		}

    }

    class AttachEventHandler implements Runnable { 
    	Phidget ch;

		public AttachEventHandler(Phidget ch) {
			this.ch = ch;
		}

		public void run() {
			LinearLayout settingsAndData = (LinearLayout) findViewById(R.id.settingsAndData);
			settingsAndData.setVisibility(LinearLayout.VISIBLE);

			TextView attachedTxt = (TextView) findViewById(R.id.attachedTxt);

			attachedTxt.setText("Attached");
			try {
				TextView nameTxt = (TextView) findViewById(R.id.nameTxt);
				TextView serialTxt = (TextView) findViewById(R.id.serialTxt);
				TextView versionTxt = (TextView) findViewById(R.id.versionTxt);
				TextView channelTxt = (TextView) findViewById(R.id.channelTxt);
				TextView hubPortTxt = (TextView) findViewById(R.id.hubPortTxt);
				TextView labelTxt = (TextView) findViewById(R.id.labelTxt);

				nameTxt.setText(ch.getDeviceName());
				serialTxt.setText(Integer.toString(ch.getDeviceSerialNumber()));
				versionTxt.setText(Integer.toString(ch.getDeviceVersion()));
				channelTxt.setText(Integer.toString(ch.getChannel()));
				hubPortTxt.setText(Integer.toString(ch.getHubPort()));
				labelTxt.setText(ch.getDeviceLabel());

			} catch (PhidgetException e) {
				e.printStackTrace();
			}

			//notify that we're done
			synchronized(this)
			{
				this.notify();
			}
		}
    }
    
    class DetachEventHandler implements Runnable {
    	Phidget ch;
    	
    	public DetachEventHandler(Phidget ch) {
    		this.ch = ch;
    	}
    	
		public void run() {
			LinearLayout settingsAndData = (LinearLayout) findViewById(R.id.settingsAndData);

			settingsAndData.setVisibility(LinearLayout.GONE);

			TextView attachedTxt = (TextView) findViewById(R.id.attachedTxt);
			attachedTxt.setText("Detached");

			TextView nameTxt = (TextView) findViewById(R.id.nameTxt);
			TextView serialTxt = (TextView) findViewById(R.id.serialTxt);
			TextView versionTxt = (TextView) findViewById(R.id.versionTxt);
			TextView channelTxt = (TextView) findViewById(R.id.channelTxt);
			TextView hubPortTxt = (TextView) findViewById(R.id.hubPortTxt);
			TextView labelTxt = (TextView) findViewById(R.id.labelTxt);

			nameTxt.setText(R.string.unknown_val);
			serialTxt.setText(R.string.unknown_val);
			versionTxt.setText(R.string.unknown_val);
			channelTxt.setText(R.string.unknown_val);
			hubPortTxt.setText(R.string.unknown_val);
			labelTxt.setText(R.string.unknown_val);

			//clear position data
            ((TextView)findViewById(R.id.latitudeTxt)).setText("");
            ((TextView)findViewById(R.id.longitudeTxt)).setText("");
            ((TextView)findViewById(R.id.altitudeTxt)).setText("");
            ((TextView)findViewById(R.id.velocityTxt)).setText("");
            ((TextView)findViewById(R.id.headingTxt)).setText("");

			//notify that we're done
			synchronized(this)
			{
				this.notify();
			}
		}
    }

	class ErrorEventHandler implements Runnable {
		Phidget ch;
		ErrorEvent errorEvent;

		public ErrorEventHandler(Phidget ch, ErrorEvent errorEvent) {
			this.ch = ch;
			this.errorEvent = errorEvent;
		}

		public void run() {
			 if (errToast == null)
				 errToast = Toast.makeText(getApplicationContext(), errorEvent.getDescription(), Toast.LENGTH_SHORT);

			 //replace the previous toast message if a new error occurs
			 errToast.setText(errorEvent.getDescription());
			 errToast.show();
        }
	}

	class GPSPositionFixStateChangeEventHandler implements Runnable {
		Phidget ch;
		GPSPositionFixStateChangeEvent positionFixStateChangeEvent;

		public GPSPositionFixStateChangeEventHandler(Phidget ch, GPSPositionFixStateChangeEvent positionFixStateChangeEvent) {
			this.ch = ch;
			this.positionFixStateChangeEvent = positionFixStateChangeEvent;
		}

		public void run() {
		    CheckBox positionFixStateBox = (CheckBox) findViewById(R.id.positionFixStateBox);
            boolean fixState = positionFixStateChangeEvent.getPositionFixState();

            positionFixStateBox.setChecked(fixState);

			//if we lost a fix, clear position data
			if(fixState == false) {
                ((TextView)findViewById(R.id.latitudeTxt)).setText("");
                ((TextView)findViewById(R.id.longitudeTxt)).setText("");
                ((TextView)findViewById(R.id.altitudeTxt)).setText("");
                ((TextView)findViewById(R.id.velocityTxt)).setText("");
                ((TextView)findViewById(R.id.headingTxt)).setText("");
            }
		}
	}

	class GPSPositionChangeEventHandler implements Runnable {
		Phidget ch;
		GPSPositionChangeEvent positionChangeEvent;

		public GPSPositionChangeEventHandler(Phidget ch, GPSPositionChangeEvent positionChangeEvent) {
			this.ch = ch;
			this.positionChangeEvent = positionChangeEvent;
		}

		public void run() {
			TextView latitudeTxt = (TextView) findViewById(R.id.latitudeTxt);
			TextView longitudeTxt = (TextView) findViewById(R.id.longitudeTxt);
			TextView altitudeTxt = (TextView) findViewById(R.id.altitudeTxt);

			latitudeTxt.setText(String.valueOf(positionChangeEvent.getLatitude()));
			longitudeTxt.setText(String.valueOf(positionChangeEvent.getLongitude()));
			altitudeTxt.setText(String.valueOf(positionChangeEvent.getAltitude()));
		}
	}

	class GPSHeadingChangeEventHandler implements Runnable {
		Phidget ch;
		GPSHeadingChangeEvent positionChangeEvent;

		public GPSHeadingChangeEventHandler(Phidget ch, GPSHeadingChangeEvent positionChangeEvent) {
			this.ch = ch;
			this.positionChangeEvent = positionChangeEvent;
		}

		public void run() {
			TextView velocityTxt = (TextView) findViewById(R.id.velocityTxt);
			TextView headingTxt = (TextView) findViewById(R.id.headingTxt);

			velocityTxt.setText(String.valueOf(positionChangeEvent.getVelocity()));
			headingTxt.setText(String.valueOf(positionChangeEvent.getHeading()));
		}
	}
	
    @Override
    protected void onDestroy() {
    	super.onDestroy();
    	try {
			ch.close();

		} catch (PhidgetException e) {
			e.printStackTrace();
		}

		//Disable USB connection to Phidgets
    	if(getPackageManager().hasSystemFeature(PackageManager.FEATURE_USB_HOST))
            com.phidget22.usb.Manager.Uninitialize();
    }

}

