import com.phidget22.*;

public class StepperExample {

    public static void main(String[] args) throws Exception {
        //Enable logging to stdout
        com.phidget22.Log.enable(LogLevel.INFO, null);

        Stepper ch = new Stepper();

        ch.addAttachListener(new AttachListener() {
			public void onAttach(AttachEvent ae) {
				Stepper phid = (Stepper) ae.getSource();
				try {
					if(phid.getDeviceClass() != DeviceClass.VINT){
						System.out.println("channel " + phid.getChannel() + " on device " + phid.getDeviceSerialNumber() + " attached");
					}
					else{
						System.out.println("channel " + phid.getChannel() + " on device " + phid.getDeviceSerialNumber() + " hub port " + phid.getHubPort() + " attached");
					}
				} catch (PhidgetException ex) {
					System.out.println(ex.getDescription());
				}
			}
        });

        ch.addDetachListener(new DetachListener() {
			public void onDetach(DetachEvent de) {
				Stepper phid = (Stepper) de.getSource();
				try {
					if (phid.getDeviceClass() != DeviceClass.VINT) {
						System.out.println("channel " + phid.getChannel() + " on device " + phid.getDeviceSerialNumber() + " detached");
					} else {
						System.out.println("channel " + phid.getChannel() + " on device " + phid.getDeviceSerialNumber() + " hub port " + phid.getHubPort() + " detached");
					}
				} catch (PhidgetException ex) {
					System.out.println(ex.getDescription());
				}
			}
        });

        ch.addErrorListener(new ErrorListener() {
			public void onError(ErrorEvent ee) {
				System.out.println("Error: " + ee.getDescription());
			}
		});

        ch.addPositionChangeListener(new StepperPositionChangeListener() {
			public void onPositionChange(StepperPositionChangeEvent e) {
				System.out.printf("Position Changed: %.0f\n", e.getPosition());
			}
        });
        
        ch.addVelocityChangeListener(new StepperVelocityChangeListener() {
			public void onVelocityChange(StepperVelocityChangeEvent e) {
				System.out.printf("Velocity Changed: %.0f\n", e.getVelocity());
			}
        });
        
        ch.addStoppedListener(new StepperStoppedListener() {
			public void onStopped(StepperStoppedEvent e) {
				System.out.println("Stopped!");
			}
        });
        try {
             /*
            * Please review the Phidget22 channel matching documentation for details on the device
            * and class architecture of Phidget22, and how channels are matched to device features.
            */

            /*
            * Specifies the serial number of the device to attach to.
            * For VINT devices, this is the hub serial number.
            *
            * The default is any device.
            */
            //ch.setDeviceSerialNumber(<YOUR DEVICE SERIAL NUMBER>);
            /*
            * For VINT devices, this specifies the port the VINT device must be plugged into.
            *
            * The default is any port.
            */
            //ch.setHubPort(0);

            /*
            * Specifies that the channel should only match a VINT hub port.
            * The only valid channel id is 0.
            *
            * The default is 0 (false), meaning VINT hub ports will never match
            */
             //ch.setIsHubPortDevice(true);

            /*
            * Specifies which channel to attach to.  It is important that the channel of
            * the device is the same class as the channel that is being opened.
            *
            * The default is any channel.
            */
            //ch.setChannel(0);

            /*
            * In order to attach to a network Phidget, the program must connect to a Phidget22 Network Server.
            * In a normal environment this can be done automatically by enabling server discovery, which
            * will cause the client to discovery and connect to available servers.
            *
            * To force the channel to only match a network Phidget, set remote to 1.
            */
            // Net.enableServerDiscovery(ServerType.DEVICE);
            // ch.setIsRemote(true);
            
            System.out.println("Opening and waiting 5 seconds for attachment...");
            ch.open(5000);
            
            System.out.println("Engaging the motor!");
            ch.setEngaged(true);
            
            System.out.println("Opening and waiting 5 seconds for attachment...");
            ch.open(5000);
            
            System.out.println("\n\nSetting target position to 15000 for 5 seconds...\n\n");
            ch.setTargetPosition(15000);
            Thread.sleep(5000);
            
            System.out.println("\n\nSetting target position to -15000 for 5 seconds...\n\n");
            ch.setTargetPosition(-15000);
            Thread.sleep(5000);
            
            System.out.println("\n\nSetting target position to 0 for 5 seconds...\n\n");
            ch.setTargetPosition(0);
            Thread.sleep(5000);

            ch.close();
            System.out.println("\nClosed Stepper");
            
        } catch (PhidgetException ex) {
            System.out.println(ex.getDescription());
        }
    }
}
