import com.phidget22.*;

public class LogExample {

    public static void main(String[] args) throws Exception {
		try {
			//Let's start by logging some messages to the console to easily see the results
			System.out.println("\nLogging to the Console\n");

			//First, we enable the log
			Log.enable(LogLevel.INFO, null);

			System.out.println("\nYou should see both log messages.\n");

			//You can send your own messages to the Phidget log
			Log.log(LogLevel.ERROR, "Custom Log Error 0");

			Log.log(LogLevel.INFO, "Custom Log Info 1");

			Thread.sleep(3000);

			//Now we'll disable the log, so we can set it up to write to a file
			Log.disable();
			
			//Next let's log to a file	
			System.out.println("\nLogging to File\n");

			//Here, we'll log to a file called log.txt in the same folder as the C program
			Log.enable(LogLevel.INFO, "log.txt");
			
			//You can send your own messages to the Phidget log
			Log.log(LogLevel.ERROR, "Custom Log Error 2");

			Log.log(LogLevel.INFO, "Custom Log Info 3");
			
			Log.disable();
			
			System.out.println("\nNow you can open the log file to view the results\n");
			
			Thread.sleep(10000);

        } catch (PhidgetException ex) {
            System.out.println(ex);
        }
    }
	
	// Demo function implementation. Here is source code to demonstrate the more obscure
	// functionality of the Log object.

	public static void demo_log_level() throws Exception {
		try {
			//Log levels serve to filter out unwanted information from the log

			//To demonstrate, we'll enable the log with log level LogLevel.INFO
			Log.enable(LogLevel.INFO, "log_level_log.txt");

			System.out.println("\nDemonstrating log level LogLevel.INFO\n");
			System.out.println("You should see both log messages in log_level_log.txt\n");

			//You can send your own messages to the Phidget log
			Log.log(LogLevel.INFO, "Custom Log Info 0");

			Log.log(LogLevel.ERROR, "Custom Log Error 1");

			//Now we'll repeat the precess, using log level ERROR
			Log.setLevel(LogLevel.ERROR);

			System.out.println("\nDemonstrating log level LogLevel.ERROR\n");
			System.out.println("You should only see the log message produced by LogLevel.ERROR.\n");

			//Note that the message flagged as INFO will not appear when using log level ERROR
			//This helps filter out unwanted informaiton from the log
			Log.log(LogLevel.INFO, "Custom Log Info 2");

			Log.log(LogLevel.ERROR, "Custom Log Error 3");

			Log.disable();

			Thread.sleep(5000);
		} catch (PhidgetException ex) {
            System.out.println(ex);
        }
	}

	public static void demo_rotation() throws Exception {
		try {
			//We'll set up a rotation to keep the file size to 50kB max, 
			//and allow storage of the latest 3 log files
			Log.setRotating(50000, 3);

			//Here, we'll log to a file called rotation_log.txt in the same folder as the C program
			Log.enable(LogLevel.INFO, "rotation_log.txt");

			System.out.println("\nLogging to rotation_log.txt File...\n");
			//Now we'll log 1000 messages to the log file
			//Once complete, open the file to see the results of logging and rotation
			for (int i = 0; i < 1000; i++) {
				Log.log(LogLevel.INFO, "Custom Log Sequential Logs: " + i);
				Thread.sleep(2);
			}

			Log.disable();

			System.out.println("\nNow you can open rotation_log.txt to view the results\n");

			Thread.sleep(5000);
		} catch (PhidgetException ex) {
            System.out.println(ex);
        }
	}

	public static void demo_custom_source() throws Exception {
		try {
			//Here we'll demonstrate the use of custom log sources, which may be useful to add customized logging
			//to your applicaiton.
			Log.enable(LogLevel.INFO, "custom_source_log.txt");

			System.out.println("\nDemonstrating Custom Source Log\n");

			Log.addSource("demo_src", LogLevel.INFO);

			Log.log(LogLevel.INFO, "demo_src", "Custom Source Test");

			System.out.println("\nNow you can open custom_source_log.txt to view the results\n");

			Log.disable();
		} catch (PhidgetException ex) {
            System.out.println(ex);
        }
	}

	public static void demo_source_level() throws Exception {
		//Setting up a manager to be used to demonstrate logging
		//Not required, but serves as a convenient source of log entries
		Manager phidman = new Manager();
		
		try {
			System.out.println("\nDemonstrating Source Level\n");

			Log.enable(LogLevel.INFO, "source_level_log.txt");

			System.out.println("\nSetting source _phidget22channel to LogLevel.VERBOSE\n");

			//Knowing the list of sources, you can set a specific source to a different
			//log level than the others, to allow more or less detail for that source
			Log.setSourceLevel("_phidget22channel", LogLevel.VERBOSE);

			System.out.println("\nOpening Manager: Plug and unplug Phidgets, then check source_level_log.txt to\nsee what happened\n");

			phidman.open();

			Thread.sleep(5000);

			System.out.println("\nClosing Manager\n");

			phidman.close();

			Thread.sleep(1000);

			Log.disable();

			Thread.sleep(10000);
		} catch (PhidgetException ex) {
            System.out.println(ex);
        }

	}
	
	public static void demo_list_sources() throws Exception {
		//Listing Log Sources
		try {
			System.out.println("\nPrinting Log Sources\n");
			String[] sources = Log.getSources();
			System.out.println(sources);
			for (int i=0;i<sources.length;i++)
				System.out.println(i + sources[i]);

			Thread.sleep(5000);
		} catch (PhidgetException ex) {
            System.out.println(ex);
        }

	}
}
