import com.phidget22.*;

public class DictionaryExample {

    public static void main(String[] args) throws Exception {
        //Enable logging to stdout
        //com.phidget22.Log.enable(LogLevel.INFO, null);
        
        Dictionary dict = new Dictionary();

        dict.addAddListener(new DictionaryAddListener() {
			public void onAdd(DictionaryAddEvent ae) {
				System.out.println("-----------------");
				System.out.println("Key Added:");
				System.out.println("Key: " + ae.getKey());
				System.out.println("Value: " + ae.getValue());
			}
        });

        dict.addUpdateListener(new DictionaryUpdateListener() {
			public void onUpdate(DictionaryUpdateEvent ae) {
				System.out.println("-----------------");
				System.out.println("Key Updated:");
				System.out.println("Key: " + ae.getKey());
				System.out.println("Value: " + ae.getValue());
			}
        });

        dict.addRemoveListener(new DictionaryRemoveListener() {
			public void onRemove(DictionaryRemoveEvent ae) {
				System.out.println("-----------------");
				System.out.println("Key Removed:");
				System.out.println("Key: " + ae.getKey());
			}
        });

        try {
			String result;

			System.out.println("This example requires that you have already created a dictionary labeled");
			System.out.println("\"testdict\" in the control panel for the server hosting your dictionary.\n");
			
			Net.enableServerDiscovery(ServerType.DEVICE_REMOTE);			
			
			dict.setDeviceLabel("testdict");
			
            System.out.println("Opening and waiting 20 seconds for attachment...");
            dict.open(20000);
            
            //Set can be used to set the a value for a key even if the key doesn't exist yet
			dict.set("key1", "value");
			result = dict.get("key1");
			System.out.println("Result 1: " + result);

			Thread.sleep(3000);

			dict.set("key1", "set 2");
			result = dict.get("key1");
			System.out.println("Result 2: " + result);

			Thread.sleep(3000);

			//Update can be used to update the value of pre-existing keys
			dict.update("key1", "updated");
			result = dict.get("key1");
			System.out.println("Result 3: " + result);

			Thread.sleep(3000);

			//As you might expect, Remove removes keys from the dictionary
			System.out.println("Removing key1");
			dict.remove("key1");

			Thread.sleep(3000);

			//You can add keys explicitly, to only add them if they don't yet exist.
			dict.add("key1", "added key1");
			result = dict.get("key1");
			System.out.println("Result 4: " + result);

			Thread.sleep(3000);

			System.out.println("Removing key1");
			dict.remove("key1");
			
			System.out.println("\nListing Keys: \n");

			listKeys(dict);

			System.out.println("\nActive demonstration complete.\n");
			System.out.println("Now would be a good time to try out the events by running a second copy of this");
			System.out.println("program, or using the control panel example to edit key-value pairs in the");
			System.out.println("test dictionary.\n");

			System.out.println("\nPress Enter to end anytime...\n");
			System.in.read();

            dict.close();
            System.out.println("\nClosed Dictionary");
            
        } catch (PhidgetException ex) {
            System.out.println(ex);
        }
    }
	
	private static void listKeys(Dictionary dict) throws Exception {
		try {
			String start = "";
			int length;
			
			do {
				String[] newKeys = dict.scan(start);
				for(int i = 0; i < newKeys.length; i++) {
					System.out.println(newKeys[i]);
				}
				if(newKeys.length > 0)
					start = newKeys[newKeys.length - 1];
				length = newKeys.length;
			} while(length > 0);
			
		} catch (PhidgetException ex) {
            System.out.println(ex);
        }
	}
}
