'A reference to the Phidget22.NET.dll must be added to new projects in VB.Net 
'From the "Project" menu select "Add Reference" 
'From the "Add Reference" window select the "Browse" tab 
'Browse to the directory you installed the Phidgets library to 
'The default is "C:\Program Files\Phidgets" 
'Select "Phidget22.NET.dll" and click "OK" 
'To view objects that have been added, select the "View" menu 
'Select "Object Browser" 
'Then expand the Phidget22.NET.dll item 



Imports Phidget22
Imports Phidget22.Events

Public Class Form1
    Dim WithEvents device As Phidget22.LightSensor
    Dim open As ExampleUtils.ExampleUtils.CommandLineOpen
    Dim errorBox As ErrorEventBox

    Public Sub New()
        open = New ExampleUtils.ExampleUtils.CommandLineOpen(Me)
        Phidget22.Phidget.InvokeEventCallbacks = True
        InitializeComponent()
    End Sub

    Public Sub New(ByVal commandLine As String())
        open = New ExampleUtils.ExampleUtils.CommandLineOpen(Me)
        open.commandLine = commandLine
        Phidget22.Phidget.InvokeEventCallbacks = True
        InitializeComponent()
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        errorBox = New ErrorEventBox(Me)
        device = New Phidget22.LightSensor()

        'open the device
        Dim phidgetParameters As ExampleUtils.commandLineData = open.parseCmdLine()

        Try 'set all the values grabbed from command line.  these values have defaults that are set in ExampleUtils.vb, you can check there to see them
            device.Channel = phidgetParameters.Channel 'selects the channel on the device to open
            device.DeviceSerialNumber = phidgetParameters.SerialNumber 'selects the device or hub to open
            device.HubPort = phidgetParameters.HubPort 'selects th eport on the hub to open
            device.IsHubPortDevice = phidgetParameters.isHubPortDevice 'is the device a port on a vint hub?

            If phidgetParameters.isRemote Then 'are we trying to open a remote device?
                device.IsRemote = True
                Net.EnableServerDiscovery(ServerType.Device) 'turn on network scan
                If phidgetParameters.Password <> vbNullString And phidgetParameters.ServerName <> vbNullString Then
                    Net.SetServerPassword(phidgetParameters.ServerName, phidgetParameters.Password)
                End If
            Else
                device.IsLocal = True
            End If

            device.Open() 'open the device specified by the above parameters
        Catch ex As PhidgetException
            errorBox.addMessage("Error opening the device: " + ex.Message)
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If device.Attached Then
            device.Close()
        End If
    End Sub

    Private Sub device_Attach(ByVal sender As Object, ByVal e As Phidget22.Events.AttachEventArgs) Handles device.Attach
        Dim attachedDevice As LightSensor = CType(sender, LightSensor)
        PhidgetInfoBox1.FillPhidgetInfo(attachedDevice)

        Try
            'initialize form controls.  change trigger and data interval must be set before the device will function
            dataIntervalTrk.Unit = "ms"
            dataIntervalTrk.minTxt = attachedDevice.MinDataInterval.ToString()
            dataIntervalTrk.Minimum = attachedDevice.MinDataInterval
            dataIntervalTrk.maxTxt = attachedDevice.MaxDataInterval.ToString()
            dataIntervalTrk.Maximum = attachedDevice.MaxDataInterval
            dataIntervalTrk.Value = attachedDevice.DataInterval

            changeTriggerTrk.Unit = "lx"
            changeTriggerTrk.minTxt = attachedDevice.MinIlluminanceChangeTrigger.ToString()
            changeTriggerTrk.Minimum = attachedDevice.MinIlluminanceChangeTrigger
            changeTriggerTrk.Maximum = attachedDevice.MaxIlluminanceChangeTrigger
            changeTriggerTrk.maxTxt = attachedDevice.MaxIlluminanceChangeTrigger.ToString()
            changeTriggerTrk.trkText = attachedDevice.IlluminanceChangeTrigger.ToString()
            changeTriggerTrk.Value = attachedDevice.IlluminanceChangeTrigger
        Catch ex As PhidgetException
            errorBox.addMessage("Error initializing: " + ex.Message)
        End Try

        outputBox.Visible = True
        settingsBox.Visible = True

    End Sub
    Private Sub device_Detach(ByVal sender As Object, ByVal e As Phidget22.Events.DetachEventArgs) Handles device.Detach
        'If the Phidget Light detaches close the form
        PhidgetInfoBox1.Clear()

        settingsBox.Visible = False
        outputBox.Visible = False

    End Sub

    Private Sub device_Error(ByVal sender As Object, ByVal e As Phidget22.Events.ErrorEventArgs) Handles device.Error
        errorBox.addMessage("Error: " + e.Description)
    End Sub

    Private Sub device_IlluminanceChange(ByVal sender As Object, ByVal e As Phidget22.Events.LightSensorIlluminanceChangeEventArgs) Handles device.IlluminanceChange

        Try
            luxvalue.Text = e.Illuminance.ToString() + " lx"
        Catch ex As Exception
            errorBox.addMessage("Error reading illuminance: " = ex.Message)
        End Try
    End Sub

    Private Sub dataIntervalTrk_Scroll(sender As Object, e As EventArgs) Handles dataIntervalTrk.LogScroll
        If (MouseButtons = MouseButtons.Left) Then
            Try
                device.DataInterval = CType(dataIntervalTrk.Value, Integer)
            Catch ex As Exception
                errorBox.addMessage("Error setting data interval: " + ex.Message)
            End Try
        End If
    End Sub

    Private Sub dataIntervalTrk_LogMouseUp(sender As Object, e As EventArgs) Handles dataIntervalTrk.LogMouseUp
        Try
            device.DataInterval = CType(dataIntervalTrk.Value, Integer)
        Catch ex As Exception
            errorBox.addMessage("Error setting data interval: " + ex.Message)
        End Try
    End Sub

    Private Sub changeTriggertrk_Scroll(sender As Object, e As EventArgs) Handles changeTriggerTrk.LogScroll
        If (MouseButtons = MouseButtons.Left) Then
            Try
                device.IlluminanceChangeTrigger = CType(changeTriggerTrk.Value, Integer)
            Catch ex As Exception
                errorBox.addMessage("Error setting data interval: " + ex.Message)
            End Try
        End If
    End Sub

    Private Sub changeTriggerTrk_LogMouseUp(sender As Object, e As EventArgs) Handles changeTriggerTrk.LogMouseUp
        Try
            device.IlluminanceChangeTrigger = CType(changeTriggerTrk.Value, Integer)
        Catch ex As Exception
            errorBox.addMessage("Error setting data interval: " + ex.Message)
        End Try
    End Sub
End Class



