﻿Imports System.Reflection
Imports System.ComponentModel
Imports Phidget22
Imports System.Runtime.CompilerServices

Namespace ExampleUtils
    Public Class ExampleUtils
        Public Class CommandLineOpen
            Dim form As Form
            Dim commandLineOverride(-1) As String

            Sub New(ByVal form As Form)
                Me.form = form
            End Sub

            Public Property commandLine As String()
                Get
                    Return If(commandLineOverride IsNot String.Empty, Environment.GetCommandLineArgs(), commandLineOverride)
                End Get
                Set(value As String())
                    commandLineOverride = value
                End Set
            End Property

            Public Function parseCmdLine() As commandLineData
                Dim args As String() = commandLine
                Dim appName As String = System.AppDomain.CurrentDomain.FriendlyName
                Dim p As commandLineData

                Dim channel As Integer = 0
                Dim serialNumber As Integer = -1
                Dim label As String = vbNullString
                Dim hubPort As Integer = 0
                Dim isHubPort As Boolean = False
                Dim networkServerName As String = vbNullString
                Dim password As String = vbNullString
                Dim logFile As String = vbNullString
                Dim isRemote As Boolean = False
                Dim isLocal As Boolean = True

                For i As Integer = 0 To args.Length - 1
                    If (args(i).EndsWith(appName)) Then
                        Continue For  'app name so we can ignore this argument
                    End If
                    If (args(i).StartsWith("-")) Then
                        Select Case args(i).Remove(0, 1).ToLower()
                            Case "v"
                                i += 1
                                hubPort = Integer.Parse(args(i))
                            Case "c"
                                i += 1
                                channel = Integer.Parse(args(i))
                            Case "l"
                                i += 1
                                logFile = args(i)
                            Case "L"
                                i += 1
                                label = args(i)
                            Case "n"
                                i += 1
                                serialNumber = Integer.Parse(args(i))
                            Case "h"
                                i += 1
                                isHubPort = True
                            Case "s"
                                i += 1
                                networkServerName = args(i)
                                isRemote = True
                                isLocal = False
                            Case "p"
                                i += 1
                                password = args(i)
                            Case Else
                                GoTo usage
                        End Select
                    Else
                        GoTo usage
                    End If
                Next

                If (logFile <> vbNullString) Then
                    Phidget22.Log.Enable(Phidget22.LogLevel.Info, logFile)
                End If

                p = New commandLineData(channel, serialNumber, hubPort, label, networkServerName, password, isRemote, isLocal, isHubPort)
                Return p
usage:
                Dim sb As String = vbNullString
                sb += "Invalid Command line arguments." + Environment.NewLine
                sb += ("Usage: " + appName + " [Flags...]\n")
                sb += ("Flags:\t-n   serialNumber: Serial Number, omit for any serial\n")
                sb += ("\t-l   logFile: Enable phidget21 logging to logFile.\n")
                sb += ("\t-v   Port: Select the  Port that the device is connected to. 0 by default\n")
                sb += ("\t-c   deviceChannel: Select the specific channel of the device you want.  0 by default.\n")
                sb += ("\t-h   HubPort?: The device is connected to a hub port.\n")
                sb += ("\t-s   serverID\tServer Name, omit for any server\n")
                sb += ("\t-i   ipAddress:port\tIp Address and Port. Port is optional, defaults to 5000\n")
                sb += ("\t-p   password\tPassword, omit for no password" + Environment.NewLine)
                sb += ("Examples: \n")
                sb += (appName + " -n 50098 -h\n")
                sb += (appName + " -n 1234567 -v 1 -c 0\n")
                sb += (appName + " -r")
                sb += (appName + " -s myphidgetserver\n")
                sb += (appName + " -n 45670 -i 127.0.0.1:5001 -p password\n")
                MessageBox.Show(sb.ToString(), "Argument Error", MessageBoxButtons.OK, MessageBoxIcon.Error)
                Application.Exit()
                Return New commandLineData(-1, -1, -1, Nothing, Nothing, Nothing, False, False, False)
            End Function
        End Class
    End Class

    Public Module EnumHelper
        Public Function GetDescription(ByVal value As [Enum]) As String
            If (value.Equals(Nothing)) Then
                Throw New ArgumentNullException("value")
            End If

            Dim fieldInfo As FieldInfo = value.GetType().GetField(value.ToString())
            Dim attributes() As DescriptionAttribute = DirectCast(fieldInfo.GetCustomAttributes(GetType(DescriptionAttribute), False), DescriptionAttribute())
            If attributes.Length > 0 Then
                Return attributes(0).Description
            Else
                Return value.ToString()
            End If
        End Function

        <Extension()>
        Public Function ToList(ByVal type As Type) As IList
            If (type Is Nothing) Then
                Throw New ArgumentNullException("type")
            End If
            Dim list As ArrayList = New ArrayList()
            Dim enumValues As Array = [Enum].GetValues(type)
            For Each value As [Enum] In enumValues
                list.Add(New KeyValuePair(Of [Enum], String)(value, GetDescription(value)))
            Next
            Return list
        End Function

        <Extension()>
        Public Function ToList(ByVal enumValues As [Enum]()) As IList
            If (enumValues Is Nothing) Then
                Throw New ArgumentNullException("type")
            End If
            Dim list As ArrayList = New ArrayList()
            For Each value As [Enum] In enumValues
                list.Add(New KeyValuePair(Of [Enum], String)(value, GetDescription(value)))
            Next
            Return list
        End Function
    End Module

    Public Class commandLineData
        Dim deviceChannel, deviceSerial, devicePort As Integer
        Dim deviceLabel, networkServerName, serverpassword As String
        Dim remoteDevice, localDevice, vintPortDevice As Boolean

        Sub New(ByVal channel As Integer, ByVal serialNumber As Integer, ByVal hubPort As Integer, ByVal label As String, ByVal serverName As String, ByVal password As String, ByVal isRemote As Boolean, ByVal isLocal As Boolean, ByVal isHubPort As Boolean)
            deviceChannel = channel
            deviceSerial = serialNumber
            devicePort = hubPort
            deviceLabel = label
            networkServerName = serverName
            remoteDevice = isRemote
            localDevice = isLocal
            vintPortDevice = isHubPort
            serverpassword = password
        End Sub

        Public ReadOnly Property Channel As Integer
            Get
                Return deviceChannel
            End Get
        End Property
        Public ReadOnly Property SerialNumber As Integer
            Get
                Return deviceSerial
            End Get
        End Property
        Public ReadOnly Property HubPort As Integer
            Get
                Return devicePort
            End Get
        End Property
        Public ReadOnly Property Label As String
            Get
                Return deviceLabel
            End Get
        End Property
        Public ReadOnly Property ServerName As String
            Get
                Return networkServerName
            End Get
        End Property
        Public ReadOnly Property Password As String
            Get
                Return serverpassword
            End Get
        End Property
        Public ReadOnly Property isRemote As Boolean
            Get
                Return remoteDevice
            End Get
        End Property
        Public ReadOnly Property isLocal As Boolean
            Get
                Return localDevice
            End Get
        End Property
        Public ReadOnly Property isHubPortDevice As Boolean
            Get
                Return vintPortDevice
            End Get
        End Property
    End Class
End Namespace