﻿Imports Phidget22

Public Class ErrorEventBox
    Dim errorCount As Integer = 0

    Sub New(ByVal owner As Form)
        InitializeComponent()
        Me.Owner = owner
    End Sub


    Private Sub ErrorEventBox_FormClosing(sender As Object, e As FormClosingEventArgs) Handles MyBase.FormClosing
        If (e.CloseReason = CloseReason.UserClosing) Then
            Me.Hide()
            e.Cancel = True
        End If
    End Sub

    Delegate Sub StringDelegate(ByVal str As String)

    Public Sub addMessage(ByVal message As String)
        If (logBox.InvokeRequired) Then
            Try
                Dim invoke As StringDelegate = AddressOf addMessage
                invoke(message)
            Catch ex As Exception
            End Try
        Else
            If (logBox.Text.Equals("") <> True) Then
                logBox.AppendText(Environment.NewLine)
            End If
            logBox.SelectionColor = Color.Black
            logBox.AppendText(DateTime.Now.ToLongDateString() + " " + DateTime.Now.ToLongTimeString() + " - " + message)
            If (logBox.Text.Length > 2) Then
                logBox.Select(logBox.Text.Length - 1, 1)
            End If
            logBox.ScrollToCaret()

            errorCount += 1
            errorCountLbl.Text = errorCount.ToString()
        End If
        If (Me.Visible <> True) Then
            Me.Show()
        End If
    End Sub

    Private Sub clearBtn_Click(sender As Object, e As EventArgs) Handles clearBtn.Click
        errorCount = 0
        logBox.Clear()
    End Sub

    Private Sub closeBtn_Click(sender As Object, e As EventArgs) Handles closeBtn.Click
        Me.Hide()
    End Sub

End Class