﻿Public Class CustomScroll
    Dim minValue As Double = -1
    Dim maxValue As Double = -1
    Dim logValue As Double = -1
    Dim logBase As Double = 0.00000005 'Controls the slope Of the log Function.  very aggressive here so that the bulk Of the scale Is usable And only the last half jumps quickly


    Public Sub New()
        InitializeComponent()
        Unit = ""
    End Sub

    'Public Custom Event LogScroll As EventHandler
    '    AddHandler(value As EventHandler)
    '        Me.Events.AddHandler("LogScroll", value)
    '    End AddHandler
    '    RemoveHandler(value As EventHandler)
    '        Me.Events.RemoveHandler("LogScroll", value)
    '    End RemoveHandler
    '    RaiseEvent(sender As Object, e As EventArgs)
    '        CType(Me.Events("slider_Scroll"), EventHandler).Invoke(sender, e)
    '    End RaiseEvent
    'End Event

    'Public Custom Event LogMouseUp As EventHandler
    '    AddHandler(value As EventHandler)
    '        Me.Events.AddHandler("LogMouseUp", value)
    '    End AddHandler
    '    RemoveHandler(value As EventHandler)
    '        Me.Events.RemoveHandler("LogMouseUp", value)
    '    End RemoveHandler
    '    RaiseEvent(sender As Object, e As EventArgs)
    '        CType(Me.Events("slider_MouseUp"), EventHandler).Invoke(sender, e)
    '    End RaiseEvent
    'End Event

    Public Event LogScroll(sender As Object, e As EventArgs)
    Public Event LogMouseUp(sender As Object, e As EventArgs)


#Region "Properties"
    Public Property Minimum As Double
        Get
            Return minValue
        End Get
        Set(value As Double)
            slider.Minimum = 0
            minValue = value
        End Set
    End Property

    Public Property Maximum As Double
        Get
            Return maxValue
        End Get
        Set(value As Double)
            slider.Maximum = 100
            maxValue = value
        End Set
    End Property

    Public Property isIntValue As Boolean
    Public Property Unit As String

    Public Property labelTxt As String
        Get
            Return trkName.Text
        End Get
        Set(value As String)
            trkName.Text = value
        End Set
    End Property

    Public Property minTxt As String
        Get
            Return minLbl.Text
        End Get
        Set(value As String)
            minLbl.Text = value
        End Set
    End Property

    Public Property maxTxt As String
        Get
            Return maxLbl.Text
        End Get
        Set(value As String)
            maxLbl.Text = value
        End Set
    End Property

    Public Property trkText As String
        Get
            Return trkTxt.Text
        End Get
        Set(value As String)
            trkTxt.Text = value
        End Set
    End Property

    Public Property Value As Double
        Get
            Return logValue
        End Get
        Set(value As Double)
            logValue = value
            If (minValue <> maxValue) Then
                slider.Value = CType((slider.Maximum * (Math.Pow(logBase, -(logValue - minValue) / (minValue - maxValue)) - 1)) / (logBase - 1), Integer)
                updateValue()
            End If

        End Set
    End Property

    Private Sub updateValue()
        Dim newValue As Double = 0
        If (minValue <> maxValue And logValue >= 0) Then
            newValue = Math.Log(((slider.Value) * (logBase - 1)) / slider.Maximum + 1, logBase) * (maxValue - minValue) + minValue

            If (Not isIntValue) Then
                If maxValue <= 5 Then
                    trkTxt.Text = newValue.ToString("F3") + Unit
                Else
                    trkTxt.Text = newValue.ToString("F2") + Unit
                End If
            Else
                If maxValue <= 5 Then
                    trkTxt.Text = newValue.ToString("F0") + Unit
                Else
                    trkTxt.Text = newValue.ToString("F0") + Unit
                End If
            End If
            logValue = newValue
        End If
    End Sub


#End Region

    Private Sub slider_Scroll(sender As Object, e As EventArgs) Handles slider.Scroll
        updateValue()
        RaiseEvent LogScroll(Me, EventArgs.Empty)
    End Sub

    Private Sub slider_MouseUp(sender As Object, e As MouseEventArgs) Handles slider.MouseUp
        RaiseEvent LogMouseUp(Me, EventArgs.Empty)
    End Sub
End Class
