'A reference to the Phidget22.NET.dll must be added to new projects in VB.Net 
'From the "Project" menu select "Add Reference" 
'From the "Add Reference" window select the "Browse" tab 
'Browse to the directory you installed the Phidgets library to 
'The default is "C:\Program Files\Phidgets" 
'Select "Phidget22.NET.dll" and click "OK" 
'To view objects that have been added, select the "View" menu 
'Select "Object Browser" 
'Then expand the Phidget22.NET.dll item 



Imports Phidget22
Imports Phidget22.Events

Public Class Form1
    Dim WithEvents device As Phidget22.CurrentInput
    Dim open As ExampleUtils.ExampleUtils.CommandLineOpen
    Dim errorBox As ErrorEventBox

    Public Sub New()
        open = New ExampleUtils.ExampleUtils.CommandLineOpen(Me)
        ' This call is required by the Windows Form Designer.
        Phidget22.Phidget.InvokeEventCallbacks = True
        InitializeComponent()
        ' Add any initialization after the InitializeComponent() call.
    End Sub

    Public Sub New(ByVal commandLine As String())
        open = New ExampleUtils.ExampleUtils.CommandLineOpen(Me)
        open.commandLine = commandLine
        Phidget22.Phidget.InvokeEventCallbacks = True
        InitializeComponent()
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        psuModeCombo.DataSource = [Enum].GetValues(GetType(PowerSupply))
        psuModeCombo.SelectedIndex = -1

        errorBox = New ErrorEventBox(Me)

        device = New Phidget22.CurrentInput()


        Dim phidgetParameters As ExampleUtils.commandLineData = open.parseCmdLine()

        Try 'set all the values grabbed from command line.  these values have defaults that are set in ExampleUtils.vb, you can check there to see them
            device.Channel = phidgetParameters.Channel 'selects the channel on the device to open
            device.DeviceSerialNumber = phidgetParameters.SerialNumber 'selects the device or hub to open
            device.HubPort = phidgetParameters.HubPort 'selects th eport on the hub to open
            device.IsHubPortDevice = phidgetParameters.isHubPortDevice 'is the device a port on a vint hub?

            If phidgetParameters.isRemote Then 'are we trying to open a remote device?
                device.IsRemote = True
                Net.EnableServerDiscovery(ServerType.Device) 'turn on network scan
                If phidgetParameters.Password <> vbNullString And phidgetParameters.ServerName <> vbNullString Then
                    Net.SetServerPassword(phidgetParameters.ServerName, phidgetParameters.Password)
                End If
            Else
                device.IsLocal = True
            End If

            device.Open() 'open the device specified by the above parameters
        Catch ex As PhidgetException
            errorBox.addMessage("Error opening the device: " + ex.Message)
        End Try
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Application.DoEvents()
        If device.Attached Then
            device.Close()
        End If
    End Sub

    Private Sub device_Attach(ByVal sender As Object, ByVal e As Phidget22.Events.AttachEventArgs) Handles device.Attach
        'When the Phidget CurrentInput attaches update the form text boxes
        PhidgetInfoBox2.FillPhidgetInfo(CType(sender, Phidget22.CurrentInput))

        dataIntervalTrk.Enabled = False

        Dim attachedDevice As Phidget22.CurrentInput = CType(sender, Phidget22.CurrentInput)

        Try
            'initialize form controls.  change trigger and data interval must be set before the device will function
            changeTriggerTrk.Unit = "A"
            changeTriggerTrk.minTxt = attachedDevice.MinCurrentChangeTrigger.ToString()
            changeTriggerTrk.maxTxt = attachedDevice.MaxCurrentChangeTrigger.ToString()
            changeTriggerTrk.Minimum = attachedDevice.MinCurrentChangeTrigger
            changeTriggerTrk.Maximum = attachedDevice.MaxCurrentChangeTrigger
            changeTriggerTrk.Value = attachedDevice.CurrentChangeTrigger

        Catch ex As PhidgetException
            errorBox.addMessage("Error initializing: " + ex.Message)
        End Try

        If (attachedDevice.DeviceID = DeviceID.PN_DAQ1400) Then
            dataIntervalTrk.Enabled = True
            psuModeCombo.TabStop = True
            psuModeLbl.Visible = True
            psuModeCombo.Visible = True
            dataIntervalTrk.Unit = " ms"
            dataIntervalTrk.minTxt = attachedDevice.MinDataInterval.ToString()
            dataIntervalTrk.maxTxt = attachedDevice.MaxDataInterval.ToString()
            dataIntervalTrk.Minimum = attachedDevice.MinDataInterval
            dataIntervalTrk.Maximum = attachedDevice.MaxDataInterval
            dataIntervalTrk.Value = attachedDevice.DataInterval
        End If

        settingsBox.Visible = True
        outputBox.Visible = True
    End Sub

    Private Sub device_Detach(ByVal sender As Object, ByVal e As Phidget22.Events.DetachEventArgs) Handles device.Detach
        'If the Phidget CurrentInput detaches close the form
        PhidgetInfoBox2.Clear()

        psuModeCombo.Visible = False
        psuModeLbl.Visible = False
        psuModeCombo.TabStop = False
        settingsBox.Visible = False
        outputBox.Visible = False
    End Sub

    Private Sub device_Error(ByVal sender As Object, ByVal e As Phidget22.Events.ErrorEventArgs) Handles device.Error
        errorBox.addMessage(e.Description)
    End Sub

    Private Sub device_CurrentChange(ByVal sender As Object, ByVal e As Phidget22.Events.CurrentInputCurrentChangeEventArgs) Handles device.CurrentChange
        valueTxt.Text = e.Current.ToString("f3") + " A"
    End Sub

    Private Sub dataIntervalTrk_Scroll(sender As Object, e As EventArgs) Handles dataIntervalTrk.LogScroll
        If (MouseButtons = MouseButtons.Left) Then
            Try
                device.DataInterval = CType(dataIntervalTrk.Value, Integer)
            Catch ex As Exception
                errorBox.addMessage("Error setting data interval: " + ex.Message)
            End Try
        End If
    End Sub

    Private Sub dataIntervalTrk_LogMouseUp(sender As Object, e As EventArgs) Handles dataIntervalTrk.LogMouseUp
        Try
            device.DataInterval = CType(dataIntervalTrk.Value, Integer)
        Catch ex As Exception
            errorBox.addMessage("Error setting data interval: " + ex.Message)
        End Try
    End Sub

    Private Sub changeTriggertrk_Scroll(sender As Object, e As EventArgs) Handles changeTriggerTrk.LogScroll
        If (MouseButtons = MouseButtons.Left) Then
            Try
                device.CurrentChangeTrigger = CType(changeTriggerTrk.Value, Integer)
            Catch ex As Exception
                errorBox.addMessage("Error setting data interval: " + ex.Message)
            End Try
        End If
    End Sub

    Private Sub changeTriggerTrk_LogMouseUp(sender As Object, e As EventArgs) Handles changeTriggerTrk.LogMouseUp
        Try
            device.CurrentChangeTrigger = CType(changeTriggerTrk.Value, Integer)
        Catch ex As Exception
            errorBox.addMessage("Error setting data interval: " + ex.Message)
        End Try
    End Sub

    Private Sub psuModeCombo_SelectedIndexChanged(sender As Object, e As EventArgs) Handles psuModeCombo.SelectedIndexChanged
        If (CType(sender, ComboBox).SelectedIndex = -1 Or device Is Nothing) Then
            Return
        End If
        Try
            device.PowerSupply = CType([Enum].Parse(GetType(PowerSupply), psuModeCombo.SelectedValue.ToString()), PowerSupply)
        Catch ex As Exception
            errorBox.addMessage("Error setting power supply mode: " + ex.Message)
        End Try
    End Sub
End Class



