﻿Imports Phidget22

Namespace ExampleUtils
    Public Class PhidgetInfoBox
        Public Sub FillPhidgetInfo(ByVal phidget As Phidget)
            channelTxt.Text = phidget.Channel.ToString()
            versionTxt.Text = phidget.DeviceVersion.ToString()

            If (phidget.DeviceClass = DeviceClass.VINT) Then
                If (phidget.IsHubPortDevice) Then
                    attachedDeviceNameTxt.Text = phidget.Hub.DeviceName
                Else
                    attachedDeviceNameTxt.Text = phidget.DeviceName
                End If
                serialNumberLbl.Text = "Hub Serial Number:"
                serialNumberTxt.Text = phidget.DeviceSerialNumber.ToString()

                hubPortLbl.Visible = True
                hubPortTxt.Visible = True
                hubPortTxt.Text = phidget.HubPort.ToString()
            Else
                attachedDeviceNameTxt.Text = phidget.DeviceName
                serialNumberTxt.Text = phidget.DeviceSerialNumber.ToString()
                hubPortLbl.Visible = False
                hubPortTxt.Visible = False
                hubPortTxt.Text = phidget.HubPort.ToString()
            End If

            If (phidget.isRemote) Then
                remoteLbl.Visible = True
            Else
                remoteLbl.Visible = False
            End If

            Dim par As Control = Me.Parent
            While (TypeOf par IsNot Form)
                par = par.Parent
            End While
            CType(par, Form).Text = phidget.ChannelName

        End Sub

        Public Sub Clear()
            attachedDeviceNameTxt.Text = "Nothing"
            channelTxt.Clear()
            versionTxt.Clear()
            serialNumberTxt.Clear()
            hubPortTxt.Clear()
            serialNumberTxt.Clear()
            line1.Size = New System.Drawing.Size(GroupBox1.Size.Width - 12, 1)

            hubPortLbl.Visible = False
            hubPortTxt.Visible = False
            remoteLbl.Visible = False
        End Sub


    End Class
End Namespace
