//======================================================================
// PhidgetSDK.h - Header file.
//
// This file describes the stream IOCTL commands and necessary 
// structures needed to talk to the phidget driver.
//
// Author: Patrick McNeil
// Based On: WebCamSDK.h by Douglas Boling
//======================================================================

#ifndef _PHIDGET_SDK_H_
#define _PHIDGET_SDK_H_


// This is dereferenced from the CTLCODE macros below because I'm
// not sure this is the best device type for this non-standard driver
#define MYIOCTLDEVTYPE  FILE_DEVICE_STREAMS

//
// Returns a PHIDDEV_ATTRIBUTES structure that contains USB info
//
#define IOCTL_PHIDGET_DEVICE_GET_ATTRIBUTES \
    CTL_CODE(MYIOCTLDEVTYPE, 0x100, METHOD_BUFFERED, FILE_ANY_ACCESS)

// 
// Gets the Tag string as a PHIDDEV_STRING
//
#define IOCTL_PHIDGET_DEVICE_GET_TAGSTRING \
    CTL_CODE(MYIOCTLDEVTYPE, 0x101, METHOD_BUFFERED, FILE_ANY_ACCESS)

// 
// Sets the tag string from a PHIDDEV_STRING
//
#define IOCTL_PHIDGET_DEVICE_SET_TAGSTRING \
    CTL_CODE(MYIOCTLDEVTYPE, 0x102, METHOD_BUFFERED, FILE_ANY_ACCESS)

// 
// Gets the serial number string as a PHIDDEV_STRING
//
#define IOCTL_PHIDGET_DEVICE_GET_SERIALNUMBERSTRING \
    CTL_CODE(MYIOCTLDEVTYPE, 0x103, METHOD_BUFFERED, FILE_ANY_ACCESS)

// Structure holds a String
typedef struct _PHIDDEV_STRING{
	DWORD	size;
	WCHAR	string[255];
} PHIDDEV_STRING, *PPHIDDEV_STRING;

// Structure to hold attributes specific to this device, needed for matching in the userspace library
typedef struct _PHIDDEV_ATTRIBUTES {
    USHORT  VendorID;
    USHORT  ProductID;
    USHORT  VersionNumber;

    USHORT   InterfaceNumber;

    USHORT   InputReportByteLength;
    USHORT   OutputReportByteLength;

} PHIDDEV_ATTRIBUTES, *PPHIDDEV_ATTRIBUTES;


#endif //_PHIDGET_SDK_H_
