//======================================================================
// pddPhidget.h - pdd header
//
// Author: Patrick McNeil
// Based On: pddVClas.h by Douglas Boling
//======================================================================

typedef struct {
		USB_PIPE hPipe;
		UCHAR ucAddr;
		WORD wPacketSize;
		HANDLE hEvent;
} PIPE, *LPPIPE;

typedef struct {
	USB_INTERFACE_DESCRIPTOR ifDesc;
	BOOL fEndpoint;
	USB_ENDPOINT_DESCRIPTOR epDesc;
	LPVOID lpepExtDesc;
} USBCTLIF, *PUSBCTLIF;

//
// PDD driver instance structure  
//
typedef struct {
    DWORD dwSize;

	// Device info
	USBCTLIF usbctlIF;		// Control interface descriptor
} PDDCONTEXT, *PPDDCONTEXT;

int GetPower (PDRVCONTEXT pDrv, BOOL *pbVal);
int SetPower (PDRVCONTEXT pDrv, BOOL fOn);
DWORD GetStringDescriptor(PDRVCONTEXT pDrv, BYTE bIdx, WORD wLangId, PBYTE pbBuffer, WORD  cbBuffer, PDWORD pbTransferred);

// Defs in case the driver is being compiled outside of PB
extern "C" {
DWORD GetCurrentPermissions (void); 
DWORD SetProcPermissions (DWORD);
}
