//======================================================================
// PhidgetConstants.h - constants used for various phidget stuff
//
// Author: Patrick McNeil
//======================================================================

#ifndef _PHIDGET_CONSTANTS
#define _PHIDGET_CONSTANTS

#define MAXDEVICETYPELENGTH 50

#define PHIDDEF_INTERFACEKIT		0x03 
#define PHIDDEF_SERVO				0x04
#define PHIDDEF_HUMIDITYSENSOR		0x05
#define PHIDDEF_RFID				0x07
#define PHIDDEF_WEIGHTSENSOR		0x08
#define PHIDDEF_TEXTLCD				0x0A
#define PHIDDEF_MOTORCONTROL		0x0B
#define PHIDDEF_LED					0x0D
#define PHIDDEF_ENCODER				0x0E
#define PHIDDEF_STEPPER				0x0F
#define PHIDDEF_TEMPERATURESENSOR	0x10
#define PHIDDEF_ACCELEROMETER		0x11
#define PHIDDEF_TEXTLED				0x12
#define PHIDDEF_PHSENSOR		    0x13
#define PHIDDEF_GYROSCOPE			0x14
#define PHIDDEF_ADVANCEDSERVO		0x15
#define PHIDDEF_GPS					0x16

#define PHIDGET_DEVICE_COUNT 38

#define PHIDSPEC_SERVO_4MOTOR			0x00
#define PHIDSPEC_SERVO_1MOTOR			0x01
#define PHIDSPEC_INTERFACEKIT_8_8_8		0x02
#define PHIDSPEC_INTERFACEKIT_0_0_4		0x03
#define PHIDSPEC_INTERFACEKIT_0_16_16	0x04
#define PHIDSPEC_INTERFACEKIT_0_5_7		0x05
#define PHIDSPEC_INTERFACEKIT_0_8_8		0x06
#define PHIDSPEC_ACCELEROMETER			0x07
#define PHIDSPEC_TEXTLCD_2_20			0x08
#define PHIDSPEC_TEXTLCD_2_20_CUSTOM	0x09
#define PHIDSPEC_TEXTLCD_2_20_COMP1		0x0A
#define PHIDSPEC_RFID					0x0B
#define PHIDSPEC_LED					0x0C
#define PHIDSPEC_TEXTLED				0x0D
#define PHIDSPEC_MOTORCONTROL			0x0E
#define PHIDSPEC_TEMPERATURESENSOR		0x0F
#define PHIDSPEC_STEPPER				0x10
#define PHIDSPEC_ENCODER				0x11

#define PHIDSPEC_INTERFACEKIT_4_8_8		0x12
#define PHIDSPEC_SERVO_4MOTOR_OLD		0x13
#define PHIDSPEC_SERVO_1MOTOR_OLD		0x14
#define PHIDSPEC_WEIGHTSENSOR			0x15
#define PHIDSPEC_HUMIDITYSENSOR			0x16
#define PHIDSPEC_PHSENSOR				0x17
#define PHIDSPEC_GYROSCOPE				0x18
#define PHIDSPEC_ADVANCEDSERVO8			0x19
#define PHIDSPEC_RFIDB					0x1A
#define PHIDSPEC_TEXTLED2				0x1B

#define PHIDSPEC_LINEAR_TOUCH			0x1C
#define PHIDSPEC_ROTARY_TOUCH			0x1D
#define PHIDSPEC_ENCODER_4				0x1E

#define PHIDSPEC_GPS					0x1F
#define PHIDSPEC_ENCODER_HS				0x20
#define PHIDSPEC_UNIPOLAR_STEPPER		0x21
#define PHIDSPEC_BIPOLAR_STEPPER		0x22
#define PHIDSPEC_JOYSTICK				0x23
#define PHIDSPEC_TEXTLCD_with_888		0x24
#define PHIDSPEC_888_with_lcd			0x25

//Defines all Phidgets - Type, Vid, Pid, interface number
#define PHID_DEF 0x00
#define PHID_VID 0x01
#define PHID_PID 0x02
#define PHID_IID 0x03 //Interface

const int Phid_Device_Def[PHIDGET_DEVICE_COUNT][4] = {
{PHIDDEF_SERVO,				0x6C2,0x0038,0},
{PHIDDEF_SERVO,				0x6C2,0x0039,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0045,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0040,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0044,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0051,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0053,0},

{PHIDDEF_ACCELEROMETER,		0x6C2,0x0071,0},

{PHIDDEF_TEXTLCD,			0x6C2,0x0051,0},
{PHIDDEF_TEXTLCD,			0x6C2,0x0052,0},
{PHIDDEF_TEXTLCD,			0x6C2,0x0053,0},

{PHIDDEF_RFID,				0x6C2,0x0030,0},

{PHIDDEF_LED,				0x6C2,0x004A,0},
{PHIDDEF_TEXTLED,			0x6C2,0x0049,0},
{PHIDDEF_MOTORCONTROL,		0x6C2,0x0058,0},
{PHIDDEF_TEMPERATURESENSOR,	0x6C2,0x0070,0},
{PHIDDEF_STEPPER,			0x6C2,0x0047,0},
{PHIDDEF_ENCODER,			0x6C2,0x004B,0},

/* Obsoleted */
{PHIDDEF_INTERFACEKIT,		0x925,0x8201,0},
{PHIDDEF_SERVO,				0x925,0x8101,0},
{PHIDDEF_SERVO,				0x925,0x8104,0},
/* Not obsoleted */
{PHIDDEF_WEIGHTSENSOR,		0x6C2,0x0072,0},
{PHIDDEF_HUMIDITYSENSOR,	0x6C2,0x0073,0},

{PHIDDEF_PHSENSOR,			0x6C2,0x0074,0},
{PHIDDEF_GYROSCOPE,			0x6C2,0x0075,0},
{PHIDDEF_ADVANCEDSERVO,		0x6C2,0x003A,0},
{PHIDDEF_RFID,				0x6C2,0x0031,0},
{PHIDDEF_TEXTLED,			0x6C2,0x0048,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0076,0}, //linear touch sensor
{PHIDDEF_INTERFACEKIT,		0x6C2,0x0077,0}, //rotary touch sensor
{PHIDDEF_ENCODER,			0x6C2,0x0078,0}, //4 encoder
{PHIDDEF_GPS,				0x6C2,0x0079,0}, 
{PHIDDEF_ENCODER,			0x6C2,0x0080,0}, //high speed encoder
{PHIDDEF_STEPPER,			0x6C2,0x007A,0}, //unipolar stepper
{PHIDDEF_STEPPER,			0x6C2,0x007B,0},
{PHIDDEF_INTERFACEKIT,		0x6C2,0x007C,0}, //joystick
{PHIDDEF_TEXTLCD,			0x6C2,0x007D,1}, //TextLCD 8/8/8 Composite Device
{PHIDDEF_INTERFACEKIT,		0x6C2,0x007D,0}}; //TextLCD 8/8/8 Composite Device

#endif
