//======================================================================
// Phidget.h - Header file for the driver
//
// Author: Patrick McNeil
// Based On: Webcam.h by Douglas Boling
//======================================================================

#define dim(a)  (sizeof(a)/sizeof(a[0]))
//
// Debug zone support
//
// Used as a prefix string for all debug zone messages.
#define DTAG        TEXT ("Phidget: ")

// Debug zone constants
#define ZONE_ERROR      DEBUGZONE(0)
#define ZONE_WARNING    DEBUGZONE(1)
#define ZONE_FUNC       DEBUGZONE(2)
#define ZONE_INIT       DEBUGZONE(3)
#define ZONE_DRVCALLS   DEBUGZONE(4)
#define ZONE_EXENTRY  (ZONE_FUNC | ZONE_DRVCALLS)
#define ZONE_USBLOAD    DEBUGZONE(5)
#define ZONE_THREAD     DEBUGZONE(6)
#define ZONE_THSTATE	DEBUGZONE(7)
#define ZONE_PACKETS    DEBUGZONE(8)
#define ZONE_TIMING     DEBUGZONE(9)
#define ZONE_READDATA   DEBUGZONE(10)
#define ZONE_PROBE      DEBUGZONE(11)
#define ZONE_STILL      DEBUGZONE(12)
#define ZONE_VIDFRAME   DEBUGZONE(13)
#define ZONE_FEATURE    DEBUGZONE(14)

//
// Declare the driver entry points here. 
//
#ifdef __cplusplus
extern "C" {
#endif //__cplusplus
DWORD PHD_Init (DWORD dwContext);
BOOL  PHD_Deinit (DWORD dwContext);
DWORD PHD_Open (DWORD dwContext, DWORD dwAccess, DWORD dwShare);
BOOL  PHD_Close (DWORD dwOpen);
DWORD PHD_Read (DWORD dwOpen, LPVOID pBuffer, DWORD dwCount);
DWORD PHD_Write (DWORD dwOpen, LPVOID pBuffer, DWORD dwCount);
DWORD PHD_Seek (DWORD dwOpen, long lDelta, WORD wType);
DWORD PHD_IOControl (DWORD dwOpen, DWORD dwCode, 
                     PBYTE pIn, DWORD dwIn,
                     PBYTE pOut, DWORD dwOut, 
                     DWORD *pdwBytesWritten);
void PHD_PowerDown (DWORD dwContext);
void PHD_PowerUp (DWORD dwContext);

#ifdef __cplusplus
} // extern "C"
#endif //__cplusplus


#define DRV_MAJORVER   0
#define DRV_MINORVER   1
//
// USB constants
//

#define DRIVER_NAME   TEXT("Phidget.dll")

#define DEVICE_PREFIX TEXT("PHD")

//TODO: these probably aren't right
#define CLASS_NAME_SZ    TEXT("Phidget_Driver")
#define CLIENT_REGKEY_SZ TEXT("Drivers\\USB\\ClientDrivers\\Phidget_Driver")

//
// USB_DRIVER_SETTINGS
//
#define DRIVER_SETTINGS \
            sizeof(USB_DRIVER_SETTINGS),  \
            USB_NO_INFO,   \
            USB_NO_INFO,   \
            USB_NO_INFO,   \
            USB_NO_INFO,   \
            USB_NO_INFO,   \
            USB_NO_INFO,   \
            USB_DEVICE_CLASS_HUMAN_INTERFACE,   \
            USB_NO_INFO,   \
            USB_NO_INFO

//
// Driver instance structure  
//
typedef struct {
    DWORD dwSize;
	CRITICAL_SECTION csWrite;
	CRITICAL_SECTION csRead;
	CRITICAL_SECTION csDCall;
    INT nNumOpens;
	HANDLE hStreamDevice;
	// USB support
	USB_HANDLE hDevice;
	USB_PIPE hPipe;
	LPCUSB_FUNCS lpUsbFuncs;
	HANDLE hUnload;
	BOOL fUnloadFlag;
	DWORD dwPddContext;
	PHIDDEV_ATTRIBUTES attr;			//Device attributes, initialized on open
} DRVCONTEXT, *PDRVCONTEXT;

PDRVCONTEXT GetConfigData (DWORD dwContext);
DWORD GetString(PDRVCONTEXT pDrv,DWORD dwIdx, LPWSTR pszBuffer, DWORD cchBuffer, PDWORD pcchActual);

//
// MDD functions
//
int mdd_GetAttributes (PDRVCONTEXT lpDrv, PBYTE pOut, DWORD dwOut, PDWORD pdwBytesWritten);
int mdd_SetTagString (PDRVCONTEXT pDrv, PBYTE pIn, DWORD dwIn, PDWORD pdwBytesWritten);
int mdd_GetTagString (PDRVCONTEXT lpDrv, PBYTE pOut, DWORD dwOut, PDWORD pdwBytesWritten);
int mdd_GetSerialNumberString (PDRVCONTEXT lpDrv, PBYTE pOut, DWORD dwOut, PDWORD pdwBytesWritten);

//
// PDD Interface
//
int pdd_DrvInit (PDRVCONTEXT);
int pdd_DrvUninit (PDRVCONTEXT);

int pdd_DrvOpen (PDRVCONTEXT);
int pdd_DrvClose (PDRVCONTEXT);

int pdd_GetAttributes (PDRVCONTEXT pDrv, PPHIDDEV_ATTRIBUTES);
int pdd_SetTagString (PDRVCONTEXT pDrv, PPHIDDEV_STRING pdwVal, PDWORD pBytes);
DWORD Pdd_GetString(PDRVCONTEXT pDrv, DWORD dwIdx, LPWSTR pszBuffer, DWORD cchBuffer, PDWORD pcchActual);
DWORD pdd_Read (PDRVCONTEXT pDrv, LPVOID pBuffer, DWORD dwCount, PDWORD pbTransferred);
DWORD pdd_Write (PDRVCONTEXT pDrv, LPVOID Buffer, DWORD dwCount, PDWORD pbTransferred);
