/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.PhidgetException;
import com.phidgets.event.AttachEvent;
import com.phidgets.event.AttachListener;
import com.phidgets.event.DetachEvent;
import com.phidgets.event.DetachListener;
import com.phidgets.event.ServerConnectEvent;
import com.phidgets.event.ServerConnectListener;
import com.phidgets.event.ServerDisconnectEvent;
import com.phidgets.event.ServerDisconnectListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class Manager {
    private Vector phidgets;
    private long handle = 0L;
    private LinkedList attachListeners = new LinkedList();
    private long nativeAttachHandler = 0L;
    private LinkedList detachListeners = new LinkedList();
    private long nativeDetachHandler = 0L;
    private LinkedList serverConnectListeners = new LinkedList();
    private long nativeServerConnectHandler = 0L;
    private LinkedList serverDisconnectListeners = new LinkedList();
    private long nativeServerDisconnectHandler = 0L;

    public Manager() throws PhidgetException {
        this.handle = this.create();
        this.phidgets = new Vector();
        this.addAttachListener(new AttachListener(){

            public void attached(AttachEvent attachEvent) {
                Manager.this.phidgets.add(attachEvent.getSource());
            }
        });
        this.addDetachListener(new DetachListener(){

            public void detached(DetachEvent detachEvent) {
                Manager.this.phidgets.remove(detachEvent.getSource());
            }
        });
    }

    private final native long create() throws PhidgetException;

    public final native String getServerAddress() throws PhidgetException;

    public final native String getServerID() throws PhidgetException;

    public final native int getServerPort() throws PhidgetException;

    public final native boolean isAttached() throws PhidgetException;

    public final native boolean isAttachedToServer() throws PhidgetException;

    private final native void nativeClose() throws PhidgetException;

    private final native void nativeDelete() throws PhidgetException;

    private final native void nativeOpen() throws PhidgetException;

    private final native void nativeOpenRemote(String var1, String var2) throws PhidgetException;

    private final native void nativeOpenRemoteIP(String var1, int var2, String var3) throws PhidgetException;

    public final void open() throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpen();
    }

    public final void open(String string, int n, String string2) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemoteIP(string, n, string2);
    }

    public final void open(String string, int n) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemoteIP(string, n, "");
    }

    public final void open(String string, String string2) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemote(string, string2);
    }

    public final void open(String string) throws PhidgetException {
        this.enableEvents(true);
        this.nativeOpenRemote(string, "");
    }

    public final void close() throws PhidgetException {
        this.enableEvents(false);
        this.nativeClose();
    }

    private void enableEvents(boolean bl) {
        this.enableManagerAttachEvents(bl && this.attachListeners.size() > 0);
        this.enableManagerDetachEvents(bl && this.detachListeners.size() > 0);
        this.enableServerConnectEvents(bl && this.serverConnectListeners.size() > 0);
        this.enableServerDisconnectEvents(bl && this.serverDisconnectListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addAttachListener(AttachListener attachListener) {
        LinkedList linkedList = this.attachListeners;
        synchronized (linkedList) {
            this.attachListeners.add(attachListener);
            this.enableManagerAttachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeAttachListener(AttachListener attachListener) {
        LinkedList linkedList = this.attachListeners;
        synchronized (linkedList) {
            this.attachListeners.remove(attachListener);
            this.enableManagerAttachEvents(this.attachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttach(AttachEvent attachEvent) {
        LinkedList linkedList = this.attachListeners;
        synchronized (linkedList) {
            Iterator iterator = this.attachListeners.iterator();
            while (iterator.hasNext()) {
                ((AttachListener)iterator.next()).attached(attachEvent);
            }
        }
    }

    private native void enableManagerAttachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDetachListener(DetachListener detachListener) {
        LinkedList linkedList = this.detachListeners;
        synchronized (linkedList) {
            this.detachListeners.add(detachListener);
            this.enableManagerDetachEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDetachListener(DetachListener detachListener) {
        LinkedList linkedList = this.detachListeners;
        synchronized (linkedList) {
            this.detachListeners.remove(detachListener);
            this.enableManagerDetachEvents(this.detachListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDetach(DetachEvent detachEvent) {
        LinkedList linkedList = this.detachListeners;
        synchronized (linkedList) {
            Iterator iterator = this.detachListeners.iterator();
            while (iterator.hasNext()) {
                ((DetachListener)iterator.next()).detached(detachEvent);
            }
        }
    }

    private native void enableManagerDetachEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerConnectListener(ServerConnectListener serverConnectListener) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            this.serverConnectListeners.add(serverConnectListener);
            this.enableServerConnectEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerConnectListener(ServerConnectListener serverConnectListener) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            this.serverConnectListeners.remove(serverConnectListener);
            this.enableServerConnectEvents(this.serverConnectListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerConnect(ServerConnectEvent serverConnectEvent) {
        LinkedList linkedList = this.serverConnectListeners;
        synchronized (linkedList) {
            Iterator iterator = this.serverConnectListeners.iterator();
            while (iterator.hasNext()) {
                ((ServerConnectListener)iterator.next()).serverConnected(serverConnectEvent);
            }
        }
    }

    private native void enableServerConnectEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addServerDisconnectListener(ServerDisconnectListener serverDisconnectListener) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            this.serverDisconnectListeners.add(serverDisconnectListener);
            this.enableServerDisconnectEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeServerDisconnectListener(ServerDisconnectListener serverDisconnectListener) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            this.serverDisconnectListeners.remove(serverDisconnectListener);
            this.enableServerDisconnectEvents(this.serverDisconnectListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireServerDisconnect(ServerDisconnectEvent serverDisconnectEvent) {
        LinkedList linkedList = this.serverDisconnectListeners;
        synchronized (linkedList) {
            Iterator iterator = this.serverDisconnectListeners.iterator();
            while (iterator.hasNext()) {
                ((ServerDisconnectListener)iterator.next()).serverDisconnected(serverDisconnectEvent);
            }
        }
    }

    private native void enableServerDisconnectEvents(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nativeDelete();
        }
        catch (Exception exception) {
        }
        finally {
            this.handle = 0L;
            super.finalize();
        }
    }

    public String toString() {
        return "PhidgetManager: ";
    }

    public Vector getPhidgets() {
        return this.phidgets;
    }

    static {
        try {
            System.loadLibrary("phidget21");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library (libphidget21.so)." + "\nMake sure it is installed, and add it's path to LD_LIBRARY_PATH.");
            }
            if (string.startsWith("Windows")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library." + "\nThe Windows Phidget21 MSI must be installed.");
            }
            if (string.startsWith("Mac")) {
                throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library." + "\nThe Mac Phidget21 DMG must be installed.");
            }
            throw new ExceptionInInitializerError(unsatisfiedLinkError.getMessage() + "\nCould not locate the Phidget C library.");
        }
    }
}

