/*
 * Decompiled with CFR 0.152.
 */
package com.phidgets;

import com.phidgets.Phidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.BridgeDataEvent;
import com.phidgets.event.BridgeDataListener;
import java.util.Iterator;
import java.util.LinkedList;

public final class BridgePhidget
extends Phidget {
    public static final int PHIDGET_BRIDGE_GAIN_1 = 1;
    public static final int PHIDGET_BRIDGE_GAIN_8 = 2;
    public static final int PHIDGET_BRIDGE_GAIN_16 = 3;
    public static final int PHIDGET_BRIDGE_GAIN_32 = 4;
    public static final int PHIDGET_BRIDGE_GAIN_64 = 5;
    public static final int PHIDGET_BRIDGE_GAIN_128 = 6;
    public static final int PHIDGET_BRIDGE_GAIN_UNKNOWN = 7;
    private LinkedList bridgeDataListeners = new LinkedList();
    private long nativeBridgeDataHandler = 0L;

    public BridgePhidget() throws PhidgetException {
        super(BridgePhidget.create());
    }

    private static native long create() throws PhidgetException;

    public native int getInputCount() throws PhidgetException;

    public native double getBridgeValue(int var1) throws PhidgetException;

    public native double getBridgeMin(int var1) throws PhidgetException;

    public native double getBridgeMax(int var1) throws PhidgetException;

    public native boolean getEnabled(int var1) throws PhidgetException;

    public native void setEnabled(int var1, boolean var2) throws PhidgetException;

    public native int getGain(int var1) throws PhidgetException;

    public native void setGain(int var1, int var2) throws PhidgetException;

    public native int getDataRate() throws PhidgetException;

    public native void setDataRate(int var1) throws PhidgetException;

    public native int getDataRateMin() throws PhidgetException;

    public native int getDataRateMax() throws PhidgetException;

    private final void enableDeviceSpecificEvents(boolean bl) {
        this.enableBridgeDataEvents(bl && this.bridgeDataListeners.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBridgeDataListener(BridgeDataListener bridgeDataListener) {
        LinkedList linkedList = this.bridgeDataListeners;
        synchronized (linkedList) {
            this.bridgeDataListeners.add(bridgeDataListener);
            this.enableBridgeDataEvents(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBridgeDataListener(BridgeDataListener bridgeDataListener) {
        LinkedList linkedList = this.bridgeDataListeners;
        synchronized (linkedList) {
            this.bridgeDataListeners.remove(bridgeDataListener);
            this.enableBridgeDataEvents(this.bridgeDataListeners.size() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBridgeData(BridgeDataEvent bridgeDataEvent) {
        LinkedList linkedList = this.bridgeDataListeners;
        synchronized (linkedList) {
            Iterator iterator = this.bridgeDataListeners.iterator();
            while (iterator.hasNext()) {
                ((BridgeDataListener)iterator.next()).bridgeData(bridgeDataEvent);
            }
        }
    }

    private native void enableBridgeDataEvents(boolean var1);
}

